#ifndef NSTD_STD_IO_H_INCLUDED
#define NSTD_STD_IO_H_INCLUDED
#include "../core/def.h"
#ifdef __cplusplus
extern "C"
{
#endif

/// Attempts to flush stdout.
/// Returns: `int errc` - Nonzero on error.
NSTDAPI int nstd_std_io_flush();

/// Writes a single character to stdout.
/// Parameters:
///     `const char ch` - Character to write.
/// Returns: `int errc` - Nonzero on error.
NSTDAPI int nstd_std_io_write_char(const char ch);

/// Writes `str` to stdout.
/// Parameters:
///     `const char *const str` - String to write to stdout.
/// Returns: `int errc` - Nonzero on error.
NSTDAPI int nstd_std_io_write(const char *const str);

/// Writes `str` to stdout with an additional newline.
/// Parameters:
///     `const char *const str` - String to write to stdout.
/// Returns: `int errc` - Nonzero on error.
NSTDAPI int nstd_std_io_write_line(const char *const str);

/// Attempts to flush stderr.
/// Returns: `int errc` - Nonzero on error.
NSTDAPI int nstd_std_io_flush_err();

/// Writes a single character to stderr.
/// Parameters:
///     `const char ch` - Character to write.
/// Returns: `int errc` - Nonzero on error.
NSTDAPI int nstd_std_io_write_char_err(const char ch);

/// Writes `str` to stderr.
/// Parameters:
///     `const char *const str` - String to write to stderr.
/// Returns: `int errc` - Nonzero on error.
NSTDAPI int nstd_std_io_write_err(const char *const str);

/// Writes `str` to stderr with an additional newline.
/// Parameters:
///     `const char *const str` - String to write to stderr.
/// Returns: `int errc` - Nonzero on error.
NSTDAPI int nstd_std_io_write_line_err(const char *const str);

/// Reads a single character from stdin.
/// Parameters:
///     `int *errc` - Error code, returns as nonzero on error.
/// Returns: `char ch` - Character read from stdin.
NSTDAPI char nstd_std_io_read_char(int *errc);

/// Reads from stdin and returns the read string.
/// Parameters:
///     `int *errc` - Error code, returns as nonzero on error.
/// Returns: `char *in` - String read from stdin.
NSTDAPI char *nstd_std_io_read(int *errc);

/// Reads from stdin and returns the read string appending a newline to the end.
/// Parameters:
///     `int *errc` - Error code, returns as nonzero on error.
/// Returns: `char *in` - String read from stdin.
NSTDAPI char *nstd_std_io_read_line(int *errc);

/// Frees memory allocated by `nstd_std_io_read` and `nstd_std_io_readline`.
/// Parameters:
///     `const char **str` - Pointer to the string returned from the read functions.
NSTDAPI void nstd_std_io_free_read(const char **str);

#ifdef __cplusplus
}
#endif
#endif
