#ifndef NSTD_CORE_MEM_H_INCLUDED
#define NSTD_CORE_MEM_H_INCLUDED
#include "def.h"
#ifdef __cplusplus
extern "C"
{
#endif

/// Copies bytes from `other` to `copycat`.
/// Parameters:
///     `NSTDCOREByte *const copycat` - Pointer to memory to be copied to.
///     `const NSTDCOREByte *const other` - Pointer to memory to be copied from.
///     `const NSTDCOREUSize size` - Number of bytes to copy.
NSTDAPI void nstd_core_mem_copy(
    NSTDCOREByte *const copycat,
    const NSTDCOREByte *const other,
    const NSTDCOREUSize size);

/// Moves bytes from `from` to `to`. Zeroes out `from`'s memory.
/// Parameters:
///     `NSTDCOREByte *const from` - Memory to be moved from.
///     `NSTDCOREByte *const to` - Memory to be moved to.
///     `const NSTDCOREUSize size` - Number of bytes to move.
NSTDAPI void nstd_core_mem_move(
    NSTDCOREByte *const from,
    NSTDCOREByte *const to,
    const NSTDCOREUSize size);

/// Moves memory from `*ptr1` to `*ptr2` and vice versa.
/// Parameters:
///     `const void **const ptr1` - Pointer to first pointer's memory location.
///     `const void **const ptr2` - Pointer to second pointer's memory location.
NSTDAPI void nstd_core_mem_switch(const void **const ptr1, const void **const ptr2);

/// Fills a block of memory with `byte`.
/// Parameters:
///     `NSTDCOREByte *const ptr` - Pointer to block of memory.
///     `const NSTDCOREUSize size` - Size of block.
///     `const NSTDCOREByte byte` - Byte to fill with.
NSTDAPI void nstd_core_mem_fill(
    NSTDCOREByte *const ptr,
    const NSTDCOREUSize size,
    const NSTDCOREByte byte);

/// Zeros a memory range pointed to by `ptr`.
/// Parameters:
///     `NSTDCOREByte *const ptr` - Pointer to memory to be zeroed.
///     `NSTDCOREUSize start` - Starting index of memory to be zeroed.
///     `const NSTDCOREUSize end` - Ending index of memory to be zeroed. (Excluded).
NSTDAPI void nstd_core_mem_zero(
    NSTDCOREByte *const ptr,
    NSTDCOREUSize start, const
    NSTDCOREUSize end);

#ifdef __cplusplus
}
#endif
#endif
