#ifndef NSTD_CORE_INT_TYPES_H_INCLUDED
#define NSTD_CORE_INT_TYPES_H_INCLUDED
#include "def.h"
#ifdef __cplusplus
extern "C"
{
#endif

/// Gets the lowest number representable by `NSTDCOREUInt8`.
/// Returns: `NSTDCOREUInt8 min` - The lowest number representable by `NSTDCOREUInt8`.
NSTDAPI NSTDCOREUInt8 nstd_core_int_types_u8_min();
/// Gets the highest number representable by `NSTDCOREUInt8`.
/// Returns: `NSTDCOREUInt8 max` - The highest number representable by `NSTDCOREUInt8`.
NSTDAPI NSTDCOREUInt8 nstd_core_int_types_u8_max();
/// Gets the lowest number representable by `NSTDCOREInt8`.
/// Returns: `NSTDCOREInt8 min` - The lowest number representable by `NSTDCOREInt8`.
NSTDAPI NSTDCOREInt8 nstd_core_int_types_i8_min();
/// Gets the highest number representable by `NSTDCOREInt8`.
/// Returns: `NSTDCOREInt8 max` - The highest number representable by `NSTDCOREInt8`.
NSTDAPI NSTDCOREInt8 nstd_core_int_types_i8_max();

/// Gets the lowest number representable by `NSTDCOREUInt16`.
/// Returns: `NSTDCOREUInt16 min` - The lowest number representable by `NSTDCOREUInt16`.
NSTDAPI NSTDCOREUInt16 nstd_core_int_types_u16_min();
/// Gets the highest number representable by `NSTDCOREUInt16`.
/// Returns: `NSTDCOREUInt16 max` - The highest number representable by `NSTDCOREUInt16`.
NSTDAPI NSTDCOREUInt16 nstd_core_int_types_u16_max();
/// Gets the lowest number representable by `NSTDCOREInt16`.
/// Returns: `NSTDCOREInt16 min` - The lowest number representable by `NSTDCOREInt16`.
NSTDAPI NSTDCOREInt16 nstd_core_int_types_i16_min();
/// Gets the highest number representable by `NSTDCOREInt16`.
/// Returns: `NSTDCOREInt16 max` - The highest number representable by `NSTDCOREInt16`.
NSTDAPI NSTDCOREInt16 nstd_core_int_types_i16_max();

/// Gets the lowest number representable by `NSTDCOREUInt32`.
/// Returns: `NSTDCOREUInt32 min` - The lowest number representable by `NSTDCOREUInt32`.
NSTDAPI NSTDCOREUInt32 nstd_core_int_types_u32_min();
/// Gets the highest number representable by `NSTDCOREUInt32`.
/// Returns: `NSTDCOREUInt32 max` - The highest number representable by `NSTDCOREUInt32`.
NSTDAPI NSTDCOREUInt32 nstd_core_int_types_u32_max();
/// Gets the lowest number representable by `NSTDCOREInt32`.
/// Returns: `NSTDCOREInt32 min` - The lowest number representable by `NSTDCOREInt32`.
NSTDAPI NSTDCOREInt32 nstd_core_int_types_i32_min();
/// Gets the highest number representable by `NSTDCOREInt32`.
/// Returns: `NSTDCOREInt32 max` - The highest number representable by `NSTDCOREInt32`.
NSTDAPI NSTDCOREInt32 nstd_core_int_types_i32_max();

/// Gets the lowest number representable by `NSTDCOREUInt64`.
/// Returns: `NSTDCOREUInt64 min` - The lowest number representable by `NSTDCOREUInt64`.
NSTDAPI NSTDCOREUInt64 nstd_core_int_types_u64_min();
/// Gets the highest number representable by `NSTDCOREUInt64`.
/// Returns: `NSTDCOREUInt64 max` - The highest number representable by `NSTDCOREUInt64`.
NSTDAPI NSTDCOREUInt64 nstd_core_int_types_u64_max();
/// Gets the lowest number representable by `NSTDCOREInt64`.
/// Returns: `NSTDCOREInt64 min` - The lowest number representable by `NSTDCOREInt64`.
NSTDAPI NSTDCOREInt64 nstd_core_int_types_i64_min();
/// Gets the highest number representable by `NSTDCOREInt64`.
/// Returns: `NSTDCOREInt64 max` - The highest number representable by `NSTDCOREInt64`.
NSTDAPI NSTDCOREInt64 nstd_core_int_types_i64_max();

/// Gets the lowest number representable by `NSTDCOREUSize`.
/// Returns: `NSTDCOREUSize min` - The lowest number representable by `NSTDCOREUSize`.
NSTDAPI NSTDCOREUSize nstd_core_int_types_usize_min();
/// Gets the highest number representable by `NSTDCOREUSize`.
/// Returns: `NSTDCOREUSize max` - The highest number representable by `NSTDCOREUSize`.
NSTDAPI NSTDCOREUSize nstd_core_int_types_usize_max();
/// Gets the lowest number representable by `NSTDCOREISize`.
/// Returns: `NSTDCOREISize min` - The lowest number representable by `NSTDCOREISize`.
NSTDAPI NSTDCOREISize nstd_core_int_types_isize_min();
/// Gets the highest number representable by `NSTDCOREISize`.
/// Returns: `NSTDCOREISize max` - The highest number representable by `NSTDCOREISize`.
NSTDAPI NSTDCOREISize nstd_core_int_types_isize_max();

#ifdef __cplusplus
}
#endif
#endif
