#ifndef __nsicallbacks_h
#define __nsicallbacks_h

#ifndef __cplusplus
#	include <stdbool.h>
#endif

/**
	\brief callbacks provide a way to trap NSI calls in a give NSI stream.

	Pass in your callbacks to NSIBegin(). Return true if you want the execution
	to continue in the original context, false otherwise.

	Each call will provide you with the nsicallbacks struct you passed to
	NSIBegin. This allows you to append your variables at the end of an
	extended struct.

	struct nsicallbacks callbacks;
    callbacks.version = 0;
    callbacks.Delete = nullptr;
    callbacks.DeleteAttribute = nullptr;
    callbacks.Connect = nullptr;
    callbacks.Disconnect = nullptr;
    callbacks.SetAttribute = nullptr;
    callbacks.SetAttributeAtTime = nullptr;
    callbacks.Create = Create;
    callbacks.Evaluate = Evaluate;
    callbacks.RenderControl = RenderControl;
    NSI::Context nsi;
    nsi.Begin( NSI::PointerArg("callbacks", &callbacks) );

	bool Create(
		const nsicallbacks *callbacks,
		const char *handle,
		const char *type,
		int nparams,
		const NSIParam_t *params )
	{
    	NSICreate( s_render_context->Handle(), handle, type, nparams, params );
    	return false;
	}
*/
struct nsicallbacks
{
	int version;

	bool (*Create)(
		const struct nsicallbacks *,
		NSIHandle_t handle,
		const char *type,
		int nparams,
		const struct NSIParam_t *params );

	bool (*Delete)(
		const struct nsicallbacks *,
		NSIHandle_t handle,
		int nparams,
		const struct NSIParam_t *params );

	bool (*SetAttribute)(
		const struct nsicallbacks *,
		NSIHandle_t object,
		int nparams,
		const struct NSIParam_t *params );

	bool (*SetAttributeAtTime)(
		const struct nsicallbacks *,
		NSIHandle_t object,
		double time,
		int nparams,
		const struct NSIParam_t *params );

	bool (*DeleteAttribute)(
		const struct nsicallbacks *,
		NSIHandle_t object,
		const char *name );

	bool (*Connect)(
		const struct nsicallbacks *,
		NSIHandle_t from,
		const char *from_attr,
		NSIHandle_t to,
		const char *to_attr,
		int nparams,
		const struct NSIParam_t *params );

	bool (*Disconnect)(
		const struct nsicallbacks *,
		NSIHandle_t from,
		const char *from_attr,
		NSIHandle_t to,
		const char *to_attr );

	bool (*Evaluate)(
		const struct nsicallbacks *,
		int nparams,
		const struct NSIParam_t *params );

	bool (*RenderControl)(
		const struct nsicallbacks *,
		int nparams,
		const struct NSIParam_t *params );
};

#endif
