#![doc = "Peripheral access API for NRF5340_APPLICATION microcontrollers (generated using svd2rust v0.19.0 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.19.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[doc = r"Number available in the NVIC for configuring priority"]
pub const NVIC_PRIO_BITS: u8 = 3;
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, FPU, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn FPU();
    fn CACHE();
    fn SPU();
    fn CLOCK_POWER();
    fn SERIAL0();
    fn SERIAL1();
    fn SPIM4();
    fn SERIAL2();
    fn SERIAL3();
    fn GPIOTE0();
    fn SAADC();
    fn TIMER0();
    fn TIMER1();
    fn TIMER2();
    fn RTC0();
    fn RTC1();
    fn WDT0();
    fn WDT1();
    fn COMP_LPCOMP();
    fn EGU0();
    fn EGU1();
    fn EGU2();
    fn EGU3();
    fn EGU4();
    fn EGU5();
    fn PWM0();
    fn PWM1();
    fn PWM2();
    fn PWM3();
    fn PDM0();
    fn I2S0();
    fn IPC();
    fn QSPI();
    fn NFCT();
    fn GPIOTE1();
    fn QDEC0();
    fn QDEC1();
    fn USBD();
    fn USBREGULATOR();
    fn KMU();
    fn CRYPTOCELL();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 69] = [
    Vector { _handler: FPU },
    Vector { _handler: CACHE },
    Vector { _reserved: 0 },
    Vector { _handler: SPU },
    Vector { _reserved: 0 },
    Vector {
        _handler: CLOCK_POWER,
    },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: SERIAL0 },
    Vector { _handler: SERIAL1 },
    Vector { _handler: SPIM4 },
    Vector { _handler: SERIAL2 },
    Vector { _handler: SERIAL3 },
    Vector { _handler: GPIOTE0 },
    Vector { _handler: SAADC },
    Vector { _handler: TIMER0 },
    Vector { _handler: TIMER1 },
    Vector { _handler: TIMER2 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: RTC0 },
    Vector { _handler: RTC1 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: WDT0 },
    Vector { _handler: WDT1 },
    Vector {
        _handler: COMP_LPCOMP,
    },
    Vector { _handler: EGU0 },
    Vector { _handler: EGU1 },
    Vector { _handler: EGU2 },
    Vector { _handler: EGU3 },
    Vector { _handler: EGU4 },
    Vector { _handler: EGU5 },
    Vector { _handler: PWM0 },
    Vector { _handler: PWM1 },
    Vector { _handler: PWM2 },
    Vector { _handler: PWM3 },
    Vector { _reserved: 0 },
    Vector { _handler: PDM0 },
    Vector { _reserved: 0 },
    Vector { _handler: I2S0 },
    Vector { _reserved: 0 },
    Vector { _handler: IPC },
    Vector { _handler: QSPI },
    Vector { _reserved: 0 },
    Vector { _handler: NFCT },
    Vector { _reserved: 0 },
    Vector { _handler: GPIOTE1 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: QDEC0 },
    Vector { _handler: QDEC1 },
    Vector { _reserved: 0 },
    Vector { _handler: USBD },
    Vector {
        _handler: USBREGULATOR,
    },
    Vector { _reserved: 0 },
    Vector { _handler: KMU },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: CRYPTOCELL,
    },
];
#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "0 - FPU"]
    FPU = 0,
    #[doc = "1 - CACHE"]
    CACHE = 1,
    #[doc = "3 - SPU"]
    SPU = 3,
    #[doc = "5 - CLOCK_POWER"]
    CLOCK_POWER = 5,
    #[doc = "8 - SERIAL0"]
    SERIAL0 = 8,
    #[doc = "9 - SERIAL1"]
    SERIAL1 = 9,
    #[doc = "10 - SPIM4"]
    SPIM4 = 10,
    #[doc = "11 - SERIAL2"]
    SERIAL2 = 11,
    #[doc = "12 - SERIAL3"]
    SERIAL3 = 12,
    #[doc = "13 - GPIOTE0"]
    GPIOTE0 = 13,
    #[doc = "14 - SAADC"]
    SAADC = 14,
    #[doc = "15 - TIMER0"]
    TIMER0 = 15,
    #[doc = "16 - TIMER1"]
    TIMER1 = 16,
    #[doc = "17 - TIMER2"]
    TIMER2 = 17,
    #[doc = "20 - RTC0"]
    RTC0 = 20,
    #[doc = "21 - RTC1"]
    RTC1 = 21,
    #[doc = "24 - WDT0"]
    WDT0 = 24,
    #[doc = "25 - WDT1"]
    WDT1 = 25,
    #[doc = "26 - COMP_LPCOMP"]
    COMP_LPCOMP = 26,
    #[doc = "27 - EGU0"]
    EGU0 = 27,
    #[doc = "28 - EGU1"]
    EGU1 = 28,
    #[doc = "29 - EGU2"]
    EGU2 = 29,
    #[doc = "30 - EGU3"]
    EGU3 = 30,
    #[doc = "31 - EGU4"]
    EGU4 = 31,
    #[doc = "32 - EGU5"]
    EGU5 = 32,
    #[doc = "33 - PWM0"]
    PWM0 = 33,
    #[doc = "34 - PWM1"]
    PWM1 = 34,
    #[doc = "35 - PWM2"]
    PWM2 = 35,
    #[doc = "36 - PWM3"]
    PWM3 = 36,
    #[doc = "38 - PDM0"]
    PDM0 = 38,
    #[doc = "40 - I2S0"]
    I2S0 = 40,
    #[doc = "42 - IPC"]
    IPC = 42,
    #[doc = "43 - QSPI"]
    QSPI = 43,
    #[doc = "45 - NFCT"]
    NFCT = 45,
    #[doc = "47 - GPIOTE1"]
    GPIOTE1 = 47,
    #[doc = "51 - QDEC0"]
    QDEC0 = 51,
    #[doc = "52 - QDEC1"]
    QDEC1 = 52,
    #[doc = "54 - USBD"]
    USBD = 54,
    #[doc = "55 - USBREGULATOR"]
    USBREGULATOR = 55,
    #[doc = "57 - KMU"]
    KMU = 57,
    #[doc = "68 - CRYPTOCELL"]
    CRYPTOCELL = 68,
}
unsafe impl cortex_m::interrupt::InterruptNumber for Interrupt {
    #[inline(always)]
    fn number(self) -> u16 {
        self as u16
    }
}
#[doc = "CACHEDATA"]
pub struct CACHEDATA_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CACHEDATA_S {}
impl CACHEDATA_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cachedata_s::RegisterBlock = 0x00f0_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cachedata_s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CACHEDATA_S {
    type Target = cachedata_s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CACHEDATA_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CACHEDATA_S").finish()
    }
}
#[doc = "CACHEDATA"]
pub mod cachedata_s;
#[doc = "CACHEINFO"]
pub struct CACHEINFO_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CACHEINFO_S {}
impl CACHEINFO_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cacheinfo_s::RegisterBlock = 0x00f0_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cacheinfo_s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CACHEINFO_S {
    type Target = cacheinfo_s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CACHEINFO_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CACHEINFO_S").finish()
    }
}
#[doc = "CACHEINFO"]
pub mod cacheinfo_s;
#[doc = "Factory Information Configuration Registers"]
pub struct FICR_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FICR_S {}
impl FICR_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ficr_s::RegisterBlock = 0x00ff_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ficr_s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FICR_S {
    type Target = ficr_s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FICR_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FICR_S").finish()
    }
}
#[doc = "Factory Information Configuration Registers"]
pub mod ficr_s;
#[doc = "User Information Configuration Registers User information configuration registers"]
pub struct UICR_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UICR_S {}
impl UICR_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uicr_s::RegisterBlock = 0x00ff_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uicr_s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UICR_S {
    type Target = uicr_s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UICR_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UICR_S").finish()
    }
}
#[doc = "User Information Configuration Registers User information configuration registers"]
pub mod uicr_s;
#[doc = "Cross-Trigger Interface control. NOTE: this is not a separate peripheral, but describes CM33 functionality."]
pub struct CTI_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTI_S {}
impl CTI_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cti_s::RegisterBlock = 0xe004_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cti_s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTI_S {
    type Target = cti_s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTI_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTI_S").finish()
    }
}
#[doc = "Cross-Trigger Interface control. NOTE: this is not a separate peripheral, but describes CM33 functionality."]
pub mod cti_s;
#[doc = "Trace and debug control"]
pub struct TAD_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TAD_S {}
impl TAD_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tad_s::RegisterBlock = 0xe008_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tad_s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TAD_S {
    type Target = tad_s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TAD_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TAD_S").finish()
    }
}
#[doc = "Trace and debug control"]
pub mod tad_s;
#[doc = "Domain configuration management 0"]
pub struct DCNF_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DCNF_NS {}
impl DCNF_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dcnf_ns::RegisterBlock = 0x4000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dcnf_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DCNF_NS {
    type Target = dcnf_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DCNF_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DCNF_NS").finish()
    }
}
#[doc = "Domain configuration management 0"]
pub mod dcnf_ns;
#[doc = "FPU control peripheral 0"]
pub struct FPU_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FPU_NS {}
impl FPU_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const fpu_ns::RegisterBlock = 0x4000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const fpu_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FPU_NS {
    type Target = fpu_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FPU_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FPU_NS").finish()
    }
}
#[doc = "FPU control peripheral 0"]
pub mod fpu_ns;
#[doc = "Domain configuration management 1"]
pub struct DCNF_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DCNF_S {}
impl DCNF_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dcnf_ns::RegisterBlock = 0x5000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dcnf_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DCNF_S {
    type Target = dcnf_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DCNF_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DCNF_S").finish()
    }
}
#[doc = "FPU control peripheral 1"]
pub struct FPU_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FPU_S {}
impl FPU_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const fpu_ns::RegisterBlock = 0x5000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const fpu_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FPU_S {
    type Target = fpu_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FPU_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FPU_S").finish()
    }
}
#[doc = "Cache"]
pub struct CACHE_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CACHE_S {}
impl CACHE_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cache_s::RegisterBlock = 0x5000_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cache_s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CACHE_S {
    type Target = cache_s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CACHE_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CACHE_S").finish()
    }
}
#[doc = "Cache"]
pub mod cache_s;
#[doc = "System protection unit"]
pub struct SPU_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPU_S {}
impl SPU_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spu_s::RegisterBlock = 0x5000_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spu_s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPU_S {
    type Target = spu_s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPU_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPU_S").finish()
    }
}
#[doc = "System protection unit"]
pub mod spu_s;
#[doc = "Oscillator control 0"]
pub struct OSCILLATORS_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for OSCILLATORS_NS {}
impl OSCILLATORS_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const oscillators_ns::RegisterBlock = 0x4000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const oscillators_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for OSCILLATORS_NS {
    type Target = oscillators_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for OSCILLATORS_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("OSCILLATORS_NS").finish()
    }
}
#[doc = "Oscillator control 0"]
pub mod oscillators_ns;
#[doc = "Voltage regulators 0"]
pub struct REGULATORS_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for REGULATORS_NS {}
impl REGULATORS_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const regulators_ns::RegisterBlock = 0x4000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const regulators_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for REGULATORS_NS {
    type Target = regulators_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for REGULATORS_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("REGULATORS_NS").finish()
    }
}
#[doc = "Voltage regulators 0"]
pub mod regulators_ns;
#[doc = "Oscillator control 1"]
pub struct OSCILLATORS_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for OSCILLATORS_S {}
impl OSCILLATORS_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const oscillators_ns::RegisterBlock = 0x5000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const oscillators_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for OSCILLATORS_S {
    type Target = oscillators_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for OSCILLATORS_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("OSCILLATORS_S").finish()
    }
}
#[doc = "Voltage regulators 1"]
pub struct REGULATORS_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for REGULATORS_S {}
impl REGULATORS_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const regulators_ns::RegisterBlock = 0x5000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const regulators_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for REGULATORS_S {
    type Target = regulators_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for REGULATORS_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("REGULATORS_S").finish()
    }
}
#[doc = "Clock management 0"]
pub struct CLOCK_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CLOCK_NS {}
impl CLOCK_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const clock_ns::RegisterBlock = 0x4000_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const clock_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CLOCK_NS {
    type Target = clock_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CLOCK_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CLOCK_NS").finish()
    }
}
#[doc = "Clock management 0"]
pub mod clock_ns;
#[doc = "Power control 0"]
pub struct POWER_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for POWER_NS {}
impl POWER_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const power_ns::RegisterBlock = 0x4000_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const power_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for POWER_NS {
    type Target = power_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for POWER_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("POWER_NS").finish()
    }
}
#[doc = "Power control 0"]
pub mod power_ns;
#[doc = "Reset control 0"]
pub struct RESET_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RESET_NS {}
impl RESET_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const reset_ns::RegisterBlock = 0x4000_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const reset_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RESET_NS {
    type Target = reset_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RESET_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RESET_NS").finish()
    }
}
#[doc = "Reset control 0"]
pub mod reset_ns;
#[doc = "Clock management 1"]
pub struct CLOCK_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CLOCK_S {}
impl CLOCK_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const clock_ns::RegisterBlock = 0x5000_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const clock_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CLOCK_S {
    type Target = clock_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CLOCK_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CLOCK_S").finish()
    }
}
#[doc = "Power control 1"]
pub struct POWER_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for POWER_S {}
impl POWER_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const power_ns::RegisterBlock = 0x5000_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const power_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for POWER_S {
    type Target = power_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for POWER_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("POWER_S").finish()
    }
}
#[doc = "Reset control 1"]
pub struct RESET_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RESET_S {}
impl RESET_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const reset_ns::RegisterBlock = 0x5000_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const reset_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RESET_S {
    type Target = reset_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RESET_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RESET_S").finish()
    }
}
#[doc = "Control access port 0"]
pub struct CTRLAP_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTRLAP_NS {}
impl CTRLAP_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctrlap_ns::RegisterBlock = 0x4000_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctrlap_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTRLAP_NS {
    type Target = ctrlap_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTRLAP_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTRLAP_NS").finish()
    }
}
#[doc = "Control access port 0"]
pub mod ctrlap_ns;
#[doc = "Control access port 1"]
pub struct CTRLAP_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTRLAP_S {}
impl CTRLAP_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctrlap_ns::RegisterBlock = 0x5000_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctrlap_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTRLAP_S {
    type Target = ctrlap_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTRLAP_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTRLAP_S").finish()
    }
}
#[doc = "Serial Peripheral Interface Master with EasyDMA 0"]
pub struct SPIM0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM0_NS {}
impl SPIM0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0_ns::RegisterBlock = 0x4000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM0_NS {
    type Target = spim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM0_NS").finish()
    }
}
#[doc = "Serial Peripheral Interface Master with EasyDMA 0"]
pub mod spim0_ns;
#[doc = "SPI Slave 0"]
pub struct SPIS0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIS0_NS {}
impl SPIS0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spis0_ns::RegisterBlock = 0x4000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIS0_NS {
    type Target = spis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIS0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIS0_NS").finish()
    }
}
#[doc = "SPI Slave 0"]
pub mod spis0_ns;
#[doc = "I2C compatible Two-Wire Master Interface with EasyDMA 0"]
pub struct TWIM0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIM0_NS {}
impl TWIM0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twim0_ns::RegisterBlock = 0x4000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIM0_NS {
    type Target = twim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIM0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIM0_NS").finish()
    }
}
#[doc = "I2C compatible Two-Wire Master Interface with EasyDMA 0"]
pub mod twim0_ns;
#[doc = "I2C compatible Two-Wire Slave Interface with EasyDMA 0"]
pub struct TWIS0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIS0_NS {}
impl TWIS0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twis0_ns::RegisterBlock = 0x4000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIS0_NS {
    type Target = twis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIS0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIS0_NS").finish()
    }
}
#[doc = "I2C compatible Two-Wire Slave Interface with EasyDMA 0"]
pub mod twis0_ns;
#[doc = "UART with EasyDMA 0"]
pub struct UARTE0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UARTE0_NS {}
impl UARTE0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uarte0_ns::RegisterBlock = 0x4000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uarte0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UARTE0_NS {
    type Target = uarte0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UARTE0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UARTE0_NS").finish()
    }
}
#[doc = "UART with EasyDMA 0"]
pub mod uarte0_ns;
#[doc = "Serial Peripheral Interface Master with EasyDMA 1"]
pub struct SPIM0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM0_S {}
impl SPIM0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0_ns::RegisterBlock = 0x5000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM0_S {
    type Target = spim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM0_S").finish()
    }
}
#[doc = "SPI Slave 1"]
pub struct SPIS0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIS0_S {}
impl SPIS0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spis0_ns::RegisterBlock = 0x5000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIS0_S {
    type Target = spis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIS0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIS0_S").finish()
    }
}
#[doc = "I2C compatible Two-Wire Master Interface with EasyDMA 1"]
pub struct TWIM0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIM0_S {}
impl TWIM0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twim0_ns::RegisterBlock = 0x5000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIM0_S {
    type Target = twim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIM0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIM0_S").finish()
    }
}
#[doc = "I2C compatible Two-Wire Slave Interface with EasyDMA 1"]
pub struct TWIS0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIS0_S {}
impl TWIS0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twis0_ns::RegisterBlock = 0x5000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIS0_S {
    type Target = twis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIS0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIS0_S").finish()
    }
}
#[doc = "UART with EasyDMA 1"]
pub struct UARTE0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UARTE0_S {}
impl UARTE0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uarte0_ns::RegisterBlock = 0x5000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uarte0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UARTE0_S {
    type Target = uarte0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UARTE0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UARTE0_S").finish()
    }
}
#[doc = "Serial Peripheral Interface Master with EasyDMA 2"]
pub struct SPIM1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM1_NS {}
impl SPIM1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0_ns::RegisterBlock = 0x4000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM1_NS {
    type Target = spim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM1_NS").finish()
    }
}
#[doc = "SPI Slave 2"]
pub struct SPIS1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIS1_NS {}
impl SPIS1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spis0_ns::RegisterBlock = 0x4000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIS1_NS {
    type Target = spis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIS1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIS1_NS").finish()
    }
}
#[doc = "I2C compatible Two-Wire Master Interface with EasyDMA 2"]
pub struct TWIM1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIM1_NS {}
impl TWIM1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twim0_ns::RegisterBlock = 0x4000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIM1_NS {
    type Target = twim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIM1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIM1_NS").finish()
    }
}
#[doc = "I2C compatible Two-Wire Slave Interface with EasyDMA 2"]
pub struct TWIS1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIS1_NS {}
impl TWIS1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twis0_ns::RegisterBlock = 0x4000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIS1_NS {
    type Target = twis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIS1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIS1_NS").finish()
    }
}
#[doc = "UART with EasyDMA 2"]
pub struct UARTE1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UARTE1_NS {}
impl UARTE1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uarte0_ns::RegisterBlock = 0x4000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uarte0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UARTE1_NS {
    type Target = uarte0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UARTE1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UARTE1_NS").finish()
    }
}
#[doc = "Serial Peripheral Interface Master with EasyDMA 3"]
pub struct SPIM1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM1_S {}
impl SPIM1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0_ns::RegisterBlock = 0x5000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM1_S {
    type Target = spim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM1_S").finish()
    }
}
#[doc = "SPI Slave 3"]
pub struct SPIS1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIS1_S {}
impl SPIS1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spis0_ns::RegisterBlock = 0x5000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIS1_S {
    type Target = spis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIS1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIS1_S").finish()
    }
}
#[doc = "I2C compatible Two-Wire Master Interface with EasyDMA 3"]
pub struct TWIM1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIM1_S {}
impl TWIM1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twim0_ns::RegisterBlock = 0x5000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIM1_S {
    type Target = twim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIM1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIM1_S").finish()
    }
}
#[doc = "I2C compatible Two-Wire Slave Interface with EasyDMA 3"]
pub struct TWIS1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIS1_S {}
impl TWIS1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twis0_ns::RegisterBlock = 0x5000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIS1_S {
    type Target = twis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIS1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIS1_S").finish()
    }
}
#[doc = "UART with EasyDMA 3"]
pub struct UARTE1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UARTE1_S {}
impl UARTE1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uarte0_ns::RegisterBlock = 0x5000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uarte0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UARTE1_S {
    type Target = uarte0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UARTE1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UARTE1_S").finish()
    }
}
#[doc = "Serial Peripheral Interface Master with EasyDMA 4"]
pub struct SPIM4_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM4_NS {}
impl SPIM4_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0_ns::RegisterBlock = 0x4000_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM4_NS {
    type Target = spim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM4_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM4_NS").finish()
    }
}
#[doc = "Serial Peripheral Interface Master with EasyDMA 5"]
pub struct SPIM4_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM4_S {}
impl SPIM4_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0_ns::RegisterBlock = 0x5000_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM4_S {
    type Target = spim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM4_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM4_S").finish()
    }
}
#[doc = "Serial Peripheral Interface Master with EasyDMA 6"]
pub struct SPIM2_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM2_NS {}
impl SPIM2_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0_ns::RegisterBlock = 0x4000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM2_NS {
    type Target = spim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM2_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM2_NS").finish()
    }
}
#[doc = "SPI Slave 4"]
pub struct SPIS2_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIS2_NS {}
impl SPIS2_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spis0_ns::RegisterBlock = 0x4000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIS2_NS {
    type Target = spis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIS2_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIS2_NS").finish()
    }
}
#[doc = "I2C compatible Two-Wire Master Interface with EasyDMA 4"]
pub struct TWIM2_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIM2_NS {}
impl TWIM2_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twim0_ns::RegisterBlock = 0x4000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIM2_NS {
    type Target = twim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIM2_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIM2_NS").finish()
    }
}
#[doc = "I2C compatible Two-Wire Slave Interface with EasyDMA 4"]
pub struct TWIS2_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIS2_NS {}
impl TWIS2_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twis0_ns::RegisterBlock = 0x4000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIS2_NS {
    type Target = twis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIS2_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIS2_NS").finish()
    }
}
#[doc = "UART with EasyDMA 4"]
pub struct UARTE2_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UARTE2_NS {}
impl UARTE2_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uarte0_ns::RegisterBlock = 0x4000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uarte0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UARTE2_NS {
    type Target = uarte0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UARTE2_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UARTE2_NS").finish()
    }
}
#[doc = "Serial Peripheral Interface Master with EasyDMA 7"]
pub struct SPIM2_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM2_S {}
impl SPIM2_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0_ns::RegisterBlock = 0x5000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM2_S {
    type Target = spim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM2_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM2_S").finish()
    }
}
#[doc = "SPI Slave 5"]
pub struct SPIS2_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIS2_S {}
impl SPIS2_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spis0_ns::RegisterBlock = 0x5000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIS2_S {
    type Target = spis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIS2_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIS2_S").finish()
    }
}
#[doc = "I2C compatible Two-Wire Master Interface with EasyDMA 5"]
pub struct TWIM2_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIM2_S {}
impl TWIM2_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twim0_ns::RegisterBlock = 0x5000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIM2_S {
    type Target = twim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIM2_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIM2_S").finish()
    }
}
#[doc = "I2C compatible Two-Wire Slave Interface with EasyDMA 5"]
pub struct TWIS2_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIS2_S {}
impl TWIS2_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twis0_ns::RegisterBlock = 0x5000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIS2_S {
    type Target = twis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIS2_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIS2_S").finish()
    }
}
#[doc = "UART with EasyDMA 5"]
pub struct UARTE2_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UARTE2_S {}
impl UARTE2_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uarte0_ns::RegisterBlock = 0x5000_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uarte0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UARTE2_S {
    type Target = uarte0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UARTE2_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UARTE2_S").finish()
    }
}
#[doc = "Serial Peripheral Interface Master with EasyDMA 8"]
pub struct SPIM3_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM3_NS {}
impl SPIM3_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0_ns::RegisterBlock = 0x4000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM3_NS {
    type Target = spim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM3_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM3_NS").finish()
    }
}
#[doc = "SPI Slave 6"]
pub struct SPIS3_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIS3_NS {}
impl SPIS3_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spis0_ns::RegisterBlock = 0x4000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIS3_NS {
    type Target = spis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIS3_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIS3_NS").finish()
    }
}
#[doc = "I2C compatible Two-Wire Master Interface with EasyDMA 6"]
pub struct TWIM3_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIM3_NS {}
impl TWIM3_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twim0_ns::RegisterBlock = 0x4000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIM3_NS {
    type Target = twim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIM3_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIM3_NS").finish()
    }
}
#[doc = "I2C compatible Two-Wire Slave Interface with EasyDMA 6"]
pub struct TWIS3_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIS3_NS {}
impl TWIS3_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twis0_ns::RegisterBlock = 0x4000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIS3_NS {
    type Target = twis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIS3_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIS3_NS").finish()
    }
}
#[doc = "UART with EasyDMA 6"]
pub struct UARTE3_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UARTE3_NS {}
impl UARTE3_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uarte0_ns::RegisterBlock = 0x4000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uarte0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UARTE3_NS {
    type Target = uarte0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UARTE3_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UARTE3_NS").finish()
    }
}
#[doc = "Serial Peripheral Interface Master with EasyDMA 9"]
pub struct SPIM3_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIM3_S {}
impl SPIM3_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spim0_ns::RegisterBlock = 0x5000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIM3_S {
    type Target = spim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIM3_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIM3_S").finish()
    }
}
#[doc = "SPI Slave 7"]
pub struct SPIS3_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIS3_S {}
impl SPIS3_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spis0_ns::RegisterBlock = 0x5000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIS3_S {
    type Target = spis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIS3_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIS3_S").finish()
    }
}
#[doc = "I2C compatible Two-Wire Master Interface with EasyDMA 7"]
pub struct TWIM3_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIM3_S {}
impl TWIM3_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twim0_ns::RegisterBlock = 0x5000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twim0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIM3_S {
    type Target = twim0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIM3_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIM3_S").finish()
    }
}
#[doc = "I2C compatible Two-Wire Slave Interface with EasyDMA 7"]
pub struct TWIS3_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWIS3_S {}
impl TWIS3_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twis0_ns::RegisterBlock = 0x5000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twis0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWIS3_S {
    type Target = twis0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWIS3_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWIS3_S").finish()
    }
}
#[doc = "UART with EasyDMA 7"]
pub struct UARTE3_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UARTE3_S {}
impl UARTE3_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uarte0_ns::RegisterBlock = 0x5000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uarte0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UARTE3_S {
    type Target = uarte0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UARTE3_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UARTE3_S").finish()
    }
}
#[doc = "GPIO Tasks and Events 0"]
pub struct GPIOTE0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIOTE0_S {}
impl GPIOTE0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpiote0_s::RegisterBlock = 0x5000_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpiote0_s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIOTE0_S {
    type Target = gpiote0_s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIOTE0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIOTE0_S").finish()
    }
}
#[doc = "GPIO Tasks and Events 0"]
pub mod gpiote0_s;
#[doc = "Analog to Digital Converter 0"]
pub struct SAADC_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SAADC_NS {}
impl SAADC_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const saadc_ns::RegisterBlock = 0x4000_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const saadc_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SAADC_NS {
    type Target = saadc_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SAADC_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SAADC_NS").finish()
    }
}
#[doc = "Analog to Digital Converter 0"]
pub mod saadc_ns;
#[doc = "Analog to Digital Converter 1"]
pub struct SAADC_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SAADC_S {}
impl SAADC_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const saadc_ns::RegisterBlock = 0x5000_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const saadc_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SAADC_S {
    type Target = saadc_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SAADC_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SAADC_S").finish()
    }
}
#[doc = "Timer/Counter 0"]
pub struct TIMER0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER0_NS {}
impl TIMER0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer0_ns::RegisterBlock = 0x4000_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER0_NS {
    type Target = timer0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER0_NS").finish()
    }
}
#[doc = "Timer/Counter 0"]
pub mod timer0_ns;
#[doc = "Timer/Counter 1"]
pub struct TIMER0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER0_S {}
impl TIMER0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer0_ns::RegisterBlock = 0x5000_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER0_S {
    type Target = timer0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER0_S").finish()
    }
}
#[doc = "Timer/Counter 2"]
pub struct TIMER1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER1_NS {}
impl TIMER1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer0_ns::RegisterBlock = 0x4001_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER1_NS {
    type Target = timer0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER1_NS").finish()
    }
}
#[doc = "Timer/Counter 3"]
pub struct TIMER1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER1_S {}
impl TIMER1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer0_ns::RegisterBlock = 0x5001_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER1_S {
    type Target = timer0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER1_S").finish()
    }
}
#[doc = "Timer/Counter 4"]
pub struct TIMER2_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER2_NS {}
impl TIMER2_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer0_ns::RegisterBlock = 0x4001_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER2_NS {
    type Target = timer0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER2_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER2_NS").finish()
    }
}
#[doc = "Timer/Counter 5"]
pub struct TIMER2_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER2_S {}
impl TIMER2_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer0_ns::RegisterBlock = 0x5001_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER2_S {
    type Target = timer0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER2_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER2_S").finish()
    }
}
#[doc = "Real-time counter 0"]
pub struct RTC0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC0_NS {}
impl RTC0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc0_ns::RegisterBlock = 0x4001_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC0_NS {
    type Target = rtc0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC0_NS").finish()
    }
}
#[doc = "Real-time counter 0"]
pub mod rtc0_ns;
#[doc = "Real-time counter 1"]
pub struct RTC0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC0_S {}
impl RTC0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc0_ns::RegisterBlock = 0x5001_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC0_S {
    type Target = rtc0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC0_S").finish()
    }
}
#[doc = "Real-time counter 2"]
pub struct RTC1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC1_NS {}
impl RTC1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc0_ns::RegisterBlock = 0x4001_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC1_NS {
    type Target = rtc0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC1_NS").finish()
    }
}
#[doc = "Real-time counter 3"]
pub struct RTC1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC1_S {}
impl RTC1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc0_ns::RegisterBlock = 0x5001_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC1_S {
    type Target = rtc0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC1_S").finish()
    }
}
#[doc = "Distributed programmable peripheral interconnect controller 0"]
pub struct DPPIC_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DPPIC_NS {}
impl DPPIC_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dppic_ns::RegisterBlock = 0x4001_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dppic_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DPPIC_NS {
    type Target = dppic_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DPPIC_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DPPIC_NS").finish()
    }
}
#[doc = "Distributed programmable peripheral interconnect controller 0"]
pub mod dppic_ns;
#[doc = "Distributed programmable peripheral interconnect controller 1"]
pub struct DPPIC_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DPPIC_S {}
impl DPPIC_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dppic_ns::RegisterBlock = 0x5001_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dppic_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DPPIC_S {
    type Target = dppic_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DPPIC_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DPPIC_S").finish()
    }
}
#[doc = "Watchdog Timer 0"]
pub struct WDT0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WDT0_NS {}
impl WDT0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const wdt0_ns::RegisterBlock = 0x4001_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const wdt0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WDT0_NS {
    type Target = wdt0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WDT0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WDT0_NS").finish()
    }
}
#[doc = "Watchdog Timer 0"]
pub mod wdt0_ns;
#[doc = "Watchdog Timer 1"]
pub struct WDT0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WDT0_S {}
impl WDT0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const wdt0_ns::RegisterBlock = 0x5001_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const wdt0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WDT0_S {
    type Target = wdt0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WDT0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WDT0_S").finish()
    }
}
#[doc = "Watchdog Timer 2"]
pub struct WDT1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WDT1_NS {}
impl WDT1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const wdt0_ns::RegisterBlock = 0x4001_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const wdt0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WDT1_NS {
    type Target = wdt0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WDT1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WDT1_NS").finish()
    }
}
#[doc = "Watchdog Timer 3"]
pub struct WDT1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WDT1_S {}
impl WDT1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const wdt0_ns::RegisterBlock = 0x5001_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const wdt0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WDT1_S {
    type Target = wdt0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WDT1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WDT1_S").finish()
    }
}
#[doc = "Comparator 0"]
pub struct COMP_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for COMP_NS {}
impl COMP_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const comp_ns::RegisterBlock = 0x4001_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const comp_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for COMP_NS {
    type Target = comp_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for COMP_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("COMP_NS").finish()
    }
}
#[doc = "Comparator 0"]
pub mod comp_ns;
#[doc = "Low-power comparator 0"]
pub struct LPCOMP_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LPCOMP_NS {}
impl LPCOMP_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const lpcomp_ns::RegisterBlock = 0x4001_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const lpcomp_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for LPCOMP_NS {
    type Target = lpcomp_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for LPCOMP_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("LPCOMP_NS").finish()
    }
}
#[doc = "Low-power comparator 0"]
pub mod lpcomp_ns;
#[doc = "Comparator 1"]
pub struct COMP_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for COMP_S {}
impl COMP_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const comp_ns::RegisterBlock = 0x5001_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const comp_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for COMP_S {
    type Target = comp_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for COMP_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("COMP_S").finish()
    }
}
#[doc = "Low-power comparator 1"]
pub struct LPCOMP_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LPCOMP_S {}
impl LPCOMP_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const lpcomp_ns::RegisterBlock = 0x5001_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const lpcomp_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for LPCOMP_S {
    type Target = lpcomp_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for LPCOMP_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("LPCOMP_S").finish()
    }
}
#[doc = "Event generator unit 0"]
pub struct EGU0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU0_NS {}
impl EGU0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x4001_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU0_NS {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU0_NS").finish()
    }
}
#[doc = "Event generator unit 0"]
pub mod egu0_ns;
#[doc = "Event generator unit 1"]
pub struct EGU0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU0_S {}
impl EGU0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x5001_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU0_S {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU0_S").finish()
    }
}
#[doc = "Event generator unit 2"]
pub struct EGU1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU1_NS {}
impl EGU1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x4001_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU1_NS {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU1_NS").finish()
    }
}
#[doc = "Event generator unit 3"]
pub struct EGU1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU1_S {}
impl EGU1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x5001_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU1_S {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU1_S").finish()
    }
}
#[doc = "Event generator unit 4"]
pub struct EGU2_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU2_NS {}
impl EGU2_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x4001_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU2_NS {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU2_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU2_NS").finish()
    }
}
#[doc = "Event generator unit 5"]
pub struct EGU2_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU2_S {}
impl EGU2_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x5001_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU2_S {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU2_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU2_S").finish()
    }
}
#[doc = "Event generator unit 6"]
pub struct EGU3_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU3_NS {}
impl EGU3_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x4001_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU3_NS {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU3_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU3_NS").finish()
    }
}
#[doc = "Event generator unit 7"]
pub struct EGU3_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU3_S {}
impl EGU3_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x5001_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU3_S {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU3_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU3_S").finish()
    }
}
#[doc = "Event generator unit 8"]
pub struct EGU4_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU4_NS {}
impl EGU4_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x4001_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU4_NS {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU4_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU4_NS").finish()
    }
}
#[doc = "Event generator unit 9"]
pub struct EGU4_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU4_S {}
impl EGU4_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x5001_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU4_S {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU4_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU4_S").finish()
    }
}
#[doc = "Event generator unit 10"]
pub struct EGU5_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU5_NS {}
impl EGU5_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x4002_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU5_NS {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU5_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU5_NS").finish()
    }
}
#[doc = "Event generator unit 11"]
pub struct EGU5_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EGU5_S {}
impl EGU5_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const egu0_ns::RegisterBlock = 0x5002_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const egu0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EGU5_S {
    type Target = egu0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EGU5_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EGU5_S").finish()
    }
}
#[doc = "Pulse width modulation unit 0"]
pub struct PWM0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM0_NS {}
impl PWM0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm0_ns::RegisterBlock = 0x4002_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM0_NS {
    type Target = pwm0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM0_NS").finish()
    }
}
#[doc = "Pulse width modulation unit 0"]
pub mod pwm0_ns;
#[doc = "Pulse width modulation unit 1"]
pub struct PWM0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM0_S {}
impl PWM0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm0_ns::RegisterBlock = 0x5002_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM0_S {
    type Target = pwm0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM0_S").finish()
    }
}
#[doc = "Pulse width modulation unit 2"]
pub struct PWM1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM1_NS {}
impl PWM1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm0_ns::RegisterBlock = 0x4002_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM1_NS {
    type Target = pwm0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM1_NS").finish()
    }
}
#[doc = "Pulse width modulation unit 3"]
pub struct PWM1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM1_S {}
impl PWM1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm0_ns::RegisterBlock = 0x5002_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM1_S {
    type Target = pwm0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM1_S").finish()
    }
}
#[doc = "Pulse width modulation unit 4"]
pub struct PWM2_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM2_NS {}
impl PWM2_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm0_ns::RegisterBlock = 0x4002_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM2_NS {
    type Target = pwm0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM2_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM2_NS").finish()
    }
}
#[doc = "Pulse width modulation unit 5"]
pub struct PWM2_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM2_S {}
impl PWM2_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm0_ns::RegisterBlock = 0x5002_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM2_S {
    type Target = pwm0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM2_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM2_S").finish()
    }
}
#[doc = "Pulse width modulation unit 6"]
pub struct PWM3_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM3_NS {}
impl PWM3_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm0_ns::RegisterBlock = 0x4002_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM3_NS {
    type Target = pwm0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM3_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM3_NS").finish()
    }
}
#[doc = "Pulse width modulation unit 7"]
pub struct PWM3_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM3_S {}
impl PWM3_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm0_ns::RegisterBlock = 0x5002_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM3_S {
    type Target = pwm0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM3_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM3_S").finish()
    }
}
#[doc = "Pulse Density Modulation (Digital Microphone) Interface 0"]
pub struct PDM0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PDM0_NS {}
impl PDM0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pdm0_ns::RegisterBlock = 0x4002_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pdm0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PDM0_NS {
    type Target = pdm0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PDM0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PDM0_NS").finish()
    }
}
#[doc = "Pulse Density Modulation (Digital Microphone) Interface 0"]
pub mod pdm0_ns;
#[doc = "Pulse Density Modulation (Digital Microphone) Interface 1"]
pub struct PDM0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PDM0_S {}
impl PDM0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pdm0_ns::RegisterBlock = 0x5002_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pdm0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PDM0_S {
    type Target = pdm0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PDM0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PDM0_S").finish()
    }
}
#[doc = "Inter-IC Sound 0"]
pub struct I2S0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S0_NS {}
impl I2S0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0_ns::RegisterBlock = 0x4002_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S0_NS {
    type Target = i2s0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S0_NS").finish()
    }
}
#[doc = "Inter-IC Sound 0"]
pub mod i2s0_ns;
#[doc = "Inter-IC Sound 1"]
pub struct I2S0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S0_S {}
impl I2S0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0_ns::RegisterBlock = 0x5002_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S0_S {
    type Target = i2s0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S0_S").finish()
    }
}
#[doc = "Interprocessor communication 0"]
pub struct IPC_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IPC_NS {}
impl IPC_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ipc_ns::RegisterBlock = 0x4002_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ipc_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IPC_NS {
    type Target = ipc_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IPC_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IPC_NS").finish()
    }
}
#[doc = "Interprocessor communication 0"]
pub mod ipc_ns;
#[doc = "Interprocessor communication 1"]
pub struct IPC_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IPC_S {}
impl IPC_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ipc_ns::RegisterBlock = 0x5002_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ipc_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IPC_S {
    type Target = ipc_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IPC_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IPC_S").finish()
    }
}
#[doc = "External flash interface 0"]
pub struct QSPI_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for QSPI_NS {}
impl QSPI_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const qspi_ns::RegisterBlock = 0x4002_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const qspi_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for QSPI_NS {
    type Target = qspi_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for QSPI_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("QSPI_NS").finish()
    }
}
#[doc = "External flash interface 0"]
pub mod qspi_ns;
#[doc = "External flash interface 1"]
pub struct QSPI_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for QSPI_S {}
impl QSPI_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const qspi_ns::RegisterBlock = 0x5002_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const qspi_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for QSPI_S {
    type Target = qspi_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for QSPI_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("QSPI_S").finish()
    }
}
#[doc = "NFC-A compatible radio 0"]
pub struct NFCT_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for NFCT_NS {}
impl NFCT_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const nfct_ns::RegisterBlock = 0x4002_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const nfct_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for NFCT_NS {
    type Target = nfct_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for NFCT_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("NFCT_NS").finish()
    }
}
#[doc = "NFC-A compatible radio 0"]
pub mod nfct_ns;
#[doc = "NFC-A compatible radio 1"]
pub struct NFCT_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for NFCT_S {}
impl NFCT_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const nfct_ns::RegisterBlock = 0x5002_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const nfct_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for NFCT_S {
    type Target = nfct_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for NFCT_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("NFCT_S").finish()
    }
}
#[doc = "GPIO Tasks and Events 1"]
pub struct GPIOTE1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIOTE1_NS {}
impl GPIOTE1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpiote0_s::RegisterBlock = 0x4002_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpiote0_s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIOTE1_NS {
    type Target = gpiote0_s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIOTE1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIOTE1_NS").finish()
    }
}
#[doc = "MUTEX 0"]
pub struct MUTEX_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MUTEX_NS {}
impl MUTEX_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mutex_ns::RegisterBlock = 0x4003_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mutex_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MUTEX_NS {
    type Target = mutex_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MUTEX_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MUTEX_NS").finish()
    }
}
#[doc = "MUTEX 0"]
pub mod mutex_ns;
#[doc = "MUTEX 1"]
pub struct MUTEX_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MUTEX_S {}
impl MUTEX_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mutex_ns::RegisterBlock = 0x5003_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mutex_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MUTEX_S {
    type Target = mutex_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MUTEX_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MUTEX_S").finish()
    }
}
#[doc = "Quadrature Decoder 0"]
pub struct QDEC0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for QDEC0_NS {}
impl QDEC0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const qdec0_ns::RegisterBlock = 0x4003_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const qdec0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for QDEC0_NS {
    type Target = qdec0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for QDEC0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("QDEC0_NS").finish()
    }
}
#[doc = "Quadrature Decoder 0"]
pub mod qdec0_ns;
#[doc = "Quadrature Decoder 1"]
pub struct QDEC0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for QDEC0_S {}
impl QDEC0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const qdec0_ns::RegisterBlock = 0x5003_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const qdec0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for QDEC0_S {
    type Target = qdec0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for QDEC0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("QDEC0_S").finish()
    }
}
#[doc = "Quadrature Decoder 2"]
pub struct QDEC1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for QDEC1_NS {}
impl QDEC1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const qdec0_ns::RegisterBlock = 0x4003_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const qdec0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for QDEC1_NS {
    type Target = qdec0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for QDEC1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("QDEC1_NS").finish()
    }
}
#[doc = "Quadrature Decoder 3"]
pub struct QDEC1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for QDEC1_S {}
impl QDEC1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const qdec0_ns::RegisterBlock = 0x5003_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const qdec0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for QDEC1_S {
    type Target = qdec0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for QDEC1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("QDEC1_S").finish()
    }
}
#[doc = "Universal serial bus device 0"]
pub struct USBD_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBD_NS {}
impl USBD_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbd_ns::RegisterBlock = 0x4003_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbd_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBD_NS {
    type Target = usbd_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBD_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBD_NS").finish()
    }
}
#[doc = "Universal serial bus device 0"]
pub mod usbd_ns;
#[doc = "Universal serial bus device 1"]
pub struct USBD_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBD_S {}
impl USBD_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbd_ns::RegisterBlock = 0x5003_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbd_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBD_S {
    type Target = usbd_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBD_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBD_S").finish()
    }
}
#[doc = "USB Regulator 0"]
pub struct USBREGULATOR_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBREGULATOR_NS {}
impl USBREGULATOR_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbregulator_ns::RegisterBlock = 0x4003_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbregulator_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBREGULATOR_NS {
    type Target = usbregulator_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBREGULATOR_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBREGULATOR_NS").finish()
    }
}
#[doc = "USB Regulator 0"]
pub mod usbregulator_ns;
#[doc = "USB Regulator 1"]
pub struct USBREGULATOR_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBREGULATOR_S {}
impl USBREGULATOR_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbregulator_ns::RegisterBlock = 0x5003_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbregulator_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBREGULATOR_S {
    type Target = usbregulator_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBREGULATOR_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBREGULATOR_S").finish()
    }
}
#[doc = "Key management unit 0"]
pub struct KMU_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for KMU_NS {}
impl KMU_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const kmu_ns::RegisterBlock = 0x4003_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const kmu_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for KMU_NS {
    type Target = kmu_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for KMU_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("KMU_NS").finish()
    }
}
#[doc = "Key management unit 0"]
pub mod kmu_ns;
#[doc = "Non-volatile memory controller 0"]
pub struct NVMC_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for NVMC_NS {}
impl NVMC_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const nvmc_ns::RegisterBlock = 0x4003_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const nvmc_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for NVMC_NS {
    type Target = nvmc_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for NVMC_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("NVMC_NS").finish()
    }
}
#[doc = "Non-volatile memory controller 0"]
pub mod nvmc_ns;
#[doc = "Key management unit 1"]
pub struct KMU_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for KMU_S {}
impl KMU_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const kmu_ns::RegisterBlock = 0x5003_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const kmu_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for KMU_S {
    type Target = kmu_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for KMU_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("KMU_S").finish()
    }
}
#[doc = "Non-volatile memory controller 1"]
pub struct NVMC_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for NVMC_S {}
impl NVMC_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const nvmc_ns::RegisterBlock = 0x5003_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const nvmc_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for NVMC_S {
    type Target = nvmc_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for NVMC_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("NVMC_S").finish()
    }
}
#[doc = "GPIO Port 0"]
pub struct P0_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for P0_NS {}
impl P0_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const p0_ns::RegisterBlock = 0x4084_2500 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const p0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for P0_NS {
    type Target = p0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for P0_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("P0_NS").finish()
    }
}
#[doc = "GPIO Port 0"]
pub mod p0_ns;
#[doc = "GPIO Port 1"]
pub struct P1_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for P1_NS {}
impl P1_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const p0_ns::RegisterBlock = 0x4084_2800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const p0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for P1_NS {
    type Target = p0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for P1_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("P1_NS").finish()
    }
}
#[doc = "GPIO Port 2"]
pub struct P0_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for P0_S {}
impl P0_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const p0_ns::RegisterBlock = 0x5084_2500 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const p0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for P0_S {
    type Target = p0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for P0_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("P0_S").finish()
    }
}
#[doc = "GPIO Port 3"]
pub struct P1_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for P1_S {}
impl P1_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const p0_ns::RegisterBlock = 0x5084_2800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const p0_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for P1_S {
    type Target = p0_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for P1_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("P1_S").finish()
    }
}
#[doc = "ARM TrustZone CryptoCell register interface"]
pub struct CRYPTOCELL_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRYPTOCELL_S {}
impl CRYPTOCELL_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cryptocell_s::RegisterBlock = 0x5084_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cryptocell_s::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CRYPTOCELL_S {
    type Target = cryptocell_s::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CRYPTOCELL_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CRYPTOCELL_S").finish()
    }
}
#[doc = "ARM TrustZone CryptoCell register interface"]
pub mod cryptocell_s;
#[doc = "Volatile Memory controller 0"]
pub struct VMC_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for VMC_NS {}
impl VMC_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const vmc_ns::RegisterBlock = 0x4008_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const vmc_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for VMC_NS {
    type Target = vmc_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for VMC_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("VMC_NS").finish()
    }
}
#[doc = "Volatile Memory controller 0"]
pub mod vmc_ns;
#[doc = "Volatile Memory controller 1"]
pub struct VMC_S {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for VMC_S {}
impl VMC_S {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const vmc_ns::RegisterBlock = 0x5008_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const vmc_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for VMC_S {
    type Target = vmc_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for VMC_S {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("VMC_S").finish()
    }
}
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "CACHEDATA_S"]
    pub CACHEDATA_S: CACHEDATA_S,
    #[doc = "CACHEINFO_S"]
    pub CACHEINFO_S: CACHEINFO_S,
    #[doc = "FICR_S"]
    pub FICR_S: FICR_S,
    #[doc = "UICR_S"]
    pub UICR_S: UICR_S,
    #[doc = "CTI_S"]
    pub CTI_S: CTI_S,
    #[doc = "TAD_S"]
    pub TAD_S: TAD_S,
    #[doc = "DCNF_NS"]
    pub DCNF_NS: DCNF_NS,
    #[doc = "FPU_NS"]
    pub FPU_NS: FPU_NS,
    #[doc = "DCNF_S"]
    pub DCNF_S: DCNF_S,
    #[doc = "FPU_S"]
    pub FPU_S: FPU_S,
    #[doc = "CACHE_S"]
    pub CACHE_S: CACHE_S,
    #[doc = "SPU_S"]
    pub SPU_S: SPU_S,
    #[doc = "OSCILLATORS_NS"]
    pub OSCILLATORS_NS: OSCILLATORS_NS,
    #[doc = "REGULATORS_NS"]
    pub REGULATORS_NS: REGULATORS_NS,
    #[doc = "OSCILLATORS_S"]
    pub OSCILLATORS_S: OSCILLATORS_S,
    #[doc = "REGULATORS_S"]
    pub REGULATORS_S: REGULATORS_S,
    #[doc = "CLOCK_NS"]
    pub CLOCK_NS: CLOCK_NS,
    #[doc = "POWER_NS"]
    pub POWER_NS: POWER_NS,
    #[doc = "RESET_NS"]
    pub RESET_NS: RESET_NS,
    #[doc = "CLOCK_S"]
    pub CLOCK_S: CLOCK_S,
    #[doc = "POWER_S"]
    pub POWER_S: POWER_S,
    #[doc = "RESET_S"]
    pub RESET_S: RESET_S,
    #[doc = "CTRLAP_NS"]
    pub CTRLAP_NS: CTRLAP_NS,
    #[doc = "CTRLAP_S"]
    pub CTRLAP_S: CTRLAP_S,
    #[doc = "SPIM0_NS"]
    pub SPIM0_NS: SPIM0_NS,
    #[doc = "SPIS0_NS"]
    pub SPIS0_NS: SPIS0_NS,
    #[doc = "TWIM0_NS"]
    pub TWIM0_NS: TWIM0_NS,
    #[doc = "TWIS0_NS"]
    pub TWIS0_NS: TWIS0_NS,
    #[doc = "UARTE0_NS"]
    pub UARTE0_NS: UARTE0_NS,
    #[doc = "SPIM0_S"]
    pub SPIM0_S: SPIM0_S,
    #[doc = "SPIS0_S"]
    pub SPIS0_S: SPIS0_S,
    #[doc = "TWIM0_S"]
    pub TWIM0_S: TWIM0_S,
    #[doc = "TWIS0_S"]
    pub TWIS0_S: TWIS0_S,
    #[doc = "UARTE0_S"]
    pub UARTE0_S: UARTE0_S,
    #[doc = "SPIM1_NS"]
    pub SPIM1_NS: SPIM1_NS,
    #[doc = "SPIS1_NS"]
    pub SPIS1_NS: SPIS1_NS,
    #[doc = "TWIM1_NS"]
    pub TWIM1_NS: TWIM1_NS,
    #[doc = "TWIS1_NS"]
    pub TWIS1_NS: TWIS1_NS,
    #[doc = "UARTE1_NS"]
    pub UARTE1_NS: UARTE1_NS,
    #[doc = "SPIM1_S"]
    pub SPIM1_S: SPIM1_S,
    #[doc = "SPIS1_S"]
    pub SPIS1_S: SPIS1_S,
    #[doc = "TWIM1_S"]
    pub TWIM1_S: TWIM1_S,
    #[doc = "TWIS1_S"]
    pub TWIS1_S: TWIS1_S,
    #[doc = "UARTE1_S"]
    pub UARTE1_S: UARTE1_S,
    #[doc = "SPIM4_NS"]
    pub SPIM4_NS: SPIM4_NS,
    #[doc = "SPIM4_S"]
    pub SPIM4_S: SPIM4_S,
    #[doc = "SPIM2_NS"]
    pub SPIM2_NS: SPIM2_NS,
    #[doc = "SPIS2_NS"]
    pub SPIS2_NS: SPIS2_NS,
    #[doc = "TWIM2_NS"]
    pub TWIM2_NS: TWIM2_NS,
    #[doc = "TWIS2_NS"]
    pub TWIS2_NS: TWIS2_NS,
    #[doc = "UARTE2_NS"]
    pub UARTE2_NS: UARTE2_NS,
    #[doc = "SPIM2_S"]
    pub SPIM2_S: SPIM2_S,
    #[doc = "SPIS2_S"]
    pub SPIS2_S: SPIS2_S,
    #[doc = "TWIM2_S"]
    pub TWIM2_S: TWIM2_S,
    #[doc = "TWIS2_S"]
    pub TWIS2_S: TWIS2_S,
    #[doc = "UARTE2_S"]
    pub UARTE2_S: UARTE2_S,
    #[doc = "SPIM3_NS"]
    pub SPIM3_NS: SPIM3_NS,
    #[doc = "SPIS3_NS"]
    pub SPIS3_NS: SPIS3_NS,
    #[doc = "TWIM3_NS"]
    pub TWIM3_NS: TWIM3_NS,
    #[doc = "TWIS3_NS"]
    pub TWIS3_NS: TWIS3_NS,
    #[doc = "UARTE3_NS"]
    pub UARTE3_NS: UARTE3_NS,
    #[doc = "SPIM3_S"]
    pub SPIM3_S: SPIM3_S,
    #[doc = "SPIS3_S"]
    pub SPIS3_S: SPIS3_S,
    #[doc = "TWIM3_S"]
    pub TWIM3_S: TWIM3_S,
    #[doc = "TWIS3_S"]
    pub TWIS3_S: TWIS3_S,
    #[doc = "UARTE3_S"]
    pub UARTE3_S: UARTE3_S,
    #[doc = "GPIOTE0_S"]
    pub GPIOTE0_S: GPIOTE0_S,
    #[doc = "SAADC_NS"]
    pub SAADC_NS: SAADC_NS,
    #[doc = "SAADC_S"]
    pub SAADC_S: SAADC_S,
    #[doc = "TIMER0_NS"]
    pub TIMER0_NS: TIMER0_NS,
    #[doc = "TIMER0_S"]
    pub TIMER0_S: TIMER0_S,
    #[doc = "TIMER1_NS"]
    pub TIMER1_NS: TIMER1_NS,
    #[doc = "TIMER1_S"]
    pub TIMER1_S: TIMER1_S,
    #[doc = "TIMER2_NS"]
    pub TIMER2_NS: TIMER2_NS,
    #[doc = "TIMER2_S"]
    pub TIMER2_S: TIMER2_S,
    #[doc = "RTC0_NS"]
    pub RTC0_NS: RTC0_NS,
    #[doc = "RTC0_S"]
    pub RTC0_S: RTC0_S,
    #[doc = "RTC1_NS"]
    pub RTC1_NS: RTC1_NS,
    #[doc = "RTC1_S"]
    pub RTC1_S: RTC1_S,
    #[doc = "DPPIC_NS"]
    pub DPPIC_NS: DPPIC_NS,
    #[doc = "DPPIC_S"]
    pub DPPIC_S: DPPIC_S,
    #[doc = "WDT0_NS"]
    pub WDT0_NS: WDT0_NS,
    #[doc = "WDT0_S"]
    pub WDT0_S: WDT0_S,
    #[doc = "WDT1_NS"]
    pub WDT1_NS: WDT1_NS,
    #[doc = "WDT1_S"]
    pub WDT1_S: WDT1_S,
    #[doc = "COMP_NS"]
    pub COMP_NS: COMP_NS,
    #[doc = "LPCOMP_NS"]
    pub LPCOMP_NS: LPCOMP_NS,
    #[doc = "COMP_S"]
    pub COMP_S: COMP_S,
    #[doc = "LPCOMP_S"]
    pub LPCOMP_S: LPCOMP_S,
    #[doc = "EGU0_NS"]
    pub EGU0_NS: EGU0_NS,
    #[doc = "EGU0_S"]
    pub EGU0_S: EGU0_S,
    #[doc = "EGU1_NS"]
    pub EGU1_NS: EGU1_NS,
    #[doc = "EGU1_S"]
    pub EGU1_S: EGU1_S,
    #[doc = "EGU2_NS"]
    pub EGU2_NS: EGU2_NS,
    #[doc = "EGU2_S"]
    pub EGU2_S: EGU2_S,
    #[doc = "EGU3_NS"]
    pub EGU3_NS: EGU3_NS,
    #[doc = "EGU3_S"]
    pub EGU3_S: EGU3_S,
    #[doc = "EGU4_NS"]
    pub EGU4_NS: EGU4_NS,
    #[doc = "EGU4_S"]
    pub EGU4_S: EGU4_S,
    #[doc = "EGU5_NS"]
    pub EGU5_NS: EGU5_NS,
    #[doc = "EGU5_S"]
    pub EGU5_S: EGU5_S,
    #[doc = "PWM0_NS"]
    pub PWM0_NS: PWM0_NS,
    #[doc = "PWM0_S"]
    pub PWM0_S: PWM0_S,
    #[doc = "PWM1_NS"]
    pub PWM1_NS: PWM1_NS,
    #[doc = "PWM1_S"]
    pub PWM1_S: PWM1_S,
    #[doc = "PWM2_NS"]
    pub PWM2_NS: PWM2_NS,
    #[doc = "PWM2_S"]
    pub PWM2_S: PWM2_S,
    #[doc = "PWM3_NS"]
    pub PWM3_NS: PWM3_NS,
    #[doc = "PWM3_S"]
    pub PWM3_S: PWM3_S,
    #[doc = "PDM0_NS"]
    pub PDM0_NS: PDM0_NS,
    #[doc = "PDM0_S"]
    pub PDM0_S: PDM0_S,
    #[doc = "I2S0_NS"]
    pub I2S0_NS: I2S0_NS,
    #[doc = "I2S0_S"]
    pub I2S0_S: I2S0_S,
    #[doc = "IPC_NS"]
    pub IPC_NS: IPC_NS,
    #[doc = "IPC_S"]
    pub IPC_S: IPC_S,
    #[doc = "QSPI_NS"]
    pub QSPI_NS: QSPI_NS,
    #[doc = "QSPI_S"]
    pub QSPI_S: QSPI_S,
    #[doc = "NFCT_NS"]
    pub NFCT_NS: NFCT_NS,
    #[doc = "NFCT_S"]
    pub NFCT_S: NFCT_S,
    #[doc = "GPIOTE1_NS"]
    pub GPIOTE1_NS: GPIOTE1_NS,
    #[doc = "MUTEX_NS"]
    pub MUTEX_NS: MUTEX_NS,
    #[doc = "MUTEX_S"]
    pub MUTEX_S: MUTEX_S,
    #[doc = "QDEC0_NS"]
    pub QDEC0_NS: QDEC0_NS,
    #[doc = "QDEC0_S"]
    pub QDEC0_S: QDEC0_S,
    #[doc = "QDEC1_NS"]
    pub QDEC1_NS: QDEC1_NS,
    #[doc = "QDEC1_S"]
    pub QDEC1_S: QDEC1_S,
    #[doc = "USBD_NS"]
    pub USBD_NS: USBD_NS,
    #[doc = "USBD_S"]
    pub USBD_S: USBD_S,
    #[doc = "USBREGULATOR_NS"]
    pub USBREGULATOR_NS: USBREGULATOR_NS,
    #[doc = "USBREGULATOR_S"]
    pub USBREGULATOR_S: USBREGULATOR_S,
    #[doc = "KMU_NS"]
    pub KMU_NS: KMU_NS,
    #[doc = "NVMC_NS"]
    pub NVMC_NS: NVMC_NS,
    #[doc = "KMU_S"]
    pub KMU_S: KMU_S,
    #[doc = "NVMC_S"]
    pub NVMC_S: NVMC_S,
    #[doc = "P0_NS"]
    pub P0_NS: P0_NS,
    #[doc = "P1_NS"]
    pub P1_NS: P1_NS,
    #[doc = "P0_S"]
    pub P0_S: P0_S,
    #[doc = "P1_S"]
    pub P1_S: P1_S,
    #[doc = "CRYPTOCELL_S"]
    pub CRYPTOCELL_S: CRYPTOCELL_S,
    #[doc = "VMC_NS"]
    pub VMC_NS: VMC_NS,
    #[doc = "VMC_S"]
    pub VMC_S: VMC_S,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        cortex_m::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            CACHEDATA_S: CACHEDATA_S {
                _marker: PhantomData,
            },
            CACHEINFO_S: CACHEINFO_S {
                _marker: PhantomData,
            },
            FICR_S: FICR_S {
                _marker: PhantomData,
            },
            UICR_S: UICR_S {
                _marker: PhantomData,
            },
            CTI_S: CTI_S {
                _marker: PhantomData,
            },
            TAD_S: TAD_S {
                _marker: PhantomData,
            },
            DCNF_NS: DCNF_NS {
                _marker: PhantomData,
            },
            FPU_NS: FPU_NS {
                _marker: PhantomData,
            },
            DCNF_S: DCNF_S {
                _marker: PhantomData,
            },
            FPU_S: FPU_S {
                _marker: PhantomData,
            },
            CACHE_S: CACHE_S {
                _marker: PhantomData,
            },
            SPU_S: SPU_S {
                _marker: PhantomData,
            },
            OSCILLATORS_NS: OSCILLATORS_NS {
                _marker: PhantomData,
            },
            REGULATORS_NS: REGULATORS_NS {
                _marker: PhantomData,
            },
            OSCILLATORS_S: OSCILLATORS_S {
                _marker: PhantomData,
            },
            REGULATORS_S: REGULATORS_S {
                _marker: PhantomData,
            },
            CLOCK_NS: CLOCK_NS {
                _marker: PhantomData,
            },
            POWER_NS: POWER_NS {
                _marker: PhantomData,
            },
            RESET_NS: RESET_NS {
                _marker: PhantomData,
            },
            CLOCK_S: CLOCK_S {
                _marker: PhantomData,
            },
            POWER_S: POWER_S {
                _marker: PhantomData,
            },
            RESET_S: RESET_S {
                _marker: PhantomData,
            },
            CTRLAP_NS: CTRLAP_NS {
                _marker: PhantomData,
            },
            CTRLAP_S: CTRLAP_S {
                _marker: PhantomData,
            },
            SPIM0_NS: SPIM0_NS {
                _marker: PhantomData,
            },
            SPIS0_NS: SPIS0_NS {
                _marker: PhantomData,
            },
            TWIM0_NS: TWIM0_NS {
                _marker: PhantomData,
            },
            TWIS0_NS: TWIS0_NS {
                _marker: PhantomData,
            },
            UARTE0_NS: UARTE0_NS {
                _marker: PhantomData,
            },
            SPIM0_S: SPIM0_S {
                _marker: PhantomData,
            },
            SPIS0_S: SPIS0_S {
                _marker: PhantomData,
            },
            TWIM0_S: TWIM0_S {
                _marker: PhantomData,
            },
            TWIS0_S: TWIS0_S {
                _marker: PhantomData,
            },
            UARTE0_S: UARTE0_S {
                _marker: PhantomData,
            },
            SPIM1_NS: SPIM1_NS {
                _marker: PhantomData,
            },
            SPIS1_NS: SPIS1_NS {
                _marker: PhantomData,
            },
            TWIM1_NS: TWIM1_NS {
                _marker: PhantomData,
            },
            TWIS1_NS: TWIS1_NS {
                _marker: PhantomData,
            },
            UARTE1_NS: UARTE1_NS {
                _marker: PhantomData,
            },
            SPIM1_S: SPIM1_S {
                _marker: PhantomData,
            },
            SPIS1_S: SPIS1_S {
                _marker: PhantomData,
            },
            TWIM1_S: TWIM1_S {
                _marker: PhantomData,
            },
            TWIS1_S: TWIS1_S {
                _marker: PhantomData,
            },
            UARTE1_S: UARTE1_S {
                _marker: PhantomData,
            },
            SPIM4_NS: SPIM4_NS {
                _marker: PhantomData,
            },
            SPIM4_S: SPIM4_S {
                _marker: PhantomData,
            },
            SPIM2_NS: SPIM2_NS {
                _marker: PhantomData,
            },
            SPIS2_NS: SPIS2_NS {
                _marker: PhantomData,
            },
            TWIM2_NS: TWIM2_NS {
                _marker: PhantomData,
            },
            TWIS2_NS: TWIS2_NS {
                _marker: PhantomData,
            },
            UARTE2_NS: UARTE2_NS {
                _marker: PhantomData,
            },
            SPIM2_S: SPIM2_S {
                _marker: PhantomData,
            },
            SPIS2_S: SPIS2_S {
                _marker: PhantomData,
            },
            TWIM2_S: TWIM2_S {
                _marker: PhantomData,
            },
            TWIS2_S: TWIS2_S {
                _marker: PhantomData,
            },
            UARTE2_S: UARTE2_S {
                _marker: PhantomData,
            },
            SPIM3_NS: SPIM3_NS {
                _marker: PhantomData,
            },
            SPIS3_NS: SPIS3_NS {
                _marker: PhantomData,
            },
            TWIM3_NS: TWIM3_NS {
                _marker: PhantomData,
            },
            TWIS3_NS: TWIS3_NS {
                _marker: PhantomData,
            },
            UARTE3_NS: UARTE3_NS {
                _marker: PhantomData,
            },
            SPIM3_S: SPIM3_S {
                _marker: PhantomData,
            },
            SPIS3_S: SPIS3_S {
                _marker: PhantomData,
            },
            TWIM3_S: TWIM3_S {
                _marker: PhantomData,
            },
            TWIS3_S: TWIS3_S {
                _marker: PhantomData,
            },
            UARTE3_S: UARTE3_S {
                _marker: PhantomData,
            },
            GPIOTE0_S: GPIOTE0_S {
                _marker: PhantomData,
            },
            SAADC_NS: SAADC_NS {
                _marker: PhantomData,
            },
            SAADC_S: SAADC_S {
                _marker: PhantomData,
            },
            TIMER0_NS: TIMER0_NS {
                _marker: PhantomData,
            },
            TIMER0_S: TIMER0_S {
                _marker: PhantomData,
            },
            TIMER1_NS: TIMER1_NS {
                _marker: PhantomData,
            },
            TIMER1_S: TIMER1_S {
                _marker: PhantomData,
            },
            TIMER2_NS: TIMER2_NS {
                _marker: PhantomData,
            },
            TIMER2_S: TIMER2_S {
                _marker: PhantomData,
            },
            RTC0_NS: RTC0_NS {
                _marker: PhantomData,
            },
            RTC0_S: RTC0_S {
                _marker: PhantomData,
            },
            RTC1_NS: RTC1_NS {
                _marker: PhantomData,
            },
            RTC1_S: RTC1_S {
                _marker: PhantomData,
            },
            DPPIC_NS: DPPIC_NS {
                _marker: PhantomData,
            },
            DPPIC_S: DPPIC_S {
                _marker: PhantomData,
            },
            WDT0_NS: WDT0_NS {
                _marker: PhantomData,
            },
            WDT0_S: WDT0_S {
                _marker: PhantomData,
            },
            WDT1_NS: WDT1_NS {
                _marker: PhantomData,
            },
            WDT1_S: WDT1_S {
                _marker: PhantomData,
            },
            COMP_NS: COMP_NS {
                _marker: PhantomData,
            },
            LPCOMP_NS: LPCOMP_NS {
                _marker: PhantomData,
            },
            COMP_S: COMP_S {
                _marker: PhantomData,
            },
            LPCOMP_S: LPCOMP_S {
                _marker: PhantomData,
            },
            EGU0_NS: EGU0_NS {
                _marker: PhantomData,
            },
            EGU0_S: EGU0_S {
                _marker: PhantomData,
            },
            EGU1_NS: EGU1_NS {
                _marker: PhantomData,
            },
            EGU1_S: EGU1_S {
                _marker: PhantomData,
            },
            EGU2_NS: EGU2_NS {
                _marker: PhantomData,
            },
            EGU2_S: EGU2_S {
                _marker: PhantomData,
            },
            EGU3_NS: EGU3_NS {
                _marker: PhantomData,
            },
            EGU3_S: EGU3_S {
                _marker: PhantomData,
            },
            EGU4_NS: EGU4_NS {
                _marker: PhantomData,
            },
            EGU4_S: EGU4_S {
                _marker: PhantomData,
            },
            EGU5_NS: EGU5_NS {
                _marker: PhantomData,
            },
            EGU5_S: EGU5_S {
                _marker: PhantomData,
            },
            PWM0_NS: PWM0_NS {
                _marker: PhantomData,
            },
            PWM0_S: PWM0_S {
                _marker: PhantomData,
            },
            PWM1_NS: PWM1_NS {
                _marker: PhantomData,
            },
            PWM1_S: PWM1_S {
                _marker: PhantomData,
            },
            PWM2_NS: PWM2_NS {
                _marker: PhantomData,
            },
            PWM2_S: PWM2_S {
                _marker: PhantomData,
            },
            PWM3_NS: PWM3_NS {
                _marker: PhantomData,
            },
            PWM3_S: PWM3_S {
                _marker: PhantomData,
            },
            PDM0_NS: PDM0_NS {
                _marker: PhantomData,
            },
            PDM0_S: PDM0_S {
                _marker: PhantomData,
            },
            I2S0_NS: I2S0_NS {
                _marker: PhantomData,
            },
            I2S0_S: I2S0_S {
                _marker: PhantomData,
            },
            IPC_NS: IPC_NS {
                _marker: PhantomData,
            },
            IPC_S: IPC_S {
                _marker: PhantomData,
            },
            QSPI_NS: QSPI_NS {
                _marker: PhantomData,
            },
            QSPI_S: QSPI_S {
                _marker: PhantomData,
            },
            NFCT_NS: NFCT_NS {
                _marker: PhantomData,
            },
            NFCT_S: NFCT_S {
                _marker: PhantomData,
            },
            GPIOTE1_NS: GPIOTE1_NS {
                _marker: PhantomData,
            },
            MUTEX_NS: MUTEX_NS {
                _marker: PhantomData,
            },
            MUTEX_S: MUTEX_S {
                _marker: PhantomData,
            },
            QDEC0_NS: QDEC0_NS {
                _marker: PhantomData,
            },
            QDEC0_S: QDEC0_S {
                _marker: PhantomData,
            },
            QDEC1_NS: QDEC1_NS {
                _marker: PhantomData,
            },
            QDEC1_S: QDEC1_S {
                _marker: PhantomData,
            },
            USBD_NS: USBD_NS {
                _marker: PhantomData,
            },
            USBD_S: USBD_S {
                _marker: PhantomData,
            },
            USBREGULATOR_NS: USBREGULATOR_NS {
                _marker: PhantomData,
            },
            USBREGULATOR_S: USBREGULATOR_S {
                _marker: PhantomData,
            },
            KMU_NS: KMU_NS {
                _marker: PhantomData,
            },
            NVMC_NS: NVMC_NS {
                _marker: PhantomData,
            },
            KMU_S: KMU_S {
                _marker: PhantomData,
            },
            NVMC_S: NVMC_S {
                _marker: PhantomData,
            },
            P0_NS: P0_NS {
                _marker: PhantomData,
            },
            P1_NS: P1_NS {
                _marker: PhantomData,
            },
            P0_S: P0_S {
                _marker: PhantomData,
            },
            P1_S: P1_S {
                _marker: PhantomData,
            },
            CRYPTOCELL_S: CRYPTOCELL_S {
                _marker: PhantomData,
            },
            VMC_NS: VMC_NS {
                _marker: PhantomData,
            },
            VMC_S: VMC_S {
                _marker: PhantomData,
            },
        }
    }
}
