#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00..0x40 - Description collection: Trigger n for triggering the corresponding TRIGGERED\\[n\\]
event"]
    pub tasks_trigger: [crate::Reg<tasks_trigger::TASKS_TRIGGER_SPEC>; 16],
    _reserved1: [u8; 0xc0],
    #[doc = "0x100..0x140 - Description collection: Event number n generated by triggering the corresponding TRIGGER\\[n\\]
task"]
    pub events_triggered: [crate::Reg<events_triggered::EVENTS_TRIGGERED_SPEC>; 16],
    _reserved2: [u8; 0x01c0],
    #[doc = "0x300 - Enable or disable interrupt"]
    pub inten: crate::Reg<inten::INTEN_SPEC>,
    #[doc = "0x304 - Enable interrupt"]
    pub intenset: crate::Reg<intenset::INTENSET_SPEC>,
    #[doc = "0x308 - Disable interrupt"]
    pub intenclr: crate::Reg<intenclr::INTENCLR_SPEC>,
}
#[doc = "TASKS_TRIGGER register accessor: an alias for `Reg<TASKS_TRIGGER_SPEC>`"]
pub type TASKS_TRIGGER = crate::Reg<tasks_trigger::TASKS_TRIGGER_SPEC>;
#[doc = "Description collection: Trigger n for triggering the corresponding TRIGGERED\\[n\\]
event"]
pub mod tasks_trigger;
#[doc = "EVENTS_TRIGGERED register accessor: an alias for `Reg<EVENTS_TRIGGERED_SPEC>`"]
pub type EVENTS_TRIGGERED = crate::Reg<events_triggered::EVENTS_TRIGGERED_SPEC>;
#[doc = "Description collection: Event number n generated by triggering the corresponding TRIGGER\\[n\\]
task"]
pub mod events_triggered;
#[doc = "INTEN register accessor: an alias for `Reg<INTEN_SPEC>`"]
pub type INTEN = crate::Reg<inten::INTEN_SPEC>;
#[doc = "Enable or disable interrupt"]
pub mod inten;
#[doc = "INTENSET register accessor: an alias for `Reg<INTENSET_SPEC>`"]
pub type INTENSET = crate::Reg<intenset::INTENSET_SPEC>;
#[doc = "Enable interrupt"]
pub mod intenset;
#[doc = "INTENCLR register accessor: an alias for `Reg<INTENCLR_SPEC>`"]
pub type INTENCLR = crate::Reg<intenclr::INTENCLR_SPEC>;
#[doc = "Disable interrupt"]
pub mod intenclr;
