#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - Start the quadrature decoder."]
    pub tasks_start: TASKS_START,
    #[doc = "0x04 - Stop the quadrature decoder."]
    pub tasks_stop: TASKS_STOP,
    #[doc = "0x08 - Transfers the content from ACC registers to ACCREAD registers, and clears the ACC registers."]
    pub tasks_readclracc: TASKS_READCLRACC,
    _reserved3: [u8; 244usize],
    #[doc = "0x100 - A new sample is written to the sample register."]
    pub events_samplerdy: EVENTS_SAMPLERDY,
    #[doc = "0x104 - REPORTPER number of samples accumulated in ACC register, and ACC register different than zero."]
    pub events_reportrdy: EVENTS_REPORTRDY,
    #[doc = "0x108 - ACC or ACCDBL register overflow."]
    pub events_accof: EVENTS_ACCOF,
    _reserved6: [u8; 244usize],
    #[doc = "0x200 - Shortcuts for the QDEC."]
    pub shorts: SHORTS,
    _reserved7: [u8; 256usize],
    #[doc = "0x304 - Interrupt enable set register."]
    pub intenset: INTENSET,
    #[doc = "0x308 - Interrupt enable clear register."]
    pub intenclr: INTENCLR,
    _reserved9: [u8; 500usize],
    #[doc = "0x500 - Enable the QDEC."]
    pub enable: ENABLE,
    #[doc = "0x504 - LED output pin polarity."]
    pub ledpol: LEDPOL,
    #[doc = "0x508 - Sample period."]
    pub sampleper: SAMPLEPER,
    #[doc = "0x50c - Motion sample value."]
    pub sample: SAMPLE,
    #[doc = "0x510 - Number of samples to generate an EVENT_REPORTRDY."]
    pub reportper: REPORTPER,
    #[doc = "0x514 - Accumulated valid transitions register."]
    pub acc: ACC,
    #[doc = "0x518 - Snapshot of ACC register. Value generated by the TASKS_READCLEACC task."]
    pub accread: ACCREAD,
    #[doc = "0x51c - Pin select for LED output."]
    pub pselled: PSELLED,
    #[doc = "0x520 - Pin select for phase A input."]
    pub psela: PSELA,
    #[doc = "0x524 - Pin select for phase B input."]
    pub pselb: PSELB,
    #[doc = "0x528 - Enable debouncer input filters."]
    pub dbfen: DBFEN,
    _reserved20: [u8; 20usize],
    #[doc = "0x540 - Time LED is switched ON before the sample."]
    pub ledpre: LEDPRE,
    #[doc = "0x544 - Accumulated double (error) transitions register."]
    pub accdbl: ACCDBL,
    #[doc = "0x548 - Snapshot of ACCDBL register. Value generated by the TASKS_READCLEACC task."]
    pub accdblread: ACCDBLREAD,
    _reserved23: [u8; 2736usize],
    #[doc = "0xffc - Peripheral power control."]
    pub power: POWER,
}
#[doc = "Start the quadrature decoder.\n\nThis register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tasks_start](tasks_start) module"]
pub type TASKS_START = crate::Reg<u32, _TASKS_START>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _TASKS_START;
#[doc = "`write(|w| ..)` method takes [tasks_start::W](tasks_start::W) writer structure"]
impl crate::Writable for TASKS_START {}
#[doc = "Start the quadrature decoder."]
pub mod tasks_start;
#[doc = "Stop the quadrature decoder.\n\nThis register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tasks_stop](tasks_stop) module"]
pub type TASKS_STOP = crate::Reg<u32, _TASKS_STOP>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _TASKS_STOP;
#[doc = "`write(|w| ..)` method takes [tasks_stop::W](tasks_stop::W) writer structure"]
impl crate::Writable for TASKS_STOP {}
#[doc = "Stop the quadrature decoder."]
pub mod tasks_stop;
#[doc = "Transfers the content from ACC registers to ACCREAD registers, and clears the ACC registers.\n\nThis register you can [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tasks_readclracc](tasks_readclracc) module"]
pub type TASKS_READCLRACC = crate::Reg<u32, _TASKS_READCLRACC>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _TASKS_READCLRACC;
#[doc = "`write(|w| ..)` method takes [tasks_readclracc::W](tasks_readclracc::W) writer structure"]
impl crate::Writable for TASKS_READCLRACC {}
#[doc = "Transfers the content from ACC registers to ACCREAD registers, and clears the ACC registers."]
pub mod tasks_readclracc;
#[doc = "A new sample is written to the sample register.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [events_samplerdy](events_samplerdy) module"]
pub type EVENTS_SAMPLERDY = crate::Reg<u32, _EVENTS_SAMPLERDY>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _EVENTS_SAMPLERDY;
#[doc = "`read()` method returns [events_samplerdy::R](events_samplerdy::R) reader structure"]
impl crate::Readable for EVENTS_SAMPLERDY {}
#[doc = "`write(|w| ..)` method takes [events_samplerdy::W](events_samplerdy::W) writer structure"]
impl crate::Writable for EVENTS_SAMPLERDY {}
#[doc = "A new sample is written to the sample register."]
pub mod events_samplerdy;
#[doc = "REPORTPER number of samples accumulated in ACC register, and ACC register different than zero.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [events_reportrdy](events_reportrdy) module"]
pub type EVENTS_REPORTRDY = crate::Reg<u32, _EVENTS_REPORTRDY>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _EVENTS_REPORTRDY;
#[doc = "`read()` method returns [events_reportrdy::R](events_reportrdy::R) reader structure"]
impl crate::Readable for EVENTS_REPORTRDY {}
#[doc = "`write(|w| ..)` method takes [events_reportrdy::W](events_reportrdy::W) writer structure"]
impl crate::Writable for EVENTS_REPORTRDY {}
#[doc = "REPORTPER number of samples accumulated in ACC register, and ACC register different than zero."]
pub mod events_reportrdy;
#[doc = "ACC or ACCDBL register overflow.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [events_accof](events_accof) module"]
pub type EVENTS_ACCOF = crate::Reg<u32, _EVENTS_ACCOF>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _EVENTS_ACCOF;
#[doc = "`read()` method returns [events_accof::R](events_accof::R) reader structure"]
impl crate::Readable for EVENTS_ACCOF {}
#[doc = "`write(|w| ..)` method takes [events_accof::W](events_accof::W) writer structure"]
impl crate::Writable for EVENTS_ACCOF {}
#[doc = "ACC or ACCDBL register overflow."]
pub mod events_accof;
#[doc = "Shortcuts for the QDEC.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [shorts](shorts) module"]
pub type SHORTS = crate::Reg<u32, _SHORTS>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _SHORTS;
#[doc = "`read()` method returns [shorts::R](shorts::R) reader structure"]
impl crate::Readable for SHORTS {}
#[doc = "`write(|w| ..)` method takes [shorts::W](shorts::W) writer structure"]
impl crate::Writable for SHORTS {}
#[doc = "Shortcuts for the QDEC."]
pub mod shorts;
#[doc = "Interrupt enable set register.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [intenset](intenset) module"]
pub type INTENSET = crate::Reg<u32, _INTENSET>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _INTENSET;
#[doc = "`read()` method returns [intenset::R](intenset::R) reader structure"]
impl crate::Readable for INTENSET {}
#[doc = "`write(|w| ..)` method takes [intenset::W](intenset::W) writer structure"]
impl crate::Writable for INTENSET {}
#[doc = "Interrupt enable set register."]
pub mod intenset;
#[doc = "Interrupt enable clear register.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [intenclr](intenclr) module"]
pub type INTENCLR = crate::Reg<u32, _INTENCLR>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _INTENCLR;
#[doc = "`read()` method returns [intenclr::R](intenclr::R) reader structure"]
impl crate::Readable for INTENCLR {}
#[doc = "`write(|w| ..)` method takes [intenclr::W](intenclr::W) writer structure"]
impl crate::Writable for INTENCLR {}
#[doc = "Interrupt enable clear register."]
pub mod intenclr;
#[doc = "Enable the QDEC.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [enable](enable) module"]
pub type ENABLE = crate::Reg<u32, _ENABLE>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _ENABLE;
#[doc = "`read()` method returns [enable::R](enable::R) reader structure"]
impl crate::Readable for ENABLE {}
#[doc = "`write(|w| ..)` method takes [enable::W](enable::W) writer structure"]
impl crate::Writable for ENABLE {}
#[doc = "Enable the QDEC."]
pub mod enable;
#[doc = "LED output pin polarity.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ledpol](ledpol) module"]
pub type LEDPOL = crate::Reg<u32, _LEDPOL>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _LEDPOL;
#[doc = "`read()` method returns [ledpol::R](ledpol::R) reader structure"]
impl crate::Readable for LEDPOL {}
#[doc = "`write(|w| ..)` method takes [ledpol::W](ledpol::W) writer structure"]
impl crate::Writable for LEDPOL {}
#[doc = "LED output pin polarity."]
pub mod ledpol;
#[doc = "Sample period.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [sampleper](sampleper) module"]
pub type SAMPLEPER = crate::Reg<u32, _SAMPLEPER>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _SAMPLEPER;
#[doc = "`read()` method returns [sampleper::R](sampleper::R) reader structure"]
impl crate::Readable for SAMPLEPER {}
#[doc = "`write(|w| ..)` method takes [sampleper::W](sampleper::W) writer structure"]
impl crate::Writable for SAMPLEPER {}
#[doc = "Sample period."]
pub mod sampleper;
#[doc = "Motion sample value.\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [sample](sample) module"]
pub type SAMPLE = crate::Reg<u32, _SAMPLE>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _SAMPLE;
#[doc = "`read()` method returns [sample::R](sample::R) reader structure"]
impl crate::Readable for SAMPLE {}
#[doc = "Motion sample value."]
pub mod sample;
#[doc = "Number of samples to generate an EVENT_REPORTRDY.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [reportper](reportper) module"]
pub type REPORTPER = crate::Reg<u32, _REPORTPER>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _REPORTPER;
#[doc = "`read()` method returns [reportper::R](reportper::R) reader structure"]
impl crate::Readable for REPORTPER {}
#[doc = "`write(|w| ..)` method takes [reportper::W](reportper::W) writer structure"]
impl crate::Writable for REPORTPER {}
#[doc = "Number of samples to generate an EVENT_REPORTRDY."]
pub mod reportper;
#[doc = "Accumulated valid transitions register.\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [acc](acc) module"]
pub type ACC = crate::Reg<u32, _ACC>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _ACC;
#[doc = "`read()` method returns [acc::R](acc::R) reader structure"]
impl crate::Readable for ACC {}
#[doc = "Accumulated valid transitions register."]
pub mod acc;
#[doc = "Snapshot of ACC register. Value generated by the TASKS_READCLEACC task.\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [accread](accread) module"]
pub type ACCREAD = crate::Reg<u32, _ACCREAD>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _ACCREAD;
#[doc = "`read()` method returns [accread::R](accread::R) reader structure"]
impl crate::Readable for ACCREAD {}
#[doc = "Snapshot of ACC register. Value generated by the TASKS_READCLEACC task."]
pub mod accread;
#[doc = "Pin select for LED output.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pselled](pselled) module"]
pub type PSELLED = crate::Reg<u32, _PSELLED>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _PSELLED;
#[doc = "`read()` method returns [pselled::R](pselled::R) reader structure"]
impl crate::Readable for PSELLED {}
#[doc = "`write(|w| ..)` method takes [pselled::W](pselled::W) writer structure"]
impl crate::Writable for PSELLED {}
#[doc = "Pin select for LED output."]
pub mod pselled;
#[doc = "Pin select for phase A input.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [psela](psela) module"]
pub type PSELA = crate::Reg<u32, _PSELA>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _PSELA;
#[doc = "`read()` method returns [psela::R](psela::R) reader structure"]
impl crate::Readable for PSELA {}
#[doc = "`write(|w| ..)` method takes [psela::W](psela::W) writer structure"]
impl crate::Writable for PSELA {}
#[doc = "Pin select for phase A input."]
pub mod psela;
#[doc = "Pin select for phase B input.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pselb](pselb) module"]
pub type PSELB = crate::Reg<u32, _PSELB>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _PSELB;
#[doc = "`read()` method returns [pselb::R](pselb::R) reader structure"]
impl crate::Readable for PSELB {}
#[doc = "`write(|w| ..)` method takes [pselb::W](pselb::W) writer structure"]
impl crate::Writable for PSELB {}
#[doc = "Pin select for phase B input."]
pub mod pselb;
#[doc = "Enable debouncer input filters.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [dbfen](dbfen) module"]
pub type DBFEN = crate::Reg<u32, _DBFEN>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _DBFEN;
#[doc = "`read()` method returns [dbfen::R](dbfen::R) reader structure"]
impl crate::Readable for DBFEN {}
#[doc = "`write(|w| ..)` method takes [dbfen::W](dbfen::W) writer structure"]
impl crate::Writable for DBFEN {}
#[doc = "Enable debouncer input filters."]
pub mod dbfen;
#[doc = "Time LED is switched ON before the sample.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ledpre](ledpre) module"]
pub type LEDPRE = crate::Reg<u32, _LEDPRE>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _LEDPRE;
#[doc = "`read()` method returns [ledpre::R](ledpre::R) reader structure"]
impl crate::Readable for LEDPRE {}
#[doc = "`write(|w| ..)` method takes [ledpre::W](ledpre::W) writer structure"]
impl crate::Writable for LEDPRE {}
#[doc = "Time LED is switched ON before the sample."]
pub mod ledpre;
#[doc = "Accumulated double (error) transitions register.\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [accdbl](accdbl) module"]
pub type ACCDBL = crate::Reg<u32, _ACCDBL>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _ACCDBL;
#[doc = "`read()` method returns [accdbl::R](accdbl::R) reader structure"]
impl crate::Readable for ACCDBL {}
#[doc = "Accumulated double (error) transitions register."]
pub mod accdbl;
#[doc = "Snapshot of ACCDBL register. Value generated by the TASKS_READCLEACC task.\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [accdblread](accdblread) module"]
pub type ACCDBLREAD = crate::Reg<u32, _ACCDBLREAD>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _ACCDBLREAD;
#[doc = "`read()` method returns [accdblread::R](accdblread::R) reader structure"]
impl crate::Readable for ACCDBLREAD {}
#[doc = "Snapshot of ACCDBL register. Value generated by the TASKS_READCLEACC task."]
pub mod accdblread;
#[doc = "Peripheral power control.\n\nThis register you can [`read`](crate::generic::Reg::read), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [power](power) module"]
pub type POWER = crate::Reg<u32, _POWER>;
#[allow(missing_docs)]
#[doc(hidden)]
pub struct _POWER;
#[doc = "`read()` method returns [power::R](power::R) reader structure"]
impl crate::Readable for POWER {}
#[doc = "`write(|w| ..)` method takes [power::W](power::W) writer structure"]
impl crate::Writable for POWER {}
#[doc = "Peripheral power control."]
pub mod power;
