#[doc = "Reader of register LFCLKSRCCOPY"]
pub type R = crate::R<u32, super::LFCLKSRCCOPY>;
#[doc = "Clock source for the LFCLK clock, set when task LKCLKSTART is triggered.\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum SRC_A {
    #[doc = "0: Internal 32KiHz RC oscillator."]
    RC = 0,
    #[doc = "1: External 32KiHz crystal."]
    XTAL = 1,
    #[doc = "2: Internal 32KiHz synthesizer from HFCLK system clock."]
    SYNTH = 2,
}
impl From<SRC_A> for u8 {
    #[inline(always)]
    fn from(variant: SRC_A) -> Self {
        variant as _
    }
}
#[doc = "Reader of field `SRC`"]
pub type SRC_R = crate::R<u8, SRC_A>;
impl SRC_R {
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> crate::Variant<u8, SRC_A> {
        use crate::Variant::*;
        match self.bits {
            0 => Val(SRC_A::RC),
            1 => Val(SRC_A::XTAL),
            2 => Val(SRC_A::SYNTH),
            i => Res(i),
        }
    }
    #[doc = "Checks if the value of the field is `RC`"]
    #[inline(always)]
    pub fn is_rc(&self) -> bool {
        *self == SRC_A::RC
    }
    #[doc = "Checks if the value of the field is `XTAL`"]
    #[inline(always)]
    pub fn is_xtal(&self) -> bool {
        *self == SRC_A::XTAL
    }
    #[doc = "Checks if the value of the field is `SYNTH`"]
    #[inline(always)]
    pub fn is_synth(&self) -> bool {
        *self == SRC_A::SYNTH
    }
}
impl R {
    #[doc = "Bits 0:1 - Clock source for the LFCLK clock, set when task LKCLKSTART is triggered."]
    #[inline(always)]
    pub fn src(&self) -> SRC_R {
        SRC_R::new((self.bits & 0x03) as u8)
    }
}
