# nova

[![Documentation](https://docs.rs/nova/badge.svg)](https://docs.rs/nova)

Create newtypes with great convenience.

All types generated by the following macros implement `Debug`, `Clone`, `Eq`, `PartialEq`, `Ord`, `PartialOrd` 
and `Hash`. For `Copy` types, the newtype also implements `Copy`.

For convenience, each type is also generated with a conditional derive for serde serialisation and deserialisation. This is enabled
with the `serde` feature, if desired.

## Usage

```toml
[dependencies]
nova = "0.3"
```

### Example

```rust
use nova::newtype;

#[newtype(serde, borrow = "str")]
pub type Meow = String;

#[newtype(copy)]
pub(crate) type SpecialUuid = uuid::Uuid;

fn example() {
    let meow = Meow("this is a string".to_string());
    let special_uuid = SpecialUuid(uuid::Uuid::new_v4());

    // Get inner:
    let inner = special_uuid.into_inner();
}

```

## Features

- **serde**: enables support for the `serde` attribute to derive `Serialize` and `Deserialize` for newtypes.

## License

This project is licensed under either of

 * Apache License, Version 2.0 ([LICENSE-APACHE](LICENSE-APACHE) or <http://www.apache.org/licenses/LICENSE-2.0>)
 * MIT license ([LICENSE-MIT](LICENSE-MIT) or <http://opensource.org/licenses/MIT>)

at your option.
