//! Module for letters with the font weight light and size 32.
//!
//! The bitmap font contains all unicode symbols from 0x00 to 0x17f with
//! the exception of control characters. It includes Basic Latin
//! Latin-1 Supplement and Latin extended A. This means the typical letters
//! and symbols from a QWERTZ/QWERTY keyboard plus symbols such as Ö, Ä,
//! and Ü.
//!
//! # Font License
//! * Downloaded from: <https://fonts.google.com/noto/specimen/Noto+Sans+Mono>
//! * License: SIL Open Font License (OFL) <https://scripts.sil.org/cms/scripts/page.php?site_id=nrsi&id=OFL>

/// The height of each bitmap character for the given font weight
/// and size. This size corresponds to the size of the module name.
/// The font size will be a few percent smaller, because each
/// bitmap contains a small vertical padding.
#[allow(dead_code)]
pub const BITMAP_HEIGHT: usize = 32;

/// The width of each bitmap character for the given font weight
/// and size. This is a few percent less than [`BITMAP_HEIGHT`],
/// because the bitmap font doesn't contain horizontal padding.
pub const BITMAP_WIDTH: usize = 17;

/// Returns the bitmap of the given character of the pre rendered
/// "Noto Sans Mono" raster for font weight light and font size 27px
#[inline]
pub const fn get_char(c: char) -> &'static [&'static [u8]] {
    match c {
        // letter: ' ' / 0x20
        ' ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '!' / 0x21
        '!' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 58, 71, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 205, 255, 8, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 201, 255, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 197, 254, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 192, 250, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 188, 246, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 184, 242, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 179, 237, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 175, 233, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 170, 228, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 166, 224, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 162, 220, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 157, 215, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 153, 211, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 137, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 60, 85, 2, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 8, 244, 255, 56, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 2, 232, 254, 40, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 20, 35, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '"' / 0x22
        '"' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 67, 49, 0, 0, 34, 71, 12, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 234, 168, 0, 0, 117, 255, 36, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 222, 156, 0, 0, 105, 255, 24, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 210, 145, 0, 0, 93, 255, 12, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 198, 133, 0, 0, 81, 254, 1, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 186, 121, 0, 0, 70, 244, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 174, 109, 0, 0, 58, 232, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 113, 68, 0, 0, 33, 153, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '#' / 0x23
        '#' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 67, 24, 0, 0, 0, 52, 35, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 15, 255, 61, 0, 0, 0, 216, 101, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 59, 255, 18, 0, 0, 8, 252, 58, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 103, 231, 0, 0, 0, 49, 255, 16, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 147, 188, 0, 0, 0, 93, 229, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 191, 146, 0, 0, 0, 137, 186, 0, 0, 0, 0],
            &[
                0, 0, 59, 121, 121, 121, 239, 180, 121, 121, 121, 211, 201, 121, 121, 89, 0,
            ],
            &[
                0, 0, 92, 189, 189, 200, 255, 198, 189, 189, 189, 254, 210, 189, 189, 140, 0,
            ],
            &[0, 0, 0, 0, 0, 68, 253, 9, 0, 0, 21, 255, 53, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 112, 219, 0, 0, 0, 65, 254, 11, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 155, 175, 0, 0, 0, 108, 222, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 199, 132, 0, 0, 0, 152, 179, 0, 0, 0, 0, 0],
            &[
                0, 18, 46, 46, 46, 242, 122, 46, 46, 46, 203, 160, 46, 46, 39, 0, 0,
            ],
            &[
                0, 103, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0,
            ],
            &[
                0, 6, 15, 15, 87, 250, 19, 15, 15, 44, 255, 57, 15, 15, 13, 0, 0,
            ],
            &[0, 0, 0, 0, 118, 211, 0, 0, 0, 74, 250, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 161, 167, 0, 0, 0, 119, 211, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 204, 123, 0, 0, 0, 165, 166, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 1, 245, 79, 0, 0, 0, 210, 121, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 34, 255, 34, 0, 0, 5, 250, 75, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '$' / 0x24
        '$' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 72, 77, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 156, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 2, 64, 128, 212, 219, 140, 108, 45, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 37, 204, 255, 228, 231, 231, 217, 251, 255, 199, 0, 0, 0, 0,
            ],
            &[
                0, 0, 10, 223, 227, 66, 0, 147, 156, 0, 9, 83, 99, 0, 0, 0, 0,
            ],
            &[0, 0, 98, 255, 59, 0, 0, 147, 156, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 141, 244, 0, 0, 0, 147, 156, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 131, 252, 9, 0, 0, 147, 156, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 66, 255, 133, 0, 0, 147, 156, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 163, 255, 160, 36, 147, 156, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 2, 115, 236, 254, 237, 183, 13, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 9, 100, 223, 255, 245, 156, 38, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 0, 147, 186, 150, 242, 248, 106, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 147, 156, 0, 18, 190, 254, 66, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 156, 0, 0, 7, 233, 165, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 156, 0, 0, 0, 192, 196, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 156, 0, 0, 0, 227, 178, 0, 0, 0],
            &[0, 0, 4, 0, 0, 0, 0, 147, 156, 0, 0, 110, 255, 97, 0, 0, 0],
            &[
                0, 0, 110, 209, 132, 77, 43, 160, 179, 93, 177, 255, 170, 2, 0, 0, 0,
            ],
            &[
                0, 0, 54, 175, 241, 255, 255, 255, 255, 251, 204, 83, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 2, 31, 56, 175, 174, 10, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 156, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 83, 88, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '%' / 0x25
        '%' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 59, 108, 92, 28, 0, 0, 0, 0, 0, 0, 61, 40, 0, 0, 0],
            &[
                5, 166, 238, 174, 195, 241, 76, 0, 0, 0, 0, 50, 254, 61, 0, 0, 0,
            ],
            &[
                102, 237, 31, 0, 0, 117, 236, 13, 0, 0, 0, 179, 187, 0, 0, 0, 0,
            ],
            &[201, 144, 0, 0, 0, 7, 242, 95, 0, 0, 53, 255, 57, 0, 0, 0, 0],
            &[
                237, 104, 0, 0, 0, 0, 209, 131, 0, 0, 183, 182, 0, 0, 0, 0, 0,
            ],
            &[
                240, 101, 0, 0, 0, 0, 207, 135, 0, 57, 255, 53, 0, 0, 0, 0, 0,
            ],
            &[
                205, 137, 0, 0, 0, 4, 239, 102, 0, 187, 178, 0, 0, 0, 0, 0, 0,
            ],
            &[
                116, 228, 16, 0, 0, 94, 247, 25, 61, 254, 49, 0, 0, 0, 0, 0, 0,
            ],
            &[
                9, 195, 216, 133, 155, 248, 112, 0, 192, 174, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 5, 99, 151, 134, 61, 0, 66, 254, 45, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 196, 169, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 70, 253, 42, 0, 90, 187, 220, 179, 60, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 0, 200, 165, 0, 113, 243, 108, 64, 130, 248, 68, 0,
            ],
            &[
                0, 0, 0, 0, 0, 74, 252, 38, 13, 239, 102, 0, 0, 0, 149, 204, 0,
            ],
            &[
                0, 0, 0, 0, 0, 204, 161, 0, 60, 255, 21, 0, 0, 0, 69, 255, 12,
            ],
            &[0, 0, 0, 0, 79, 251, 35, 0, 89, 252, 0, 0, 0, 0, 45, 255, 42],
            &[
                0, 0, 0, 1, 207, 156, 0, 0, 69, 255, 13, 0, 0, 0, 61, 255, 22,
            ],
            &[
                0, 0, 0, 83, 250, 32, 0, 0, 26, 252, 72, 0, 0, 0, 120, 234, 0,
            ],
            &[
                0, 0, 1, 211, 152, 0, 0, 0, 0, 160, 209, 27, 0, 49, 234, 120, 0,
            ],
            &[
                0, 0, 87, 248, 29, 0, 0, 0, 0, 12, 169, 253, 235, 253, 144, 4, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 49, 11, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '&' / 0x26
        '&' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 57, 120, 129, 75, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 138, 255, 207, 196, 251, 179, 2, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 62, 255, 110, 0, 0, 65, 254, 104, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 133, 236, 1, 0, 0, 0, 198, 172, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 159, 218, 0, 0, 0, 0, 178, 195, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 129, 250, 5, 0, 0, 1, 221, 164, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 50, 255, 84, 0, 0, 88, 255, 73, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 185, 204, 2, 55, 241, 168, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 48, 249, 219, 247, 177, 7, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 11, 255, 255, 184, 1, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 35, 214, 238, 255, 227, 22, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 23, 226, 214, 29, 19, 225, 190, 3, 0, 0, 0, 211, 163, 0, 0,
            ],
            &[
                0, 0, 167, 239, 29, 0, 0, 54, 249, 140, 0, 0, 18, 254, 110, 0, 0,
            ],
            &[
                0, 21, 251, 130, 0, 0, 0, 0, 107, 255, 85, 0, 95, 255, 36, 0, 0,
            ],
            &[
                0, 63, 255, 67, 0, 0, 0, 0, 0, 166, 243, 43, 207, 197, 0, 0, 0,
            ],
            &[
                0, 75, 255, 61, 0, 0, 0, 0, 0, 11, 213, 255, 255, 80, 0, 0, 0,
            ],
            &[0, 46, 255, 105, 0, 0, 0, 0, 0, 0, 66, 255, 255, 1, 0, 0, 0],
            &[
                0, 1, 223, 222, 10, 0, 0, 0, 0, 29, 211, 255, 255, 122, 0, 0, 0,
            ],
            &[
                0, 0, 78, 254, 213, 84, 39, 51, 127, 241, 223, 43, 146, 253, 70, 0, 0,
            ],
            &[
                0, 0, 0, 76, 217, 255, 255, 255, 239, 141, 17, 0, 5, 199, 236, 32, 0,
            ],
            &[0, 0, 0, 0, 0, 37, 62, 46, 4, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: ''' / 0x27
        '\'' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 51, 66, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 179, 230, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 167, 218, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 155, 206, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 143, 194, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 131, 182, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 119, 171, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 75, 110, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '(' / 0x28
        '(' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 71, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 18, 224, 154, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 159, 227, 11, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 51, 254, 92, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 221, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 24, 251, 123, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 106, 255, 37, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 177, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 232, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 20, 255, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 49, 255, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 67, 255, 77, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 75, 255, 69, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 68, 255, 76, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 54, 255, 92, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 25, 255, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 238, 165, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 184, 221, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 112, 255, 35, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 28, 253, 123, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 177, 222, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 53, 254, 93, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 159, 227, 11, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 17, 223, 152, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 67, 4, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: ')' / 0x29
        ')' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 60, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 99, 247, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 186, 208, 4, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 42, 253, 105, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 173, 226, 4, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 71, 255, 78, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 2, 236, 164, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 169, 235, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 114, 255, 34, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 70, 255, 76, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 40, 255, 105, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 24, 255, 120, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 18, 255, 126, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 26, 255, 118, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 44, 255, 100, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 73, 255, 71, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 118, 255, 26, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 173, 228, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 3, 239, 157, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 73, 255, 70, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 175, 221, 2, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 44, 254, 100, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 189, 205, 3, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 105, 246, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 59, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '*' / 0x2a
        '*' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 23, 77, 9, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 68, 255, 23, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 56, 255, 12, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 43, 255, 2, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 5, 132, 58, 2, 0, 31, 246, 0, 0, 9, 78, 136, 0, 0, 0],
            &[
                0, 0, 36, 227, 255, 234, 161, 101, 241, 97, 176, 245, 255, 230, 9, 0, 0,
            ],
            &[
                0, 0, 0, 0, 29, 86, 143, 222, 255, 214, 140, 85, 30, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 228, 181, 213, 11, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 3, 189, 178, 5, 212, 166, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 133, 245, 31, 0, 63, 255, 108, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 63, 254, 120, 0, 0, 0, 162, 249, 42, 0, 0, 0, 0],
            &[0, 0, 0, 0, 3, 101, 5, 0, 0, 0, 22, 96, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '+' / 0x2b
        '+' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 102, 152, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 133, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 133, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 133, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 133, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 44, 45, 45, 45, 45, 155, 208, 45, 45, 45, 45, 45, 8, 0, 0,
            ],
            &[
                0, 0, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 44, 0, 0,
            ],
            &[
                0, 0, 29, 29, 29, 29, 29, 147, 205, 29, 29, 29, 29, 29, 5, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 133, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 133, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 133, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 133, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 94, 140, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: ',' / 0x2c
        ',' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 27, 82, 47, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 113, 255, 137, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 156, 255, 70, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 207, 243, 7, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 10, 251, 171, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 64, 255, 82, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 129, 236, 7, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 112, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '-' / 0x2d
        '-' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 24, 25, 25, 25, 25, 25, 25, 25, 3, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 243, 255, 255, 255, 255, 255, 255, 255, 38, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 73, 77, 77, 77, 77, 77, 77, 77, 11, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '.' / 0x2e
        '.' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 62, 85, 2, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 11, 248, 255, 56, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 237, 254, 40, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 21, 35, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '/' / 0x2f
        '/' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 71, 33, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 255, 59, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 217, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 250, 121, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 113, 252, 27, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 210, 182, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 52, 255, 85, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 149, 237, 7, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 7, 238, 147, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 87, 255, 50, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 184, 208, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 28, 253, 111, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 123, 250, 20, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 219, 173, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 61, 255, 76, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 158, 231, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 12, 243, 138, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 97, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 194, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 36, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '0' / 0x30
        '0' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 14, 93, 135, 140, 107, 31, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 75, 238, 255, 238, 228, 255, 251, 124, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 47, 245, 201, 46, 0, 0, 21, 159, 255, 97, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 199, 225, 16, 0, 0, 0, 0, 3, 255, 255, 13, 0, 0, 0],
            &[
                0, 0, 46, 255, 99, 0, 0, 0, 0, 0, 106, 255, 255, 103, 0, 0, 0,
            ],
            &[
                0, 0, 124, 249, 15, 0, 0, 0, 0, 19, 237, 157, 200, 179, 0, 0, 0,
            ],
            &[
                0, 0, 171, 209, 0, 0, 0, 0, 0, 151, 239, 22, 146, 226, 0, 0, 0,
            ],
            &[
                0, 0, 214, 167, 0, 0, 0, 0, 49, 253, 110, 0, 106, 255, 12, 0, 0,
            ],
            &[
                0, 0, 232, 145, 0, 0, 0, 0, 195, 211, 4, 0, 85, 255, 28, 0, 0,
            ],
            &[
                0, 0, 245, 133, 0, 0, 0, 91, 255, 64, 0, 0, 74, 255, 41, 0, 0,
            ],
            &[
                0, 0, 252, 126, 0, 0, 12, 229, 168, 0, 0, 0, 68, 255, 48, 0, 0,
            ],
            &[
                0, 0, 239, 134, 0, 0, 136, 244, 28, 0, 0, 0, 76, 255, 39, 0, 0,
            ],
            &[
                0, 0, 225, 148, 0, 37, 249, 121, 0, 0, 0, 0, 89, 255, 26, 0, 0,
            ],
            &[
                0, 0, 202, 178, 0, 181, 218, 6, 0, 0, 0, 0, 118, 250, 2, 0, 0,
            ],
            &[
                0, 0, 153, 223, 75, 255, 74, 0, 0, 0, 0, 0, 161, 215, 0, 0, 0,
            ],
            &[
                0, 0, 100, 255, 252, 178, 0, 0, 0, 0, 0, 0, 224, 153, 0, 0, 0,
            ],
            &[0, 0, 18, 255, 255, 34, 0, 0, 0, 0, 0, 68, 255, 73, 0, 0, 0],
            &[0, 0, 0, 150, 255, 50, 0, 0, 0, 0, 15, 214, 210, 1, 0, 0, 0],
            &[
                0, 0, 0, 11, 206, 242, 122, 53, 45, 96, 217, 244, 47, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 20, 150, 251, 255, 255, 255, 194, 44, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 9, 45, 57, 25, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '1' / 0x31
        '1' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 49, 58, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 23, 164, 255, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 106, 239, 225, 204, 211, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 50, 202, 253, 142, 11, 164, 211, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 120, 213, 55, 0, 0, 169, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 4, 6, 0, 0, 0, 173, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 174, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 211, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 211, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 11, 33, 45, 58, 243, 255, 60, 47, 34, 14, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 125, 255, 255, 255, 255, 255, 255, 255, 255, 148, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '2' / 0x32
        '2' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 27, 92, 123, 128, 97, 23, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 42, 182, 252, 253, 231, 238, 255, 251, 132, 2, 0, 0, 0, 0,
            ],
            &[
                0, 0, 52, 248, 219, 100, 18, 0, 0, 31, 167, 255, 128, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 98, 7, 0, 0, 0, 0, 0, 1, 189, 246, 15, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 255, 76, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 255, 100, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 255, 89, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 51, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190, 232, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 126, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 217, 223, 10, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 2, 174, 249, 56, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 150, 254, 93, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 138, 255, 111, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 132, 255, 117, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 126, 255, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 120, 255, 125, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 114, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 93, 255, 218, 110, 110, 110, 110, 110, 110, 110, 110, 110, 43, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '3' / 0x33
        '3' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 33, 98, 125, 131, 107, 40, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 62, 193, 255, 253, 231, 233, 255, 255, 177, 19, 0, 0, 0, 0,
            ],
            &[
                0, 0, 67, 254, 204, 89, 15, 0, 0, 16, 125, 252, 194, 1, 0, 0, 0,
            ],
            &[0, 0, 1, 80, 1, 0, 0, 0, 0, 0, 0, 131, 255, 68, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 255, 122, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 255, 131, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 255, 93, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 187, 235, 14, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 38, 181, 245, 70, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 170, 183, 191, 220, 238, 149, 34, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 168, 182, 187, 204, 245, 225, 140, 21, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 79, 222, 226, 29, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 242, 174, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 156, 250, 7, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 255, 30, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 255, 12, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 220, 215, 0, 0, 0],
            &[0, 0, 35, 1, 0, 0, 0, 0, 0, 0, 1, 149, 255, 103, 0, 0, 0],
            &[
                0, 0, 173, 221, 142, 86, 50, 38, 51, 98, 196, 255, 156, 0, 0, 0, 0,
            ],
            &[
                0, 0, 52, 160, 233, 255, 255, 255, 255, 253, 195, 84, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 27, 56, 63, 44, 16, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '4' / 0x34
        '4' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 98, 76, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 153, 255, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 61, 252, 210, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 7, 215, 159, 172, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 129, 240, 23, 179, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 42, 249, 105, 0, 184, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 1, 197, 197, 1, 0, 187, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 105, 250, 43, 0, 0, 189, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 241, 131, 0, 0, 0, 189, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 175, 217, 7, 0, 0, 0, 189, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 82, 254, 64, 0, 0, 0, 0, 189, 197, 0, 0, 0, 0, 0],
            &[0, 0, 15, 229, 157, 0, 0, 0, 0, 0, 189, 197, 0, 0, 0, 0, 0],
            &[0, 0, 151, 233, 18, 0, 0, 0, 0, 0, 189, 197, 0, 0, 0, 0, 0],
            &[
                0, 59, 254, 126, 39, 39, 39, 39, 39, 39, 199, 206, 39, 39, 28, 0, 0,
            ],
            &[
                0, 131, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 182, 0, 0,
            ],
            &[
                0, 25, 49, 49, 49, 49, 49, 49, 49, 49, 202, 208, 49, 49, 35, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '5' / 0x35
        '5' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 16, 71, 71, 71, 71, 71, 71, 71, 71, 58, 0, 0, 0, 0],
            &[
                0, 0, 0, 73, 255, 255, 255, 255, 255, 255, 255, 255, 211, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 95, 255, 52, 32, 32, 32, 32, 32, 32, 26, 0, 0, 0, 0],
            &[0, 0, 0, 116, 253, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 138, 234, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 160, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 182, 188, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 204, 165, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 226, 179, 114, 146, 163, 151, 118, 40, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 214, 252, 212, 185, 174, 196, 247, 255, 164, 15, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 10, 11, 0, 0, 0, 0, 12, 131, 254, 184, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 255, 76, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 249, 162, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215, 195, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 198, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 236, 170, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 255, 98, 0, 0, 0],
            &[0, 0, 32, 3, 0, 0, 0, 0, 0, 0, 34, 226, 224, 12, 0, 0, 0],
            &[
                0, 0, 132, 222, 135, 75, 45, 40, 68, 139, 242, 236, 53, 0, 0, 0, 0,
            ],
            &[
                0, 0, 37, 154, 232, 255, 255, 255, 255, 240, 157, 26, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 29, 58, 61, 37, 6, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '6' / 0x36
        '6' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 34, 102, 129, 142, 124, 55, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 36, 189, 255, 245, 215, 204, 227, 162, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 58, 244, 218, 82, 8, 0, 0, 0, 11, 0, 0, 0, 0],
            &[0, 0, 0, 25, 235, 196, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 151, 241, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 15, 249, 130, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 91, 255, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 151, 232, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 194, 187, 0, 57, 176, 240, 255, 247, 196, 92, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 224, 164, 97, 244, 157, 90, 70, 93, 170, 254, 162, 1, 0, 0, 0,
            ],
            &[
                0, 0, 237, 196, 215, 40, 0, 0, 0, 0, 0, 101, 255, 105, 0, 0, 0,
            ],
            &[0, 0, 246, 255, 53, 0, 0, 0, 0, 0, 0, 0, 199, 220, 0, 0, 0],
            &[0, 0, 235, 206, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 27, 0, 0],
            &[0, 0, 215, 180, 0, 0, 0, 0, 0, 0, 0, 0, 85, 255, 51, 0, 0],
            &[0, 0, 173, 208, 0, 0, 0, 0, 0, 0, 0, 0, 82, 255, 42, 0, 0],
            &[0, 0, 111, 253, 24, 0, 0, 0, 0, 0, 0, 0, 117, 254, 15, 0, 0],
            &[0, 0, 28, 251, 132, 0, 0, 0, 0, 0, 0, 0, 197, 196, 0, 0, 0],
            &[0, 0, 0, 150, 250, 63, 0, 0, 0, 0, 0, 98, 255, 85, 0, 0, 0],
            &[
                0, 0, 0, 10, 203, 251, 133, 46, 26, 56, 149, 253, 157, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 10, 143, 241, 255, 255, 255, 225, 110, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 8, 45, 61, 35, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '7' / 0x37
        '7' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 32, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 12, 0, 0,
            ],
            &[
                0, 0, 118, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 44, 0, 0,
            ],
            &[
                0, 0, 14, 32, 32, 32, 32, 32, 32, 32, 32, 32, 171, 233, 6, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 243, 137, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 106, 254, 35, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 187, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 255, 84, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165, 232, 5, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 248, 135, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 118, 254, 34, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 1, 221, 185, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 72, 255, 83, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 177, 231, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 29, 252, 133, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 130, 253, 32, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 230, 183, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 84, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 189, 230, 4, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 38, 254, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 142, 253, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '8' / 0x38
        '8' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 30, 100, 130, 127, 92, 20, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 9, 156, 254, 250, 219, 225, 253, 247, 123, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 172, 251, 113, 8, 0, 0, 20, 151, 255, 117, 0, 0, 0,
            ],
            &[0, 0, 0, 49, 255, 124, 0, 0, 0, 0, 0, 0, 184, 239, 6, 0, 0],
            &[0, 0, 0, 101, 255, 44, 0, 0, 0, 0, 0, 0, 108, 255, 37, 0, 0],
            &[0, 0, 0, 103, 255, 35, 0, 0, 0, 0, 0, 0, 102, 255, 26, 0, 0],
            &[0, 0, 0, 48, 255, 108, 0, 0, 0, 0, 0, 0, 178, 226, 0, 0, 0],
            &[0, 0, 0, 0, 171, 243, 62, 0, 0, 0, 0, 117, 254, 82, 0, 0, 0],
            &[
                0, 0, 0, 0, 10, 172, 252, 158, 37, 60, 192, 245, 88, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 81, 244, 253, 255, 190, 27, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 67, 211, 244, 148, 207, 254, 171, 28, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 120, 255, 155, 23, 0, 0, 75, 218, 239, 61, 0, 0, 0,
            ],
            &[0, 0, 0, 79, 255, 124, 0, 0, 0, 0, 0, 12, 189, 238, 28, 0, 0],
            &[0, 0, 0, 202, 215, 1, 0, 0, 0, 0, 0, 0, 22, 248, 137, 0, 0],
            &[0, 0, 4, 253, 144, 0, 0, 0, 0, 0, 0, 0, 0, 199, 193, 0, 0],
            &[0, 0, 10, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 205, 197, 0, 0],
            &[0, 0, 0, 229, 190, 0, 0, 0, 0, 0, 0, 0, 12, 248, 156, 0, 0],
            &[0, 0, 0, 131, 255, 82, 0, 0, 0, 0, 0, 0, 161, 254, 53, 0, 0],
            &[
                0, 0, 0, 8, 196, 251, 147, 60, 25, 39, 81, 199, 255, 117, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 7, 127, 230, 255, 255, 255, 253, 195, 68, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 37, 61, 50, 19, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '9' / 0x39
        '9' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 32, 106, 136, 129, 86, 9, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 8, 157, 253, 241, 206, 218, 252, 234, 78, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 181, 245, 97, 4, 0, 0, 30, 176, 252, 72, 0, 0, 0, 0],
            &[0, 0, 88, 255, 82, 0, 0, 0, 0, 0, 2, 186, 226, 8, 0, 0, 0],
            &[0, 0, 183, 210, 0, 0, 0, 0, 0, 0, 0, 51, 255, 95, 0, 0, 0],
            &[0, 0, 238, 146, 0, 0, 0, 0, 0, 0, 0, 0, 204, 176, 0, 0, 0],
            &[0, 6, 255, 122, 0, 0, 0, 0, 0, 0, 0, 0, 152, 229, 0, 0, 0],
            &[0, 2, 254, 141, 0, 0, 0, 0, 0, 0, 0, 0, 131, 255, 11, 0, 0],
            &[0, 0, 220, 178, 0, 0, 0, 0, 0, 0, 0, 0, 180, 255, 27, 0, 0],
            &[0, 0, 144, 250, 37, 0, 0, 0, 0, 0, 0, 63, 252, 255, 34, 0, 0],
            &[
                0, 0, 27, 237, 204, 38, 0, 0, 0, 1, 87, 225, 147, 255, 25, 0, 0,
            ],
            &[
                0, 0, 0, 56, 230, 247, 193, 154, 165, 222, 237, 70, 128, 254, 8, 0, 0,
            ],
            &[
                0, 0, 0, 0, 11, 100, 158, 176, 161, 106, 15, 0, 162, 230, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 212, 181, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 255, 116, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 253, 28, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 246, 160, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 38, 222, 228, 23, 0, 0, 0, 0],
            &[
                0, 0, 0, 65, 59, 35, 40, 71, 149, 247, 225, 45, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 159, 255, 255, 255, 255, 230, 135, 17, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 5, 41, 61, 59, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: ':' / 0x3a
        ':' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 86, 117, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 10, 249, 255, 56, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 216, 245, 27, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 4, 14, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 62, 85, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 11, 248, 255, 51, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 237, 254, 36, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 21, 35, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: ';' / 0x3b
        ';' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 25, 117, 37, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 135, 255, 166, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 92, 252, 122, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 38, 82, 36, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 148, 255, 103, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 191, 255, 36, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 1, 240, 217, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 40, 255, 137, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 99, 255, 48, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 163, 208, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 133, 78, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '<' / 0x3c
        '<' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 87, 215, 3, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 81, 210, 245, 138, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 75, 205, 245, 140, 22, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 68, 199, 246, 141, 23, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 62, 193, 246, 143, 24, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 55, 187, 247, 144, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 210, 254, 118, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 20, 132, 240, 222, 104, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 15, 122, 234, 230, 116, 12, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 10, 112, 228, 238, 129, 19, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 6, 102, 221, 244, 141, 26, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 92, 214, 248, 2, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 83, 1, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '=' / 0x3d
        '=' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 24, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 69, 0, 0,
            ],
            &[
                0, 14, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 41, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 16, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 46, 0, 0,
            ],
            &[
                0, 23, 215, 215, 215, 215, 215, 215, 215, 215, 215, 215, 215, 215, 66, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '>' / 0x3e
        '>' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 185, 114, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 101, 232, 229, 107, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 9, 114, 232, 225, 101, 4, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 10, 115, 233, 221, 94, 3, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 10, 117, 234, 216, 88, 2, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 118, 235, 211, 82, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 245, 252, 9, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 201, 250, 157, 37, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 92, 212, 246, 147, 29, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 7, 104, 222, 242, 137, 23, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 13, 117, 231, 237, 127, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 200, 231, 117, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 78, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '?' / 0x3f
        '?' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 10, 75, 119, 135, 124, 88, 17, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 153, 243, 255, 240, 218, 235, 255, 247, 120, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 131, 136, 44, 0, 0, 0, 30, 167, 255, 111, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 193, 233, 4, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 255, 33, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 86, 255, 43, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 253, 15, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 227, 187, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 181, 245, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 30, 208, 235, 60, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 47, 229, 214, 33, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 9, 229, 197, 17, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 104, 252, 40, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 146, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 157, 175, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 60, 85, 2, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 7, 244, 255, 56, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 2, 232, 254, 41, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 20, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '@' / 0x40
        '@' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 6, 39, 64, 53, 10, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 22, 150, 238, 255, 253, 255, 249, 163, 28, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 62, 234, 220, 94, 35, 3, 14, 78, 201, 230, 39, 0, 0, 0,
            ],
            &[0, 0, 45, 240, 162, 5, 0, 0, 0, 0, 0, 3, 165, 229, 14, 0, 0],
            &[0, 1, 202, 182, 3, 0, 0, 0, 0, 0, 0, 0, 6, 216, 135, 0, 0],
            &[0, 86, 251, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88, 245, 9, 0],
            &[
                0, 183, 160, 0, 0, 0, 60, 185, 233, 224, 184, 82, 0, 9, 243, 71, 0,
            ],
            &[
                14, 252, 70, 0, 0, 76, 250, 150, 71, 88, 222, 165, 0, 0, 192, 137, 0,
            ],
            &[
                63, 253, 11, 0, 10, 230, 148, 0, 0, 0, 196, 152, 0, 0, 150, 166, 0,
            ],
            &[
                109, 222, 0, 0, 87, 254, 27, 0, 0, 0, 211, 138, 0, 0, 133, 186, 0,
            ],
            &[
                129, 195, 0, 0, 149, 217, 0, 0, 0, 0, 226, 125, 0, 0, 125, 198, 0,
            ],
            &[
                144, 184, 0, 0, 175, 188, 0, 0, 0, 0, 245, 112, 0, 0, 140, 182, 0,
            ],
            &[
                147, 188, 0, 0, 177, 186, 0, 0, 0, 21, 255, 103, 0, 0, 158, 164, 0,
            ],
            &[
                135, 208, 0, 0, 150, 208, 0, 0, 0, 68, 255, 108, 0, 0, 190, 115, 0,
            ],
            &[
                106, 231, 0, 0, 95, 253, 24, 0, 0, 157, 241, 136, 0, 15, 246, 48, 0,
            ],
            &[
                60, 255, 35, 0, 9, 230, 192, 68, 121, 238, 83, 229, 69, 165, 202, 0, 0,
            ],
            &[
                7, 242, 106, 0, 0, 40, 193, 243, 202, 54, 0, 137, 242, 201, 34, 0, 0,
            ],
            &[0, 157, 216, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 39, 250, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 120, 252, 93, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 138, 253, 172, 55, 5, 0, 0, 6, 63, 157, 87, 0, 0, 0],
            &[
                0, 0, 0, 0, 72, 201, 255, 252, 225, 225, 250, 246, 166, 39, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 30, 78, 98, 92, 63, 13, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'A' / 0x41
        'A' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 70, 88, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 12, 245, 255, 53, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 91, 253, 231, 142, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 180, 199, 146, 229, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 19, 250, 119, 61, 255, 65, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 255, 32, 1, 228, 154, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 192, 200, 0, 0, 142, 237, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 253, 112, 0, 0, 55, 255, 77, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 115, 253, 26, 0, 0, 0, 223, 166, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 204, 193, 0, 0, 0, 0, 137, 244, 11, 0, 0, 0, 0],
            &[0, 0, 0, 38, 255, 105, 0, 0, 0, 0, 50, 255, 88, 0, 0, 0, 0],
            &[
                0, 0, 0, 126, 255, 33, 11, 11, 11, 11, 12, 227, 178, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 216, 255, 255, 255, 255, 255, 255, 255, 255, 250, 17, 0, 0, 0,
            ],
            &[
                0, 0, 49, 255, 194, 98, 98, 98, 98, 98, 98, 142, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 138, 249, 17, 0, 0, 0, 0, 0, 0, 0, 213, 189, 0, 0, 0],
            &[0, 1, 226, 179, 0, 0, 0, 0, 0, 0, 0, 0, 126, 253, 25, 0, 0],
            &[0, 61, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 112, 0, 0],
            &[0, 150, 246, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 201, 0, 0],
            &[4, 235, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 35, 0],
            &[73, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 255, 124, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'B' / 0x42
        'B' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 71, 71, 71, 71, 70, 61, 40, 5, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 246, 172, 46, 0, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 105, 25, 25, 28, 47, 70, 143, 237, 246, 61, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 0, 43, 242, 205, 0, 0, 0],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 0, 0, 163, 255, 16, 0, 0],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 0, 0, 125, 255, 29, 0, 0],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 0, 0, 157, 249, 3, 0, 0],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 0, 23, 232, 167, 0, 0, 0],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 1, 72, 207, 217, 29, 0, 0, 0],
            &[
                0, 0, 42, 255, 222, 204, 204, 205, 222, 249, 227, 118, 16, 0, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 185, 147, 147, 147, 158, 181, 235, 223, 119, 4, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 3, 97, 248, 178, 1, 0, 0],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 0, 0, 109, 255, 76, 0, 0],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 0, 0, 19, 255, 144, 0, 0],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 0, 0, 2, 252, 162, 0, 0],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 0, 0, 37, 255, 137, 0, 0],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 0, 0, 125, 255, 77, 0, 0],
            &[0, 0, 42, 255, 88, 0, 0, 0, 0, 0, 0, 80, 251, 206, 2, 0, 0],
            &[
                0, 0, 42, 255, 156, 103, 103, 103, 111, 139, 204, 255, 209, 26, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 248, 227, 178, 97, 3, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'C' / 0x43
        'C' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 33, 98, 124, 130, 104, 73, 14, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 48, 193, 255, 254, 235, 229, 253, 255, 249, 133, 0, 0,
            ],
            &[
                0, 0, 0, 0, 84, 250, 228, 100, 17, 0, 0, 4, 45, 129, 89, 0, 0,
            ],
            &[0, 0, 0, 56, 251, 199, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 234, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 73, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 164, 248, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 220, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 9, 255, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 26, 255, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 37, 255, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 20, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 2, 253, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 218, 204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 149, 253, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 74, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 240, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 56, 249, 224, 39, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0],
            &[
                0, 0, 0, 0, 79, 245, 252, 165, 95, 62, 64, 92, 138, 212, 65, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 35, 162, 245, 255, 255, 255, 255, 242, 173, 32, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 4, 43, 63, 53, 30, 4, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'D' / 0x44
        'D' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 71, 71, 71, 69, 56, 22, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 194, 255, 255, 255, 255, 255, 255, 215, 117, 9, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 194, 211, 25, 25, 33, 60, 101, 195, 255, 216, 35, 0, 0, 0, 0,
            ],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 81, 243, 225, 19, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 71, 255, 157, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 170, 251, 24, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 75, 255, 103, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 10, 249, 160, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 194, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 210, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 213, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 209, 202, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 236, 174, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 32, 255, 129, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 114, 255, 60, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 10, 222, 216, 1, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 2, 159, 255, 79, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 36, 178, 255, 140, 0, 0, 0, 0],
            &[
                0, 0, 194, 226, 103, 103, 116, 138, 196, 252, 247, 114, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 194, 255, 255, 255, 250, 233, 191, 121, 24, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'E' / 0x45
        'E' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 60, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 121, 32, 32, 32, 32, 32, 32, 32, 32, 27, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 229, 211, 211, 211, 211, 211, 211, 211, 211, 65, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 191, 147, 147, 147, 147, 147, 147, 147, 147, 45, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 168, 110, 110, 110, 110, 110, 110, 110, 110, 93, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'F' / 0x46
        'F' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 60, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 121, 32, 32, 32, 32, 32, 32, 32, 32, 27, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 246, 239, 239, 239, 239, 239, 239, 239, 239, 80, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 174, 119, 119, 119, 119, 119, 119, 119, 119, 40, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'G' / 0x47
        'G' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 28, 97, 134, 139, 111, 78, 14, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 21, 166, 253, 255, 246, 227, 251, 255, 247, 115, 0, 0,
            ],
            &[
                0, 0, 0, 0, 30, 224, 248, 146, 35, 1, 0, 2, 41, 133, 78, 0, 0,
            ],
            &[0, 0, 0, 4, 205, 248, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 103, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 212, 225, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 37, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 94, 255, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 131, 255, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 154, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 163, 252, 0, 0, 0, 0, 0, 104, 211, 211, 211, 211, 208, 0, 0,
            ],
            &[
                0, 0, 158, 255, 7, 0, 0, 0, 0, 76, 154, 154, 154, 210, 252, 0, 0,
            ],
            &[0, 0, 141, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 108, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 55, 255, 125, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 2, 231, 214, 2, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 0, 125, 255, 98, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 0, 10, 217, 248, 76, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[
                0, 0, 0, 0, 35, 221, 255, 183, 92, 59, 53, 81, 141, 231, 252, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 15, 136, 233, 255, 255, 255, 255, 245, 180, 85, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 1, 36, 62, 61, 38, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'H' / 0x48
        'H' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[
                0, 0, 194, 247, 211, 211, 211, 211, 211, 211, 211, 211, 237, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 236, 154, 154, 154, 154, 154, 154, 154, 154, 213, 252, 0, 0, 0,
            ],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'I' / 0x49
        'I' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 25, 71, 71, 71, 71, 71, 71, 71, 71, 39, 0, 0, 0, 0],
            &[
                0, 0, 0, 76, 225, 240, 253, 255, 255, 254, 243, 228, 120, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 177, 227, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 10, 40, 55, 70, 200, 235, 73, 58, 43, 17, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 90, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'J' / 0x4a
        'J' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 68, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 242, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 224, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 235, 185, 0, 0, 0, 0],
            &[0, 0, 0, 1, 6, 0, 0, 0, 0, 0, 102, 255, 108, 0, 0, 0, 0],
            &[
                0, 0, 0, 7, 232, 132, 61, 33, 49, 130, 251, 216, 7, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 2, 149, 239, 255, 255, 255, 254, 183, 24, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 6, 40, 71, 65, 28, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'K' / 0x4b
        'K' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 34, 71, 28, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 33, 232, 208, 12, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 17, 215, 230, 28, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 6, 192, 245, 51, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 164, 253, 81, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 131, 255, 116, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 98, 255, 154, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 69, 251, 188, 4, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 45, 241, 214, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 18, 223, 255, 173, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 194, 207, 177, 227, 134, 255, 87, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 194, 252, 234, 39, 1, 190, 236, 23, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 194, 243, 49, 0, 0, 32, 243, 174, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 105, 255, 90, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 1, 189, 237, 24, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 32, 243, 178, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 104, 255, 93, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 1, 187, 239, 26, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 31, 242, 181, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 102, 255, 97, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'L' / 0x4c
        'L' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 29, 71, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 104, 255, 138, 117, 117, 117, 117, 117, 117, 117, 99, 0, 0, 0,
            ],
            &[
                0, 0, 0, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'M' / 0x4d
        'M' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 36, 71, 55, 0, 0, 0, 0, 0, 0, 0, 0, 42, 71, 50, 0, 0],
            &[
                0, 131, 255, 244, 11, 0, 0, 0, 0, 0, 0, 0, 212, 255, 182, 0, 0,
            ],
            &[
                0, 131, 234, 254, 92, 0, 0, 0, 0, 0, 0, 47, 255, 235, 182, 0, 0,
            ],
            &[
                0, 131, 220, 194, 183, 0, 0, 0, 0, 0, 0, 138, 235, 179, 182, 0, 0,
            ],
            &[
                0, 131, 238, 101, 251, 22, 0, 0, 0, 0, 2, 227, 148, 185, 182, 0, 0,
            ],
            &[
                0, 131, 248, 16, 248, 109, 0, 0, 0, 0, 65, 255, 56, 193, 182, 0, 0,
            ],
            &[
                0, 131, 253, 0, 172, 200, 0, 0, 0, 0, 156, 219, 0, 196, 182, 0, 0,
            ],
            &[
                0, 131, 255, 0, 79, 255, 36, 0, 0, 7, 240, 128, 0, 197, 182, 0, 0,
            ],
            &[
                0, 131, 255, 0, 6, 237, 127, 0, 0, 83, 255, 36, 0, 197, 182, 0, 0,
            ],
            &[
                0, 131, 255, 0, 0, 150, 218, 0, 0, 174, 199, 0, 0, 197, 182, 0, 0,
            ],
            &[
                0, 131, 255, 0, 0, 58, 255, 53, 16, 248, 107, 0, 0, 197, 182, 0, 0,
            ],
            &[
                0, 131, 255, 0, 0, 0, 220, 145, 100, 250, 20, 0, 0, 197, 182, 0, 0,
            ],
            &[
                0, 131, 255, 0, 0, 0, 128, 232, 196, 179, 0, 0, 0, 197, 182, 0, 0,
            ],
            &[
                0, 131, 255, 0, 0, 0, 36, 255, 255, 86, 0, 0, 0, 197, 182, 0, 0,
            ],
            &[
                0, 131, 255, 0, 0, 0, 0, 174, 208, 9, 0, 0, 0, 197, 182, 0, 0,
            ],
            &[0, 131, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 182, 0, 0],
            &[0, 131, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 182, 0, 0],
            &[0, 131, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 182, 0, 0],
            &[0, 131, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 182, 0, 0],
            &[0, 131, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 182, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'N' / 0x4e
        'N' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 71, 19, 0, 0, 0, 0, 0, 0, 0, 39, 70, 0, 0, 0],
            &[0, 0, 194, 255, 151, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[0, 0, 194, 239, 249, 28, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[
                0, 0, 194, 164, 228, 147, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 171, 110, 247, 25, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 183, 9, 232, 142, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 189, 0, 115, 245, 22, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 11, 235, 137, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 121, 243, 19, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 13, 238, 132, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 127, 241, 16, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 16, 241, 127, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 132, 238, 14, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 19, 243, 122, 0, 139, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 138, 236, 12, 135, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 22, 246, 117, 128, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 143, 233, 129, 252, 0, 0, 0,
            ],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 26, 248, 220, 252, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 149, 255, 252, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 30, 250, 252, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'O' / 0x4f
        'O' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 17, 94, 135, 136, 107, 31, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 105, 244, 255, 238, 223, 250, 254, 153, 9, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 103, 255, 180, 39, 0, 0, 14, 122, 251, 178, 1, 0, 0, 0,
            ],
            &[0, 0, 38, 252, 178, 1, 0, 0, 0, 0, 0, 99, 255, 101, 0, 0, 0],
            &[0, 0, 158, 247, 20, 0, 0, 0, 0, 0, 0, 0, 201, 223, 1, 0, 0],
            &[0, 6, 247, 161, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 55, 0, 0],
            &[0, 58, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 122, 0, 0],
            &[0, 113, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 164, 0, 0],
            &[0, 135, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 195, 0, 0],
            &[0, 152, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 207, 0, 0],
            &[0, 162, 245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 213, 0, 0],
            &[0, 151, 255, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 202, 0, 0],
            &[0, 134, 255, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 185, 0, 0],
            &[0, 96, 255, 58, 0, 0, 0, 0, 0, 0, 0, 0, 8, 251, 147, 0, 0],
            &[0, 47, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 53, 255, 99, 0, 0],
            &[0, 0, 228, 196, 0, 0, 0, 0, 0, 0, 0, 0, 136, 255, 27, 0, 0],
            &[0, 0, 128, 255, 56, 0, 0, 0, 0, 0, 0, 15, 234, 182, 0, 0, 0],
            &[0, 0, 17, 230, 225, 25, 0, 0, 0, 0, 5, 177, 250, 52, 0, 0, 0],
            &[
                0, 0, 0, 59, 242, 239, 122, 67, 56, 98, 213, 253, 104, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 39, 179, 252, 255, 255, 255, 202, 70, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 18, 51, 57, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'P' / 0x50
        'P' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 71, 71, 71, 71, 71, 64, 48, 9, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 252, 189, 67, 0, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 117, 25, 25, 25, 33, 58, 116, 222, 255, 108, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 11, 200, 249, 31, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 64, 255, 114, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 6, 255, 155, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 1, 251, 159, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 25, 255, 132, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 110, 255, 64, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 59, 241, 200, 1, 0, 0],
            &[
                0, 0, 42, 255, 138, 59, 59, 62, 76, 109, 178, 254, 214, 28, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 254, 201, 116, 7, 0, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 128, 43, 43, 42, 25, 5, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Q' / 0x51
        'Q' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 17, 94, 135, 136, 107, 31, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 105, 244, 255, 238, 223, 250, 254, 153, 9, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 103, 255, 180, 39, 0, 0, 14, 122, 251, 178, 1, 0, 0, 0,
            ],
            &[0, 0, 38, 252, 178, 1, 0, 0, 0, 0, 0, 99, 255, 101, 0, 0, 0],
            &[0, 0, 158, 247, 20, 0, 0, 0, 0, 0, 0, 0, 201, 223, 1, 0, 0],
            &[0, 6, 247, 161, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 55, 0, 0],
            &[0, 58, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 122, 0, 0],
            &[0, 113, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 164, 0, 0],
            &[0, 135, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 195, 0, 0],
            &[0, 152, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 207, 0, 0],
            &[0, 162, 245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 213, 0, 0],
            &[0, 151, 255, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 202, 0, 0],
            &[0, 134, 255, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 185, 0, 0],
            &[0, 96, 255, 58, 0, 0, 0, 0, 0, 0, 0, 0, 8, 251, 147, 0, 0],
            &[0, 47, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 53, 255, 99, 0, 0],
            &[0, 0, 228, 196, 0, 0, 0, 0, 0, 0, 0, 0, 136, 255, 27, 0, 0],
            &[0, 0, 128, 255, 56, 0, 0, 0, 0, 0, 0, 15, 234, 182, 0, 0, 0],
            &[0, 0, 17, 230, 225, 25, 0, 0, 0, 0, 5, 177, 250, 52, 0, 0, 0],
            &[
                0, 0, 0, 59, 242, 239, 122, 67, 56, 98, 255, 253, 104, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 39, 179, 252, 255, 255, 255, 255, 107, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 18, 51, 57, 46, 240, 174, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122, 255, 59, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 230, 199, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 255, 86, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 169, 150, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'R' / 0x52
        'R' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 11, 71, 71, 71, 71, 66, 50, 22, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 42, 255, 255, 255, 255, 255, 255, 255, 218, 120, 10, 0, 0, 0, 0, 0,
            ],
            &[
                0, 42, 255, 117, 25, 25, 34, 59, 95, 189, 254, 202, 14, 0, 0, 0, 0,
            ],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 93, 255, 136, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 201, 230, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 147, 255, 8, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 145, 255, 13, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 184, 236, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 42, 252, 153, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 68, 224, 226, 22, 0, 0, 0, 0],
            &[
                0, 42, 255, 204, 170, 170, 171, 187, 229, 254, 176, 28, 0, 0, 0, 0, 0,
            ],
            &[
                0, 42, 255, 215, 188, 188, 188, 205, 255, 91, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 42, 255, 102, 0, 0, 0, 6, 218, 208, 3, 0, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 74, 255, 108, 0, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 178, 239, 22, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 35, 248, 158, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 132, 254, 57, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 10, 226, 205, 2, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 85, 255, 105, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 189, 238, 20, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'S' / 0x53
        'S' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 3, 58, 111, 132, 132, 111, 68, 9, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 79, 224, 255, 248, 226, 236, 255, 255, 246, 119, 0, 0, 0,
            ],
            &[0, 0, 0, 84, 253, 205, 71, 6, 0, 0, 8, 61, 144, 78, 0, 0, 0],
            &[0, 0, 4, 225, 215, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 44, 255, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 68, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 46, 255, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 3, 221, 226, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 66, 249, 232, 104, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 49, 198, 255, 239, 141, 34, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 57, 170, 251, 253, 176, 61, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 28, 133, 234, 255, 156, 4, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 148, 255, 143, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 247, 11, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108, 255, 44, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 255, 46, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 172, 248, 11, 0, 0],
            &[0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 86, 253, 160, 0, 0, 0],
            &[
                0, 0, 158, 205, 131, 77, 43, 31, 45, 87, 174, 255, 207, 18, 0, 0, 0,
            ],
            &[
                0, 0, 70, 171, 239, 255, 255, 255, 255, 255, 222, 122, 8, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 1, 29, 56, 65, 55, 24, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'T' / 0x54
        'T' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 50, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 66, 0, 0,
            ],
            &[
                0, 180, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 0, 0,
            ],
            &[
                0, 22, 32, 32, 32, 32, 32, 185, 229, 32, 32, 32, 32, 32, 30, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'U' / 0x55
        'U' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 187, 214, 0, 0, 0, 0, 0, 0, 0, 0, 156, 245, 0, 0, 0],
            &[0, 0, 169, 231, 0, 0, 0, 0, 0, 0, 0, 0, 174, 226, 0, 0, 0],
            &[0, 0, 136, 255, 21, 0, 0, 0, 0, 0, 0, 0, 221, 191, 0, 0, 0],
            &[0, 0, 73, 255, 98, 0, 0, 0, 0, 0, 0, 47, 255, 123, 0, 0, 0],
            &[0, 0, 5, 219, 223, 23, 0, 0, 0, 0, 8, 193, 243, 25, 0, 0, 0],
            &[
                0, 0, 0, 68, 247, 224, 108, 58, 54, 97, 208, 253, 99, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 59, 195, 255, 255, 255, 255, 205, 77, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 53, 55, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'V' / 0x56
        'V' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[4, 71, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 71, 20, 0],
            &[0, 217, 202, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 253, 23, 0],
            &[0, 132, 255, 30, 0, 0, 0, 0, 0, 0, 0, 0, 1, 230, 191, 0, 0],
            &[0, 46, 255, 112, 0, 0, 0, 0, 0, 0, 0, 0, 57, 255, 106, 0, 0],
            &[0, 0, 217, 195, 0, 0, 0, 0, 0, 0, 0, 0, 139, 253, 24, 0, 0],
            &[0, 0, 132, 253, 25, 0, 0, 0, 0, 0, 0, 0, 221, 193, 0, 0, 0],
            &[0, 0, 46, 255, 106, 0, 0, 0, 0, 0, 0, 47, 255, 109, 0, 0, 0],
            &[0, 0, 0, 217, 189, 0, 0, 0, 0, 0, 0, 129, 254, 26, 0, 0, 0],
            &[0, 0, 0, 132, 252, 20, 0, 0, 0, 0, 0, 211, 195, 0, 0, 0, 0],
            &[0, 0, 0, 46, 255, 99, 0, 0, 0, 0, 37, 255, 111, 0, 0, 0, 0],
            &[0, 0, 0, 0, 217, 183, 0, 0, 0, 0, 118, 254, 28, 0, 0, 0, 0],
            &[0, 0, 0, 0, 132, 250, 16, 0, 0, 0, 200, 197, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 46, 255, 93, 0, 0, 27, 254, 113, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 217, 176, 0, 0, 108, 254, 29, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 132, 247, 12, 0, 190, 200, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 46, 255, 81, 16, 251, 115, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 217, 156, 85, 255, 31, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 132, 228, 154, 202, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 46, 255, 242, 117, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 217, 255, 33, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'W' / 0x57
        'W' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[6, 71, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 71, 22, 0],
            &[4, 251, 122, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 255, 59, 0],
            &[0, 221, 156, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 255, 25, 0],
            &[0, 187, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 132, 246, 1, 0],
            &[0, 152, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 213, 0, 0],
            &[0, 117, 252, 5, 0, 0, 0, 65, 86, 0, 0, 0, 0, 200, 179, 0, 0],
            &[
                0, 82, 255, 36, 0, 0, 0, 218, 255, 21, 0, 0, 0, 235, 145, 0, 0,
            ],
            &[
                0, 48, 255, 69, 0, 0, 22, 253, 217, 80, 0, 0, 15, 255, 111, 0, 0,
            ],
            &[
                0, 13, 255, 103, 0, 0, 80, 219, 154, 139, 0, 0, 49, 255, 77, 0, 0,
            ],
            &[
                0, 0, 234, 137, 0, 0, 139, 167, 102, 198, 0, 0, 83, 255, 43, 0, 0,
            ],
            &[
                0, 0, 199, 171, 0, 0, 198, 112, 47, 249, 8, 0, 116, 254, 9, 0, 0,
            ],
            &[
                0, 0, 164, 205, 0, 8, 249, 55, 2, 242, 60, 0, 150, 230, 0, 0, 0,
            ],
            &[
                0, 0, 130, 239, 0, 60, 247, 5, 0, 186, 119, 0, 182, 196, 0, 0, 0,
            ],
            &[
                0, 0, 95, 255, 14, 119, 195, 0, 0, 127, 179, 0, 206, 162, 0, 0, 0,
            ],
            &[
                0, 0, 60, 255, 42, 175, 137, 0, 0, 69, 238, 2, 229, 128, 0, 0, 0,
            ],
            &[
                0, 0, 25, 255, 67, 231, 79, 0, 0, 13, 252, 46, 251, 94, 0, 0, 0,
            ],
            &[
                0, 0, 1, 246, 120, 255, 21, 0, 0, 0, 207, 115, 255, 60, 0, 0, 0,
            ],
            &[
                0, 0, 0, 212, 193, 219, 0, 0, 0, 0, 149, 186, 255, 26, 0, 0, 0,
            ],
            &[0, 0, 0, 177, 249, 161, 0, 0, 0, 0, 90, 249, 247, 1, 0, 0, 0],
            &[0, 0, 0, 142, 255, 103, 0, 0, 0, 0, 32, 255, 214, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'X' / 0x58
        'X' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 15, 71, 36, 0, 0, 0, 0, 0, 0, 0, 0, 10, 71, 37, 0, 0],
            &[0, 3, 207, 219, 6, 0, 0, 0, 0, 0, 0, 0, 136, 249, 39, 0, 0],
            &[0, 0, 55, 253, 120, 0, 0, 0, 0, 0, 0, 39, 249, 131, 0, 0, 0],
            &[0, 0, 0, 153, 243, 26, 0, 0, 0, 0, 0, 187, 221, 8, 0, 0, 0],
            &[0, 0, 0, 17, 234, 164, 0, 0, 0, 0, 84, 255, 72, 0, 0, 0, 0],
            &[0, 0, 0, 0, 95, 254, 59, 0, 0, 11, 226, 170, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 193, 205, 2, 0, 135, 242, 26, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 43, 250, 102, 39, 249, 111, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 137, 235, 193, 206, 3, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 11, 225, 253, 55, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 13, 229, 254, 59, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 145, 237, 188, 210, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 51, 252, 102, 33, 247, 116, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 204, 201, 1, 0, 127, 244, 29, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 109, 253, 51, 0, 0, 8, 222, 175, 0, 0, 0, 0, 0],
            &[0, 0, 0, 26, 241, 149, 0, 0, 0, 0, 77, 255, 76, 0, 0, 0, 0],
            &[0, 0, 0, 171, 233, 16, 0, 0, 0, 0, 0, 180, 223, 10, 0, 0, 0],
            &[0, 0, 74, 255, 95, 0, 0, 0, 0, 0, 0, 34, 247, 135, 0, 0, 0],
            &[0, 9, 222, 195, 1, 0, 0, 0, 0, 0, 0, 0, 129, 250, 42, 0, 0],
            &[0, 135, 251, 46, 0, 0, 0, 0, 0, 0, 0, 0, 9, 223, 193, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Y' / 0x59
        'Y' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 54, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 69, 1, 0],
            &[0, 110, 255, 71, 0, 0, 0, 0, 0, 0, 0, 0, 18, 242, 168, 0, 0],
            &[0, 7, 225, 198, 0, 0, 0, 0, 0, 0, 0, 0, 131, 252, 39, 0, 0],
            &[0, 0, 98, 255, 71, 0, 0, 0, 0, 0, 0, 17, 241, 157, 0, 0, 0],
            &[0, 0, 3, 216, 198, 0, 0, 0, 0, 0, 0, 129, 249, 31, 0, 0, 0],
            &[0, 0, 0, 85, 255, 71, 0, 0, 0, 0, 15, 240, 146, 0, 0, 0, 0],
            &[0, 0, 0, 1, 206, 198, 0, 0, 0, 0, 126, 245, 23, 0, 0, 0, 0],
            &[0, 0, 0, 0, 73, 255, 71, 0, 0, 14, 238, 135, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 195, 198, 0, 0, 123, 240, 17, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 61, 255, 71, 13, 237, 124, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 183, 198, 121, 234, 12, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 50, 254, 247, 113, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 183, 239, 8, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Z' / 0x5a
        'Z' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 36, 71, 71, 71, 71, 71, 71, 71, 71, 71, 24, 0, 0, 0],
            &[
                0, 0, 0, 132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 85, 0, 0, 0,
            ],
            &[
                0, 0, 0, 13, 25, 25, 25, 25, 25, 25, 25, 163, 242, 20, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 249, 128, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 236, 14, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 42, 253, 115, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 228, 8, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 54, 255, 103, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 189, 219, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 68, 255, 90, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 202, 209, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 82, 255, 77, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 3, 214, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 96, 255, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 6, 224, 185, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 110, 254, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 12, 233, 173, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 124, 252, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 15, 240, 217, 110, 110, 110, 110, 110, 110, 110, 110, 55, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '[' / 0x5b
        '[' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 38, 71, 71, 71, 71, 71, 14, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 139, 255, 255, 255, 255, 255, 52, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 139, 247, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 247, 14, 14, 14, 14, 2, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 139, 255, 255, 255, 255, 255, 52, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 37, 68, 68, 68, 68, 68, 13, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '\' / 0x5c
        '\\' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 19, 71, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 16, 247, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 167, 224, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 70, 255, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 226, 165, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 131, 246, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 35, 254, 103, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 193, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 96, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 11, 243, 138, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 157, 231, 4, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 60, 255, 77, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 218, 174, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 122, 250, 21, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 28, 253, 112, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 209, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 86, 255, 51, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 238, 148, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 148, 237, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 255, 86, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: ']' / 0x5d
        ']' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 105, 105, 105, 105, 81, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 227, 232, 232, 232, 249, 198, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 198, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 41, 42, 42, 42, 199, 198, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 250, 255, 255, 255, 255, 198, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 32, 33, 33, 33, 33, 25, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '^' / 0x5e
        '^' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 54, 70, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 219, 242, 19, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 96, 235, 211, 137, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 4, 221, 120, 81, 245, 23, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 99, 236, 12, 1, 208, 143, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 5, 222, 122, 0, 0, 81, 247, 26, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 101, 237, 13, 0, 0, 1, 207, 148, 0, 0, 0, 0, 0],
            &[0, 0, 0, 5, 224, 124, 0, 0, 0, 0, 80, 249, 30, 0, 0, 0, 0],
            &[0, 0, 0, 103, 238, 14, 0, 0, 0, 0, 1, 206, 154, 0, 0, 0, 0],
            &[0, 0, 6, 226, 126, 0, 0, 0, 0, 0, 0, 79, 250, 34, 0, 0, 0],
            &[0, 0, 105, 239, 15, 0, 0, 0, 0, 0, 0, 0, 206, 160, 0, 0, 0],
            &[0, 7, 227, 128, 0, 0, 0, 0, 0, 0, 0, 0, 79, 252, 38, 0, 0],
            &[0, 53, 160, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144, 89, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '_' / 0x5f
        '_' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                221, 221, 221, 221, 221, 221, 221, 221, 221, 221, 221, 221, 221, 221, 221, 221, 44,
            ],
            &[
                144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 28,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '`' / 0x60
        '`' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 82, 174, 81, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 8, 201, 238, 27, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 20, 213, 198, 5, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 22, 211, 156, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 17, 151, 47, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'a' / 0x61
        'a' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 66, 124, 151, 156, 134, 76, 4, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 84, 225, 255, 228, 195, 189, 224, 255, 214, 37, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 141, 39, 0, 0, 0, 0, 72, 237, 211, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 255, 62, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 255, 110, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 250, 126, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 16, 54, 79, 93, 102, 110, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 4, 99, 205, 253, 253, 232, 213, 203, 193, 253, 127, 0, 0, 0,
            ],
            &[0, 0, 7, 183, 251, 151, 59, 8, 0, 0, 0, 0, 245, 127, 0, 0, 0],
            &[0, 0, 112, 255, 76, 0, 0, 0, 0, 0, 0, 3, 252, 127, 0, 0, 0],
            &[0, 0, 186, 204, 0, 0, 0, 0, 0, 0, 0, 36, 255, 127, 0, 0, 0],
            &[0, 0, 201, 186, 0, 0, 0, 0, 0, 0, 0, 131, 255, 127, 0, 0, 0],
            &[
                0, 0, 158, 237, 19, 0, 0, 0, 0, 0, 67, 227, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 47, 248, 205, 76, 28, 26, 63, 153, 242, 54, 226, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 68, 211, 255, 255, 255, 253, 183, 45, 0, 206, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 25, 58, 55, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'b' / 0x62
        'b' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 65, 133, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 125, 255, 5, 0, 34, 118, 150, 145, 96, 14, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 3, 134, 251, 210, 182, 203, 253, 233, 69, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 249, 119, 216, 47, 0, 0, 0, 34, 203, 247, 44, 0, 0, 0,
            ],
            &[
                0, 0, 125, 251, 234, 31, 0, 0, 0, 0, 0, 23, 241, 184, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 146, 0, 0, 0, 0, 0, 0, 0, 146, 253, 25, 0, 0],
            &[0, 0, 125, 255, 69, 0, 0, 0, 0, 0, 0, 0, 77, 255, 82, 0, 0],
            &[0, 0, 125, 255, 27, 0, 0, 0, 0, 0, 0, 0, 40, 255, 116, 0, 0],
            &[0, 0, 125, 255, 11, 0, 0, 0, 0, 0, 0, 0, 27, 255, 130, 0, 0],
            &[0, 0, 125, 255, 13, 0, 0, 0, 0, 0, 0, 0, 34, 255, 122, 0, 0],
            &[0, 0, 125, 255, 33, 0, 0, 0, 0, 0, 0, 0, 58, 255, 100, 0, 0],
            &[0, 0, 125, 255, 79, 0, 0, 0, 0, 0, 0, 0, 109, 255, 52, 0, 0],
            &[0, 0, 125, 255, 163, 0, 0, 0, 0, 0, 0, 0, 198, 228, 2, 0, 0],
            &[
                0, 0, 125, 250, 239, 57, 0, 0, 0, 0, 0, 96, 255, 115, 0, 0, 0,
            ],
            &[
                0, 0, 125, 226, 93, 240, 117, 38, 19, 48, 142, 252, 187, 5, 0, 0, 0,
            ],
            &[
                0, 0, 125, 208, 0, 82, 218, 255, 255, 255, 240, 136, 9, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 35, 61, 47, 6, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'c' / 0x63
        'c' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 14, 92, 130, 154, 140, 112, 43, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 5, 137, 247, 255, 230, 205, 217, 245, 255, 106, 0, 0, 0,
            ],
            &[0, 0, 0, 4, 192, 255, 152, 37, 0, 0, 0, 6, 77, 30, 0, 0, 0],
            &[0, 0, 0, 133, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 9, 242, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 83, 255, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 122, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 123, 255, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 76, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 7, 241, 200, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 113, 255, 141, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 2, 161, 255, 201, 99, 52, 34, 55, 87, 158, 96, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 93, 201, 255, 255, 255, 255, 253, 201, 66, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 20, 47, 62, 40, 13, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'd' / 0x64
        'd' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 113, 95, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 59, 124, 153, 145, 89, 5, 0, 216, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 20, 193, 255, 229, 186, 197, 242, 213, 30, 211, 183, 0, 0,
            ],
            &[
                0, 0, 0, 5, 211, 247, 92, 1, 0, 0, 16, 161, 189, 200, 183, 0, 0,
            ],
            &[0, 0, 0, 112, 255, 92, 0, 0, 0, 0, 0, 2, 199, 250, 183, 0, 0],
            &[0, 0, 0, 206, 216, 0, 0, 0, 0, 0, 0, 0, 84, 255, 183, 0, 0],
            &[0, 0, 19, 254, 141, 0, 0, 0, 0, 0, 0, 0, 20, 255, 183, 0, 0],
            &[0, 0, 49, 255, 99, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0],
            &[0, 0, 68, 255, 82, 0, 0, 0, 0, 0, 0, 0, 0, 222, 183, 0, 0],
            &[0, 0, 67, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0, 222, 183, 0, 0],
            &[0, 0, 50, 255, 99, 0, 0, 0, 0, 0, 0, 0, 0, 240, 183, 0, 0],
            &[0, 0, 11, 253, 145, 0, 0, 0, 0, 0, 0, 0, 30, 255, 183, 0, 0],
            &[0, 0, 0, 195, 225, 4, 0, 0, 0, 0, 0, 0, 113, 255, 183, 0, 0],
            &[
                0, 0, 0, 86, 255, 125, 0, 0, 0, 0, 0, 26, 226, 225, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 165, 255, 157, 56, 20, 31, 95, 224, 120, 173, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 3, 121, 236, 255, 255, 255, 236, 111, 0, 156, 183, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 3, 44, 63, 46, 3, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'e' / 0x65
        'e' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 6, 86, 130, 154, 132, 81, 3, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 83, 231, 252, 205, 182, 207, 254, 221, 45, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 95, 253, 174, 28, 0, 0, 0, 39, 207, 238, 27, 0, 0, 0,
            ],
            &[0, 0, 27, 241, 175, 1, 0, 0, 0, 0, 0, 23, 240, 164, 0, 0, 0],
            &[0, 0, 136, 249, 26, 0, 0, 0, 0, 0, 0, 0, 145, 246, 9, 0, 0],
            &[0, 0, 217, 182, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 62, 0, 0],
            &[
                0, 7, 255, 169, 73, 73, 73, 73, 73, 73, 73, 73, 116, 255, 86, 0, 0,
            ],
            &[
                0, 30, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99, 0, 0,
            ],
            &[0, 29, 255, 123, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0],
            &[0, 5, 254, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 208, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 120, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 219, 222, 36, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0],
            &[
                0, 0, 0, 46, 223, 242, 141, 65, 36, 25, 45, 92, 175, 210, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 17, 136, 228, 255, 255, 255, 255, 247, 181, 93, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 27, 53, 58, 32, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'f' / 0x66
        'f' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 1, 69, 134, 159, 156, 137, 95, 14, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 11, 191, 255, 226, 185, 180, 200, 241, 19, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 144, 255, 109, 2, 0, 0, 0, 1, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 232, 196, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 7, 255, 149, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 35, 53, 64, 76, 97, 255, 175, 93, 93, 93, 93, 93, 31, 0, 0, 0,
            ],
            &[
                0, 211, 252, 252, 252, 252, 255, 254, 252, 252, 252, 252, 252, 85, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 255, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'g' / 0x67
        'g' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 64, 132, 155, 139, 88, 7, 0, 53, 66, 0, 0],
            &[
                0, 0, 0, 0, 19, 190, 255, 227, 186, 194, 238, 217, 36, 166, 183, 0, 0,
            ],
            &[
                0, 0, 0, 3, 200, 243, 83, 0, 0, 0, 9, 130, 214, 205, 183, 0, 0,
            ],
            &[0, 0, 0, 103, 255, 85, 0, 0, 0, 0, 0, 0, 157, 255, 183, 0, 0],
            &[0, 0, 0, 205, 213, 0, 0, 0, 0, 0, 0, 0, 40, 255, 183, 0, 0],
            &[0, 0, 14, 254, 139, 0, 0, 0, 0, 0, 0, 0, 0, 233, 183, 0, 0],
            &[0, 0, 53, 255, 97, 0, 0, 0, 0, 0, 0, 0, 0, 205, 183, 0, 0],
            &[0, 0, 69, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 191, 183, 0, 0],
            &[0, 0, 68, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 195, 183, 0, 0],
            &[0, 0, 51, 255, 104, 0, 0, 0, 0, 0, 0, 0, 0, 221, 183, 0, 0],
            &[0, 0, 10, 252, 152, 0, 0, 0, 0, 0, 0, 0, 6, 249, 183, 0, 0],
            &[0, 0, 0, 192, 232, 8, 0, 0, 0, 0, 0, 0, 80, 255, 183, 0, 0],
            &[
                0, 0, 0, 79, 255, 138, 0, 0, 0, 0, 0, 16, 213, 228, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 155, 255, 166, 60, 21, 29, 89, 217, 144, 191, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 1, 114, 233, 255, 255, 255, 236, 123, 1, 195, 183, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 42, 62, 42, 6, 0, 0, 199, 182, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 164, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 254, 130, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 255, 50, 0, 0],
            &[0, 0, 0, 103, 106, 24, 0, 0, 0, 0, 6, 111, 251, 165, 0, 0, 0],
            &[
                0, 0, 0, 97, 238, 255, 223, 188, 178, 194, 241, 255, 156, 10, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 5, 69, 123, 151, 159, 140, 108, 31, 0, 0, 0, 0, 0,
            ],
        ],
        // letter: 'h' / 0x68
        'h' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 65, 133, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 125, 255, 19, 0, 37, 119, 153, 151, 108, 22, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 16, 130, 252, 214, 185, 213, 252, 245, 87, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 116, 216, 50, 0, 0, 0, 47, 215, 250, 43, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 224, 25, 0, 0, 0, 0, 0, 58, 255, 146, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 134, 0, 0, 0, 0, 0, 0, 0, 227, 197, 0, 0, 0],
            &[0, 0, 125, 255, 62, 0, 0, 0, 0, 0, 0, 0, 194, 215, 0, 0, 0],
            &[0, 0, 125, 255, 33, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 20, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'i' / 0x69
        'i' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 145, 254, 107, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 185, 255, 147, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 35, 109, 22, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 10, 93, 93, 93, 93, 93, 93, 34, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 21, 197, 210, 223, 235, 248, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'j' / 0x6a
        'j' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 16, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 249, 57, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 238, 255, 92, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 102, 8, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 28, 93, 93, 93, 93, 93, 93, 16, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 57, 200, 212, 225, 238, 251, 255, 45, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 45, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 34, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 243, 4, 0, 0, 0, 0],
            &[0, 0, 0, 7, 28, 0, 0, 0, 2, 117, 255, 146, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 28, 255, 229, 195, 190, 231, 255, 182, 9, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 4, 71, 119, 145, 158, 135, 66, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'k' / 0x6b
        'k' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 90, 118, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 45, 93, 40, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 49, 240, 192, 9, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 42, 235, 202, 13, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 35, 230, 211, 18, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 29, 224, 219, 24, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 224, 0, 0, 23, 217, 226, 31, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 219, 0, 18, 210, 254, 45, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 173, 212, 12, 201, 221, 249, 146, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 173, 207, 183, 212, 24, 115, 255, 79, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 173, 255, 206, 20, 0, 1, 185, 237, 28, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 173, 238, 16, 0, 0, 0, 24, 234, 193, 3, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 75, 255, 128, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 145, 252, 63, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 7, 209, 228, 19, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 42, 246, 178, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'l' / 0x6c
        'l' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 25, 133, 133, 133, 133, 133, 133, 49, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 29, 158, 171, 183, 196, 216, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'm' / 0x6d
        'm' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 35, 69, 0, 54, 138, 136, 35, 0, 1, 91, 150, 127, 22, 0, 0, 0,
            ],
            &[
                0, 97, 208, 65, 242, 215, 254, 236, 22, 142, 244, 219, 255, 217, 7, 0, 0,
            ],
            &[
                0, 97, 237, 202, 46, 0, 67, 255, 163, 227, 28, 0, 106, 255, 86, 0, 0,
            ],
            &[
                0, 97, 255, 145, 0, 0, 0, 202, 255, 104, 0, 0, 4, 244, 139, 0, 0,
            ],
            &[
                0, 97, 255, 73, 0, 0, 0, 168, 255, 28, 0, 0, 0, 218, 160, 0, 0,
            ],
            &[
                0, 97, 255, 34, 0, 0, 0, 145, 244, 0, 0, 0, 0, 199, 169, 0, 0,
            ],
            &[
                0, 97, 255, 18, 0, 0, 0, 140, 229, 0, 0, 0, 0, 197, 169, 0, 0,
            ],
            &[
                0, 97, 255, 13, 0, 0, 0, 140, 225, 0, 0, 0, 0, 197, 169, 0, 0,
            ],
            &[
                0, 97, 255, 13, 0, 0, 0, 140, 225, 0, 0, 0, 0, 197, 169, 0, 0,
            ],
            &[
                0, 97, 255, 13, 0, 0, 0, 140, 225, 0, 0, 0, 0, 197, 169, 0, 0,
            ],
            &[
                0, 97, 255, 13, 0, 0, 0, 140, 225, 0, 0, 0, 0, 197, 169, 0, 0,
            ],
            &[
                0, 97, 255, 13, 0, 0, 0, 140, 225, 0, 0, 0, 0, 197, 169, 0, 0,
            ],
            &[
                0, 97, 255, 13, 0, 0, 0, 140, 225, 0, 0, 0, 0, 197, 169, 0, 0,
            ],
            &[
                0, 97, 255, 13, 0, 0, 0, 140, 225, 0, 0, 0, 0, 197, 169, 0, 0,
            ],
            &[
                0, 97, 255, 13, 0, 0, 0, 140, 225, 0, 0, 0, 0, 197, 169, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'n' / 0x6e
        'n' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 45, 74, 0, 0, 40, 119, 152, 152, 113, 28, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 218, 1, 146, 252, 207, 183, 210, 250, 248, 98, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 239, 111, 198, 36, 0, 0, 0, 37, 205, 253, 51, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 222, 15, 0, 0, 0, 0, 0, 45, 253, 153, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 123, 0, 0, 0, 0, 0, 0, 0, 222, 201, 0, 0, 0],
            &[0, 0, 125, 255, 58, 0, 0, 0, 0, 0, 0, 0, 191, 216, 0, 0, 0],
            &[0, 0, 125, 255, 29, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'o' / 0x6f
        'o' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 107, 142, 150, 120, 52, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 3, 140, 250, 239, 191, 188, 225, 255, 188, 20, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 167, 251, 112, 5, 0, 0, 0, 74, 234, 217, 12, 0, 0, 0,
            ],
            &[0, 0, 84, 255, 108, 0, 0, 0, 0, 0, 0, 51, 252, 142, 0, 0, 0],
            &[0, 0, 191, 219, 1, 0, 0, 0, 0, 0, 0, 0, 165, 242, 7, 0, 0],
            &[0, 16, 252, 137, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 70, 0, 0],
            &[0, 46, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 41, 255, 105, 0, 0],
            &[0, 68, 255, 73, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 127, 0, 0],
            &[0, 64, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0, 30, 255, 122, 0, 0],
            &[0, 42, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 56, 255, 98, 0, 0],
            &[0, 2, 242, 167, 0, 0, 0, 0, 0, 0, 0, 0, 117, 255, 44, 0, 0],
            &[0, 0, 160, 244, 24, 0, 0, 0, 0, 0, 0, 3, 214, 212, 0, 0, 0],
            &[0, 0, 39, 247, 179, 5, 0, 0, 0, 0, 0, 132, 255, 85, 0, 0, 0],
            &[
                0, 0, 0, 90, 251, 202, 83, 33, 27, 66, 174, 255, 145, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 56, 191, 253, 255, 255, 255, 218, 94, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 19, 54, 60, 32, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'p' / 0x70
        'p' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 45, 76, 0, 0, 38, 120, 153, 147, 102, 18, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 219, 0, 131, 251, 210, 182, 200, 251, 238, 79, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 234, 95, 210, 43, 0, 0, 0, 25, 188, 250, 53, 0, 0, 0,
            ],
            &[
                0, 0, 125, 252, 224, 24, 0, 0, 0, 0, 0, 12, 231, 192, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 137, 0, 0, 0, 0, 0, 0, 0, 132, 254, 30, 0, 0],
            &[0, 0, 125, 255, 65, 0, 0, 0, 0, 0, 0, 0, 70, 255, 85, 0, 0],
            &[0, 0, 125, 255, 27, 0, 0, 0, 0, 0, 0, 0, 38, 255, 117, 0, 0],
            &[0, 0, 125, 255, 14, 0, 0, 0, 0, 0, 0, 0, 27, 255, 130, 0, 0],
            &[0, 0, 125, 255, 21, 0, 0, 0, 0, 0, 0, 0, 34, 255, 118, 0, 0],
            &[0, 0, 125, 255, 42, 0, 0, 0, 0, 0, 0, 0, 56, 255, 98, 0, 0],
            &[0, 0, 125, 255, 90, 0, 0, 0, 0, 0, 0, 0, 104, 255, 50, 0, 0],
            &[0, 0, 125, 255, 176, 0, 0, 0, 0, 0, 0, 0, 189, 232, 1, 0, 0],
            &[
                0, 0, 125, 250, 221, 71, 0, 0, 0, 0, 0, 83, 255, 114, 0, 0, 0,
            ],
            &[
                0, 0, 125, 254, 61, 241, 126, 42, 19, 44, 133, 249, 190, 5, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 10, 63, 209, 255, 255, 255, 242, 139, 8, 0, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 12, 0, 0, 33, 62, 43, 9, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 60, 122, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'q' / 0x71
        'q' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 63, 133, 155, 134, 77, 1, 0, 53, 66, 0, 0],
            &[
                0, 0, 0, 0, 18, 187, 255, 221, 183, 194, 245, 202, 23, 163, 183, 0, 0,
            ],
            &[
                0, 0, 0, 3, 199, 240, 75, 0, 0, 0, 12, 155, 196, 191, 183, 0, 0,
            ],
            &[0, 0, 0, 104, 255, 80, 0, 0, 0, 0, 0, 1, 193, 254, 183, 0, 0],
            &[0, 0, 0, 205, 211, 0, 0, 0, 0, 0, 0, 0, 79, 255, 183, 0, 0],
            &[0, 0, 14, 254, 138, 0, 0, 0, 0, 0, 0, 0, 13, 255, 183, 0, 0],
            &[0, 0, 53, 255, 97, 0, 0, 0, 0, 0, 0, 0, 0, 233, 183, 0, 0],
            &[0, 0, 69, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0],
            &[0, 0, 68, 255, 82, 0, 0, 0, 0, 0, 0, 0, 0, 223, 183, 0, 0],
            &[0, 0, 50, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 241, 183, 0, 0],
            &[0, 0, 10, 252, 150, 0, 0, 0, 0, 0, 0, 0, 33, 255, 183, 0, 0],
            &[0, 0, 0, 192, 229, 6, 0, 0, 0, 0, 0, 0, 121, 255, 183, 0, 0],
            &[
                0, 0, 0, 82, 255, 127, 0, 0, 0, 0, 0, 36, 226, 223, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 162, 254, 154, 53, 20, 35, 106, 232, 98, 206, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 3, 122, 237, 255, 255, 255, 222, 87, 0, 214, 183, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 3, 45, 61, 35, 3, 0, 0, 217, 183, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104, 87, 0, 0],
        ],
        // letter: 'r' / 0x72
        'r' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 32, 93, 93, 93, 93, 93, 7, 0, 22, 111, 146, 135, 97, 19, 0, 0,
            ],
            &[
                0, 68, 203, 218, 233, 248, 255, 30, 74, 242, 246, 213, 227, 255, 52, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 63, 255, 78, 244, 122, 8, 0, 0, 32, 1, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 218, 121, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 228, 6, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 153, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 105, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 26, 45, 58, 72, 127, 255, 139, 74, 61, 48, 35, 3, 0, 0, 0, 0,
            ],
            &[
                0, 208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 's' / 0x73
        's' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 25, 100, 143, 157, 139, 114, 52, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 111, 247, 248, 207, 189, 206, 236, 255, 172, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 255, 165, 17, 0, 0, 0, 1, 57, 54, 0, 0, 0, 0],
            &[0, 0, 0, 132, 254, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 139, 251, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 75, 255, 151, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 138, 254, 217, 110, 17, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 52, 164, 249, 247, 160, 55, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 21, 118, 218, 255, 183, 20, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 111, 249, 190, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146, 255, 22, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 34, 0, 0, 0],
            &[0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 2, 193, 239, 5, 0, 0, 0],
            &[
                0, 0, 0, 233, 167, 86, 42, 25, 39, 73, 181, 255, 111, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 116, 204, 255, 255, 255, 255, 255, 215, 91, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 16, 51, 65, 54, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 't' / 0x74
        't' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 8, 12, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 145, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 168, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 191, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 4, 47, 63, 80, 96, 228, 215, 93, 93, 93, 93, 93, 46, 0, 0,
            ],
            &[
                0, 0, 27, 252, 252, 252, 252, 255, 255, 252, 252, 252, 252, 252, 126, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 204, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 183, 228, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 125, 255, 56, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 25, 236, 228, 86, 27, 23, 52, 54, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 0, 0, 49, 202, 255, 255, 255, 255, 139, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 58, 57, 28, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'u' / 0x75
        'u' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 159, 242, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 150, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 121, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 52, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 176, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 9, 152, 249, 255, 255, 255, 226, 94, 0, 152, 183, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 10, 53, 63, 40, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'v' / 0x76
        'v' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 16, 93, 41, 0, 0, 0, 0, 0, 0, 0, 0, 24, 93, 34, 0, 0],
            &[0, 3, 231, 177, 0, 0, 0, 0, 0, 0, 0, 0, 132, 253, 31, 0, 0],
            &[0, 0, 138, 250, 20, 0, 0, 0, 0, 0, 0, 1, 224, 187, 0, 0, 0],
            &[0, 0, 41, 255, 109, 0, 0, 0, 0, 0, 0, 62, 255, 90, 0, 0, 0],
            &[0, 0, 0, 200, 203, 0, 0, 0, 0, 0, 0, 156, 239, 8, 0, 0, 0],
            &[0, 0, 0, 104, 255, 41, 0, 0, 0, 0, 8, 240, 150, 0, 0, 0, 0],
            &[0, 0, 0, 16, 247, 135, 0, 0, 0, 0, 86, 255, 53, 0, 0, 0, 0],
            &[0, 0, 0, 0, 166, 227, 2, 0, 0, 0, 179, 211, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 70, 255, 67, 0, 0, 21, 251, 113, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 226, 161, 0, 0, 110, 250, 21, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 132, 243, 11, 0, 203, 174, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 36, 255, 94, 41, 255, 76, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 195, 185, 131, 230, 3, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 98, 251, 229, 137, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 12, 244, 255, 40, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'w' / 0x77
        'w' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[36, 93, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 58, 0],
            &[65, 255, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 240, 125, 0],
            &[14, 254, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 255, 75, 0],
            &[
                0, 216, 159, 0, 0, 0, 0, 140, 183, 23, 0, 0, 0, 87, 255, 25, 0,
            ],
            &[
                0, 164, 213, 0, 0, 0, 13, 249, 252, 97, 0, 0, 0, 139, 231, 0, 0,
            ],
            &[
                0, 111, 253, 13, 0, 0, 83, 243, 167, 174, 0, 0, 0, 190, 181, 0, 0,
            ],
            &[
                0, 59, 255, 64, 0, 0, 161, 184, 98, 243, 7, 0, 1, 240, 131, 0, 0,
            ],
            &[
                0, 10, 252, 118, 0, 3, 235, 113, 28, 255, 71, 0, 36, 255, 81, 0, 0,
            ],
            &[
                0, 0, 210, 171, 0, 60, 255, 40, 0, 210, 147, 0, 87, 255, 31, 0, 0,
            ],
            &[
                0, 0, 157, 222, 0, 137, 221, 0, 0, 135, 223, 0, 136, 236, 0, 0, 0,
            ],
            &[
                0, 0, 105, 254, 10, 210, 145, 0, 0, 59, 255, 41, 178, 187, 0, 0, 0,
            ],
            &[
                0, 0, 52, 255, 67, 255, 69, 0, 0, 3, 236, 110, 212, 137, 0, 0, 0,
            ],
            &[
                0, 0, 6, 249, 155, 243, 6, 0, 0, 0, 164, 171, 240, 87, 0, 0, 0,
            ],
            &[
                0, 0, 0, 204, 236, 174, 0, 0, 0, 0, 88, 236, 255, 37, 0, 0, 0,
            ],
            &[0, 0, 0, 151, 255, 98, 0, 0, 0, 0, 17, 251, 241, 1, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'x' / 0x78
        'x' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 75, 88, 1, 0, 0, 0, 0, 0, 0, 0, 68, 90, 3, 0, 0],
            &[0, 0, 81, 255, 115, 0, 0, 0, 0, 0, 0, 63, 253, 130, 0, 0, 0],
            &[0, 0, 0, 149, 249, 48, 0, 0, 0, 0, 18, 227, 194, 3, 0, 0, 0],
            &[0, 0, 0, 8, 210, 214, 9, 0, 0, 0, 176, 236, 28, 0, 0, 0, 0],
            &[0, 0, 0, 0, 41, 245, 151, 0, 0, 106, 255, 77, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 100, 255, 78, 45, 247, 143, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 169, 235, 215, 204, 6, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 16, 244, 255, 48, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 113, 253, 242, 162, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 52, 249, 134, 83, 255, 96, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 14, 220, 200, 4, 0, 153, 244, 40, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 168, 241, 33, 0, 0, 10, 214, 210, 8, 0, 0, 0, 0],
            &[0, 0, 0, 101, 255, 89, 0, 0, 0, 0, 46, 247, 152, 0, 0, 0, 0],
            &[0, 0, 44, 246, 159, 0, 0, 0, 0, 0, 0, 108, 255, 85, 0, 0, 0],
            &[0, 10, 213, 218, 12, 0, 0, 0, 0, 0, 0, 0, 178, 240, 34, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'y' / 0x79
        'y' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 8, 93, 44, 0, 0, 0, 0, 0, 0, 0, 0, 22, 93, 35, 0, 0],
            &[0, 0, 209, 188, 0, 0, 0, 0, 0, 0, 0, 0, 124, 254, 32, 0, 0],
            &[0, 0, 108, 254, 33, 0, 0, 0, 0, 0, 0, 0, 215, 189, 0, 0, 0],
            &[0, 0, 16, 246, 131, 0, 0, 0, 0, 0, 0, 52, 255, 93, 0, 0, 0],
            &[0, 0, 0, 160, 227, 3, 0, 0, 0, 0, 0, 143, 242, 10, 0, 0, 0],
            &[0, 0, 0, 59, 255, 74, 0, 0, 0, 0, 3, 232, 156, 0, 0, 0, 0],
            &[0, 0, 0, 0, 213, 173, 0, 0, 0, 0, 71, 255, 59, 0, 0, 0, 0],
            &[0, 0, 0, 0, 111, 250, 22, 0, 0, 0, 163, 218, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 18, 247, 116, 0, 0, 11, 244, 122, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 164, 215, 0, 0, 91, 253, 28, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 62, 255, 57, 0, 181, 185, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 216, 154, 19, 251, 89, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 115, 236, 105, 240, 8, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 20, 249, 233, 152, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 167, 255, 55, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 170, 214, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 17, 248, 118, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 110, 250, 25, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 5, 225, 162, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 1, 150, 253, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 196, 176, 223, 255, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 158, 141, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'z' / 0x7a
        'z' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 60, 93, 93, 93, 93, 93, 93, 93, 93, 93, 31, 0, 0, 0],
            &[
                0, 0, 0, 150, 231, 231, 231, 231, 231, 231, 231, 244, 255, 82, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 222, 204, 6, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 242, 36, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 255, 92, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 37, 243, 161, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 6, 205, 218, 12, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 249, 50, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 71, 254, 112, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 22, 232, 180, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 1, 183, 229, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 114, 253, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 50, 249, 132, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 217, 239, 100, 96, 96, 96, 96, 96, 96, 96, 37, 0, 0, 0,
            ],
            &[
                0, 0, 56, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '{' / 0x7b
        '{' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 59, 10, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 71, 214, 255, 255, 38, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 49, 250, 202, 76, 31, 1, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 149, 248, 20, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 182, 212, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 188, 205, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 188, 205, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 188, 205, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 188, 205, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 207, 192, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 29, 247, 143, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 52, 101, 217, 220, 27, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 222, 255, 188, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 42, 87, 208, 229, 34, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 24, 246, 149, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 205, 194, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 188, 205, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 188, 205, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 188, 205, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 188, 205, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 251, 24, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 47, 249, 204, 75, 31, 2, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 67, 207, 255, 255, 38, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 54, 9, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '|' / 0x7c
        '|' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 72, 103, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 67, 95, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '}' / 0x7d
        '}' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 57, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 243, 255, 228, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 22, 57, 173, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 218, 199, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 165, 233, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 154, 239, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 154, 239, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 154, 239, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 154, 239, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 143, 251, 5, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 97, 255, 67, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 8, 201, 231, 107, 56, 2, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 11, 153, 255, 255, 17, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 7, 192, 234, 115, 61, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 93, 255, 70, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 141, 252, 5, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 154, 239, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 154, 239, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 154, 239, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 154, 239, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 161, 233, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 2, 216, 199, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 26, 68, 174, 255, 93, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 243, 255, 229, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 56, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '~' / 0x7e
        '~' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 11, 104, 118, 53, 0, 0, 0, 0, 0, 29, 131, 0, 0, 0],
            &[
                0, 0, 3, 186, 217, 170, 242, 148, 3, 0, 0, 0, 85, 220, 0, 0, 0,
            ],
            &[
                0, 0, 81, 227, 13, 0, 33, 222, 174, 8, 0, 0, 155, 154, 0, 0, 0,
            ],
            &[
                0, 0, 159, 142, 0, 0, 0, 29, 215, 202, 87, 99, 245, 51, 0, 0, 0,
            ],
            &[0, 0, 198, 97, 0, 0, 0, 0, 17, 149, 228, 228, 93, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: ' ' / 0xa0
        ' ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¡' / 0xa1
        '¡' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 82, 105, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 13, 251, 255, 52, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 3, 231, 249, 27, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 9, 18, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 31, 41, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 157, 201, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 161, 205, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 165, 210, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 170, 214, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 218, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 179, 223, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 183, 227, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 187, 232, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 192, 236, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 196, 240, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 200, 245, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 205, 249, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 253, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 212, 254, 2, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¢' / 0xa2
        '¢' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 92, 85, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 168, 156, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 11, 184, 185, 55, 27, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 55, 185, 251, 255, 255, 255, 255, 218, 42, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 99, 253, 214, 102, 41, 17, 35, 73, 147, 9, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 254, 179, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 197, 231, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 27, 255, 134, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 86, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 109, 255, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 118, 255, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 98, 255, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 64, 255, 97, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 6, 243, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 139, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 14, 211, 251, 120, 16, 0, 0, 0, 12, 84, 22, 0, 0, 0],
            &[
                0, 0, 0, 0, 17, 169, 253, 249, 221, 207, 230, 252, 252, 39, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 36, 100, 215, 210, 126, 92, 20, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 168, 149, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 168, 149, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 45, 40, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '£' / 0xa3
        '£' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 1, 67, 118, 127, 104, 41, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 30, 205, 255, 244, 222, 250, 255, 186, 7, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 2, 206, 235, 75, 1, 0, 3, 76, 138, 0, 0, 0],
            &[0, 0, 0, 0, 0, 71, 255, 104, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 131, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 154, 246, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 160, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 160, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 160, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 4, 18, 18, 167, 234, 18, 18, 18, 18, 13, 0, 0, 0, 0, 0],
            &[
                0, 0, 69, 255, 255, 255, 255, 255, 255, 255, 255, 183, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 10, 36, 36, 174, 236, 36, 36, 36, 36, 26, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 160, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 160, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 162, 231, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 180, 201, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 6, 236, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 132, 240, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 61, 197, 255, 156, 110, 110, 110, 110, 110, 110, 110, 110, 40, 0, 0,
            ],
            &[
                0, 0, 138, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 93, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¤' / 0xa4
        '¤' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 124, 51, 0, 0, 0, 1, 5, 0, 0, 0, 19, 138, 5, 0, 0],
            &[
                0, 2, 172, 239, 54, 73, 197, 244, 250, 213, 108, 26, 210, 212, 18, 0, 0,
            ],
            &[
                0, 0, 5, 178, 250, 243, 133, 65, 56, 106, 220, 250, 214, 22, 0, 0, 0,
            ],
            &[0, 0, 0, 103, 238, 42, 0, 0, 0, 0, 13, 200, 164, 0, 0, 0, 0],
            &[0, 0, 2, 229, 104, 0, 0, 0, 0, 0, 0, 42, 253, 40, 0, 0, 0],
            &[0, 0, 34, 255, 20, 0, 0, 0, 0, 0, 0, 0, 216, 97, 0, 0, 0],
            &[0, 0, 58, 253, 2, 0, 0, 0, 0, 0, 0, 0, 198, 123, 0, 0, 0],
            &[0, 0, 20, 255, 37, 0, 0, 0, 0, 0, 0, 3, 234, 85, 0, 0, 0],
            &[0, 0, 0, 194, 147, 0, 0, 0, 0, 0, 0, 92, 241, 20, 0, 0, 0],
            &[0, 0, 0, 74, 255, 114, 1, 0, 0, 0, 71, 241, 139, 0, 0, 0, 0],
            &[
                0, 0, 23, 214, 217, 236, 217, 148, 142, 196, 250, 209, 240, 52, 0, 0, 0,
            ],
            &[
                0, 0, 200, 208, 20, 16, 118, 167, 177, 134, 37, 5, 172, 238, 20, 0, 0,
            ],
            &[0, 0, 51, 18, 0, 0, 0, 0, 0, 0, 0, 0, 4, 73, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¥' / 0xa5
        '¥' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 63, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 71, 8, 0],
            &[0, 137, 250, 37, 0, 0, 0, 0, 0, 0, 0, 0, 7, 223, 193, 0, 0],
            &[0, 15, 234, 173, 0, 0, 0, 0, 0, 0, 0, 0, 117, 253, 50, 0, 0],
            &[0, 0, 106, 255, 59, 0, 0, 0, 0, 0, 0, 19, 239, 158, 0, 0, 0],
            &[0, 0, 4, 214, 199, 0, 0, 0, 0, 0, 0, 144, 243, 25, 0, 0, 0],
            &[0, 0, 0, 74, 255, 85, 0, 0, 0, 0, 36, 250, 123, 0, 0, 0, 0],
            &[0, 0, 0, 0, 186, 220, 5, 0, 0, 0, 172, 224, 8, 0, 0, 0, 0],
            &[0, 0, 0, 0, 46, 253, 111, 0, 0, 58, 255, 87, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 155, 236, 15, 0, 198, 197, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 243, 137, 85, 254, 53, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 124, 247, 225, 162, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 234, 239, 239, 242, 255, 255, 245, 239, 239, 239, 48, 0, 0, 0,
            ],
            &[
                0, 0, 0, 62, 64, 64, 64, 189, 228, 64, 64, 64, 64, 13, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 167, 219, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 32, 33, 33, 33, 179, 223, 33, 33, 33, 33, 6, 0, 0, 0,
            ],
            &[
                0, 0, 0, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 51, 0, 0, 0,
            ],
            &[
                0, 0, 0, 14, 14, 14, 14, 172, 221, 14, 14, 14, 14, 3, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 167, 219, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 167, 219, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 167, 219, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¦' / 0xa6
        '¦' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 84, 109, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 81, 105, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 71, 92, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 94, 122, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '§' / 0xa7
        '§' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 5, 78, 116, 140, 124, 100, 48, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 65, 229, 238, 182, 163, 181, 210, 254, 181, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 19, 241, 163, 8, 0, 0, 0, 0, 28, 49, 0, 0, 0, 0],
            &[0, 0, 0, 76, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 70, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 4, 206, 238, 95, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 16, 161, 255, 228, 131, 31, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 34, 198, 211, 145, 220, 253, 179, 53, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 11, 226, 144, 3, 0, 0, 56, 177, 253, 96, 0, 0, 0, 0],
            &[0, 0, 0, 91, 239, 3, 0, 0, 0, 0, 0, 151, 243, 13, 0, 0, 0],
            &[0, 0, 0, 116, 219, 0, 0, 0, 0, 0, 0, 45, 255, 48, 0, 0, 0],
            &[0, 0, 0, 73, 254, 70, 0, 0, 0, 0, 0, 59, 255, 29, 0, 0, 0],
            &[0, 0, 0, 1, 180, 252, 134, 22, 0, 0, 2, 178, 194, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 4, 112, 225, 249, 168, 88, 180, 221, 31, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 3, 78, 182, 253, 255, 101, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 172, 255, 115, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 174, 244, 3, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 255, 18, 0, 0, 0],
            &[0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 172, 224, 0, 0, 0, 0],
            &[
                0, 0, 0, 202, 159, 89, 42, 20, 33, 67, 172, 252, 78, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 82, 175, 240, 255, 255, 255, 246, 185, 66, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 18, 31, 24, 2, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¨' / 0xa8
        '¨' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 60, 121, 7, 0, 0, 0, 96, 91, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 194, 255, 67, 0, 0, 11, 252, 248, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 112, 199, 21, 0, 0, 0, 171, 161, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '©' / 0xa9
        '©' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 40, 118, 149, 157, 129, 70, 2, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 25, 183, 221, 134, 97, 92, 123, 203, 221, 60, 0, 0, 0, 0,
            ],
            &[0, 0, 33, 228, 116, 1, 0, 0, 0, 0, 0, 76, 232, 80, 0, 0, 0],
            &[
                0, 2, 205, 106, 0, 1, 107, 198, 236, 220, 124, 0, 56, 234, 27, 0, 0,
            ],
            &[
                0, 75, 201, 0, 0, 145, 203, 57, 13, 36, 59, 0, 0, 147, 131, 0, 0,
            ],
            &[0, 162, 105, 0, 37, 241, 25, 0, 0, 0, 0, 0, 0, 50, 216, 0, 0],
            &[0, 197, 63, 0, 91, 188, 0, 0, 0, 0, 0, 0, 0, 7, 247, 1, 0],
            &[0, 213, 49, 0, 115, 166, 0, 0, 0, 0, 0, 0, 0, 0, 246, 8, 0],
            &[0, 187, 76, 0, 83, 199, 0, 0, 0, 0, 0, 0, 0, 17, 236, 0, 0],
            &[0, 139, 143, 0, 19, 237, 62, 0, 0, 0, 0, 0, 0, 81, 185, 0, 0],
            &[
                0, 42, 236, 20, 0, 85, 236, 151, 110, 132, 102, 0, 2, 194, 84, 0, 0,
            ],
            &[
                0, 0, 146, 183, 8, 0, 29, 98, 131, 109, 32, 0, 133, 182, 1, 0, 0,
            ],
            &[0, 0, 6, 170, 206, 66, 1, 0, 0, 0, 46, 175, 190, 17, 0, 0, 0],
            &[
                0, 0, 0, 0, 92, 201, 230, 195, 191, 222, 210, 107, 2, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 17, 47, 49, 20, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ª' / 0xaa
        'ª' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 7, 72, 107, 114, 74, 2, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 1, 216, 197, 147, 143, 217, 199, 7, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 16, 0, 0, 0, 10, 223, 89, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 172, 125, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 31, 133, 186, 207, 217, 244, 128, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 40, 240, 138, 52, 23, 10, 170, 128, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 135, 184, 0, 0, 0, 0, 193, 128, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 130, 193, 0, 0, 0, 49, 250, 128, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 38, 241, 180, 129, 159, 194, 172, 128, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 24, 107, 125, 84, 6, 44, 49, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '«' / 0xab
        '«' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 31, 119, 2, 0, 0, 41, 112, 1, 0, 0, 0],
            &[0, 0, 0, 0, 0, 10, 208, 198, 5, 0, 16, 218, 176, 1, 0, 0, 0],
            &[0, 0, 0, 0, 0, 169, 232, 27, 0, 3, 185, 219, 15, 0, 0, 0, 0],
            &[0, 0, 0, 0, 122, 251, 63, 0, 0, 142, 245, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 76, 253, 115, 0, 0, 95, 255, 91, 0, 0, 0, 0, 0, 0],
            &[0, 0, 21, 241, 184, 0, 0, 36, 248, 162, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 1, 175, 239, 34, 0, 5, 193, 229, 23, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 12, 209, 207, 8, 0, 20, 222, 192, 4, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 32, 234, 157, 0, 0, 44, 243, 139, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 61, 250, 99, 0, 0, 78, 253, 83, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 100, 216, 5, 0, 0, 121, 206, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 9, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¬' / 0xac
        '¬' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 31, 0, 0,
            ],
            &[
                0, 0, 62, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 176, 0, 0,
            ],
            &[
                0, 0, 7, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 167, 176, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 176, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 176, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 176, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 176, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 86, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '®' / 0xae
        '®' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 40, 118, 149, 157, 129, 70, 2, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 25, 183, 221, 134, 97, 92, 123, 203, 221, 60, 0, 0, 0, 0,
            ],
            &[
                0, 0, 33, 228, 116, 16, 44, 44, 33, 4, 0, 76, 232, 80, 0, 0, 0,
            ],
            &[
                0, 2, 205, 106, 0, 84, 232, 190, 201, 231, 90, 0, 56, 234, 27, 0, 0,
            ],
            &[
                0, 75, 201, 0, 0, 84, 164, 0, 0, 43, 244, 9, 0, 147, 131, 0, 0,
            ],
            &[
                0, 162, 105, 0, 0, 84, 164, 0, 0, 0, 228, 35, 0, 50, 216, 0, 0,
            ],
            &[0, 197, 63, 0, 0, 84, 164, 0, 0, 67, 227, 5, 0, 7, 247, 1, 0],
            &[
                0, 213, 49, 0, 0, 84, 237, 204, 218, 205, 38, 0, 0, 0, 246, 8, 0,
            ],
            &[
                0, 187, 76, 0, 0, 84, 170, 16, 81, 207, 3, 0, 0, 17, 236, 0, 0,
            ],
            &[
                0, 139, 143, 0, 0, 84, 164, 0, 0, 179, 112, 0, 0, 81, 185, 0, 0,
            ],
            &[
                0, 42, 236, 20, 0, 84, 164, 0, 0, 35, 234, 26, 2, 194, 84, 0, 0,
            ],
            &[
                0, 0, 146, 183, 8, 52, 103, 0, 0, 0, 100, 89, 133, 182, 1, 0, 0,
            ],
            &[0, 0, 6, 170, 206, 66, 1, 0, 0, 0, 46, 175, 190, 17, 0, 0, 0],
            &[
                0, 0, 0, 0, 92, 201, 230, 195, 191, 222, 210, 107, 2, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 17, 47, 49, 20, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¯' / 0xaf
        '¯' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 31, 50, 50, 50, 50, 50, 50, 41, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 160, 255, 255, 255, 255, 255, 255, 211, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 15, 25, 25, 25, 25, 25, 25, 20, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '°' / 0xb0
        '°' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 50, 121, 127, 70, 1, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 145, 245, 170, 161, 231, 184, 8, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 91, 236, 35, 0, 0, 15, 201, 139, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 184, 124, 0, 0, 0, 0, 68, 234, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 207, 93, 0, 0, 0, 0, 34, 255, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 173, 145, 0, 0, 0, 0, 82, 225, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 66, 249, 80, 0, 0, 40, 222, 119, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 99, 244, 220, 208, 248, 149, 2, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 14, 73, 81, 30, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '±' / 0xb1
        '±' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 120, 151, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 184, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 184, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 184, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 184, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 1, 52, 52, 52, 52, 52, 169, 199, 52, 52, 52, 52, 52, 9, 0, 0,
            ],
            &[
                0, 7, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 44, 0, 0,
            ],
            &[
                0, 0, 16, 16, 16, 16, 16, 153, 189, 16, 16, 16, 16, 16, 2, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 147, 184, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 184, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 184, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 147, 184, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 95, 120, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 73, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 13, 0, 0,
            ],
            &[
                0, 0, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 44, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '²' / 0xb2
        '²' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 79, 204, 253, 251, 212, 83, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 61, 234, 108, 42, 27, 117, 253, 62, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 187, 149, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 177, 164, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 237, 97, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 190, 2, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 145, 220, 24, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 222, 29, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 139, 222, 30, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 139, 220, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 131, 254, 135, 107, 107, 107, 107, 107, 4, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 154, 196, 196, 196, 196, 196, 196, 196, 8, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '³' / 0xb3
        '³' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 4, 101, 204, 246, 240, 196, 68, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 102, 217, 104, 49, 42, 143, 249, 45, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 2, 3, 0, 0, 0, 0, 221, 121, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 120, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 2, 114, 243, 32, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 34, 202, 206, 237, 234, 55, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 11, 66, 69, 92, 175, 231, 46, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 179, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125, 214, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 173, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 175, 141, 83, 54, 75, 172, 247, 46, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 67, 162, 209, 230, 207, 158, 38, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '´' / 0xb4
        '´' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 14, 168, 153, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 159, 250, 63, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 98, 253, 86, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 59, 243, 93, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 142, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'µ' / 0xb5
        'µ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 180, 255, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 255, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 255, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 212, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 159, 255, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 159, 250, 152, 249, 255, 255, 255, 226, 94, 0, 152, 183, 0, 0, 0,
            ],
            &[0, 0, 159, 241, 0, 10, 53, 63, 40, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 76, 115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¶' / 0xb6
        '¶' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 25, 98, 126, 133, 133, 133, 133, 133, 133, 106, 0, 0,
            ],
            &[
                0, 0, 0, 0, 120, 251, 255, 255, 255, 255, 174, 150, 150, 182, 203, 0, 0,
            ],
            &[
                0, 0, 0, 83, 255, 255, 255, 255, 255, 255, 59, 0, 0, 79, 203, 0, 0,
            ],
            &[
                0, 0, 0, 205, 255, 255, 255, 255, 255, 255, 59, 0, 0, 79, 203, 0, 0,
            ],
            &[
                0, 0, 19, 254, 255, 255, 255, 255, 255, 255, 59, 0, 0, 79, 203, 0, 0,
            ],
            &[
                0, 0, 48, 255, 255, 255, 255, 255, 255, 255, 59, 0, 0, 79, 203, 0, 0,
            ],
            &[
                0, 0, 64, 255, 255, 255, 255, 255, 255, 255, 59, 0, 0, 79, 203, 0, 0,
            ],
            &[
                0, 0, 53, 255, 255, 255, 255, 255, 255, 255, 59, 0, 0, 79, 203, 0, 0,
            ],
            &[
                0, 0, 28, 255, 255, 255, 255, 255, 255, 255, 59, 0, 0, 79, 203, 0, 0,
            ],
            &[
                0, 0, 0, 224, 255, 255, 255, 255, 255, 255, 59, 0, 0, 79, 203, 0, 0,
            ],
            &[
                0, 0, 0, 123, 255, 255, 255, 255, 255, 255, 59, 0, 0, 79, 203, 0, 0,
            ],
            &[
                0, 0, 0, 10, 194, 255, 255, 255, 255, 255, 59, 0, 0, 79, 203, 0, 0,
            ],
            &[
                0, 0, 0, 0, 7, 104, 172, 189, 163, 240, 59, 0, 0, 79, 203, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 59, 0, 0, 79, 203, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 59, 0, 0, 79, 203, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 59, 0, 0, 79, 203, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 59, 0, 0, 79, 203, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 59, 0, 0, 79, 203, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 59, 0, 0, 79, 203, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 59, 0, 0, 79, 203, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 59, 0, 0, 79, 203, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 59, 0, 0, 79, 203, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 59, 0, 0, 79, 203, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 59, 0, 0, 79, 203, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 25, 0, 0, 34, 87, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '·' / 0xb7
        '·' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 1, 211, 237, 28, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 15, 253, 255, 64, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 104, 133, 6, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¸' / 0xb8
        '¸' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 19, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 54, 231, 7, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 179, 179, 27, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 2, 94, 155, 245, 81, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 148, 193, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 176, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 26, 165, 160, 206, 234, 46, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 11, 108, 113, 83, 10, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¹' / 0xb9
        '¹' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 20, 146, 201, 14, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 8, 120, 241, 209, 255, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 132, 225, 92, 38, 255, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 13, 8, 0, 41, 255, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 43, 255, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 43, 255, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 43, 255, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 43, 255, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 43, 255, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 43, 255, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 52, 66, 124, 255, 97, 64, 45, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 196, 196, 229, 255, 210, 196, 172, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'º' / 0xba
        'º' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 36, 101, 121, 66, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 95, 240, 163, 143, 226, 165, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 25, 245, 70, 0, 0, 31, 243, 86, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 108, 205, 0, 0, 0, 0, 154, 173, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 143, 164, 0, 0, 0, 0, 116, 207, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 142, 164, 0, 0, 0, 0, 113, 200, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 107, 204, 0, 0, 0, 0, 153, 166, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 22, 244, 67, 0, 0, 31, 240, 69, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 92, 239, 167, 157, 232, 141, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 35, 98, 106, 50, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '»' / 0xbb
        '»' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 21, 43, 0, 0, 0, 24, 34, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 139, 228, 25, 0, 0, 154, 216, 15, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 7, 203, 200, 8, 0, 12, 215, 184, 3, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 31, 236, 163, 0, 0, 42, 243, 142, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 70, 253, 119, 0, 0, 88, 255, 97, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 125, 253, 72, 0, 0, 146, 249, 54, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 133, 251, 63, 0, 0, 155, 245, 47, 0, 0, 0],
            &[0, 0, 0, 0, 0, 77, 254, 108, 0, 0, 100, 255, 88, 0, 0, 0, 0],
            &[0, 0, 0, 0, 35, 239, 154, 0, 0, 52, 248, 135, 0, 0, 0, 0, 0],
            &[0, 0, 0, 9, 208, 195, 6, 0, 19, 225, 181, 2, 0, 0, 0, 0, 0],
            &[0, 0, 0, 142, 225, 22, 0, 0, 165, 216, 15, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 18, 40, 0, 0, 0, 23, 35, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¼' / 0xbc
        '¼' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 3, 66, 32, 0, 0, 0, 0, 0, 0, 0, 46, 55, 0, 0, 0],
            &[
                0, 78, 215, 255, 116, 0, 0, 0, 0, 0, 0, 14, 237, 114, 0, 0, 0,
            ],
            &[
                113, 247, 131, 198, 116, 0, 0, 0, 0, 0, 0, 128, 229, 8, 0, 0, 0,
            ],
            &[17, 30, 0, 198, 116, 0, 0, 0, 0, 0, 19, 241, 105, 0, 0, 0, 0],
            &[0, 0, 0, 200, 116, 0, 0, 0, 0, 0, 137, 222, 5, 0, 0, 0, 0],
            &[0, 0, 0, 201, 116, 0, 0, 0, 0, 24, 245, 95, 0, 0, 0, 0, 0],
            &[0, 0, 0, 201, 116, 0, 0, 0, 0, 146, 215, 3, 0, 0, 0, 0, 0],
            &[0, 0, 0, 201, 116, 0, 0, 0, 30, 249, 86, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 204, 118, 0, 0, 0, 156, 208, 1, 0, 0, 0, 0, 0, 0],
            &[
                6, 228, 246, 255, 255, 239, 156, 37, 251, 77, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 23, 23, 41, 33, 23, 16, 165, 200, 0, 0, 0, 58, 97, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 44, 253, 68, 0, 0, 28, 238, 231, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 174, 191, 0, 0, 2, 191, 186, 231, 0, 0, 0],
            &[0, 0, 0, 0, 0, 52, 254, 58, 0, 0, 118, 198, 80, 231, 0, 0, 0],
            &[0, 0, 0, 0, 0, 184, 181, 0, 0, 50, 237, 35, 79, 231, 0, 0, 0],
            &[0, 0, 0, 0, 61, 254, 50, 0, 10, 215, 99, 0, 79, 231, 0, 0, 0],
            &[
                0, 0, 0, 0, 193, 172, 0, 0, 143, 232, 110, 109, 155, 242, 109, 45, 0,
            ],
            &[
                0, 0, 0, 70, 253, 42, 0, 0, 122, 166, 166, 166, 194, 247, 166, 69, 0,
            ],
            &[0, 0, 0, 202, 163, 0, 0, 0, 0, 0, 0, 0, 79, 231, 0, 0, 0],
            &[0, 0, 79, 251, 35, 0, 0, 0, 0, 0, 0, 0, 79, 231, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '½' / 0xbd
        '½' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 3, 66, 32, 0, 0, 0, 0, 0, 0, 0, 46, 55, 0, 0, 0],
            &[
                0, 78, 215, 255, 116, 0, 0, 0, 0, 0, 0, 14, 237, 114, 0, 0, 0,
            ],
            &[
                113, 247, 131, 198, 116, 0, 0, 0, 0, 0, 0, 128, 229, 8, 0, 0, 0,
            ],
            &[17, 30, 0, 198, 116, 0, 0, 0, 0, 0, 19, 241, 105, 0, 0, 0, 0],
            &[0, 0, 0, 200, 116, 0, 0, 0, 0, 0, 137, 222, 5, 0, 0, 0, 0],
            &[0, 0, 0, 201, 116, 0, 0, 0, 0, 24, 245, 95, 0, 0, 0, 0, 0],
            &[0, 0, 0, 201, 116, 0, 0, 0, 0, 146, 215, 3, 0, 0, 0, 0, 0],
            &[0, 0, 0, 201, 116, 0, 0, 0, 30, 249, 86, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 204, 118, 0, 0, 0, 156, 208, 1, 0, 0, 0, 0, 0, 0],
            &[
                6, 228, 246, 255, 255, 239, 156, 37, 251, 77, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 23, 23, 41, 33, 23, 16, 165, 200, 0, 38, 111, 138, 95, 5, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 0, 44, 253, 68, 80, 244, 176, 145, 226, 189, 2, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 174, 191, 0, 13, 44, 0, 0, 62, 255, 47, 0],
            &[0, 0, 0, 0, 0, 52, 254, 58, 0, 0, 0, 0, 0, 28, 255, 44, 0],
            &[0, 0, 0, 0, 0, 184, 181, 0, 0, 0, 0, 0, 0, 136, 214, 1, 0],
            &[0, 0, 0, 0, 61, 254, 50, 0, 0, 0, 0, 0, 91, 242, 47, 0, 0],
            &[0, 0, 0, 0, 193, 172, 0, 0, 0, 0, 0, 86, 241, 63, 0, 0, 0],
            &[0, 0, 0, 70, 253, 42, 0, 0, 0, 0, 88, 240, 64, 0, 0, 0, 0],
            &[
                0, 0, 0, 202, 163, 0, 0, 0, 0, 90, 249, 107, 48, 48, 48, 23, 0,
            ],
            &[
                0, 0, 79, 251, 35, 0, 0, 0, 0, 209, 255, 255, 255, 255, 255, 127, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¾' / 0xbe
        '¾' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 11, 82, 121, 106, 27, 0, 0, 0, 0, 0, 0, 46, 55, 0, 0, 0],
            &[
                22, 232, 211, 164, 213, 246, 52, 0, 0, 0, 0, 14, 237, 114, 0, 0, 0,
            ],
            &[0, 46, 0, 0, 0, 197, 156, 0, 0, 0, 0, 128, 229, 8, 0, 0, 0],
            &[0, 0, 0, 0, 0, 192, 153, 0, 0, 0, 19, 241, 105, 0, 0, 0, 0],
            &[0, 7, 85, 97, 166, 210, 36, 0, 0, 0, 137, 222, 5, 0, 0, 0, 0],
            &[
                0, 15, 183, 192, 234, 193, 36, 0, 0, 24, 245, 95, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 4, 181, 189, 0, 0, 146, 215, 3, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 119, 220, 0, 30, 249, 86, 0, 0, 0, 0, 0, 0],
            &[36, 58, 1, 0, 28, 213, 161, 0, 156, 208, 1, 0, 0, 0, 0, 0, 0],
            &[
                58, 242, 246, 227, 252, 185, 20, 37, 251, 77, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 7, 44, 55, 25, 0, 0, 165, 200, 0, 0, 0, 58, 97, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 44, 253, 68, 0, 0, 28, 238, 231, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 174, 191, 0, 0, 2, 191, 186, 231, 0, 0, 0],
            &[0, 0, 0, 0, 0, 52, 254, 58, 0, 0, 118, 198, 80, 231, 0, 0, 0],
            &[0, 0, 0, 0, 0, 184, 181, 0, 0, 50, 237, 35, 79, 231, 0, 0, 0],
            &[0, 0, 0, 0, 61, 254, 50, 0, 10, 215, 99, 0, 79, 231, 0, 0, 0],
            &[
                0, 0, 0, 0, 193, 172, 0, 0, 143, 232, 110, 109, 155, 242, 109, 45, 0,
            ],
            &[
                0, 0, 0, 70, 253, 42, 0, 0, 122, 166, 166, 166, 194, 247, 166, 69, 0,
            ],
            &[0, 0, 0, 202, 163, 0, 0, 0, 0, 0, 0, 0, 79, 231, 0, 0, 0],
            &[0, 0, 79, 251, 35, 0, 0, 0, 0, 0, 0, 0, 79, 231, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '¿' / 0xbf
        '¿' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 39, 122, 26, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 175, 255, 142, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 144, 255, 110, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 9, 52, 12, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 54, 255, 50, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 84, 255, 23, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 189, 216, 1, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 3, 148, 254, 79, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 12, 179, 249, 87, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 25, 209, 232, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 1, 198, 234, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 74, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 140, 245, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 160, 227, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 139, 253, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 68, 255, 130, 0, 0, 0, 0, 0, 0, 9, 1, 0, 0, 0],
            &[
                0, 0, 0, 0, 171, 254, 168, 71, 38, 41, 79, 156, 241, 68, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 5, 122, 230, 255, 255, 255, 255, 228, 141, 38, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 37, 60, 57, 30, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'À' / 0xc0
        'À' => &[
            &[0, 0, 0, 0, 0, 131, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 157, 243, 41, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 2, 157, 217, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 1, 129, 117, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 70, 88, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 12, 245, 255, 53, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 91, 253, 231, 142, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 180, 199, 146, 229, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 19, 250, 119, 61, 255, 65, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 255, 32, 1, 228, 154, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 192, 200, 0, 0, 142, 237, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 253, 112, 0, 0, 55, 255, 77, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 115, 253, 26, 0, 0, 0, 223, 166, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 204, 193, 0, 0, 0, 0, 137, 244, 11, 0, 0, 0, 0],
            &[0, 0, 0, 38, 255, 105, 0, 0, 0, 0, 50, 255, 88, 0, 0, 0, 0],
            &[
                0, 0, 0, 126, 255, 33, 11, 11, 11, 11, 12, 227, 178, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 216, 255, 255, 255, 255, 255, 255, 255, 255, 250, 17, 0, 0, 0,
            ],
            &[
                0, 0, 49, 255, 194, 98, 98, 98, 98, 98, 98, 142, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 138, 249, 17, 0, 0, 0, 0, 0, 0, 0, 213, 189, 0, 0, 0],
            &[0, 1, 226, 179, 0, 0, 0, 0, 0, 0, 0, 0, 126, 253, 25, 0, 0],
            &[0, 61, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 112, 0, 0],
            &[0, 150, 246, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 201, 0, 0],
            &[4, 235, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 35, 0],
            &[73, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 255, 124, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 20, 151, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Á' / 0xc1
        'Á' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 250, 61, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 101, 253, 86, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 60, 244, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 166, 77, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 70, 88, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 12, 245, 255, 53, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 91, 253, 231, 142, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 180, 199, 146, 229, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 19, 250, 119, 61, 255, 65, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 255, 32, 1, 228, 154, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 192, 200, 0, 0, 142, 237, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 253, 112, 0, 0, 55, 255, 77, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 115, 253, 26, 0, 0, 0, 223, 166, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 204, 193, 0, 0, 0, 0, 137, 244, 11, 0, 0, 0, 0],
            &[0, 0, 0, 38, 255, 105, 0, 0, 0, 0, 50, 255, 88, 0, 0, 0, 0],
            &[
                0, 0, 0, 126, 255, 33, 11, 11, 11, 11, 12, 227, 178, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 216, 255, 255, 255, 255, 255, 255, 255, 255, 250, 17, 0, 0, 0,
            ],
            &[
                0, 0, 49, 255, 194, 98, 98, 98, 98, 98, 98, 142, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 138, 249, 17, 0, 0, 0, 0, 0, 0, 0, 213, 189, 0, 0, 0],
            &[0, 1, 226, 179, 0, 0, 0, 0, 0, 0, 0, 0, 126, 253, 25, 0, 0],
            &[0, 61, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 112, 0, 0],
            &[0, 150, 246, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 201, 0, 0],
            &[4, 235, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 35, 0],
            &[73, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 255, 124, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 150, 127, 0, 0, 0, 0, 0],
        ],
        // letter: 'Â' / 0xc2
        'Â' => &[
            &[0, 0, 0, 0, 0, 0, 97, 252, 241, 157, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 246, 104, 61, 247, 100, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 226, 122, 0, 0, 77, 242, 65, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 134, 112, 0, 0, 0, 0, 71, 169, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 70, 88, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 12, 245, 255, 53, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 91, 253, 231, 142, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 180, 199, 146, 229, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 19, 250, 119, 61, 255, 65, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 255, 32, 1, 228, 154, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 192, 200, 0, 0, 142, 237, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 253, 112, 0, 0, 55, 255, 77, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 115, 253, 26, 0, 0, 0, 223, 166, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 204, 193, 0, 0, 0, 0, 137, 244, 11, 0, 0, 0, 0],
            &[0, 0, 0, 38, 255, 105, 0, 0, 0, 0, 50, 255, 88, 0, 0, 0, 0],
            &[
                0, 0, 0, 126, 255, 33, 11, 11, 11, 11, 12, 227, 178, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 216, 255, 255, 255, 255, 255, 255, 255, 255, 250, 17, 0, 0, 0,
            ],
            &[
                0, 0, 49, 255, 194, 98, 98, 98, 98, 98, 98, 142, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 138, 249, 17, 0, 0, 0, 0, 0, 0, 0, 213, 189, 0, 0, 0],
            &[0, 1, 226, 179, 0, 0, 0, 0, 0, 0, 0, 0, 126, 253, 25, 0, 0],
            &[0, 61, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 112, 0, 0],
            &[0, 150, 246, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 201, 0, 0],
            &[4, 235, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 35, 0],
            &[73, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 255, 124, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 120, 143, 13, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ã' / 0xc3
        'Ã' => &[
            &[0, 0, 0, 0, 6, 90, 103, 30, 0, 0, 0, 45, 90, 0, 0, 0, 0],
            &[
                0, 0, 0, 1, 194, 245, 228, 246, 112, 1, 0, 158, 131, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 71, 220, 15, 0, 91, 238, 225, 219, 236, 24, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 65, 83, 0, 0, 0, 23, 110, 120, 29, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 70, 88, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 12, 245, 255, 53, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 91, 253, 231, 142, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 180, 199, 146, 229, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 19, 250, 119, 61, 255, 65, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 255, 32, 1, 228, 154, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 192, 200, 0, 0, 142, 237, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 253, 112, 0, 0, 55, 255, 77, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 115, 253, 26, 0, 0, 0, 223, 166, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 204, 193, 0, 0, 0, 0, 137, 244, 11, 0, 0, 0, 0],
            &[0, 0, 0, 38, 255, 105, 0, 0, 0, 0, 50, 255, 88, 0, 0, 0, 0],
            &[
                0, 0, 0, 126, 255, 33, 11, 11, 11, 11, 12, 227, 178, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 216, 255, 255, 255, 255, 255, 255, 255, 255, 250, 17, 0, 0, 0,
            ],
            &[
                0, 0, 49, 255, 194, 98, 98, 98, 98, 98, 98, 142, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 138, 249, 17, 0, 0, 0, 0, 0, 0, 0, 213, 189, 0, 0, 0],
            &[0, 1, 226, 179, 0, 0, 0, 0, 0, 0, 0, 0, 126, 253, 25, 0, 0],
            &[0, 61, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 112, 0, 0],
            &[0, 150, 246, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 201, 0, 0],
            &[4, 235, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 35, 0],
            &[73, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 255, 124, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ä' / 0xc4
        'Ä' => &[
            &[0, 0, 0, 0, 46, 99, 4, 0, 0, 0, 76, 72, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 192, 255, 64, 0, 0, 10, 250, 245, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 129, 221, 27, 0, 0, 0, 193, 182, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 70, 88, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 12, 245, 255, 53, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 91, 253, 231, 142, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 180, 199, 146, 229, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 19, 250, 119, 61, 255, 65, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 255, 32, 1, 228, 154, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 192, 200, 0, 0, 142, 237, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 253, 112, 0, 0, 55, 255, 77, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 115, 253, 26, 0, 0, 0, 223, 166, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 204, 193, 0, 0, 0, 0, 137, 244, 11, 0, 0, 0, 0],
            &[0, 0, 0, 38, 255, 105, 0, 0, 0, 0, 50, 255, 88, 0, 0, 0, 0],
            &[
                0, 0, 0, 126, 255, 33, 11, 11, 11, 11, 12, 227, 178, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 216, 255, 255, 255, 255, 255, 255, 255, 255, 250, 17, 0, 0, 0,
            ],
            &[
                0, 0, 49, 255, 194, 98, 98, 98, 98, 98, 98, 142, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 138, 249, 17, 0, 0, 0, 0, 0, 0, 0, 213, 189, 0, 0, 0],
            &[0, 1, 226, 179, 0, 0, 0, 0, 0, 0, 0, 0, 126, 253, 25, 0, 0],
            &[0, 61, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 112, 0, 0],
            &[0, 150, 246, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 201, 0, 0],
            &[4, 235, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 35, 0],
            &[73, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 255, 124, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Å' / 0xc5
        'Å' => &[
            &[0, 0, 0, 0, 0, 170, 106, 0, 0, 55, 221, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 161, 125, 0, 0, 74, 210, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 60, 241, 126, 111, 227, 99, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 48, 140, 146, 67, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 70, 88, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 12, 245, 255, 53, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 91, 253, 231, 142, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 180, 199, 146, 229, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 19, 250, 119, 61, 255, 65, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 255, 32, 1, 228, 154, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 192, 200, 0, 0, 142, 237, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 253, 112, 0, 0, 55, 255, 77, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 115, 253, 26, 0, 0, 0, 223, 166, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 204, 193, 0, 0, 0, 0, 137, 244, 11, 0, 0, 0, 0],
            &[0, 0, 0, 38, 255, 105, 0, 0, 0, 0, 50, 255, 88, 0, 0, 0, 0],
            &[
                0, 0, 0, 126, 255, 33, 11, 11, 11, 11, 12, 227, 178, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 216, 255, 255, 255, 255, 255, 255, 255, 255, 250, 17, 0, 0, 0,
            ],
            &[
                0, 0, 49, 255, 194, 98, 98, 98, 98, 98, 98, 142, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 138, 249, 17, 0, 0, 0, 0, 0, 0, 0, 213, 189, 0, 0, 0],
            &[0, 1, 226, 179, 0, 0, 0, 0, 0, 0, 0, 0, 126, 253, 25, 0, 0],
            &[0, 61, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 112, 0, 0],
            &[0, 150, 246, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 201, 0, 0],
            &[4, 235, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 35, 0],
            &[73, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 255, 124, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 92, 220, 57, 41, 190, 138, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Æ' / 0xc6
        'Æ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 64, 71, 71, 71, 71, 71, 71, 71, 71, 16, 0],
            &[
                0, 0, 0, 0, 0, 25, 254, 255, 255, 255, 255, 255, 255, 255, 255, 58, 0,
            ],
            &[
                0, 0, 0, 0, 0, 98, 253, 47, 251, 151, 32, 32, 32, 32, 32, 7, 0,
            ],
            &[0, 0, 0, 0, 0, 173, 202, 0, 251, 135, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 5, 241, 129, 0, 251, 135, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 65, 255, 57, 0, 251, 135, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 139, 237, 3, 0, 251, 135, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 213, 167, 0, 0, 251, 135, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 32, 255, 95, 0, 0, 251, 135, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 106, 254, 23, 0, 0, 251, 235, 211, 211, 211, 211, 162, 0, 0,
            ],
            &[
                0, 0, 0, 180, 205, 0, 0, 0, 251, 205, 147, 147, 147, 147, 113, 0, 0,
            ],
            &[0, 0, 8, 247, 144, 11, 11, 11, 255, 135, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 73, 255, 255, 255, 255, 255, 255, 135, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 147, 255, 88, 84, 84, 84, 255, 135, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 221, 170, 0, 0, 0, 0, 251, 135, 0, 0, 0, 0, 0, 0, 0],
            &[0, 39, 255, 98, 0, 0, 0, 0, 251, 135, 0, 0, 0, 0, 0, 0, 0],
            &[0, 113, 255, 26, 0, 0, 0, 0, 251, 135, 0, 0, 0, 0, 0, 0, 0],
            &[0, 188, 208, 0, 0, 0, 0, 0, 251, 135, 0, 0, 0, 0, 0, 0, 0],
            &[
                12, 249, 136, 0, 0, 0, 0, 0, 251, 187, 110, 110, 110, 110, 110, 25, 0,
            ],
            &[
                80, 255, 63, 0, 0, 0, 0, 0, 251, 255, 255, 255, 255, 255, 255, 58, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ç' / 0xc7
        'Ç' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 33, 98, 124, 130, 104, 73, 14, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 48, 193, 255, 254, 235, 229, 253, 255, 249, 133, 0, 0,
            ],
            &[
                0, 0, 0, 0, 84, 250, 228, 100, 17, 0, 0, 4, 45, 129, 89, 0, 0,
            ],
            &[0, 0, 0, 55, 251, 199, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 234, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 73, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 164, 248, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 220, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 9, 255, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 26, 255, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 37, 255, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 20, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 2, 253, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 218, 204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 149, 253, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 74, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 240, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 56, 249, 224, 39, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0],
            &[
                0, 0, 0, 0, 79, 245, 252, 165, 95, 62, 64, 92, 138, 212, 65, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 35, 162, 245, 255, 255, 255, 255, 242, 173, 32, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 4, 132, 255, 54, 30, 4, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 1, 212, 152, 19, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 12, 100, 171, 240, 54, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 158, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 203, 141, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 50, 161, 163, 217, 219, 26, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 24, 112, 110, 75, 4, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'È' / 0xc8
        'È' => &[
            &[0, 0, 0, 0, 0, 79, 253, 146, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 103, 254, 84, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 106, 241, 47, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 90, 157, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 60, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 121, 32, 32, 32, 32, 32, 32, 32, 32, 27, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 229, 211, 211, 211, 211, 211, 211, 211, 211, 65, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 191, 147, 147, 147, 147, 147, 147, 147, 147, 45, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 168, 110, 110, 110, 110, 110, 110, 110, 110, 93, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 138, 147, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'É' / 0xc9
        'É' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 255, 111, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 53, 248, 139, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 26, 227, 145, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 130, 117, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 60, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 121, 32, 32, 32, 32, 32, 32, 32, 32, 27, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 229, 211, 211, 211, 211, 211, 211, 211, 211, 65, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 191, 147, 147, 147, 147, 147, 147, 147, 147, 45, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 168, 110, 110, 110, 110, 110, 110, 110, 110, 93, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 133, 148, 11, 0, 0, 0, 0],
        ],
        // letter: 'Ê' / 0xca
        'Ê' => &[
            &[0, 0, 0, 0, 0, 0, 48, 249, 238, 206, 6, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 19, 222, 158, 28, 226, 156, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 7, 192, 173, 4, 0, 40, 230, 114, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 94, 147, 4, 0, 0, 0, 36, 178, 33, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 60, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 121, 32, 32, 32, 32, 32, 32, 32, 32, 27, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 229, 211, 211, 211, 211, 211, 211, 211, 211, 65, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 191, 147, 147, 147, 147, 147, 147, 147, 147, 45, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 168, 110, 110, 110, 110, 110, 110, 110, 110, 93, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 89, 145, 42, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ë' / 0xcb
        'Ë' => &[
            &[0, 0, 0, 0, 25, 106, 18, 0, 0, 0, 49, 96, 1, 0, 0, 0, 0],
            &[0, 0, 0, 0, 136, 255, 119, 0, 0, 0, 205, 255, 49, 0, 0, 0, 0],
            &[0, 0, 0, 0, 82, 228, 67, 0, 0, 0, 140, 218, 17, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 60, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 121, 32, 32, 32, 32, 32, 32, 32, 32, 27, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 229, 211, 211, 211, 211, 211, 211, 211, 211, 65, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 191, 147, 147, 147, 147, 147, 147, 147, 147, 45, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 168, 110, 110, 110, 110, 110, 110, 110, 110, 93, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ì' / 0xcc
        'Ì' => &[
            &[0, 0, 0, 0, 0, 131, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 157, 243, 41, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 2, 157, 217, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 1, 129, 117, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 25, 71, 71, 71, 71, 71, 71, 71, 71, 39, 0, 0, 0, 0],
            &[
                0, 0, 0, 76, 225, 240, 253, 255, 255, 254, 243, 228, 120, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 177, 227, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 10, 40, 55, 70, 200, 235, 73, 58, 43, 17, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 90, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 20, 151, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Í' / 0xcd
        'Í' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 250, 61, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 101, 253, 86, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 60, 244, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 166, 77, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 25, 71, 71, 71, 71, 71, 71, 71, 71, 39, 0, 0, 0, 0],
            &[
                0, 0, 0, 76, 225, 240, 253, 255, 255, 254, 243, 228, 120, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 177, 227, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 10, 40, 55, 70, 200, 235, 73, 58, 43, 17, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 90, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 150, 127, 0, 0, 0, 0, 0],
        ],
        // letter: 'Î' / 0xce
        'Î' => &[
            &[0, 0, 0, 0, 0, 0, 97, 252, 241, 157, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 246, 104, 61, 247, 100, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 226, 122, 0, 0, 77, 242, 65, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 134, 112, 0, 0, 0, 0, 71, 169, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 25, 71, 71, 71, 71, 71, 71, 71, 71, 39, 0, 0, 0, 0],
            &[
                0, 0, 0, 76, 225, 240, 253, 255, 255, 254, 243, 228, 120, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 177, 227, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 10, 40, 55, 70, 200, 235, 73, 58, 43, 17, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 90, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 120, 143, 13, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ï' / 0xcf
        'Ï' => &[
            &[0, 0, 0, 0, 46, 99, 4, 0, 0, 0, 76, 72, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 192, 255, 64, 0, 0, 10, 250, 245, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 129, 221, 27, 0, 0, 0, 193, 182, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 25, 71, 71, 71, 71, 71, 71, 71, 71, 39, 0, 0, 0, 0],
            &[
                0, 0, 0, 76, 225, 240, 253, 255, 255, 254, 243, 228, 120, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 177, 227, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 10, 40, 55, 70, 200, 235, 73, 58, 43, 17, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 90, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ð' / 0xd0
        'Ð' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 34, 71, 71, 71, 70, 61, 34, 1, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 125, 255, 255, 255, 255, 255, 255, 234, 148, 29, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 43, 25, 28, 52, 84, 168, 248, 241, 79, 0, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 39, 217, 251, 63, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 21, 236, 220, 6, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 101, 255, 89, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 12, 249, 172, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 190, 229, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 155, 254, 8, 0],
            &[
                101, 101, 226, 255, 120, 101, 101, 67, 0, 0, 0, 0, 0, 135, 255, 23, 0,
            ],
            &[
                251, 251, 255, 255, 255, 251, 251, 167, 0, 0, 0, 0, 0, 126, 255, 26, 0,
            ],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 140, 255, 15, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 167, 243, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 218, 198, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 45, 255, 129, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 163, 252, 34, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 92, 255, 148, 0, 0, 0],
            &[
                0, 0, 125, 255, 19, 0, 0, 0, 0, 14, 133, 253, 200, 9, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 115, 103, 111, 130, 178, 242, 255, 163, 13, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 255, 255, 253, 239, 205, 143, 48, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ñ' / 0xd1
        'Ñ' => &[
            &[0, 0, 0, 0, 1, 80, 108, 41, 0, 0, 0, 27, 108, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 161, 250, 223, 252, 136, 6, 0, 124, 166, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 37, 239, 29, 0, 69, 226, 233, 210, 246, 48, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 46, 103, 0, 0, 0, 13, 102, 125, 42, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 71, 19, 0, 0, 0, 0, 0, 0, 0, 39, 70, 0, 0, 0],
            &[0, 0, 194, 255, 151, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[0, 0, 194, 239, 249, 28, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[
                0, 0, 194, 164, 228, 147, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 171, 110, 247, 25, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 183, 9, 232, 142, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 189, 0, 115, 245, 22, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 11, 235, 137, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 121, 243, 19, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 13, 238, 132, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 127, 241, 16, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 16, 241, 127, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 132, 238, 14, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 19, 243, 122, 0, 139, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 138, 236, 12, 135, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 22, 246, 117, 128, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 143, 233, 129, 252, 0, 0, 0,
            ],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 26, 248, 220, 252, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 149, 255, 252, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 30, 250, 252, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ò' / 0xd2
        'Ò' => &[
            &[0, 0, 0, 0, 0, 131, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 157, 243, 41, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 2, 157, 217, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 1, 129, 117, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 17, 94, 135, 136, 107, 31, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 105, 244, 255, 238, 223, 250, 254, 153, 9, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 103, 255, 180, 39, 0, 0, 14, 122, 251, 178, 1, 0, 0, 0,
            ],
            &[0, 0, 38, 252, 178, 1, 0, 0, 0, 0, 0, 99, 255, 101, 0, 0, 0],
            &[0, 0, 158, 247, 20, 0, 0, 0, 0, 0, 0, 0, 201, 223, 1, 0, 0],
            &[0, 6, 247, 161, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 55, 0, 0],
            &[0, 58, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 122, 0, 0],
            &[0, 113, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 164, 0, 0],
            &[0, 135, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 195, 0, 0],
            &[0, 152, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 207, 0, 0],
            &[0, 162, 245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 213, 0, 0],
            &[0, 151, 255, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 202, 0, 0],
            &[0, 134, 255, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 185, 0, 0],
            &[0, 96, 255, 58, 0, 0, 0, 0, 0, 0, 0, 0, 8, 251, 147, 0, 0],
            &[0, 47, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 53, 255, 99, 0, 0],
            &[0, 0, 228, 196, 0, 0, 0, 0, 0, 0, 0, 0, 136, 255, 27, 0, 0],
            &[0, 0, 128, 255, 56, 0, 0, 0, 0, 0, 0, 15, 234, 182, 0, 0, 0],
            &[0, 0, 17, 230, 225, 25, 0, 0, 0, 0, 5, 177, 250, 52, 0, 0, 0],
            &[
                0, 0, 0, 59, 242, 239, 122, 67, 56, 98, 213, 253, 104, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 39, 179, 252, 255, 255, 255, 202, 70, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 18, 51, 57, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 20, 151, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ó' / 0xd3
        'Ó' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 250, 61, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 101, 253, 86, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 60, 244, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 166, 77, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 17, 94, 135, 136, 107, 31, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 105, 244, 255, 238, 223, 250, 254, 153, 9, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 103, 255, 180, 39, 0, 0, 14, 122, 251, 178, 1, 0, 0, 0,
            ],
            &[0, 0, 38, 252, 178, 1, 0, 0, 0, 0, 0, 99, 255, 101, 0, 0, 0],
            &[0, 0, 158, 247, 20, 0, 0, 0, 0, 0, 0, 0, 201, 223, 1, 0, 0],
            &[0, 6, 247, 161, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 55, 0, 0],
            &[0, 58, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 122, 0, 0],
            &[0, 113, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 164, 0, 0],
            &[0, 135, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 195, 0, 0],
            &[0, 152, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 207, 0, 0],
            &[0, 162, 245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 213, 0, 0],
            &[0, 151, 255, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 202, 0, 0],
            &[0, 134, 255, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 185, 0, 0],
            &[0, 96, 255, 58, 0, 0, 0, 0, 0, 0, 0, 0, 8, 251, 147, 0, 0],
            &[0, 47, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 53, 255, 99, 0, 0],
            &[0, 0, 228, 196, 0, 0, 0, 0, 0, 0, 0, 0, 136, 255, 27, 0, 0],
            &[0, 0, 128, 255, 56, 0, 0, 0, 0, 0, 0, 15, 234, 182, 0, 0, 0],
            &[0, 0, 17, 230, 225, 25, 0, 0, 0, 0, 5, 177, 250, 52, 0, 0, 0],
            &[
                0, 0, 0, 59, 242, 239, 122, 67, 56, 98, 213, 253, 104, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 39, 179, 252, 255, 255, 255, 202, 70, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 18, 51, 57, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 150, 127, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ô' / 0xd4
        'Ô' => &[
            &[0, 0, 0, 0, 0, 0, 97, 252, 241, 157, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 246, 104, 61, 247, 100, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 226, 122, 0, 0, 77, 242, 65, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 134, 112, 0, 0, 0, 0, 71, 169, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 17, 94, 135, 136, 107, 31, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 105, 244, 255, 238, 223, 250, 254, 153, 9, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 103, 255, 180, 39, 0, 0, 14, 122, 251, 178, 1, 0, 0, 0,
            ],
            &[0, 0, 38, 252, 178, 1, 0, 0, 0, 0, 0, 99, 255, 101, 0, 0, 0],
            &[0, 0, 158, 247, 20, 0, 0, 0, 0, 0, 0, 0, 201, 223, 1, 0, 0],
            &[0, 6, 247, 161, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 55, 0, 0],
            &[0, 58, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 122, 0, 0],
            &[0, 113, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 164, 0, 0],
            &[0, 135, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 195, 0, 0],
            &[0, 152, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 207, 0, 0],
            &[0, 162, 245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 213, 0, 0],
            &[0, 151, 255, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 202, 0, 0],
            &[0, 134, 255, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 185, 0, 0],
            &[0, 96, 255, 58, 0, 0, 0, 0, 0, 0, 0, 0, 8, 251, 147, 0, 0],
            &[0, 47, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 53, 255, 99, 0, 0],
            &[0, 0, 228, 196, 0, 0, 0, 0, 0, 0, 0, 0, 136, 255, 27, 0, 0],
            &[0, 0, 128, 255, 56, 0, 0, 0, 0, 0, 0, 15, 234, 182, 0, 0, 0],
            &[0, 0, 17, 230, 225, 25, 0, 0, 0, 0, 5, 177, 250, 52, 0, 0, 0],
            &[
                0, 0, 0, 59, 242, 239, 122, 67, 56, 98, 213, 253, 104, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 39, 179, 252, 255, 255, 255, 202, 70, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 18, 51, 57, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 120, 143, 13, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Õ' / 0xd5
        'Õ' => &[
            &[0, 0, 0, 0, 6, 90, 103, 30, 0, 0, 0, 45, 90, 0, 0, 0, 0],
            &[
                0, 0, 0, 1, 194, 245, 228, 246, 112, 1, 0, 158, 131, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 71, 220, 15, 0, 91, 238, 225, 219, 236, 24, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 65, 83, 0, 0, 0, 23, 110, 120, 29, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 17, 94, 135, 136, 107, 31, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 105, 244, 255, 238, 223, 250, 254, 153, 9, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 103, 255, 180, 39, 0, 0, 14, 122, 251, 178, 1, 0, 0, 0,
            ],
            &[0, 0, 38, 252, 178, 1, 0, 0, 0, 0, 0, 99, 255, 101, 0, 0, 0],
            &[0, 0, 158, 247, 20, 0, 0, 0, 0, 0, 0, 0, 201, 223, 1, 0, 0],
            &[0, 6, 247, 161, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 55, 0, 0],
            &[0, 58, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 122, 0, 0],
            &[0, 113, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 164, 0, 0],
            &[0, 135, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 195, 0, 0],
            &[0, 152, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 207, 0, 0],
            &[0, 162, 245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 213, 0, 0],
            &[0, 151, 255, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 202, 0, 0],
            &[0, 134, 255, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 185, 0, 0],
            &[0, 96, 255, 58, 0, 0, 0, 0, 0, 0, 0, 0, 8, 251, 147, 0, 0],
            &[0, 47, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 53, 255, 99, 0, 0],
            &[0, 0, 228, 196, 0, 0, 0, 0, 0, 0, 0, 0, 136, 255, 27, 0, 0],
            &[0, 0, 128, 255, 56, 0, 0, 0, 0, 0, 0, 15, 234, 182, 0, 0, 0],
            &[0, 0, 17, 230, 225, 25, 0, 0, 0, 0, 5, 177, 250, 52, 0, 0, 0],
            &[
                0, 0, 0, 59, 242, 239, 122, 67, 56, 98, 213, 253, 104, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 39, 179, 252, 255, 255, 255, 202, 70, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 18, 51, 57, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ö' / 0xd6
        'Ö' => &[
            &[0, 0, 0, 0, 46, 99, 4, 0, 0, 0, 76, 72, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 192, 255, 64, 0, 0, 10, 250, 245, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 129, 221, 27, 0, 0, 0, 193, 182, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 17, 94, 135, 136, 107, 31, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 105, 244, 255, 238, 223, 250, 254, 153, 9, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 103, 255, 180, 39, 0, 0, 14, 122, 251, 178, 1, 0, 0, 0,
            ],
            &[0, 0, 38, 252, 178, 1, 0, 0, 0, 0, 0, 99, 255, 101, 0, 0, 0],
            &[0, 0, 158, 247, 20, 0, 0, 0, 0, 0, 0, 0, 201, 223, 1, 0, 0],
            &[0, 6, 247, 161, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 55, 0, 0],
            &[0, 58, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 122, 0, 0],
            &[0, 113, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 164, 0, 0],
            &[0, 135, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 195, 0, 0],
            &[0, 152, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 207, 0, 0],
            &[0, 162, 245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 213, 0, 0],
            &[0, 151, 255, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 202, 0, 0],
            &[0, 134, 255, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 185, 0, 0],
            &[0, 96, 255, 58, 0, 0, 0, 0, 0, 0, 0, 0, 8, 251, 147, 0, 0],
            &[0, 47, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 53, 255, 99, 0, 0],
            &[0, 0, 228, 196, 0, 0, 0, 0, 0, 0, 0, 0, 136, 255, 27, 0, 0],
            &[0, 0, 128, 255, 56, 0, 0, 0, 0, 0, 0, 15, 234, 182, 0, 0, 0],
            &[0, 0, 17, 230, 225, 25, 0, 0, 0, 0, 5, 177, 250, 52, 0, 0, 0],
            &[
                0, 0, 0, 59, 242, 239, 122, 67, 56, 98, 213, 253, 104, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 39, 179, 252, 255, 255, 255, 202, 70, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 18, 51, 57, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '×' / 0xd7
        '×' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 1, 26, 0, 0, 0, 0, 0, 0, 0, 0, 13, 15, 0, 0, 0],
            &[0, 0, 109, 229, 37, 0, 0, 0, 0, 0, 0, 13, 197, 166, 0, 0, 0],
            &[0, 0, 8, 185, 228, 36, 0, 0, 0, 0, 13, 197, 219, 27, 0, 0, 0],
            &[0, 0, 0, 8, 185, 228, 36, 0, 0, 13, 197, 220, 28, 0, 0, 0, 0],
            &[0, 0, 0, 0, 8, 185, 227, 35, 13, 197, 220, 28, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 8, 185, 226, 199, 221, 29, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 21, 244, 255, 68, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 13, 197, 222, 192, 229, 38, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 13, 197, 222, 30, 9, 188, 229, 38, 0, 0, 0, 0, 0],
            &[0, 0, 0, 13, 197, 222, 30, 0, 0, 9, 186, 229, 38, 0, 0, 0, 0],
            &[0, 0, 13, 197, 222, 30, 0, 0, 0, 0, 8, 184, 229, 38, 0, 0, 0],
            &[0, 0, 102, 222, 30, 0, 0, 0, 0, 0, 0, 7, 181, 162, 0, 0, 0],
            &[0, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0, 0, 7, 8, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ø' / 0xd8
        'Ø' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 17, 94, 135, 136, 107, 31, 0, 19, 214, 49, 0, 0,
            ],
            &[
                0, 0, 0, 0, 105, 244, 255, 238, 223, 250, 254, 153, 157, 226, 9, 0, 0,
            ],
            &[
                0, 0, 0, 103, 255, 180, 39, 0, 0, 14, 122, 255, 255, 92, 0, 0, 0,
            ],
            &[0, 0, 38, 252, 178, 1, 0, 0, 0, 0, 0, 255, 255, 102, 0, 0, 0],
            &[
                0, 0, 158, 247, 20, 0, 0, 0, 0, 0, 76, 254, 255, 223, 1, 0, 0,
            ],
            &[
                0, 6, 247, 161, 0, 0, 0, 0, 0, 5, 216, 164, 100, 255, 55, 0, 0,
            ],
            &[
                0, 58, 255, 91, 0, 0, 0, 0, 0, 112, 245, 28, 31, 255, 122, 0, 0,
            ],
            &[
                0, 113, 255, 41, 0, 0, 0, 0, 19, 239, 128, 0, 0, 242, 164, 0, 0,
            ],
            &[
                0, 135, 255, 12, 0, 0, 0, 0, 149, 227, 10, 0, 0, 211, 195, 0, 0,
            ],
            &[
                0, 152, 252, 0, 0, 0, 0, 43, 252, 92, 0, 0, 0, 198, 207, 0, 0,
            ],
            &[
                0, 162, 245, 0, 0, 0, 0, 186, 200, 1, 0, 0, 0, 193, 213, 0, 0,
            ],
            &[
                0, 151, 255, 3, 0, 0, 76, 254, 57, 0, 0, 0, 0, 206, 202, 0, 0,
            ],
            &[
                0, 134, 255, 18, 0, 5, 217, 166, 0, 0, 0, 0, 0, 221, 185, 0, 0,
            ],
            &[
                0, 96, 255, 58, 0, 113, 246, 29, 0, 0, 0, 0, 8, 251, 147, 0, 0,
            ],
            &[
                0, 47, 255, 110, 20, 239, 129, 0, 0, 0, 0, 0, 53, 255, 99, 0, 0,
            ],
            &[
                0, 0, 228, 196, 150, 228, 11, 0, 0, 0, 0, 0, 136, 255, 27, 0, 0,
            ],
            &[
                0, 0, 128, 255, 255, 93, 0, 0, 0, 0, 0, 15, 234, 182, 0, 0, 0,
            ],
            &[0, 0, 17, 255, 255, 26, 0, 0, 0, 0, 5, 177, 250, 52, 0, 0, 0],
            &[
                0, 0, 77, 255, 255, 239, 122, 67, 56, 98, 213, 253, 104, 0, 0, 0, 0,
            ],
            &[
                0, 5, 217, 167, 39, 179, 252, 255, 255, 255, 202, 70, 0, 0, 0, 0, 0,
            ],
            &[0, 20, 170, 30, 0, 0, 18, 51, 57, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ù' / 0xd9
        'Ù' => &[
            &[0, 0, 0, 0, 0, 131, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 157, 243, 41, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 2, 157, 217, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 1, 129, 117, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 187, 214, 0, 0, 0, 0, 0, 0, 0, 0, 156, 245, 0, 0, 0],
            &[0, 0, 169, 231, 0, 0, 0, 0, 0, 0, 0, 0, 174, 226, 0, 0, 0],
            &[0, 0, 136, 255, 21, 0, 0, 0, 0, 0, 0, 0, 221, 191, 0, 0, 0],
            &[0, 0, 73, 255, 98, 0, 0, 0, 0, 0, 0, 47, 255, 123, 0, 0, 0],
            &[0, 0, 5, 219, 223, 23, 0, 0, 0, 0, 8, 193, 243, 25, 0, 0, 0],
            &[
                0, 0, 0, 68, 247, 224, 108, 58, 54, 97, 208, 253, 99, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 59, 195, 255, 255, 255, 255, 205, 77, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 53, 55, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 20, 151, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ú' / 0xda
        'Ú' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 250, 61, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 101, 253, 86, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 60, 244, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 166, 77, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 187, 214, 0, 0, 0, 0, 0, 0, 0, 0, 156, 245, 0, 0, 0],
            &[0, 0, 169, 231, 0, 0, 0, 0, 0, 0, 0, 0, 174, 226, 0, 0, 0],
            &[0, 0, 136, 255, 21, 0, 0, 0, 0, 0, 0, 0, 221, 191, 0, 0, 0],
            &[0, 0, 73, 255, 98, 0, 0, 0, 0, 0, 0, 47, 255, 123, 0, 0, 0],
            &[0, 0, 5, 219, 223, 23, 0, 0, 0, 0, 8, 193, 243, 25, 0, 0, 0],
            &[
                0, 0, 0, 68, 247, 224, 108, 58, 54, 97, 208, 253, 99, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 59, 195, 255, 255, 255, 255, 205, 77, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 53, 55, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 150, 127, 0, 0, 0, 0, 0],
        ],
        // letter: 'Û' / 0xdb
        'Û' => &[
            &[0, 0, 0, 0, 0, 0, 97, 252, 241, 157, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 246, 104, 61, 247, 100, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 226, 122, 0, 0, 77, 242, 65, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 134, 112, 0, 0, 0, 0, 71, 169, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 187, 214, 0, 0, 0, 0, 0, 0, 0, 0, 156, 245, 0, 0, 0],
            &[0, 0, 169, 231, 0, 0, 0, 0, 0, 0, 0, 0, 174, 226, 0, 0, 0],
            &[0, 0, 136, 255, 21, 0, 0, 0, 0, 0, 0, 0, 221, 191, 0, 0, 0],
            &[0, 0, 73, 255, 98, 0, 0, 0, 0, 0, 0, 47, 255, 123, 0, 0, 0],
            &[0, 0, 5, 219, 223, 23, 0, 0, 0, 0, 8, 193, 243, 25, 0, 0, 0],
            &[
                0, 0, 0, 68, 247, 224, 108, 58, 54, 97, 208, 253, 99, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 59, 195, 255, 255, 255, 255, 205, 77, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 53, 55, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 120, 143, 13, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ü' / 0xdc
        'Ü' => &[
            &[0, 0, 0, 0, 46, 99, 4, 0, 0, 0, 76, 72, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 192, 255, 64, 0, 0, 10, 250, 245, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 129, 221, 27, 0, 0, 0, 193, 182, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 187, 214, 0, 0, 0, 0, 0, 0, 0, 0, 156, 245, 0, 0, 0],
            &[0, 0, 169, 231, 0, 0, 0, 0, 0, 0, 0, 0, 174, 226, 0, 0, 0],
            &[0, 0, 136, 255, 21, 0, 0, 0, 0, 0, 0, 0, 221, 191, 0, 0, 0],
            &[0, 0, 73, 255, 98, 0, 0, 0, 0, 0, 0, 47, 255, 123, 0, 0, 0],
            &[0, 0, 5, 219, 223, 23, 0, 0, 0, 0, 8, 193, 243, 25, 0, 0, 0],
            &[
                0, 0, 0, 68, 247, 224, 108, 58, 54, 97, 208, 253, 99, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 59, 195, 255, 255, 255, 255, 205, 77, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 53, 55, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ý' / 0xdd
        'Ý' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 250, 61, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 101, 253, 86, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 60, 244, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 166, 77, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 54, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 69, 1, 0],
            &[0, 110, 255, 71, 0, 0, 0, 0, 0, 0, 0, 0, 18, 242, 168, 0, 0],
            &[0, 7, 225, 198, 0, 0, 0, 0, 0, 0, 0, 0, 131, 252, 39, 0, 0],
            &[0, 0, 98, 255, 71, 0, 0, 0, 0, 0, 0, 17, 241, 157, 0, 0, 0],
            &[0, 0, 3, 216, 198, 0, 0, 0, 0, 0, 0, 129, 249, 31, 0, 0, 0],
            &[0, 0, 0, 85, 255, 71, 0, 0, 0, 0, 15, 240, 146, 0, 0, 0, 0],
            &[0, 0, 0, 1, 206, 198, 0, 0, 0, 0, 126, 245, 23, 0, 0, 0, 0],
            &[0, 0, 0, 0, 73, 255, 71, 0, 0, 14, 238, 135, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 195, 198, 0, 0, 123, 240, 17, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 61, 255, 71, 13, 237, 124, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 183, 198, 121, 234, 12, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 50, 254, 247, 113, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 183, 239, 8, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 150, 127, 0, 0, 0, 0, 0],
        ],
        // letter: 'Þ' / 0xde
        'Þ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 71, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 195, 155, 155, 155, 149, 133, 92, 24, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 220, 197, 197, 197, 204, 229, 255, 251, 151, 9, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 32, 152, 255, 173, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 154, 255, 58, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 40, 255, 132, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 1, 252, 160, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 6, 254, 151, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 46, 255, 115, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 160, 252, 29, 0, 0],
            &[
                0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 18, 147, 255, 131, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 188, 143, 143, 146, 161, 196, 248, 250, 129, 1, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 231, 215, 215, 213, 196, 174, 113, 31, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ß' / 0xdf
        'ß' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 55, 126, 154, 159, 135, 72, 2, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 17, 182, 255, 235, 191, 190, 226, 255, 206, 26, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 183, 251, 102, 3, 0, 0, 1, 88, 251, 184, 0, 0, 0, 0],
            &[0, 0, 48, 255, 132, 0, 0, 0, 0, 0, 0, 165, 253, 7, 0, 0, 0],
            &[0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 151, 255, 12, 0, 0, 0],
            &[0, 0, 128, 255, 11, 0, 0, 0, 0, 0, 14, 225, 196, 0, 0, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 0, 0, 23, 199, 235, 34, 0, 0, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 0, 35, 229, 213, 35, 0, 0, 0, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 1, 213, 218, 19, 0, 0, 0, 0, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 32, 255, 123, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 10, 250, 146, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 0, 157, 253, 106, 0, 0, 0, 0, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 0, 5, 165, 255, 174, 16, 0, 0, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 0, 0, 0, 100, 246, 221, 44, 0, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 0, 0, 0, 0, 45, 225, 224, 18, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 0, 0, 0, 0, 0, 47, 253, 140, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 0, 0, 0, 0, 0, 0, 214, 195, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 0, 0, 0, 0, 0, 0, 200, 199, 0, 0],
            &[0, 0, 132, 255, 5, 0, 0, 0, 0, 0, 0, 0, 28, 246, 151, 0, 0],
            &[
                0, 0, 132, 255, 5, 0, 154, 141, 69, 34, 28, 77, 211, 242, 38, 0, 0,
            ],
            &[
                0, 0, 132, 255, 5, 0, 97, 222, 255, 255, 255, 255, 201, 52, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 24, 53, 58, 26, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'à' / 0xe0
        'à' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 5, 161, 162, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 81, 253, 141, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 103, 253, 80, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 104, 240, 46, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 85, 130, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 66, 124, 151, 156, 134, 76, 4, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 84, 225, 255, 228, 195, 189, 224, 255, 214, 37, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 141, 39, 0, 0, 0, 0, 72, 237, 211, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 255, 62, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 255, 110, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 250, 126, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 16, 54, 79, 93, 102, 110, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 4, 99, 205, 253, 253, 232, 213, 203, 193, 253, 127, 0, 0, 0,
            ],
            &[0, 0, 7, 183, 251, 151, 59, 8, 0, 0, 0, 0, 245, 127, 0, 0, 0],
            &[0, 0, 112, 255, 76, 0, 0, 0, 0, 0, 0, 3, 252, 127, 0, 0, 0],
            &[0, 0, 186, 204, 0, 0, 0, 0, 0, 0, 0, 36, 255, 127, 0, 0, 0],
            &[0, 0, 201, 186, 0, 0, 0, 0, 0, 0, 0, 131, 255, 127, 0, 0, 0],
            &[
                0, 0, 158, 237, 19, 0, 0, 0, 0, 0, 67, 227, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 47, 248, 205, 76, 28, 26, 63, 153, 242, 54, 226, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 68, 211, 255, 255, 255, 253, 183, 45, 0, 206, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 25, 58, 55, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'á' / 0xe1
        'á' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 164, 159, 4, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 253, 75, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 84, 254, 98, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 49, 241, 105, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 133, 82, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 66, 124, 151, 156, 134, 76, 4, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 84, 225, 255, 228, 195, 189, 224, 255, 214, 37, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 141, 39, 0, 0, 0, 0, 72, 237, 211, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 255, 62, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 255, 110, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 250, 126, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 16, 54, 79, 93, 102, 110, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 4, 99, 205, 253, 253, 232, 213, 203, 193, 253, 127, 0, 0, 0,
            ],
            &[0, 0, 7, 183, 251, 151, 59, 8, 0, 0, 0, 0, 245, 127, 0, 0, 0],
            &[0, 0, 112, 255, 76, 0, 0, 0, 0, 0, 0, 3, 252, 127, 0, 0, 0],
            &[0, 0, 186, 204, 0, 0, 0, 0, 0, 0, 0, 36, 255, 127, 0, 0, 0],
            &[0, 0, 201, 186, 0, 0, 0, 0, 0, 0, 0, 131, 255, 127, 0, 0, 0],
            &[
                0, 0, 158, 237, 19, 0, 0, 0, 0, 0, 67, 227, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 47, 248, 205, 76, 28, 26, 63, 153, 242, 54, 226, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 68, 211, 255, 255, 255, 253, 183, 45, 0, 206, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 25, 58, 55, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'â' / 0xe2
        'â' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 121, 167, 40, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 79, 254, 227, 202, 5, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 39, 240, 119, 28, 226, 153, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 20, 218, 135, 0, 0, 40, 229, 112, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 101, 113, 0, 0, 0, 0, 35, 159, 22, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 66, 124, 151, 156, 134, 76, 4, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 84, 225, 255, 228, 195, 189, 224, 255, 214, 37, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 141, 39, 0, 0, 0, 0, 72, 237, 211, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 255, 62, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 255, 110, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 250, 126, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 16, 54, 79, 93, 102, 110, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 4, 99, 205, 253, 253, 232, 213, 203, 193, 253, 127, 0, 0, 0,
            ],
            &[0, 0, 7, 183, 251, 151, 59, 8, 0, 0, 0, 0, 245, 127, 0, 0, 0],
            &[0, 0, 112, 255, 76, 0, 0, 0, 0, 0, 0, 3, 252, 127, 0, 0, 0],
            &[0, 0, 186, 204, 0, 0, 0, 0, 0, 0, 0, 36, 255, 127, 0, 0, 0],
            &[0, 0, 201, 186, 0, 0, 0, 0, 0, 0, 0, 131, 255, 127, 0, 0, 0],
            &[
                0, 0, 158, 237, 19, 0, 0, 0, 0, 0, 67, 227, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 47, 248, 205, 76, 28, 26, 63, 153, 242, 54, 226, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 68, 211, 255, 255, 255, 253, 183, 45, 0, 206, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 25, 58, 55, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ã' / 0xe3
        'ã' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 5, 102, 130, 59, 0, 0, 0, 33, 125, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 178, 240, 201, 251, 158, 14, 2, 140, 159, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 43, 235, 17, 0, 50, 212, 247, 230, 238, 38, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 40, 86, 0, 0, 0, 6, 80, 103, 28, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 66, 124, 151, 156, 134, 76, 4, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 84, 225, 255, 228, 195, 189, 224, 255, 214, 37, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 141, 39, 0, 0, 0, 0, 72, 237, 211, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 255, 62, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 255, 110, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 250, 126, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 16, 54, 79, 93, 102, 110, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 4, 99, 205, 253, 253, 232, 213, 203, 193, 253, 127, 0, 0, 0,
            ],
            &[0, 0, 7, 183, 251, 151, 59, 8, 0, 0, 0, 0, 245, 127, 0, 0, 0],
            &[0, 0, 112, 255, 76, 0, 0, 0, 0, 0, 0, 3, 252, 127, 0, 0, 0],
            &[0, 0, 186, 204, 0, 0, 0, 0, 0, 0, 0, 36, 255, 127, 0, 0, 0],
            &[0, 0, 201, 186, 0, 0, 0, 0, 0, 0, 0, 131, 255, 127, 0, 0, 0],
            &[
                0, 0, 158, 237, 19, 0, 0, 0, 0, 0, 67, 227, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 47, 248, 205, 76, 28, 26, 63, 153, 242, 54, 226, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 68, 211, 255, 255, 255, 253, 183, 45, 0, 206, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 25, 58, 55, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ä' / 0xe4
        'ä' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 43, 127, 18, 0, 0, 0, 76, 111, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 159, 255, 101, 0, 0, 0, 229, 255, 30, 0, 0, 0, 0],
            &[0, 0, 0, 0, 85, 204, 43, 0, 0, 0, 140, 187, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 66, 124, 151, 156, 134, 76, 4, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 84, 225, 255, 228, 195, 189, 224, 255, 214, 37, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 141, 39, 0, 0, 0, 0, 72, 237, 211, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 255, 62, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 255, 110, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 250, 126, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 16, 54, 79, 93, 102, 110, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 4, 99, 205, 253, 253, 232, 213, 203, 193, 253, 127, 0, 0, 0,
            ],
            &[0, 0, 7, 183, 251, 151, 59, 8, 0, 0, 0, 0, 245, 127, 0, 0, 0],
            &[0, 0, 112, 255, 76, 0, 0, 0, 0, 0, 0, 3, 252, 127, 0, 0, 0],
            &[0, 0, 186, 204, 0, 0, 0, 0, 0, 0, 0, 36, 255, 127, 0, 0, 0],
            &[0, 0, 201, 186, 0, 0, 0, 0, 0, 0, 0, 131, 255, 127, 0, 0, 0],
            &[
                0, 0, 158, 237, 19, 0, 0, 0, 0, 0, 67, 227, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 47, 248, 205, 76, 28, 26, 63, 153, 242, 54, 226, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 68, 211, 255, 255, 255, 253, 183, 45, 0, 206, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 25, 58, 55, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'å' / 0xe5
        'å' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 104, 219, 235, 168, 23, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 69, 230, 49, 13, 147, 185, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 138, 137, 0, 0, 17, 252, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 122, 168, 0, 0, 48, 239, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 26, 232, 161, 127, 225, 115, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 20, 112, 128, 62, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 66, 124, 151, 156, 134, 76, 4, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 84, 225, 255, 228, 195, 189, 224, 255, 214, 37, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 141, 39, 0, 0, 0, 0, 72, 237, 211, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 255, 62, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 255, 110, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 250, 126, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 16, 54, 79, 93, 102, 110, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 4, 99, 205, 253, 253, 232, 213, 203, 193, 253, 127, 0, 0, 0,
            ],
            &[0, 0, 7, 183, 251, 151, 59, 8, 0, 0, 0, 0, 245, 127, 0, 0, 0],
            &[0, 0, 112, 255, 76, 0, 0, 0, 0, 0, 0, 3, 252, 127, 0, 0, 0],
            &[0, 0, 186, 204, 0, 0, 0, 0, 0, 0, 0, 36, 255, 127, 0, 0, 0],
            &[0, 0, 201, 186, 0, 0, 0, 0, 0, 0, 0, 131, 255, 127, 0, 0, 0],
            &[
                0, 0, 158, 237, 19, 0, 0, 0, 0, 0, 67, 227, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 47, 248, 205, 76, 28, 26, 63, 153, 242, 54, 226, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 68, 211, 255, 255, 255, 253, 183, 45, 0, 206, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 25, 58, 55, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'æ' / 0xe6
        'æ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 19, 101, 145, 138, 63, 0, 0, 2, 93, 149, 127, 27, 0, 0, 0,
            ],
            &[
                0, 65, 242, 237, 191, 213, 255, 116, 1, 176, 247, 193, 231, 239, 38, 0, 0,
            ],
            &[
                0, 17, 108, 6, 0, 0, 123, 248, 101, 232, 33, 0, 12, 212, 182, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 6, 237, 243, 102, 0, 0, 0, 97, 253, 21, 0],
            &[0, 0, 0, 0, 0, 0, 0, 201, 252, 15, 0, 0, 0, 38, 255, 72, 0],
            &[0, 0, 0, 0, 0, 0, 0, 182, 223, 0, 0, 0, 0, 9, 255, 101, 0],
            &[
                0, 0, 0, 0, 32, 64, 78, 206, 214, 80, 80, 80, 80, 81, 255, 115, 0,
            ],
            &[
                0, 0, 97, 220, 255, 250, 227, 245, 252, 243, 243, 243, 243, 243, 243, 114, 0,
            ],
            &[0, 112, 255, 168, 51, 6, 0, 188, 185, 0, 0, 0, 0, 0, 0, 0, 0],
            &[8, 239, 173, 0, 0, 0, 0, 191, 200, 0, 0, 0, 0, 0, 0, 0, 0],
            &[49, 255, 80, 0, 0, 0, 0, 210, 239, 1, 0, 0, 0, 0, 0, 0, 0],
            &[58, 255, 57, 0, 0, 0, 12, 250, 250, 50, 0, 0, 0, 0, 0, 0, 0],
            &[
                26, 255, 103, 0, 0, 0, 115, 192, 165, 172, 0, 0, 0, 0, 1, 0, 0,
            ],
            &[
                0, 191, 228, 65, 26, 105, 247, 67, 43, 244, 160, 45, 26, 76, 202, 9, 0,
            ],
            &[
                0, 36, 211, 255, 255, 240, 97, 0, 0, 69, 224, 255, 255, 252, 161, 3, 0,
            ],
            &[0, 0, 2, 41, 50, 10, 0, 0, 0, 0, 5, 42, 55, 18, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ç' / 0xe7
        'ç' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 14, 92, 130, 154, 140, 112, 43, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 5, 137, 247, 255, 230, 205, 217, 245, 255, 106, 0, 0, 0,
            ],
            &[0, 0, 0, 4, 192, 255, 152, 37, 0, 0, 0, 6, 77, 30, 0, 0, 0],
            &[0, 0, 0, 133, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 9, 242, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 83, 255, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 122, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 123, 255, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 76, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 7, 241, 200, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 113, 255, 141, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 2, 161, 255, 201, 99, 52, 34, 55, 87, 158, 96, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 93, 201, 255, 255, 255, 255, 253, 201, 66, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 20, 240, 162, 40, 13, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 61, 251, 71, 1, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 48, 120, 218, 187, 4, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 55, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 255, 37, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 118, 157, 176, 243, 143, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 66, 118, 99, 43, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'è' / 0xe8
        'è' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 8, 164, 159, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 87, 254, 134, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 110, 253, 74, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 110, 238, 42, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 89, 126, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 6, 86, 130, 154, 132, 81, 3, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 83, 231, 252, 205, 182, 207, 254, 221, 45, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 95, 253, 174, 28, 0, 0, 0, 39, 207, 238, 27, 0, 0, 0,
            ],
            &[0, 0, 27, 241, 175, 1, 0, 0, 0, 0, 0, 23, 240, 164, 0, 0, 0],
            &[0, 0, 136, 249, 26, 0, 0, 0, 0, 0, 0, 0, 145, 246, 9, 0, 0],
            &[0, 0, 217, 182, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 62, 0, 0],
            &[
                0, 7, 255, 169, 73, 73, 73, 73, 73, 73, 73, 73, 116, 255, 86, 0, 0,
            ],
            &[
                0, 30, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99, 0, 0,
            ],
            &[0, 29, 255, 123, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0],
            &[0, 5, 254, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 208, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 120, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 219, 222, 36, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0],
            &[
                0, 0, 0, 46, 223, 242, 141, 65, 36, 25, 45, 92, 175, 210, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 17, 136, 228, 255, 255, 255, 255, 247, 181, 93, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 27, 53, 58, 32, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'é' / 0xe9
        'é' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 166, 156, 2, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 251, 69, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 91, 253, 92, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 54, 242, 99, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 138, 78, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 6, 86, 130, 154, 132, 81, 3, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 83, 231, 252, 205, 182, 207, 254, 221, 45, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 95, 253, 174, 28, 0, 0, 0, 39, 207, 238, 27, 0, 0, 0,
            ],
            &[0, 0, 27, 241, 175, 1, 0, 0, 0, 0, 0, 23, 240, 164, 0, 0, 0],
            &[0, 0, 136, 249, 26, 0, 0, 0, 0, 0, 0, 0, 145, 246, 9, 0, 0],
            &[0, 0, 217, 182, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 62, 0, 0],
            &[
                0, 7, 255, 169, 73, 73, 73, 73, 73, 73, 73, 73, 116, 255, 86, 0, 0,
            ],
            &[
                0, 30, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99, 0, 0,
            ],
            &[0, 29, 255, 123, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0],
            &[0, 5, 254, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 208, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 120, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 219, 222, 36, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0],
            &[
                0, 0, 0, 46, 223, 242, 141, 65, 36, 25, 45, 92, 175, 210, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 17, 136, 228, 255, 255, 255, 255, 247, 181, 93, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 27, 53, 58, 32, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ê' / 0xea
        'ê' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 125, 167, 35, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 86, 253, 228, 196, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 43, 243, 112, 31, 229, 146, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 23, 222, 128, 0, 0, 44, 232, 106, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 106, 109, 0, 0, 0, 0, 39, 159, 18, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 6, 86, 130, 154, 132, 81, 3, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 83, 231, 252, 205, 182, 207, 254, 221, 45, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 95, 253, 174, 28, 0, 0, 0, 39, 207, 238, 27, 0, 0, 0,
            ],
            &[0, 0, 27, 241, 175, 1, 0, 0, 0, 0, 0, 23, 240, 164, 0, 0, 0],
            &[0, 0, 136, 249, 26, 0, 0, 0, 0, 0, 0, 0, 145, 246, 9, 0, 0],
            &[0, 0, 217, 182, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 62, 0, 0],
            &[
                0, 7, 255, 169, 73, 73, 73, 73, 73, 73, 73, 73, 116, 255, 86, 0, 0,
            ],
            &[
                0, 30, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99, 0, 0,
            ],
            &[0, 29, 255, 123, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0],
            &[0, 5, 254, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 208, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 120, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 219, 222, 36, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0],
            &[
                0, 0, 0, 46, 223, 242, 141, 65, 36, 25, 45, 92, 175, 210, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 17, 136, 228, 255, 255, 255, 255, 247, 181, 93, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 27, 53, 58, 32, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ë' / 0xeb
        'ë' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 47, 126, 16, 0, 0, 0, 79, 107, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 166, 255, 94, 0, 0, 0, 236, 255, 24, 0, 0, 0, 0],
            &[0, 0, 0, 0, 91, 203, 39, 0, 0, 0, 146, 183, 1, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 6, 86, 130, 154, 132, 81, 3, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 83, 231, 252, 205, 182, 207, 254, 221, 45, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 95, 253, 174, 28, 0, 0, 0, 39, 207, 238, 27, 0, 0, 0,
            ],
            &[0, 0, 27, 241, 175, 1, 0, 0, 0, 0, 0, 23, 240, 164, 0, 0, 0],
            &[0, 0, 136, 249, 26, 0, 0, 0, 0, 0, 0, 0, 145, 246, 9, 0, 0],
            &[0, 0, 217, 182, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 62, 0, 0],
            &[
                0, 7, 255, 169, 73, 73, 73, 73, 73, 73, 73, 73, 116, 255, 86, 0, 0,
            ],
            &[
                0, 30, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99, 0, 0,
            ],
            &[0, 29, 255, 123, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0],
            &[0, 5, 254, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 208, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 120, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 219, 222, 36, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0],
            &[
                0, 0, 0, 46, 223, 242, 141, 65, 36, 25, 45, 92, 175, 210, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 17, 136, 228, 255, 255, 255, 255, 247, 181, 93, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 27, 53, 58, 32, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ì' / 0xec
        'ì' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 20, 171, 146, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 113, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 137, 248, 52, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 136, 227, 27, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 107, 108, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 10, 93, 93, 93, 93, 93, 93, 34, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 21, 197, 210, 223, 235, 248, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'í' / 0xed
        'í' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 172, 140, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 244, 48, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 118, 248, 70, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 75, 243, 77, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 151, 60, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 10, 93, 93, 93, 93, 93, 93, 34, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 21, 197, 210, 223, 235, 248, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'î' / 0xee
        'î' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 1, 142, 165, 20, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 113, 248, 233, 172, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 249, 86, 47, 241, 118, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 38, 234, 102, 0, 0, 61, 240, 80, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 124, 91, 0, 0, 0, 0, 55, 154, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 10, 93, 93, 93, 93, 93, 93, 34, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 21, 197, 210, 223, 235, 248, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ï' / 0xef
        'ï' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 60, 121, 7, 0, 0, 0, 96, 91, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 194, 255, 67, 0, 0, 11, 252, 248, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 112, 199, 21, 0, 0, 0, 171, 161, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 10, 93, 93, 93, 93, 93, 93, 34, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 21, 197, 210, 223, 235, 248, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ð' / 0xf0
        'ð' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 69, 0, 0, 0, 0, 12, 39, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 101, 253, 184, 33, 0, 92, 230, 184, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 46, 203, 255, 255, 242, 118, 6, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 19, 157, 255, 255, 108, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 3, 107, 238, 206, 59, 132, 249, 62, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 6, 187, 103, 2, 0, 0, 163, 226, 16, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 224, 148, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85, 249, 31, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 42, 122, 153, 159, 131, 58, 2, 218, 132, 0, 0, 0,
            ],
            &[
                0, 0, 0, 17, 174, 255, 229, 183, 169, 197, 251, 184, 145, 222, 0, 0, 0,
            ],
            &[
                0, 0, 8, 207, 238, 85, 2, 0, 0, 0, 27, 183, 242, 255, 32, 0, 0,
            ],
            &[0, 0, 132, 253, 61, 0, 0, 0, 0, 0, 0, 4, 208, 255, 84, 0, 0],
            &[0, 4, 231, 178, 0, 0, 0, 0, 0, 0, 0, 0, 88, 255, 113, 0, 0],
            &[0, 39, 255, 105, 0, 0, 0, 0, 0, 0, 0, 0, 28, 255, 129, 0, 0],
            &[0, 66, 255, 77, 0, 0, 0, 0, 0, 0, 0, 0, 17, 255, 122, 0, 0],
            &[0, 58, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 38, 255, 100, 0, 0],
            &[0, 26, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 92, 255, 51, 0, 0],
            &[0, 0, 199, 213, 3, 0, 0, 0, 0, 0, 0, 0, 187, 223, 2, 0, 0],
            &[0, 0, 75, 255, 135, 0, 0, 0, 0, 0, 0, 106, 255, 103, 0, 0, 0],
            &[
                0, 0, 0, 125, 254, 182, 74, 30, 25, 63, 162, 255, 163, 1, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 73, 195, 255, 255, 255, 255, 224, 106, 1, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 20, 51, 60, 34, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ñ' / 0xf1
        'ñ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 1, 89, 132, 74, 0, 0, 0, 13, 146, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 144, 247, 198, 248, 181, 25, 0, 107, 194, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 12, 247, 35, 0, 34, 193, 251, 226, 248, 63, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 23, 102, 0, 0, 0, 1, 70, 106, 39, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 45, 74, 0, 0, 40, 119, 152, 152, 113, 28, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 218, 1, 146, 252, 207, 183, 210, 250, 248, 98, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 239, 111, 198, 36, 0, 0, 0, 37, 205, 253, 51, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 222, 15, 0, 0, 0, 0, 0, 45, 253, 153, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 123, 0, 0, 0, 0, 0, 0, 0, 222, 201, 0, 0, 0],
            &[0, 0, 125, 255, 58, 0, 0, 0, 0, 0, 0, 0, 191, 216, 0, 0, 0],
            &[0, 0, 125, 255, 29, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ò' / 0xf2
        'ò' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 20, 171, 146, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 113, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 137, 248, 52, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 136, 227, 27, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 107, 108, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 107, 142, 150, 120, 52, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 3, 140, 250, 239, 191, 188, 225, 255, 188, 20, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 167, 251, 112, 5, 0, 0, 0, 74, 234, 217, 12, 0, 0, 0,
            ],
            &[0, 0, 84, 255, 108, 0, 0, 0, 0, 0, 0, 51, 252, 142, 0, 0, 0],
            &[0, 0, 191, 219, 1, 0, 0, 0, 0, 0, 0, 0, 165, 242, 7, 0, 0],
            &[0, 16, 252, 137, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 70, 0, 0],
            &[0, 46, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 41, 255, 105, 0, 0],
            &[0, 68, 255, 73, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 127, 0, 0],
            &[0, 64, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0, 30, 255, 122, 0, 0],
            &[0, 42, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 56, 255, 98, 0, 0],
            &[0, 2, 242, 167, 0, 0, 0, 0, 0, 0, 0, 0, 117, 255, 44, 0, 0],
            &[0, 0, 160, 244, 24, 0, 0, 0, 0, 0, 0, 3, 214, 212, 0, 0, 0],
            &[0, 0, 39, 247, 179, 5, 0, 0, 0, 0, 0, 132, 255, 85, 0, 0, 0],
            &[
                0, 0, 0, 90, 251, 202, 83, 33, 27, 66, 174, 255, 145, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 56, 191, 253, 255, 255, 255, 218, 94, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 19, 54, 60, 32, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ó' / 0xf3
        'ó' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 172, 140, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 244, 48, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 118, 248, 70, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 75, 243, 77, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 151, 60, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 107, 142, 150, 120, 52, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 3, 140, 250, 239, 191, 188, 225, 255, 188, 20, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 167, 251, 112, 5, 0, 0, 0, 74, 234, 217, 12, 0, 0, 0,
            ],
            &[0, 0, 84, 255, 108, 0, 0, 0, 0, 0, 0, 51, 252, 142, 0, 0, 0],
            &[0, 0, 191, 219, 1, 0, 0, 0, 0, 0, 0, 0, 165, 242, 7, 0, 0],
            &[0, 16, 252, 137, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 70, 0, 0],
            &[0, 46, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 41, 255, 105, 0, 0],
            &[0, 68, 255, 73, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 127, 0, 0],
            &[0, 64, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0, 30, 255, 122, 0, 0],
            &[0, 42, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 56, 255, 98, 0, 0],
            &[0, 2, 242, 167, 0, 0, 0, 0, 0, 0, 0, 0, 117, 255, 44, 0, 0],
            &[0, 0, 160, 244, 24, 0, 0, 0, 0, 0, 0, 3, 214, 212, 0, 0, 0],
            &[0, 0, 39, 247, 179, 5, 0, 0, 0, 0, 0, 132, 255, 85, 0, 0, 0],
            &[
                0, 0, 0, 90, 251, 202, 83, 33, 27, 66, 174, 255, 145, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 56, 191, 253, 255, 255, 255, 218, 94, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 19, 54, 60, 32, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ô' / 0xf4
        'ô' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 1, 142, 165, 20, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 113, 248, 233, 172, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 249, 86, 47, 241, 118, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 38, 234, 102, 0, 0, 61, 240, 80, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 124, 91, 0, 0, 0, 0, 55, 154, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 107, 142, 150, 120, 52, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 3, 140, 250, 239, 191, 188, 225, 255, 188, 20, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 167, 251, 112, 5, 0, 0, 0, 74, 234, 217, 12, 0, 0, 0,
            ],
            &[0, 0, 84, 255, 108, 0, 0, 0, 0, 0, 0, 51, 252, 142, 0, 0, 0],
            &[0, 0, 191, 219, 1, 0, 0, 0, 0, 0, 0, 0, 165, 242, 7, 0, 0],
            &[0, 16, 252, 137, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 70, 0, 0],
            &[0, 46, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 41, 255, 105, 0, 0],
            &[0, 68, 255, 73, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 127, 0, 0],
            &[0, 64, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0, 30, 255, 122, 0, 0],
            &[0, 42, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 56, 255, 98, 0, 0],
            &[0, 2, 242, 167, 0, 0, 0, 0, 0, 0, 0, 0, 117, 255, 44, 0, 0],
            &[0, 0, 160, 244, 24, 0, 0, 0, 0, 0, 0, 3, 214, 212, 0, 0, 0],
            &[0, 0, 39, 247, 179, 5, 0, 0, 0, 0, 0, 132, 255, 85, 0, 0, 0],
            &[
                0, 0, 0, 90, 251, 202, 83, 33, 27, 66, 174, 255, 145, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 56, 191, 253, 255, 255, 255, 218, 94, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 19, 54, 60, 32, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'õ' / 0xf5
        'õ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 13, 112, 125, 46, 0, 0, 0, 54, 104, 0, 0, 0, 0],
            &[
                0, 0, 0, 4, 208, 232, 207, 251, 134, 6, 5, 171, 124, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 77, 212, 5, 0, 70, 226, 241, 236, 225, 17, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 56, 69, 0, 0, 0, 13, 88, 98, 18, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 107, 142, 150, 120, 52, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 3, 140, 250, 239, 191, 188, 225, 255, 188, 20, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 167, 251, 112, 5, 0, 0, 0, 74, 234, 217, 12, 0, 0, 0,
            ],
            &[0, 0, 84, 255, 108, 0, 0, 0, 0, 0, 0, 51, 252, 142, 0, 0, 0],
            &[0, 0, 191, 219, 1, 0, 0, 0, 0, 0, 0, 0, 165, 242, 7, 0, 0],
            &[0, 16, 252, 137, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 70, 0, 0],
            &[0, 46, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 41, 255, 105, 0, 0],
            &[0, 68, 255, 73, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 127, 0, 0],
            &[0, 64, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0, 30, 255, 122, 0, 0],
            &[0, 42, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 56, 255, 98, 0, 0],
            &[0, 2, 242, 167, 0, 0, 0, 0, 0, 0, 0, 0, 117, 255, 44, 0, 0],
            &[0, 0, 160, 244, 24, 0, 0, 0, 0, 0, 0, 3, 214, 212, 0, 0, 0],
            &[0, 0, 39, 247, 179, 5, 0, 0, 0, 0, 0, 132, 255, 85, 0, 0, 0],
            &[
                0, 0, 0, 90, 251, 202, 83, 33, 27, 66, 174, 255, 145, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 56, 191, 253, 255, 255, 255, 218, 94, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 19, 54, 60, 32, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ö' / 0xf6
        'ö' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 60, 121, 7, 0, 0, 0, 96, 91, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 194, 255, 67, 0, 0, 11, 252, 248, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 112, 199, 21, 0, 0, 0, 171, 161, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 107, 142, 150, 120, 52, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 3, 140, 250, 239, 191, 188, 225, 255, 188, 20, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 167, 251, 112, 5, 0, 0, 0, 74, 234, 217, 12, 0, 0, 0,
            ],
            &[0, 0, 84, 255, 108, 0, 0, 0, 0, 0, 0, 51, 252, 142, 0, 0, 0],
            &[0, 0, 191, 219, 1, 0, 0, 0, 0, 0, 0, 0, 165, 242, 7, 0, 0],
            &[0, 16, 252, 137, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 70, 0, 0],
            &[0, 46, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 41, 255, 105, 0, 0],
            &[0, 68, 255, 73, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 127, 0, 0],
            &[0, 64, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0, 30, 255, 122, 0, 0],
            &[0, 42, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 56, 255, 98, 0, 0],
            &[0, 2, 242, 167, 0, 0, 0, 0, 0, 0, 0, 0, 117, 255, 44, 0, 0],
            &[0, 0, 160, 244, 24, 0, 0, 0, 0, 0, 0, 3, 214, 212, 0, 0, 0],
            &[0, 0, 39, 247, 179, 5, 0, 0, 0, 0, 0, 132, 255, 85, 0, 0, 0],
            &[
                0, 0, 0, 90, 251, 202, 83, 33, 27, 66, 174, 255, 145, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 56, 191, 253, 255, 255, 255, 218, 94, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 19, 54, 60, 32, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: '÷' / 0xf7
        '÷' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 56, 77, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 232, 255, 22, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 173, 213, 5, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 44, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 8, 0, 0,
            ],
            &[
                0, 0, 249, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 44, 0, 0,
            ],
            &[
                0, 0, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 5, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 186, 224, 7, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 229, 254, 20, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 44, 62, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ø' / 0xf8
        'ø' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 24, 107, 142, 150, 120, 52, 0, 26, 225, 63, 0, 0,
            ],
            &[
                0, 0, 0, 3, 140, 250, 239, 191, 188, 225, 255, 192, 215, 204, 7, 0, 0,
            ],
            &[
                0, 0, 0, 167, 251, 112, 5, 0, 0, 0, 74, 255, 255, 46, 0, 0, 0,
            ],
            &[
                0, 0, 84, 255, 108, 0, 0, 0, 0, 0, 77, 255, 255, 142, 0, 0, 0,
            ],
            &[
                0, 0, 191, 219, 1, 0, 0, 0, 0, 32, 238, 141, 165, 242, 7, 0, 0,
            ],
            &[
                0, 16, 252, 137, 0, 0, 0, 0, 6, 203, 198, 5, 87, 255, 70, 0, 0,
            ],
            &[
                0, 46, 255, 91, 0, 0, 0, 0, 148, 235, 28, 0, 41, 255, 105, 0, 0,
            ],
            &[
                0, 68, 255, 73, 0, 0, 0, 87, 253, 72, 0, 0, 23, 255, 127, 0, 0,
            ],
            &[
                0, 64, 255, 81, 0, 0, 38, 242, 132, 0, 0, 0, 30, 255, 122, 0, 0,
            ],
            &[
                0, 42, 255, 106, 0, 9, 210, 190, 3, 0, 0, 0, 56, 255, 98, 0, 0,
            ],
            &[
                0, 2, 242, 167, 0, 158, 231, 24, 0, 0, 0, 0, 117, 255, 44, 0, 0,
            ],
            &[
                0, 0, 160, 244, 121, 252, 64, 0, 0, 0, 0, 3, 214, 212, 0, 0, 0,
            ],
            &[
                0, 0, 39, 255, 255, 129, 0, 0, 0, 0, 0, 132, 255, 85, 0, 0, 0,
            ],
            &[
                0, 0, 13, 255, 255, 204, 83, 33, 27, 66, 174, 255, 145, 0, 0, 0, 0,
            ],
            &[
                0, 0, 169, 226, 76, 191, 253, 255, 255, 255, 218, 94, 0, 0, 0, 0, 0,
            ],
            &[0, 1, 120, 57, 0, 0, 19, 54, 60, 32, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ù' / 0xf9
        'ù' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 20, 171, 146, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 113, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 137, 248, 52, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 136, 227, 27, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 107, 108, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 159, 242, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 150, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 121, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 52, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 176, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 9, 152, 249, 255, 255, 255, 226, 94, 0, 152, 183, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 11, 53, 63, 40, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ú' / 0xfa
        'ú' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 172, 140, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 244, 48, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 118, 248, 70, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 75, 243, 77, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 151, 60, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 159, 242, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 150, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 121, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 52, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 176, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 9, 152, 249, 255, 255, 255, 226, 94, 0, 152, 183, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 11, 53, 63, 40, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'û' / 0xfb
        'û' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 1, 142, 165, 20, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 113, 248, 233, 172, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 249, 86, 47, 241, 118, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 38, 234, 102, 0, 0, 61, 240, 80, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 124, 91, 0, 0, 0, 0, 55, 154, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 159, 242, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 150, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 121, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 52, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 176, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 9, 152, 249, 255, 255, 255, 226, 94, 0, 152, 183, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 10, 53, 63, 40, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ü' / 0xfc
        'ü' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 60, 121, 7, 0, 0, 0, 96, 91, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 194, 255, 67, 0, 0, 11, 252, 248, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 112, 199, 21, 0, 0, 0, 171, 161, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 159, 242, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 150, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 121, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 52, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 176, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 9, 152, 249, 255, 255, 255, 226, 94, 0, 152, 183, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 11, 53, 63, 40, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ý' / 0xfd
        'ý' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 172, 140, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 244, 48, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 118, 248, 70, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 75, 243, 77, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 151, 60, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 8, 93, 44, 0, 0, 0, 0, 0, 0, 0, 0, 22, 93, 35, 0, 0],
            &[0, 0, 209, 188, 0, 0, 0, 0, 0, 0, 0, 0, 124, 254, 32, 0, 0],
            &[0, 0, 108, 254, 33, 0, 0, 0, 0, 0, 0, 0, 215, 189, 0, 0, 0],
            &[0, 0, 16, 246, 131, 0, 0, 0, 0, 0, 0, 52, 255, 93, 0, 0, 0],
            &[0, 0, 0, 160, 227, 3, 0, 0, 0, 0, 0, 143, 242, 10, 0, 0, 0],
            &[0, 0, 0, 59, 255, 74, 0, 0, 0, 0, 3, 232, 156, 0, 0, 0, 0],
            &[0, 0, 0, 0, 213, 173, 0, 0, 0, 0, 71, 255, 59, 0, 0, 0, 0],
            &[0, 0, 0, 0, 111, 250, 22, 0, 0, 0, 163, 218, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 18, 247, 116, 0, 0, 11, 244, 122, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 164, 215, 0, 0, 91, 253, 28, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 62, 255, 57, 0, 181, 185, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 216, 154, 19, 251, 89, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 115, 236, 105, 240, 8, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 20, 249, 233, 152, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 167, 255, 55, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 170, 214, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 17, 248, 118, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 110, 250, 25, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 5, 225, 162, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 1, 150, 253, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 196, 176, 223, 255, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 158, 141, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'þ' / 0xfe
        'þ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 112, 230, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 125, 255, 12, 0, 38, 120, 153, 147, 102, 18, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 12, 131, 251, 210, 182, 200, 251, 238, 79, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 100, 210, 43, 0, 0, 0, 25, 188, 250, 53, 0, 0, 0,
            ],
            &[
                0, 0, 125, 254, 224, 24, 0, 0, 0, 0, 0, 12, 231, 192, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 137, 0, 0, 0, 0, 0, 0, 0, 132, 254, 30, 0, 0],
            &[0, 0, 125, 255, 65, 0, 0, 0, 0, 0, 0, 0, 70, 255, 85, 0, 0],
            &[0, 0, 125, 255, 27, 0, 0, 0, 0, 0, 0, 0, 38, 255, 117, 0, 0],
            &[0, 0, 125, 255, 14, 0, 0, 0, 0, 0, 0, 0, 27, 255, 130, 0, 0],
            &[0, 0, 125, 255, 21, 0, 0, 0, 0, 0, 0, 0, 34, 255, 118, 0, 0],
            &[0, 0, 125, 255, 42, 0, 0, 0, 0, 0, 0, 0, 56, 255, 98, 0, 0],
            &[0, 0, 125, 255, 90, 0, 0, 0, 0, 0, 0, 0, 104, 255, 50, 0, 0],
            &[0, 0, 125, 255, 176, 0, 0, 0, 0, 0, 0, 0, 189, 232, 1, 0, 0],
            &[
                0, 0, 125, 250, 221, 71, 0, 0, 0, 0, 0, 83, 255, 114, 0, 0, 0,
            ],
            &[
                0, 0, 125, 254, 61, 241, 126, 42, 19, 44, 133, 249, 190, 5, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 10, 63, 209, 255, 255, 255, 242, 139, 8, 0, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 12, 0, 0, 33, 62, 43, 9, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 60, 122, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ÿ' / 0xff
        'ÿ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 60, 121, 7, 0, 0, 0, 96, 91, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 194, 255, 67, 0, 0, 11, 252, 248, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 112, 199, 21, 0, 0, 0, 171, 161, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 8, 93, 44, 0, 0, 0, 0, 0, 0, 0, 0, 22, 93, 35, 0, 0],
            &[0, 0, 209, 188, 0, 0, 0, 0, 0, 0, 0, 0, 124, 254, 32, 0, 0],
            &[0, 0, 108, 254, 33, 0, 0, 0, 0, 0, 0, 0, 215, 189, 0, 0, 0],
            &[0, 0, 16, 246, 131, 0, 0, 0, 0, 0, 0, 52, 255, 93, 0, 0, 0],
            &[0, 0, 0, 160, 227, 3, 0, 0, 0, 0, 0, 143, 242, 10, 0, 0, 0],
            &[0, 0, 0, 59, 255, 74, 0, 0, 0, 0, 3, 232, 156, 0, 0, 0, 0],
            &[0, 0, 0, 0, 213, 173, 0, 0, 0, 0, 71, 255, 59, 0, 0, 0, 0],
            &[0, 0, 0, 0, 111, 250, 22, 0, 0, 0, 163, 218, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 18, 247, 116, 0, 0, 11, 244, 122, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 164, 215, 0, 0, 91, 253, 28, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 62, 255, 57, 0, 181, 185, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 216, 154, 19, 251, 89, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 115, 236, 105, 240, 8, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 20, 249, 233, 152, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 167, 255, 55, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 170, 214, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 17, 248, 118, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 110, 250, 25, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 5, 225, 162, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 1, 150, 253, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 196, 176, 223, 255, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 158, 141, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ā' / 0x100
        'Ā' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 17, 28, 28, 28, 28, 28, 28, 23, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 160, 255, 255, 255, 255, 255, 255, 211, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 29, 47, 47, 47, 47, 47, 47, 38, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 70, 88, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 12, 245, 255, 53, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 91, 253, 231, 142, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 180, 199, 146, 229, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 19, 250, 119, 61, 255, 65, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 255, 32, 1, 228, 154, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 192, 200, 0, 0, 142, 237, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 253, 112, 0, 0, 55, 255, 77, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 115, 253, 26, 0, 0, 0, 223, 166, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 204, 193, 0, 0, 0, 0, 137, 244, 11, 0, 0, 0, 0],
            &[0, 0, 0, 38, 255, 105, 0, 0, 0, 0, 50, 255, 88, 0, 0, 0, 0],
            &[
                0, 0, 0, 126, 255, 33, 11, 11, 11, 11, 12, 227, 178, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 216, 255, 255, 255, 255, 255, 255, 255, 255, 250, 17, 0, 0, 0,
            ],
            &[
                0, 0, 49, 255, 194, 98, 98, 98, 98, 98, 98, 142, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 138, 249, 17, 0, 0, 0, 0, 0, 0, 0, 213, 189, 0, 0, 0],
            &[0, 1, 226, 179, 0, 0, 0, 0, 0, 0, 0, 0, 126, 253, 25, 0, 0],
            &[0, 61, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 112, 0, 0],
            &[0, 150, 246, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 201, 0, 0],
            &[4, 235, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 35, 0],
            &[73, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 255, 124, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ā' / 0x101
        'ā' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 24, 50, 50, 50, 50, 50, 50, 48, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 125, 255, 255, 255, 255, 255, 255, 245, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 12, 25, 25, 25, 25, 25, 25, 24, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 66, 124, 151, 156, 134, 76, 4, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 84, 225, 255, 228, 195, 189, 224, 255, 214, 37, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 141, 39, 0, 0, 0, 0, 72, 237, 211, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 255, 62, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 255, 110, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 250, 126, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 16, 54, 79, 93, 102, 110, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 4, 99, 205, 253, 253, 232, 213, 203, 193, 253, 127, 0, 0, 0,
            ],
            &[0, 0, 7, 183, 251, 151, 59, 8, 0, 0, 0, 0, 245, 127, 0, 0, 0],
            &[0, 0, 112, 255, 76, 0, 0, 0, 0, 0, 0, 3, 252, 127, 0, 0, 0],
            &[0, 0, 186, 204, 0, 0, 0, 0, 0, 0, 0, 36, 255, 127, 0, 0, 0],
            &[0, 0, 201, 186, 0, 0, 0, 0, 0, 0, 0, 131, 255, 127, 0, 0, 0],
            &[
                0, 0, 158, 237, 19, 0, 0, 0, 0, 0, 67, 227, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 47, 248, 205, 76, 28, 26, 63, 153, 242, 54, 226, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 68, 211, 255, 255, 255, 253, 183, 45, 0, 206, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 25, 58, 55, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ă' / 0x102
        'Ă' => &[
            &[0, 0, 0, 0, 105, 117, 0, 0, 0, 0, 73, 143, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 82, 240, 39, 0, 0, 9, 201, 133, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 164, 243, 175, 160, 228, 204, 11, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 70, 129, 133, 86, 3, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 70, 88, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 12, 245, 255, 53, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 91, 253, 231, 142, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 180, 199, 146, 229, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 19, 250, 119, 61, 255, 65, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 255, 32, 1, 228, 154, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 192, 200, 0, 0, 142, 237, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 253, 112, 0, 0, 55, 255, 77, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 115, 253, 26, 0, 0, 0, 223, 166, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 204, 193, 0, 0, 0, 0, 137, 244, 11, 0, 0, 0, 0],
            &[0, 0, 0, 38, 255, 105, 0, 0, 0, 0, 50, 255, 88, 0, 0, 0, 0],
            &[
                0, 0, 0, 126, 255, 33, 11, 11, 11, 11, 12, 227, 178, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 216, 255, 255, 255, 255, 255, 255, 255, 255, 250, 17, 0, 0, 0,
            ],
            &[
                0, 0, 49, 255, 194, 98, 98, 98, 98, 98, 98, 142, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 138, 249, 17, 0, 0, 0, 0, 0, 0, 0, 213, 189, 0, 0, 0],
            &[0, 1, 226, 179, 0, 0, 0, 0, 0, 0, 0, 0, 126, 253, 25, 0, 0],
            &[0, 61, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 112, 0, 0],
            &[0, 150, 246, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 201, 0, 0],
            &[4, 235, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 35, 0],
            &[73, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 255, 124, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ă' / 0x103
        'ă' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 87, 163, 0, 0, 0, 0, 56, 186, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 41, 251, 79, 0, 0, 8, 186, 158, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 111, 249, 204, 179, 233, 207, 19, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 37, 101, 115, 74, 3, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 66, 124, 151, 156, 134, 76, 4, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 84, 225, 255, 228, 195, 189, 224, 255, 214, 37, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 141, 39, 0, 0, 0, 0, 72, 237, 211, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 255, 62, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 255, 110, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 250, 126, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 16, 54, 79, 93, 102, 110, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 4, 99, 205, 253, 253, 232, 213, 203, 193, 253, 127, 0, 0, 0,
            ],
            &[0, 0, 7, 183, 251, 151, 59, 8, 0, 0, 0, 0, 245, 127, 0, 0, 0],
            &[0, 0, 112, 255, 76, 0, 0, 0, 0, 0, 0, 3, 252, 127, 0, 0, 0],
            &[0, 0, 186, 204, 0, 0, 0, 0, 0, 0, 0, 36, 255, 127, 0, 0, 0],
            &[0, 0, 201, 186, 0, 0, 0, 0, 0, 0, 0, 131, 255, 127, 0, 0, 0],
            &[
                0, 0, 158, 237, 19, 0, 0, 0, 0, 0, 67, 227, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 47, 248, 205, 76, 28, 26, 63, 153, 242, 54, 226, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 68, 211, 255, 255, 255, 253, 183, 45, 0, 206, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 25, 58, 55, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ą' / 0x104
        'Ą' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 70, 88, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 12, 245, 255, 53, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 91, 253, 231, 142, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 180, 199, 146, 229, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 19, 250, 119, 61, 255, 65, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 255, 32, 1, 228, 154, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 192, 200, 0, 0, 142, 237, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 253, 112, 0, 0, 55, 255, 77, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 115, 253, 26, 0, 0, 0, 223, 166, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 204, 193, 0, 0, 0, 0, 137, 244, 11, 0, 0, 0, 0],
            &[0, 0, 0, 38, 255, 105, 0, 0, 0, 0, 50, 255, 88, 0, 0, 0, 0],
            &[
                0, 0, 0, 126, 255, 33, 11, 11, 11, 11, 12, 227, 178, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 216, 255, 255, 255, 255, 255, 255, 255, 255, 250, 17, 0, 0, 0,
            ],
            &[
                0, 0, 49, 255, 194, 98, 98, 98, 98, 98, 98, 142, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 138, 249, 17, 0, 0, 0, 0, 0, 0, 0, 213, 189, 0, 0, 0],
            &[0, 1, 226, 179, 0, 0, 0, 0, 0, 0, 0, 0, 126, 253, 25, 0, 0],
            &[0, 61, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 39, 255, 112, 0, 0],
            &[0, 150, 246, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 201, 0, 0],
            &[4, 235, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 35, 0],
            &[73, 255, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 255, 148, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 228, 62, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 235, 70, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 180, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 157, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 237, 103, 73, 19],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 158, 216, 206, 35],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ą' / 0x105
        'ą' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 2, 66, 124, 151, 156, 134, 76, 4, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 84, 225, 255, 228, 195, 189, 224, 255, 214, 37, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 141, 39, 0, 0, 0, 0, 72, 237, 211, 2, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 255, 62, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 255, 110, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 250, 126, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 16, 54, 79, 93, 102, 110, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 4, 99, 205, 253, 253, 232, 213, 203, 193, 253, 127, 0, 0, 0,
            ],
            &[0, 0, 7, 183, 251, 151, 59, 8, 0, 0, 0, 0, 245, 127, 0, 0, 0],
            &[0, 0, 112, 255, 76, 0, 0, 0, 0, 0, 0, 3, 252, 127, 0, 0, 0],
            &[0, 0, 186, 204, 0, 0, 0, 0, 0, 0, 0, 36, 255, 127, 0, 0, 0],
            &[0, 0, 201, 186, 0, 0, 0, 0, 0, 0, 0, 131, 255, 127, 0, 0, 0],
            &[
                0, 0, 158, 237, 19, 0, 0, 0, 0, 0, 67, 227, 249, 127, 0, 0, 0,
            ],
            &[
                0, 0, 47, 248, 205, 76, 28, 26, 63, 153, 242, 54, 226, 127, 0, 0, 0,
            ],
            &[
                0, 0, 0, 68, 211, 255, 255, 255, 253, 183, 45, 0, 254, 137, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 25, 58, 55, 16, 0, 0, 109, 217, 26, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 231, 30, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 200, 118, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 249, 95, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 212, 208, 86, 77, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 181, 219, 189, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ć' / 0x106
        'Ć' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 236, 205, 9, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 194, 218, 24, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 219, 30, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 55, 170, 22, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 33, 98, 124, 130, 104, 73, 14, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 48, 193, 255, 254, 235, 229, 253, 255, 249, 133, 0, 0,
            ],
            &[
                0, 0, 0, 0, 84, 250, 228, 100, 17, 0, 0, 4, 45, 129, 89, 0, 0,
            ],
            &[0, 0, 0, 56, 251, 199, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 234, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 73, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 164, 248, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 220, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 9, 255, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 26, 255, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 37, 255, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 20, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 2, 253, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 218, 204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 149, 253, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 74, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 240, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 56, 249, 224, 39, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0],
            &[
                0, 0, 0, 0, 79, 245, 252, 165, 95, 62, 64, 92, 138, 212, 65, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 35, 162, 245, 255, 255, 255, 255, 242, 173, 32, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 4, 43, 63, 53, 30, 4, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 152, 69, 0, 0, 0],
        ],
        // letter: 'ć' / 0x107
        'ć' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 174, 102, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 222, 220, 18, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 173, 229, 34, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 127, 227, 40, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 28, 158, 29, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 14, 92, 130, 154, 140, 112, 43, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 5, 137, 247, 255, 230, 205, 217, 245, 255, 106, 0, 0, 0,
            ],
            &[0, 0, 0, 4, 192, 255, 152, 37, 0, 0, 0, 6, 77, 30, 0, 0, 0],
            &[0, 0, 0, 133, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 9, 242, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 83, 255, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 122, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 123, 255, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 76, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 7, 241, 200, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 113, 255, 141, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 2, 161, 255, 201, 99, 52, 34, 55, 87, 158, 96, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 93, 201, 255, 255, 255, 255, 253, 201, 66, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 20, 47, 62, 40, 13, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ĉ' / 0x108
        'Ĉ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 2, 192, 238, 253, 62, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 138, 230, 32, 150, 231, 27, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 96, 234, 46, 0, 2, 164, 205, 12, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 178, 44, 0, 0, 0, 2, 139, 106, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 33, 98, 124, 130, 104, 73, 14, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 48, 193, 255, 254, 235, 229, 253, 255, 249, 133, 0, 0,
            ],
            &[
                0, 0, 0, 0, 84, 250, 228, 100, 17, 0, 0, 4, 45, 129, 89, 0, 0,
            ],
            &[0, 0, 0, 56, 251, 199, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 234, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 73, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 164, 248, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 220, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 9, 255, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 26, 255, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 37, 255, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 20, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 2, 253, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 218, 204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 149, 253, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 74, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 240, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 56, 249, 224, 39, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0],
            &[
                0, 0, 0, 0, 79, 245, 252, 165, 95, 62, 64, 92, 138, 212, 65, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 35, 162, 245, 255, 255, 255, 255, 242, 173, 32, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 4, 43, 63, 53, 30, 4, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 30, 145, 101, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ĉ' / 0x109
        'ĉ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 16, 163, 146, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 169, 232, 249, 117, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 114, 239, 45, 90, 250, 67, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 76, 238, 59, 0, 0, 105, 236, 40, 0, 0, 0, 0],
            &[0, 0, 0, 0, 6, 153, 56, 0, 0, 0, 0, 91, 125, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 14, 92, 130, 154, 140, 112, 43, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 5, 137, 247, 255, 230, 205, 217, 245, 255, 106, 0, 0, 0,
            ],
            &[0, 0, 0, 4, 192, 255, 152, 37, 0, 0, 0, 6, 77, 30, 0, 0, 0],
            &[0, 0, 0, 133, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 9, 242, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 83, 255, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 122, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 123, 255, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 76, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 7, 241, 200, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 113, 255, 141, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 2, 161, 255, 201, 99, 52, 34, 55, 87, 158, 96, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 93, 201, 255, 255, 255, 255, 253, 201, 66, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 20, 47, 62, 40, 13, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ċ' / 0x10a
        'Ċ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 45, 205, 127, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 118, 255, 231, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 32, 169, 97, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 33, 98, 124, 130, 104, 73, 14, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 48, 193, 255, 254, 235, 229, 253, 255, 249, 133, 0, 0,
            ],
            &[
                0, 0, 0, 0, 84, 250, 228, 100, 17, 0, 0, 4, 45, 129, 89, 0, 0,
            ],
            &[0, 0, 0, 56, 251, 199, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 234, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 73, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 164, 248, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 220, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 9, 255, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 26, 255, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 37, 255, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 20, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 2, 253, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 218, 204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 149, 253, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 74, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 240, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 56, 249, 224, 39, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0],
            &[
                0, 0, 0, 0, 79, 245, 252, 165, 95, 62, 64, 92, 138, 212, 65, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 35, 162, 245, 255, 255, 255, 255, 242, 173, 32, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 4, 43, 63, 53, 30, 4, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ċ' / 0x10b
        'ċ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 13, 4, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 38, 245, 221, 3, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 67, 255, 250, 14, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 3, 96, 68, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 14, 92, 130, 154, 140, 112, 43, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 5, 137, 247, 255, 230, 205, 217, 245, 255, 106, 0, 0, 0,
            ],
            &[0, 0, 0, 4, 192, 255, 152, 37, 0, 0, 0, 6, 77, 30, 0, 0, 0],
            &[0, 0, 0, 133, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 9, 242, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 83, 255, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 122, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 123, 255, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 76, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 7, 241, 200, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 113, 255, 141, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 2, 161, 255, 201, 99, 52, 34, 55, 87, 158, 96, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 93, 201, 255, 255, 255, 255, 253, 201, 66, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 20, 47, 62, 40, 13, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Č' / 0x10c
        'Č' => &[
            &[0, 0, 0, 0, 0, 0, 137, 216, 28, 0, 0, 139, 223, 26, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 1, 174, 214, 18, 130, 240, 41, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 12, 217, 223, 255, 76, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 56, 185, 129, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 33, 98, 124, 130, 104, 73, 14, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 48, 193, 255, 254, 235, 229, 253, 255, 249, 133, 0, 0,
            ],
            &[
                0, 0, 0, 0, 84, 250, 228, 100, 17, 0, 0, 4, 45, 129, 89, 0, 0,
            ],
            &[0, 0, 0, 56, 251, 199, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 234, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 73, 255, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 164, 248, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 220, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 9, 255, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 26, 255, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 37, 255, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 20, 255, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 2, 253, 155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 218, 204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 149, 253, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 74, 255, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 2, 212, 240, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 56, 249, 224, 39, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0],
            &[
                0, 0, 0, 0, 79, 245, 252, 165, 95, 62, 64, 92, 138, 212, 65, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 35, 162, 245, 255, 255, 255, 255, 242, 173, 32, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 4, 43, 63, 53, 30, 4, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 26, 142, 22, 0, 0, 0, 0, 104, 93, 0, 0, 0],
        ],
        // letter: 'č' / 0x10d
        'č' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 7, 158, 57, 0, 0, 0, 0, 100, 129, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 79, 241, 65, 0, 0, 121, 233, 37, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 116, 243, 51, 108, 248, 57, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 171, 238, 253, 101, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 20, 161, 135, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 14, 92, 130, 154, 140, 112, 43, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 5, 137, 247, 255, 230, 205, 217, 245, 255, 106, 0, 0, 0,
            ],
            &[0, 0, 0, 4, 192, 255, 152, 37, 0, 0, 0, 6, 77, 30, 0, 0, 0],
            &[0, 0, 0, 133, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 9, 242, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 83, 255, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 122, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 147, 254, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 123, 255, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 76, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 7, 241, 200, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 113, 255, 141, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 2, 161, 255, 201, 99, 52, 34, 55, 87, 158, 96, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 93, 201, 255, 255, 255, 255, 253, 201, 66, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 20, 47, 62, 40, 13, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ď' / 0x10e
        'Ď' => &[
            &[0, 0, 0, 0, 109, 230, 43, 0, 0, 112, 235, 41, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 147, 229, 31, 102, 249, 61, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 4, 197, 226, 252, 104, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 36, 184, 148, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 71, 71, 71, 69, 56, 22, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 194, 255, 255, 255, 255, 255, 255, 215, 117, 9, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 194, 211, 25, 25, 33, 60, 101, 195, 255, 216, 35, 0, 0, 0, 0,
            ],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 81, 243, 225, 19, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 71, 255, 157, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 170, 251, 24, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 75, 255, 103, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 10, 249, 160, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 194, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 210, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 213, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 209, 202, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 236, 174, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 32, 255, 129, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 114, 255, 60, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 10, 222, 216, 1, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 2, 159, 255, 79, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 36, 178, 255, 140, 0, 0, 0, 0],
            &[
                0, 0, 194, 226, 103, 103, 116, 138, 196, 252, 247, 114, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 194, 255, 255, 255, 250, 233, 191, 121, 24, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 12, 142, 35, 0, 0, 0, 0, 88, 109, 0, 0, 0, 0, 0],
        ],
        // letter: 'ď' / 0x10f
        'ď' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 84, 0, 0, 98, 112, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 237, 162, 0, 0, 225, 158, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 237, 162, 0, 29, 255, 64, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 237, 162, 0, 101, 206, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 237, 162, 0, 142, 68, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 237, 162, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 22, 111, 148, 148, 95, 4, 0, 236, 162, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 93, 246, 247, 198, 191, 238, 197, 22, 231, 162, 0, 0, 0, 0, 0,
            ],
            &[
                0, 63, 253, 193, 27, 0, 0, 12, 158, 172, 219, 162, 0, 0, 0, 0, 0,
            ],
            &[0, 199, 236, 15, 0, 0, 0, 0, 3, 206, 250, 162, 0, 0, 0, 0, 0],
            &[29, 255, 133, 0, 0, 0, 0, 0, 0, 98, 255, 162, 0, 0, 0, 0, 0],
            &[91, 255, 68, 0, 0, 0, 0, 0, 0, 36, 255, 162, 0, 0, 0, 0, 0],
            &[120, 255, 29, 0, 0, 0, 0, 0, 0, 2, 254, 162, 0, 0, 0, 0, 0],
            &[137, 255, 14, 0, 0, 0, 0, 0, 0, 0, 242, 162, 0, 0, 0, 0, 0],
            &[138, 255, 11, 0, 0, 0, 0, 0, 0, 0, 242, 162, 0, 0, 0, 0, 0],
            &[122, 255, 27, 0, 0, 0, 0, 0, 0, 6, 253, 162, 0, 0, 0, 0, 0],
            &[83, 255, 67, 0, 0, 0, 0, 0, 0, 47, 255, 162, 0, 0, 0, 0, 0],
            &[23, 252, 140, 0, 0, 0, 0, 0, 0, 125, 255, 162, 0, 0, 0, 0, 0],
            &[
                0, 176, 242, 31, 0, 0, 0, 0, 25, 225, 232, 162, 0, 0, 0, 0, 0,
            ],
            &[
                0, 35, 237, 224, 88, 26, 26, 85, 220, 111, 193, 162, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 44, 198, 255, 255, 255, 235, 107, 0, 177, 162, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 30, 61, 44, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Đ' / 0x110
        'Đ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 34, 71, 71, 71, 70, 61, 34, 1, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 125, 255, 255, 255, 255, 255, 255, 234, 148, 29, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 43, 25, 28, 52, 84, 168, 248, 241, 79, 0, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 39, 217, 251, 63, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 21, 236, 220, 6, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 101, 255, 89, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 12, 249, 172, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 190, 229, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 155, 254, 8, 0],
            &[
                101, 101, 226, 255, 120, 101, 101, 67, 0, 0, 0, 0, 0, 135, 255, 23, 0,
            ],
            &[
                251, 251, 255, 255, 255, 251, 251, 167, 0, 0, 0, 0, 0, 126, 255, 26, 0,
            ],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 140, 255, 15, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 167, 243, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 218, 198, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 45, 255, 129, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 163, 252, 34, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 92, 255, 148, 0, 0, 0],
            &[
                0, 0, 125, 255, 19, 0, 0, 0, 0, 14, 133, 253, 200, 9, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 115, 103, 111, 130, 178, 242, 255, 163, 13, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 255, 255, 253, 239, 205, 143, 48, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'đ' / 0x111
        'đ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 113, 95, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 20, 230, 230, 230, 230, 230, 255, 255, 230, 230, 46, 0,
            ],
            &[
                0, 0, 0, 0, 0, 7, 87, 87, 87, 87, 87, 255, 255, 87, 87, 17, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 39, 103, 132, 124, 68, 0, 0, 216, 183, 0, 0, 0, 0,
            ],
            &[
                0, 0, 13, 173, 254, 243, 206, 218, 251, 181, 21, 211, 183, 0, 0, 0, 0,
            ],
            &[
                0, 3, 199, 251, 111, 7, 0, 0, 28, 177, 177, 200, 183, 0, 0, 0, 0,
            ],
            &[
                0, 105, 255, 104, 0, 0, 0, 0, 0, 6, 207, 245, 183, 0, 0, 0, 0,
            ],
            &[0, 203, 221, 1, 0, 0, 0, 0, 0, 0, 89, 255, 183, 0, 0, 0, 0],
            &[18, 253, 144, 0, 0, 0, 0, 0, 0, 0, 22, 255, 183, 0, 0, 0, 0],
            &[48, 255, 100, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0, 0],
            &[68, 255, 82, 0, 0, 0, 0, 0, 0, 0, 0, 222, 183, 0, 0, 0, 0],
            &[68, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0, 222, 183, 0, 0, 0, 0],
            &[51, 255, 99, 0, 0, 0, 0, 0, 0, 0, 0, 239, 183, 0, 0, 0, 0],
            &[11, 253, 144, 0, 0, 0, 0, 0, 0, 0, 28, 255, 183, 0, 0, 0, 0],
            &[0, 198, 224, 4, 0, 0, 0, 0, 0, 0, 111, 255, 183, 0, 0, 0, 0],
            &[
                0, 89, 255, 125, 0, 0, 0, 0, 0, 24, 225, 225, 183, 0, 0, 0, 0,
            ],
            &[
                0, 0, 167, 255, 157, 56, 20, 31, 94, 223, 120, 173, 183, 0, 0, 0, 0,
            ],
            &[
                0, 0, 3, 121, 236, 255, 255, 255, 236, 111, 0, 156, 183, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 3, 44, 63, 46, 3, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ē' / 0x112
        'Ē' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 11, 28, 28, 28, 28, 28, 28, 28, 1, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 104, 255, 255, 255, 255, 255, 255, 255, 10, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 19, 47, 47, 47, 47, 47, 47, 47, 1, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 60, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 121, 32, 32, 32, 32, 32, 32, 32, 32, 27, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 229, 211, 211, 211, 211, 211, 211, 211, 211, 65, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 191, 147, 147, 147, 147, 147, 147, 147, 147, 45, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 168, 110, 110, 110, 110, 110, 110, 110, 110, 93, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ē' / 0x113
        'ē' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 26, 50, 50, 50, 50, 50, 50, 47, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 132, 255, 255, 255, 255, 255, 255, 239, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 12, 25, 25, 25, 25, 25, 25, 23, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 6, 86, 130, 154, 132, 81, 3, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 83, 231, 252, 205, 182, 207, 254, 221, 45, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 95, 253, 174, 28, 0, 0, 0, 39, 207, 238, 27, 0, 0, 0,
            ],
            &[0, 0, 27, 241, 175, 1, 0, 0, 0, 0, 0, 23, 240, 164, 0, 0, 0],
            &[0, 0, 136, 249, 26, 0, 0, 0, 0, 0, 0, 0, 145, 246, 9, 0, 0],
            &[0, 0, 217, 182, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 62, 0, 0],
            &[
                0, 7, 255, 169, 73, 73, 73, 73, 73, 73, 73, 73, 116, 255, 86, 0, 0,
            ],
            &[
                0, 30, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99, 0, 0,
            ],
            &[0, 29, 255, 123, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0],
            &[0, 5, 254, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 208, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 120, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 219, 222, 36, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0],
            &[
                0, 0, 0, 46, 223, 242, 141, 65, 36, 25, 45, 92, 175, 210, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 17, 136, 228, 255, 255, 255, 255, 247, 181, 93, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 27, 53, 58, 32, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ĕ' / 0x114
        'Ĕ' => &[
            &[0, 0, 0, 0, 65, 158, 0, 0, 0, 0, 33, 181, 2, 0, 0, 0, 0],
            &[0, 0, 0, 0, 31, 251, 79, 0, 0, 0, 154, 189, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 112, 251, 187, 156, 210, 231, 39, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 47, 120, 139, 102, 13, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 60, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 121, 32, 32, 32, 32, 32, 32, 32, 32, 27, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 229, 211, 211, 211, 211, 211, 211, 211, 211, 65, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 191, 147, 147, 147, 147, 147, 147, 147, 147, 45, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 168, 110, 110, 110, 110, 110, 110, 110, 110, 93, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ĕ' / 0x115
        'ĕ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 93, 158, 0, 0, 0, 0, 62, 180, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 47, 251, 73, 0, 0, 10, 192, 151, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 117, 250, 202, 180, 234, 203, 16, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 40, 102, 114, 73, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 6, 86, 130, 154, 132, 81, 3, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 83, 231, 252, 205, 182, 207, 254, 221, 45, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 95, 253, 174, 28, 0, 0, 0, 39, 207, 238, 27, 0, 0, 0,
            ],
            &[0, 0, 27, 241, 175, 1, 0, 0, 0, 0, 0, 23, 240, 164, 0, 0, 0],
            &[0, 0, 136, 249, 26, 0, 0, 0, 0, 0, 0, 0, 145, 246, 9, 0, 0],
            &[0, 0, 217, 182, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 62, 0, 0],
            &[
                0, 7, 255, 169, 73, 73, 73, 73, 73, 73, 73, 73, 116, 255, 86, 0, 0,
            ],
            &[
                0, 30, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99, 0, 0,
            ],
            &[0, 29, 255, 123, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0],
            &[0, 5, 254, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 208, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 120, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 219, 222, 36, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0],
            &[
                0, 0, 0, 46, 223, 242, 141, 65, 36, 25, 45, 92, 175, 210, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 17, 136, 228, 255, 255, 255, 255, 247, 181, 93, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 27, 53, 58, 32, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ė' / 0x116
        'Ė' => &[
            &[0, 0, 0, 0, 0, 0, 0, 120, 207, 51, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 221, 255, 127, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 91, 170, 37, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 60, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 121, 32, 32, 32, 32, 32, 32, 32, 32, 27, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 229, 211, 211, 211, 211, 211, 211, 211, 211, 65, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 191, 147, 147, 147, 147, 147, 147, 147, 147, 45, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 168, 110, 110, 110, 110, 110, 110, 110, 110, 93, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ė' / 0x117
        'ė' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 2, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 201, 249, 58, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 2, 237, 255, 92, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 58, 101, 8, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 6, 86, 130, 154, 132, 81, 3, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 83, 231, 252, 205, 182, 207, 254, 221, 45, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 95, 253, 174, 28, 0, 0, 0, 39, 207, 238, 27, 0, 0, 0,
            ],
            &[0, 0, 27, 241, 175, 1, 0, 0, 0, 0, 0, 23, 240, 164, 0, 0, 0],
            &[0, 0, 136, 249, 26, 0, 0, 0, 0, 0, 0, 0, 145, 246, 9, 0, 0],
            &[0, 0, 217, 182, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 62, 0, 0],
            &[
                0, 7, 255, 169, 73, 73, 73, 73, 73, 73, 73, 73, 116, 255, 86, 0, 0,
            ],
            &[
                0, 30, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99, 0, 0,
            ],
            &[0, 29, 255, 123, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0],
            &[0, 5, 254, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 208, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 120, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 219, 222, 36, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0],
            &[
                0, 0, 0, 46, 223, 242, 141, 65, 36, 25, 45, 92, 175, 210, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 17, 136, 228, 255, 255, 255, 255, 247, 181, 93, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 27, 53, 58, 32, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ę' / 0x118
        'Ę' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 60, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 121, 32, 32, 32, 32, 32, 32, 32, 32, 27, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 229, 211, 211, 211, 211, 211, 211, 211, 211, 65, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 191, 147, 147, 147, 147, 147, 147, 147, 147, 45, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 168, 110, 110, 110, 110, 110, 110, 110, 110, 93, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 203, 15, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 217, 18, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 227, 91, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 22, 255, 68, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 4, 235, 193, 81, 70, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 189, 220, 166, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ę' / 0x119
        'ę' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 6, 86, 130, 154, 132, 81, 3, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 83, 231, 252, 205, 182, 207, 254, 221, 45, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 95, 253, 174, 28, 0, 0, 0, 39, 207, 238, 27, 0, 0, 0,
            ],
            &[0, 0, 27, 241, 175, 1, 0, 0, 0, 0, 0, 23, 240, 164, 0, 0, 0],
            &[0, 0, 136, 249, 26, 0, 0, 0, 0, 0, 0, 0, 145, 246, 9, 0, 0],
            &[0, 0, 217, 182, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 62, 0, 0],
            &[
                0, 7, 255, 169, 73, 73, 73, 73, 73, 73, 73, 73, 116, 255, 86, 0, 0,
            ],
            &[
                0, 30, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99, 0, 0,
            ],
            &[0, 29, 255, 123, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0],
            &[0, 5, 254, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 208, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 120, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 219, 222, 36, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0],
            &[
                0, 0, 0, 46, 223, 242, 141, 65, 36, 25, 45, 92, 175, 210, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 17, 136, 228, 255, 255, 255, 255, 255, 255, 181, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 27, 53, 58, 47, 211, 113, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 187, 135, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 249, 10, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 243, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 255, 155, 73, 49, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 203, 217, 103, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ě' / 0x11a
        'Ě' => &[
            &[0, 0, 0, 0, 21, 219, 141, 0, 0, 27, 215, 146, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 39, 240, 129, 19, 214, 177, 2, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 77, 255, 223, 216, 12, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 131, 185, 54, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 60, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 121, 32, 32, 32, 32, 32, 32, 32, 32, 27, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 229, 211, 211, 211, 211, 211, 211, 211, 211, 65, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 191, 147, 147, 147, 147, 147, 147, 147, 147, 45, 0, 0, 0,
            ],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 42, 255, 168, 110, 110, 110, 110, 110, 110, 110, 110, 93, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 105, 0, 0, 0, 0, 21, 141, 34, 0, 0, 0, 0],
        ],
        // letter: 'ě' / 0x11b
        'ě' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 110, 111, 0, 0, 0, 0, 46, 163, 19, 0, 0, 0, 0],
            &[0, 0, 0, 0, 25, 223, 136, 0, 0, 54, 238, 99, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 45, 243, 121, 43, 238, 133, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 89, 255, 237, 183, 1, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 128, 162, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 6, 86, 130, 154, 132, 81, 3, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 83, 231, 252, 205, 182, 207, 254, 221, 45, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 95, 253, 174, 28, 0, 0, 0, 39, 207, 238, 27, 0, 0, 0,
            ],
            &[0, 0, 27, 241, 175, 1, 0, 0, 0, 0, 0, 23, 240, 164, 0, 0, 0],
            &[0, 0, 136, 249, 26, 0, 0, 0, 0, 0, 0, 0, 145, 246, 9, 0, 0],
            &[0, 0, 217, 182, 0, 0, 0, 0, 0, 0, 0, 0, 83, 255, 62, 0, 0],
            &[
                0, 7, 255, 169, 73, 73, 73, 73, 73, 73, 73, 73, 116, 255, 86, 0, 0,
            ],
            &[
                0, 30, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 99, 0, 0,
            ],
            &[0, 29, 255, 123, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0],
            &[0, 5, 254, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 208, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 120, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 11, 219, 222, 36, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0],
            &[
                0, 0, 0, 46, 223, 242, 141, 65, 36, 25, 45, 92, 175, 210, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 17, 136, 228, 255, 255, 255, 255, 247, 181, 93, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 27, 53, 58, 32, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ĝ' / 0x11c
        'Ĝ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 1, 185, 238, 254, 68, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 131, 233, 36, 143, 234, 31, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 89, 236, 50, 0, 1, 158, 210, 14, 0, 0, 0],
            &[0, 0, 0, 0, 0, 20, 177, 48, 0, 0, 0, 1, 135, 111, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 28, 97, 134, 139, 111, 78, 14, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 21, 166, 253, 255, 246, 227, 251, 255, 247, 115, 0, 0,
            ],
            &[
                0, 0, 0, 0, 30, 224, 248, 146, 35, 1, 0, 2, 41, 133, 78, 0, 0,
            ],
            &[0, 0, 0, 4, 205, 248, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 103, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 212, 225, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 37, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 94, 255, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 131, 255, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 154, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 163, 252, 0, 0, 0, 0, 0, 104, 211, 211, 211, 211, 208, 0, 0,
            ],
            &[
                0, 0, 158, 255, 7, 0, 0, 0, 0, 76, 154, 154, 154, 210, 252, 0, 0,
            ],
            &[0, 0, 141, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 108, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 55, 255, 125, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 2, 231, 214, 2, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 0, 125, 255, 98, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 0, 10, 217, 248, 76, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[
                0, 0, 0, 0, 35, 221, 255, 183, 92, 59, 53, 81, 141, 231, 252, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 15, 136, 233, 255, 255, 255, 255, 245, 180, 85, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 1, 36, 62, 61, 38, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 26, 145, 105, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ĝ' / 0x11d
        'ĝ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 1, 142, 165, 20, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 113, 248, 233, 172, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 63, 249, 86, 47, 241, 118, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 38, 234, 102, 0, 0, 61, 240, 80, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 124, 91, 0, 0, 0, 0, 55, 154, 7, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 64, 132, 155, 139, 88, 7, 0, 53, 66, 0, 0],
            &[
                0, 0, 0, 0, 19, 190, 255, 227, 186, 194, 238, 217, 36, 166, 183, 0, 0,
            ],
            &[
                0, 0, 0, 3, 200, 243, 83, 0, 0, 0, 9, 130, 214, 205, 183, 0, 0,
            ],
            &[0, 0, 0, 103, 255, 85, 0, 0, 0, 0, 0, 0, 157, 255, 183, 0, 0],
            &[0, 0, 0, 205, 213, 0, 0, 0, 0, 0, 0, 0, 40, 255, 183, 0, 0],
            &[0, 0, 14, 254, 139, 0, 0, 0, 0, 0, 0, 0, 0, 233, 183, 0, 0],
            &[0, 0, 53, 255, 97, 0, 0, 0, 0, 0, 0, 0, 0, 205, 183, 0, 0],
            &[0, 0, 69, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 191, 183, 0, 0],
            &[0, 0, 68, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 195, 183, 0, 0],
            &[0, 0, 51, 255, 104, 0, 0, 0, 0, 0, 0, 0, 0, 221, 183, 0, 0],
            &[0, 0, 10, 252, 152, 0, 0, 0, 0, 0, 0, 0, 6, 249, 183, 0, 0],
            &[0, 0, 0, 192, 232, 8, 0, 0, 0, 0, 0, 0, 80, 255, 183, 0, 0],
            &[
                0, 0, 0, 79, 255, 138, 0, 0, 0, 0, 0, 16, 213, 228, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 155, 255, 166, 60, 21, 29, 89, 217, 144, 191, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 1, 114, 233, 255, 255, 255, 236, 123, 1, 195, 183, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 42, 62, 42, 6, 0, 0, 199, 182, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 164, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 254, 130, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 255, 50, 0, 0],
            &[0, 0, 0, 103, 106, 24, 0, 0, 0, 0, 6, 111, 251, 165, 0, 0, 0],
            &[
                0, 0, 0, 97, 238, 255, 223, 188, 178, 194, 241, 255, 156, 10, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 5, 69, 123, 151, 159, 140, 108, 31, 0, 0, 0, 0, 0,
            ],
        ],
        // letter: 'Ğ' / 0x11e
        'Ğ' => &[
            &[0, 0, 0, 0, 0, 0, 171, 52, 0, 0, 0, 0, 139, 77, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 172, 182, 8, 0, 0, 51, 247, 45, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 29, 225, 221, 161, 176, 248, 127, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 10, 100, 139, 120, 52, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 28, 97, 134, 139, 111, 78, 14, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 21, 166, 253, 255, 246, 227, 251, 255, 247, 115, 0, 0,
            ],
            &[
                0, 0, 0, 0, 30, 224, 248, 146, 35, 1, 0, 2, 41, 133, 78, 0, 0,
            ],
            &[0, 0, 0, 4, 205, 248, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 103, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 212, 225, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 37, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 94, 255, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 131, 255, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 154, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 163, 252, 0, 0, 0, 0, 0, 104, 211, 211, 211, 211, 208, 0, 0,
            ],
            &[
                0, 0, 158, 255, 7, 0, 0, 0, 0, 76, 154, 154, 154, 210, 252, 0, 0,
            ],
            &[0, 0, 141, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 108, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 55, 255, 125, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 2, 231, 214, 2, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 0, 125, 255, 98, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 0, 10, 217, 248, 76, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[
                0, 0, 0, 0, 35, 221, 255, 183, 92, 59, 53, 81, 141, 231, 252, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 15, 136, 233, 255, 255, 255, 255, 245, 180, 85, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 1, 36, 62, 61, 38, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ğ' / 0x11f
        'ğ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 116, 135, 0, 0, 0, 0, 85, 157, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 72, 245, 55, 0, 0, 18, 211, 124, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 142, 249, 197, 182, 241, 185, 6, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 49, 107, 111, 64, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 64, 132, 155, 139, 88, 7, 0, 53, 66, 0, 0],
            &[
                0, 0, 0, 0, 19, 190, 255, 227, 186, 194, 238, 217, 36, 166, 183, 0, 0,
            ],
            &[
                0, 0, 0, 3, 200, 243, 83, 0, 0, 0, 9, 130, 214, 205, 183, 0, 0,
            ],
            &[0, 0, 0, 103, 255, 85, 0, 0, 0, 0, 0, 0, 157, 255, 183, 0, 0],
            &[0, 0, 0, 205, 213, 0, 0, 0, 0, 0, 0, 0, 40, 255, 183, 0, 0],
            &[0, 0, 14, 254, 139, 0, 0, 0, 0, 0, 0, 0, 0, 233, 183, 0, 0],
            &[0, 0, 53, 255, 97, 0, 0, 0, 0, 0, 0, 0, 0, 205, 183, 0, 0],
            &[0, 0, 69, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 191, 183, 0, 0],
            &[0, 0, 68, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 195, 183, 0, 0],
            &[0, 0, 51, 255, 104, 0, 0, 0, 0, 0, 0, 0, 0, 221, 183, 0, 0],
            &[0, 0, 10, 252, 152, 0, 0, 0, 0, 0, 0, 0, 6, 249, 183, 0, 0],
            &[0, 0, 0, 192, 232, 8, 0, 0, 0, 0, 0, 0, 80, 255, 183, 0, 0],
            &[
                0, 0, 0, 79, 255, 138, 0, 0, 0, 0, 0, 16, 213, 228, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 155, 255, 166, 60, 21, 29, 89, 217, 144, 191, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 1, 114, 233, 255, 255, 255, 236, 123, 1, 195, 183, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 42, 62, 42, 6, 0, 0, 199, 182, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 164, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 254, 130, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 255, 50, 0, 0],
            &[0, 0, 0, 103, 106, 24, 0, 0, 0, 0, 6, 111, 251, 165, 0, 0, 0],
            &[
                0, 0, 0, 97, 238, 255, 223, 188, 178, 194, 241, 255, 156, 10, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 5, 69, 123, 151, 159, 140, 108, 31, 0, 0, 0, 0, 0,
            ],
        ],
        // letter: 'Ġ' / 0x120
        'Ġ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 41, 204, 133, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 110, 255, 238, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 28, 168, 102, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 28, 97, 134, 139, 111, 78, 14, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 21, 166, 253, 255, 246, 227, 251, 255, 247, 115, 0, 0,
            ],
            &[
                0, 0, 0, 0, 30, 224, 248, 146, 35, 1, 0, 2, 41, 133, 78, 0, 0,
            ],
            &[0, 0, 0, 4, 205, 248, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 103, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 212, 225, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 37, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 94, 255, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 131, 255, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 154, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 163, 252, 0, 0, 0, 0, 0, 104, 211, 211, 211, 211, 208, 0, 0,
            ],
            &[
                0, 0, 158, 255, 7, 0, 0, 0, 0, 76, 154, 154, 154, 210, 252, 0, 0,
            ],
            &[0, 0, 141, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 108, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 55, 255, 125, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 2, 231, 214, 2, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 0, 125, 255, 98, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 0, 10, 217, 248, 76, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[
                0, 0, 0, 0, 35, 221, 255, 183, 92, 59, 53, 81, 141, 231, 252, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 15, 136, 233, 255, 255, 255, 255, 245, 180, 85, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 1, 36, 62, 61, 38, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ġ' / 0x121
        'ġ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 5, 13, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 4, 224, 244, 34, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 17, 251, 255, 64, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 71, 93, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 64, 132, 155, 139, 88, 7, 0, 53, 66, 0, 0],
            &[
                0, 0, 0, 0, 19, 190, 255, 227, 186, 194, 238, 217, 36, 166, 183, 0, 0,
            ],
            &[
                0, 0, 0, 3, 200, 243, 83, 0, 0, 0, 9, 130, 214, 205, 183, 0, 0,
            ],
            &[0, 0, 0, 103, 255, 85, 0, 0, 0, 0, 0, 0, 157, 255, 183, 0, 0],
            &[0, 0, 0, 205, 213, 0, 0, 0, 0, 0, 0, 0, 40, 255, 183, 0, 0],
            &[0, 0, 14, 254, 139, 0, 0, 0, 0, 0, 0, 0, 0, 233, 183, 0, 0],
            &[0, 0, 53, 255, 97, 0, 0, 0, 0, 0, 0, 0, 0, 205, 183, 0, 0],
            &[0, 0, 69, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 191, 183, 0, 0],
            &[0, 0, 68, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 195, 183, 0, 0],
            &[0, 0, 51, 255, 104, 0, 0, 0, 0, 0, 0, 0, 0, 221, 183, 0, 0],
            &[0, 0, 10, 252, 152, 0, 0, 0, 0, 0, 0, 0, 6, 249, 183, 0, 0],
            &[0, 0, 0, 192, 232, 8, 0, 0, 0, 0, 0, 0, 80, 255, 183, 0, 0],
            &[
                0, 0, 0, 79, 255, 138, 0, 0, 0, 0, 0, 16, 213, 228, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 155, 255, 166, 60, 21, 29, 89, 217, 144, 191, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 1, 114, 233, 255, 255, 255, 236, 123, 1, 195, 183, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 42, 62, 42, 6, 0, 0, 199, 182, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 164, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 254, 130, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 255, 50, 0, 0],
            &[0, 0, 0, 103, 106, 24, 0, 0, 0, 0, 6, 111, 251, 165, 0, 0, 0],
            &[
                0, 0, 0, 97, 238, 255, 223, 188, 178, 194, 241, 255, 156, 10, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 5, 69, 123, 151, 159, 140, 108, 31, 0, 0, 0, 0, 0,
            ],
        ],
        // letter: 'Ģ' / 0x122
        'Ģ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 28, 97, 134, 139, 111, 78, 14, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 21, 166, 253, 255, 246, 227, 251, 255, 247, 115, 0, 0,
            ],
            &[
                0, 0, 0, 0, 30, 224, 248, 146, 35, 1, 0, 2, 41, 133, 78, 0, 0,
            ],
            &[0, 0, 0, 4, 205, 248, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 103, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 212, 225, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 37, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 94, 255, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 131, 255, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 154, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 163, 252, 0, 0, 0, 0, 0, 104, 211, 211, 211, 211, 208, 0, 0,
            ],
            &[
                0, 0, 158, 255, 7, 0, 0, 0, 0, 76, 154, 154, 154, 210, 252, 0, 0,
            ],
            &[0, 0, 141, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 108, 255, 63, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 55, 255, 125, 0, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 2, 231, 214, 2, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 0, 125, 255, 98, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[0, 0, 0, 10, 217, 248, 76, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0],
            &[
                0, 0, 0, 0, 35, 221, 255, 183, 92, 59, 53, 81, 141, 231, 252, 0, 0,
            ],
            &[
                0, 0, 0, 0, 0, 15, 136, 233, 255, 255, 255, 255, 245, 180, 85, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 1, 36, 62, 61, 38, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 78, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 170, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 28, 255, 77, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 104, 214, 1, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 189, 69, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ģ' / 0x123
        'ģ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 116, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 1, 207, 100, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 76, 253, 20, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 178, 205, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 161, 106, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 64, 132, 155, 139, 88, 7, 0, 53, 66, 0, 0],
            &[
                0, 0, 0, 0, 19, 190, 255, 227, 186, 194, 238, 217, 36, 166, 183, 0, 0,
            ],
            &[
                0, 0, 0, 3, 200, 243, 83, 0, 0, 0, 9, 130, 214, 205, 183, 0, 0,
            ],
            &[0, 0, 0, 103, 255, 85, 0, 0, 0, 0, 0, 0, 157, 255, 183, 0, 0],
            &[0, 0, 0, 205, 213, 0, 0, 0, 0, 0, 0, 0, 40, 255, 183, 0, 0],
            &[0, 0, 14, 254, 139, 0, 0, 0, 0, 0, 0, 0, 0, 233, 183, 0, 0],
            &[0, 0, 53, 255, 97, 0, 0, 0, 0, 0, 0, 0, 0, 205, 183, 0, 0],
            &[0, 0, 69, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 191, 183, 0, 0],
            &[0, 0, 68, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 195, 183, 0, 0],
            &[0, 0, 51, 255, 104, 0, 0, 0, 0, 0, 0, 0, 0, 221, 183, 0, 0],
            &[0, 0, 10, 252, 152, 0, 0, 0, 0, 0, 0, 0, 6, 249, 183, 0, 0],
            &[0, 0, 0, 192, 232, 8, 0, 0, 0, 0, 0, 0, 80, 255, 183, 0, 0],
            &[
                0, 0, 0, 79, 255, 138, 0, 0, 0, 0, 0, 16, 213, 228, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 155, 255, 166, 60, 21, 29, 89, 217, 144, 191, 183, 0, 0,
            ],
            &[
                0, 0, 0, 0, 1, 114, 233, 255, 255, 255, 236, 123, 1, 195, 183, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 2, 42, 62, 42, 6, 0, 0, 199, 182, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 164, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 254, 130, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 255, 50, 0, 0],
            &[0, 0, 0, 103, 106, 24, 0, 0, 0, 0, 6, 111, 251, 165, 0, 0, 0],
            &[
                0, 0, 0, 97, 238, 255, 223, 188, 178, 194, 241, 255, 156, 10, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 5, 69, 123, 151, 159, 140, 108, 31, 0, 0, 0, 0, 0,
            ],
        ],
        // letter: 'Ĥ' / 0x124
        'Ĥ' => &[
            &[0, 0, 0, 0, 0, 0, 97, 252, 241, 157, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 246, 104, 61, 247, 100, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 226, 122, 0, 0, 77, 242, 65, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 134, 112, 0, 0, 0, 0, 71, 169, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[
                0, 0, 194, 247, 211, 211, 211, 211, 211, 211, 211, 211, 237, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 236, 154, 154, 154, 154, 154, 154, 154, 154, 213, 252, 0, 0, 0,
            ],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 120, 143, 13, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ĥ' / 0x125
        'ĥ' => &[
            &[0, 0, 55, 247, 92, 10, 200, 189, 4, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 34, 231, 105, 0, 0, 17, 202, 155, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 80, 80, 0, 0, 0, 0, 14, 120, 25, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 65, 133, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 125, 255, 19, 0, 37, 119, 153, 151, 108, 22, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 125, 255, 16, 130, 252, 214, 185, 213, 252, 245, 87, 0, 0,
            ],
            &[
                0, 0, 0, 0, 125, 255, 116, 216, 50, 0, 0, 0, 47, 215, 250, 43, 0,
            ],
            &[
                0, 0, 0, 0, 125, 255, 224, 25, 0, 0, 0, 0, 0, 58, 255, 146, 0,
            ],
            &[0, 0, 0, 0, 125, 255, 134, 0, 0, 0, 0, 0, 0, 0, 227, 197, 0],
            &[0, 0, 0, 0, 125, 255, 62, 0, 0, 0, 0, 0, 0, 0, 194, 215, 0],
            &[0, 0, 0, 0, 125, 255, 33, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 125, 255, 20, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 100, 250, 200, 226, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ħ' / 0x126
        'Ħ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[
                127, 127, 255, 255, 127, 127, 127, 127, 127, 127, 127, 127, 255, 255, 127, 127, 25,
            ],
            &[
                211, 211, 255, 255, 211, 211, 211, 211, 211, 211, 211, 211, 255, 255, 211, 211, 42,
            ],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[
                0, 0, 194, 247, 211, 211, 211, 211, 211, 211, 211, 211, 237, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 236, 154, 154, 154, 154, 154, 154, 154, 154, 213, 252, 0, 0, 0,
            ],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ħ' / 0x127
        'ħ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 65, 133, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 230, 230, 255, 255, 250, 230, 230, 230, 230, 66, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 87, 87, 212, 255, 106, 87, 87, 87, 87, 25, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 125, 255, 19, 0, 37, 119, 153, 151, 108, 22, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 125, 255, 16, 130, 252, 214, 185, 213, 252, 245, 87, 0, 0, 0,
            ],
            &[
                0, 0, 0, 125, 255, 116, 216, 50, 0, 0, 0, 47, 215, 250, 43, 0, 0,
            ],
            &[
                0, 0, 0, 125, 255, 224, 25, 0, 0, 0, 0, 0, 58, 255, 146, 0, 0,
            ],
            &[0, 0, 0, 125, 255, 134, 0, 0, 0, 0, 0, 0, 0, 227, 197, 0, 0],
            &[0, 0, 0, 125, 255, 62, 0, 0, 0, 0, 0, 0, 0, 194, 215, 0, 0],
            &[0, 0, 0, 125, 255, 33, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0],
            &[0, 0, 0, 125, 255, 20, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ĩ' / 0x128
        'Ĩ' => &[
            &[0, 0, 0, 0, 6, 90, 103, 30, 0, 0, 0, 45, 90, 0, 0, 0, 0],
            &[
                0, 0, 0, 1, 194, 245, 228, 246, 112, 1, 0, 158, 131, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 71, 220, 15, 0, 91, 238, 225, 219, 236, 24, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 65, 83, 0, 0, 0, 23, 110, 120, 29, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 25, 71, 71, 71, 71, 71, 71, 71, 71, 39, 0, 0, 0, 0],
            &[
                0, 0, 0, 76, 225, 240, 253, 255, 255, 254, 243, 228, 120, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 177, 227, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 10, 40, 55, 70, 200, 235, 73, 58, 43, 17, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 90, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ĩ' / 0x129
        'ĩ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 13, 112, 125, 46, 0, 0, 0, 54, 104, 0, 0, 0, 0],
            &[
                0, 0, 0, 4, 208, 232, 207, 251, 134, 6, 5, 171, 124, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 77, 212, 5, 0, 70, 226, 241, 236, 225, 17, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 56, 69, 0, 0, 0, 13, 88, 98, 18, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 10, 93, 93, 93, 93, 93, 93, 34, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 21, 197, 210, 223, 235, 248, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ī' / 0x12a
        'Ī' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 17, 28, 28, 28, 28, 28, 28, 23, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 160, 255, 255, 255, 255, 255, 255, 211, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 29, 47, 47, 47, 47, 47, 47, 38, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 25, 71, 71, 71, 71, 71, 71, 71, 71, 39, 0, 0, 0, 0],
            &[
                0, 0, 0, 76, 225, 240, 253, 255, 255, 254, 243, 228, 120, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 177, 227, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 10, 40, 55, 70, 200, 235, 73, 58, 43, 17, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 90, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ī' / 0x12b
        'ī' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 31, 50, 50, 50, 50, 50, 50, 41, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 160, 255, 255, 255, 255, 255, 255, 211, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 15, 25, 25, 25, 25, 25, 25, 20, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 10, 93, 93, 93, 93, 93, 93, 34, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 21, 197, 210, 223, 235, 248, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ĭ' / 0x12c
        'Ĭ' => &[
            &[0, 0, 0, 0, 105, 117, 0, 0, 0, 0, 73, 143, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 82, 240, 39, 0, 0, 9, 201, 133, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 164, 243, 175, 160, 228, 204, 11, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 70, 129, 133, 86, 3, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 25, 71, 71, 71, 71, 71, 71, 71, 71, 39, 0, 0, 0, 0],
            &[
                0, 0, 0, 76, 225, 240, 253, 255, 255, 254, 243, 228, 120, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 177, 227, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 10, 40, 55, 70, 200, 235, 73, 58, 43, 17, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 90, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ĭ' / 0x12d
        'ĭ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 116, 135, 0, 0, 0, 0, 85, 157, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 72, 245, 55, 0, 0, 18, 211, 124, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 142, 249, 197, 182, 241, 185, 6, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 49, 107, 111, 64, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 10, 93, 93, 93, 93, 93, 93, 34, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 21, 197, 210, 223, 235, 248, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Į' / 0x12e
        'Į' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 25, 71, 71, 71, 71, 71, 71, 71, 71, 39, 0, 0, 0, 0],
            &[
                0, 0, 0, 76, 225, 240, 253, 255, 255, 254, 243, 228, 120, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 177, 227, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 10, 40, 55, 70, 200, 235, 73, 58, 43, 17, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 90, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 114, 214, 23, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 74, 229, 27, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 206, 112, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 5, 252, 88, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 218, 204, 85, 76, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 47, 183, 219, 183, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'į' / 0x12f
        'į' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 145, 254, 107, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 185, 255, 147, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 35, 109, 22, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 10, 93, 93, 93, 93, 93, 93, 34, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 21, 197, 210, 223, 235, 248, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 203, 15, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 217, 18, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 227, 91, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 22, 255, 68, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 4, 235, 193, 81, 70, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 189, 220, 166, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'İ' / 0x130
        'İ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 166, 194, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 21, 255, 255, 72, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 130, 157, 11, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 25, 71, 71, 71, 71, 71, 71, 71, 71, 39, 0, 0, 0, 0],
            &[
                0, 0, 0, 76, 225, 240, 253, 255, 255, 254, 243, 228, 120, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 1, 177, 227, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 10, 40, 55, 70, 200, 235, 73, 58, 43, 17, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 90, 255, 255, 255, 255, 255, 255, 255, 255, 142, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ı' / 0x131
        'ı' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 10, 93, 93, 93, 93, 93, 93, 34, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 21, 197, 210, 223, 235, 248, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ĳ' / 0x132
        'Ĳ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 5, 71, 34, 0, 0, 0, 0, 0, 0, 18, 71, 22, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 65, 255, 79, 0, 0, 0],
            &[0, 0, 21, 255, 123, 0, 0, 0, 0, 0, 0, 72, 255, 75, 0, 0, 0],
            &[0, 0, 6, 77, 37, 0, 0, 0, 0, 0, 0, 96, 255, 55, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 250, 16, 0, 0, 0],
            &[0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 52, 250, 180, 0, 0, 0, 0],
            &[
                0, 0, 0, 229, 149, 84, 50, 33, 54, 127, 244, 241, 36, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 143, 234, 255, 255, 255, 255, 253, 187, 39, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 33, 63, 77, 59, 23, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ĳ' / 0x133
        'ĳ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 13, 6, 0, 0, 0, 0],
            &[0, 0, 0, 174, 253, 84, 0, 0, 0, 0, 35, 245, 227, 4, 0, 0, 0],
            &[
                0, 0, 0, 212, 255, 121, 0, 0, 0, 0, 61, 255, 252, 18, 0, 0, 0,
            ],
            &[0, 0, 0, 45, 107, 15, 0, 0, 0, 0, 2, 94, 73, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 45, 93, 7, 0, 0, 0, 0, 0, 74, 71, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 197, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 205, 197, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 227, 184, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 255, 139, 0, 0, 0, 0],
            &[0, 0, 0, 40, 30, 0, 0, 0, 0, 44, 215, 248, 36, 0, 0, 0, 0],
            &[
                0, 0, 0, 118, 255, 229, 195, 187, 214, 255, 237, 75, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 9, 66, 118, 143, 159, 143, 94, 13, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ĵ' / 0x134
        'Ĵ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 78, 254, 239, 176, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 37, 239, 124, 47, 241, 120, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 18, 215, 142, 0, 0, 62, 241, 81, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 120, 126, 0, 0, 0, 0, 57, 175, 15, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 68, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 245, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 242, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 224, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 2, 235, 185, 0, 0, 0, 0, 0, 0],
            &[0, 1, 6, 0, 0, 0, 0, 0, 102, 255, 108, 0, 0, 0, 0, 0, 0],
            &[
                0, 7, 232, 132, 61, 33, 49, 130, 251, 216, 7, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 2, 149, 239, 255, 255, 255, 254, 183, 24, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 6, 40, 71, 65, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 145, 22, 0, 0, 0, 0, 0],
        ],
        // letter: 'ĵ' / 0x135
        'ĵ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 166, 23, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 107, 250, 231, 178, 1, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 58, 248, 92, 43, 238, 125, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 34, 231, 108, 0, 0, 57, 238, 86, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 119, 96, 0, 0, 0, 0, 51, 155, 9, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 28, 93, 93, 93, 93, 93, 93, 16, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 57, 200, 212, 225, 238, 251, 255, 45, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 45, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 34, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 243, 4, 0, 0, 0, 0, 0],
            &[0, 0, 7, 28, 0, 0, 0, 2, 117, 255, 146, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 28, 255, 229, 195, 190, 231, 255, 182, 9, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 4, 71, 119, 145, 158, 135, 66, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ķ' / 0x136
        'Ķ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 34, 71, 28, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 33, 232, 208, 12, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 17, 215, 230, 28, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 6, 192, 245, 51, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 164, 253, 81, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 131, 255, 116, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 98, 255, 154, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 69, 251, 188, 4, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 45, 241, 214, 16, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 18, 223, 255, 173, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 194, 207, 177, 227, 134, 255, 87, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 194, 252, 234, 39, 1, 190, 236, 23, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 194, 243, 49, 0, 0, 32, 243, 174, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 105, 255, 90, 0, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 1, 189, 237, 24, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 32, 243, 178, 0, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 104, 255, 93, 0, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 1, 187, 239, 26, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 31, 242, 181, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 102, 255, 97, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 21, 90, 31, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 95, 255, 39, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 159, 202, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 3, 232, 84, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 69, 189, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ķ' / 0x137
        'ķ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 90, 118, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 45, 93, 40, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 49, 240, 192, 9, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 42, 235, 202, 13, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 35, 230, 211, 18, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 29, 224, 219, 24, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 224, 0, 0, 23, 217, 226, 31, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 219, 0, 18, 210, 254, 45, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 173, 212, 12, 201, 221, 249, 146, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 173, 207, 183, 212, 24, 115, 255, 79, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 173, 255, 206, 20, 0, 1, 185, 237, 28, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 173, 238, 16, 0, 0, 0, 24, 234, 193, 3, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 75, 255, 128, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 145, 252, 63, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 7, 209, 228, 19, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 42, 246, 178, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 57, 85, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 199, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 13, 249, 98, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 83, 229, 7, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 169, 89, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ĸ' / 0x138
        'ĸ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 63, 82, 0, 0, 0, 0, 0, 0, 0, 45, 93, 40, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 49, 240, 192, 9, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 42, 235, 202, 13, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 35, 230, 211, 18, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 29, 224, 219, 24, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 224, 0, 0, 23, 217, 226, 31, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 173, 219, 0, 18, 210, 254, 45, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 173, 212, 12, 201, 221, 249, 146, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 173, 207, 183, 212, 24, 115, 255, 79, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 173, 255, 206, 20, 0, 1, 185, 237, 28, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 173, 238, 16, 0, 0, 0, 24, 234, 193, 3, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 75, 255, 128, 0, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 145, 252, 63, 0, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 7, 209, 228, 19, 0, 0, 0],
            &[0, 0, 173, 226, 0, 0, 0, 0, 0, 0, 0, 42, 246, 178, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ĺ' / 0x139
        'Ĺ' => &[
            &[0, 0, 0, 0, 0, 94, 255, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 43, 244, 153, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 19, 219, 158, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 119, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 29, 71, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 104, 255, 138, 117, 117, 117, 117, 117, 117, 117, 99, 0, 0, 0,
            ],
            &[
                0, 0, 0, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 126, 150, 18, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ĺ' / 0x13a
        'ĺ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 150, 236, 44, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 106, 232, 49, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 4, 120, 35, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 25, 133, 133, 133, 133, 133, 133, 49, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 29, 158, 171, 183, 196, 216, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 6, 202, 230, 28, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ļ' / 0x13b
        'Ļ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 29, 71, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 104, 255, 138, 117, 117, 117, 117, 117, 117, 117, 99, 0, 0, 0,
            ],
            &[
                0, 0, 0, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 62, 80, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 213, 177, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 22, 254, 84, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 97, 219, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 182, 76, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ļ' / 0x13c
        'ļ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 25, 133, 133, 133, 133, 133, 133, 49, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 29, 158, 171, 183, 196, 216, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 13, 90, 39, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 75, 255, 59, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 138, 220, 2, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 215, 105, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 49, 206, 4, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ľ' / 0x13d
        'Ľ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 29, 71, 11, 0, 0, 0, 0, 0, 19, 71, 21, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 101, 255, 33, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 158, 202, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 226, 92, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 55, 213, 3, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 3, 6, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 104, 255, 138, 117, 117, 117, 117, 117, 117, 117, 99, 0, 0, 0,
            ],
            &[
                0, 0, 0, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ľ' / 0x13e
        'ľ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 25, 133, 133, 133, 133, 133, 133, 49, 0, 0, 33, 133, 44, 0, 0,
            ],
            &[
                0, 0, 29, 158, 171, 183, 196, 216, 255, 94, 0, 0, 100, 255, 28, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 160, 190, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 1, 230, 76, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 42, 168, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ŀ' / 0x13f
        'Ŀ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 29, 71, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 5, 32, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 190, 255, 82, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 214, 255, 106, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 51, 110, 13, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 104, 255, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 104, 255, 138, 117, 117, 117, 117, 117, 117, 117, 99, 0, 0, 0,
            ],
            &[
                0, 0, 0, 104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 217, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ŀ' / 0x140
        'ŀ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                25, 133, 133, 133, 133, 133, 133, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                29, 158, 171, 183, 196, 216, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 10, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 185, 247, 56, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 234, 255, 96, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 79, 135, 16, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0, 0, 0,
            ],
            &[
                145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ł' / 0x141
        'Ł' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 23, 71, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 0, 9, 9, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 74, 222, 129, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 89, 173, 255, 163, 23, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 88, 255, 255, 214, 64, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 57, 255, 255, 181, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 152, 254, 255, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 126, 78, 84, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 84, 255, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 84, 255, 150, 117, 117, 117, 117, 117, 117, 117, 109, 0, 0,
            ],
            &[
                0, 0, 0, 0, 84, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ł' / 0x142
        'ł' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 25, 133, 133, 133, 133, 133, 133, 49, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 29, 158, 171, 183, 196, 216, 255, 94, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 4, 120, 123, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 149, 209, 241, 103, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 63, 255, 255, 175, 27, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 79, 255, 255, 175, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 26, 173, 253, 199, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 152, 211, 56, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 12, 5, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 50, 255, 94, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 17, 39, 51, 62, 74, 118, 255, 148, 75, 63, 51, 38, 13, 0, 0,
            ],
            &[
                0, 0, 145, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 113, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ń' / 0x143
        'Ń' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 130, 255, 91, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 69, 253, 118, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 37, 236, 125, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 145, 102, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 71, 19, 0, 0, 0, 0, 0, 0, 0, 39, 70, 0, 0, 0],
            &[0, 0, 194, 255, 151, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[0, 0, 194, 239, 249, 28, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[
                0, 0, 194, 164, 228, 147, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 171, 110, 247, 25, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 183, 9, 232, 142, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 189, 0, 115, 245, 22, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 11, 235, 137, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 121, 243, 19, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 13, 238, 132, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 127, 241, 16, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 16, 241, 127, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 132, 238, 14, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 19, 243, 122, 0, 139, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 138, 236, 12, 135, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 22, 246, 117, 128, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 143, 233, 129, 252, 0, 0, 0,
            ],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 26, 248, 220, 252, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 149, 255, 252, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 30, 250, 252, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 142, 143, 4, 0, 0, 0, 0],
        ],
        // letter: 'ń' / 0x144
        'ń' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 148, 169, 17, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 255, 106, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 56, 249, 132, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 29, 229, 136, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 111, 104, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 45, 74, 0, 0, 40, 119, 152, 152, 113, 28, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 218, 1, 146, 252, 207, 183, 210, 250, 248, 98, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 239, 111, 198, 36, 0, 0, 0, 37, 205, 253, 51, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 222, 15, 0, 0, 0, 0, 0, 45, 253, 153, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 123, 0, 0, 0, 0, 0, 0, 0, 222, 201, 0, 0, 0],
            &[0, 0, 125, 255, 58, 0, 0, 0, 0, 0, 0, 0, 191, 216, 0, 0, 0],
            &[0, 0, 125, 255, 29, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ņ' / 0x145
        'Ņ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 71, 19, 0, 0, 0, 0, 0, 0, 0, 39, 70, 0, 0, 0],
            &[0, 0, 194, 255, 151, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[0, 0, 194, 239, 249, 28, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[
                0, 0, 194, 164, 228, 147, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 171, 110, 247, 25, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 183, 9, 232, 142, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 189, 0, 115, 245, 22, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 11, 235, 137, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 121, 243, 19, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 13, 238, 132, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 127, 241, 16, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 16, 241, 127, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 132, 238, 14, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 19, 243, 122, 0, 139, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 138, 236, 12, 135, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 22, 246, 117, 128, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 143, 233, 129, 252, 0, 0, 0,
            ],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 26, 248, 220, 252, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 149, 255, 252, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 30, 250, 252, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 57, 85, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 199, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 13, 249, 98, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 83, 229, 7, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 169, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ņ' / 0x146
        'ņ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 45, 74, 0, 0, 40, 119, 152, 152, 113, 28, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 218, 1, 146, 252, 207, 183, 210, 250, 248, 98, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 239, 111, 198, 36, 0, 0, 0, 37, 205, 253, 51, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 222, 15, 0, 0, 0, 0, 0, 45, 253, 153, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 123, 0, 0, 0, 0, 0, 0, 0, 222, 201, 0, 0, 0],
            &[0, 0, 125, 255, 58, 0, 0, 0, 0, 0, 0, 0, 191, 216, 0, 0, 0],
            &[0, 0, 125, 255, 29, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 38, 90, 14, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 144, 240, 5, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 207, 153, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 29, 251, 39, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 115, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ň' / 0x147
        'Ň' => &[
            &[0, 0, 0, 0, 31, 229, 121, 0, 0, 37, 226, 126, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 52, 247, 109, 28, 226, 158, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 98, 253, 225, 201, 6, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 146, 185, 39, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 71, 19, 0, 0, 0, 0, 0, 0, 0, 39, 70, 0, 0, 0],
            &[0, 0, 194, 255, 151, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[0, 0, 194, 239, 249, 28, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[
                0, 0, 194, 164, 228, 147, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 171, 110, 247, 25, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 183, 9, 232, 142, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 189, 0, 115, 245, 22, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 11, 235, 137, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 121, 243, 19, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 13, 238, 132, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 127, 241, 16, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 16, 241, 127, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 132, 238, 14, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 19, 243, 122, 0, 139, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 138, 236, 12, 135, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 22, 246, 117, 128, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 143, 233, 129, 252, 0, 0, 0,
            ],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 26, 248, 220, 252, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 149, 255, 252, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 30, 250, 252, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 96, 94, 0, 0, 0, 0, 30, 144, 23, 0, 0, 0, 0],
        ],
        // letter: 'ň' / 0x148
        'ň' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 83, 135, 3, 0, 0, 0, 25, 161, 43, 0, 0, 0, 0],
            &[0, 0, 0, 0, 9, 198, 173, 5, 0, 31, 220, 140, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 22, 225, 162, 22, 218, 173, 1, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 52, 251, 236, 215, 10, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 102, 163, 51, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 45, 74, 0, 0, 40, 119, 152, 152, 113, 28, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 218, 1, 146, 252, 207, 183, 210, 250, 248, 98, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 239, 111, 198, 36, 0, 0, 0, 37, 205, 253, 51, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 222, 15, 0, 0, 0, 0, 0, 45, 253, 153, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 123, 0, 0, 0, 0, 0, 0, 0, 222, 201, 0, 0, 0],
            &[0, 0, 125, 255, 58, 0, 0, 0, 0, 0, 0, 0, 191, 216, 0, 0, 0],
            &[0, 0, 125, 255, 29, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ŉ' / 0x149
        'ŉ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 16, 71, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 85, 255, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 127, 255, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 179, 239, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 1, 235, 158, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 45, 255, 65, 0, 93, 26, 0, 12, 98, 147, 155, 123, 38, 0, 0, 0,
            ],
            &[
                0, 120, 213, 0, 0, 255, 86, 56, 232, 226, 184, 204, 247, 253, 114, 0, 0,
            ],
            &[
                0, 58, 48, 0, 0, 255, 125, 220, 91, 0, 0, 0, 30, 200, 254, 58, 0,
            ],
            &[0, 0, 0, 0, 0, 255, 247, 105, 0, 0, 0, 0, 0, 42, 253, 156, 0],
            &[0, 0, 0, 0, 0, 255, 237, 6, 0, 0, 0, 0, 0, 0, 221, 202, 0],
            &[0, 0, 0, 0, 0, 255, 181, 0, 0, 0, 0, 0, 0, 0, 191, 216, 0],
            &[0, 0, 0, 0, 0, 255, 153, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 0, 255, 144, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 0, 255, 144, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 0, 255, 144, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 0, 255, 144, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 0, 255, 144, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 0, 255, 144, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 0, 255, 144, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 0, 255, 144, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ŋ' / 0x14a
        'Ŋ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 71, 19, 0, 0, 0, 0, 0, 0, 0, 39, 70, 0, 0, 0],
            &[0, 0, 194, 255, 151, 0, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[0, 0, 194, 239, 249, 28, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0],
            &[
                0, 0, 194, 164, 228, 147, 0, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 171, 110, 247, 25, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 183, 9, 232, 142, 0, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 189, 0, 115, 245, 22, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 11, 235, 137, 0, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 121, 243, 19, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 13, 238, 132, 0, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 127, 241, 16, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 16, 241, 127, 0, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 132, 238, 14, 0, 141, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 19, 243, 122, 0, 139, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 138, 236, 12, 135, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 22, 246, 117, 128, 252, 0, 0, 0,
            ],
            &[
                0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 143, 233, 129, 252, 0, 0, 0,
            ],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 26, 248, 220, 252, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 149, 255, 255, 0, 0, 0],
            &[0, 0, 194, 192, 0, 0, 0, 0, 0, 0, 0, 30, 255, 255, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149, 241, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 199, 206, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 255, 125, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 0, 129, 150, 144, 195, 253, 207, 10, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 114, 211, 228, 204, 127, 12, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ŋ' / 0x14b
        'ŋ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 45, 74, 0, 0, 40, 119, 152, 152, 113, 28, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 218, 1, 146, 252, 207, 183, 210, 250, 248, 98, 0, 0, 0, 0,
            ],
            &[
                0, 0, 125, 239, 111, 198, 36, 0, 0, 0, 37, 205, 253, 51, 0, 0, 0,
            ],
            &[
                0, 0, 125, 255, 222, 15, 0, 0, 0, 0, 0, 45, 253, 153, 0, 0, 0,
            ],
            &[0, 0, 125, 255, 123, 0, 0, 0, 0, 0, 0, 0, 222, 201, 0, 0, 0],
            &[0, 0, 125, 255, 58, 0, 0, 0, 0, 0, 0, 0, 191, 216, 0, 0, 0],
            &[0, 0, 125, 255, 29, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0],
            &[0, 0, 125, 255, 19, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 182, 217, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 214, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219, 190, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 92, 255, 116, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 147, 231, 230, 255, 197, 8, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 37, 102, 115, 76, 4, 0, 0, 0, 0],
        ],
        // letter: 'Ō' / 0x14c
        'Ō' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 17, 28, 28, 28, 28, 28, 28, 23, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 160, 255, 255, 255, 255, 255, 255, 211, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 29, 47, 47, 47, 47, 47, 47, 38, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 17, 94, 135, 136, 107, 31, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 105, 244, 255, 238, 223, 250, 254, 153, 9, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 103, 255, 180, 39, 0, 0, 14, 122, 251, 178, 1, 0, 0, 0,
            ],
            &[0, 0, 38, 252, 178, 1, 0, 0, 0, 0, 0, 99, 255, 101, 0, 0, 0],
            &[0, 0, 158, 247, 20, 0, 0, 0, 0, 0, 0, 0, 201, 223, 1, 0, 0],
            &[0, 6, 247, 161, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 55, 0, 0],
            &[0, 58, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 122, 0, 0],
            &[0, 113, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 164, 0, 0],
            &[0, 135, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 195, 0, 0],
            &[0, 152, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 207, 0, 0],
            &[0, 162, 245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 213, 0, 0],
            &[0, 151, 255, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 202, 0, 0],
            &[0, 134, 255, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 185, 0, 0],
            &[0, 96, 255, 58, 0, 0, 0, 0, 0, 0, 0, 0, 8, 251, 147, 0, 0],
            &[0, 47, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 53, 255, 99, 0, 0],
            &[0, 0, 228, 196, 0, 0, 0, 0, 0, 0, 0, 0, 136, 255, 27, 0, 0],
            &[0, 0, 128, 255, 56, 0, 0, 0, 0, 0, 0, 15, 234, 182, 0, 0, 0],
            &[0, 0, 17, 230, 225, 25, 0, 0, 0, 0, 5, 177, 250, 52, 0, 0, 0],
            &[
                0, 0, 0, 59, 242, 239, 122, 67, 56, 98, 213, 253, 104, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 39, 179, 252, 255, 255, 255, 202, 70, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 18, 51, 57, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ō' / 0x14d
        'ō' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 31, 50, 50, 50, 50, 50, 50, 41, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 160, 255, 255, 255, 255, 255, 255, 211, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 15, 25, 25, 25, 25, 25, 25, 20, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 107, 142, 150, 120, 52, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 3, 140, 250, 239, 191, 188, 225, 255, 188, 20, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 167, 251, 112, 5, 0, 0, 0, 74, 234, 217, 12, 0, 0, 0,
            ],
            &[0, 0, 84, 255, 108, 0, 0, 0, 0, 0, 0, 51, 252, 142, 0, 0, 0],
            &[0, 0, 191, 219, 1, 0, 0, 0, 0, 0, 0, 0, 165, 242, 7, 0, 0],
            &[0, 16, 252, 137, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 70, 0, 0],
            &[0, 46, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 41, 255, 105, 0, 0],
            &[0, 68, 255, 73, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 127, 0, 0],
            &[0, 64, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0, 30, 255, 122, 0, 0],
            &[0, 42, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 56, 255, 98, 0, 0],
            &[0, 2, 242, 167, 0, 0, 0, 0, 0, 0, 0, 0, 117, 255, 44, 0, 0],
            &[0, 0, 160, 244, 24, 0, 0, 0, 0, 0, 0, 3, 214, 212, 0, 0, 0],
            &[0, 0, 39, 247, 179, 5, 0, 0, 0, 0, 0, 132, 255, 85, 0, 0, 0],
            &[
                0, 0, 0, 90, 251, 202, 83, 33, 27, 66, 174, 255, 145, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 56, 191, 253, 255, 255, 255, 218, 94, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 19, 54, 60, 32, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ŏ' / 0x14e
        'Ŏ' => &[
            &[0, 0, 0, 0, 105, 117, 0, 0, 0, 0, 73, 143, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 82, 240, 39, 0, 0, 9, 201, 133, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 164, 243, 175, 160, 228, 204, 11, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 70, 129, 133, 86, 3, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 17, 94, 135, 136, 107, 31, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 105, 244, 255, 238, 223, 250, 254, 153, 9, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 103, 255, 180, 39, 0, 0, 14, 122, 251, 178, 1, 0, 0, 0,
            ],
            &[0, 0, 38, 252, 178, 1, 0, 0, 0, 0, 0, 99, 255, 101, 0, 0, 0],
            &[0, 0, 158, 247, 20, 0, 0, 0, 0, 0, 0, 0, 201, 223, 1, 0, 0],
            &[0, 6, 247, 161, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 55, 0, 0],
            &[0, 58, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 122, 0, 0],
            &[0, 113, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 164, 0, 0],
            &[0, 135, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 195, 0, 0],
            &[0, 152, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 207, 0, 0],
            &[0, 162, 245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 213, 0, 0],
            &[0, 151, 255, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 202, 0, 0],
            &[0, 134, 255, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 185, 0, 0],
            &[0, 96, 255, 58, 0, 0, 0, 0, 0, 0, 0, 0, 8, 251, 147, 0, 0],
            &[0, 47, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 53, 255, 99, 0, 0],
            &[0, 0, 228, 196, 0, 0, 0, 0, 0, 0, 0, 0, 136, 255, 27, 0, 0],
            &[0, 0, 128, 255, 56, 0, 0, 0, 0, 0, 0, 15, 234, 182, 0, 0, 0],
            &[0, 0, 17, 230, 225, 25, 0, 0, 0, 0, 5, 177, 250, 52, 0, 0, 0],
            &[
                0, 0, 0, 59, 242, 239, 122, 67, 56, 98, 213, 253, 104, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 39, 179, 252, 255, 255, 255, 202, 70, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 18, 51, 57, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ŏ' / 0x14f
        'ŏ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 116, 135, 0, 0, 0, 0, 85, 157, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 72, 245, 55, 0, 0, 18, 211, 124, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 142, 249, 197, 182, 241, 185, 6, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 49, 107, 111, 64, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 107, 142, 150, 120, 52, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 3, 140, 250, 239, 191, 188, 225, 255, 188, 20, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 167, 251, 112, 5, 0, 0, 0, 74, 234, 217, 12, 0, 0, 0,
            ],
            &[0, 0, 84, 255, 108, 0, 0, 0, 0, 0, 0, 51, 252, 142, 0, 0, 0],
            &[0, 0, 191, 219, 1, 0, 0, 0, 0, 0, 0, 0, 165, 242, 7, 0, 0],
            &[0, 16, 252, 137, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 70, 0, 0],
            &[0, 46, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 41, 255, 105, 0, 0],
            &[0, 68, 255, 73, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 127, 0, 0],
            &[0, 64, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0, 30, 255, 122, 0, 0],
            &[0, 42, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 56, 255, 98, 0, 0],
            &[0, 2, 242, 167, 0, 0, 0, 0, 0, 0, 0, 0, 117, 255, 44, 0, 0],
            &[0, 0, 160, 244, 24, 0, 0, 0, 0, 0, 0, 3, 214, 212, 0, 0, 0],
            &[0, 0, 39, 247, 179, 5, 0, 0, 0, 0, 0, 132, 255, 85, 0, 0, 0],
            &[
                0, 0, 0, 90, 251, 202, 83, 33, 27, 66, 174, 255, 145, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 56, 191, 253, 255, 255, 255, 218, 94, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 19, 54, 60, 32, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ő' / 0x150
        'Ő' => &[
            &[0, 0, 0, 0, 0, 0, 166, 240, 30, 0, 95, 255, 83, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 71, 253, 78, 0, 21, 235, 144, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 18, 226, 118, 0, 0, 175, 182, 3, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 104, 119, 0, 0, 54, 159, 8, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 17, 94, 135, 136, 107, 31, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 105, 244, 255, 238, 223, 250, 254, 153, 9, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 103, 255, 180, 39, 0, 0, 14, 122, 251, 178, 1, 0, 0, 0,
            ],
            &[0, 0, 38, 252, 178, 1, 0, 0, 0, 0, 0, 99, 255, 101, 0, 0, 0],
            &[0, 0, 158, 247, 20, 0, 0, 0, 0, 0, 0, 0, 201, 223, 1, 0, 0],
            &[0, 6, 247, 161, 0, 0, 0, 0, 0, 0, 0, 0, 100, 255, 55, 0, 0],
            &[0, 58, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 31, 255, 122, 0, 0],
            &[0, 113, 255, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 164, 0, 0],
            &[0, 135, 255, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 195, 0, 0],
            &[0, 152, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 207, 0, 0],
            &[0, 162, 245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 213, 0, 0],
            &[0, 151, 255, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 202, 0, 0],
            &[0, 134, 255, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 185, 0, 0],
            &[0, 96, 255, 58, 0, 0, 0, 0, 0, 0, 0, 0, 8, 251, 147, 0, 0],
            &[0, 47, 255, 110, 0, 0, 0, 0, 0, 0, 0, 0, 53, 255, 99, 0, 0],
            &[0, 0, 228, 196, 0, 0, 0, 0, 0, 0, 0, 0, 136, 255, 27, 0, 0],
            &[0, 0, 128, 255, 56, 0, 0, 0, 0, 0, 0, 15, 234, 182, 0, 0, 0],
            &[0, 0, 17, 230, 225, 25, 0, 0, 0, 0, 5, 177, 250, 52, 0, 0, 0],
            &[
                0, 0, 0, 59, 242, 239, 122, 67, 56, 98, 213, 253, 104, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 39, 179, 252, 255, 255, 255, 202, 70, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 18, 51, 57, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 30, 152, 88, 0, 2, 139, 129, 0, 0, 0, 0],
        ],
        // letter: 'ő' / 0x151
        'ő' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 39, 174, 97, 0, 4, 162, 143, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 179, 233, 22, 0, 108, 254, 69, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 84, 250, 63, 0, 29, 241, 126, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 25, 233, 99, 0, 2, 189, 165, 1, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 96, 98, 0, 0, 52, 137, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 24, 107, 142, 150, 120, 52, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 3, 140, 250, 239, 191, 188, 225, 255, 188, 20, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 167, 251, 112, 5, 0, 0, 0, 74, 234, 217, 12, 0, 0, 0,
            ],
            &[0, 0, 84, 255, 108, 0, 0, 0, 0, 0, 0, 51, 252, 142, 0, 0, 0],
            &[0, 0, 191, 219, 1, 0, 0, 0, 0, 0, 0, 0, 165, 242, 7, 0, 0],
            &[0, 16, 252, 137, 0, 0, 0, 0, 0, 0, 0, 0, 87, 255, 70, 0, 0],
            &[0, 46, 255, 91, 0, 0, 0, 0, 0, 0, 0, 0, 41, 255, 105, 0, 0],
            &[0, 68, 255, 73, 0, 0, 0, 0, 0, 0, 0, 0, 23, 255, 127, 0, 0],
            &[0, 64, 255, 81, 0, 0, 0, 0, 0, 0, 0, 0, 30, 255, 122, 0, 0],
            &[0, 42, 255, 106, 0, 0, 0, 0, 0, 0, 0, 0, 56, 255, 98, 0, 0],
            &[0, 2, 242, 167, 0, 0, 0, 0, 0, 0, 0, 0, 117, 255, 44, 0, 0],
            &[0, 0, 160, 244, 24, 0, 0, 0, 0, 0, 0, 3, 214, 212, 0, 0, 0],
            &[0, 0, 39, 247, 179, 5, 0, 0, 0, 0, 0, 132, 255, 85, 0, 0, 0],
            &[
                0, 0, 0, 90, 251, 202, 83, 33, 27, 66, 174, 255, 145, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 56, 191, 253, 255, 255, 255, 218, 94, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 19, 54, 60, 32, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Œ' / 0x152
        'Œ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 28, 79, 101, 94, 72, 71, 71, 71, 71, 71, 25, 0,
            ],
            &[
                0, 0, 0, 16, 169, 253, 255, 252, 255, 255, 255, 255, 255, 255, 255, 92, 0,
            ],
            &[
                0, 0, 7, 207, 243, 102, 17, 2, 197, 211, 32, 32, 32, 32, 32, 11, 0,
            ],
            &[0, 0, 126, 255, 69, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[0, 4, 233, 184, 0, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[0, 53, 255, 99, 0, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[0, 108, 255, 45, 0, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[0, 140, 255, 10, 0, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[0, 163, 243, 0, 0, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 172, 233, 0, 0, 0, 0, 0, 188, 247, 211, 211, 211, 211, 197, 0, 0,
            ],
            &[
                0, 176, 230, 0, 0, 0, 0, 0, 188, 234, 147, 147, 147, 147, 137, 0, 0,
            ],
            &[0, 163, 241, 0, 0, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[0, 149, 253, 1, 0, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[0, 124, 255, 33, 0, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[0, 75, 255, 77, 0, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[0, 24, 254, 151, 0, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 183, 236, 15, 0, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 69, 254, 165, 3, 0, 0, 188, 204, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 133, 255, 199, 105, 78, 218, 226, 110, 110, 110, 110, 110, 40, 0,
            ],
            &[
                0, 0, 0, 0, 89, 217, 254, 255, 255, 255, 255, 255, 255, 255, 255, 92, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 11, 35, 17, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'œ' / 0x153
        'œ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 67, 144, 140, 60, 0, 0, 0, 63, 149, 128, 26, 0, 0, 0,
            ],
            &[
                0, 0, 130, 255, 208, 186, 251, 91, 0, 80, 246, 182, 214, 231, 22, 0, 0,
            ],
            &[
                0, 55, 254, 117, 0, 0, 96, 237, 20, 239, 85, 0, 9, 217, 146, 0, 0,
            ],
            &[
                0, 161, 217, 1, 0, 0, 0, 216, 182, 203, 0, 0, 0, 115, 232, 0, 0,
            ],
            &[
                0, 230, 145, 0, 0, 0, 0, 148, 255, 124, 0, 0, 0, 64, 255, 28, 0,
            ],
            &[
                16, 255, 94, 0, 0, 0, 0, 111, 255, 89, 0, 0, 0, 43, 255, 61, 0,
            ],
            &[
                42, 255, 76, 0, 0, 0, 0, 90, 255, 114, 67, 67, 67, 85, 255, 74, 0,
            ],
            &[
                52, 255, 60, 0, 0, 0, 0, 81, 255, 246, 243, 243, 243, 243, 243, 75, 0,
            ],
            &[44, 255, 66, 0, 0, 0, 0, 84, 255, 59, 0, 0, 0, 0, 0, 0, 0],
            &[31, 255, 83, 0, 0, 0, 0, 96, 255, 72, 0, 0, 0, 0, 0, 0, 0],
            &[4, 248, 109, 0, 0, 0, 0, 126, 255, 107, 0, 0, 0, 0, 0, 0, 0],
            &[0, 202, 174, 0, 0, 0, 0, 176, 249, 163, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 117, 242, 24, 0, 0, 21, 244, 112, 243, 23, 0, 0, 0, 0, 0, 0,
            ],
            &[
                0, 18, 229, 193, 50, 34, 185, 186, 1, 196, 196, 39, 7, 56, 172, 0, 0,
            ],
            &[
                0, 0, 54, 222, 255, 255, 203, 27, 0, 29, 200, 255, 254, 250, 155, 0, 0,
            ],
            &[0, 0, 0, 5, 47, 42, 2, 0, 0, 0, 2, 38, 55, 17, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ŕ' / 0x154
        'Ŕ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 164, 250, 61, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 101, 253, 86, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 60, 244, 94, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 4, 166, 77, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 11, 71, 71, 71, 71, 66, 50, 22, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 42, 255, 255, 255, 255, 255, 255, 255, 218, 120, 10, 0, 0, 0, 0, 0,
            ],
            &[
                0, 42, 255, 117, 25, 25, 34, 59, 95, 189, 254, 202, 14, 0, 0, 0, 0,
            ],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 93, 255, 136, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 201, 230, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 147, 255, 8, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 145, 255, 13, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 184, 236, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 42, 252, 153, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 68, 224, 226, 22, 0, 0, 0, 0],
            &[
                0, 42, 255, 204, 170, 170, 171, 187, 229, 254, 176, 28, 0, 0, 0, 0, 0,
            ],
            &[
                0, 42, 255, 215, 188, 188, 188, 205, 255, 91, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 42, 255, 102, 0, 0, 0, 6, 218, 208, 3, 0, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 74, 255, 108, 0, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 178, 239, 22, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 35, 248, 158, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 132, 254, 57, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 10, 226, 205, 2, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 85, 255, 105, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 189, 238, 20, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 17, 150, 127, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ŕ' / 0x155
        'ŕ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 161, 161, 6, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 253, 80, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 78, 254, 104, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 45, 239, 110, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 129, 86, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 32, 93, 93, 93, 93, 93, 7, 0, 22, 111, 146, 135, 97, 19, 0, 0,
            ],
            &[
                0, 68, 203, 218, 233, 248, 255, 30, 74, 242, 246, 213, 227, 255, 52, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 63, 255, 78, 244, 122, 8, 0, 0, 32, 1, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 218, 121, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 228, 6, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 153, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 105, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 26, 45, 58, 72, 127, 255, 139, 74, 61, 48, 35, 3, 0, 0, 0, 0,
            ],
            &[
                0, 208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ŗ' / 0x156
        'Ŗ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 11, 71, 71, 71, 71, 66, 50, 22, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 42, 255, 255, 255, 255, 255, 255, 255, 218, 120, 10, 0, 0, 0, 0, 0,
            ],
            &[
                0, 42, 255, 117, 25, 25, 34, 59, 95, 189, 254, 202, 14, 0, 0, 0, 0,
            ],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 93, 255, 136, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 201, 230, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 147, 255, 8, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 145, 255, 13, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 184, 236, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 42, 252, 153, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 68, 224, 226, 22, 0, 0, 0, 0],
            &[
                0, 42, 255, 204, 170, 170, 171, 187, 229, 254, 176, 28, 0, 0, 0, 0, 0,
            ],
            &[
                0, 42, 255, 215, 188, 188, 188, 205, 255, 91, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 42, 255, 102, 0, 0, 0, 6, 218, 208, 3, 0, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 74, 255, 108, 0, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 178, 239, 22, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 35, 248, 158, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 132, 254, 57, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 10, 226, 205, 2, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 85, 255, 105, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 189, 238, 20, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 62, 80, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 213, 177, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 22, 254, 84, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 97, 219, 3, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 182, 76, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ŗ' / 0x157
        'ŗ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 32, 93, 93, 93, 93, 93, 7, 0, 22, 111, 146, 135, 97, 19, 0, 0,
            ],
            &[
                0, 68, 203, 218, 233, 248, 255, 30, 74, 242, 246, 213, 227, 255, 52, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 63, 255, 78, 244, 122, 8, 0, 0, 32, 1, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 218, 121, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 228, 6, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 153, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 105, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 26, 45, 58, 72, 127, 255, 139, 74, 61, 48, 35, 3, 0, 0, 0, 0,
            ],
            &[
                0, 208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 18, 90, 34, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 88, 255, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 152, 209, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 1, 226, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 62, 195, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ř' / 0x158
        'Ř' => &[
            &[0, 0, 0, 52, 239, 91, 0, 0, 58, 238, 93, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 80, 250, 77, 48, 240, 123, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 132, 246, 233, 172, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 5, 166, 179, 19, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 11, 71, 71, 71, 71, 66, 50, 22, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 42, 255, 255, 255, 255, 255, 255, 255, 218, 120, 10, 0, 0, 0, 0, 0,
            ],
            &[
                0, 42, 255, 117, 25, 25, 34, 59, 95, 189, 254, 202, 14, 0, 0, 0, 0,
            ],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 93, 255, 136, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 201, 230, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 147, 255, 8, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 145, 255, 13, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 184, 236, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 42, 252, 153, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 68, 224, 226, 22, 0, 0, 0, 0],
            &[
                0, 42, 255, 204, 170, 170, 171, 187, 229, 254, 176, 28, 0, 0, 0, 0, 0,
            ],
            &[
                0, 42, 255, 215, 188, 188, 188, 205, 255, 91, 0, 0, 0, 0, 0, 0, 0,
            ],
            &[0, 42, 255, 102, 0, 0, 0, 6, 218, 208, 3, 0, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 74, 255, 108, 0, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 178, 239, 22, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 35, 248, 158, 0, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 132, 254, 57, 0, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 10, 226, 205, 2, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 85, 255, 105, 0, 0, 0],
            &[0, 42, 255, 102, 0, 0, 0, 0, 0, 0, 0, 0, 189, 238, 20, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 116, 74, 0, 0, 0, 0, 49, 141, 7, 0, 0, 0, 0, 0],
        ],
        // letter: 'ř' / 0x159
        'ř' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 101, 119, 0, 0, 0, 0, 39, 164, 26, 0, 0, 0, 0],
            &[0, 0, 0, 0, 19, 216, 149, 0, 0, 46, 233, 112, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 36, 238, 135, 35, 232, 146, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 76, 255, 236, 194, 3, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 120, 163, 33, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 32, 93, 93, 93, 93, 93, 7, 0, 22, 111, 146, 135, 97, 19, 0, 0,
            ],
            &[
                0, 68, 203, 218, 233, 248, 255, 30, 74, 242, 246, 213, 227, 255, 52, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 63, 255, 78, 244, 122, 8, 0, 0, 32, 1, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 218, 121, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 228, 6, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 153, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 105, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 85, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 255, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 26, 45, 58, 72, 127, 255, 139, 74, 61, 48, 35, 3, 0, 0, 0, 0,
            ],
            &[
                0, 208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 31, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ś' / 0x15a
        'Ś' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 245, 189, 4, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 10, 209, 206, 15, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 1, 169, 208, 21, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 70, 162, 14, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 3, 58, 111, 132, 132, 111, 68, 9, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 79, 224, 255, 248, 226, 236, 255, 255, 246, 119, 0, 0, 0,
            ],
            &[0, 0, 0, 84, 253, 205, 71, 6, 0, 0, 8, 61, 144, 78, 0, 0, 0],
            &[0, 0, 4, 225, 215, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 44, 255, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 68, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 46, 255, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 3, 221, 226, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 66, 249, 232, 104, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 49, 198, 255, 239, 141, 34, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 57, 170, 251, 253, 176, 61, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 28, 133, 234, 255, 156, 4, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 148, 255, 143, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 247, 11, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108, 255, 44, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 255, 46, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 172, 248, 11, 0, 0],
            &[0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 86, 253, 160, 0, 0, 0],
            &[
                0, 0, 158, 205, 131, 77, 43, 31, 45, 87, 174, 255, 207, 18, 0, 0, 0,
            ],
            &[
                0, 0, 70, 171, 239, 255, 255, 255, 255, 255, 222, 122, 8, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 1, 29, 56, 65, 55, 24, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85, 152, 57, 0, 0, 0, 0],
        ],
        // letter: 'ś' / 0x15b
        'ś' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 168, 153, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 250, 63, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 98, 253, 86, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 59, 243, 93, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 142, 73, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 25, 100, 143, 157, 139, 114, 52, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 111, 247, 248, 207, 189, 206, 236, 255, 172, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 255, 165, 17, 0, 0, 0, 1, 57, 54, 0, 0, 0, 0],
            &[0, 0, 0, 132, 254, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 139, 251, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 75, 255, 151, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 138, 254, 217, 110, 17, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 52, 164, 249, 247, 160, 55, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 21, 118, 218, 255, 183, 20, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 111, 249, 190, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146, 255, 22, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 34, 0, 0, 0],
            &[0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 2, 193, 239, 5, 0, 0, 0],
            &[
                0, 0, 0, 233, 167, 86, 42, 25, 39, 73, 181, 255, 111, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 116, 204, 255, 255, 255, 255, 255, 215, 91, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 16, 51, 65, 54, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ŝ' / 0x15c
        'Ŝ' => &[
            &[0, 0, 0, 0, 0, 0, 7, 208, 238, 249, 46, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 158, 220, 24, 168, 220, 18, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 116, 226, 34, 0, 6, 181, 190, 6, 0, 0, 0, 0],
            &[0, 0, 0, 0, 35, 177, 33, 0, 0, 0, 6, 150, 91, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 3, 58, 111, 132, 132, 111, 68, 9, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 79, 224, 255, 248, 226, 236, 255, 255, 246, 119, 0, 0, 0,
            ],
            &[0, 0, 0, 84, 253, 205, 71, 6, 0, 0, 8, 61, 144, 78, 0, 0, 0],
            &[0, 0, 4, 225, 215, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 44, 255, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 68, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 46, 255, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 3, 221, 226, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 66, 249, 232, 104, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 49, 198, 255, 239, 141, 34, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 57, 170, 251, 253, 176, 61, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 28, 133, 234, 255, 156, 4, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 148, 255, 143, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 247, 11, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108, 255, 44, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 255, 46, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 172, 248, 11, 0, 0],
            &[0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 86, 253, 160, 0, 0, 0],
            &[
                0, 0, 158, 205, 131, 77, 43, 31, 45, 87, 174, 255, 207, 18, 0, 0, 0,
            ],
            &[
                0, 0, 70, 171, 239, 255, 255, 255, 255, 255, 222, 122, 8, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 1, 29, 56, 65, 55, 24, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 41, 145, 89, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ŝ' / 0x15d
        'ŝ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 130, 167, 31, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 93, 253, 229, 191, 2, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 48, 245, 105, 35, 233, 139, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 225, 121, 0, 0, 48, 235, 99, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 110, 105, 0, 0, 0, 0, 43, 158, 15, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 25, 100, 143, 157, 139, 114, 52, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 111, 247, 248, 207, 189, 206, 236, 255, 172, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 255, 165, 17, 0, 0, 0, 1, 57, 54, 0, 0, 0, 0],
            &[0, 0, 0, 132, 254, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 139, 251, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 75, 255, 151, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 138, 254, 217, 110, 17, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 52, 164, 249, 247, 160, 55, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 21, 118, 218, 255, 183, 20, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 111, 249, 190, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146, 255, 22, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 34, 0, 0, 0],
            &[0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 2, 193, 239, 5, 0, 0, 0],
            &[
                0, 0, 0, 233, 167, 86, 42, 25, 39, 73, 181, 255, 111, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 116, 204, 255, 255, 255, 255, 255, 215, 91, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 16, 51, 65, 54, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ş' / 0x15e
        'Ş' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 3, 58, 111, 132, 132, 111, 68, 9, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 79, 224, 255, 248, 226, 236, 255, 255, 246, 119, 0, 0, 0,
            ],
            &[0, 0, 0, 84, 253, 205, 71, 6, 0, 0, 8, 61, 144, 78, 0, 0, 0],
            &[0, 0, 4, 225, 215, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 44, 255, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 68, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 46, 255, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 3, 221, 226, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 66, 249, 232, 104, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 49, 198, 255, 239, 141, 34, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 57, 170, 251, 253, 176, 61, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 28, 133, 234, 255, 156, 4, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 148, 255, 143, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 247, 11, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108, 255, 44, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 255, 46, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 172, 248, 11, 0, 0],
            &[0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 86, 253, 160, 0, 0, 0],
            &[
                0, 0, 158, 205, 131, 77, 43, 31, 45, 87, 174, 255, 207, 18, 0, 0, 0,
            ],
            &[
                0, 0, 70, 171, 239, 255, 255, 255, 255, 255, 222, 122, 8, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 1, 29, 56, 237, 177, 24, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 42, 253, 86, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 40, 115, 210, 202, 10, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 14, 251, 76, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 34, 254, 58, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 105, 157, 172, 240, 162, 1, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 57, 117, 101, 50, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ş' / 0x15f
        'ş' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 25, 100, 143, 157, 139, 114, 52, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 111, 247, 248, 207, 189, 206, 236, 255, 172, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 255, 165, 17, 0, 0, 0, 1, 57, 54, 0, 0, 0, 0],
            &[0, 0, 0, 132, 254, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 139, 251, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 75, 255, 151, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 138, 254, 217, 110, 17, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 52, 164, 249, 247, 160, 55, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 21, 118, 218, 255, 183, 20, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 111, 249, 190, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146, 255, 22, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 34, 0, 0, 0],
            &[0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 2, 193, 239, 5, 0, 0, 0],
            &[
                0, 0, 0, 233, 167, 86, 42, 25, 39, 73, 181, 255, 111, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 116, 204, 255, 255, 255, 255, 255, 215, 91, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 16, 51, 215, 196, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 27, 248, 103, 6, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 33, 110, 201, 215, 17, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 6, 239, 97, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 22, 246, 79, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 92, 157, 169, 235, 179, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 48, 117, 103, 57, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Š' / 0x160
        'Š' => &[
            &[0, 0, 0, 0, 0, 157, 205, 19, 0, 2, 157, 211, 17, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 4, 191, 201, 11, 150, 232, 29, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 20, 229, 223, 252, 59, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 71, 185, 114, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 3, 58, 111, 132, 132, 111, 68, 9, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 79, 224, 255, 248, 226, 236, 255, 255, 246, 119, 0, 0, 0,
            ],
            &[0, 0, 0, 84, 253, 205, 71, 6, 0, 0, 8, 61, 144, 78, 0, 0, 0],
            &[0, 0, 4, 225, 215, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 44, 255, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 68, 255, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 46, 255, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 3, 221, 226, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 66, 249, 232, 104, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 49, 198, 255, 239, 141, 34, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 57, 170, 251, 253, 176, 61, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 28, 133, 234, 255, 156, 4, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 148, 255, 143, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 247, 11, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108, 255, 44, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 255, 46, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 172, 248, 11, 0, 0],
            &[0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 86, 253, 160, 0, 0, 0],
            &[
                0, 0, 158, 205, 131, 77, 43, 31, 45, 87, 174, 255, 207, 18, 0, 0, 0,
            ],
            &[
                0, 0, 70, 171, 239, 255, 255, 255, 255, 255, 222, 122, 8, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 1, 29, 56, 65, 55, 24, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 37, 138, 15, 0, 0, 0, 1, 115, 82, 0, 0, 0, 0],
        ],
        // letter: 'š' / 0x161
        'š' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 115, 107, 0, 0, 0, 0, 51, 162, 16, 0, 0, 0, 0],
            &[0, 0, 0, 0, 28, 227, 130, 0, 0, 59, 239, 93, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 246, 114, 47, 240, 126, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 96, 254, 238, 177, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 133, 161, 22, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 25, 100, 143, 157, 139, 114, 52, 0, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 111, 247, 248, 207, 189, 206, 236, 255, 172, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 57, 255, 165, 17, 0, 0, 0, 1, 57, 54, 0, 0, 0, 0],
            &[0, 0, 0, 132, 254, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 139, 251, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 75, 255, 151, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 138, 254, 217, 110, 17, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 52, 164, 249, 247, 160, 55, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 21, 118, 218, 255, 183, 20, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 111, 249, 190, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146, 255, 22, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 255, 34, 0, 0, 0],
            &[0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 2, 193, 239, 5, 0, 0, 0],
            &[
                0, 0, 0, 233, 167, 86, 42, 25, 39, 73, 181, 255, 111, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 116, 204, 255, 255, 255, 255, 255, 215, 91, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 16, 51, 65, 54, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ţ' / 0x162
        'Ţ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 50, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 66, 0, 0,
            ],
            &[
                0, 180, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 0, 0,
            ],
            &[
                0, 22, 32, 32, 32, 32, 32, 185, 229, 32, 32, 32, 32, 32, 30, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 183, 241, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 171, 121, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 42, 253, 86, 3, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 40, 115, 210, 202, 10, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 14, 251, 76, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 34, 254, 58, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 105, 157, 172, 240, 162, 1, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 57, 117, 101, 50, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ţ' / 0x163
        'ţ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 8, 12, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 145, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 168, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 191, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 4, 47, 63, 80, 96, 228, 215, 93, 93, 93, 93, 93, 46, 0, 0,
            ],
            &[
                0, 0, 27, 252, 252, 252, 252, 255, 255, 252, 252, 252, 252, 252, 126, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 204, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 183, 228, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 125, 255, 56, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 25, 236, 228, 86, 27, 23, 52, 54, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 0, 0, 49, 202, 255, 255, 255, 255, 139, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 151, 227, 57, 28, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 236, 125, 11, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 105, 189, 229, 31, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 216, 124, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 229, 106, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 74, 159, 166, 228, 199, 11, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 37, 115, 107, 66, 1, 0, 0, 0, 0],
        ],
        // letter: 'Ť' / 0x164
        'Ť' => &[
            &[0, 0, 0, 0, 52, 239, 91, 0, 0, 58, 238, 93, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 80, 250, 77, 48, 240, 123, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 132, 246, 233, 172, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 5, 166, 179, 19, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 50, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 66, 0, 0,
            ],
            &[
                0, 180, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 0, 0,
            ],
            &[
                0, 22, 32, 32, 32, 32, 32, 185, 229, 32, 32, 32, 32, 32, 30, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 116, 74, 0, 0, 0, 0, 49, 141, 7, 0, 0, 0, 0],
        ],
        // letter: 'ť' / 0x165
        'ť' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 174, 68, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 255, 36, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 8, 12, 0, 0, 0, 153, 193, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 145, 191, 0, 0, 1, 227, 75, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 168, 191, 0, 0, 25, 137, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 191, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 4, 47, 63, 80, 96, 228, 215, 93, 93, 93, 93, 93, 46, 0, 0,
            ],
            &[
                0, 0, 27, 252, 252, 252, 252, 255, 255, 252, 252, 252, 252, 252, 126, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 204, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 183, 228, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 125, 255, 56, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 25, 236, 228, 86, 27, 23, 52, 54, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 0, 0, 49, 202, 255, 255, 255, 255, 139, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 58, 57, 28, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ŧ' / 0x166
        'Ŧ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 50, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 66, 0, 0,
            ],
            &[
                0, 180, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 238, 0, 0,
            ],
            &[
                0, 22, 32, 32, 32, 32, 32, 185, 229, 32, 32, 32, 32, 32, 30, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 7, 135, 135, 135, 135, 255, 255, 135, 135, 135, 135, 38, 0, 0, 0,
            ],
            &[
                0, 0, 11, 209, 209, 209, 209, 255, 255, 209, 209, 209, 209, 59, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 174, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ŧ' / 0x167
        'ŧ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 8, 12, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 145, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 168, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 191, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 4, 47, 63, 80, 96, 228, 215, 93, 93, 93, 93, 93, 46, 0, 0,
            ],
            &[
                0, 0, 27, 252, 252, 252, 252, 255, 255, 252, 252, 252, 252, 252, 126, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 24, 219, 219, 219, 219, 255, 255, 219, 219, 219, 219, 219, 150, 0, 0,
            ],
            &[
                0, 0, 10, 91, 91, 91, 91, 255, 255, 91, 91, 91, 91, 91, 63, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 209, 191, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 204, 198, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 183, 228, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 125, 255, 56, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 25, 236, 228, 86, 27, 23, 52, 54, 0, 0],
            &[
                0, 0, 0, 0, 0, 0, 0, 0, 49, 202, 255, 255, 255, 255, 139, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 58, 57, 28, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ũ' / 0x168
        'Ũ' => &[
            &[0, 0, 0, 0, 6, 90, 103, 30, 0, 0, 0, 45, 90, 0, 0, 0, 0],
            &[
                0, 0, 0, 1, 194, 245, 228, 246, 112, 1, 0, 158, 131, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 71, 220, 15, 0, 91, 238, 225, 219, 236, 24, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 65, 83, 0, 0, 0, 23, 110, 120, 29, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 187, 214, 0, 0, 0, 0, 0, 0, 0, 0, 156, 245, 0, 0, 0],
            &[0, 0, 169, 231, 0, 0, 0, 0, 0, 0, 0, 0, 174, 226, 0, 0, 0],
            &[0, 0, 136, 255, 21, 0, 0, 0, 0, 0, 0, 0, 221, 191, 0, 0, 0],
            &[0, 0, 73, 255, 98, 0, 0, 0, 0, 0, 0, 47, 255, 123, 0, 0, 0],
            &[0, 0, 5, 219, 223, 23, 0, 0, 0, 0, 8, 193, 243, 25, 0, 0, 0],
            &[
                0, 0, 0, 68, 247, 224, 108, 58, 54, 97, 208, 253, 99, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 59, 195, 255, 255, 255, 255, 205, 77, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 53, 55, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ũ' / 0x169
        'ũ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 13, 112, 125, 46, 0, 0, 0, 54, 104, 0, 0, 0, 0],
            &[
                0, 0, 0, 4, 208, 232, 207, 251, 134, 6, 5, 171, 124, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 77, 212, 5, 0, 70, 226, 241, 236, 225, 17, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 56, 69, 0, 0, 0, 13, 88, 98, 18, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 159, 242, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 150, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 121, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 52, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 176, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 9, 152, 249, 255, 255, 255, 226, 94, 0, 152, 183, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 11, 53, 63, 40, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ū' / 0x16a
        'Ū' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 17, 28, 28, 28, 28, 28, 28, 23, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 160, 255, 255, 255, 255, 255, 255, 211, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 29, 47, 47, 47, 47, 47, 47, 38, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 187, 214, 0, 0, 0, 0, 0, 0, 0, 0, 156, 245, 0, 0, 0],
            &[0, 0, 169, 231, 0, 0, 0, 0, 0, 0, 0, 0, 174, 226, 0, 0, 0],
            &[0, 0, 136, 255, 21, 0, 0, 0, 0, 0, 0, 0, 221, 191, 0, 0, 0],
            &[0, 0, 73, 255, 98, 0, 0, 0, 0, 0, 0, 47, 255, 123, 0, 0, 0],
            &[0, 0, 5, 219, 223, 23, 0, 0, 0, 0, 8, 193, 243, 25, 0, 0, 0],
            &[
                0, 0, 0, 68, 247, 224, 108, 58, 54, 97, 208, 253, 99, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 59, 195, 255, 255, 255, 255, 205, 77, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 53, 55, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ū' / 0x16b
        'ū' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 31, 50, 50, 50, 50, 50, 50, 41, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 160, 255, 255, 255, 255, 255, 255, 211, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 15, 25, 25, 25, 25, 25, 25, 20, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 159, 242, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 150, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 121, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 52, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 176, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 9, 152, 249, 255, 255, 255, 226, 94, 0, 152, 183, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 10, 53, 63, 40, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ŭ' / 0x16c
        'Ŭ' => &[
            &[0, 0, 0, 0, 105, 117, 0, 0, 0, 0, 73, 143, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 82, 240, 39, 0, 0, 9, 201, 133, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 164, 243, 175, 160, 228, 204, 11, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 70, 129, 133, 86, 3, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 187, 214, 0, 0, 0, 0, 0, 0, 0, 0, 156, 245, 0, 0, 0],
            &[0, 0, 169, 231, 0, 0, 0, 0, 0, 0, 0, 0, 174, 226, 0, 0, 0],
            &[0, 0, 136, 255, 21, 0, 0, 0, 0, 0, 0, 0, 221, 191, 0, 0, 0],
            &[0, 0, 73, 255, 98, 0, 0, 0, 0, 0, 0, 47, 255, 123, 0, 0, 0],
            &[0, 0, 5, 219, 223, 23, 0, 0, 0, 0, 8, 193, 243, 25, 0, 0, 0],
            &[
                0, 0, 0, 68, 247, 224, 108, 58, 54, 97, 208, 253, 99, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 59, 195, 255, 255, 255, 255, 205, 77, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 53, 55, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ŭ' / 0x16d
        'ŭ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 116, 135, 0, 0, 0, 0, 85, 157, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 72, 245, 55, 0, 0, 18, 211, 124, 0, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 142, 249, 197, 182, 241, 185, 6, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 49, 107, 111, 64, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 159, 242, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 150, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 121, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 52, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 176, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 9, 152, 249, 255, 255, 255, 226, 94, 0, 152, 183, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 10, 53, 63, 40, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ů' / 0x16e
        'Ů' => &[
            &[0, 0, 0, 0, 0, 170, 106, 0, 0, 55, 221, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 161, 125, 0, 0, 74, 210, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 60, 241, 126, 111, 227, 99, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 48, 140, 146, 67, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 187, 214, 0, 0, 0, 0, 0, 0, 0, 0, 156, 245, 0, 0, 0],
            &[0, 0, 169, 231, 0, 0, 0, 0, 0, 0, 0, 0, 174, 226, 0, 0, 0],
            &[0, 0, 136, 255, 21, 0, 0, 0, 0, 0, 0, 0, 221, 191, 0, 0, 0],
            &[0, 0, 73, 255, 98, 0, 0, 0, 0, 0, 0, 47, 255, 123, 0, 0, 0],
            &[0, 0, 5, 219, 223, 23, 0, 0, 0, 0, 8, 193, 243, 25, 0, 0, 0],
            &[
                0, 0, 0, 68, 247, 224, 108, 58, 54, 97, 208, 253, 99, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 59, 195, 255, 255, 255, 255, 205, 77, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 53, 55, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 92, 220, 57, 41, 190, 138, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ů' / 0x16f
        'ů' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 1, 129, 225, 231, 151, 11, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 103, 210, 35, 19, 175, 150, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 173, 103, 0, 0, 51, 223, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 157, 133, 0, 0, 82, 206, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 48, 240, 148, 133, 234, 83, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 32, 118, 124, 48, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 159, 242, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 150, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 121, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 52, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 176, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 9, 152, 249, 255, 255, 255, 226, 94, 0, 152, 183, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 10, 53, 63, 40, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ű' / 0x170
        'Ű' => &[
            &[0, 0, 0, 0, 0, 0, 166, 240, 30, 0, 95, 255, 83, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 71, 253, 78, 0, 21, 235, 144, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 18, 226, 118, 0, 0, 175, 182, 3, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 104, 119, 0, 0, 54, 159, 8, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 187, 214, 0, 0, 0, 0, 0, 0, 0, 0, 156, 245, 0, 0, 0],
            &[0, 0, 169, 231, 0, 0, 0, 0, 0, 0, 0, 0, 174, 226, 0, 0, 0],
            &[0, 0, 136, 255, 21, 0, 0, 0, 0, 0, 0, 0, 221, 191, 0, 0, 0],
            &[0, 0, 73, 255, 98, 0, 0, 0, 0, 0, 0, 47, 255, 123, 0, 0, 0],
            &[0, 0, 5, 219, 223, 23, 0, 0, 0, 0, 8, 193, 243, 25, 0, 0, 0],
            &[
                0, 0, 0, 68, 247, 224, 108, 58, 54, 97, 208, 253, 99, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 59, 195, 255, 255, 255, 255, 205, 77, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 53, 55, 26, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 30, 152, 88, 0, 2, 139, 129, 0, 0, 0, 0],
        ],
        // letter: 'ű' / 0x171
        'ű' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 39, 174, 97, 0, 4, 162, 143, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 179, 233, 22, 0, 108, 254, 69, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 84, 250, 63, 0, 29, 241, 126, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 25, 233, 99, 0, 2, 189, 165, 1, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 96, 98, 0, 0, 52, 137, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 159, 242, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 150, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 121, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 52, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 176, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 9, 152, 249, 255, 255, 255, 226, 94, 0, 152, 183, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 11, 53, 63, 40, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ų' / 0x172
        'Ų' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 53, 57, 0, 0, 0, 0, 0, 0, 0, 0, 41, 70, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 194, 206, 0, 0, 0, 0, 0, 0, 0, 0, 148, 252, 0, 0, 0],
            &[0, 0, 187, 214, 0, 0, 0, 0, 0, 0, 0, 0, 156, 245, 0, 0, 0],
            &[0, 0, 169, 231, 0, 0, 0, 0, 0, 0, 0, 0, 174, 226, 0, 0, 0],
            &[0, 0, 136, 255, 21, 0, 0, 0, 0, 0, 0, 0, 221, 191, 0, 0, 0],
            &[0, 0, 73, 255, 98, 0, 0, 0, 0, 0, 0, 47, 255, 123, 0, 0, 0],
            &[0, 0, 5, 219, 223, 23, 0, 0, 0, 0, 8, 193, 243, 25, 0, 0, 0],
            &[
                0, 0, 0, 68, 247, 224, 108, 58, 54, 97, 208, 253, 99, 0, 0, 0, 0,
            ],
            &[
                0, 0, 0, 0, 59, 195, 255, 255, 255, 255, 255, 78, 0, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 22, 60, 219, 207, 21, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 3, 184, 167, 4, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 85, 241, 11, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 123, 227, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 75, 255, 140, 71, 43, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 119, 208, 215, 88, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ų' / 0x173
        'ų' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 58, 87, 0, 0, 0, 0, 0, 0, 0, 0, 79, 66, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 217, 183, 0, 0, 0],
            &[0, 0, 159, 241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 183, 0, 0, 0],
            &[0, 0, 159, 242, 0, 0, 0, 0, 0, 0, 0, 0, 238, 183, 0, 0, 0],
            &[0, 0, 150, 255, 9, 0, 0, 0, 0, 0, 0, 24, 255, 183, 0, 0, 0],
            &[0, 0, 121, 255, 47, 0, 0, 0, 0, 0, 0, 107, 255, 183, 0, 0, 0],
            &[
                0, 0, 52, 255, 161, 0, 0, 0, 0, 0, 31, 224, 227, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 176, 255, 163, 59, 23, 39, 108, 230, 101, 174, 183, 0, 0, 0,
            ],
            &[
                0, 0, 0, 9, 152, 249, 255, 255, 255, 226, 94, 0, 188, 205, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 10, 53, 63, 40, 1, 0, 66, 228, 58, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 236, 65, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 174, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196, 150, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 157, 234, 101, 74, 17, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 160, 216, 205, 30, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ŵ' / 0x174
        'Ŵ' => &[
            &[0, 0, 0, 0, 0, 0, 97, 252, 241, 157, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 246, 104, 61, 247, 100, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 226, 122, 0, 0, 77, 242, 65, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 134, 112, 0, 0, 0, 0, 71, 169, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[6, 71, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 71, 22, 0],
            &[4, 251, 122, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 255, 59, 0],
            &[0, 221, 156, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 255, 25, 0],
            &[0, 187, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 132, 246, 1, 0],
            &[0, 152, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 213, 0, 0],
            &[0, 117, 252, 5, 0, 0, 0, 65, 86, 0, 0, 0, 0, 200, 179, 0, 0],
            &[
                0, 82, 255, 36, 0, 0, 0, 218, 255, 21, 0, 0, 0, 235, 145, 0, 0,
            ],
            &[
                0, 48, 255, 69, 0, 0, 22, 253, 217, 80, 0, 0, 15, 255, 111, 0, 0,
            ],
            &[
                0, 13, 255, 103, 0, 0, 80, 219, 154, 139, 0, 0, 49, 255, 77, 0, 0,
            ],
            &[
                0, 0, 234, 137, 0, 0, 139, 167, 102, 198, 0, 0, 83, 255, 43, 0, 0,
            ],
            &[
                0, 0, 199, 171, 0, 0, 198, 112, 47, 249, 8, 0, 116, 254, 9, 0, 0,
            ],
            &[
                0, 0, 164, 205, 0, 8, 249, 55, 2, 242, 60, 0, 150, 230, 0, 0, 0,
            ],
            &[
                0, 0, 130, 239, 0, 60, 247, 5, 0, 186, 119, 0, 182, 196, 0, 0, 0,
            ],
            &[
                0, 0, 95, 255, 14, 119, 195, 0, 0, 127, 179, 0, 206, 162, 0, 0, 0,
            ],
            &[
                0, 0, 60, 255, 42, 175, 137, 0, 0, 69, 238, 2, 229, 128, 0, 0, 0,
            ],
            &[
                0, 0, 25, 255, 67, 231, 79, 0, 0, 13, 252, 46, 251, 94, 0, 0, 0,
            ],
            &[
                0, 0, 1, 246, 120, 255, 21, 0, 0, 0, 207, 115, 255, 60, 0, 0, 0,
            ],
            &[
                0, 0, 0, 212, 193, 219, 0, 0, 0, 0, 149, 186, 255, 26, 0, 0, 0,
            ],
            &[0, 0, 0, 177, 249, 161, 0, 0, 0, 0, 90, 249, 247, 1, 0, 0, 0],
            &[0, 0, 0, 142, 255, 103, 0, 0, 0, 0, 32, 255, 214, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 120, 143, 13, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ŵ' / 0x175
        'ŵ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 125, 167, 35, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 86, 253, 228, 196, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 43, 243, 112, 31, 229, 146, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 23, 222, 128, 0, 0, 44, 232, 106, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 106, 109, 0, 0, 0, 0, 39, 159, 18, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[36, 93, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 58, 0],
            &[65, 255, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 240, 125, 0],
            &[14, 254, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 255, 75, 0],
            &[
                0, 216, 159, 0, 0, 0, 0, 140, 183, 23, 0, 0, 0, 87, 255, 25, 0,
            ],
            &[
                0, 164, 213, 0, 0, 0, 13, 249, 252, 97, 0, 0, 0, 139, 231, 0, 0,
            ],
            &[
                0, 111, 253, 13, 0, 0, 83, 243, 167, 174, 0, 0, 0, 190, 181, 0, 0,
            ],
            &[
                0, 59, 255, 64, 0, 0, 161, 184, 98, 243, 7, 0, 1, 240, 131, 0, 0,
            ],
            &[
                0, 10, 252, 118, 0, 3, 235, 113, 28, 255, 71, 0, 36, 255, 81, 0, 0,
            ],
            &[
                0, 0, 210, 171, 0, 60, 255, 40, 0, 210, 147, 0, 87, 255, 31, 0, 0,
            ],
            &[
                0, 0, 157, 222, 0, 137, 221, 0, 0, 135, 223, 0, 136, 236, 0, 0, 0,
            ],
            &[
                0, 0, 105, 254, 10, 210, 145, 0, 0, 59, 255, 41, 178, 187, 0, 0, 0,
            ],
            &[
                0, 0, 52, 255, 67, 255, 69, 0, 0, 3, 236, 110, 212, 137, 0, 0, 0,
            ],
            &[
                0, 0, 6, 249, 155, 243, 6, 0, 0, 0, 164, 171, 240, 87, 0, 0, 0,
            ],
            &[
                0, 0, 0, 204, 236, 174, 0, 0, 0, 0, 88, 236, 255, 37, 0, 0, 0,
            ],
            &[0, 0, 0, 151, 255, 98, 0, 0, 0, 0, 17, 251, 241, 1, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ŷ' / 0x176
        'Ŷ' => &[
            &[0, 0, 0, 0, 0, 0, 97, 252, 241, 157, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 50, 246, 104, 61, 247, 100, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 27, 226, 122, 0, 0, 77, 242, 65, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 134, 112, 0, 0, 0, 0, 71, 169, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 54, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 69, 1, 0],
            &[0, 110, 255, 71, 0, 0, 0, 0, 0, 0, 0, 0, 18, 242, 168, 0, 0],
            &[0, 7, 225, 198, 0, 0, 0, 0, 0, 0, 0, 0, 131, 252, 39, 0, 0],
            &[0, 0, 98, 255, 71, 0, 0, 0, 0, 0, 0, 17, 241, 157, 0, 0, 0],
            &[0, 0, 3, 216, 198, 0, 0, 0, 0, 0, 0, 129, 249, 31, 0, 0, 0],
            &[0, 0, 0, 85, 255, 71, 0, 0, 0, 0, 15, 240, 146, 0, 0, 0, 0],
            &[0, 0, 0, 1, 206, 198, 0, 0, 0, 0, 126, 245, 23, 0, 0, 0, 0],
            &[0, 0, 0, 0, 73, 255, 71, 0, 0, 14, 238, 135, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 195, 198, 0, 0, 123, 240, 17, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 61, 255, 71, 13, 237, 124, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 183, 198, 121, 234, 12, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 50, 254, 247, 113, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 183, 239, 8, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 120, 143, 13, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ŷ' / 0x177
        'ŷ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 1, 142, 165, 20, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 113, 248, 233, 172, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 63, 249, 86, 47, 241, 118, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 38, 234, 102, 0, 0, 61, 240, 80, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 124, 91, 0, 0, 0, 0, 55, 154, 7, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 8, 93, 44, 0, 0, 0, 0, 0, 0, 0, 0, 22, 93, 35, 0, 0],
            &[0, 0, 209, 188, 0, 0, 0, 0, 0, 0, 0, 0, 124, 254, 32, 0, 0],
            &[0, 0, 108, 254, 33, 0, 0, 0, 0, 0, 0, 0, 215, 189, 0, 0, 0],
            &[0, 0, 16, 246, 131, 0, 0, 0, 0, 0, 0, 52, 255, 93, 0, 0, 0],
            &[0, 0, 0, 160, 227, 3, 0, 0, 0, 0, 0, 143, 242, 10, 0, 0, 0],
            &[0, 0, 0, 59, 255, 74, 0, 0, 0, 0, 3, 232, 156, 0, 0, 0, 0],
            &[0, 0, 0, 0, 213, 173, 0, 0, 0, 0, 71, 255, 59, 0, 0, 0, 0],
            &[0, 0, 0, 0, 111, 250, 22, 0, 0, 0, 163, 218, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 18, 247, 116, 0, 0, 11, 244, 122, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 164, 215, 0, 0, 91, 253, 28, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 62, 255, 57, 0, 181, 185, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 216, 154, 19, 251, 89, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 115, 236, 105, 240, 8, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 20, 249, 233, 152, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 167, 255, 55, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 170, 214, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 17, 248, 118, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 110, 250, 25, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 5, 225, 162, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 1, 150, 253, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 196, 176, 223, 255, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 125, 158, 141, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ÿ' / 0x178
        'Ÿ' => &[
            &[0, 0, 0, 0, 46, 99, 4, 0, 0, 0, 76, 72, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 192, 255, 64, 0, 0, 10, 250, 245, 3, 0, 0, 0, 0],
            &[0, 0, 0, 0, 129, 221, 27, 0, 0, 0, 193, 182, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 54, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 69, 1, 0],
            &[0, 110, 255, 71, 0, 0, 0, 0, 0, 0, 0, 0, 18, 242, 168, 0, 0],
            &[0, 7, 225, 198, 0, 0, 0, 0, 0, 0, 0, 0, 131, 252, 39, 0, 0],
            &[0, 0, 98, 255, 71, 0, 0, 0, 0, 0, 0, 17, 241, 157, 0, 0, 0],
            &[0, 0, 3, 216, 198, 0, 0, 0, 0, 0, 0, 129, 249, 31, 0, 0, 0],
            &[0, 0, 0, 85, 255, 71, 0, 0, 0, 0, 15, 240, 146, 0, 0, 0, 0],
            &[0, 0, 0, 1, 206, 198, 0, 0, 0, 0, 126, 245, 23, 0, 0, 0, 0],
            &[0, 0, 0, 0, 73, 255, 71, 0, 0, 14, 238, 135, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 195, 198, 0, 0, 123, 240, 17, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 61, 255, 71, 13, 237, 124, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 183, 198, 121, 234, 12, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 50, 254, 247, 113, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 183, 239, 8, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 160, 225, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ź' / 0x179
        'Ź' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 253, 159, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 24, 229, 181, 5, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 8, 197, 185, 9, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 95, 146, 5, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 36, 71, 71, 71, 71, 71, 71, 71, 71, 71, 24, 0, 0, 0],
            &[
                0, 0, 0, 132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 85, 0, 0, 0,
            ],
            &[
                0, 0, 0, 13, 25, 25, 25, 25, 25, 25, 25, 163, 242, 20, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 249, 128, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 236, 14, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 42, 253, 115, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 228, 8, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 54, 255, 103, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 189, 219, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 68, 255, 90, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 202, 209, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 82, 255, 77, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 3, 214, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 96, 255, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 6, 224, 185, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 110, 254, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 12, 233, 173, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 124, 252, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 15, 240, 217, 110, 110, 110, 110, 110, 110, 110, 110, 55, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 106, 152, 36, 0, 0, 0, 0],
        ],
        // letter: 'ź' / 0x17a
        'ź' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 148, 169, 17, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 255, 106, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 56, 249, 132, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 29, 229, 136, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 111, 104, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 60, 93, 93, 93, 93, 93, 93, 93, 93, 93, 31, 0, 0, 0],
            &[
                0, 0, 0, 150, 231, 231, 231, 231, 231, 231, 231, 244, 255, 82, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 222, 204, 6, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 242, 36, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 255, 92, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 37, 243, 161, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 6, 205, 218, 12, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 249, 50, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 71, 254, 112, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 22, 232, 180, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 1, 183, 229, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 114, 253, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 50, 249, 132, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 217, 239, 100, 96, 96, 96, 96, 96, 96, 96, 37, 0, 0, 0,
            ],
            &[
                0, 0, 56, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ż' / 0x17b
        'Ż' => &[
            &[0, 0, 0, 0, 0, 0, 0, 83, 210, 85, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 173, 255, 176, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 61, 174, 63, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 36, 71, 71, 71, 71, 71, 71, 71, 71, 71, 24, 0, 0, 0],
            &[
                0, 0, 0, 132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 85, 0, 0, 0,
            ],
            &[
                0, 0, 0, 13, 25, 25, 25, 25, 25, 25, 25, 163, 242, 20, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 249, 128, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 236, 14, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 42, 253, 115, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 228, 8, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 54, 255, 103, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 189, 219, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 68, 255, 90, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 202, 209, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 82, 255, 77, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 3, 214, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 96, 255, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 6, 224, 185, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 110, 254, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 12, 233, 173, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 124, 252, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 15, 240, 217, 110, 110, 110, 110, 110, 110, 110, 110, 55, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ż' / 0x17c
        'ż' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 159, 253, 94, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 199, 255, 133, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 40, 108, 18, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 60, 93, 93, 93, 93, 93, 93, 93, 93, 93, 31, 0, 0, 0],
            &[
                0, 0, 0, 150, 231, 231, 231, 231, 231, 231, 231, 244, 255, 82, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 222, 204, 6, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 242, 36, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 255, 92, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 37, 243, 161, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 6, 205, 218, 12, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 249, 50, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 71, 254, 112, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 22, 232, 180, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 1, 183, 229, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 114, 253, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 50, 249, 132, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 217, 239, 100, 96, 96, 96, 96, 96, 96, 96, 37, 0, 0, 0,
            ],
            &[
                0, 0, 56, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'Ž' / 0x17d
        'Ž' => &[
            &[0, 0, 0, 0, 5, 186, 181, 8, 0, 9, 185, 188, 6, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 15, 215, 175, 7, 180, 213, 14, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 39, 245, 223, 242, 34, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 96, 185, 89, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 36, 71, 71, 71, 71, 71, 71, 71, 71, 71, 24, 0, 0, 0],
            &[
                0, 0, 0, 132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 85, 0, 0, 0,
            ],
            &[
                0, 0, 0, 13, 25, 25, 25, 25, 25, 25, 25, 163, 242, 20, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 249, 128, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 236, 14, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 42, 253, 115, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 228, 8, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 54, 255, 103, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 189, 219, 4, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 68, 255, 90, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 202, 209, 1, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 82, 255, 77, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 3, 214, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 96, 255, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 6, 224, 185, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 110, 254, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 12, 233, 173, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 124, 252, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 15, 240, 217, 110, 110, 110, 110, 110, 110, 110, 110, 55, 0, 0, 0,
            ],
            &[
                0, 0, 42, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 57, 127, 5, 0, 0, 0, 6, 129, 62, 0, 0, 0, 0],
        ],
        // letter: 'ž' / 0x17e
        'ž' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 83, 135, 3, 0, 0, 0, 25, 161, 43, 0, 0, 0, 0],
            &[0, 0, 0, 0, 9, 198, 173, 5, 0, 31, 220, 140, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 22, 225, 162, 22, 218, 173, 1, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 52, 251, 236, 215, 10, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 102, 163, 51, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 60, 93, 93, 93, 93, 93, 93, 93, 93, 93, 31, 0, 0, 0],
            &[
                0, 0, 0, 150, 231, 231, 231, 231, 231, 231, 231, 244, 255, 82, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 222, 204, 6, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 242, 36, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 255, 92, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 37, 243, 161, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 6, 205, 218, 12, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 140, 249, 50, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 71, 254, 112, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 22, 232, 180, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 1, 183, 229, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 114, 253, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 50, 249, 132, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[
                0, 0, 11, 217, 239, 100, 96, 96, 96, 96, 96, 96, 96, 37, 0, 0, 0,
            ],
            &[
                0, 0, 56, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 100, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        // letter: 'ſ' / 0x17f
        'ſ' => &[
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 2, 68, 136, 160, 154, 119, 19, 0, 0, 0, 0],
            &[
                0, 0, 0, 0, 0, 20, 192, 255, 220, 181, 187, 226, 19, 0, 0, 0, 0,
            ],
            &[0, 0, 0, 0, 0, 178, 246, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 36, 255, 139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 96, 255, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 119, 255, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 126, 255, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            &[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ],
        _ => panic!("unsupported char"),
    }
}
