use crate::NoteError;
use std::ops::Range;
use yggdrasil_shared::records::{lsp_types::Diagnostic, TextIndex};

impl Into<Diagnostic> for NoteError {
    fn into(self) -> Diagnostic {}
}

impl NoteError {
    pub fn build_diag(&self, text: &TextIndex) -> Diagnostic {
        let range = match &self.range {
            None => Default::default(),
            Some(r) => text.get_lsp_range(r.start, r.end),
        };
        Diagnostic {
            range,
            severity: None,
            code: None,
            code_description: None,
            source: None,
            message: "".to_string(),
            related_information: None,
            tags: None,
            data: None,
        }
    }
}
