use super::*;

mod detailed;
mod prefix;
mod simple;

pub use self::{detailed::ListDetailedNode, simple::ListSimpleNode};
pub use self::prefix::ListPrefixSymbol;

#[derive(Clone, Eq, PartialEq, Hash)]
pub enum ListView {
    /// ## Quote List
    /// ```note
    /// > part1
    /// > part2
    ///   part2
    /// > part3
    ///
    /// > part4
    /// ```
    Quote(Box<ListSimpleNode>),
    /// ## Ordered List
    /// ```note
    /// 1.1. part1
    /// 1.2. part2
    ///      part2
    /// 1.3. part3
    ///
    /// 1.4. part4
    /// ```
    Ordered(Box<ListSimpleNode>),
    /// ## Orderless List
    /// ```note
    /// - part1
    /// - part2
    ///   part2
    /// - part3
    ///
    /// - part4
    /// ```
    Orderless(Box<ListSimpleNode>),

    Details(Box<ListDetailedNode>),
}

#[derive(Clone, Debug, Eq, PartialEq, Hash)]
pub struct ListItem {
    prefix: Literal<ListPrefixSymbol>,
    rest: ASTNodes,
}


impl From<ListView> for ASTNode {
    fn from(node: ListView) -> Self {
        Self { value: ASTKind::ListView(node), range: None }
    }
}

impl From<ASTNodes> for ListItem {
    fn from(node: ASTNodes) -> Self {
        Self { prefix: Default::default(), rest: node }
    }
}
