use anyhow::Result;
use super::*;

#[test]
fn arch_string() -> Result<()> {
    assert_eq!(Arch::X86_64, "x86_64".parse()?);
    assert_eq!("x86_64", &Arch::X86_64.to_string());

    assert_eq!(Arch::AArch64, "aarch64".parse()?);
    assert_eq!("aarch64", &Arch::AArch64.to_string());

    Ok(())
}

#[test]
fn system_string() -> Result<()> {
    assert_eq!(System::Linux, "linux".parse()?);
    assert_eq!("linux", &System::Linux.to_string());
    Ok(())
}

#[test]
fn version_string() -> Result<()> {
    assert_eq!(Version::new(1, 2, 3), "1.2.3".parse()?);
    assert_eq!("1.2.3", &Version::new(1, 2, 3).to_string());
    Ok(())
}
