use rusoto_dynamodb::*;

pub const DATA:  &str = "NotaryData";
pub const META:  &str = "NotaryMeta";
pub const INDEX: &str = "NotaryDataReleaseIndex";

pub fn meta() -> CreateTableInput {
    CreateTableInput {
        table_name: META.to_owned(),
        attribute_definitions: vec![
            AttributeDefinition {
                attribute_name: "id".to_owned(),
                attribute_type: "S".to_owned(),
            },
        ],
        key_schema: vec![
            KeySchemaElement {
                attribute_name: "id".to_owned(),
                key_type:       "HASH".to_owned(),
            },
        ],
        billing_mode: Some("PROVISIONED".to_owned()),
        provisioned_throughput: Some(ProvisionedThroughput {
            read_capacity_units:  2,
            write_capacity_units: 2,
        }),
        ..Default::default()
    }
}

pub fn data() -> CreateTableInput {
    CreateTableInput {
        table_name: DATA.to_owned(),
        attribute_definitions: vec![
            AttributeDefinition {
                attribute_name: "artifact".to_owned(),
                attribute_type: "S".to_owned(),
            },
            AttributeDefinition {
                attribute_name: "revision".to_owned(),
                attribute_type: "N".to_owned(),
            },
            AttributeDefinition {
                attribute_name: "released".to_owned(),
                attribute_type: "N".to_owned(),
            },
        ],
        key_schema: vec![
            KeySchemaElement {
                attribute_name: "artifact".to_owned(),
                key_type:       "HASH".to_owned(),
            },
            KeySchemaElement {
                attribute_name: "revision".to_owned(),
                key_type:       "RANGE".to_owned(),
            },
        ],
        global_secondary_indexes: Some(vec![index()]),
        billing_mode: Some("PROVISIONED".to_owned()),
        provisioned_throughput: Some(ProvisionedThroughput {
            read_capacity_units:  2,
            write_capacity_units: 2,
        }),
        ..Default::default()
    }
}

fn index() -> GlobalSecondaryIndex {
    GlobalSecondaryIndex {
        index_name: INDEX.to_owned(),
        key_schema: vec![
            KeySchemaElement {
                attribute_name: "artifact".to_owned(),
                key_type:       "HASH".to_owned(),
            },
            KeySchemaElement {
                attribute_name: "released".to_owned(),
                key_type:       "RANGE".to_owned(),
            },
        ],
        projection: Projection {
            projection_type: Some("ALL".to_owned()),
            ..Default::default()
        },
        provisioned_throughput: Some(ProvisionedThroughput {
            read_capacity_units:  8,
            write_capacity_units: 2,
        }),
    }
}
