use anyhow::Result;
use bytes::Bytes;
use rusoto_lambda::{Lambda, LambdaClient, InvocationRequest};
use serde::de::DeserializeOwned;
use super::notary::SECRET_FN;
use super::server::{Command, Response};

pub async fn invoke<T: DeserializeOwned>(client: &LambdaClient, cmd: Command) -> Result<T> {
    let payload = serde_json::to_vec(&cmd)?;

    let output = client.invoke(InvocationRequest {
        function_name: SECRET_FN.to_owned(),
        payload:       Some(Bytes::from(payload)),
        ..Default::default()
    }).await?;

    let payload = output.payload.unwrap_or_default();

    match serde_json::from_slice(&payload)? {
        Response::Success(value) => Ok(value),
        Response::Failure(error) => Err(error.into()),
    }
}
