// NEWLINE_PROCESS_FUNCへの対応
// 関数と関数の間に空行がなかった場合空行を挿入する

use crate::c_parser;

pub fn format(file_texts: &Vec<String>) -> Vec<String> {
	let mut new_file_texts: Vec<String> = Vec::new();
	for (i, line) in file_texts.iter().enumerate() {
		new_file_texts.push(line.to_string());
		let next_line = file_texts.get(i + 1).unwrap();
		// 関数の終わりの行でかつ次の行が空行ではない場合、空行を挿入する
		if line.starts_with("}") && next_line != "" {
			new_file_texts.push(String::from(""));
		}
	}
	new_file_texts
}

// #[cfg(test)]
// mod test {
// 	use super::*;
// 	use crate::test_util;

// 	const TEST_FILE_COUNT: usize = 1;

// 	#[test]
// 	fn test_format() {
// 		let (file_texts, formatted_file_texts) =
// 			test_util::load_text_from_file("replace_tab_before_func", TEST_FILE_COUNT);
// 		// TODO: パニック時のメッセージ
// 			assert_eq!(
// 			format(&file_texts[0]),
// 			formatted_file_texts[0]
// 		);
// 	}
// }
