use crate::config::Artifact;
use crate::config::{FromPrompt, Repo};
use crate::ui;
use anyhow::Result;
use serde::{Deserialize, Serialize};
use url::Url;

#[derive(Serialize, Deserialize, Debug, Clone)]
pub struct Gitea {
    domain: String,
    user: String,
    repo: String,
}

impl FromPrompt for Gitea {
    fn from_prompt() -> Result<Self, std::io::Error> {
        let domain = ui::input_url("Instance domain")?.into_string();
        let user: String = ui::input("Repository user")?;
        let repo: String = ui::input("Repository slug")?;
        Ok(Gitea { domain, user, repo })
    }
}

impl Repo for Gitea {
    fn should_upgrade(&self, _: &str) -> Result<(bool, String)> {
        todo!()
    }

    fn pull(&self, _: &Vec<Artifact>) -> Result<Vec<Url>> {
        todo!()
    }

    fn get_display(&self) -> String {
        todo!()
    }
}
