# nopkg

`nopkg` is a command-line tool to help you download files which doesn't have a regular package. `nopkg` is intended to wipe out the all-too-common workflow of hunting for an executable, downloading it to the right place, renaming it, etc.

After going through `nopkg`'s setup process, all you have to do is run `nopkg pull` and the latest release artifact (which matches a regex) will be downloaded for you and saved to whatever filename you specify, optionally setting the executable bit.

Supported platforms:

- GitHub
- Planned: Gitea
- Planned: GitLab

If you have any suggestions for platforms feel free to make an issue or pull request.

## Usage

You can run `nopkg new` to set up a new repository and it will guide you through setting everything up. Here is an example of what the command line looks output of this process is:

```
$ nopkg new
✔ Select the host · GitHub
✔ Use a GitHub enterprise domain? · no
✔ Pull from prereleases? · no
✔ Repository user · andreimarcu
✔ Repository slug · linx-server
✔ Regex of file to pull · linx-server-v.*_linux-amd64
✔ Output filename · linx-server
✔ Set executable bit? · yes
✔ Add another file? · no
» Upgrading andreimarcu/linx-server to version v2.3.7
    ✔ Downloaded file linx-server
```

Now, if a new version of the program is released, simply run `nopkg pull`:

```
$ nopkg pull
» Upgrading andreimarcu/linx-server to version v2.3.8
    ✔ Downloaded file linx-server
```

If you run `pull` while on the latest version, `nopkg` will report that it is up to date:

```
$ nopkg pull
✔ andreimarcu/linx-server up to date!
```

## FAQ\*

_What is the use case for this? Why not just use a package?_

For programs that have packages for your OS, you should prefer to use that. The main use for `nopkg` is for programs that, well, have no package. Creating a package for every program you might want to use certainly isn't trivially either, especially if you are using Debian or a derivative. `nopkg` helps avoid [FrankenDebian](https://wiki.debian.org/DontBreakDebian#Don.27t_make_a_FrankenDebian) or vendor dependency hell.

_Is there a way to update all nopkg configs?_

No, there is intentionally no way to do this. One of the common use cases is to download the latest executable for a server, in which each application should be isolated (ie. one application per user). If there was a singular update command, it would either have to be per-user (making it useless for this use-case) or run as root which does not seem very appropriate.

---

\*: not actually frequently asked, but I have no idea what else to call this section
