use core::marker::PhantomData;

use crate::core::{Class, Ttl, Type};
use crate::emit::message::{ArSection, ArWithOpt, MessageBuilder, MessageError};
use crate::emit::record::{RecordBuilder, RecordData, RecordError};
use crate::emit::{Buffer, Builder, PushBuilder, Sink};

error!(ExtensionError, Record);
/// failed to emit OPT RR
#[derive(Debug, displaydoc::Display)]
#[prefix_enum_doc_attributes]
pub enum ExtensionError {
    /// error while emitting record
    Record(RecordError),
}

pub struct ExtensionBuilder<B: Buffer, P: Builder<B>> {
    buffer: PhantomData<B>,
    parent: RecordBuilder<B, P, RecordData>,
}

impl<B: Buffer, P: Builder<B>> PushBuilder<B, RecordBuilder<B, P, RecordData>>
    for ExtensionBuilder<B, P>
{
    type Error = ExtensionError;
    fn push(parent: RecordBuilder<B, P, RecordData>) -> Result<Self, ExtensionError> {
        Ok(Self {
            buffer: PhantomData,
            parent,
        })
    }
}

builder! {
    <B, P> ExtensionBuilder {
        Builder;
        @ <MessageBuilder<B, P, ArSection>>:
            /// Finish building the EDNS OPT RR and return to the parent builder.
            pub fn finish(mut self) -> Result<MessageBuilder<B, P, ArWithOpt>, MessageError> = {
                Ok(self
                    .parent
                    .r#type(Type(41))
                    .class(Class(4096))
                    .ttl(Ttl(0))
                    .finish()
                    .map_err(ExtensionError::Record)
                    .map_err(MessageError::Extension)?
                    .into())
            }
    }
}
