#![allow(dead_code)]

use core::convert::{Infallible, TryFrom, TryInto};
use core::marker::PhantomData;

use super::{Buffer, Builder, PushBuilder, Sink};

impl<B: Buffer, P: Builder<B>> PushBuilder<B, P> for ChildBuilder<B, P, Baby> {
    type Error = Infallible;
    fn push(parent: P) -> Result<Self, Self::Error> {
        Ok(Self {
            buffer: PhantomData,
            parent,
            step: Baby,
        })
    }
}
struct FooBuilder<B: Buffer, P: Builder<B>, Q> {
    buffer: PhantomData<B>,
    parent: P,
    step: Q,
}
impl<B: Buffer, P: Builder<B>> TryFrom<FooBuilder<B, P, FooBaz>> for FooBuilder<B, P, FooQux> {
    type Error = FooError;
    fn try_from(value: FooBuilder<B, P, FooBaz>) -> Result<Self, Self::Error> {
        Ok(Self {
            buffer: value.buffer,
            parent: value.parent,
            step: FooQux,
        })
    }
}
struct FooBar;
struct FooBaz;
struct FooQux;
#[derive(Debug)]
enum FooError {
    Child(Infallible),
}
transition! { FooBuilder.step { (buffer, parent) FooBar -> FooBaz; } }
struct ParentBuilder<B: Buffer, P: Builder<B>, Q> {
    buffer: PhantomData<B>,
    parent: P,
    step: Q,
}
struct Parent0;
struct Parent1;
struct Parent2;
trait SpecialStates {}
impl SpecialStates for Parent0 {}
impl SpecialStates for Parent1 {}
trait OtherStates {}
impl SpecialStates for Parent2 {}
struct ChildBuilder<B: Buffer, P: Builder<B>, Q> {
    buffer: PhantomData<B>,
    parent: P,
    step: Q,
}
struct Baby;
builder! {
    <B, P> FooBuilder {
        Builder [Q];
        @ <P> Q [Q]:
            /// a
            fn handle_tu[T, U: Ord](mut self, t: T, u: U) -> Self = { drop((t, u)); self }
        @ <ParentBuilder<B, P, Q>> FooBar [Q: SpecialStates]:
            pub fn into_baz(mut self) = [into FooBaz] { self }
        @ <P> FooBaz:
            pub fn try_into_qux(mut self) = [try_into FooQux | FooError] { self }
        @ <P> FooQux:
            pub fn push_child[T, U: Ord](mut self, t: T, u: U) =
                [push ChildBuilder<Baby> | FooError::Child]
                { self.handle_tu(t, u) }
    }
}
builder! { <B, P> ParentBuilder { Builder [Q]; } }
builder! { <B, P> ChildBuilder { Builder [Q]; } }

#[test]
fn test() -> Result<(), FooError> {
    let buffer = PhantomData;
    let parent: Sink<_> = arrayvec::ArrayVec::<[u8; 4096]>::new().try_into().unwrap();
    let parent = ParentBuilder {
        buffer,
        parent,
        step: Parent0,
    };
    let foo = FooBuilder {
        buffer,
        parent,
        step: FooBar,
    };

    foo.into_baz().try_into_qux()?.push_child(false, 0)?;

    Ok(())
}
