# 0.3.1 (2021-07-05)


## bore


- fixed bug where failure to gather default resolvers would break `--decode`
    - this is necessary for a useful installCheckPhase in the Nix derivation
    - note that failure otherwise remains fatal unless `--host` is given


# 0.3.0 (2021-07-04)


- nonymous-scoop was removed (0.0.2 was the last version)
    - please install [bore](https://crates.io/crates/bore) instead
- nonymous + bore: increased minimum Rust version from 1.39 to 1.46
- nonymous + bore: the “strict” package feature has been removed in favour of `#[cfg(ci_)]`
    - use `RUSTFLAGS='--cfg ci'` instead of `--feature strict` to build these crates with `#[deny(warnings)]`
- nonymous + bore: `Label` now displays symbols other than `-_;` and space in the more compact `\;` format


## Conformance


- nonymous + bore: IPv6 addresses are now displayed in canonical format ([RFC 5952](https://datatracker.ietf.org/doc/html/rfc5952))
- nonymous + bore: `NameBuilder::labels` and &lt;host> argument now parse names in zone format (supporting escapes)


## nonymous


- removed all hard dependencies on `alloc` and `std` outside of tests
    - `Record::{rdata, try_rdata}` now return non-exhaustive enum instead of `Box<dyn>`
    - `Type` and `Class` name/value maps are now backed by compile-time sorted arrays
    - all tests except one now run in `#![no_std]` without `alloc` (but not benches)
    - all `alloc`/`std`-dependent features in dependencies are now disabled or feature-gated
    - CI runs a new test (nonono) that will fail to compile given any future regressions
- fixed broken links in rustdoc for `view` iterator types and some `MessageBuilder` methods


## bore


- new option `--show-resolvers` lists resolver hosts and ports that would be used
- new option `--reverse` (`-x`) makes a reverse DNS query (in-addr.arpa. or ip6.arpa.)
- new option `--color` highlights output to draw your attention to important parts
- new option `--man` views detailed docs compiled into the binary
- crate now uses [pledge(2)](https://man.openbsd.org/OpenBSD-6.3/pledge.2) + [unveil(2)](https://man.openbsd.org/OpenBSD-6.4/unveil.2) for security on OpenBSD
- crate now gathers system resolvers with GetAdaptersAddresses on Windows
- crate now gathers system resolvers with dns_configuration_copy on macOS
- crate now uses [eyre](https://crates.io/crates/eyre) for error reporting (was [failure](https://crates.io/crates/failure))
- crate now correctly reports nested errors with full source chains (causes)
- crate now has meaningful error messages on every fallible code path
- crate can no longer be consumed as a library (was a hack for nonymous-scoop)


## API changes


- **note: there are a great deal of breaking changes, but we have tried to list as many as possible below**
- error handling has been reworked
    - all error types now implement std::error::Error where available (was [failure](https://crates.io/crates/failure)::Error)
        - note: without the “std” feature, `view::rdata::RdataError` discards original error for now
    - all error messages have been rewritten and improved with the help of [displaydoc](https://crates.io/crates/displaydoc)
    - `emit::BoundsError` is now an enum with three tuple variants (was unit struct)
    - `emit::NameError` new variants: DecimalEscapeRange, DecimalEscapeSyntax, UnfinishedEscape, UnfinishedLabel
- `emit` has been reworked and simplified to a new panic-free API with fallible packet writing
    - `Sink` now replaces `RootBuilder` and `RootBuildee` as the top of the builder hierarchy
    - eliminated the distinction between `Buildee` (no `Sink`) and `Builder` (buildee plus sink)
    - `Sink::new` has been split into `TryFrom::from` (no limit) and `Sink::with_limit` (limit: u16)
    - `Sink` growth is now fallible with a new `GrowError` type (previously panicking)
    - `Sink` creation is now fallible with a new `SinkError` type (previously panicking)
    - `NewBuilder::new` is now fallible in the same way as `Sink` creation
- `view`: zone-like view formatting has been moved to `crate::zone`
    - to migrate, wrap view objects in a `Plain`, then `Display` as usual
- `NameBuilder::labels` now requires trailing dot and rejects lone dot (bore is unaffected)
- `NameBuilder::labels` now takes a `&[u8]` rather than a `&str`
    - for the old behaviour, pass `str` arguments through `str::as_bytes`


# 0.0.2 (2021-01-03)


## Breaking


- scoop(1) ([nonymous-scoop](https://crates.io/crates/nonymous-scoop)) was renamed to bore(1) ([bore](https://crates.io/crates/bore))
    - you can still install nonymous-scoop if you want scoop(1), but this version will be the last
- nonymous: increased minimum Rust version from 1.37 to 1.39
- nonymous: `crate::emit` was rewritten from scratch (pull request #2)
    - for an example of how to migrate, see bore/src/main.rs
    - API is now zero-copy, `#![no_std]` compatible, and harder to misuse
    - you can pass a packet size limit to `Sink`, for UDP and similar use cases
- nonymous: `crate::NeverError` was removed (but it was only used by the old `crate::emit`)
- nonymous: `crate::emit::{Type, TypeError}` were moved to `crate::core::{Type, TypeFromStrError}`
- nonymous: `crate::emit::{Class, ClassError}` were moved to `crate::core::{Class, ClassFromStrError}`
- nonymous: `crate::emit::{Ttl, TtlError}` were moved to `crate::core::{Ttl, TtlFromStrError}`
- nonymous: `NameBuilder::label` (moved from `Name::parent`) now takes a `&[u8]` rather than a `&str`
    - for the old behaviour, pass `str` arguments through `str::as_bytes`


## Issues


- fixed bug where RecordError::Bounds display message is incomplete (issue #1)
- added code coverage checks, currently disabled by default due to [a CI problem] (issue #2)
- fixed bug where `nonymous::emit::Name` doesn’t accept arbitrary binary labels (issue #3)


[a CI problem]: https://twitter.com/dazabani/status/1201527372740096000


## bore


- new options: `--encode` + `--decode` + `--dump` + `--load`
- crate is now built against Rust 1.39.0 on CI (was nightly-2019-09-13)
- crate now uses the stable Tokio 0.2 API (was 0.2.0-alpha.4)


# 0.0.1 (2019-09-29)


## Breaking


- `nonymous::emit::Record::new` is now fallible, failing when the given `rdata` is too long
- `nonymous::view::ExtensionError` removes the unused `Bounds` variant
- `nonymous::view::Len` was removed
    - for the old behaviour, replace `Len::len` calls with `View::len` calls
- `nonymous::view::Record::rdata` is now infallible, returning `Malformed` as a last resort
    - for the old behaviour, rename `Record::rdata` calls to `Record::try_rdata`
- `nonymous::view::Record::rdata_offset` was removed
    - for the old behaviour, replace calls with `Record::rdata_range(x).start`
- `nonymous::view::View` adds a required `fn len`


## nonymous


- crate is now `#![forbid(unsafe_code)]`
- `crate::view` error types now have meaningful error messages
- crate moves [assert_matches] from `[dependencies]` to `[dev-dependencies]`
- crate cleans up unwrap calls outside of tests and benches
- crate cleans up FIXME sites for `as {integer}` casts


## nonymous-scoop


- crate is now `#![forbid(unsafe_code)]`
- scoop(1) now uses `Display` to report fatal errors and their causes
- crate moves [assert_matches] from `[dependencies]` to `[dev-dependencies]`
- crate bumps tokio to 0.2.0-alpha.4 explicitly
- crate cleans up unwrap calls outside of tests and benches


[assert_matches]: https://crates.io/crates/assert_matches


# 0.0.0 (2019-09-16)


## nonymous


- initial release with view and emit modules


## nonymous-scoop


- initial release with resolv.conf(5) support
