//! The `nonogrid` contains set of algorithms and solvers to solve the nonogram puzzles.

// do not warn on older Rust versions
#![allow(unknown_lints)]
//
// The following list was generated with the command
//   $ rustc -W help | grep ' allow ' | awk '{print $1}' | tr - _ | sort | xargs -I{} echo '#![warn({})]'
//
#![warn(absolute_paths_not_starting_with_crate)]
#![warn(anonymous_parameters)]
// use `Box` without fear
#![allow(box_pointers)]
#![warn(deprecated_in_future)]
#![warn(elided_lifetimes_in_paths)]
#![warn(explicit_outlives_requirements)]
#![warn(indirect_structural_match)]
#![warn(keyword_idents)]
#![warn(macro_use_extern_crate)]
#![warn(meta_variable_misuse)]
#![warn(missing_abi)]
#![warn(missing_copy_implementations)]
#![warn(missing_debug_implementations)]
#![warn(missing_docs)]
#![warn(non_ascii_idents)]
#![warn(noop_method_call)]
#![warn(pointer_structural_match)]
// produces an ICE when enabled as a warning
#![allow(rust_2021_incompatible_closure_captures)]
#![warn(rust_2021_incompatible_or_patterns)]
#![warn(rust_2021_prefixes_incompatible_syntax)]
#![warn(rust_2021_prelude_collisions)]
#![warn(single_use_lifetimes)]
#![warn(trivial_casts)]
#![warn(trivial_numeric_casts)]
#![warn(unaligned_references)]
// conflicts with the `clippy::redundant_pub_crate`
#![allow(unreachable_pub)]
// !!! NO UNSAFE
#![forbid(unsafe_code)]
#![warn(unsafe_op_in_unsafe_fn)]
#![warn(unstable_features)]
// some crates are only used in binary (see `main.rs`), not in the lib itself
#![allow(unused_crate_dependencies)]
#![warn(unused_extern_crates)]
#![warn(unused_import_braces)]
#![warn(unused_labels)]
#![warn(unused_lifetimes)]
#![warn(unused_qualifications)]
#![warn(unused_results)]
#![warn(variant_size_differences)]
//
// additional recommendations
#![deny(clippy::mem_forget)]
// `use super::*` in tests
#![cfg_attr(test, allow(clippy::wildcard_imports))]
//
//
// FIXME: remove or localize the following suppression:
#![allow(missing_docs)]
#![allow(clippy::missing_errors_doc)]
#![allow(clippy::module_name_repetitions)]
#![allow(clippy::must_use_candidate)]

pub use self::{
    block::{
        base::{color::ColorId, Block, Color, Description},
        binary::{BinaryBlock, BinaryColor},
        multicolor::ColoredBlock,
    },
    board::Board,
    parser::{BoardParser, DetectedParser},
    solver::{
        line::{DynamicColor, DynamicSolver as LineSolver},
        probing::{FullProbe1 as FullProbe, ProbeSolver},
        propagation::Solver as PropagationSolver,
        run as solve,
    },
};

mod block;
mod board;
mod cache;
pub mod parser;
pub mod render;
mod solver;
mod utils;

pub type RcBoard<B> = utils::rc::MutRc<Board<B>>;
