use std::env;
use std::process;

use noname::Config;

fn main() {
    let config = Config::new(env::args()).unwrap_or_else(|err| {
        eprintln!("Problem parsing arguments: {}", err);
        process::exit(1);
    });

    // --snip--

    if let Err(e) = noname::run(config) {
        eprintln!("Application error: {}", e);

        process::exit(1);
    }
}
