use std::io::Write;

const DEFINITIONS: &str = include_str!(concat!(env!("CARGO_MANIFEST_DIR"), "/data/definitions.ts"));
const TYPEDEFS: &str = include_str!(concat!(env!("CARGO_MANIFEST_DIR"), "/data/types.rs"));

const OUTPUT_FILE: &str = concat!(env!("CARGO_MANIFEST_DIR"), "/src/wasm/types.rs");

fn main() -> eyre::Result<()> {
    println!(
        "cargo:rerun-if-changed={}",
        concat!(env!("CARGO_MANIFEST_DIR"), "/data/definitions.ts")
    );
    println!(
        "cargo:rerun-if-changed={}",
        concat!(env!("CARGO_MANIFEST_DIR"), "/data/types.rs")
    );

    let mut f = std::fs::OpenOptions::new()
        .write(true)
        .truncate(true)
        .open(OUTPUT_FILE)
        .unwrap();

    writeln!(f, "//! THIS IS AUTOGENERATED CODE, DO NOT EDIT")?;
    writeln!(
        f,
        "//! Please edit `data/definitions.ts` and `data/types.rs`"
    )?;
    writeln!(f, "use wasm_bindgen::prelude::*;")?;
    writeln!(
        f,
        r###"
#[wasm_bindgen(typescript_custom_section)]
const _: &'static str = r#""###
    )?;
    f.write_all(DEFINITIONS.as_ref())?;
    writeln!(f, r###""#;"###)?;
    writeln!(f)?;
    f.write_all(TYPEDEFS.as_ref())?;

    Ok(())
}
