/* automatically generated by rust-bindgen 0.59.2 */
use crate::{
    env::NapiEnv, NapiKeyCollectionMode, NapiKeyConversion, NapiKeyFilter, NapiStatus,
    NapiTypedarrayType, NapiValuetype,
};
#[cfg(feature = "v4")]
use crate::{NapiThreadsafeFunctionCallMode, NapiThreadsafeFunctionReleaseMode};

pub type size_t = usize;
pub type char16_t = u16;

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_env__ {
    _unused: [u8; 0],
}
pub type napi_env = *mut napi_env__;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_value__ {
    _unused: [u8; 0],
}
pub type napi_value = *mut napi_value__;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_ref__ {
    _unused: [u8; 0],
}
pub type napi_ref = *mut napi_ref__;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_handle_scope__ {
    _unused: [u8; 0],
}
pub type napi_handle_scope = *mut napi_handle_scope__;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_escapable_handle_scope__ {
    _unused: [u8; 0],
}
pub type napi_escapable_handle_scope = *mut napi_escapable_handle_scope__;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_callback_info__ {
    _unused: [u8; 0],
}
pub type napi_callback_info = *mut napi_callback_info__;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_deferred__ {
    _unused: [u8; 0],
}
pub type napi_deferred = *mut napi_deferred__;
pub const napi_property_attributes_napi_default: napi_property_attributes = 0;
pub const napi_property_attributes_napi_writable: napi_property_attributes = 1;
pub const napi_property_attributes_napi_enumerable: napi_property_attributes = 2;
pub const napi_property_attributes_napi_configurable: napi_property_attributes = 4;
pub const napi_property_attributes_napi_static: napi_property_attributes = 1024;
pub const napi_property_attributes_napi_default_method: napi_property_attributes = 5;
pub const napi_property_attributes_napi_default_jsproperty: napi_property_attributes = 7;
pub type napi_property_attributes = ::std::os::raw::c_uint;
pub const napi_valuetype_napi_undefined: napi_valuetype = 0;
pub const napi_valuetype_napi_null: napi_valuetype = 1;
pub const napi_valuetype_napi_boolean: napi_valuetype = 2;
pub const napi_valuetype_napi_number: napi_valuetype = 3;
pub const napi_valuetype_napi_string: napi_valuetype = 4;
pub const napi_valuetype_napi_symbol: napi_valuetype = 5;
pub const napi_valuetype_napi_object: napi_valuetype = 6;
pub const napi_valuetype_napi_function: napi_valuetype = 7;
pub const napi_valuetype_napi_external: napi_valuetype = 8;
pub const napi_valuetype_napi_bigint: napi_valuetype = 9;
pub type napi_valuetype = ::std::os::raw::c_uint;
pub const napi_typedarray_type_napi_int8_array: napi_typedarray_type = 0;
pub const napi_typedarray_type_napi_uint8_array: napi_typedarray_type = 1;
pub const napi_typedarray_type_napi_uint8_clamped_array: napi_typedarray_type = 2;
pub const napi_typedarray_type_napi_int16_array: napi_typedarray_type = 3;
pub const napi_typedarray_type_napi_uint16_array: napi_typedarray_type = 4;
pub const napi_typedarray_type_napi_int32_array: napi_typedarray_type = 5;
pub const napi_typedarray_type_napi_uint32_array: napi_typedarray_type = 6;
pub const napi_typedarray_type_napi_float32_array: napi_typedarray_type = 7;
pub const napi_typedarray_type_napi_float64_array: napi_typedarray_type = 8;
pub const napi_typedarray_type_napi_bigint64_array: napi_typedarray_type = 9;
pub const napi_typedarray_type_napi_biguint64_array: napi_typedarray_type = 10;
pub type napi_typedarray_type = ::std::os::raw::c_uint;
pub const napi_status_napi_ok: napi_status = 0;
pub const napi_status_napi_invalid_arg: napi_status = 1;
pub const napi_status_napi_object_expected: napi_status = 2;
pub const napi_status_napi_string_expected: napi_status = 3;
pub const napi_status_napi_name_expected: napi_status = 4;
pub const napi_status_napi_function_expected: napi_status = 5;
pub const napi_status_napi_number_expected: napi_status = 6;
pub const napi_status_napi_boolean_expected: napi_status = 7;
pub const napi_status_napi_array_expected: napi_status = 8;
pub const napi_status_napi_generic_failure: napi_status = 9;
pub const napi_status_napi_pending_exception: napi_status = 10;
pub const napi_status_napi_cancelled: napi_status = 11;
pub const napi_status_napi_escape_called_twice: napi_status = 12;
pub const napi_status_napi_handle_scope_mismatch: napi_status = 13;
pub const napi_status_napi_callback_scope_mismatch: napi_status = 14;
pub const napi_status_napi_queue_full: napi_status = 15;
pub const napi_status_napi_closing: napi_status = 16;
pub const napi_status_napi_bigint_expected: napi_status = 17;
pub const napi_status_napi_date_expected: napi_status = 18;
pub const napi_status_napi_arraybuffer_expected: napi_status = 19;
pub const napi_status_napi_detachable_arraybuffer_expected: napi_status = 20;
pub const napi_status_napi_would_deadlock: napi_status = 21;
pub type napi_status = ::std::os::raw::c_uint;
pub type napi_callback = ::std::option::Option<
    unsafe extern "C" fn(env: NapiEnv, info: napi_callback_info) -> napi_value,
>;
pub type napi_finalize = ::std::option::Option<
    unsafe extern "C" fn(
        env: NapiEnv,
        finalize_data: *mut ::std::os::raw::c_void,
        finalize_hint: *mut ::std::os::raw::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_property_descriptor {
    pub utf8name: *const ::std::os::raw::c_char,
    pub name: napi_value,
    pub method: napi_callback,
    pub getter: napi_callback,
    pub setter: napi_callback,
    pub value: napi_value,
    pub attributes: napi_property_attributes,
    pub data: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NapiExtendedErrorInfo {
    pub error_message: *const ::std::os::raw::c_char,
    pub engine_reserved: *mut ::std::os::raw::c_void,
    pub engine_error_code: u32,
    pub error_code: NapiStatus,
}
pub const napi_key_collection_mode_napi_key_include_prototypes: napi_key_collection_mode = 0;
pub const napi_key_collection_mode_napi_key_own_only: napi_key_collection_mode = 1;
pub type napi_key_collection_mode = ::std::os::raw::c_uint;
pub const napi_key_filter_napi_key_all_properties: napi_key_filter = 0;
pub const napi_key_filter_napi_key_writable: napi_key_filter = 1;
pub const napi_key_filter_napi_key_enumerable: napi_key_filter = 2;
pub const napi_key_filter_napi_key_configurable: napi_key_filter = 4;
pub const napi_key_filter_napi_key_skip_strings: napi_key_filter = 8;
pub const napi_key_filter_napi_key_skip_symbols: napi_key_filter = 16;
pub type napi_key_filter = ::std::os::raw::c_uint;
pub const napi_key_conversion_napi_key_keep_numbers: napi_key_conversion = 0;
pub const napi_key_conversion_napi_key_numbers_to_strings: napi_key_conversion = 1;
pub type napi_key_conversion = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NapiTypeTag {
    pub lower: u64,
    pub upper: u64,
}
extern "C" {
    pub fn napi_get_last_error_info(
        env: NapiEnv,
        result: *mut *const NapiExtendedErrorInfo,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_undefined(env: NapiEnv, result: *mut napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_null(env: NapiEnv, result: *mut napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_global(env: NapiEnv, result: *mut napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_boolean(env: NapiEnv, value: bool, result: *mut napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_object(env: NapiEnv, result: *mut napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_array(env: NapiEnv, result: *mut napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_array_with_length(
        env: NapiEnv,
        length: size_t,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_double(env: NapiEnv, value: f64, result: *mut napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_int32(env: NapiEnv, value: i32, result: *mut napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_uint32(env: NapiEnv, value: u32, result: *mut napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_int64(env: NapiEnv, value: i64, result: *mut napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_string_latin1(
        env: NapiEnv,
        str_: *const ::std::os::raw::c_char,
        length: size_t,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_string_utf8(
        env: NapiEnv,
        str_: *const ::std::os::raw::c_char,
        length: size_t,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_string_utf16(
        env: NapiEnv,
        str_: *const char16_t,
        length: size_t,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_symbol(
        env: NapiEnv,
        description: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_function(
        env: NapiEnv,
        utf8name: *const ::std::os::raw::c_char,
        length: size_t,
        cb: napi_callback,
        data: *mut ::std::os::raw::c_void,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_error(
        env: NapiEnv,
        code: napi_value,
        msg: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_type_error(
        env: NapiEnv,
        code: napi_value,
        msg: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_range_error(
        env: NapiEnv,
        code: napi_value,
        msg: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_typeof(env: NapiEnv, value: napi_value, result: *mut NapiValuetype) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_value_double(env: NapiEnv, value: napi_value, result: *mut f64) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_value_int32(env: NapiEnv, value: napi_value, result: *mut i32) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_value_uint32(env: NapiEnv, value: napi_value, result: *mut u32) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_value_int64(env: NapiEnv, value: napi_value, result: *mut i64) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_value_bool(env: NapiEnv, value: napi_value, result: *mut bool) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_value_string_latin1(
        env: NapiEnv,
        value: napi_value,
        buf: *mut ::std::os::raw::c_char,
        bufsize: size_t,
        result: *mut size_t,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_value_string_utf8(
        env: NapiEnv,
        value: napi_value,
        buf: *mut ::std::os::raw::c_char,
        bufsize: size_t,
        result: *mut size_t,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_value_string_utf16(
        env: NapiEnv,
        value: napi_value,
        buf: *mut char16_t,
        bufsize: size_t,
        result: *mut size_t,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_coerce_to_bool(
        env: NapiEnv,
        value: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_coerce_to_number(
        env: NapiEnv,
        value: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_coerce_to_object(
        env: NapiEnv,
        value: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_coerce_to_string(
        env: NapiEnv,
        value: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_prototype(
        env: NapiEnv,
        object: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_property_names(
        env: NapiEnv,
        object: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_set_property(
        env: NapiEnv,
        object: napi_value,
        key: napi_value,
        value: napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_has_property(
        env: NapiEnv,
        object: napi_value,
        key: napi_value,
        result: *mut bool,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_property(
        env: NapiEnv,
        object: napi_value,
        key: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_delete_property(
        env: NapiEnv,
        object: napi_value,
        key: napi_value,
        result: *mut bool,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_has_own_property(
        env: NapiEnv,
        object: napi_value,
        key: napi_value,
        result: *mut bool,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_set_named_property(
        env: NapiEnv,
        object: napi_value,
        utf8name: *const ::std::os::raw::c_char,
        value: napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_has_named_property(
        env: NapiEnv,
        object: napi_value,
        utf8name: *const ::std::os::raw::c_char,
        result: *mut bool,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_named_property(
        env: NapiEnv,
        object: napi_value,
        utf8name: *const ::std::os::raw::c_char,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_set_element(
        env: NapiEnv,
        object: napi_value,
        index: u32,
        value: napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_has_element(
        env: NapiEnv,
        object: napi_value,
        index: u32,
        result: *mut bool,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_element(
        env: NapiEnv,
        object: napi_value,
        index: u32,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_delete_element(
        env: NapiEnv,
        object: napi_value,
        index: u32,
        result: *mut bool,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_define_properties(
        env: NapiEnv,
        object: napi_value,
        property_count: size_t,
        properties: *const napi_property_descriptor,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_is_array(env: NapiEnv, value: napi_value, result: *mut bool) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_array_length(env: NapiEnv, value: napi_value, result: *mut u32) -> NapiStatus;
}
extern "C" {
    pub fn napi_strict_equals(
        env: NapiEnv,
        lhs: napi_value,
        rhs: napi_value,
        result: *mut bool,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_call_function(
        env: NapiEnv,
        recv: napi_value,
        func: napi_value,
        argc: size_t,
        argv: *const napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_new_instance(
        env: NapiEnv,
        constructor: napi_value,
        argc: size_t,
        argv: *const napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_instanceof(
        env: NapiEnv,
        object: napi_value,
        constructor: napi_value,
        result: *mut bool,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_cb_info(
        env: NapiEnv,
        cbinfo: napi_callback_info,
        argc: *mut size_t,
        argv: *mut napi_value,
        this_arg: *mut napi_value,
        data: *mut *mut ::std::os::raw::c_void,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_new_target(
        env: NapiEnv,
        cbinfo: napi_callback_info,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_define_class(
        env: NapiEnv,
        utf8name: *const ::std::os::raw::c_char,
        length: size_t,
        constructor: napi_callback,
        data: *mut ::std::os::raw::c_void,
        property_count: size_t,
        properties: *const napi_property_descriptor,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_wrap(
        env: NapiEnv,
        js_object: napi_value,
        native_object: *mut ::std::os::raw::c_void,
        finalize_cb: napi_finalize,
        finalize_hint: *mut ::std::os::raw::c_void,
        result: *mut napi_ref,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_unwrap(
        env: NapiEnv,
        js_object: napi_value,
        result: *mut *mut ::std::os::raw::c_void,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_remove_wrap(
        env: NapiEnv,
        js_object: napi_value,
        result: *mut *mut ::std::os::raw::c_void,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_external(
        env: NapiEnv,
        data: *mut ::std::os::raw::c_void,
        finalize_cb: napi_finalize,
        finalize_hint: *mut ::std::os::raw::c_void,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_value_external(
        env: NapiEnv,
        value: napi_value,
        result: *mut *mut ::std::os::raw::c_void,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_reference(
        env: NapiEnv,
        value: napi_value,
        initial_refcount: u32,
        result: *mut napi_ref,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_delete_reference(env: NapiEnv, ref_: napi_ref) -> NapiStatus;
}
extern "C" {
    pub fn napi_reference_ref(env: NapiEnv, ref_: napi_ref, result: *mut u32) -> NapiStatus;
}
extern "C" {
    pub fn napi_reference_unref(env: NapiEnv, ref_: napi_ref, result: *mut u32) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_reference_value(
        env: NapiEnv,
        ref_: napi_ref,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_open_handle_scope(env: NapiEnv, result: *mut napi_handle_scope) -> NapiStatus;
}
extern "C" {
    pub fn napi_close_handle_scope(env: NapiEnv, scope: napi_handle_scope) -> NapiStatus;
}
extern "C" {
    pub fn napi_open_escapable_handle_scope(
        env: NapiEnv,
        result: *mut napi_escapable_handle_scope,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_close_escapable_handle_scope(
        env: NapiEnv,
        scope: napi_escapable_handle_scope,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_escape_handle(
        env: NapiEnv,
        scope: napi_escapable_handle_scope,
        escapee: napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_throw(env: NapiEnv, error: napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_throw_error(
        env: NapiEnv,
        code: *const ::std::os::raw::c_char,
        msg: *const ::std::os::raw::c_char,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_throw_type_error(
        env: NapiEnv,
        code: *const ::std::os::raw::c_char,
        msg: *const ::std::os::raw::c_char,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_throw_range_error(
        env: NapiEnv,
        code: *const ::std::os::raw::c_char,
        msg: *const ::std::os::raw::c_char,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_is_error(env: NapiEnv, value: napi_value, result: *mut bool) -> NapiStatus;
}
extern "C" {
    pub fn napi_is_exception_pending(env: NapiEnv, result: *mut bool) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_and_clear_last_exception(env: NapiEnv, result: *mut napi_value) -> NapiStatus;
}
extern "C" {
    pub fn napi_is_arraybuffer(env: NapiEnv, value: napi_value, result: *mut bool) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_arraybuffer(
        env: NapiEnv,
        byte_length: size_t,
        data: *mut *mut ::std::os::raw::c_void,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_external_arraybuffer(
        env: NapiEnv,
        external_data: *mut ::std::os::raw::c_void,
        byte_length: size_t,
        finalize_cb: napi_finalize,
        finalize_hint: *mut ::std::os::raw::c_void,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_arraybuffer_info(
        env: NapiEnv,
        arraybuffer: napi_value,
        data: *mut *mut ::std::os::raw::c_void,
        byte_length: *mut size_t,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_is_typedarray(env: NapiEnv, value: napi_value, result: *mut bool) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_typedarray(
        env: NapiEnv,
        type_: NapiTypedarrayType,
        length: size_t,
        arraybuffer: napi_value,
        byte_offset: size_t,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_typedarray_info(
        env: NapiEnv,
        typedarray: napi_value,
        type_: *mut NapiTypedarrayType,
        length: *mut size_t,
        data: *mut *mut ::std::os::raw::c_void,
        arraybuffer: *mut napi_value,
        byte_offset: *mut size_t,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_dataview(
        env: NapiEnv,
        length: size_t,
        arraybuffer: napi_value,
        byte_offset: size_t,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_is_dataview(env: NapiEnv, value: napi_value, result: *mut bool) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_dataview_info(
        env: NapiEnv,
        dataview: napi_value,
        bytelength: *mut size_t,
        data: *mut *mut ::std::os::raw::c_void,
        arraybuffer: *mut napi_value,
        byte_offset: *mut size_t,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_version(env: NapiEnv, result: *mut u32) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_promise(
        env: NapiEnv,
        deferred: *mut napi_deferred,
        promise: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_resolve_deferred(
        env: NapiEnv,
        deferred: napi_deferred,
        resolution: napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_reject_deferred(
        env: NapiEnv,
        deferred: napi_deferred,
        rejection: napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_is_promise(env: NapiEnv, value: napi_value, is_promise: *mut bool) -> NapiStatus;
}
extern "C" {
    pub fn napi_run_script(env: NapiEnv, script: napi_value, result: *mut napi_value)
        -> NapiStatus;
}
extern "C" {
    pub fn napi_adjust_external_memory(
        env: NapiEnv,
        change_in_bytes: i64,
        adjusted_value: *mut i64,
    ) -> NapiStatus;
}

#[cfg(feature = "v5")]
extern "C" {
    pub fn napi_create_date(env: NapiEnv, time: f64, result: *mut napi_value) -> NapiStatus;
}
#[cfg(feature = "v5")]
extern "C" {
    pub fn napi_is_date(env: NapiEnv, value: napi_value, is_date: *mut bool) -> NapiStatus;
}
#[cfg(feature = "v5")]
extern "C" {
    pub fn napi_get_date_value(env: NapiEnv, value: napi_value, result: *mut f64) -> NapiStatus;
}
#[cfg(feature = "v5")]
extern "C" {
    pub fn napi_add_finalizer(
        env: NapiEnv,
        js_object: napi_value,
        native_object: *mut ::std::os::raw::c_void,
        finalize_cb: napi_finalize,
        finalize_hint: *mut ::std::os::raw::c_void,
        result: *mut napi_ref,
    ) -> NapiStatus;
}

#[cfg(feature = "v6")]
extern "C" {
    pub fn napi_create_bigint_int64(
        env: NapiEnv,
        value: i64,
        result: *mut napi_value,
    ) -> NapiStatus;
}
#[cfg(feature = "v6")]
extern "C" {
    pub fn napi_create_bigint_uint64(
        env: NapiEnv,
        value: u64,
        result: *mut napi_value,
    ) -> NapiStatus;
}
#[cfg(feature = "v6")]
extern "C" {
    pub fn napi_create_bigint_words(
        env: NapiEnv,
        sign_bit: ::std::os::raw::c_int,
        word_count: size_t,
        words: *const u64,
        result: *mut napi_value,
    ) -> NapiStatus;
}
#[cfg(feature = "v6")]
extern "C" {
    pub fn napi_get_value_bigint_int64(
        env: NapiEnv,
        value: napi_value,
        result: *mut i64,
        lossless: *mut bool,
    ) -> NapiStatus;
}
#[cfg(feature = "v6")]
extern "C" {
    pub fn napi_get_value_bigint_uint64(
        env: NapiEnv,
        value: napi_value,
        result: *mut u64,
        lossless: *mut bool,
    ) -> NapiStatus;
}
#[cfg(feature = "v6")]
extern "C" {
    pub fn napi_get_value_bigint_words(
        env: NapiEnv,
        value: napi_value,
        sign_bit: *mut ::std::os::raw::c_int,
        word_count: *mut size_t,
        words: *mut u64,
    ) -> NapiStatus;
}
#[cfg(feature = "v6")]
extern "C" {
    pub fn napi_get_all_property_names(
        env: NapiEnv,
        object: napi_value,
        key_mode: NapiKeyCollectionMode,
        key_filter: NapiKeyFilter,
        key_conversion: NapiKeyConversion,
        result: *mut napi_value,
    ) -> NapiStatus;
}
#[cfg(feature = "v6")]
extern "C" {
    pub fn napi_set_instance_data(
        env: NapiEnv,
        data: *mut ::std::os::raw::c_void,
        finalize_cb: napi_finalize,
        finalize_hint: *mut ::std::os::raw::c_void,
    ) -> NapiStatus;
}
#[cfg(feature = "v6")]
extern "C" {
    pub fn napi_get_instance_data(
        env: NapiEnv,
        data: *mut *mut ::std::os::raw::c_void,
    ) -> NapiStatus;
}

#[cfg(feature = "v7")]
extern "C" {
    pub fn napi_detach_arraybuffer(env: NapiEnv, arraybuffer: napi_value) -> NapiStatus;
}
#[cfg(feature = "v7")]
extern "C" {
    pub fn napi_is_detached_arraybuffer(
        env: NapiEnv,
        value: napi_value,
        result: *mut bool,
    ) -> NapiStatus;
}

#[cfg(feature = "v8")]
extern "C" {
    pub fn napi_type_tag_object(
        env: NapiEnv,
        value: napi_value,
        type_tag: *const NapiTypeTag,
    ) -> NapiStatus;
}
#[cfg(feature = "v8")]
extern "C" {
    pub fn napi_check_object_type_tag(
        env: NapiEnv,
        value: napi_value,
        type_tag: *const NapiTypeTag,
        result: *mut bool,
    ) -> NapiStatus;
}
#[cfg(feature = "v8")]
extern "C" {
    pub fn napi_object_freeze(env: NapiEnv, object: napi_value) -> NapiStatus;
}
#[cfg(feature = "v8")]
extern "C" {
    pub fn napi_object_seal(env: NapiEnv, object: napi_value) -> NapiStatus;
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_callback_scope__ {
    _unused: [u8; 0],
}
pub type napi_callback_scope = *mut napi_callback_scope__;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_async_context__ {
    _unused: [u8; 0],
}
pub type napi_async_context = *mut napi_async_context__;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_async_work__ {
    _unused: [u8; 0],
}
pub type napi_async_work = *mut napi_async_work__;

#[cfg(feature = "v4")]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_threadsafe_function__ {
    _unused: [u8; 0],
}
#[cfg(feature = "v4")]
pub type napi_threadsafe_function = *mut napi_threadsafe_function__;
#[cfg(feature = "v4")]
pub const napi_threadsafe_function_release_mode_napi_tsfn_release:
    napi_threadsafe_function_release_mode = 0;
#[cfg(feature = "v4")]
pub const napi_threadsafe_function_release_mode_napi_tsfn_abort:
    napi_threadsafe_function_release_mode = 1;
#[cfg(feature = "v4")]
pub type napi_threadsafe_function_release_mode = ::std::os::raw::c_uint;
#[cfg(feature = "v4")]
pub const napi_threadsafe_function_call_mode_napi_tsfn_nonblocking:
    napi_threadsafe_function_call_mode = 0;
#[cfg(feature = "v4")]
pub const napi_threadsafe_function_call_mode_napi_tsfn_blocking:
    napi_threadsafe_function_call_mode = 1;
#[cfg(feature = "v4")]
pub type napi_threadsafe_function_call_mode = ::std::os::raw::c_uint;

pub type napi_async_execute_callback =
    ::std::option::Option<unsafe extern "C" fn(env: NapiEnv, data: *mut ::std::os::raw::c_void)>;
pub type napi_async_complete_callback = ::std::option::Option<
    unsafe extern "C" fn(env: NapiEnv, status: NapiStatus, data: *mut ::std::os::raw::c_void),
>;

#[cfg(feature = "v4")]
pub type napi_threadsafe_function_call_js = ::std::option::Option<
    unsafe extern "C" fn(
        env: NapiEnv,
        js_callback: napi_value,
        context: *mut ::std::os::raw::c_void,
        data: *mut ::std::os::raw::c_void,
    ),
>;

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_node_version {
    pub major: u32,
    pub minor: u32,
    pub patch: u32,
    pub release: *const ::std::os::raw::c_char,
}

#[cfg(feature = "v8")]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_async_cleanup_hook_handle__ {
    _unused: [u8; 0],
}
#[cfg(feature = "v8")]
pub type napi_async_cleanup_hook_handle = *mut napi_async_cleanup_hook_handle__;
#[cfg(feature = "v8")]
pub type napi_async_cleanup_hook = ::std::option::Option<
    unsafe extern "C" fn(handle: napi_async_cleanup_hook_handle, data: *mut ::std::os::raw::c_void),
>;

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uv_loop_s {
    _unused: [u8; 0],
}
pub type napi_addon_register_func =
    ::std::option::Option<unsafe extern "C" fn(env: NapiEnv, exports: napi_value) -> napi_value>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct napi_module {
    pub nm_version: ::std::os::raw::c_int,
    pub nm_flags: ::std::os::raw::c_uint,
    pub nm_filename: *const ::std::os::raw::c_char,
    pub nm_register_func: napi_addon_register_func,
    pub nm_modname: *const ::std::os::raw::c_char,
    pub nm_priv: *mut ::std::os::raw::c_void,
    pub reserved: [*mut ::std::os::raw::c_void; 4usize],
}
extern "C" {
    pub fn napi_module_register(mod_: *mut napi_module);
}
extern "C" {
    pub fn napi_fatal_error(
        location: *const ::std::os::raw::c_char,
        location_len: size_t,
        message: *const ::std::os::raw::c_char,
        message_len: size_t,
    );
}
extern "C" {
    pub fn napi_async_init(
        env: NapiEnv,
        async_resource: napi_value,
        async_resource_name: napi_value,
        result: *mut napi_async_context,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_async_destroy(env: NapiEnv, async_context: napi_async_context) -> NapiStatus;
}
extern "C" {
    pub fn napi_make_callback(
        env: NapiEnv,
        async_context: napi_async_context,
        recv: napi_value,
        func: napi_value,
        argc: size_t,
        argv: *const napi_value,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_buffer(
        env: NapiEnv,
        length: size_t,
        data: *mut *mut ::std::os::raw::c_void,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_external_buffer(
        env: NapiEnv,
        length: size_t,
        data: *mut ::std::os::raw::c_void,
        finalize_cb: napi_finalize,
        finalize_hint: *mut ::std::os::raw::c_void,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_buffer_copy(
        env: NapiEnv,
        length: size_t,
        data: *const ::std::os::raw::c_void,
        result_data: *mut *mut ::std::os::raw::c_void,
        result: *mut napi_value,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_is_buffer(env: NapiEnv, value: napi_value, result: *mut bool) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_buffer_info(
        env: NapiEnv,
        value: napi_value,
        data: *mut *mut ::std::os::raw::c_void,
        length: *mut size_t,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_create_async_work(
        env: NapiEnv,
        async_resource: napi_value,
        async_resource_name: napi_value,
        execute: napi_async_execute_callback,
        complete: napi_async_complete_callback,
        data: *mut ::std::os::raw::c_void,
        result: *mut napi_async_work,
    ) -> NapiStatus;
}
extern "C" {
    pub fn napi_delete_async_work(env: NapiEnv, work: napi_async_work) -> NapiStatus;
}
extern "C" {
    pub fn napi_queue_async_work(env: NapiEnv, work: napi_async_work) -> NapiStatus;
}
extern "C" {
    pub fn napi_cancel_async_work(env: NapiEnv, work: napi_async_work) -> NapiStatus;
}
extern "C" {
    pub fn napi_get_node_version(
        env: NapiEnv,
        version: *mut *const napi_node_version,
    ) -> NapiStatus;
}

#[cfg(feature = "v2")]
extern "C" {
    pub fn napi_get_uv_event_loop(env: NapiEnv, loop_: *mut *mut uv_loop_s) -> NapiStatus;
}

#[cfg(feature = "v3")]
extern "C" {
    pub fn napi_fatal_exception(env: NapiEnv, err: napi_value) -> NapiStatus;
}
#[cfg(feature = "v3")]
extern "C" {
    pub fn napi_add_env_cleanup_hook(
        env: NapiEnv,
        fun: ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>,
        arg: *mut ::std::os::raw::c_void,
    ) -> NapiStatus;
}
#[cfg(feature = "v3")]
extern "C" {
    pub fn napi_remove_env_cleanup_hook(
        env: NapiEnv,
        fun: ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>,
        arg: *mut ::std::os::raw::c_void,
    ) -> NapiStatus;
}
#[cfg(feature = "v3")]
extern "C" {
    pub fn napi_open_callback_scope(
        env: NapiEnv,
        resource_object: napi_value,
        context: napi_async_context,
        result: *mut napi_callback_scope,
    ) -> NapiStatus;
}
#[cfg(feature = "v3")]
extern "C" {
    pub fn napi_close_callback_scope(env: NapiEnv, scope: napi_callback_scope) -> NapiStatus;
}

#[cfg(feature = "v4")]
extern "C" {
    pub fn napi_create_threadsafe_function(
        env: NapiEnv,
        func: napi_value,
        async_resource: napi_value,
        async_resource_name: napi_value,
        max_queue_size: size_t,
        initial_thread_count: size_t,
        thread_finalize_data: *mut ::std::os::raw::c_void,
        thread_finalize_cb: napi_finalize,
        context: *mut ::std::os::raw::c_void,
        call_js_cb: napi_threadsafe_function_call_js,
        result: *mut napi_threadsafe_function,
    ) -> NapiStatus;
}
#[cfg(feature = "v4")]
extern "C" {
    pub fn napi_get_threadsafe_function_context(
        func: napi_threadsafe_function,
        result: *mut *mut ::std::os::raw::c_void,
    ) -> NapiStatus;
}
#[cfg(feature = "v4")]
extern "C" {
    pub fn napi_call_threadsafe_function(
        func: napi_threadsafe_function,
        data: *mut ::std::os::raw::c_void,
        is_blocking: NapiThreadsafeFunctionCallMode,
    ) -> NapiStatus;
}
#[cfg(feature = "v4")]
extern "C" {
    pub fn napi_acquire_threadsafe_function(func: napi_threadsafe_function) -> NapiStatus;
}
#[cfg(feature = "v4")]
extern "C" {
    pub fn napi_release_threadsafe_function(
        func: napi_threadsafe_function,
        mode: NapiThreadsafeFunctionReleaseMode,
    ) -> NapiStatus;
}
#[cfg(feature = "v4")]
extern "C" {
    pub fn napi_unref_threadsafe_function(
        env: NapiEnv,
        func: napi_threadsafe_function,
    ) -> NapiStatus;
}
#[cfg(feature = "v4")]
extern "C" {
    pub fn napi_ref_threadsafe_function(env: NapiEnv, func: napi_threadsafe_function)
        -> NapiStatus;
}

#[cfg(feature = "v8")]
extern "C" {
    pub fn napi_add_async_cleanup_hook(
        env: NapiEnv,
        hook: napi_async_cleanup_hook,
        arg: *mut ::std::os::raw::c_void,
        remove_handle: *mut napi_async_cleanup_hook_handle,
    ) -> NapiStatus;
}
#[cfg(feature = "v8")]
extern "C" {
    pub fn napi_remove_async_cleanup_hook(
        remove_handle: napi_async_cleanup_hook_handle,
    ) -> NapiStatus;
}
