// Copyright (C) 2022 Andreas Doerr
//
// SPDX-License-Identifier: Apache-2.0

use crate::{tag, take};

#[test]
fn tag_found() {
    assert_eq!(
        tag("Hello".as_bytes())("Hello, World".as_bytes()).unwrap(),
        (", World".as_bytes(), "Hello".as_bytes())
    );
}

#[test]
fn tag_error() {
    assert_eq!(
        format!(
            "{:?}",
            tag("foobar".as_bytes())("foo".as_bytes()).err().unwrap()
        ),
        "Error(Tag([102, 111, 111]))",
    );

    assert_eq!(
        format!(
            "{:?}",
            tag("foobar".as_bytes())("foo".as_bytes()).err().unwrap()
        ),
        "Error(Tag([102, 111, 111]))",
    );
}

#[test]
fn take_ok() {
    assert_eq!(format!("{:?}", take(1)("1".as_bytes())), "Ok(([], [49]))",);

    assert_eq!(
        format!("{:?}", take(6)("1234567".as_bytes())),
        "Ok(([55], [49, 50, 51, 52, 53, 54]))",
    );
}

#[test]
fn take_needed() {
    // incomplete - 1 more needed
    assert_eq!(
        format!("{:?}", take(2)("1".as_bytes())),
        "Err(Incomplete(Size(1)))",
    );

    // imcomplete - 3 more needed
    assert_eq!(
        format!("{:?}", take(10)("1234567".as_bytes())),
        "Err(Incomplete(Size(3)))",
    );
}
