// Copyright (C) 2022 Andreas Doerr
//
// SPDX-License-Identifier: Apache-2.0

#![deny(clippy::all)]
#![allow(dead_code)]

mod combinator;
mod error;
mod traits;

#[cfg(test)]
#[path = "tests.rs"]
mod tests;

pub use combinator::{tag, take};
pub use error::{Error, Needed, Result, Terminate};
pub use traits::{Compare, Comparision, Index, Length, Take};
