// Copyright (C) 2022 Andreas Doerr
//
// SPDX-License-Identifier: Apache-2.0

use crate::{Compare, Comparision, Error, Index, Length, Result, Take, Terminate};

pub fn tag<T, I>(tag: T) -> impl Fn(I) -> Result<I, I>
where
    T: Length + Clone,
    I: Take + Compare<T>,
{
    move |input: I| {
        if let Comparision::Equal = input.compare(tag.clone()) {
            Ok(input.take_split(tag.length()))
        } else {
            Err(Terminate::Error(Error::Tag(input)))
        }
    }
}

pub fn take<I>(count: usize) -> impl Fn(I) -> Result<I, I>
where
    I: Take + Index,
{
    move |input| match input.index(count) {
        Ok(idx) => Ok(input.take_split(idx)),
        Err(needed) => Err(Terminate::Incomplete(needed)),
    }
}
