use nalgebra as na;

/// Calculate the euclidean distance between two vectors
///
/// # Parameters
/// - a: first vector
/// - b: second vector
///
/// # Return Values
/// - the euclidean distance between a and b
pub fn euclidean_distance(a: &na::DVector<f64>, b: &na::DVector<f64>) -> f64 {
    assert_eq!(
        a.shape(),
        b.shape(),
        "expected shape of a and b to be the same but got {:?} and {:?}",
        a.shape(),
        b.shape()
    );
    a.metric_distance(b)
}

#[cfg(test)]
mod tests {
    use super::*;
    use na::dvector;

    #[test]
    /// test the euclidean distance function returns the correct results
    fn test_euclidean_distance() {
        assert_eq!(
            euclidean_distance(&dvector!(1.0, 2.0, 3.0), &dvector!(1.0, 2.0, 3.0)),
            0.0
        );
        assert_eq!(
            euclidean_distance(&dvector!(1.0, 2.0, 3.0), &dvector!(4.0, 2.0, 7.0)),
            5.0
        );
    }
}
