// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait DeviceWired {
    fn hw_address(&self) -> Result<String, dbus::Error>;
    fn perm_hw_address(&self) -> Result<String, dbus::Error>;
    fn speed(&self) -> Result<u32, dbus::Error>;
    fn s390_subchannels(&self) -> Result<Vec<String>, dbus::Error>;
    fn carrier(&self) -> Result<bool, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> DeviceWired for blocking::Proxy<'a, C> {

    fn hw_address(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Wired", "HwAddress")
    }

    fn perm_hw_address(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Wired", "PermHwAddress")
    }

    fn speed(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Wired", "Speed")
    }

    fn s390_subchannels(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Wired", "S390Subchannels")
    }

    fn carrier(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Wired", "Carrier")
    }
}
