// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait AccessPoint {
    fn flags(&self) -> Result<u32, dbus::Error>;
    fn wpa_flags(&self) -> Result<u32, dbus::Error>;
    fn rsn_flags(&self) -> Result<u32, dbus::Error>;
    fn ssid(&self) -> Result<Vec<u8>, dbus::Error>;
    fn frequency(&self) -> Result<u32, dbus::Error>;
    fn hw_address(&self) -> Result<String, dbus::Error>;
    fn mode(&self) -> Result<u32, dbus::Error>;
    fn max_bitrate(&self) -> Result<u32, dbus::Error>;
    fn strength(&self) -> Result<u8, dbus::Error>;
    fn last_seen(&self) -> Result<i32, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> AccessPoint for blocking::Proxy<'a, C> {

    fn flags(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.AccessPoint", "Flags")
    }

    fn wpa_flags(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.AccessPoint", "WpaFlags")
    }

    fn rsn_flags(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.AccessPoint", "RsnFlags")
    }

    fn ssid(&self) -> Result<Vec<u8>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.AccessPoint", "Ssid")
    }

    fn frequency(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.AccessPoint", "Frequency")
    }

    fn hw_address(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.AccessPoint", "HwAddress")
    }

    fn mode(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.AccessPoint", "Mode")
    }

    fn max_bitrate(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.AccessPoint", "MaxBitrate")
    }

    fn strength(&self) -> Result<u8, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.AccessPoint", "Strength")
    }

    fn last_seen(&self) -> Result<i32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.AccessPoint", "LastSeen")
    }
}
