// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait DeviceModem {
    fn modem_capabilities(&self) -> Result<u32, dbus::Error>;
    fn current_capabilities(&self) -> Result<u32, dbus::Error>;
    fn device_id(&self) -> Result<String, dbus::Error>;
    fn operator_code(&self) -> Result<String, dbus::Error>;
    fn apn(&self) -> Result<String, dbus::Error>;
}

#[derive(Debug)]
pub struct DeviceModemPropertiesChanged {
    pub properties: arg::PropMap,
}

impl arg::AppendAll for DeviceModemPropertiesChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.properties, i);
    }
}

impl arg::ReadAll for DeviceModemPropertiesChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DeviceModemPropertiesChanged {
            properties: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DeviceModemPropertiesChanged {
    const NAME: &'static str = "PropertiesChanged";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.Device.Modem";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> DeviceModem for blocking::Proxy<'a, C> {

    fn modem_capabilities(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Modem", "ModemCapabilities")
    }

    fn current_capabilities(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Modem", "CurrentCapabilities")
    }

    fn device_id(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Modem", "DeviceId")
    }

    fn operator_code(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Modem", "OperatorCode")
    }

    fn apn(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Modem", "Apn")
    }
}
