// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait VPNPlugin {
    fn connect(&self, connection: ::std::collections::HashMap<&str, arg::PropMap>) -> Result<(), dbus::Error>;
    fn connect_interactive(&self, connection: ::std::collections::HashMap<&str, arg::PropMap>, details: arg::PropMap) -> Result<(), dbus::Error>;
    fn need_secrets(&self, settings: ::std::collections::HashMap<&str, arg::PropMap>) -> Result<String, dbus::Error>;
    fn disconnect(&self) -> Result<(), dbus::Error>;
    fn set_config(&self, config: arg::PropMap) -> Result<(), dbus::Error>;
    fn set_ip4_config(&self, config: arg::PropMap) -> Result<(), dbus::Error>;
    fn set_ip6_config(&self, config: arg::PropMap) -> Result<(), dbus::Error>;
    fn set_failure(&self, reason: &str) -> Result<(), dbus::Error>;
    fn new_secrets(&self, connection: ::std::collections::HashMap<&str, arg::PropMap>) -> Result<(), dbus::Error>;
    fn state(&self) -> Result<u32, dbus::Error>;
}

#[derive(Debug)]
pub struct VPNPluginStateChanged {
    pub state: u32,
}

impl arg::AppendAll for VPNPluginStateChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.state, i);
    }
}

impl arg::ReadAll for VPNPluginStateChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(VPNPluginStateChanged {
            state: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for VPNPluginStateChanged {
    const NAME: &'static str = "StateChanged";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.VPN.Plugin";
}

#[derive(Debug)]
pub struct VPNPluginSecretsRequired {
    pub message: String,
    pub secrets: Vec<String>,
}

impl arg::AppendAll for VPNPluginSecretsRequired {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.message, i);
        arg::RefArg::append(&self.secrets, i);
    }
}

impl arg::ReadAll for VPNPluginSecretsRequired {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(VPNPluginSecretsRequired {
            message: i.read()?,
            secrets: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for VPNPluginSecretsRequired {
    const NAME: &'static str = "SecretsRequired";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.VPN.Plugin";
}

#[derive(Debug)]
pub struct VPNPluginConfig {
    pub config: arg::PropMap,
}

impl arg::AppendAll for VPNPluginConfig {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.config, i);
    }
}

impl arg::ReadAll for VPNPluginConfig {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(VPNPluginConfig {
            config: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for VPNPluginConfig {
    const NAME: &'static str = "Config";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.VPN.Plugin";
}

#[derive(Debug)]
pub struct VPNPluginIp4Config {
    pub ip4config: arg::PropMap,
}

impl arg::AppendAll for VPNPluginIp4Config {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.ip4config, i);
    }
}

impl arg::ReadAll for VPNPluginIp4Config {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(VPNPluginIp4Config {
            ip4config: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for VPNPluginIp4Config {
    const NAME: &'static str = "Ip4Config";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.VPN.Plugin";
}

#[derive(Debug)]
pub struct VPNPluginIp6Config {
    pub ip6config: arg::PropMap,
}

impl arg::AppendAll for VPNPluginIp6Config {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.ip6config, i);
    }
}

impl arg::ReadAll for VPNPluginIp6Config {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(VPNPluginIp6Config {
            ip6config: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for VPNPluginIp6Config {
    const NAME: &'static str = "Ip6Config";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.VPN.Plugin";
}

#[derive(Debug)]
pub struct VPNPluginLoginBanner {
    pub banner: String,
}

impl arg::AppendAll for VPNPluginLoginBanner {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.banner, i);
    }
}

impl arg::ReadAll for VPNPluginLoginBanner {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(VPNPluginLoginBanner {
            banner: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for VPNPluginLoginBanner {
    const NAME: &'static str = "LoginBanner";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.VPN.Plugin";
}

#[derive(Debug)]
pub struct VPNPluginFailure {
    pub reason: u32,
}

impl arg::AppendAll for VPNPluginFailure {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.reason, i);
    }
}

impl arg::ReadAll for VPNPluginFailure {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(VPNPluginFailure {
            reason: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for VPNPluginFailure {
    const NAME: &'static str = "Failure";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.VPN.Plugin";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> VPNPlugin for blocking::Proxy<'a, C> {

    fn connect(&self, connection: ::std::collections::HashMap<&str, arg::PropMap>) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.NetworkManager.VPN.Plugin", "Connect", (connection, ))
    }

    fn connect_interactive(&self, connection: ::std::collections::HashMap<&str, arg::PropMap>, details: arg::PropMap) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.NetworkManager.VPN.Plugin", "ConnectInteractive", (connection, details, ))
    }

    fn need_secrets(&self, settings: ::std::collections::HashMap<&str, arg::PropMap>) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.NetworkManager.VPN.Plugin", "NeedSecrets", (settings, ))
            .and_then(|r: (String, )| Ok(r.0, ))
    }

    fn disconnect(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.NetworkManager.VPN.Plugin", "Disconnect", ())
    }

    fn set_config(&self, config: arg::PropMap) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.NetworkManager.VPN.Plugin", "SetConfig", (config, ))
    }

    fn set_ip4_config(&self, config: arg::PropMap) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.NetworkManager.VPN.Plugin", "SetIp4Config", (config, ))
    }

    fn set_ip6_config(&self, config: arg::PropMap) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.NetworkManager.VPN.Plugin", "SetIp6Config", (config, ))
    }

    fn set_failure(&self, reason: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.NetworkManager.VPN.Plugin", "SetFailure", (reason, ))
    }

    fn new_secrets(&self, connection: ::std::collections::HashMap<&str, arg::PropMap>) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.NetworkManager.VPN.Plugin", "NewSecrets", (connection, ))
    }

    fn state(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.VPN.Plugin", "State")
    }
}
