// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait DeviceWiMax {
    fn get_nsp_list(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
    fn nsps(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
    fn hw_address(&self) -> Result<String, dbus::Error>;
    fn center_frequency(&self) -> Result<u32, dbus::Error>;
    fn rssi(&self) -> Result<i32, dbus::Error>;
    fn cinr(&self) -> Result<i32, dbus::Error>;
    fn tx_power(&self) -> Result<i32, dbus::Error>;
    fn bsid(&self) -> Result<String, dbus::Error>;
    fn active_nsp(&self) -> Result<dbus::Path<'static>, dbus::Error>;
}

#[derive(Debug)]
pub struct DeviceWiMaxPropertiesChanged {
    pub properties: arg::PropMap,
}

impl arg::AppendAll for DeviceWiMaxPropertiesChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.properties, i);
    }
}

impl arg::ReadAll for DeviceWiMaxPropertiesChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DeviceWiMaxPropertiesChanged {
            properties: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DeviceWiMaxPropertiesChanged {
    const NAME: &'static str = "PropertiesChanged";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.Device.WiMax";
}

#[derive(Debug)]
pub struct DeviceWiMaxNspAdded {
    pub nsp: dbus::Path<'static>,
}

impl arg::AppendAll for DeviceWiMaxNspAdded {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.nsp, i);
    }
}

impl arg::ReadAll for DeviceWiMaxNspAdded {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DeviceWiMaxNspAdded {
            nsp: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DeviceWiMaxNspAdded {
    const NAME: &'static str = "NspAdded";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.Device.WiMax";
}

#[derive(Debug)]
pub struct DeviceWiMaxNspRemoved {
    pub nsp: dbus::Path<'static>,
}

impl arg::AppendAll for DeviceWiMaxNspRemoved {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.nsp, i);
    }
}

impl arg::ReadAll for DeviceWiMaxNspRemoved {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DeviceWiMaxNspRemoved {
            nsp: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DeviceWiMaxNspRemoved {
    const NAME: &'static str = "NspRemoved";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.Device.WiMax";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> DeviceWiMax for blocking::Proxy<'a, C> {

    fn get_nsp_list(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        self.method_call("org.freedesktop.NetworkManager.Device.WiMax", "GetNspList", ())
            .and_then(|r: (Vec<dbus::Path<'static>>, )| Ok(r.0, ))
    }

    fn nsps(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.WiMax", "Nsps")
    }

    fn hw_address(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.WiMax", "HwAddress")
    }

    fn center_frequency(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.WiMax", "CenterFrequency")
    }

    fn rssi(&self) -> Result<i32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.WiMax", "Rssi")
    }

    fn cinr(&self) -> Result<i32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.WiMax", "Cinr")
    }

    fn tx_power(&self) -> Result<i32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.WiMax", "TxPower")
    }

    fn bsid(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.WiMax", "Bsid")
    }

    fn active_nsp(&self) -> Result<dbus::Path<'static>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.WiMax", "ActiveNsp")
    }
}
