// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait DeviceVxlan {
    fn parent(&self) -> Result<dbus::Path<'static>, dbus::Error>;
    fn hw_address(&self) -> Result<String, dbus::Error>;
    fn id(&self) -> Result<u32, dbus::Error>;
    fn group(&self) -> Result<String, dbus::Error>;
    fn local(&self) -> Result<String, dbus::Error>;
    fn tos(&self) -> Result<u8, dbus::Error>;
    fn ttl(&self) -> Result<u8, dbus::Error>;
    fn learning(&self) -> Result<bool, dbus::Error>;
    fn ageing(&self) -> Result<u32, dbus::Error>;
    fn limit(&self) -> Result<u32, dbus::Error>;
    fn dst_port(&self) -> Result<u16, dbus::Error>;
    fn src_port_min(&self) -> Result<u16, dbus::Error>;
    fn src_port_max(&self) -> Result<u16, dbus::Error>;
    fn proxy(&self) -> Result<bool, dbus::Error>;
    fn rsc(&self) -> Result<bool, dbus::Error>;
    fn l2miss(&self) -> Result<bool, dbus::Error>;
    fn l3miss(&self) -> Result<bool, dbus::Error>;
}

#[derive(Debug)]
pub struct DeviceVxlanPropertiesChanged {
    pub properties: arg::PropMap,
}

impl arg::AppendAll for DeviceVxlanPropertiesChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.properties, i);
    }
}

impl arg::ReadAll for DeviceVxlanPropertiesChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DeviceVxlanPropertiesChanged {
            properties: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DeviceVxlanPropertiesChanged {
    const NAME: &'static str = "PropertiesChanged";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.Device.Vxlan";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> DeviceVxlan for blocking::Proxy<'a, C> {

    fn parent(&self) -> Result<dbus::Path<'static>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "Parent")
    }

    fn hw_address(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "HwAddress")
    }

    fn id(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "Id")
    }

    fn group(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "Group")
    }

    fn local(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "Local")
    }

    fn tos(&self) -> Result<u8, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "Tos")
    }

    fn ttl(&self) -> Result<u8, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "Ttl")
    }

    fn learning(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "Learning")
    }

    fn ageing(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "Ageing")
    }

    fn limit(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "Limit")
    }

    fn dst_port(&self) -> Result<u16, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "DstPort")
    }

    fn src_port_min(&self) -> Result<u16, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "SrcPortMin")
    }

    fn src_port_max(&self) -> Result<u16, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "SrcPortMax")
    }

    fn proxy(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "Proxy")
    }

    fn rsc(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "Rsc")
    }

    fn l2miss(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "L2miss")
    }

    fn l3miss(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Vxlan", "L3miss")
    }
}
