// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait DeviceStatistics {
    fn refresh_rate_ms(&self) -> Result<u32, dbus::Error>;
    fn set_refresh_rate_ms(&self, value: u32) -> Result<(), dbus::Error>;
    fn tx_bytes(&self) -> Result<u64, dbus::Error>;
    fn rx_bytes(&self) -> Result<u64, dbus::Error>;
}

#[derive(Debug)]
pub struct DeviceStatisticsPropertiesChanged {
    pub properties: arg::PropMap,
}

impl arg::AppendAll for DeviceStatisticsPropertiesChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.properties, i);
    }
}

impl arg::ReadAll for DeviceStatisticsPropertiesChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DeviceStatisticsPropertiesChanged {
            properties: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DeviceStatisticsPropertiesChanged {
    const NAME: &'static str = "PropertiesChanged";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.Device.Statistics";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> DeviceStatistics for blocking::Proxy<'a, C> {

    fn refresh_rate_ms(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Statistics", "RefreshRateMs")
    }

    fn tx_bytes(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Statistics", "TxBytes")
    }

    fn rx_bytes(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.Statistics", "RxBytes")
    }

    fn set_refresh_rate_ms(&self, value: u32) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(&self, "org.freedesktop.NetworkManager.Device.Statistics", "RefreshRateMs", value)
    }
}
