// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait DeviceIPTunnel {
    fn mode(&self) -> Result<u32, dbus::Error>;
    fn parent(&self) -> Result<dbus::Path<'static>, dbus::Error>;
    fn local(&self) -> Result<String, dbus::Error>;
    fn remote(&self) -> Result<String, dbus::Error>;
    fn ttl(&self) -> Result<u8, dbus::Error>;
    fn tos(&self) -> Result<u8, dbus::Error>;
    fn path_mtu_discovery(&self) -> Result<bool, dbus::Error>;
    fn input_key(&self) -> Result<String, dbus::Error>;
    fn output_key(&self) -> Result<String, dbus::Error>;
    fn encapsulation_limit(&self) -> Result<u8, dbus::Error>;
    fn flow_label(&self) -> Result<u32, dbus::Error>;
}

#[derive(Debug)]
pub struct DeviceIPTunnelPropertiesChanged {
    pub properties: arg::PropMap,
}

impl arg::AppendAll for DeviceIPTunnelPropertiesChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.properties, i);
    }
}

impl arg::ReadAll for DeviceIPTunnelPropertiesChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DeviceIPTunnelPropertiesChanged {
            properties: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DeviceIPTunnelPropertiesChanged {
    const NAME: &'static str = "PropertiesChanged";
    const INTERFACE: &'static str = "org.freedesktop.NetworkManager.Device.IPTunnel";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> DeviceIPTunnel for blocking::Proxy<'a, C> {

    fn mode(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.IPTunnel", "Mode")
    }

    fn parent(&self) -> Result<dbus::Path<'static>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.IPTunnel", "Parent")
    }

    fn local(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.IPTunnel", "Local")
    }

    fn remote(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.IPTunnel", "Remote")
    }

    fn ttl(&self) -> Result<u8, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.IPTunnel", "Ttl")
    }

    fn tos(&self) -> Result<u8, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.IPTunnel", "Tos")
    }

    fn path_mtu_discovery(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.IPTunnel", "PathMtuDiscovery")
    }

    fn input_key(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.IPTunnel", "InputKey")
    }

    fn output_key(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.IPTunnel", "OutputKey")
    }

    fn encapsulation_limit(&self) -> Result<u8, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.IPTunnel", "EncapsulationLimit")
    }

    fn flow_label(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.NetworkManager.Device.IPTunnel", "FlowLabel")
    }
}
