use std::path::Path;

use insta::assert_snapshot;
use pretty_hex::{config_hex, HexConfig};

use crate::cmd_dump_path::{self, Opts};

#[test]
fn test_nested_dirs() {
    fn run_dump_path<P: AsRef<Path>>(path: P) -> Result<String, anyhow::Error> {
        let mut output: Vec<u8> = vec![];
        let opts = Opts {
            path: path.as_ref().to_path_buf(),
        };
        cmd_dump_path::run(&mut output, opts)?;
        Ok(hex_print(&output))
    }
    assert_snapshot!(
        run_dump_path("test-data/07-nested-dirs.in").unwrap(),
        @r###"
    0000:   0d00 0000 0000 0000 6e69 782d 6172 6368   ........nix-arch
    0010:   6976 652d 3100 0000 0100 0000 0000 0000   ive-1...........
    0020:   2800 0000 0000 0000 0400 0000 0000 0000   (...............
    0030:   7479 7065 0000 0000 0900 0000 0000 0000   type............
    0040:   6469 7265 6374 6f72 7900 0000 0000 0000   directory.......
    0050:   0500 0000 0000 0000 656e 7472 7900 0000   ........entry...
    0060:   0100 0000 0000 0000 2800 0000 0000 0000   ........(.......
    0070:   0400 0000 0000 0000 6e61 6d65 0000 0000   ........name....
    0080:   1000 0000 0000 0000 3031 2d61 6e2d 656d   ........01-an-em
    0090:   7074 792d 6669 6c65 0400 0000 0000 0000   pty-file........
    00a0:   6e6f 6465 0000 0000 0100 0000 0000 0000   node............
    00b0:   2800 0000 0000 0000 0400 0000 0000 0000   (...............
    00c0:   7479 7065 0000 0000 0700 0000 0000 0000   type............
    00d0:   7265 6775 6c61 7200 0800 0000 0000 0000   regular.........
    00e0:   636f 6e74 656e 7473 0000 0000 0000 0000   contents........
    00f0:   0100 0000 0000 0000 2900 0000 0000 0000   ........).......
    0100:   0100 0000 0000 0000 2900 0000 0000 0000   ........).......
    0110:   0500 0000 0000 0000 656e 7472 7900 0000   ........entry...
    0120:   0100 0000 0000 0000 2800 0000 0000 0000   ........(.......
    0130:   0400 0000 0000 0000 6e61 6d65 0000 0000   ........name....
    0140:   0b00 0000 0000 0000 3032 2d73 6f6d 652d   ........02-some-
    0150:   6469 7200 0000 0000 0400 0000 0000 0000   dir.............
    0160:   6e6f 6465 0000 0000 0100 0000 0000 0000   node............
    0170:   2800 0000 0000 0000 0400 0000 0000 0000   (...............
    0180:   7479 7065 0000 0000 0900 0000 0000 0000   type............
    0190:   6469 7265 6374 6f72 7900 0000 0000 0000   directory.......
    01a0:   0500 0000 0000 0000 656e 7472 7900 0000   ........entry...
    01b0:   0100 0000 0000 0000 2800 0000 0000 0000   ........(.......
    01c0:   0400 0000 0000 0000 6e61 6d65 0000 0000   ........name....
    01d0:   1500 0000 0000 0000 6c69 6e6b 2d74 6f2d   ........link-to-
    01e0:   616e 2d65 6d70 7479 2d66 696c 6500 0000   an-empty-file...
    01f0:   0400 0000 0000 0000 6e6f 6465 0000 0000   ........node....
    0200:   0100 0000 0000 0000 2800 0000 0000 0000   ........(.......
    0210:   0400 0000 0000 0000 7479 7065 0000 0000   ........type....
    0220:   0700 0000 0000 0000 7379 6d6c 696e 6b00   ........symlink.
    0230:   0600 0000 0000 0000 7461 7267 6574 0000   ........target..
    0240:   1300 0000 0000 0000 2e2e 2f30 312d 616e   ........../01-an
    0250:   2d65 6d70 7479 2d66 696c 6500 0000 0000   -empty-file.....
    0260:   0100 0000 0000 0000 2900 0000 0000 0000   ........).......
    0270:   0100 0000 0000 0000 2900 0000 0000 0000   ........).......
    0280:   0500 0000 0000 0000 656e 7472 7900 0000   ........entry...
    0290:   0100 0000 0000 0000 2800 0000 0000 0000   ........(.......
    02a0:   0400 0000 0000 0000 6e61 6d65 0000 0000   ........name....
    02b0:   0a00 0000 0000 0000 6d6f 7265 2d64 6570   ........more-dep
    02c0:   7468 0000 0000 0000 0400 0000 0000 0000   th..............
    02d0:   6e6f 6465 0000 0000 0100 0000 0000 0000   node............
    02e0:   2800 0000 0000 0000 0400 0000 0000 0000   (...............
    02f0:   7479 7065 0000 0000 0900 0000 0000 0000   type............
    0300:   6469 7265 6374 6f72 7900 0000 0000 0000   directory.......
    0310:   0500 0000 0000 0000 656e 7472 7900 0000   ........entry...
    0320:   0100 0000 0000 0000 2800 0000 0000 0000   ........(.......
    0330:   0400 0000 0000 0000 6e61 6d65 0000 0000   ........name....
    0340:   0f00 0000 0000 0000 6465 6570 2d65 6d70   ........deep-emp
    0350:   7479 2d66 696c 6500 0400 0000 0000 0000   ty-file.........
    0360:   6e6f 6465 0000 0000 0100 0000 0000 0000   node............
    0370:   2800 0000 0000 0000 0400 0000 0000 0000   (...............
    0380:   7479 7065 0000 0000 0700 0000 0000 0000   type............
    0390:   7265 6775 6c61 7200 0800 0000 0000 0000   regular.........
    03a0:   636f 6e74 656e 7473 0000 0000 0000 0000   contents........
    03b0:   0100 0000 0000 0000 2900 0000 0000 0000   ........).......
    03c0:   0100 0000 0000 0000 2900 0000 0000 0000   ........).......
    03d0:   0100 0000 0000 0000 2900 0000 0000 0000   ........).......
    03e0:   0100 0000 0000 0000 2900 0000 0000 0000   ........).......
    03f0:   0500 0000 0000 0000 656e 7472 7900 0000   ........entry...
    0400:   0100 0000 0000 0000 2800 0000 0000 0000   ........(.......
    0410:   0400 0000 0000 0000 6e61 6d65 0000 0000   ........name....
    0420:   0a00 0000 0000 0000 736d 616c 6c2d 6669   ........small-fi
    0430:   6c65 0000 0000 0000 0400 0000 0000 0000   le..............
    0440:   6e6f 6465 0000 0000 0100 0000 0000 0000   node............
    0450:   2800 0000 0000 0000 0400 0000 0000 0000   (...............
    0460:   7479 7065 0000 0000 0700 0000 0000 0000   type............
    0470:   7265 6775 6c61 7200 0800 0000 0000 0000   regular.........
    0480:   636f 6e74 656e 7473 1500 0000 0000 0000   contents........
    0490:   5468 6973 2069 7320 6120 7465 7374 2066   This is a test f
    04a0:   696c 652e 0a00 0000 0100 0000 0000 0000   ile.............
    04b0:   2900 0000 0000 0000 0100 0000 0000 0000   )...............
    04c0:   2900 0000 0000 0000 0100 0000 0000 0000   )...............
    04d0:   2900 0000 0000 0000 0100 0000 0000 0000   )...............
    04e0:   2900 0000 0000 0000 0500 0000 0000 0000   )...............
    04f0:   656e 7472 7900 0000 0100 0000 0000 0000   entry...........
    0500:   2800 0000 0000 0000 0400 0000 0000 0000   (...............
    0510:   6e61 6d65 0000 0000 1200 0000 0000 0000   name............
    0520:   3033 2d65 7865 6375 7461 626c 652d 6669   03-executable-fi
    0530:   6c65 0000 0000 0000 0400 0000 0000 0000   le..............
    0540:   6e6f 6465 0000 0000 0100 0000 0000 0000   node............
    0550:   2800 0000 0000 0000 0400 0000 0000 0000   (...............
    0560:   7479 7065 0000 0000 0700 0000 0000 0000   type............
    0570:   7265 6775 6c61 7200 0a00 0000 0000 0000   regular.........
    0580:   6578 6563 7574 6162 6c65 0000 0000 0000   executable......
    0590:   0000 0000 0000 0000 0800 0000 0000 0000   ................
    05a0:   636f 6e74 656e 7473 0000 0000 0000 0000   contents........
    05b0:   0100 0000 0000 0000 2900 0000 0000 0000   ........).......
    05c0:   0100 0000 0000 0000 2900 0000 0000 0000   ........).......
    05d0:   0100 0000 0000 0000 2900 0000 0000 0000   ........).......
    "###
    );
}

fn hex_print(buf: &[u8]) -> String {
    let cfg = HexConfig {
        title: false,
        width: 16,
        group: 0,
        chunk: 2,
        ..HexConfig::default()
    };
    config_hex(&buf.to_vec(), cfg)
}
