// Copyright (C) 2021 Robin Krahl <robin.krahl@ireas.org>
// SPDX-License-Identifier: Apache-2.0 or MIT

//! Lists all connected Nitrokey 3 devices and their firmware version.

fn main() -> Result<(), nitrokey3::Error> {
    let devices = nitrokey3::list()?;
    println!("Found {} Nitrokey 3 devices", devices.len());
    for device in &devices {
        let device = devices.connect(device)?;
        println!(
            "- Nitrokey 3 with firmware version {}",
            device.firmware_version()?
        );
    }
    Ok(())
}
