#[allow(dead_code)]
pub mod sample_crowdsale {
  # [rustfmt :: skip] use ethcontract as ethcontract ;
  #[doc = "Generated by `ethcontract`"]
  #[derive(Clone)]
  pub struct Contract {
    methods: Methods,
  }
  impl Contract {
    #[doc = r" Retrieves the raw contract instance used to generate the type safe"]
    #[doc = r" API for this contract."]
    pub fn raw_contract() -> &'static self::ethcontract::Contract {
      use self::ethcontract::common::artifact::truffle::TruffleLoader;
      use self::ethcontract::private::lazy_static;
      use self::ethcontract::Contract;
      lazy_static! {
        pub static ref CONTRACT: Contract = {
          # [allow (unused_mut)] let mut contract = TruffleLoader :: new () . load_contract_from_str ("{\"contractName\":\"SampleCrowdsale\",\"abi\":[{\"type\":\"constructor\",\"inputs\":[{\"name\":\"openingTime\",\"type\":\"uint256\"},{\"name\":\"closingTime\",\"type\":\"uint256\"},{\"name\":\"rate\",\"type\":\"uint256\"},{\"name\":\"wallet\",\"type\":\"address\"},{\"name\":\"cap\",\"type\":\"uint256\"},{\"name\":\"token\",\"type\":\"address\"},{\"name\":\"goal\",\"type\":\"uint256\"}]},{\"type\":\"function\",\"name\":\"wallet\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"capReached\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"rate\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"closingTime\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"goal\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"isOpen\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"claimRefund\",\"inputs\":[{\"name\":\"refundee\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"finalize\",\"inputs\":[],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"hasClosed\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"cap\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"token\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"finalized\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"buyTokens\",\"inputs\":[{\"name\":\"beneficiary\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"weiRaised\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"goalReached\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"openingTime\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"event\",\"name\":\"CrowdsaleFinalized\",\"inputs\":[],\"anonymous\":false},{\"type\":\"event\",\"name\":\"TimedCrowdsaleExtended\",\"inputs\":[{\"name\":\"prevClosingTime\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"newClosingTime\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"TokensPurchased\",\"inputs\":[{\"name\":\"purchaser\",\"type\":\"address\",\"indexed\":true},{\"name\":\"beneficiary\",\"type\":\"address\",\"indexed\":true},{\"name\":\"value\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"amount\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"fallback\"}],\"bytecode\":\"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\",\"networks\":{},\"devdoc\":{\"details\":null,\"methods\":{}},\"userdoc\":{\"details\":null,\"methods\":{}}}") . expect ("valid contract JSON") ;
          contract
        };
      }
      &CONTRACT
    }
    #[doc = r" Creates a new contract instance with the specified `web3`"]
    #[doc = r" provider at the given `Address`."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching"]
    #[doc = r" `Abi` is actually deployed at the given address."]
    pub fn at<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      Contract::with_deployment_info(web3, address, None)
    }
    #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
    #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
    #[doc = r" This hash is used to retrieve contract related information such as the"]
    #[doc = r" creation block (which is useful for fetching all historic events)."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
    #[doc = r" actually deployed at the given address nor that the transaction hash,"]
    #[doc = r" when provided, is actually for this contract deployment."]
    pub fn with_deployment_info<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
      deployment_information: Option<ethcontract::common::DeploymentInformation>,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::transport::DynTransport;
      use self::ethcontract::web3::api::Web3;
      use self::ethcontract::Instance;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let abi = Self::raw_contract().abi.clone();
      let instance = Instance::with_deployment_info(web3, abi, address, deployment_information);
      Contract::from_raw(instance)
    }
    #[doc = r" Creates a contract from a raw instance."]
    fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
      let methods = Methods { instance };
      Contract { methods }
    }
    #[doc = r" Returns the contract address being used by this instance."]
    pub fn address(&self) -> self::ethcontract::Address {
      self.raw_instance().address()
    }
    #[doc = r" Returns the deployment information of the contract"]
    #[doc = r" if it is known, `None` otherwise."]
    pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
      self.raw_instance().deployment_information()
    }
    #[doc = r" Returns a reference to the default method options used by this"]
    #[doc = r" contract."]
    pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
      &self.raw_instance().defaults
    }
    #[doc = r" Returns a mutable reference to the default method options used"]
    #[doc = r" by this contract."]
    pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
      &mut self.raw_instance_mut().defaults
    }
    #[doc = r" Returns a reference to the raw runtime instance used by this"]
    #[doc = r" contract."]
    pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
      &self.methods.instance
    }
    #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
    #[doc = r" this contract."]
    fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
      &mut self.methods.instance
    }
  }
  impl std::fmt::Debug for Contract {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
      f.debug_tuple(stringify!(SampleCrowdsale))
        .field(&self.address())
        .finish()
    }
  }
  impl Contract {
    #[doc = "Generated by `ethcontract`"]
    #[allow(clippy::too_many_arguments)]
    pub fn builder<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      opening_time: self::ethcontract::U256,
      closing_time: self::ethcontract::U256,
      rate: self::ethcontract::U256,
      wallet: self::ethcontract::Address,
      cap: self::ethcontract::U256,
      token: self::ethcontract::Address,
      goal: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynDeployBuilder<Self>
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::contract::DeployBuilder;
      use self::ethcontract::dyns::DynTransport;
      use self::ethcontract::web3::api::Web3;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let bytecode = Self::raw_contract().bytecode.clone();
      DeployBuilder::new(
        web3,
        bytecode,
        (opening_time, closing_time, rate, wallet, cap, token, goal),
      )
      .expect("valid deployment args")
    }
  }
  impl self::ethcontract::contract::Deploy<self::ethcontract::dyns::DynTransport> for Contract {
    type Context = self::ethcontract::common::Bytecode;
    fn bytecode(cx: &Self::Context) -> &self::ethcontract::common::Bytecode {
      cx
    }
    fn abi(_: &Self::Context) -> &self::ethcontract::common::Abi {
      &Self::raw_contract().abi
    }
    fn from_deployment(
      web3: self::ethcontract::dyns::DynWeb3,
      address: self::ethcontract::Address,
      transaction_hash: self::ethcontract::H256,
      _: Self::Context,
    ) -> Self {
      Self::with_deployment_info(&web3, address, Some(transaction_hash.into()))
    }
  }
  impl Contract {
    #[doc = r" Returns an object that allows accessing typed method signatures."]
    pub fn signatures() -> Signatures {
      Signatures
    }
    #[doc = r" Retrieves a reference to type containing all the generated"]
    #[doc = r" contract methods. This can be used for methods where the name"]
    #[doc = r" would collide with a common method (like `at` or `deployed`)."]
    pub fn methods(&self) -> &Methods {
      &self.methods
    }
  }
  #[doc = r" Type containing signatures for all methods for generated contract type."]
  #[derive(Clone, Copy)]
  pub struct Signatures;
  impl Signatures {
    #[doc = "Returns signature for method `wallet():(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn wallet(&self) -> self::ethcontract::contract::Signature<(), self::ethcontract::Address> {
      self::ethcontract::contract::Signature::new([82, 30, 178, 115])
    }
    #[doc = "Returns signature for method `capReached():(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn cap_reached(&self) -> self::ethcontract::contract::Signature<(), bool> {
      self::ethcontract::contract::Signature::new([79, 147, 89, 69])
    }
    #[doc = "Returns signature for method `rate():(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn rate(&self) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
      self::ethcontract::contract::Signature::new([44, 78, 114, 46])
    }
    #[doc = "Returns signature for method `closingTime():(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn closing_time(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
      self::ethcontract::contract::Signature::new([75, 103, 83, 188])
    }
    #[doc = "Returns signature for method `goal():(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn goal(&self) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
      self::ethcontract::contract::Signature::new([64, 25, 56, 131])
    }
    #[doc = "Returns signature for method `isOpen():(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn is_open(&self) -> self::ethcontract::contract::Signature<(), bool> {
      self::ethcontract::contract::Signature::new([71, 83, 93, 123])
    }
    #[doc = "Returns signature for method `claimRefund(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn claim_refund(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
      self::ethcontract::contract::Signature::new([191, 250, 85, 213])
    }
    #[doc = "Returns signature for method `finalize()`."]
    #[allow(clippy::type_complexity)]
    pub fn finalize(&self) -> self::ethcontract::contract::Signature<(), ()> {
      self::ethcontract::contract::Signature::new([75, 178, 120, 243])
    }
    #[doc = "Returns signature for method `hasClosed():(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn has_closed(&self) -> self::ethcontract::contract::Signature<(), bool> {
      self::ethcontract::contract::Signature::new([21, 21, 188, 43])
    }
    #[doc = "Returns signature for method `cap():(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn cap(&self) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
      self::ethcontract::contract::Signature::new([53, 82, 116, 234])
    }
    #[doc = "Returns signature for method `token():(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn token(&self) -> self::ethcontract::contract::Signature<(), self::ethcontract::Address> {
      self::ethcontract::contract::Signature::new([252, 12, 84, 106])
    }
    #[doc = "Returns signature for method `finalized():(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn finalized(&self) -> self::ethcontract::contract::Signature<(), bool> {
      self::ethcontract::contract::Signature::new([179, 240, 91, 151])
    }
    #[doc = "Returns signature for method `buyTokens(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn buy_tokens(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
      self::ethcontract::contract::Signature::new([236, 138, 196, 216])
    }
    #[doc = "Returns signature for method `weiRaised():(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn wei_raised(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
      self::ethcontract::contract::Signature::new([64, 66, 182, 111])
    }
    #[doc = "Returns signature for method `goalReached():(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn goal_reached(&self) -> self::ethcontract::contract::Signature<(), bool> {
      self::ethcontract::contract::Signature::new([125, 61, 101, 34])
    }
    #[doc = "Returns signature for method `openingTime():(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn opening_time(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
      self::ethcontract::contract::Signature::new([183, 168, 128, 124])
    }
  }
  #[doc = r" Type containing all contract methods for generated contract type."]
  #[derive(Clone)]
  pub struct Methods {
    instance: self::ethcontract::dyns::DynInstance,
  }
  #[allow(clippy::too_many_arguments, clippy::type_complexity)]
  impl Methods {
    #[doc = "Generated by `ethcontract`"]
    pub fn wallet(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
      self
        .instance
        .view_method([82, 30, 178, 115], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn cap_reached(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([79, 147, 89, 69], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn rate(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([44, 78, 114, 46], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn closing_time(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([75, 103, 83, 188], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn goal(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([64, 25, 56, 131], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn is_open(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([71, 83, 93, 123], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn claim_refund(
      &self,
      refundee: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([191, 250, 85, 213], (refundee,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn finalize(&self) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([75, 178, 120, 243], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn has_closed(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([21, 21, 188, 43], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn cap(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([53, 82, 116, 234], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn token(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
      self
        .instance
        .view_method([252, 12, 84, 106], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn finalized(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([179, 240, 91, 151], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn buy_tokens(
      &self,
      beneficiary: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([236, 138, 196, 216], (beneficiary,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn wei_raised(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([64, 66, 182, 111], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn goal_reached(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([125, 61, 101, 34], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn opening_time(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([183, 168, 128, 124], ())
        .expect("generated call")
    }
  }
  impl std::ops::Deref for Contract {
    type Target = Methods;
    fn deref(&self) -> &Self::Target {
      &self.methods
    }
  }
  impl Contract {
    #[doc = r" Returns a method builder to setup a call to a smart"]
    #[doc = r" contract's fallback function."]
    pub fn fallback<D>(&self, data: D) -> self::ethcontract::dyns::DynMethodBuilder<()>
    where
      D: Into<Vec<u8>>,
    {
      self
        .raw_instance()
        .fallback(data)
        .expect("generated fallback method")
    }
  }
  #[doc = r" Module containing all generated data models for this contract's"]
  #[doc = r" events."]
  pub mod event_data {
    use super::ethcontract;
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct CrowdsaleFinalized();
    impl CrowdsaleFinalized {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          146, 112, 204, 57, 12, 9, 102, 0, 161, 193, 124, 68, 52, 90, 27, 166, 137, 250, 253, 153,
          217, 116, 135, 177, 12, 252, 207, 134, 207, 115, 24, 54,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`CrowdsaleFinalized()`"]
      pub fn abi_signature() -> &'static str {
        "CrowdsaleFinalized()"
      }
    }
    impl self::ethcontract::tokens::Tokenize for CrowdsaleFinalized {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let () = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(CrowdsaleFinalized())
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct TimedCrowdsaleExtended {
      pub prev_closing_time: self::ethcontract::U256,
      pub new_closing_time: self::ethcontract::U256,
    }
    impl TimedCrowdsaleExtended {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          70, 113, 30, 34, 47, 85, 138, 7, 175, 210, 110, 94, 113, 180, 142, 203, 10, 139, 44, 220,
          212, 15, 174, 177, 50, 62, 5, 226, 199, 106, 47, 50,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`TimedCrowdsaleExtended(uint256,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "TimedCrowdsaleExtended(uint256,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for TimedCrowdsaleExtended {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (prev_closing_time, new_closing_time) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(TimedCrowdsaleExtended {
          prev_closing_time,
          new_closing_time,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct TokensPurchased {
      pub purchaser: self::ethcontract::Address,
      pub beneficiary: self::ethcontract::Address,
      pub value: self::ethcontract::U256,
      pub amount: self::ethcontract::U256,
    }
    impl TokensPurchased {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          111, 175, 147, 35, 26, 69, 110, 85, 45, 188, 153, 97, 245, 141, 151, 19, 238, 79, 46,
          105, 209, 95, 25, 117, 176, 80, 239, 9, 17, 5, 58, 123,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`TokensPurchased(address,address,uint256,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "TokensPurchased(address,address,uint256,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for TokensPurchased {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (purchaser, beneficiary, value, amount) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(TokensPurchased {
          purchaser,
          beneficiary,
          value,
          amount,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
  }
  impl Contract {
    #[doc = r" Retrieves a handle to a type containing for creating event"]
    #[doc = r" streams for all the contract events."]
    pub fn events(&self) -> Events<'_> {
      Events {
        instance: self.raw_instance(),
      }
    }
  }
  pub struct Events<'a> {
    instance: &'a self::ethcontract::dyns::DynInstance,
  }
  impl Events<'_> {
    #[doc = r" Generated by `ethcontract`."]
    pub fn crowdsale_finalized(&self) -> self::event_builders::CrowdsaleFinalizedBuilder {
      self::event_builders::CrowdsaleFinalizedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            146, 112, 204, 57, 12, 9, 102, 0, 161, 193, 124, 68, 52, 90, 27, 166, 137, 250, 253,
            153, 217, 116, 135, 177, 12, 252, 207, 134, 207, 115, 24, 54,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn timed_crowdsale_extended(&self) -> self::event_builders::TimedCrowdsaleExtendedBuilder {
      self::event_builders::TimedCrowdsaleExtendedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            70, 113, 30, 34, 47, 85, 138, 7, 175, 210, 110, 94, 113, 180, 142, 203, 10, 139, 44,
            220, 212, 15, 174, 177, 50, 62, 5, 226, 199, 106, 47, 50,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn tokens_purchased(&self) -> self::event_builders::TokensPurchasedBuilder {
      self::event_builders::TokensPurchasedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            111, 175, 147, 35, 26, 69, 110, 85, 45, 188, 153, 97, 245, 141, 151, 19, 238, 79, 46,
            105, 209, 95, 25, 117, 176, 80, 239, 9, 17, 5, 58, 123,
          ]))
          .expect("generated event filter"),
      )
    }
  }
  #[doc = r" Module containing the generated event stream builders with type safe"]
  #[doc = r" filter methods for this contract's events."]
  pub mod event_builders {
    use super::ethcontract;
    use super::event_data;
    #[doc = "A builder for creating a filtered stream of `CrowdsaleFinalized` events."]
    pub struct CrowdsaleFinalizedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::CrowdsaleFinalized>,
    );
    impl CrowdsaleFinalizedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::CrowdsaleFinalized>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::CrowdsaleFinalized>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `TimedCrowdsaleExtended` events."]
    pub struct TimedCrowdsaleExtendedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::TimedCrowdsaleExtended>,
    );
    impl TimedCrowdsaleExtendedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::TimedCrowdsaleExtended>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::TimedCrowdsaleExtended>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `TokensPurchased` events."]
    pub struct TokensPurchasedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::TokensPurchased>,
    );
    impl TokensPurchasedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the purchaser event parameter."]
      pub fn purchaser(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the beneficiary event parameter."]
      pub fn beneficiary(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::TokensPurchased>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::TokensPurchased>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
  }
  impl Contract {
    #[doc = r" Returns a log stream with all events."]
    pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
      self::ethcontract::dyns::DynAllEventsBuilder::new(
        self.raw_instance().web3(),
        self.address(),
        self.deployment_information(),
      )
    }
  }
  #[doc = r" A contract event."]
  #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
  pub enum Event {
    CrowdsaleFinalized(self::event_data::CrowdsaleFinalized),
    TimedCrowdsaleExtended(self::event_data::TimedCrowdsaleExtended),
    TokensPurchased(self::event_data::TokensPurchased),
  }
  impl self::ethcontract::contract::ParseLog for Event {
    fn parse_log(
      log: self::ethcontract::RawLog,
    ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
      let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([146 , 112 , 204 , 57 , 12 , 9 , 102 , 0 , 161 , 193 , 124 , 68 , 52 , 90 , 27 , 166 , 137 , 250 , 253 , 153 , 217 , 116 , 135 , 177 , 12 , 252 , 207 , 134 , 207 , 115 , 24 , 54]) => Ok (Event :: CrowdsaleFinalized (log . clone () . decode (Contract :: raw_contract () . abi . event ("CrowdsaleFinalized") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([70 , 113 , 30 , 34 , 47 , 85 , 138 , 7 , 175 , 210 , 110 , 94 , 113 , 180 , 142 , 203 , 10 , 139 , 44 , 220 , 212 , 15 , 174 , 177 , 50 , 62 , 5 , 226 , 199 , 106 , 47 , 50]) => Ok (Event :: TimedCrowdsaleExtended (log . clone () . decode (Contract :: raw_contract () . abi . event ("TimedCrowdsaleExtended") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([111 , 175 , 147 , 35 , 26 , 69 , 110 , 85 , 45 , 188 , 153 , 97 , 245 , 141 , 151 , 19 , 238 , 79 , 46 , 105 , 209 , 95 , 25 , 117 , 176 , 80 , 239 , 9 , 17 , 5 , 58 , 123]) => Ok (Event :: TokensPurchased (log . clone () . decode (Contract :: raw_contract () . abi . event ("TokensPurchased") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
      if let Some(Ok(data)) = standard_event {
        return Ok(data);
      }
      Err(self::ethcontract::errors::ExecutionError::from(
        self::ethcontract::common::abi::Error::InvalidData,
      ))
    }
  }
}
pub use self::sample_crowdsale::Contract as SampleCrowdsale;
