#[allow(dead_code)]
pub mod individually_capped_crowdsale_impl {
  # [rustfmt :: skip] use ethcontract as ethcontract ;
  #[doc = "Generated by `ethcontract`"]
  #[derive(Clone)]
  pub struct Contract {
    methods: Methods,
  }
  impl Contract {
    #[doc = r" Retrieves the raw contract instance used to generate the type safe"]
    #[doc = r" API for this contract."]
    pub fn raw_contract() -> &'static self::ethcontract::Contract {
      use self::ethcontract::common::artifact::truffle::TruffleLoader;
      use self::ethcontract::private::lazy_static;
      use self::ethcontract::Contract;
      lazy_static! {
        pub static ref CONTRACT: Contract = {
          # [allow (unused_mut)] let mut contract = TruffleLoader :: new () . load_contract_from_str ("{\"contractName\":\"IndividuallyCappedCrowdsaleImpl\",\"abi\":[{\"type\":\"constructor\",\"inputs\":[{\"name\":\"rate\",\"type\":\"uint256\"},{\"name\":\"wallet\",\"type\":\"address\"},{\"name\":\"token\",\"type\":\"address\"}]},{\"type\":\"function\",\"name\":\"setCap\",\"inputs\":[{\"name\":\"beneficiary\",\"type\":\"address\"},{\"name\":\"cap\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"onlyCapperMock\",\"inputs\":[],\"outputs\":[],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"addCapper\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"getCap\",\"inputs\":[{\"name\":\"beneficiary\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"token\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"removeCapper\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"rate\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"renounceCapper\",\"inputs\":[],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"weiRaised\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"buyTokens\",\"inputs\":[{\"name\":\"beneficiary\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"wallet\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"isCapper\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"getContribution\",\"inputs\":[{\"name\":\"beneficiary\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"event\",\"name\":\"CapperRemoved\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\",\"indexed\":true}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"TokensPurchased\",\"inputs\":[{\"name\":\"purchaser\",\"type\":\"address\",\"indexed\":true},{\"name\":\"beneficiary\",\"type\":\"address\",\"indexed\":true},{\"name\":\"value\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"amount\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"CapperAdded\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\",\"indexed\":true}],\"anonymous\":false},{\"type\":\"fallback\"}],\"bytecode\":\"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\",\"networks\":{},\"devdoc\":{\"details\":null,\"methods\":{}},\"userdoc\":{\"details\":null,\"methods\":{}}}") . expect ("valid contract JSON") ;
          contract
        };
      }
      &CONTRACT
    }
    #[doc = r" Creates a new contract instance with the specified `web3`"]
    #[doc = r" provider at the given `Address`."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching"]
    #[doc = r" `Abi` is actually deployed at the given address."]
    pub fn at<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      Contract::with_deployment_info(web3, address, None)
    }
    #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
    #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
    #[doc = r" This hash is used to retrieve contract related information such as the"]
    #[doc = r" creation block (which is useful for fetching all historic events)."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
    #[doc = r" actually deployed at the given address nor that the transaction hash,"]
    #[doc = r" when provided, is actually for this contract deployment."]
    pub fn with_deployment_info<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
      deployment_information: Option<ethcontract::common::DeploymentInformation>,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::transport::DynTransport;
      use self::ethcontract::web3::api::Web3;
      use self::ethcontract::Instance;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let abi = Self::raw_contract().abi.clone();
      let instance = Instance::with_deployment_info(web3, abi, address, deployment_information);
      Contract::from_raw(instance)
    }
    #[doc = r" Creates a contract from a raw instance."]
    fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
      let methods = Methods { instance };
      Contract { methods }
    }
    #[doc = r" Returns the contract address being used by this instance."]
    pub fn address(&self) -> self::ethcontract::Address {
      self.raw_instance().address()
    }
    #[doc = r" Returns the deployment information of the contract"]
    #[doc = r" if it is known, `None` otherwise."]
    pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
      self.raw_instance().deployment_information()
    }
    #[doc = r" Returns a reference to the default method options used by this"]
    #[doc = r" contract."]
    pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
      &self.raw_instance().defaults
    }
    #[doc = r" Returns a mutable reference to the default method options used"]
    #[doc = r" by this contract."]
    pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
      &mut self.raw_instance_mut().defaults
    }
    #[doc = r" Returns a reference to the raw runtime instance used by this"]
    #[doc = r" contract."]
    pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
      &self.methods.instance
    }
    #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
    #[doc = r" this contract."]
    fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
      &mut self.methods.instance
    }
  }
  impl std::fmt::Debug for Contract {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
      f.debug_tuple(stringify!(IndividuallyCappedCrowdsaleImpl))
        .field(&self.address())
        .finish()
    }
  }
  impl Contract {
    #[doc = "Generated by `ethcontract`"]
    #[allow(clippy::too_many_arguments)]
    pub fn builder<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      rate: self::ethcontract::U256,
      wallet: self::ethcontract::Address,
      token: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynDeployBuilder<Self>
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::contract::DeployBuilder;
      use self::ethcontract::dyns::DynTransport;
      use self::ethcontract::web3::api::Web3;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let bytecode = Self::raw_contract().bytecode.clone();
      DeployBuilder::new(web3, bytecode, (rate, wallet, token)).expect("valid deployment args")
    }
  }
  impl self::ethcontract::contract::Deploy<self::ethcontract::dyns::DynTransport> for Contract {
    type Context = self::ethcontract::common::Bytecode;
    fn bytecode(cx: &Self::Context) -> &self::ethcontract::common::Bytecode {
      cx
    }
    fn abi(_: &Self::Context) -> &self::ethcontract::common::Abi {
      &Self::raw_contract().abi
    }
    fn from_deployment(
      web3: self::ethcontract::dyns::DynWeb3,
      address: self::ethcontract::Address,
      transaction_hash: self::ethcontract::H256,
      _: Self::Context,
    ) -> Self {
      Self::with_deployment_info(&web3, address, Some(transaction_hash.into()))
    }
  }
  impl Contract {
    #[doc = r" Returns an object that allows accessing typed method signatures."]
    pub fn signatures() -> Signatures {
      Signatures
    }
    #[doc = r" Retrieves a reference to type containing all the generated"]
    #[doc = r" contract methods. This can be used for methods where the name"]
    #[doc = r" would collide with a common method (like `at` or `deployed`)."]
    pub fn methods(&self) -> &Methods {
      &self.methods
    }
  }
  #[doc = r" Type containing signatures for all methods for generated contract type."]
  #[derive(Clone, Copy)]
  pub struct Signatures;
  impl Signatures {
    #[doc = "Returns signature for method `setCap(address,uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn set_cap(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::U256),
      (),
    > {
      self::ethcontract::contract::Signature::new([128, 173, 44, 243])
    }
    #[doc = "Returns signature for method `onlyCapperMock()`."]
    #[allow(clippy::type_complexity)]
    pub fn only_capper_mock(&self) -> self::ethcontract::contract::Signature<(), ()> {
      self::ethcontract::contract::Signature::new([209, 224, 123, 203])
    }
    #[doc = "Returns signature for method `addCapper(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn add_capper(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
      self::ethcontract::contract::Signature::new([141, 251, 207, 54])
    }
    #[doc = "Returns signature for method `getCap(address):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_cap(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address,),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([179, 174, 251, 117])
    }
    #[doc = "Returns signature for method `token():(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn token(&self) -> self::ethcontract::contract::Signature<(), self::ethcontract::Address> {
      self::ethcontract::contract::Signature::new([252, 12, 84, 106])
    }
    #[doc = "Returns signature for method `removeCapper(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn remove_capper(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
      self::ethcontract::contract::Signature::new([63, 74, 100, 132])
    }
    #[doc = "Returns signature for method `rate():(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn rate(&self) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
      self::ethcontract::contract::Signature::new([44, 78, 114, 46])
    }
    #[doc = "Returns signature for method `renounceCapper()`."]
    #[allow(clippy::type_complexity)]
    pub fn renounce_capper(&self) -> self::ethcontract::contract::Signature<(), ()> {
      self::ethcontract::contract::Signature::new([93, 85, 118, 248])
    }
    #[doc = "Returns signature for method `weiRaised():(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn wei_raised(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
      self::ethcontract::contract::Signature::new([64, 66, 182, 111])
    }
    #[doc = "Returns signature for method `buyTokens(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn buy_tokens(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
      self::ethcontract::contract::Signature::new([236, 138, 196, 216])
    }
    #[doc = "Returns signature for method `wallet():(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn wallet(&self) -> self::ethcontract::contract::Signature<(), self::ethcontract::Address> {
      self::ethcontract::contract::Signature::new([82, 30, 178, 115])
    }
    #[doc = "Returns signature for method `isCapper(address):(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn is_capper(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), bool> {
      self::ethcontract::contract::Signature::new([57, 86, 69, 97])
    }
    #[doc = "Returns signature for method `getContribution(address):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_contribution(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address,),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([33, 239, 247, 252])
    }
  }
  #[doc = r" Type containing all contract methods for generated contract type."]
  #[derive(Clone)]
  pub struct Methods {
    instance: self::ethcontract::dyns::DynInstance,
  }
  #[allow(clippy::too_many_arguments, clippy::type_complexity)]
  impl Methods {
    #[doc = "Generated by `ethcontract`"]
    pub fn set_cap(
      &self,
      beneficiary: self::ethcontract::Address,
      cap: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([128, 173, 44, 243], (beneficiary, cap))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn only_capper_mock(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<()> {
      self
        .instance
        .view_method([209, 224, 123, 203], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn add_capper(
      &self,
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([141, 251, 207, 54], (account,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_cap(
      &self,
      beneficiary: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([179, 174, 251, 117], (beneficiary,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn token(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
      self
        .instance
        .view_method([252, 12, 84, 106], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn remove_capper(
      &self,
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([63, 74, 100, 132], (account,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn rate(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([44, 78, 114, 46], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn renounce_capper(&self) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([93, 85, 118, 248], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn wei_raised(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([64, 66, 182, 111], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn buy_tokens(
      &self,
      beneficiary: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([236, 138, 196, 216], (beneficiary,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn wallet(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
      self
        .instance
        .view_method([82, 30, 178, 115], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn is_capper(
      &self,
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([57, 86, 69, 97], (account,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_contribution(
      &self,
      beneficiary: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([33, 239, 247, 252], (beneficiary,))
        .expect("generated call")
    }
  }
  impl std::ops::Deref for Contract {
    type Target = Methods;
    fn deref(&self) -> &Self::Target {
      &self.methods
    }
  }
  impl Contract {
    #[doc = r" Returns a method builder to setup a call to a smart"]
    #[doc = r" contract's fallback function."]
    pub fn fallback<D>(&self, data: D) -> self::ethcontract::dyns::DynMethodBuilder<()>
    where
      D: Into<Vec<u8>>,
    {
      self
        .raw_instance()
        .fallback(data)
        .expect("generated fallback method")
    }
  }
  #[doc = r" Module containing all generated data models for this contract's"]
  #[doc = r" events."]
  pub mod event_data {
    use super::ethcontract;
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct CapperRemoved {
      pub account: self::ethcontract::Address,
    }
    impl CapperRemoved {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          66, 116, 0, 210, 121, 197, 6, 223, 97, 2, 36, 178, 46, 204, 232, 155, 105, 63, 193, 134,
          88, 100, 17, 63, 33, 200, 209, 156, 31, 12, 42, 59,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`CapperRemoved(address)`"]
      pub fn abi_signature() -> &'static str {
        "CapperRemoved(address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for CapperRemoved {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (account,) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(CapperRemoved { account })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct TokensPurchased {
      pub purchaser: self::ethcontract::Address,
      pub beneficiary: self::ethcontract::Address,
      pub value: self::ethcontract::U256,
      pub amount: self::ethcontract::U256,
    }
    impl TokensPurchased {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          111, 175, 147, 35, 26, 69, 110, 85, 45, 188, 153, 97, 245, 141, 151, 19, 238, 79, 46,
          105, 209, 95, 25, 117, 176, 80, 239, 9, 17, 5, 58, 123,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`TokensPurchased(address,address,uint256,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "TokensPurchased(address,address,uint256,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for TokensPurchased {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (purchaser, beneficiary, value, amount) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(TokensPurchased {
          purchaser,
          beneficiary,
          value,
          amount,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct CapperAdded {
      pub account: self::ethcontract::Address,
    }
    impl CapperAdded {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          167, 85, 92, 149, 182, 157, 79, 92, 200, 71, 136, 31, 235, 74, 178, 136, 58, 25, 33, 49,
          158, 52, 250, 32, 67, 116, 123, 121, 61, 101, 179, 110,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`CapperAdded(address)`"]
      pub fn abi_signature() -> &'static str {
        "CapperAdded(address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for CapperAdded {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (account,) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(CapperAdded { account })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
  }
  impl Contract {
    #[doc = r" Retrieves a handle to a type containing for creating event"]
    #[doc = r" streams for all the contract events."]
    pub fn events(&self) -> Events<'_> {
      Events {
        instance: self.raw_instance(),
      }
    }
  }
  pub struct Events<'a> {
    instance: &'a self::ethcontract::dyns::DynInstance,
  }
  impl Events<'_> {
    #[doc = r" Generated by `ethcontract`."]
    pub fn capper_removed(&self) -> self::event_builders::CapperRemovedBuilder {
      self::event_builders::CapperRemovedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            66, 116, 0, 210, 121, 197, 6, 223, 97, 2, 36, 178, 46, 204, 232, 155, 105, 63, 193,
            134, 88, 100, 17, 63, 33, 200, 209, 156, 31, 12, 42, 59,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn tokens_purchased(&self) -> self::event_builders::TokensPurchasedBuilder {
      self::event_builders::TokensPurchasedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            111, 175, 147, 35, 26, 69, 110, 85, 45, 188, 153, 97, 245, 141, 151, 19, 238, 79, 46,
            105, 209, 95, 25, 117, 176, 80, 239, 9, 17, 5, 58, 123,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn capper_added(&self) -> self::event_builders::CapperAddedBuilder {
      self::event_builders::CapperAddedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            167, 85, 92, 149, 182, 157, 79, 92, 200, 71, 136, 31, 235, 74, 178, 136, 58, 25, 33,
            49, 158, 52, 250, 32, 67, 116, 123, 121, 61, 101, 179, 110,
          ]))
          .expect("generated event filter"),
      )
    }
  }
  #[doc = r" Module containing the generated event stream builders with type safe"]
  #[doc = r" filter methods for this contract's events."]
  pub mod event_builders {
    use super::ethcontract;
    use super::event_data;
    #[doc = "A builder for creating a filtered stream of `CapperRemoved` events."]
    pub struct CapperRemovedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::CapperRemoved>,
    );
    impl CapperRemovedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the account event parameter."]
      pub fn account(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::CapperRemoved>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::CapperRemoved>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `TokensPurchased` events."]
    pub struct TokensPurchasedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::TokensPurchased>,
    );
    impl TokensPurchasedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the purchaser event parameter."]
      pub fn purchaser(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the beneficiary event parameter."]
      pub fn beneficiary(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::TokensPurchased>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::TokensPurchased>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `CapperAdded` events."]
    pub struct CapperAddedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::CapperAdded>,
    );
    impl CapperAddedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the account event parameter."]
      pub fn account(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::CapperAdded>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::CapperAdded>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
  }
  impl Contract {
    #[doc = r" Returns a log stream with all events."]
    pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
      self::ethcontract::dyns::DynAllEventsBuilder::new(
        self.raw_instance().web3(),
        self.address(),
        self.deployment_information(),
      )
    }
  }
  #[doc = r" A contract event."]
  #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
  pub enum Event {
    CapperAdded(self::event_data::CapperAdded),
    CapperRemoved(self::event_data::CapperRemoved),
    TokensPurchased(self::event_data::TokensPurchased),
  }
  impl self::ethcontract::contract::ParseLog for Event {
    fn parse_log(
      log: self::ethcontract::RawLog,
    ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
      let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([167 , 85 , 92 , 149 , 182 , 157 , 79 , 92 , 200 , 71 , 136 , 31 , 235 , 74 , 178 , 136 , 58 , 25 , 33 , 49 , 158 , 52 , 250 , 32 , 67 , 116 , 123 , 121 , 61 , 101 , 179 , 110]) => Ok (Event :: CapperAdded (log . clone () . decode (Contract :: raw_contract () . abi . event ("CapperAdded") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([66 , 116 , 0 , 210 , 121 , 197 , 6 , 223 , 97 , 2 , 36 , 178 , 46 , 204 , 232 , 155 , 105 , 63 , 193 , 134 , 88 , 100 , 17 , 63 , 33 , 200 , 209 , 156 , 31 , 12 , 42 , 59]) => Ok (Event :: CapperRemoved (log . clone () . decode (Contract :: raw_contract () . abi . event ("CapperRemoved") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([111 , 175 , 147 , 35 , 26 , 69 , 110 , 85 , 45 , 188 , 153 , 97 , 245 , 141 , 151 , 19 , 238 , 79 , 46 , 105 , 209 , 95 , 25 , 117 , 176 , 80 , 239 , 9 , 17 , 5 , 58 , 123]) => Ok (Event :: TokensPurchased (log . clone () . decode (Contract :: raw_contract () . abi . event ("TokensPurchased") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
      if let Some(Ok(data)) = standard_event {
        return Ok(data);
      }
      Err(self::ethcontract::errors::ExecutionError::from(
        self::ethcontract::common::abi::Error::InvalidData,
      ))
    }
  }
}
pub use self::individually_capped_crowdsale_impl::Contract as IndividuallyCappedCrowdsaleImpl;
