#[allow(dead_code)]
pub mod i_relay_hub {
  # [rustfmt :: skip] use ethcontract as ethcontract ;
  #[doc = "Generated by `ethcontract`"]
  #[derive(Clone)]
  pub struct Contract {
    methods: Methods,
  }
  impl Contract {
    #[doc = r" Retrieves the raw contract instance used to generate the type safe"]
    #[doc = r" API for this contract."]
    pub fn raw_contract() -> &'static self::ethcontract::Contract {
      use self::ethcontract::common::artifact::truffle::TruffleLoader;
      use self::ethcontract::private::lazy_static;
      use self::ethcontract::Contract;
      lazy_static! {
        pub static ref CONTRACT: Contract = {
          # [allow (unused_mut)] let mut contract = TruffleLoader :: new () . load_contract_from_str ("{\"contractName\":\"IRelayHub\",\"abi\":[{\"type\":\"function\",\"name\":\"withdraw\",\"inputs\":[{\"name\":\"amount\",\"type\":\"uint256\"},{\"name\":\"dest\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"getRelay\",\"inputs\":[{\"name\":\"relay\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"totalStake\",\"type\":\"uint256\"},{\"name\":\"unstakeDelay\",\"type\":\"uint256\"},{\"name\":\"unstakeTime\",\"type\":\"uint256\"},{\"name\":\"owner\",\"type\":\"address\"},{\"name\":\"state\",\"type\":\"uint8\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"canRelay\",\"inputs\":[{\"name\":\"relay\",\"type\":\"address\"},{\"name\":\"from\",\"type\":\"address\"},{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"encodedFunction\",\"type\":\"bytes\"},{\"name\":\"transactionFee\",\"type\":\"uint256\"},{\"name\":\"gasPrice\",\"type\":\"uint256\"},{\"name\":\"gasLimit\",\"type\":\"uint256\"},{\"name\":\"nonce\",\"type\":\"uint256\"},{\"name\":\"signature\",\"type\":\"bytes\"},{\"name\":\"approvalData\",\"type\":\"bytes\"}],\"outputs\":[{\"name\":\"status\",\"type\":\"uint256\"},{\"name\":\"recipientContext\",\"type\":\"bytes\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"depositFor\",\"inputs\":[{\"name\":\"target\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"relayCall\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\"},{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"encodedFunction\",\"type\":\"bytes\"},{\"name\":\"transactionFee\",\"type\":\"uint256\"},{\"name\":\"gasPrice\",\"type\":\"uint256\"},{\"name\":\"gasLimit\",\"type\":\"uint256\"},{\"name\":\"nonce\",\"type\":\"uint256\"},{\"name\":\"signature\",\"type\":\"bytes\"},{\"name\":\"approvalData\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"maxPossibleCharge\",\"inputs\":[{\"name\":\"relayedCallStipend\",\"type\":\"uint256\"},{\"name\":\"gasPrice\",\"type\":\"uint256\"},{\"name\":\"transactionFee\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"getNonce\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"registerRelay\",\"inputs\":[{\"name\":\"transactionFee\",\"type\":\"uint256\"},{\"name\":\"url\",\"type\":\"string\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"unstake\",\"inputs\":[{\"name\":\"relay\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"penalizeRepeatedNonce\",\"inputs\":[{\"name\":\"unsignedTx1\",\"type\":\"bytes\"},{\"name\":\"signature1\",\"type\":\"bytes\"},{\"name\":\"unsignedTx2\",\"type\":\"bytes\"},{\"name\":\"signature2\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"requiredGas\",\"inputs\":[{\"name\":\"relayedCallStipend\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"stake\",\"inputs\":[{\"name\":\"relayaddr\",\"type\":\"address\"},{\"name\":\"unstakeDelay\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"penalizeIllegalTransaction\",\"inputs\":[{\"name\":\"unsignedTx\",\"type\":\"bytes\"},{\"name\":\"signature\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"removeRelayByOwner\",\"inputs\":[{\"name\":\"relay\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"balanceOf\",\"inputs\":[{\"name\":\"target\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"event\",\"name\":\"CanRelayFailed\",\"inputs\":[{\"name\":\"relay\",\"type\":\"address\",\"indexed\":true},{\"name\":\"from\",\"type\":\"address\",\"indexed\":true},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true},{\"name\":\"selector\",\"type\":\"bytes4\",\"indexed\":false},{\"name\":\"reason\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"TransactionRelayed\",\"inputs\":[{\"name\":\"relay\",\"type\":\"address\",\"indexed\":true},{\"name\":\"from\",\"type\":\"address\",\"indexed\":true},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true},{\"name\":\"selector\",\"type\":\"bytes4\",\"indexed\":false},{\"name\":\"status\",\"type\":\"uint8\",\"indexed\":false},{\"name\":\"charge\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"RelayAdded\",\"inputs\":[{\"name\":\"relay\",\"type\":\"address\",\"indexed\":true},{\"name\":\"owner\",\"type\":\"address\",\"indexed\":true},{\"name\":\"transactionFee\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"stake\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"unstakeDelay\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"url\",\"type\":\"string\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Penalized\",\"inputs\":[{\"name\":\"relay\",\"type\":\"address\",\"indexed\":true},{\"name\":\"sender\",\"type\":\"address\",\"indexed\":false},{\"name\":\"amount\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"RelayRemoved\",\"inputs\":[{\"name\":\"relay\",\"type\":\"address\",\"indexed\":true},{\"name\":\"unstakeTime\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Unstaked\",\"inputs\":[{\"name\":\"relay\",\"type\":\"address\",\"indexed\":true},{\"name\":\"stake\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Deposited\",\"inputs\":[{\"name\":\"recipient\",\"type\":\"address\",\"indexed\":true},{\"name\":\"from\",\"type\":\"address\",\"indexed\":true},{\"name\":\"amount\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Withdrawn\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\",\"indexed\":true},{\"name\":\"dest\",\"type\":\"address\",\"indexed\":true},{\"name\":\"amount\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Staked\",\"inputs\":[{\"name\":\"relay\",\"type\":\"address\",\"indexed\":true},{\"name\":\"stake\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"unstakeDelay\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false}],\"bytecode\":\"\",\"networks\":{},\"devdoc\":{\"details\":null,\"methods\":{}},\"userdoc\":{\"details\":null,\"methods\":{}}}") . expect ("valid contract JSON") ;
          contract
        };
      }
      &CONTRACT
    }
    #[doc = r" Creates a new contract instance with the specified `web3`"]
    #[doc = r" provider at the given `Address`."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching"]
    #[doc = r" `Abi` is actually deployed at the given address."]
    pub fn at<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      Contract::with_deployment_info(web3, address, None)
    }
    #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
    #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
    #[doc = r" This hash is used to retrieve contract related information such as the"]
    #[doc = r" creation block (which is useful for fetching all historic events)."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
    #[doc = r" actually deployed at the given address nor that the transaction hash,"]
    #[doc = r" when provided, is actually for this contract deployment."]
    pub fn with_deployment_info<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
      deployment_information: Option<ethcontract::common::DeploymentInformation>,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::transport::DynTransport;
      use self::ethcontract::web3::api::Web3;
      use self::ethcontract::Instance;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let abi = Self::raw_contract().abi.clone();
      let instance = Instance::with_deployment_info(web3, abi, address, deployment_information);
      Contract::from_raw(instance)
    }
    #[doc = r" Creates a contract from a raw instance."]
    fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
      let methods = Methods { instance };
      Contract { methods }
    }
    #[doc = r" Returns the contract address being used by this instance."]
    pub fn address(&self) -> self::ethcontract::Address {
      self.raw_instance().address()
    }
    #[doc = r" Returns the deployment information of the contract"]
    #[doc = r" if it is known, `None` otherwise."]
    pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
      self.raw_instance().deployment_information()
    }
    #[doc = r" Returns a reference to the default method options used by this"]
    #[doc = r" contract."]
    pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
      &self.raw_instance().defaults
    }
    #[doc = r" Returns a mutable reference to the default method options used"]
    #[doc = r" by this contract."]
    pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
      &mut self.raw_instance_mut().defaults
    }
    #[doc = r" Returns a reference to the raw runtime instance used by this"]
    #[doc = r" contract."]
    pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
      &self.methods.instance
    }
    #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
    #[doc = r" this contract."]
    fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
      &mut self.methods.instance
    }
  }
  impl std::fmt::Debug for Contract {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
      f.debug_tuple(stringify!(IRelayHub))
        .field(&self.address())
        .finish()
    }
  }
  impl Contract {
    #[doc = r" Returns an object that allows accessing typed method signatures."]
    pub fn signatures() -> Signatures {
      Signatures
    }
    #[doc = r" Retrieves a reference to type containing all the generated"]
    #[doc = r" contract methods. This can be used for methods where the name"]
    #[doc = r" would collide with a common method (like `at` or `deployed`)."]
    pub fn methods(&self) -> &Methods {
      &self.methods
    }
  }
  #[doc = r" Type containing signatures for all methods for generated contract type."]
  #[derive(Clone, Copy)]
  pub struct Signatures;
  impl Signatures {
    #[doc = "Returns signature for method `withdraw(uint256,address)`."]
    #[allow(clippy::type_complexity)]
    pub fn withdraw(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::U256, self::ethcontract::Address),
      (),
    > {
      self::ethcontract::contract::Signature::new([0, 247, 20, 206])
    }
    #[doc = "Returns signature for method `getRelay(address):(uint256,uint256,uint256,address,uint8)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_relay(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address,),
      (
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::Address,
        u8,
      ),
    > {
      self::ethcontract::contract::Signature::new([141, 133, 20, 96])
    }
    #[doc = "Returns signature for method `canRelay(address,address,address,bytes,uint256,uint256,uint256,uint256,bytes,bytes):(uint256,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn can_relay(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
    > {
      self::ethcontract::contract::Signature::new([43, 96, 23, 71])
    }
    #[doc = "Returns signature for method `depositFor(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn deposit_for(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
      self::ethcontract::contract::Signature::new([170, 103, 201, 25])
    }
    #[doc = "Returns signature for method `relayCall(address,address,bytes,uint256,uint256,uint256,uint256,bytes,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn relay_call(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([64, 92, 236, 103])
    }
    #[doc = "Returns signature for method `maxPossibleCharge(uint256,uint256,uint256):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn max_possible_charge(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::U256,
      ),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([168, 99, 248, 249])
    }
    #[doc = "Returns signature for method `getNonce(address):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_nonce(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address,),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([45, 3, 53, 171])
    }
    #[doc = "Returns signature for method `registerRelay(uint256,string)`."]
    #[allow(clippy::type_complexity)]
    pub fn register_relay(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256, String), ()> {
      self::ethcontract::contract::Signature::new([17, 102, 7, 58])
    }
    #[doc = "Returns signature for method `unstake(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn unstake(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
      self::ethcontract::contract::Signature::new([242, 136, 141, 187])
    }
    #[doc = "Returns signature for method `penalizeRepeatedNonce(bytes,bytes,bytes,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn penalize_repeated_nonce(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([168, 205, 149, 114])
    }
    #[doc = "Returns signature for method `requiredGas(uint256):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn required_gas(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256,), self::ethcontract::U256>
    {
      self::ethcontract::contract::Signature::new([106, 125, 132, 164])
    }
    #[doc = "Returns signature for method `stake(address,uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn stake(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::U256),
      (),
    > {
      self::ethcontract::contract::Signature::new([173, 201, 119, 46])
    }
    #[doc = "Returns signature for method `penalizeIllegalTransaction(bytes,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn penalize_illegal_transaction(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([57, 0, 36, 50])
    }
    #[doc = "Returns signature for method `removeRelayByOwner(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn remove_relay_by_owner(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
      self::ethcontract::contract::Signature::new([195, 231, 18, 242])
    }
    #[doc = "Returns signature for method `balanceOf(address):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn balance_of(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address,),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([112, 160, 130, 49])
    }
  }
  #[doc = r" Type containing all contract methods for generated contract type."]
  #[derive(Clone)]
  pub struct Methods {
    instance: self::ethcontract::dyns::DynInstance,
  }
  #[allow(clippy::too_many_arguments, clippy::type_complexity)]
  impl Methods {
    #[doc = "Generated by `ethcontract`"]
    pub fn withdraw(
      &self,
      amount: self::ethcontract::U256,
      dest: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([0, 247, 20, 206], (amount, dest))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_relay(
      &self,
      relay: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<(
      self::ethcontract::U256,
      self::ethcontract::U256,
      self::ethcontract::U256,
      self::ethcontract::Address,
      u8,
    )> {
      self
        .instance
        .view_method([141, 133, 20, 96], (relay,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn can_relay(
      &self,
      relay: self::ethcontract::Address,
      from: self::ethcontract::Address,
      to: self::ethcontract::Address,
      encoded_function: self::ethcontract::tokens::Bytes<Vec<u8>>,
      transaction_fee: self::ethcontract::U256,
      gas_price: self::ethcontract::U256,
      gas_limit: self::ethcontract::U256,
      nonce: self::ethcontract::U256,
      signature: self::ethcontract::tokens::Bytes<Vec<u8>>,
      approval_data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<(
      self::ethcontract::U256,
      self::ethcontract::tokens::Bytes<Vec<u8>>,
    )> {
      self
        .instance
        .view_method(
          [43, 96, 23, 71],
          (
            relay,
            from,
            to,
            encoded_function,
            transaction_fee,
            gas_price,
            gas_limit,
            nonce,
            signature,
            approval_data,
          ),
        )
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn deposit_for(
      &self,
      target: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([170, 103, 201, 25], (target,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn relay_call(
      &self,
      from: self::ethcontract::Address,
      to: self::ethcontract::Address,
      encoded_function: self::ethcontract::tokens::Bytes<Vec<u8>>,
      transaction_fee: self::ethcontract::U256,
      gas_price: self::ethcontract::U256,
      gas_limit: self::ethcontract::U256,
      nonce: self::ethcontract::U256,
      signature: self::ethcontract::tokens::Bytes<Vec<u8>>,
      approval_data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method(
          [64, 92, 236, 103],
          (
            from,
            to,
            encoded_function,
            transaction_fee,
            gas_price,
            gas_limit,
            nonce,
            signature,
            approval_data,
          ),
        )
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn max_possible_charge(
      &self,
      relayed_call_stipend: self::ethcontract::U256,
      gas_price: self::ethcontract::U256,
      transaction_fee: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method(
          [168, 99, 248, 249],
          (relayed_call_stipend, gas_price, transaction_fee),
        )
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_nonce(
      &self,
      from: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([45, 3, 53, 171], (from,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn register_relay(
      &self,
      transaction_fee: self::ethcontract::U256,
      url: String,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([17, 102, 7, 58], (transaction_fee, url))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn unstake(
      &self,
      relay: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([242, 136, 141, 187], (relay,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn penalize_repeated_nonce(
      &self,
      unsigned_tx_1: self::ethcontract::tokens::Bytes<Vec<u8>>,
      signature_1: self::ethcontract::tokens::Bytes<Vec<u8>>,
      unsigned_tx_2: self::ethcontract::tokens::Bytes<Vec<u8>>,
      signature_2: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method(
          [168, 205, 149, 114],
          (unsigned_tx_1, signature_1, unsigned_tx_2, signature_2),
        )
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn required_gas(
      &self,
      relayed_call_stipend: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([106, 125, 132, 164], (relayed_call_stipend,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn stake(
      &self,
      relayaddr: self::ethcontract::Address,
      unstake_delay: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([173, 201, 119, 46], (relayaddr, unstake_delay))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn penalize_illegal_transaction(
      &self,
      unsigned_tx: self::ethcontract::tokens::Bytes<Vec<u8>>,
      signature: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([57, 0, 36, 50], (unsigned_tx, signature))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn remove_relay_by_owner(
      &self,
      relay: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([195, 231, 18, 242], (relay,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn balance_of(
      &self,
      target: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([112, 160, 130, 49], (target,))
        .expect("generated call")
    }
  }
  impl std::ops::Deref for Contract {
    type Target = Methods;
    fn deref(&self) -> &Self::Target {
      &self.methods
    }
  }
  #[doc = r" Module containing all generated data models for this contract's"]
  #[doc = r" events."]
  pub mod event_data {
    use super::ethcontract;
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct CanRelayFailed {
      pub relay: self::ethcontract::Address,
      pub from: self::ethcontract::Address,
      pub to: self::ethcontract::Address,
      pub selector: self::ethcontract::tokens::Bytes<[u8; 4]>,
      pub reason: self::ethcontract::U256,
    }
    impl CanRelayFailed {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          175, 181, 175, 214, 209, 194, 232, 255, 191, 180, 128, 230, 116, 161, 105, 244, 147, 236,
          224, 178, 38, 88, 212, 244, 72, 78, 115, 52, 240, 36, 30, 34,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`CanRelayFailed(address,address,address,bytes4,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "CanRelayFailed(address,address,address,bytes4,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for CanRelayFailed {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (relay, from, to, selector, reason) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(CanRelayFailed {
          relay,
          from,
          to,
          selector,
          reason,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct TransactionRelayed {
      pub relay: self::ethcontract::Address,
      pub from: self::ethcontract::Address,
      pub to: self::ethcontract::Address,
      pub selector: self::ethcontract::tokens::Bytes<[u8; 4]>,
      pub status: u8,
      pub charge: self::ethcontract::U256,
    }
    impl TransactionRelayed {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          171, 116, 57, 13, 57, 89, 22, 217, 224, 0, 98, 152, 212, 121, 56, 165, 222, 245, 211,
          103, 5, 77, 204, 167, 143, 166, 236, 132, 56, 31, 63, 34,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`TransactionRelayed(address,address,address,bytes4,uint8,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "TransactionRelayed(address,address,address,bytes4,uint8,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for TransactionRelayed {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (relay, from, to, selector, status, charge) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(TransactionRelayed {
          relay,
          from,
          to,
          selector,
          status,
          charge,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct RelayAdded {
      pub relay: self::ethcontract::Address,
      pub owner: self::ethcontract::Address,
      pub transaction_fee: self::ethcontract::U256,
      pub stake: self::ethcontract::U256,
      pub unstake_delay: self::ethcontract::U256,
      pub url: String,
    }
    impl RelayAdded {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          133, 179, 174, 58, 174, 157, 63, 203, 49, 20, 47, 189, 140, 59, 71, 34, 213, 120, 37,
          184, 237, 214, 225, 54, 110, 105, 32, 74, 250, 90, 13, 250,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`RelayAdded(address,address,uint256,uint256,uint256,string)`"]
      pub fn abi_signature() -> &'static str {
        "RelayAdded(address,address,uint256,uint256,uint256,string)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for RelayAdded {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (relay, owner, transaction_fee, stake, unstake_delay, url) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(RelayAdded {
          relay,
          owner,
          transaction_fee,
          stake,
          unstake_delay,
          url,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Penalized {
      pub relay: self::ethcontract::Address,
      pub sender: self::ethcontract::Address,
      pub amount: self::ethcontract::U256,
    }
    impl Penalized {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          176, 89, 82, 102, 204, 236, 53, 120, 6, 178, 105, 31, 52, 139, 18, 130, 9, 241, 6, 10,
          11, 218, 79, 92, 149, 247, 9, 7, 48, 53, 31, 248,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Penalized(address,address,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "Penalized(address,address,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Penalized {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (relay, sender, amount) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Penalized {
          relay,
          sender,
          amount,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct RelayRemoved {
      pub relay: self::ethcontract::Address,
      pub unstake_time: self::ethcontract::U256,
    }
    impl RelayRemoved {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          84, 144, 175, 193, 216, 24, 120, 156, 139, 61, 93, 99, 188, 227, 210, 163, 50, 125, 11,
          186, 78, 251, 90, 119, 81, 247, 131, 220, 151, 125, 125, 17,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`RelayRemoved(address,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "RelayRemoved(address,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for RelayRemoved {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (relay, unstake_time) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(RelayRemoved {
          relay,
          unstake_time,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Unstaked {
      pub relay: self::ethcontract::Address,
      pub stake: self::ethcontract::U256,
    }
    impl Unstaked {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          15, 91, 184, 33, 118, 254, 177, 181, 231, 71, 226, 132, 113, 170, 146, 21, 106, 4, 217,
          243, 171, 159, 69, 242, 142, 45, 112, 66, 50, 185, 63, 117,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Unstaked(address,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "Unstaked(address,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Unstaked {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (relay, stake) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Unstaked { relay, stake })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Deposited {
      pub recipient: self::ethcontract::Address,
      pub from: self::ethcontract::Address,
      pub amount: self::ethcontract::U256,
    }
    impl Deposited {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          135, 82, 164, 114, 229, 113, 168, 22, 174, 169, 46, 236, 141, 174, 155, 175, 98, 142,
          132, 15, 73, 41, 251, 204, 45, 21, 94, 98, 51, 255, 104, 167,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Deposited(address,address,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "Deposited(address,address,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Deposited {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (recipient, from, amount) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Deposited {
          recipient,
          from,
          amount,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Withdrawn {
      pub account: self::ethcontract::Address,
      pub dest: self::ethcontract::Address,
      pub amount: self::ethcontract::U256,
    }
    impl Withdrawn {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          209, 193, 159, 188, 212, 85, 26, 94, 223, 182, 109, 67, 210, 227, 55, 192, 72, 55, 175,
          218, 52, 130, 180, 43, 223, 86, 154, 143, 204, 218, 229, 251,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Withdrawn(address,address,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "Withdrawn(address,address,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Withdrawn {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (account, dest, amount) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Withdrawn {
          account,
          dest,
          amount,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Staked {
      pub relay: self::ethcontract::Address,
      pub stake: self::ethcontract::U256,
      pub unstake_delay: self::ethcontract::U256,
    }
    impl Staked {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          20, 73, 198, 221, 120, 81, 171, 195, 10, 191, 55, 245, 119, 21, 244, 146, 1, 5, 25, 20,
          124, 194, 101, 47, 188, 56, 32, 44, 24, 166, 238, 144,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Staked(address,uint256,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "Staked(address,uint256,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Staked {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (relay, stake, unstake_delay) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Staked {
          relay,
          stake,
          unstake_delay,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
  }
  impl Contract {
    #[doc = r" Retrieves a handle to a type containing for creating event"]
    #[doc = r" streams for all the contract events."]
    pub fn events(&self) -> Events<'_> {
      Events {
        instance: self.raw_instance(),
      }
    }
  }
  pub struct Events<'a> {
    instance: &'a self::ethcontract::dyns::DynInstance,
  }
  impl Events<'_> {
    #[doc = r" Generated by `ethcontract`."]
    pub fn can_relay_failed(&self) -> self::event_builders::CanRelayFailedBuilder {
      self::event_builders::CanRelayFailedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            175, 181, 175, 214, 209, 194, 232, 255, 191, 180, 128, 230, 116, 161, 105, 244, 147,
            236, 224, 178, 38, 88, 212, 244, 72, 78, 115, 52, 240, 36, 30, 34,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn transaction_relayed(&self) -> self::event_builders::TransactionRelayedBuilder {
      self::event_builders::TransactionRelayedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            171, 116, 57, 13, 57, 89, 22, 217, 224, 0, 98, 152, 212, 121, 56, 165, 222, 245, 211,
            103, 5, 77, 204, 167, 143, 166, 236, 132, 56, 31, 63, 34,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn relay_added(&self) -> self::event_builders::RelayAddedBuilder {
      self::event_builders::RelayAddedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            133, 179, 174, 58, 174, 157, 63, 203, 49, 20, 47, 189, 140, 59, 71, 34, 213, 120, 37,
            184, 237, 214, 225, 54, 110, 105, 32, 74, 250, 90, 13, 250,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn penalized(&self) -> self::event_builders::PenalizedBuilder {
      self::event_builders::PenalizedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            176, 89, 82, 102, 204, 236, 53, 120, 6, 178, 105, 31, 52, 139, 18, 130, 9, 241, 6, 10,
            11, 218, 79, 92, 149, 247, 9, 7, 48, 53, 31, 248,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn relay_removed(&self) -> self::event_builders::RelayRemovedBuilder {
      self::event_builders::RelayRemovedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            84, 144, 175, 193, 216, 24, 120, 156, 139, 61, 93, 99, 188, 227, 210, 163, 50, 125, 11,
            186, 78, 251, 90, 119, 81, 247, 131, 220, 151, 125, 125, 17,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn unstaked(&self) -> self::event_builders::UnstakedBuilder {
      self::event_builders::UnstakedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            15, 91, 184, 33, 118, 254, 177, 181, 231, 71, 226, 132, 113, 170, 146, 21, 106, 4, 217,
            243, 171, 159, 69, 242, 142, 45, 112, 66, 50, 185, 63, 117,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn deposited(&self) -> self::event_builders::DepositedBuilder {
      self::event_builders::DepositedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            135, 82, 164, 114, 229, 113, 168, 22, 174, 169, 46, 236, 141, 174, 155, 175, 98, 142,
            132, 15, 73, 41, 251, 204, 45, 21, 94, 98, 51, 255, 104, 167,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn withdrawn(&self) -> self::event_builders::WithdrawnBuilder {
      self::event_builders::WithdrawnBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            209, 193, 159, 188, 212, 85, 26, 94, 223, 182, 109, 67, 210, 227, 55, 192, 72, 55, 175,
            218, 52, 130, 180, 43, 223, 86, 154, 143, 204, 218, 229, 251,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn staked(&self) -> self::event_builders::StakedBuilder {
      self::event_builders::StakedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            20, 73, 198, 221, 120, 81, 171, 195, 10, 191, 55, 245, 119, 21, 244, 146, 1, 5, 25, 20,
            124, 194, 101, 47, 188, 56, 32, 44, 24, 166, 238, 144,
          ]))
          .expect("generated event filter"),
      )
    }
  }
  #[doc = r" Module containing the generated event stream builders with type safe"]
  #[doc = r" filter methods for this contract's events."]
  pub mod event_builders {
    use super::ethcontract;
    use super::event_data;
    #[doc = "A builder for creating a filtered stream of `CanRelayFailed` events."]
    pub struct CanRelayFailedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::CanRelayFailed>,
    );
    impl CanRelayFailedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the relay event parameter."]
      pub fn relay(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the from event parameter."]
      pub fn from(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the to event parameter."]
      pub fn to(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::CanRelayFailed>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::CanRelayFailed>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `TransactionRelayed` events."]
    pub struct TransactionRelayedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::TransactionRelayed>,
    );
    impl TransactionRelayedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the relay event parameter."]
      pub fn relay(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the from event parameter."]
      pub fn from(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the to event parameter."]
      pub fn to(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::TransactionRelayed>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::TransactionRelayed>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `RelayAdded` events."]
    pub struct RelayAddedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RelayAdded>,
    );
    impl RelayAddedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the relay event parameter."]
      pub fn relay(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the owner event parameter."]
      pub fn owner(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::RelayAdded>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::RelayAdded>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Penalized` events."]
    pub struct PenalizedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Penalized>,
    );
    impl PenalizedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the relay event parameter."]
      pub fn relay(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Penalized>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Penalized>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `RelayRemoved` events."]
    pub struct RelayRemovedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RelayRemoved>,
    );
    impl RelayRemovedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the relay event parameter."]
      pub fn relay(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::RelayRemoved>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::RelayRemoved>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Unstaked` events."]
    pub struct UnstakedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Unstaked>,
    );
    impl UnstakedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the relay event parameter."]
      pub fn relay(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Unstaked>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Unstaked>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Deposited` events."]
    pub struct DepositedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Deposited>,
    );
    impl DepositedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the recipient event parameter."]
      pub fn recipient(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the from event parameter."]
      pub fn from(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Deposited>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Deposited>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Withdrawn` events."]
    pub struct WithdrawnBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Withdrawn>,
    );
    impl WithdrawnBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the account event parameter."]
      pub fn account(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the dest event parameter."]
      pub fn dest(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Withdrawn>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Withdrawn>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Staked` events."]
    pub struct StakedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Staked>,
    );
    impl StakedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the relay event parameter."]
      pub fn relay(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Staked>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Staked>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
  }
  impl Contract {
    #[doc = r" Returns a log stream with all events."]
    pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
      self::ethcontract::dyns::DynAllEventsBuilder::new(
        self.raw_instance().web3(),
        self.address(),
        self.deployment_information(),
      )
    }
  }
  #[doc = r" A contract event."]
  #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
  pub enum Event {
    CanRelayFailed(self::event_data::CanRelayFailed),
    Deposited(self::event_data::Deposited),
    Penalized(self::event_data::Penalized),
    RelayAdded(self::event_data::RelayAdded),
    RelayRemoved(self::event_data::RelayRemoved),
    Staked(self::event_data::Staked),
    TransactionRelayed(self::event_data::TransactionRelayed),
    Unstaked(self::event_data::Unstaked),
    Withdrawn(self::event_data::Withdrawn),
  }
  impl self::ethcontract::contract::ParseLog for Event {
    fn parse_log(
      log: self::ethcontract::RawLog,
    ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
      let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([175 , 181 , 175 , 214 , 209 , 194 , 232 , 255 , 191 , 180 , 128 , 230 , 116 , 161 , 105 , 244 , 147 , 236 , 224 , 178 , 38 , 88 , 212 , 244 , 72 , 78 , 115 , 52 , 240 , 36 , 30 , 34]) => Ok (Event :: CanRelayFailed (log . clone () . decode (Contract :: raw_contract () . abi . event ("CanRelayFailed") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([135 , 82 , 164 , 114 , 229 , 113 , 168 , 22 , 174 , 169 , 46 , 236 , 141 , 174 , 155 , 175 , 98 , 142 , 132 , 15 , 73 , 41 , 251 , 204 , 45 , 21 , 94 , 98 , 51 , 255 , 104 , 167]) => Ok (Event :: Deposited (log . clone () . decode (Contract :: raw_contract () . abi . event ("Deposited") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([176 , 89 , 82 , 102 , 204 , 236 , 53 , 120 , 6 , 178 , 105 , 31 , 52 , 139 , 18 , 130 , 9 , 241 , 6 , 10 , 11 , 218 , 79 , 92 , 149 , 247 , 9 , 7 , 48 , 53 , 31 , 248]) => Ok (Event :: Penalized (log . clone () . decode (Contract :: raw_contract () . abi . event ("Penalized") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([133 , 179 , 174 , 58 , 174 , 157 , 63 , 203 , 49 , 20 , 47 , 189 , 140 , 59 , 71 , 34 , 213 , 120 , 37 , 184 , 237 , 214 , 225 , 54 , 110 , 105 , 32 , 74 , 250 , 90 , 13 , 250]) => Ok (Event :: RelayAdded (log . clone () . decode (Contract :: raw_contract () . abi . event ("RelayAdded") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([84 , 144 , 175 , 193 , 216 , 24 , 120 , 156 , 139 , 61 , 93 , 99 , 188 , 227 , 210 , 163 , 50 , 125 , 11 , 186 , 78 , 251 , 90 , 119 , 81 , 247 , 131 , 220 , 151 , 125 , 125 , 17]) => Ok (Event :: RelayRemoved (log . clone () . decode (Contract :: raw_contract () . abi . event ("RelayRemoved") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([20 , 73 , 198 , 221 , 120 , 81 , 171 , 195 , 10 , 191 , 55 , 245 , 119 , 21 , 244 , 146 , 1 , 5 , 25 , 20 , 124 , 194 , 101 , 47 , 188 , 56 , 32 , 44 , 24 , 166 , 238 , 144]) => Ok (Event :: Staked (log . clone () . decode (Contract :: raw_contract () . abi . event ("Staked") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([171 , 116 , 57 , 13 , 57 , 89 , 22 , 217 , 224 , 0 , 98 , 152 , 212 , 121 , 56 , 165 , 222 , 245 , 211 , 103 , 5 , 77 , 204 , 167 , 143 , 166 , 236 , 132 , 56 , 31 , 63 , 34]) => Ok (Event :: TransactionRelayed (log . clone () . decode (Contract :: raw_contract () . abi . event ("TransactionRelayed") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([15 , 91 , 184 , 33 , 118 , 254 , 177 , 181 , 231 , 71 , 226 , 132 , 113 , 170 , 146 , 21 , 106 , 4 , 217 , 243 , 171 , 159 , 69 , 242 , 142 , 45 , 112 , 66 , 50 , 185 , 63 , 117]) => Ok (Event :: Unstaked (log . clone () . decode (Contract :: raw_contract () . abi . event ("Unstaked") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([209 , 193 , 159 , 188 , 212 , 85 , 26 , 94 , 223 , 182 , 109 , 67 , 210 , 227 , 55 , 192 , 72 , 55 , 175 , 218 , 52 , 130 , 180 , 43 , 223 , 86 , 154 , 143 , 204 , 218 , 229 , 251]) => Ok (Event :: Withdrawn (log . clone () . decode (Contract :: raw_contract () . abi . event ("Withdrawn") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
      if let Some(Ok(data)) = standard_event {
        return Ok(data);
      }
      Err(self::ethcontract::errors::ExecutionError::from(
        self::ethcontract::common::abi::Error::InvalidData,
      ))
    }
  }
}
pub use self::i_relay_hub::Contract as IRelayHub;
