#[allow(dead_code)]
pub mod gsn_recipient_mock {
  # [rustfmt :: skip] use ethcontract as ethcontract ;
  #[doc = "Generated by `ethcontract`"]
  #[derive(Clone)]
  pub struct Contract {
    methods: Methods,
  }
  impl Contract {
    #[doc = r" Retrieves the raw contract instance used to generate the type safe"]
    #[doc = r" API for this contract."]
    pub fn raw_contract() -> &'static self::ethcontract::Contract {
      use self::ethcontract::common::artifact::truffle::TruffleLoader;
      use self::ethcontract::private::lazy_static;
      use self::ethcontract::Contract;
      lazy_static! {
        pub static ref CONTRACT: Contract = {
          # [allow (unused_mut)] let mut contract = TruffleLoader :: new () . load_contract_from_str ("{\"contractName\":\"GSNRecipientMock\",\"abi\":[{\"type\":\"function\",\"name\":\"upgradeRelayHub\",\"inputs\":[{\"name\":\"newRelayHub\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"msgData\",\"inputs\":[{\"name\":\"integerValue\",\"type\":\"uint256\"},{\"name\":\"stringValue\",\"type\":\"string\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"getHubAddr\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"msgSender\",\"inputs\":[],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"withdrawDeposits\",\"inputs\":[{\"name\":\"amount\",\"type\":\"uint256\"},{\"name\":\"payee\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"postRelayedCall\",\"inputs\":[{\"name\":\"context\",\"type\":\"bytes\"},{\"name\":\"success\",\"type\":\"bool\"},{\"name\":\"actualCharge\",\"type\":\"uint256\"},{\"name\":\"preRetVal\",\"type\":\"bytes32\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"preRelayedCall\",\"inputs\":[{\"name\":\"context\",\"type\":\"bytes\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bytes32\"}],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"relayHubVersion\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"acceptRelayedCall\",\"inputs\":[{\"name\":\"\",\"type\":\"address\"},{\"name\":\"\",\"type\":\"address\"},{\"name\":\"\",\"type\":\"bytes\"},{\"name\":\"\",\"type\":\"uint256\"},{\"name\":\"\",\"type\":\"uint256\"},{\"name\":\"\",\"type\":\"uint256\"},{\"name\":\"\",\"type\":\"uint256\"},{\"name\":\"\",\"type\":\"bytes\"},{\"name\":\"\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"},{\"name\":\"\",\"type\":\"bytes\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"event\",\"name\":\"RelayHubChanged\",\"inputs\":[{\"name\":\"oldRelayHub\",\"type\":\"address\",\"indexed\":true},{\"name\":\"newRelayHub\",\"type\":\"address\",\"indexed\":true}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Data\",\"inputs\":[{\"name\":\"data\",\"type\":\"bytes\",\"indexed\":false},{\"name\":\"integerValue\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"stringValue\",\"type\":\"string\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Sender\",\"inputs\":[{\"name\":\"sender\",\"type\":\"address\",\"indexed\":false}],\"anonymous\":false}],\"bytecode\":\"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\",\"networks\":{},\"devdoc\":{\"details\":null,\"methods\":{}},\"userdoc\":{\"details\":null,\"methods\":{}}}") . expect ("valid contract JSON") ;
          contract
        };
      }
      &CONTRACT
    }
    #[doc = r" Creates a new contract instance with the specified `web3`"]
    #[doc = r" provider at the given `Address`."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching"]
    #[doc = r" `Abi` is actually deployed at the given address."]
    pub fn at<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      Contract::with_deployment_info(web3, address, None)
    }
    #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
    #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
    #[doc = r" This hash is used to retrieve contract related information such as the"]
    #[doc = r" creation block (which is useful for fetching all historic events)."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
    #[doc = r" actually deployed at the given address nor that the transaction hash,"]
    #[doc = r" when provided, is actually for this contract deployment."]
    pub fn with_deployment_info<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
      deployment_information: Option<ethcontract::common::DeploymentInformation>,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::transport::DynTransport;
      use self::ethcontract::web3::api::Web3;
      use self::ethcontract::Instance;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let abi = Self::raw_contract().abi.clone();
      let instance = Instance::with_deployment_info(web3, abi, address, deployment_information);
      Contract::from_raw(instance)
    }
    #[doc = r" Creates a contract from a raw instance."]
    fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
      let methods = Methods { instance };
      Contract { methods }
    }
    #[doc = r" Returns the contract address being used by this instance."]
    pub fn address(&self) -> self::ethcontract::Address {
      self.raw_instance().address()
    }
    #[doc = r" Returns the deployment information of the contract"]
    #[doc = r" if it is known, `None` otherwise."]
    pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
      self.raw_instance().deployment_information()
    }
    #[doc = r" Returns a reference to the default method options used by this"]
    #[doc = r" contract."]
    pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
      &self.raw_instance().defaults
    }
    #[doc = r" Returns a mutable reference to the default method options used"]
    #[doc = r" by this contract."]
    pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
      &mut self.raw_instance_mut().defaults
    }
    #[doc = r" Returns a reference to the raw runtime instance used by this"]
    #[doc = r" contract."]
    pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
      &self.methods.instance
    }
    #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
    #[doc = r" this contract."]
    fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
      &mut self.methods.instance
    }
  }
  impl std::fmt::Debug for Contract {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
      f.debug_tuple(stringify!(GSNRecipientMock))
        .field(&self.address())
        .finish()
    }
  }
  impl Contract {
    #[doc = "Generated by `ethcontract`"]
    #[allow(clippy::too_many_arguments)]
    pub fn builder<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
    ) -> self::ethcontract::dyns::DynDeployBuilder<Self>
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::contract::DeployBuilder;
      use self::ethcontract::dyns::DynTransport;
      use self::ethcontract::web3::api::Web3;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let bytecode = Self::raw_contract().bytecode.clone();
      DeployBuilder::new(web3, bytecode, ()).expect("valid deployment args")
    }
  }
  impl self::ethcontract::contract::Deploy<self::ethcontract::dyns::DynTransport> for Contract {
    type Context = self::ethcontract::common::Bytecode;
    fn bytecode(cx: &Self::Context) -> &self::ethcontract::common::Bytecode {
      cx
    }
    fn abi(_: &Self::Context) -> &self::ethcontract::common::Abi {
      &Self::raw_contract().abi
    }
    fn from_deployment(
      web3: self::ethcontract::dyns::DynWeb3,
      address: self::ethcontract::Address,
      transaction_hash: self::ethcontract::H256,
      _: Self::Context,
    ) -> Self {
      Self::with_deployment_info(&web3, address, Some(transaction_hash.into()))
    }
  }
  impl Contract {
    #[doc = r" Returns an object that allows accessing typed method signatures."]
    pub fn signatures() -> Signatures {
      Signatures
    }
    #[doc = r" Retrieves a reference to type containing all the generated"]
    #[doc = r" contract methods. This can be used for methods where the name"]
    #[doc = r" would collide with a common method (like `at` or `deployed`)."]
    pub fn methods(&self) -> &Methods {
      &self.methods
    }
  }
  #[doc = r" Type containing signatures for all methods for generated contract type."]
  #[derive(Clone, Copy)]
  pub struct Signatures;
  impl Signatures {
    #[doc = "Returns signature for method `upgradeRelayHub(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn upgrade_relay_hub(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
      self::ethcontract::contract::Signature::new([158, 48, 165, 144])
    }
    #[doc = "Returns signature for method `msgData(uint256,string)`."]
    #[allow(clippy::type_complexity)]
    pub fn msg_data(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256, String), ()> {
      self::ethcontract::contract::Signature::new([55, 107, 242, 98])
    }
    #[doc = "Returns signature for method `getHubAddr():(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_hub_addr(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::Address> {
      self::ethcontract::contract::Signature::new([116, 232, 97, 214])
    }
    #[doc = "Returns signature for method `msgSender()`."]
    #[allow(clippy::type_complexity)]
    pub fn msg_sender(&self) -> self::ethcontract::contract::Signature<(), ()> {
      self::ethcontract::contract::Signature::new([215, 55, 208, 199])
    }
    #[doc = "Returns signature for method `withdrawDeposits(uint256,address)`."]
    #[allow(clippy::type_complexity)]
    pub fn withdraw_deposits(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::U256, self::ethcontract::Address),
      (),
    > {
      self::ethcontract::contract::Signature::new([194, 219, 26, 190])
    }
    #[doc = "Returns signature for method `postRelayedCall(bytes,bool,uint256,bytes32)`."]
    #[allow(clippy::type_complexity)]
    pub fn post_relayed_call(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        bool,
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<[u8; 32]>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([224, 110, 14, 34])
    }
    #[doc = "Returns signature for method `preRelayedCall(bytes):(bytes32)`."]
    #[allow(clippy::type_complexity)]
    pub fn pre_relayed_call(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::tokens::Bytes<Vec<u8>>,),
      self::ethcontract::tokens::Bytes<[u8; 32]>,
    > {
      self::ethcontract::contract::Signature::new([128, 39, 77, 183])
    }
    #[doc = "Returns signature for method `relayHubVersion():(string)`."]
    #[allow(clippy::type_complexity)]
    pub fn relay_hub_version(&self) -> self::ethcontract::contract::Signature<(), String> {
      self::ethcontract::contract::Signature::new([173, 97, 204, 213])
    }
    #[doc = "Returns signature for method `acceptRelayedCall(address,address,bytes,uint256,uint256,uint256,uint256,bytes,uint256):(uint256,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn accept_relayed_call(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::U256,
      ),
      (
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
    > {
      self::ethcontract::contract::Signature::new([131, 148, 126, 160])
    }
  }
  #[doc = r" Type containing all contract methods for generated contract type."]
  #[derive(Clone)]
  pub struct Methods {
    instance: self::ethcontract::dyns::DynInstance,
  }
  #[allow(clippy::too_many_arguments, clippy::type_complexity)]
  impl Methods {
    #[doc = "Generated by `ethcontract`"]
    pub fn upgrade_relay_hub(
      &self,
      new_relay_hub: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([158, 48, 165, 144], (new_relay_hub,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn msg_data(
      &self,
      integer_value: self::ethcontract::U256,
      string_value: String,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([55, 107, 242, 98], (integer_value, string_value))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_hub_addr(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
      self
        .instance
        .view_method([116, 232, 97, 214], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn msg_sender(&self) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([215, 55, 208, 199], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn withdraw_deposits(
      &self,
      amount: self::ethcontract::U256,
      payee: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([194, 219, 26, 190], (amount, payee))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn post_relayed_call(
      &self,
      context: self::ethcontract::tokens::Bytes<Vec<u8>>,
      success: bool,
      actual_charge: self::ethcontract::U256,
      pre_ret_val: self::ethcontract::tokens::Bytes<[u8; 32]>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method(
          [224, 110, 14, 34],
          (context, success, actual_charge, pre_ret_val),
        )
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn pre_relayed_call(
      &self,
      context: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::tokens::Bytes<[u8; 32]>> {
      self
        .instance
        .method([128, 39, 77, 183], (context,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn relay_hub_version(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<String> {
      self
        .instance
        .view_method([173, 97, 204, 213], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn accept_relayed_call(
      &self,
      p0: self::ethcontract::Address,
      p1: self::ethcontract::Address,
      p2: self::ethcontract::tokens::Bytes<Vec<u8>>,
      p3: self::ethcontract::U256,
      p4: self::ethcontract::U256,
      p5: self::ethcontract::U256,
      p6: self::ethcontract::U256,
      p7: self::ethcontract::tokens::Bytes<Vec<u8>>,
      p8: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<(
      self::ethcontract::U256,
      self::ethcontract::tokens::Bytes<Vec<u8>>,
    )> {
      self
        .instance
        .view_method([131, 148, 126, 160], (p0, p1, p2, p3, p4, p5, p6, p7, p8))
        .expect("generated call")
    }
  }
  impl std::ops::Deref for Contract {
    type Target = Methods;
    fn deref(&self) -> &Self::Target {
      &self.methods
    }
  }
  #[doc = r" Module containing all generated data models for this contract's"]
  #[doc = r" events."]
  pub mod event_data {
    use super::ethcontract;
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct RelayHubChanged {
      pub old_relay_hub: self::ethcontract::Address,
      pub new_relay_hub: self::ethcontract::Address,
    }
    impl RelayHubChanged {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          185, 248, 75, 142, 101, 22, 75, 20, 67, 154, 227, 98, 13, 240, 164, 216, 120, 109, 137,
          105, 150, 192, 40, 43, 104, 63, 157, 140, 8, 240, 70, 232,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`RelayHubChanged(address,address)`"]
      pub fn abi_signature() -> &'static str {
        "RelayHubChanged(address,address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for RelayHubChanged {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (old_relay_hub, new_relay_hub) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(RelayHubChanged {
          old_relay_hub,
          new_relay_hub,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Data {
      pub data: self::ethcontract::tokens::Bytes<Vec<u8>>,
      pub integer_value: self::ethcontract::U256,
      pub string_value: String,
    }
    impl Data {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          175, 35, 83, 84, 160, 164, 124, 145, 238, 23, 25, 97, 50, 99, 53, 203, 45, 26, 142, 85,
          184, 168, 152, 89, 176, 230, 30, 176, 73, 229, 14, 160,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Data(bytes,uint256,string)`"]
      pub fn abi_signature() -> &'static str {
        "Data(bytes,uint256,string)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Data {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (data, integer_value, string_value) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Data {
          data,
          integer_value,
          string_value,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Sender {
      pub sender: self::ethcontract::Address,
    }
    impl Sender {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          214, 85, 140, 62, 217, 16, 217, 89, 39, 16, 84, 71, 31, 209, 195, 38, 103, 157, 159, 236,
          233, 156, 80, 145, 176, 14, 216, 150, 39, 207, 43, 252,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Sender(address)`"]
      pub fn abi_signature() -> &'static str {
        "Sender(address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Sender {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (sender,) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Sender { sender })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
  }
  impl Contract {
    #[doc = r" Retrieves a handle to a type containing for creating event"]
    #[doc = r" streams for all the contract events."]
    pub fn events(&self) -> Events<'_> {
      Events {
        instance: self.raw_instance(),
      }
    }
  }
  pub struct Events<'a> {
    instance: &'a self::ethcontract::dyns::DynInstance,
  }
  impl Events<'_> {
    #[doc = r" Generated by `ethcontract`."]
    pub fn relay_hub_changed(&self) -> self::event_builders::RelayHubChangedBuilder {
      self::event_builders::RelayHubChangedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            185, 248, 75, 142, 101, 22, 75, 20, 67, 154, 227, 98, 13, 240, 164, 216, 120, 109, 137,
            105, 150, 192, 40, 43, 104, 63, 157, 140, 8, 240, 70, 232,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn data(&self) -> self::event_builders::DataBuilder {
      self::event_builders::DataBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            175, 35, 83, 84, 160, 164, 124, 145, 238, 23, 25, 97, 50, 99, 53, 203, 45, 26, 142, 85,
            184, 168, 152, 89, 176, 230, 30, 176, 73, 229, 14, 160,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn sender(&self) -> self::event_builders::SenderBuilder {
      self::event_builders::SenderBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            214, 85, 140, 62, 217, 16, 217, 89, 39, 16, 84, 71, 31, 209, 195, 38, 103, 157, 159,
            236, 233, 156, 80, 145, 176, 14, 216, 150, 39, 207, 43, 252,
          ]))
          .expect("generated event filter"),
      )
    }
  }
  #[doc = r" Module containing the generated event stream builders with type safe"]
  #[doc = r" filter methods for this contract's events."]
  pub mod event_builders {
    use super::ethcontract;
    use super::event_data;
    #[doc = "A builder for creating a filtered stream of `RelayHubChanged` events."]
    pub struct RelayHubChangedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RelayHubChanged>,
    );
    impl RelayHubChangedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the oldRelayHub event parameter."]
      pub fn old_relay_hub(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the newRelayHub event parameter."]
      pub fn new_relay_hub(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::RelayHubChanged>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::RelayHubChanged>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Data` events."]
    pub struct DataBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Data>,
    );
    impl DataBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Data>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Data>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Sender` events."]
    pub struct SenderBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Sender>,
    );
    impl SenderBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Sender>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Sender>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
  }
  impl Contract {
    #[doc = r" Returns a log stream with all events."]
    pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
      self::ethcontract::dyns::DynAllEventsBuilder::new(
        self.raw_instance().web3(),
        self.address(),
        self.deployment_information(),
      )
    }
  }
  #[doc = r" A contract event."]
  #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
  pub enum Event {
    Data(self::event_data::Data),
    RelayHubChanged(self::event_data::RelayHubChanged),
    Sender(self::event_data::Sender),
  }
  impl self::ethcontract::contract::ParseLog for Event {
    fn parse_log(
      log: self::ethcontract::RawLog,
    ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
      let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([175 , 35 , 83 , 84 , 160 , 164 , 124 , 145 , 238 , 23 , 25 , 97 , 50 , 99 , 53 , 203 , 45 , 26 , 142 , 85 , 184 , 168 , 152 , 89 , 176 , 230 , 30 , 176 , 73 , 229 , 14 , 160]) => Ok (Event :: Data (log . clone () . decode (Contract :: raw_contract () . abi . event ("Data") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([185 , 248 , 75 , 142 , 101 , 22 , 75 , 20 , 67 , 154 , 227 , 98 , 13 , 240 , 164 , 216 , 120 , 109 , 137 , 105 , 150 , 192 , 40 , 43 , 104 , 63 , 157 , 140 , 8 , 240 , 70 , 232]) => Ok (Event :: RelayHubChanged (log . clone () . decode (Contract :: raw_contract () . abi . event ("RelayHubChanged") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([214 , 85 , 140 , 62 , 217 , 16 , 217 , 89 , 39 , 16 , 84 , 71 , 31 , 209 , 195 , 38 , 103 , 157 , 159 , 236 , 233 , 156 , 80 , 145 , 176 , 14 , 216 , 150 , 39 , 207 , 43 , 252]) => Ok (Event :: Sender (log . clone () . decode (Contract :: raw_contract () . abi . event ("Sender") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
      if let Some(Ok(data)) = standard_event {
        return Ok(data);
      }
      Err(self::ethcontract::errors::ExecutionError::from(
        self::ethcontract::common::abi::Error::InvalidData,
      ))
    }
  }
}
pub use self::gsn_recipient_mock::Contract as GSNRecipientMock;
