#[allow(dead_code)]
pub mod erc777_mock {
  # [rustfmt :: skip] use ethcontract as ethcontract ;
  #[doc = "Generated by `ethcontract`"]
  #[derive(Clone)]
  pub struct Contract {
    methods: Methods,
  }
  impl Contract {
    #[doc = r" Retrieves the raw contract instance used to generate the type safe"]
    #[doc = r" API for this contract."]
    pub fn raw_contract() -> &'static self::ethcontract::Contract {
      use self::ethcontract::common::artifact::truffle::TruffleLoader;
      use self::ethcontract::private::lazy_static;
      use self::ethcontract::Contract;
      lazy_static! {
        pub static ref CONTRACT: Contract = {
          # [allow (unused_mut)] let mut contract = TruffleLoader :: new () . load_contract_from_str ("{\"contractName\":\"ERC777Mock\",\"abi\":[{\"type\":\"constructor\",\"inputs\":[{\"name\":\"initialHolder\",\"type\":\"address\"},{\"name\":\"initialBalance\",\"type\":\"uint256\"},{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"symbol\",\"type\":\"string\"},{\"name\":\"defaultOperators\",\"type\":\"address[]\"}]},{\"type\":\"function\",\"name\":\"operatorBurn\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\"},{\"name\":\"amount\",\"type\":\"uint256\"},{\"name\":\"data\",\"type\":\"bytes\"},{\"name\":\"operatorData\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"operatorSend\",\"inputs\":[{\"name\":\"sender\",\"type\":\"address\"},{\"name\":\"recipient\",\"type\":\"address\"},{\"name\":\"amount\",\"type\":\"uint256\"},{\"name\":\"data\",\"type\":\"bytes\"},{\"name\":\"operatorData\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"allowance\",\"inputs\":[{\"name\":\"holder\",\"type\":\"address\"},{\"name\":\"spender\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"authorizeOperator\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"name\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"decimals\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint8\"}],\"constant\":true,\"stateMutability\":\"pure\"},{\"type\":\"function\",\"name\":\"granularity\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"symbol\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"transfer\",\"inputs\":[{\"name\":\"recipient\",\"type\":\"address\"},{\"name\":\"amount\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"approveInternal\",\"inputs\":[{\"name\":\"holder\",\"type\":\"address\"},{\"name\":\"spender\",\"type\":\"address\"},{\"name\":\"value\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"revokeOperator\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"isOperatorFor\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\"},{\"name\":\"tokenHolder\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"send\",\"inputs\":[{\"name\":\"recipient\",\"type\":\"address\"},{\"name\":\"amount\",\"type\":\"uint256\"},{\"name\":\"data\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"approve\",\"inputs\":[{\"name\":\"spender\",\"type\":\"address\"},{\"name\":\"value\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"defaultOperators\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address[]\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"totalSupply\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"burn\",\"inputs\":[{\"name\":\"amount\",\"type\":\"uint256\"},{\"name\":\"data\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"balanceOf\",\"inputs\":[{\"name\":\"tokenHolder\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":true,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"mintInternal\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\"},{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"amount\",\"type\":\"uint256\"},{\"name\":\"userData\",\"type\":\"bytes\"},{\"name\":\"operatorData\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"transferFrom\",\"inputs\":[{\"name\":\"holder\",\"type\":\"address\"},{\"name\":\"recipient\",\"type\":\"address\"},{\"name\":\"amount\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"event\",\"name\":\"AuthorizedOperator\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\",\"indexed\":true},{\"name\":\"tokenHolder\",\"type\":\"address\",\"indexed\":true}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Burned\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\",\"indexed\":true},{\"name\":\"from\",\"type\":\"address\",\"indexed\":true},{\"name\":\"amount\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"data\",\"type\":\"bytes\",\"indexed\":false},{\"name\":\"operatorData\",\"type\":\"bytes\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Transfer\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\",\"indexed\":true},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true},{\"name\":\"value\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Approval\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\",\"indexed\":true},{\"name\":\"spender\",\"type\":\"address\",\"indexed\":true},{\"name\":\"value\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Minted\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\",\"indexed\":true},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true},{\"name\":\"amount\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"data\",\"type\":\"bytes\",\"indexed\":false},{\"name\":\"operatorData\",\"type\":\"bytes\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Sent\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\",\"indexed\":true},{\"name\":\"from\",\"type\":\"address\",\"indexed\":true},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true},{\"name\":\"amount\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"data\",\"type\":\"bytes\",\"indexed\":false},{\"name\":\"operatorData\",\"type\":\"bytes\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"RevokedOperator\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\",\"indexed\":true},{\"name\":\"tokenHolder\",\"type\":\"address\",\"indexed\":true}],\"anonymous\":false}],\"bytecode\":\"60806040523480156200001157600080fd5b50604051620042ee380380620042ee833981810160405260a08110156200003757600080fd5b810190808051906020019092919080519060200190929190805160405193929190846401000000008211156200006c57600080fd5b838201915060208201858111156200008357600080fd5b8251866001820283011164010000000082111715620000a157600080fd5b8083526020830192505050908051906020019080838360005b83811015620000d7578082015181840152602081019050620000ba565b50505050905090810190601f168015620001055780820380516001836020036101000a031916815260200191505b50604052602001805160405193929190846401000000008211156200012957600080fd5b838201915060208201858111156200014057600080fd5b82518660018202830111640100000000821117156200015e57600080fd5b8083526020830192505050908051906020019080838360005b838110156200019457808201518184015260208101905062000177565b50505050905090810190601f168015620001c25780820380516001836020036101000a031916815260200191505b5060405260200180516040519392919084640100000000821115620001e657600080fd5b83820191506020820185811115620001fd57600080fd5b82518660208202830111640100000000821117156200021b57600080fd5b8083526020830192505050908051906020019060200280838360005b838110156200025457808201518184015260208101905062000237565b5050505090500160405250505082828282600290805190602001906200027c92919062000dae565b5081600390805190602001906200029592919062000dae565b508060049080519060200190620002ae92919062000e35565b5060008090505b600480549050811015620003615760016005600060048481548110620002d757fe5b9060005260206000200160009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060006101000a81548160ff0219169083151502179055508080600101915050620002b5565b50731820a4b7618bde71dce8cdc73aab6c95905fad2473ffffffffffffffffffffffffffffffffffffffff166329965a1d3060405180807f455243373737546f6b656e000000000000000000000000000000000000000000815250600b0190506040518091039020306040518463ffffffff1660e01b8152600401808473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018381526020018273ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020019350505050600060405180830381600087803b1580156200046757600080fd5b505af11580156200047c573d6000803e3d6000fd5b50505050731820a4b7618bde71dce8cdc73aab6c95905fad2473ffffffffffffffffffffffffffffffffffffffff166329965a1d3060405180807f4552433230546f6b656e00000000000000000000000000000000000000000000815250600a0190506040518091039020306040518463ffffffff1660e01b8152600401808473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018381526020018273ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020019350505050600060405180830381600087803b1580156200058557600080fd5b505af11580156200059a573d6000803e3d6000fd5b50505050505050620005e3620005b5620005ee60201b60201c565b86866040518060200160405280600081525060405180602001604052806000815250620005f660201b60201c565b505050505062000f32565b600033905090565b600073ffffffffffffffffffffffffffffffffffffffff168473ffffffffffffffffffffffffffffffffffffffff1614156200069a576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4552433737373a206d696e7420746f20746865207a65726f206164647265737381525060200191505060405180910390fd5b620006b6836001546200092160201b62002fe21790919060201c565b60018190555062000714836000808773ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff168152602001908152602001600020546200092160201b62002fe21790919060201c565b6000808673ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff168152602001908152602001600020819055506200076f856000868686866001620009aa60201b60201c565b8373ffffffffffffffffffffffffffffffffffffffff168573ffffffffffffffffffffffffffffffffffffffff167f2fe5be0146f74c5bce36c0b80911af6c7d86ff27e89d5cfa61fc681327954e5d858585604051808481526020018060200180602001838103835285818151815260200191508051906020019080838360005b838110156200080d578082015181840152602081019050620007f0565b50505050905090810190601f1680156200083b5780820380516001836020036101000a031916815260200191505b50838103825284818151815260200191508051906020019080838360005b838110156200087657808201518184015260208101905062000859565b50505050905090810190601f168015620008a45780820380516001836020036101000a031916815260200191505b509550505050505060405180910390a38373ffffffffffffffffffffffffffffffffffffffff16600073ffffffffffffffffffffffffffffffffffffffff167fddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef856040518082815260200191505060405180910390a35050505050565b600080828401905083811015620009a0576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252601b8152602001807f536166654d6174683a206164646974696f6e206f766572666c6f77000000000081525060200191505060405180910390fd5b8091505092915050565b6000731820a4b7618bde71dce8cdc73aab6c95905fad2473ffffffffffffffffffffffffffffffffffffffff1663aabbb8ca877fb281fc8c12954d22544db45de3159a39272895b169a852b314f9cc762e44c53b60001b6040518363ffffffff1660e01b8152600401808373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018281526020019250505060206040518083038186803b15801562000a6957600080fd5b505afa15801562000a7e573d6000803e3d6000fd5b505050506040513d602081101562000a9557600080fd5b81019080805190602001909291905050509050600073ffffffffffffffffffffffffffffffffffffffff168173ffffffffffffffffffffffffffffffffffffffff161462000ccb578073ffffffffffffffffffffffffffffffffffffffff166223de298989898989896040518763ffffffff1660e01b8152600401808773ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018673ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018573ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018481526020018060200180602001838103835285818151815260200191508051906020019080838360005b8381101562000bef57808201518184015260208101905062000bd2565b50505050905090810190601f16801562000c1d5780820380516001836020036101000a031916815260200191505b50838103825284818151815260200191508051906020019080838360005b8381101562000c5857808201518184015260208101905062000c3b565b50505050905090810190601f16801562000c865780820380516001836020036101000a031916815260200191505b5098505050505050505050600060405180830381600087803b15801562000cac57600080fd5b505af115801562000cc1573d6000803e3d6000fd5b5050505062000d58565b811562000d575762000cfe8673ffffffffffffffffffffffffffffffffffffffff1662000d6260201b6200306a1760201c565b1562000d56576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252604d815260200180620042a1604d913960600191505060405180910390fd5b5b5b5050505050505050565b60008060007fc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a47060001b9050833f915080821415801562000da557506000801b8214155b92505050919050565b828054600181600116156101000203166002900490600052602060002090601f016020900481019282601f1062000df157805160ff191683800117855562000e22565b8280016001018555821562000e22579182015b8281111562000e2157825182559160200191906001019062000e04565b5b50905062000e31919062000ec4565b5090565b82805482825590600052602060002090810192821562000eb1579160200282015b8281111562000eb05782518260006101000a81548173ffffffffffffffffffffffffffffffffffffffff021916908373ffffffffffffffffffffffffffffffffffffffff1602179055509160200191906001019062000e56565b5b50905062000ec0919062000eec565b5090565b62000ee991905b8082111562000ee557600081600090555060010162000ecb565b5090565b90565b62000f2f91905b8082111562000f2b57600081816101000a81549073ffffffffffffffffffffffffffffffffffffffff02191690555060010162000ef3565b5090565b90565b61335f8062000f426000396000f3fe608060405234801561001057600080fd5b506004361061012c5760003560e01c806370a08231116100ad578063d95b637111610071578063d95b63711461096f578063dd62ed3e146109eb578063fad8b32a14610a63578063fc673c4f14610aa7578063fe9d930314610c235761012c565b806370a0823114610705578063959b8c3f1461075d57806395d89b41146107a15780639bd9bbc614610824578063a9059cbb146109095761012c565b8063313ce567116100f4578063313ce5671461031d578063502f2b8b14610341578063556f0dc7146104dd57806356189cb4146104fb57806362ad1b83146105695761012c565b806306e485381461013157806306fdde0314610190578063095ea7b31461021357806318160ddd1461027957806323b872dd14610297575b600080fd5b610139610ce8565b6040518080602001828103825283818151815260200191508051906020019060200280838360005b8381101561017c578082015181840152602081019050610161565b505050509050019250505060405180910390f35b610198610d76565b6040518080602001828103825283818151815260200191508051906020019080838360005b838110156101d85780820151818401526020810190506101bd565b50505050905090810190601f1680156102055780820380516001836020036101000a031916815260200191505b509250505060405180910390f35b61025f6004803603604081101561022957600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff16906020019092919080359060200190929190505050610e18565b604051808215151515815260200191505060405180910390f35b610281610e3b565b6040518082815260200191505060405180910390f35b610303600480360360608110156102ad57600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803573ffffffffffffffffffffffffffffffffffffffff16906020019092919080359060200190929190505050610e45565b604051808215151515815260200191505060405180910390f35b6103256110a3565b604051808260ff1660ff16815260200191505060405180910390f35b6104db600480360360a081101561035757600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803573ffffffffffffffffffffffffffffffffffffffff16906020019092919080359060200190929190803590602001906401000000008111156103be57600080fd5b8201836020820111156103d057600080fd5b803590602001918460018302840111640100000000831117156103f257600080fd5b91908080601f016020809104026020016040519081016040528093929190818152602001838380828437600081840152601f19601f8201169050808301925050505050505091929192908035906020019064010000000081111561045557600080fd5b82018360208201111561046757600080fd5b8035906020019184600183028401116401000000008311171561048957600080fd5b91908080601f016020809104026020016040519081016040528093929190818152602001838380828437600081840152601f19601f8201169050808301925050505050505091929192905050506110ac565b005b6104e56110c0565b6040518082815260200191505060405180910390f35b6105676004803603606081101561051157600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803590602001909291905050506110c9565b005b610703600480360360a081101561057f57600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803573ffffffffffffffffffffffffffffffffffffffff16906020019092919080359060200190929190803590602001906401000000008111156105e657600080fd5b8201836020820111156105f857600080fd5b8035906020019184600183028401116401000000008311171561061a57600080fd5b91908080601f016020809104026020016040519081016040528093929190818152602001838380828437600081840152601f19601f8201169050808301925050505050505091929192908035906020019064010000000081111561067d57600080fd5b82018360208201111561068f57600080fd5b803590602001918460018302840111640100000000831117156106b157600080fd5b91908080601f016020809104026020016040519081016040528093929190818152602001838380828437600081840152601f19601f8201169050808301925050505050505091929192905050506110d9565b005b6107476004803603602081101561071b57600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff16906020019092919050505061115d565b6040518082815260200191505060405180910390f35b61079f6004803603602081101561077357600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff1690602001909291905050506111a5565b005b6107a961141c565b6040518080602001828103825283818151815260200191508051906020019080838360005b838110156107e95780820151818401526020810190506107ce565b50505050905090810190601f1680156108165780820380516001836020036101000a031916815260200191505b509250505060405180910390f35b6109076004803603606081101561083a57600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803590602001909291908035906020019064010000000081111561088157600080fd5b82018360208201111561089357600080fd5b803590602001918460018302840111640100000000831117156108b557600080fd5b91908080601f016020809104026020016040519081016040528093929190818152602001838380828437600081840152601f19601f8201169050808301925050505050505091929192905050506114be565b005b6109556004803603604081101561091f57600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803590602001909291905050506114f0565b604051808215151515815260200191505060405180910390f35b6109d16004803603604081101561098557600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803573ffffffffffffffffffffffffffffffffffffffff169060200190929190505050611614565b604051808215151515815260200191505060405180910390f35b610a4d60048036036040811015610a0157600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff169060200190929190803573ffffffffffffffffffffffffffffffffffffffff1690602001909291905050506117c5565b6040518082815260200191505060405180910390f35b610aa560048036036020811015610a7957600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff16906020019092919050505061184c565b005b610c2160048036036080811015610abd57600080fd5b81019080803573ffffffffffffffffffffffffffffffffffffffff1690602001909291908035906020019092919080359060200190640100000000811115610b0457600080fd5b820183602082011115610b1657600080fd5b80359060200191846001830284011164010000000083111715610b3857600080fd5b91908080601f016020809104026020016040519081016040528093929190818152602001838380828437600081840152601f19601f82011690508083019250505050505050919291929080359060200190640100000000811115610b9b57600080fd5b820183602082011115610bad57600080fd5b80359060200191846001830284011164010000000083111715610bcf57600080fd5b91908080601f016020809104026020016040519081016040528093929190818152602001838380828437600081840152601f19601f820116905080830192505050505050509192919290505050611ac3565b005b610ce660048036036040811015610c3957600080fd5b810190808035906020019092919080359060200190640100000000811115610c6057600080fd5b820183602082011115610c7257600080fd5b80359060200191846001830284011164010000000083111715610c9457600080fd5b91908080601f016020809104026020016040519081016040528093929190818152602001838380828437600081840152601f19601f820116905080830192505050505050509192919290505050611b43565b005b60606004805480602002602001604051908101604052809291908181526020018280548015610d6c57602002820191906000526020600020905b8160009054906101000a900473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020019060010190808311610d22575b5050505050905090565b606060028054600181600116156101000203166002900480601f016020809104026020016040519081016040528092919081815260200182805460018160011615610100020316600290048015610e0e5780601f10610de357610100808354040283529160200191610e0e565b820191906000526020600020905b815481529060010190602001808311610df157829003601f168201915b5050505050905090565b600080610e23611b71565b9050610e30818585611b79565b600191505092915050565b6000600154905090565b60008073ffffffffffffffffffffffffffffffffffffffff168373ffffffffffffffffffffffffffffffffffffffff161415610ecc576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260248152602001806132466024913960400191505060405180910390fd5b600073ffffffffffffffffffffffffffffffffffffffff168473ffffffffffffffffffffffffffffffffffffffff161415610f52576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260268152602001806132bf6026913960400191505060405180910390fd5b6000610f5c611b71565b9050610f8a818686866040518060200160405280600081525060405180602001604052806000815250611d70565b610fb681868686604051806020016040528060008152506040518060200160405280600081525061208a565b61106985826110648660405180606001604052806029815260200161329660299139600860008c73ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060008873ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020019081526020016000205461238d9092919063ffffffff16565b611b79565b611097818686866040518060200160405280600081525060405180602001604052806000815250600061244d565b60019150509392505050565b60006012905090565b6110b985858585856127e8565b5050505050565b60006001905090565b6110d4838383611b79565b505050565b6110ea6110e4611b71565b86611614565b61113f576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252602c81526020018061326a602c913960400191505060405180910390fd5b61115661114a611b71565b86868686866001612af6565b5050505050565b60008060008373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff168152602001908152602001600020549050919050565b8073ffffffffffffffffffffffffffffffffffffffff166111c4611b71565b73ffffffffffffffffffffffffffffffffffffffff161415611231576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260248152602001806131906024913960400191505060405180910390fd5b600560008273ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff161561131b576007600061128f611b71565b73ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060008273ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060006101000a81549060ff02191690556113b8565b600160066000611329611b71565b73ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060008373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060006101000a81548160ff0219169083151502179055505b6113c0611b71565b73ffffffffffffffffffffffffffffffffffffffff168173ffffffffffffffffffffffffffffffffffffffff167ff4caeb2d6ca8932a215a353d0703c326ec2d81fc68170f320eb2ab49e9df61f960405160405180910390a350565b606060038054600181600116156101000203166002900480601f0160208091040260200160405190810160405280929190818152602001828054600181600116156101000203166002900480156114b45780601f10611489576101008083540402835291602001916114b4565b820191906000526020600020905b81548152906001019060200180831161149757829003601f168201915b5050505050905090565b6114eb6114c9611b71565b6114d1611b71565b858585604051806020016040528060008152506001612af6565b505050565b60008073ffffffffffffffffffffffffffffffffffffffff168373ffffffffffffffffffffffffffffffffffffffff161415611577576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260248152602001806132466024913960400191505060405180910390fd5b6000611581611b71565b90506115af818286866040518060200160405280600081525060405180602001604052806000815250611d70565b6115db81828686604051806020016040528060008152506040518060200160405280600081525061208a565b611609818286866040518060200160405280600081525060405180602001604052806000815250600061244d565b600191505092915050565b60008173ffffffffffffffffffffffffffffffffffffffff168373ffffffffffffffffffffffffffffffffffffffff16148061172c5750600560008473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff16801561172b5750600760008373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060008473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff16155b5b806117bd5750600660008373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060008473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff165b905092915050565b6000600860008473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060008373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002054905092915050565b611854611b71565b73ffffffffffffffffffffffffffffffffffffffff168173ffffffffffffffffffffffffffffffffffffffff1614156118d8576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260218152602001806131b46021913960400191505060405180910390fd5b600560008273ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060009054906101000a900460ff16156119cb57600160076000611938611b71565b73ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060008373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060006101000a81548160ff021916908315150217905550611a5f565b600660006119d7611b71565b73ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060008273ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060006101000a81549060ff02191690555b611a67611b71565b73ffffffffffffffffffffffffffffffffffffffff168173ffffffffffffffffffffffffffffffffffffffff167f50546e66e5f44d728365dc3908c63bc5cfeeab470722c1677e3073a6ac294aa160405160405180910390a350565b611ad4611ace611b71565b85611614565b611b29576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252602c81526020018061326a602c913960400191505060405180910390fd5b611b3d611b34611b71565b85858585612cd9565b50505050565b611b6d611b4e611b71565b611b56611b71565b848460405180602001604052806000815250612cd9565b5050565b600033905090565b600073ffffffffffffffffffffffffffffffffffffffff168373ffffffffffffffffffffffffffffffffffffffff161415611bff576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260258152602001806131006025913960400191505060405180910390fd5b600073ffffffffffffffffffffffffffffffffffffffff168273ffffffffffffffffffffffffffffffffffffffff161415611c85576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260238152602001806133086023913960400191505060405180910390fd5b80600860008573ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002060008473ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff168152602001908152602001600020819055508173ffffffffffffffffffffffffffffffffffffffff168373ffffffffffffffffffffffffffffffffffffffff167f8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925836040518082815260200191505060405180910390a3505050565b6000731820a4b7618bde71dce8cdc73aab6c95905fad2473ffffffffffffffffffffffffffffffffffffffff1663aabbb8ca877f29ddb589b1fb5fc7cf394961c1adf5f8c6454761adf795e67fe149f658abe89560001b6040518363ffffffff1660e01b8152600401808373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018281526020019250505060206040518083038186803b158015611e2e57600080fd5b505afa158015611e42573d6000803e3d6000fd5b505050506040513d6020811015611e5857600080fd5b81019080805190602001909291905050509050600073ffffffffffffffffffffffffffffffffffffffff168173ffffffffffffffffffffffffffffffffffffffff1614612081578073ffffffffffffffffffffffffffffffffffffffff166375ab97828888888888886040518763ffffffff1660e01b8152600401808773ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018673ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018573ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018481526020018060200180602001838103835285818151815260200191508051906020019080838360005b83811015611fb0578082015181840152602081019050611f95565b50505050905090810190601f168015611fdd5780820380516001836020036101000a031916815260200191505b50838103825284818151815260200191508051906020019080838360005b83811015612016578082015181840152602081019050611ffb565b50505050905090810190601f1680156120435780820380516001836020036101000a031916815260200191505b5098505050505050505050600060405180830381600087803b15801561206857600080fd5b505af115801561207c573d6000803e3d6000fd5b505050505b50505050505050565b6120f583604051806060016040528060278152602001613147602791396000808973ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020019081526020016000205461238d9092919063ffffffff16565b6000808773ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002081905550612188836000808773ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002054612fe290919063ffffffff16565b6000808673ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff168152602001908152602001600020819055508373ffffffffffffffffffffffffffffffffffffffff168573ffffffffffffffffffffffffffffffffffffffff168773ffffffffffffffffffffffffffffffffffffffff167f06b541ddaa720db2b10a4d0cdac39b8d360425fc073085fac19bc82614677987868686604051808481526020018060200180602001838103835285818151815260200191508051906020019080838360005b8381101561227d578082015181840152602081019050612262565b50505050905090810190601f1680156122aa5780820380516001836020036101000a031916815260200191505b50838103825284818151815260200191508051906020019080838360005b838110156122e35780820151818401526020810190506122c8565b50505050905090810190601f1680156123105780820380516001836020036101000a031916815260200191505b509550505050505060405180910390a48373ffffffffffffffffffffffffffffffffffffffff168573ffffffffffffffffffffffffffffffffffffffff167fddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef856040518082815260200191505060405180910390a3505050505050565b600083831115829061243a576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825283818151815260200191508051906020019080838360005b838110156123ff5780820151818401526020810190506123e4565b50505050905090810190601f16801561242c5780820380516001836020036101000a031916815260200191505b509250505060405180910390fd5b5060008385039050809150509392505050565b6000731820a4b7618bde71dce8cdc73aab6c95905fad2473ffffffffffffffffffffffffffffffffffffffff1663aabbb8ca877fb281fc8c12954d22544db45de3159a39272895b169a852b314f9cc762e44c53b60001b6040518363ffffffff1660e01b8152600401808373ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018281526020019250505060206040518083038186803b15801561250b57600080fd5b505afa15801561251f573d6000803e3d6000fd5b505050506040513d602081101561253557600080fd5b81019080805190602001909291905050509050600073ffffffffffffffffffffffffffffffffffffffff168173ffffffffffffffffffffffffffffffffffffffff1614612761578073ffffffffffffffffffffffffffffffffffffffff166223de298989898989896040518763ffffffff1660e01b8152600401808773ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018673ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018573ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020018481526020018060200180602001838103835285818151815260200191508051906020019080838360005b8381101561268c578082015181840152602081019050612671565b50505050905090810190601f1680156126b95780820380516001836020036101000a031916815260200191505b50838103825284818151815260200191508051906020019080838360005b838110156126f25780820151818401526020810190506126d7565b50505050905090810190601f16801561271f5780820380516001836020036101000a031916815260200191505b5098505050505050505050600060405180830381600087803b15801561274457600080fd5b505af1158015612758573d6000803e3d6000fd5b505050506127de565b81156127dd576127868673ffffffffffffffffffffffffffffffffffffffff1661306a565b156127dc576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252604d8152602001806131f9604d913960600191505060405180910390fd5b5b5b5050505050505050565b600073ffffffffffffffffffffffffffffffffffffffff168473ffffffffffffffffffffffffffffffffffffffff16141561288b576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4552433737373a206d696e7420746f20746865207a65726f206164647265737381525060200191505060405180910390fd5b6128a083600154612fe290919063ffffffff16565b6001819055506128f7836000808773ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002054612fe290919063ffffffff16565b6000808673ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020019081526020016000208190555061294a85600086868686600161244d565b8373ffffffffffffffffffffffffffffffffffffffff168573ffffffffffffffffffffffffffffffffffffffff167f2fe5be0146f74c5bce36c0b80911af6c7d86ff27e89d5cfa61fc681327954e5d858585604051808481526020018060200180602001838103835285818151815260200191508051906020019080838360005b838110156129e65780820151818401526020810190506129cb565b50505050905090810190601f168015612a135780820380516001836020036101000a031916815260200191505b50838103825284818151815260200191508051906020019080838360005b83811015612a4c578082015181840152602081019050612a31565b50505050905090810190601f168015612a795780820380516001836020036101000a031916815260200191505b509550505050505060405180910390a38373ffffffffffffffffffffffffffffffffffffffff16600073ffffffffffffffffffffffffffffffffffffffff167fddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef856040518082815260200191505060405180910390a35050505050565b600073ffffffffffffffffffffffffffffffffffffffff168773ffffffffffffffffffffffffffffffffffffffff161415612b7c576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260248152602001806131d56024913960400191505060405180910390fd5b600073ffffffffffffffffffffffffffffffffffffffff168673ffffffffffffffffffffffffffffffffffffffff161415612c02576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260228152602001806131256022913960400191505060405180910390fd5b600073ffffffffffffffffffffffffffffffffffffffff168573ffffffffffffffffffffffffffffffffffffffff161415612ca5576040517f08c379a00000000000000000000000000000000000000000000000000000000081526004018080602001828103825260208152602001807f4552433737373a2073656e6420746f20746865207a65726f206164647265737381525060200191505060405180910390fd5b612cb3878787878787611d70565b612cc187878787878761208a565b612cd08787878787878761244d565b50505050505050565b600073ffffffffffffffffffffffffffffffffffffffff168473ffffffffffffffffffffffffffffffffffffffff161415612d5f576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252602281526020018061316e6022913960400191505060405180910390fd5b612d6e85856000868686611d70565b612dd9836040518060600160405280602381526020016132e5602391396000808873ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff1681526020019081526020016000205461238d9092919063ffffffff16565b6000808673ffffffffffffffffffffffffffffffffffffffff1673ffffffffffffffffffffffffffffffffffffffff16815260200190815260200160002081905550612e30836001546130b590919063ffffffff16565b6001819055508373ffffffffffffffffffffffffffffffffffffffff168573ffffffffffffffffffffffffffffffffffffffff167fa78a9be3a7b862d26933ad85fb11d80ef66b8f972d7cbba06621d583943a4098858585604051808481526020018060200180602001838103835285818151815260200191508051906020019080838360005b83811015612ed2578082015181840152602081019050612eb7565b50505050905090810190601f168015612eff5780820380516001836020036101000a031916815260200191505b50838103825284818151815260200191508051906020019080838360005b83811015612f38578082015181840152602081019050612f1d565b50505050905090810190601f168015612f655780820380516001836020036101000a031916815260200191505b509550505050505060405180910390a3600073ffffffffffffffffffffffffffffffffffffffff168473ffffffffffffffffffffffffffffffffffffffff167fddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef856040518082815260200191505060405180910390a35050505050565b600080828401905083811015613060576040517f08c379a000000000000000000000000000000000000000000000000000000000815260040180806020018281038252601b8152602001807f536166654d6174683a206164646974696f6e206f766572666c6f77000000000081525060200191505060405180910390fd5b8091505092915050565b60008060007fc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a47060001b9050833f91508082141580156130ac57506000801b8214155b92505050919050565b60006130f783836040518060400160405280601e81526020017f536166654d6174683a207375627472616374696f6e206f766572666c6f77000081525061238d565b90509291505056fe4552433737373a20617070726f76652066726f6d20746865207a65726f20616464726573734552433737373a2073656e642066726f6d20746865207a65726f20616464726573734552433737373a207472616e7366657220616d6f756e7420657863656564732062616c616e63654552433737373a206275726e2066726f6d20746865207a65726f20616464726573734552433737373a20617574686f72697a696e672073656c66206173206f70657261746f724552433737373a207265766f6b696e672073656c66206173206f70657261746f724552433737373a206f70657261746f7220697320746865207a65726f20616464726573734552433737373a20746f6b656e20726563697069656e7420636f6e747261637420686173206e6f20696d706c656d656e74657220666f7220455243373737546f6b656e73526563697069656e744552433737373a207472616e7366657220746f20746865207a65726f20616464726573734552433737373a2063616c6c6572206973206e6f7420616e206f70657261746f7220666f7220686f6c6465724552433737373a207472616e7366657220616d6f756e74206578636565647320616c6c6f77616e63654552433737373a207472616e736665722066726f6d20746865207a65726f20616464726573734552433737373a206275726e20616d6f756e7420657863656564732062616c616e63654552433737373a20617070726f766520746f20746865207a65726f2061646472657373a265627a7a7231582084652d8ef4cbe931ffdbb2d591b0f6a47f904f5a08f444e146a5cb45bc73955964736f6c634300051100324552433737373a20746f6b656e20726563697069656e7420636f6e747261637420686173206e6f20696d706c656d656e74657220666f7220455243373737546f6b656e73526563697069656e74\",\"networks\":{},\"devdoc\":{\"details\":null,\"methods\":{}},\"userdoc\":{\"details\":null,\"methods\":{}}}") . expect ("valid contract JSON") ;
          contract
        };
      }
      &CONTRACT
    }
    #[doc = r" Creates a new contract instance with the specified `web3`"]
    #[doc = r" provider at the given `Address`."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching"]
    #[doc = r" `Abi` is actually deployed at the given address."]
    pub fn at<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      Contract::with_deployment_info(web3, address, None)
    }
    #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
    #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
    #[doc = r" This hash is used to retrieve contract related information such as the"]
    #[doc = r" creation block (which is useful for fetching all historic events)."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
    #[doc = r" actually deployed at the given address nor that the transaction hash,"]
    #[doc = r" when provided, is actually for this contract deployment."]
    pub fn with_deployment_info<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
      deployment_information: Option<ethcontract::common::DeploymentInformation>,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::transport::DynTransport;
      use self::ethcontract::web3::api::Web3;
      use self::ethcontract::Instance;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let abi = Self::raw_contract().abi.clone();
      let instance = Instance::with_deployment_info(web3, abi, address, deployment_information);
      Contract::from_raw(instance)
    }
    #[doc = r" Creates a contract from a raw instance."]
    fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
      let methods = Methods { instance };
      Contract { methods }
    }
    #[doc = r" Returns the contract address being used by this instance."]
    pub fn address(&self) -> self::ethcontract::Address {
      self.raw_instance().address()
    }
    #[doc = r" Returns the deployment information of the contract"]
    #[doc = r" if it is known, `None` otherwise."]
    pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
      self.raw_instance().deployment_information()
    }
    #[doc = r" Returns a reference to the default method options used by this"]
    #[doc = r" contract."]
    pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
      &self.raw_instance().defaults
    }
    #[doc = r" Returns a mutable reference to the default method options used"]
    #[doc = r" by this contract."]
    pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
      &mut self.raw_instance_mut().defaults
    }
    #[doc = r" Returns a reference to the raw runtime instance used by this"]
    #[doc = r" contract."]
    pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
      &self.methods.instance
    }
    #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
    #[doc = r" this contract."]
    fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
      &mut self.methods.instance
    }
  }
  impl std::fmt::Debug for Contract {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
      f.debug_tuple(stringify!(ERC777Mock))
        .field(&self.address())
        .finish()
    }
  }
  impl Contract {
    #[doc = "Generated by `ethcontract`"]
    #[allow(clippy::too_many_arguments)]
    pub fn builder<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      initial_holder: self::ethcontract::Address,
      initial_balance: self::ethcontract::U256,
      name: String,
      symbol: String,
      default_operators: Vec<self::ethcontract::Address>,
    ) -> self::ethcontract::dyns::DynDeployBuilder<Self>
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::contract::DeployBuilder;
      use self::ethcontract::dyns::DynTransport;
      use self::ethcontract::web3::api::Web3;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let bytecode = Self::raw_contract().bytecode.clone();
      DeployBuilder::new(
        web3,
        bytecode,
        (
          initial_holder,
          initial_balance,
          name,
          symbol,
          default_operators,
        ),
      )
      .expect("valid deployment args")
    }
  }
  impl self::ethcontract::contract::Deploy<self::ethcontract::dyns::DynTransport> for Contract {
    type Context = self::ethcontract::common::Bytecode;
    fn bytecode(cx: &Self::Context) -> &self::ethcontract::common::Bytecode {
      cx
    }
    fn abi(_: &Self::Context) -> &self::ethcontract::common::Abi {
      &Self::raw_contract().abi
    }
    fn from_deployment(
      web3: self::ethcontract::dyns::DynWeb3,
      address: self::ethcontract::Address,
      transaction_hash: self::ethcontract::H256,
      _: Self::Context,
    ) -> Self {
      Self::with_deployment_info(&web3, address, Some(transaction_hash.into()))
    }
  }
  impl Contract {
    #[doc = r" Returns an object that allows accessing typed method signatures."]
    pub fn signatures() -> Signatures {
      Signatures
    }
    #[doc = r" Retrieves a reference to type containing all the generated"]
    #[doc = r" contract methods. This can be used for methods where the name"]
    #[doc = r" would collide with a common method (like `at` or `deployed`)."]
    pub fn methods(&self) -> &Methods {
      &self.methods
    }
  }
  #[doc = r" Type containing signatures for all methods for generated contract type."]
  #[derive(Clone, Copy)]
  pub struct Signatures;
  impl Signatures {
    #[doc = "Returns signature for method `operatorBurn(address,uint256,bytes,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn operator_burn(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([252, 103, 60, 79])
    }
    #[doc = "Returns signature for method `operatorSend(address,address,uint256,bytes,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn operator_send(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([98, 173, 27, 131])
    }
    #[doc = "Returns signature for method `allowance(address,address):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn allowance(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::Address),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([221, 98, 237, 62])
    }
    #[doc = "Returns signature for method `authorizeOperator(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn authorize_operator(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
      self::ethcontract::contract::Signature::new([149, 155, 140, 63])
    }
    #[doc = "Returns signature for method `name():(string)`."]
    #[allow(clippy::type_complexity)]
    pub fn name(&self) -> self::ethcontract::contract::Signature<(), String> {
      self::ethcontract::contract::Signature::new([6, 253, 222, 3])
    }
    #[doc = "Returns signature for method `decimals():(uint8)`."]
    #[allow(clippy::type_complexity)]
    pub fn decimals(&self) -> self::ethcontract::contract::Signature<(), u8> {
      self::ethcontract::contract::Signature::new([49, 60, 229, 103])
    }
    #[doc = "Returns signature for method `granularity():(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn granularity(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
      self::ethcontract::contract::Signature::new([85, 111, 13, 199])
    }
    #[doc = "Returns signature for method `symbol():(string)`."]
    #[allow(clippy::type_complexity)]
    pub fn symbol(&self) -> self::ethcontract::contract::Signature<(), String> {
      self::ethcontract::contract::Signature::new([149, 216, 155, 65])
    }
    #[doc = "Returns signature for method `transfer(address,uint256):(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn transfer(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::U256),
      bool,
    > {
      self::ethcontract::contract::Signature::new([169, 5, 156, 187])
    }
    #[doc = "Returns signature for method `approveInternal(address,address,uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn approve_internal(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::U256,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([86, 24, 156, 180])
    }
    #[doc = "Returns signature for method `revokeOperator(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn revoke_operator(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
      self::ethcontract::contract::Signature::new([250, 216, 179, 42])
    }
    #[doc = "Returns signature for method `isOperatorFor(address,address):(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn is_operator_for(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::Address),
      bool,
    > {
      self::ethcontract::contract::Signature::new([217, 91, 99, 113])
    }
    #[doc = "Returns signature for method `send(address,uint256,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn send(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([155, 217, 187, 198])
    }
    #[doc = "Returns signature for method `approve(address,uint256):(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn approve(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::U256),
      bool,
    > {
      self::ethcontract::contract::Signature::new([9, 94, 167, 179])
    }
    #[doc = "Returns signature for method `defaultOperators():(address[])`."]
    #[allow(clippy::type_complexity)]
    pub fn default_operators(
      &self,
    ) -> self::ethcontract::contract::Signature<(), Vec<self::ethcontract::Address>> {
      self::ethcontract::contract::Signature::new([6, 228, 133, 56])
    }
    #[doc = "Returns signature for method `totalSupply():(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn total_supply(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
      self::ethcontract::contract::Signature::new([24, 22, 13, 221])
    }
    #[doc = "Returns signature for method `burn(uint256,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn burn(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([254, 157, 147, 3])
    }
    #[doc = "Returns signature for method `balanceOf(address):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn balance_of(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address,),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([112, 160, 130, 49])
    }
    #[doc = "Returns signature for method `mintInternal(address,address,uint256,bytes,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn mint_internal(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([80, 47, 43, 139])
    }
    #[doc = "Returns signature for method `transferFrom(address,address,uint256):(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn transfer_from(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::U256,
      ),
      bool,
    > {
      self::ethcontract::contract::Signature::new([35, 184, 114, 221])
    }
  }
  #[doc = r" Type containing all contract methods for generated contract type."]
  #[derive(Clone)]
  pub struct Methods {
    instance: self::ethcontract::dyns::DynInstance,
  }
  #[allow(clippy::too_many_arguments, clippy::type_complexity)]
  impl Methods {
    #[doc = "Generated by `ethcontract`"]
    pub fn operator_burn(
      &self,
      account: self::ethcontract::Address,
      amount: self::ethcontract::U256,
      data: self::ethcontract::tokens::Bytes<Vec<u8>>,
      operator_data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([252, 103, 60, 79], (account, amount, data, operator_data))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn operator_send(
      &self,
      sender: self::ethcontract::Address,
      recipient: self::ethcontract::Address,
      amount: self::ethcontract::U256,
      data: self::ethcontract::tokens::Bytes<Vec<u8>>,
      operator_data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method(
          [98, 173, 27, 131],
          (sender, recipient, amount, data, operator_data),
        )
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn allowance(
      &self,
      holder: self::ethcontract::Address,
      spender: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([221, 98, 237, 62], (holder, spender))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn authorize_operator(
      &self,
      operator: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([149, 155, 140, 63], (operator,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn name(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<String> {
      self
        .instance
        .view_method([6, 253, 222, 3], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn decimals(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<u8> {
      self
        .instance
        .view_method([49, 60, 229, 103], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn granularity(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([85, 111, 13, 199], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn symbol(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<String> {
      self
        .instance
        .view_method([149, 216, 155, 65], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn transfer(
      &self,
      recipient: self::ethcontract::Address,
      amount: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<bool> {
      self
        .instance
        .method([169, 5, 156, 187], (recipient, amount))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn approve_internal(
      &self,
      holder: self::ethcontract::Address,
      spender: self::ethcontract::Address,
      value: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([86, 24, 156, 180], (holder, spender, value))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn revoke_operator(
      &self,
      operator: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([250, 216, 179, 42], (operator,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn is_operator_for(
      &self,
      operator: self::ethcontract::Address,
      token_holder: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([217, 91, 99, 113], (operator, token_holder))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn send(
      &self,
      recipient: self::ethcontract::Address,
      amount: self::ethcontract::U256,
      data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([155, 217, 187, 198], (recipient, amount, data))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn approve(
      &self,
      spender: self::ethcontract::Address,
      value: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<bool> {
      self
        .instance
        .method([9, 94, 167, 179], (spender, value))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn default_operators(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<Vec<self::ethcontract::Address>> {
      self
        .instance
        .view_method([6, 228, 133, 56], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn total_supply(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([24, 22, 13, 221], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn burn(
      &self,
      amount: self::ethcontract::U256,
      data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([254, 157, 147, 3], (amount, data))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn balance_of(
      &self,
      token_holder: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([112, 160, 130, 49], (token_holder,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn mint_internal(
      &self,
      operator: self::ethcontract::Address,
      to: self::ethcontract::Address,
      amount: self::ethcontract::U256,
      user_data: self::ethcontract::tokens::Bytes<Vec<u8>>,
      operator_data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method(
          [80, 47, 43, 139],
          (operator, to, amount, user_data, operator_data),
        )
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn transfer_from(
      &self,
      holder: self::ethcontract::Address,
      recipient: self::ethcontract::Address,
      amount: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<bool> {
      self
        .instance
        .method([35, 184, 114, 221], (holder, recipient, amount))
        .expect("generated call")
    }
  }
  impl std::ops::Deref for Contract {
    type Target = Methods;
    fn deref(&self) -> &Self::Target {
      &self.methods
    }
  }
  #[doc = r" Module containing all generated data models for this contract's"]
  #[doc = r" events."]
  pub mod event_data {
    use super::ethcontract;
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct AuthorizedOperator {
      pub operator: self::ethcontract::Address,
      pub token_holder: self::ethcontract::Address,
    }
    impl AuthorizedOperator {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          244, 202, 235, 45, 108, 168, 147, 42, 33, 90, 53, 61, 7, 3, 195, 38, 236, 45, 129, 252,
          104, 23, 15, 50, 14, 178, 171, 73, 233, 223, 97, 249,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`AuthorizedOperator(address,address)`"]
      pub fn abi_signature() -> &'static str {
        "AuthorizedOperator(address,address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for AuthorizedOperator {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (operator, token_holder) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(AuthorizedOperator {
          operator,
          token_holder,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Burned {
      pub operator: self::ethcontract::Address,
      pub from: self::ethcontract::Address,
      pub amount: self::ethcontract::U256,
      pub data: self::ethcontract::tokens::Bytes<Vec<u8>>,
      pub operator_data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    }
    impl Burned {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          167, 138, 155, 227, 167, 184, 98, 210, 105, 51, 173, 133, 251, 17, 216, 14, 246, 107,
          143, 151, 45, 124, 187, 160, 102, 33, 213, 131, 148, 58, 64, 152,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Burned(address,address,uint256,bytes,bytes)`"]
      pub fn abi_signature() -> &'static str {
        "Burned(address,address,uint256,bytes,bytes)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Burned {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (operator, from, amount, data, operator_data) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Burned {
          operator,
          from,
          amount,
          data,
          operator_data,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Transfer {
      pub from: self::ethcontract::Address,
      pub to: self::ethcontract::Address,
      pub value: self::ethcontract::U256,
    }
    impl Transfer {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          221, 242, 82, 173, 27, 226, 200, 155, 105, 194, 176, 104, 252, 55, 141, 170, 149, 43,
          167, 241, 99, 196, 161, 22, 40, 245, 90, 77, 245, 35, 179, 239,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Transfer(address,address,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "Transfer(address,address,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Transfer {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (from, to, value) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Transfer { from, to, value })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Approval {
      pub owner: self::ethcontract::Address,
      pub spender: self::ethcontract::Address,
      pub value: self::ethcontract::U256,
    }
    impl Approval {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          140, 91, 225, 229, 235, 236, 125, 91, 209, 79, 113, 66, 125, 30, 132, 243, 221, 3, 20,
          192, 247, 178, 41, 30, 91, 32, 10, 200, 199, 195, 185, 37,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Approval(address,address,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "Approval(address,address,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Approval {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (owner, spender, value) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Approval {
          owner,
          spender,
          value,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Minted {
      pub operator: self::ethcontract::Address,
      pub to: self::ethcontract::Address,
      pub amount: self::ethcontract::U256,
      pub data: self::ethcontract::tokens::Bytes<Vec<u8>>,
      pub operator_data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    }
    impl Minted {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          47, 229, 190, 1, 70, 247, 76, 91, 206, 54, 192, 184, 9, 17, 175, 108, 125, 134, 255, 39,
          232, 157, 92, 250, 97, 252, 104, 19, 39, 149, 78, 93,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Minted(address,address,uint256,bytes,bytes)`"]
      pub fn abi_signature() -> &'static str {
        "Minted(address,address,uint256,bytes,bytes)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Minted {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (operator, to, amount, data, operator_data) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Minted {
          operator,
          to,
          amount,
          data,
          operator_data,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Sent {
      pub operator: self::ethcontract::Address,
      pub from: self::ethcontract::Address,
      pub to: self::ethcontract::Address,
      pub amount: self::ethcontract::U256,
      pub data: self::ethcontract::tokens::Bytes<Vec<u8>>,
      pub operator_data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    }
    impl Sent {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          6, 181, 65, 221, 170, 114, 13, 178, 177, 10, 77, 12, 218, 195, 155, 141, 54, 4, 37, 252,
          7, 48, 133, 250, 193, 155, 200, 38, 20, 103, 121, 135,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Sent(address,address,address,uint256,bytes,bytes)`"]
      pub fn abi_signature() -> &'static str {
        "Sent(address,address,address,uint256,bytes,bytes)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Sent {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (operator, from, to, amount, data, operator_data) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Sent {
          operator,
          from,
          to,
          amount,
          data,
          operator_data,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct RevokedOperator {
      pub operator: self::ethcontract::Address,
      pub token_holder: self::ethcontract::Address,
    }
    impl RevokedOperator {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          80, 84, 110, 102, 229, 244, 77, 114, 131, 101, 220, 57, 8, 198, 59, 197, 207, 238, 171,
          71, 7, 34, 193, 103, 126, 48, 115, 166, 172, 41, 74, 161,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`RevokedOperator(address,address)`"]
      pub fn abi_signature() -> &'static str {
        "RevokedOperator(address,address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for RevokedOperator {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (operator, token_holder) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(RevokedOperator {
          operator,
          token_holder,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
  }
  impl Contract {
    #[doc = r" Retrieves a handle to a type containing for creating event"]
    #[doc = r" streams for all the contract events."]
    pub fn events(&self) -> Events<'_> {
      Events {
        instance: self.raw_instance(),
      }
    }
  }
  pub struct Events<'a> {
    instance: &'a self::ethcontract::dyns::DynInstance,
  }
  impl Events<'_> {
    #[doc = r" Generated by `ethcontract`."]
    pub fn authorized_operator(&self) -> self::event_builders::AuthorizedOperatorBuilder {
      self::event_builders::AuthorizedOperatorBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            244, 202, 235, 45, 108, 168, 147, 42, 33, 90, 53, 61, 7, 3, 195, 38, 236, 45, 129, 252,
            104, 23, 15, 50, 14, 178, 171, 73, 233, 223, 97, 249,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn burned(&self) -> self::event_builders::BurnedBuilder {
      self::event_builders::BurnedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            167, 138, 155, 227, 167, 184, 98, 210, 105, 51, 173, 133, 251, 17, 216, 14, 246, 107,
            143, 151, 45, 124, 187, 160, 102, 33, 213, 131, 148, 58, 64, 152,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn transfer(&self) -> self::event_builders::TransferBuilder {
      self::event_builders::TransferBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            221, 242, 82, 173, 27, 226, 200, 155, 105, 194, 176, 104, 252, 55, 141, 170, 149, 43,
            167, 241, 99, 196, 161, 22, 40, 245, 90, 77, 245, 35, 179, 239,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn approval(&self) -> self::event_builders::ApprovalBuilder {
      self::event_builders::ApprovalBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            140, 91, 225, 229, 235, 236, 125, 91, 209, 79, 113, 66, 125, 30, 132, 243, 221, 3, 20,
            192, 247, 178, 41, 30, 91, 32, 10, 200, 199, 195, 185, 37,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn minted(&self) -> self::event_builders::MintedBuilder {
      self::event_builders::MintedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            47, 229, 190, 1, 70, 247, 76, 91, 206, 54, 192, 184, 9, 17, 175, 108, 125, 134, 255,
            39, 232, 157, 92, 250, 97, 252, 104, 19, 39, 149, 78, 93,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn sent(&self) -> self::event_builders::SentBuilder {
      self::event_builders::SentBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            6, 181, 65, 221, 170, 114, 13, 178, 177, 10, 77, 12, 218, 195, 155, 141, 54, 4, 37,
            252, 7, 48, 133, 250, 193, 155, 200, 38, 20, 103, 121, 135,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn revoked_operator(&self) -> self::event_builders::RevokedOperatorBuilder {
      self::event_builders::RevokedOperatorBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            80, 84, 110, 102, 229, 244, 77, 114, 131, 101, 220, 57, 8, 198, 59, 197, 207, 238, 171,
            71, 7, 34, 193, 103, 126, 48, 115, 166, 172, 41, 74, 161,
          ]))
          .expect("generated event filter"),
      )
    }
  }
  #[doc = r" Module containing the generated event stream builders with type safe"]
  #[doc = r" filter methods for this contract's events."]
  pub mod event_builders {
    use super::ethcontract;
    use super::event_data;
    #[doc = "A builder for creating a filtered stream of `AuthorizedOperator` events."]
    pub struct AuthorizedOperatorBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::AuthorizedOperator>,
    );
    impl AuthorizedOperatorBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the tokenHolder event parameter."]
      pub fn token_holder(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::AuthorizedOperator>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::AuthorizedOperator>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Burned` events."]
    pub struct BurnedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Burned>,
    );
    impl BurnedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the from event parameter."]
      pub fn from(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Burned>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Burned>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Transfer` events."]
    pub struct TransferBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Transfer>,
    );
    impl TransferBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the from event parameter."]
      pub fn from(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the to event parameter."]
      pub fn to(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Transfer>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Transfer>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Approval` events."]
    pub struct ApprovalBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Approval>,
    );
    impl ApprovalBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the owner event parameter."]
      pub fn owner(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the spender event parameter."]
      pub fn spender(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Approval>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Approval>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Minted` events."]
    pub struct MintedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Minted>,
    );
    impl MintedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the to event parameter."]
      pub fn to(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Minted>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Minted>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Sent` events."]
    pub struct SentBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Sent>,
    );
    impl SentBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the from event parameter."]
      pub fn from(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the to event parameter."]
      pub fn to(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Sent>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Sent>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `RevokedOperator` events."]
    pub struct RevokedOperatorBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RevokedOperator>,
    );
    impl RevokedOperatorBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the tokenHolder event parameter."]
      pub fn token_holder(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::RevokedOperator>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::RevokedOperator>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
  }
  impl Contract {
    #[doc = r" Returns a log stream with all events."]
    pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
      self::ethcontract::dyns::DynAllEventsBuilder::new(
        self.raw_instance().web3(),
        self.address(),
        self.deployment_information(),
      )
    }
  }
  #[doc = r" A contract event."]
  #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
  pub enum Event {
    Approval(self::event_data::Approval),
    AuthorizedOperator(self::event_data::AuthorizedOperator),
    Burned(self::event_data::Burned),
    Minted(self::event_data::Minted),
    RevokedOperator(self::event_data::RevokedOperator),
    Sent(self::event_data::Sent),
    Transfer(self::event_data::Transfer),
  }
  impl self::ethcontract::contract::ParseLog for Event {
    fn parse_log(
      log: self::ethcontract::RawLog,
    ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
      let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([140 , 91 , 225 , 229 , 235 , 236 , 125 , 91 , 209 , 79 , 113 , 66 , 125 , 30 , 132 , 243 , 221 , 3 , 20 , 192 , 247 , 178 , 41 , 30 , 91 , 32 , 10 , 200 , 199 , 195 , 185 , 37]) => Ok (Event :: Approval (log . clone () . decode (Contract :: raw_contract () . abi . event ("Approval") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([244 , 202 , 235 , 45 , 108 , 168 , 147 , 42 , 33 , 90 , 53 , 61 , 7 , 3 , 195 , 38 , 236 , 45 , 129 , 252 , 104 , 23 , 15 , 50 , 14 , 178 , 171 , 73 , 233 , 223 , 97 , 249]) => Ok (Event :: AuthorizedOperator (log . clone () . decode (Contract :: raw_contract () . abi . event ("AuthorizedOperator") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([167 , 138 , 155 , 227 , 167 , 184 , 98 , 210 , 105 , 51 , 173 , 133 , 251 , 17 , 216 , 14 , 246 , 107 , 143 , 151 , 45 , 124 , 187 , 160 , 102 , 33 , 213 , 131 , 148 , 58 , 64 , 152]) => Ok (Event :: Burned (log . clone () . decode (Contract :: raw_contract () . abi . event ("Burned") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([47 , 229 , 190 , 1 , 70 , 247 , 76 , 91 , 206 , 54 , 192 , 184 , 9 , 17 , 175 , 108 , 125 , 134 , 255 , 39 , 232 , 157 , 92 , 250 , 97 , 252 , 104 , 19 , 39 , 149 , 78 , 93]) => Ok (Event :: Minted (log . clone () . decode (Contract :: raw_contract () . abi . event ("Minted") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([80 , 84 , 110 , 102 , 229 , 244 , 77 , 114 , 131 , 101 , 220 , 57 , 8 , 198 , 59 , 197 , 207 , 238 , 171 , 71 , 7 , 34 , 193 , 103 , 126 , 48 , 115 , 166 , 172 , 41 , 74 , 161]) => Ok (Event :: RevokedOperator (log . clone () . decode (Contract :: raw_contract () . abi . event ("RevokedOperator") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([6 , 181 , 65 , 221 , 170 , 114 , 13 , 178 , 177 , 10 , 77 , 12 , 218 , 195 , 155 , 141 , 54 , 4 , 37 , 252 , 7 , 48 , 133 , 250 , 193 , 155 , 200 , 38 , 20 , 103 , 121 , 135]) => Ok (Event :: Sent (log . clone () . decode (Contract :: raw_contract () . abi . event ("Sent") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([221 , 242 , 82 , 173 , 27 , 226 , 200 , 155 , 105 , 194 , 176 , 104 , 252 , 55 , 141 , 170 , 149 , 43 , 167 , 241 , 99 , 196 , 161 , 22 , 40 , 245 , 90 , 77 , 245 , 35 , 179 , 239]) => Ok (Event :: Transfer (log . clone () . decode (Contract :: raw_contract () . abi . event ("Transfer") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
      if let Some(Ok(data)) = standard_event {
        return Ok(data);
      }
      Err(self::ethcontract::errors::ExecutionError::from(
        self::ethcontract::common::abi::Error::InvalidData,
      ))
    }
  }
}
pub use self::erc777_mock::Contract as ERC777Mock;
