#[allow(dead_code)]
pub mod erc721_minter_pauser {
  # [rustfmt :: skip] use ethcontract as ethcontract ;
  #[doc = "Generated by `ethcontract`"]
  #[derive(Clone)]
  pub struct Contract {
    methods: Methods,
  }
  impl Contract {
    #[doc = r" Retrieves the raw contract instance used to generate the type safe"]
    #[doc = r" API for this contract."]
    pub fn raw_contract() -> &'static self::ethcontract::Contract {
      use self::ethcontract::common::artifact::truffle::TruffleLoader;
      use self::ethcontract::private::lazy_static;
      use self::ethcontract::Contract;
      lazy_static! {
        pub static ref CONTRACT: Contract = {
          # [allow (unused_mut)] let mut contract = TruffleLoader :: new () . load_contract_from_str ("{\"contractName\":\"ERC721MinterPauser\",\"abi\":[{\"type\":\"constructor\",\"inputs\":[{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"symbol\",\"type\":\"string\"}]},{\"type\":\"function\",\"name\":\"hasRole\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"},{\"name\":\"account\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"pause\",\"inputs\":[],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"mint\",\"inputs\":[{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"safeTransferFrom\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\"},{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"safeTransferFrom\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\"},{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"tokenId\",\"type\":\"uint256\"},{\"name\":\"_data\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"setApprovalForAll\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\"},{\"name\":\"approved\",\"type\":\"bool\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"name\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"tokenOfOwnerByIndex\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\"},{\"name\":\"index\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"revokeRole\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"},{\"name\":\"account\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"totalSupply\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"MINTER_ROLE\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bytes32\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"approve\",\"inputs\":[{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"isApprovedForAll\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\"},{\"name\":\"operator\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"symbol\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"grantRole\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"},{\"name\":\"account\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"transferFrom\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\"},{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"ownerOf\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"getRoleMemberCount\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"paused\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"burn\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"balanceOf\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"renounceRole\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"},{\"name\":\"account\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"PAUSER_ROLE\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bytes32\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"supportsInterface\",\"inputs\":[{\"name\":\"interfaceId\",\"type\":\"bytes4\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"getRoleMember\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"},{\"name\":\"index\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"getRoleAdmin\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bytes32\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"unpause\",\"inputs\":[],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"baseURI\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"tokenURI\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"tokenByIndex\",\"inputs\":[{\"name\":\"index\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"getApproved\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"DEFAULT_ADMIN_ROLE\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bytes32\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"event\",\"name\":\"ApprovalForAll\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\",\"indexed\":true},{\"name\":\"operator\",\"type\":\"address\",\"indexed\":true},{\"name\":\"approved\",\"type\":\"bool\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Transfer\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\",\"indexed\":true},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true},{\"name\":\"tokenId\",\"type\":\"uint256\",\"indexed\":true}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Unpaused\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Paused\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Approval\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\",\"indexed\":true},{\"name\":\"approved\",\"type\":\"address\",\"indexed\":true},{\"name\":\"tokenId\",\"type\":\"uint256\",\"indexed\":true}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"RoleGranted\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\",\"indexed\":true},{\"name\":\"account\",\"type\":\"address\",\"indexed\":true},{\"name\":\"sender\",\"type\":\"address\",\"indexed\":true}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"RoleRevoked\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\",\"indexed\":true},{\"name\":\"account\",\"type\":\"address\",\"indexed\":true},{\"name\":\"sender\",\"type\":\"address\",\"indexed\":true}],\"anonymous\":false}],\"bytecode\":\"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\",\"networks\":{},\"devdoc\":{\"details\":null,\"methods\":{}},\"userdoc\":{\"details\":null,\"methods\":{}}}") . expect ("valid contract JSON") ;
          contract
        };
      }
      &CONTRACT
    }
    #[doc = r" Creates a new contract instance with the specified `web3`"]
    #[doc = r" provider at the given `Address`."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching"]
    #[doc = r" `Abi` is actually deployed at the given address."]
    pub fn at<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      Contract::with_deployment_info(web3, address, None)
    }
    #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
    #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
    #[doc = r" This hash is used to retrieve contract related information such as the"]
    #[doc = r" creation block (which is useful for fetching all historic events)."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
    #[doc = r" actually deployed at the given address nor that the transaction hash,"]
    #[doc = r" when provided, is actually for this contract deployment."]
    pub fn with_deployment_info<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
      deployment_information: Option<ethcontract::common::DeploymentInformation>,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::transport::DynTransport;
      use self::ethcontract::web3::api::Web3;
      use self::ethcontract::Instance;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let abi = Self::raw_contract().abi.clone();
      let instance = Instance::with_deployment_info(web3, abi, address, deployment_information);
      Contract::from_raw(instance)
    }
    #[doc = r" Creates a contract from a raw instance."]
    fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
      let methods = Methods { instance };
      Contract { methods }
    }
    #[doc = r" Returns the contract address being used by this instance."]
    pub fn address(&self) -> self::ethcontract::Address {
      self.raw_instance().address()
    }
    #[doc = r" Returns the deployment information of the contract"]
    #[doc = r" if it is known, `None` otherwise."]
    pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
      self.raw_instance().deployment_information()
    }
    #[doc = r" Returns a reference to the default method options used by this"]
    #[doc = r" contract."]
    pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
      &self.raw_instance().defaults
    }
    #[doc = r" Returns a mutable reference to the default method options used"]
    #[doc = r" by this contract."]
    pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
      &mut self.raw_instance_mut().defaults
    }
    #[doc = r" Returns a reference to the raw runtime instance used by this"]
    #[doc = r" contract."]
    pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
      &self.methods.instance
    }
    #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
    #[doc = r" this contract."]
    fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
      &mut self.methods.instance
    }
  }
  impl std::fmt::Debug for Contract {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
      f.debug_tuple(stringify!(ERC721MinterPauser))
        .field(&self.address())
        .finish()
    }
  }
  impl Contract {
    #[doc = "Generated by `ethcontract`"]
    #[allow(clippy::too_many_arguments)]
    pub fn builder<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      name: String,
      symbol: String,
    ) -> self::ethcontract::dyns::DynDeployBuilder<Self>
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::contract::DeployBuilder;
      use self::ethcontract::dyns::DynTransport;
      use self::ethcontract::web3::api::Web3;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let bytecode = Self::raw_contract().bytecode.clone();
      DeployBuilder::new(web3, bytecode, (name, symbol)).expect("valid deployment args")
    }
  }
  impl self::ethcontract::contract::Deploy<self::ethcontract::dyns::DynTransport> for Contract {
    type Context = self::ethcontract::common::Bytecode;
    fn bytecode(cx: &Self::Context) -> &self::ethcontract::common::Bytecode {
      cx
    }
    fn abi(_: &Self::Context) -> &self::ethcontract::common::Abi {
      &Self::raw_contract().abi
    }
    fn from_deployment(
      web3: self::ethcontract::dyns::DynWeb3,
      address: self::ethcontract::Address,
      transaction_hash: self::ethcontract::H256,
      _: Self::Context,
    ) -> Self {
      Self::with_deployment_info(&web3, address, Some(transaction_hash.into()))
    }
  }
  impl Contract {
    #[doc = r" Returns an object that allows accessing typed method signatures."]
    pub fn signatures() -> Signatures {
      Signatures
    }
    #[doc = r" Retrieves a reference to type containing all the generated"]
    #[doc = r" contract methods. This can be used for methods where the name"]
    #[doc = r" would collide with a common method (like `at` or `deployed`)."]
    pub fn methods(&self) -> &Methods {
      &self.methods
    }
  }
  #[doc = r" Type containing signatures for all methods for generated contract type."]
  #[derive(Clone, Copy)]
  pub struct Signatures;
  impl Signatures {
    #[doc = "Returns signature for method `hasRole(bytes32,address):(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn has_role(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<[u8; 32]>,
        self::ethcontract::Address,
      ),
      bool,
    > {
      self::ethcontract::contract::Signature::new([145, 209, 72, 84])
    }
    #[doc = "Returns signature for method `pause()`."]
    #[allow(clippy::type_complexity)]
    pub fn pause(&self) -> self::ethcontract::contract::Signature<(), ()> {
      self::ethcontract::contract::Signature::new([132, 86, 203, 89])
    }
    #[doc = "Returns signature for method `mint(address,uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn mint(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::U256),
      (),
    > {
      self::ethcontract::contract::Signature::new([64, 193, 15, 25])
    }
    #[doc = "Returns signature for method `safeTransferFrom(address,address,uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn safe_transfer_from(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::U256,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([66, 132, 46, 14])
    }
    #[doc = "Returns signature for method `safeTransferFrom(address,address,uint256,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn safe_transfer_from_with_data(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([184, 141, 79, 222])
    }
    #[doc = "Returns signature for method `setApprovalForAll(address,bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn set_approval_for_all(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address, bool), ()> {
      self::ethcontract::contract::Signature::new([162, 44, 180, 101])
    }
    #[doc = "Returns signature for method `name():(string)`."]
    #[allow(clippy::type_complexity)]
    pub fn name(&self) -> self::ethcontract::contract::Signature<(), String> {
      self::ethcontract::contract::Signature::new([6, 253, 222, 3])
    }
    #[doc = "Returns signature for method `tokenOfOwnerByIndex(address,uint256):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn token_of_owner_by_index(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::U256),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([47, 116, 92, 89])
    }
    #[doc = "Returns signature for method `revokeRole(bytes32,address)`."]
    #[allow(clippy::type_complexity)]
    pub fn revoke_role(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<[u8; 32]>,
        self::ethcontract::Address,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([213, 71, 116, 31])
    }
    #[doc = "Returns signature for method `totalSupply():(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn total_supply(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
      self::ethcontract::contract::Signature::new([24, 22, 13, 221])
    }
    #[doc = "Returns signature for method `MINTER_ROLE():(bytes32)`."]
    #[allow(clippy::type_complexity)]
    pub fn minter_role(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::tokens::Bytes<[u8; 32]>>
    {
      self::ethcontract::contract::Signature::new([213, 57, 19, 147])
    }
    #[doc = "Returns signature for method `approve(address,uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn approve(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::U256),
      (),
    > {
      self::ethcontract::contract::Signature::new([9, 94, 167, 179])
    }
    #[doc = "Returns signature for method `isApprovedForAll(address,address):(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn is_approved_for_all(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::Address),
      bool,
    > {
      self::ethcontract::contract::Signature::new([233, 133, 233, 197])
    }
    #[doc = "Returns signature for method `symbol():(string)`."]
    #[allow(clippy::type_complexity)]
    pub fn symbol(&self) -> self::ethcontract::contract::Signature<(), String> {
      self::ethcontract::contract::Signature::new([149, 216, 155, 65])
    }
    #[doc = "Returns signature for method `grantRole(bytes32,address)`."]
    #[allow(clippy::type_complexity)]
    pub fn grant_role(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<[u8; 32]>,
        self::ethcontract::Address,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([47, 47, 241, 93])
    }
    #[doc = "Returns signature for method `transferFrom(address,address,uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn transfer_from(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::U256,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([35, 184, 114, 221])
    }
    #[doc = "Returns signature for method `ownerOf(uint256):(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn owner_of(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::U256,),
      self::ethcontract::Address,
    > {
      self::ethcontract::contract::Signature::new([99, 82, 33, 30])
    }
    #[doc = "Returns signature for method `getRoleMemberCount(bytes32):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_role_member_count(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::tokens::Bytes<[u8; 32]>,),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([202, 21, 200, 115])
    }
    #[doc = "Returns signature for method `paused():(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn paused(&self) -> self::ethcontract::contract::Signature<(), bool> {
      self::ethcontract::contract::Signature::new([92, 151, 90, 187])
    }
    #[doc = "Returns signature for method `burn(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn burn(&self) -> self::ethcontract::contract::Signature<(self::ethcontract::U256,), ()> {
      self::ethcontract::contract::Signature::new([66, 150, 108, 104])
    }
    #[doc = "Returns signature for method `balanceOf(address):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn balance_of(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address,),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([112, 160, 130, 49])
    }
    #[doc = "Returns signature for method `renounceRole(bytes32,address)`."]
    #[allow(clippy::type_complexity)]
    pub fn renounce_role(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<[u8; 32]>,
        self::ethcontract::Address,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([54, 86, 138, 190])
    }
    #[doc = "Returns signature for method `PAUSER_ROLE():(bytes32)`."]
    #[allow(clippy::type_complexity)]
    pub fn pauser_role(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::tokens::Bytes<[u8; 32]>>
    {
      self::ethcontract::contract::Signature::new([230, 58, 177, 233])
    }
    #[doc = "Returns signature for method `supportsInterface(bytes4):(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn supports_interface(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::tokens::Bytes<[u8; 4]>,), bool>
    {
      self::ethcontract::contract::Signature::new([1, 255, 201, 167])
    }
    #[doc = "Returns signature for method `getRoleMember(bytes32,uint256):(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_role_member(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<[u8; 32]>,
        self::ethcontract::U256,
      ),
      self::ethcontract::Address,
    > {
      self::ethcontract::contract::Signature::new([144, 16, 208, 124])
    }
    #[doc = "Returns signature for method `getRoleAdmin(bytes32):(bytes32)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_role_admin(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::tokens::Bytes<[u8; 32]>,),
      self::ethcontract::tokens::Bytes<[u8; 32]>,
    > {
      self::ethcontract::contract::Signature::new([36, 138, 156, 163])
    }
    #[doc = "Returns signature for method `unpause()`."]
    #[allow(clippy::type_complexity)]
    pub fn unpause(&self) -> self::ethcontract::contract::Signature<(), ()> {
      self::ethcontract::contract::Signature::new([63, 75, 168, 58])
    }
    #[doc = "Returns signature for method `baseURI():(string)`."]
    #[allow(clippy::type_complexity)]
    pub fn base_uri(&self) -> self::ethcontract::contract::Signature<(), String> {
      self::ethcontract::contract::Signature::new([108, 3, 96, 235])
    }
    #[doc = "Returns signature for method `tokenURI(uint256):(string)`."]
    #[allow(clippy::type_complexity)]
    pub fn token_uri(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256,), String> {
      self::ethcontract::contract::Signature::new([200, 123, 86, 221])
    }
    #[doc = "Returns signature for method `tokenByIndex(uint256):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn token_by_index(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256,), self::ethcontract::U256>
    {
      self::ethcontract::contract::Signature::new([79, 108, 204, 231])
    }
    #[doc = "Returns signature for method `getApproved(uint256):(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_approved(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::U256,),
      self::ethcontract::Address,
    > {
      self::ethcontract::contract::Signature::new([8, 24, 18, 252])
    }
    #[doc = "Returns signature for method `DEFAULT_ADMIN_ROLE():(bytes32)`."]
    #[allow(clippy::type_complexity)]
    pub fn default_admin_role(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::tokens::Bytes<[u8; 32]>>
    {
      self::ethcontract::contract::Signature::new([162, 23, 253, 223])
    }
  }
  #[doc = r" Type containing all contract methods for generated contract type."]
  #[derive(Clone)]
  pub struct Methods {
    instance: self::ethcontract::dyns::DynInstance,
  }
  #[allow(clippy::too_many_arguments, clippy::type_complexity)]
  impl Methods {
    #[doc = "Generated by `ethcontract`"]
    pub fn has_role(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([145, 209, 72, 84], (role, account))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn pause(&self) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([132, 86, 203, 89], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn mint(
      &self,
      to: self::ethcontract::Address,
      token_id: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([64, 193, 15, 25], (to, token_id))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn safe_transfer_from(
      &self,
      from: self::ethcontract::Address,
      to: self::ethcontract::Address,
      token_id: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([66, 132, 46, 14], (from, to, token_id))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn safe_transfer_from_with_data(
      &self,
      from: self::ethcontract::Address,
      to: self::ethcontract::Address,
      token_id: self::ethcontract::U256,
      data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([184, 141, 79, 222], (from, to, token_id, data))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn set_approval_for_all(
      &self,
      operator: self::ethcontract::Address,
      approved: bool,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([162, 44, 180, 101], (operator, approved))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn name(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<String> {
      self
        .instance
        .view_method([6, 253, 222, 3], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn token_of_owner_by_index(
      &self,
      owner: self::ethcontract::Address,
      index: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([47, 116, 92, 89], (owner, index))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn revoke_role(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([213, 71, 116, 31], (role, account))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn total_supply(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([24, 22, 13, 221], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn minter_role(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::tokens::Bytes<[u8; 32]>>
    {
      self
        .instance
        .view_method([213, 57, 19, 147], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn approve(
      &self,
      to: self::ethcontract::Address,
      token_id: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([9, 94, 167, 179], (to, token_id))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn is_approved_for_all(
      &self,
      owner: self::ethcontract::Address,
      operator: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([233, 133, 233, 197], (owner, operator))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn symbol(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<String> {
      self
        .instance
        .view_method([149, 216, 155, 65], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn grant_role(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([47, 47, 241, 93], (role, account))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn transfer_from(
      &self,
      from: self::ethcontract::Address,
      to: self::ethcontract::Address,
      token_id: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([35, 184, 114, 221], (from, to, token_id))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn owner_of(
      &self,
      token_id: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
      self
        .instance
        .view_method([99, 82, 33, 30], (token_id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_role_member_count(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([202, 21, 200, 115], (role,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn paused(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([92, 151, 90, 187], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn burn(
      &self,
      token_id: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([66, 150, 108, 104], (token_id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn balance_of(
      &self,
      owner: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([112, 160, 130, 49], (owner,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn renounce_role(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([54, 86, 138, 190], (role, account))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn pauser_role(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::tokens::Bytes<[u8; 32]>>
    {
      self
        .instance
        .view_method([230, 58, 177, 233], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn supports_interface(
      &self,
      interface_id: self::ethcontract::tokens::Bytes<[u8; 4]>,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([1, 255, 201, 167], (interface_id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_role_member(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      index: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
      self
        .instance
        .view_method([144, 16, 208, 124], (role, index))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_role_admin(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::tokens::Bytes<[u8; 32]>>
    {
      self
        .instance
        .view_method([36, 138, 156, 163], (role,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn unpause(&self) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([63, 75, 168, 58], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn base_uri(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<String> {
      self
        .instance
        .view_method([108, 3, 96, 235], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn token_uri(
      &self,
      token_id: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<String> {
      self
        .instance
        .view_method([200, 123, 86, 221], (token_id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn token_by_index(
      &self,
      index: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([79, 108, 204, 231], (index,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_approved(
      &self,
      token_id: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
      self
        .instance
        .view_method([8, 24, 18, 252], (token_id,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn default_admin_role(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::tokens::Bytes<[u8; 32]>>
    {
      self
        .instance
        .view_method([162, 23, 253, 223], ())
        .expect("generated call")
    }
  }
  impl std::ops::Deref for Contract {
    type Target = Methods;
    fn deref(&self) -> &Self::Target {
      &self.methods
    }
  }
  #[doc = r" Module containing all generated data models for this contract's"]
  #[doc = r" events."]
  pub mod event_data {
    use super::ethcontract;
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct ApprovalForAll {
      pub owner: self::ethcontract::Address,
      pub operator: self::ethcontract::Address,
      pub approved: bool,
    }
    impl ApprovalForAll {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          23, 48, 126, 171, 57, 171, 97, 7, 232, 137, 152, 69, 173, 61, 89, 189, 150, 83, 242, 0,
          242, 32, 146, 4, 137, 202, 43, 89, 55, 105, 108, 49,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`ApprovalForAll(address,address,bool)`"]
      pub fn abi_signature() -> &'static str {
        "ApprovalForAll(address,address,bool)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for ApprovalForAll {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (owner, operator, approved) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(ApprovalForAll {
          owner,
          operator,
          approved,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Transfer {
      pub from: self::ethcontract::Address,
      pub to: self::ethcontract::Address,
      pub token_id: self::ethcontract::U256,
    }
    impl Transfer {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          221, 242, 82, 173, 27, 226, 200, 155, 105, 194, 176, 104, 252, 55, 141, 170, 149, 43,
          167, 241, 99, 196, 161, 22, 40, 245, 90, 77, 245, 35, 179, 239,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Transfer(address,address,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "Transfer(address,address,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Transfer {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (from, to, token_id) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Transfer { from, to, token_id })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Unpaused {
      pub account: self::ethcontract::Address,
    }
    impl Unpaused {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          93, 185, 238, 10, 73, 91, 242, 230, 255, 156, 145, 167, 131, 76, 27, 164, 253, 210, 68,
          165, 232, 170, 78, 83, 123, 211, 138, 234, 228, 176, 115, 170,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Unpaused(address)`"]
      pub fn abi_signature() -> &'static str {
        "Unpaused(address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Unpaused {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (account,) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Unpaused { account })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Paused {
      pub account: self::ethcontract::Address,
    }
    impl Paused {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          98, 231, 140, 234, 1, 190, 227, 32, 205, 78, 66, 2, 112, 181, 234, 116, 0, 13, 17, 176,
          201, 247, 71, 84, 235, 219, 252, 84, 75, 5, 162, 88,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Paused(address)`"]
      pub fn abi_signature() -> &'static str {
        "Paused(address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Paused {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (account,) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Paused { account })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Approval {
      pub owner: self::ethcontract::Address,
      pub approved: self::ethcontract::Address,
      pub token_id: self::ethcontract::U256,
    }
    impl Approval {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          140, 91, 225, 229, 235, 236, 125, 91, 209, 79, 113, 66, 125, 30, 132, 243, 221, 3, 20,
          192, 247, 178, 41, 30, 91, 32, 10, 200, 199, 195, 185, 37,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`Approval(address,address,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "Approval(address,address,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Approval {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (owner, approved, token_id) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Approval {
          owner,
          approved,
          token_id,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct RoleGranted {
      pub role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      pub account: self::ethcontract::Address,
      pub sender: self::ethcontract::Address,
    }
    impl RoleGranted {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          47, 135, 136, 17, 126, 126, 255, 29, 130, 233, 38, 236, 121, 73, 1, 209, 124, 120, 2, 74,
          80, 39, 9, 64, 48, 69, 64, 167, 51, 101, 111, 13,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`RoleGranted(bytes32,address,address)`"]
      pub fn abi_signature() -> &'static str {
        "RoleGranted(bytes32,address,address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for RoleGranted {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (role, account, sender) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(RoleGranted {
          role,
          account,
          sender,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct RoleRevoked {
      pub role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      pub account: self::ethcontract::Address,
      pub sender: self::ethcontract::Address,
    }
    impl RoleRevoked {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          246, 57, 31, 92, 50, 217, 198, 157, 42, 71, 234, 103, 11, 68, 41, 116, 181, 57, 53, 209,
          237, 199, 253, 100, 235, 33, 224, 71, 168, 57, 23, 27,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`RoleRevoked(bytes32,address,address)`"]
      pub fn abi_signature() -> &'static str {
        "RoleRevoked(bytes32,address,address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for RoleRevoked {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (role, account, sender) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(RoleRevoked {
          role,
          account,
          sender,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
  }
  impl Contract {
    #[doc = r" Retrieves a handle to a type containing for creating event"]
    #[doc = r" streams for all the contract events."]
    pub fn events(&self) -> Events<'_> {
      Events {
        instance: self.raw_instance(),
      }
    }
  }
  pub struct Events<'a> {
    instance: &'a self::ethcontract::dyns::DynInstance,
  }
  impl Events<'_> {
    #[doc = r" Generated by `ethcontract`."]
    pub fn approval_for_all(&self) -> self::event_builders::ApprovalForAllBuilder {
      self::event_builders::ApprovalForAllBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            23, 48, 126, 171, 57, 171, 97, 7, 232, 137, 152, 69, 173, 61, 89, 189, 150, 83, 242, 0,
            242, 32, 146, 4, 137, 202, 43, 89, 55, 105, 108, 49,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn transfer(&self) -> self::event_builders::TransferBuilder {
      self::event_builders::TransferBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            221, 242, 82, 173, 27, 226, 200, 155, 105, 194, 176, 104, 252, 55, 141, 170, 149, 43,
            167, 241, 99, 196, 161, 22, 40, 245, 90, 77, 245, 35, 179, 239,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn unpaused(&self) -> self::event_builders::UnpausedBuilder {
      self::event_builders::UnpausedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            93, 185, 238, 10, 73, 91, 242, 230, 255, 156, 145, 167, 131, 76, 27, 164, 253, 210, 68,
            165, 232, 170, 78, 83, 123, 211, 138, 234, 228, 176, 115, 170,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn paused(&self) -> self::event_builders::PausedBuilder {
      self::event_builders::PausedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            98, 231, 140, 234, 1, 190, 227, 32, 205, 78, 66, 2, 112, 181, 234, 116, 0, 13, 17, 176,
            201, 247, 71, 84, 235, 219, 252, 84, 75, 5, 162, 88,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn approval(&self) -> self::event_builders::ApprovalBuilder {
      self::event_builders::ApprovalBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            140, 91, 225, 229, 235, 236, 125, 91, 209, 79, 113, 66, 125, 30, 132, 243, 221, 3, 20,
            192, 247, 178, 41, 30, 91, 32, 10, 200, 199, 195, 185, 37,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn role_granted(&self) -> self::event_builders::RoleGrantedBuilder {
      self::event_builders::RoleGrantedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            47, 135, 136, 17, 126, 126, 255, 29, 130, 233, 38, 236, 121, 73, 1, 209, 124, 120, 2,
            74, 80, 39, 9, 64, 48, 69, 64, 167, 51, 101, 111, 13,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn role_revoked(&self) -> self::event_builders::RoleRevokedBuilder {
      self::event_builders::RoleRevokedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            246, 57, 31, 92, 50, 217, 198, 157, 42, 71, 234, 103, 11, 68, 41, 116, 181, 57, 53,
            209, 237, 199, 253, 100, 235, 33, 224, 71, 168, 57, 23, 27,
          ]))
          .expect("generated event filter"),
      )
    }
  }
  #[doc = r" Module containing the generated event stream builders with type safe"]
  #[doc = r" filter methods for this contract's events."]
  pub mod event_builders {
    use super::ethcontract;
    use super::event_data;
    #[doc = "A builder for creating a filtered stream of `ApprovalForAll` events."]
    pub struct ApprovalForAllBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::ApprovalForAll>,
    );
    impl ApprovalForAllBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the owner event parameter."]
      pub fn owner(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::ApprovalForAll>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::ApprovalForAll>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Transfer` events."]
    pub struct TransferBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Transfer>,
    );
    impl TransferBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the from event parameter."]
      pub fn from(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the to event parameter."]
      pub fn to(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the tokenId event parameter."]
      pub fn token_id(mut self, topic: self::ethcontract::Topic<self::ethcontract::U256>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Transfer>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Transfer>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Unpaused` events."]
    pub struct UnpausedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Unpaused>,
    );
    impl UnpausedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Unpaused>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Unpaused>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Paused` events."]
    pub struct PausedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Paused>,
    );
    impl PausedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Paused>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Paused>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `Approval` events."]
    pub struct ApprovalBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Approval>,
    );
    impl ApprovalBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the owner event parameter."]
      pub fn owner(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the approved event parameter."]
      pub fn approved(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the tokenId event parameter."]
      pub fn token_id(mut self, topic: self::ethcontract::Topic<self::ethcontract::U256>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Approval>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Approval>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `RoleGranted` events."]
    pub struct RoleGrantedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RoleGranted>,
    );
    impl RoleGrantedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the role event parameter."]
      pub fn role(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::tokens::Bytes<[u8; 32]>>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the account event parameter."]
      pub fn account(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the sender event parameter."]
      pub fn sender(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::RoleGranted>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::RoleGranted>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `RoleRevoked` events."]
    pub struct RoleRevokedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RoleRevoked>,
    );
    impl RoleRevokedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the role event parameter."]
      pub fn role(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::tokens::Bytes<[u8; 32]>>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the account event parameter."]
      pub fn account(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the sender event parameter."]
      pub fn sender(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::RoleRevoked>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::RoleRevoked>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
  }
  impl Contract {
    #[doc = r" Returns a log stream with all events."]
    pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
      self::ethcontract::dyns::DynAllEventsBuilder::new(
        self.raw_instance().web3(),
        self.address(),
        self.deployment_information(),
      )
    }
  }
  #[doc = r" A contract event."]
  #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
  pub enum Event {
    Approval(self::event_data::Approval),
    ApprovalForAll(self::event_data::ApprovalForAll),
    Paused(self::event_data::Paused),
    RoleGranted(self::event_data::RoleGranted),
    RoleRevoked(self::event_data::RoleRevoked),
    Transfer(self::event_data::Transfer),
    Unpaused(self::event_data::Unpaused),
  }
  impl self::ethcontract::contract::ParseLog for Event {
    fn parse_log(
      log: self::ethcontract::RawLog,
    ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
      let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([140 , 91 , 225 , 229 , 235 , 236 , 125 , 91 , 209 , 79 , 113 , 66 , 125 , 30 , 132 , 243 , 221 , 3 , 20 , 192 , 247 , 178 , 41 , 30 , 91 , 32 , 10 , 200 , 199 , 195 , 185 , 37]) => Ok (Event :: Approval (log . clone () . decode (Contract :: raw_contract () . abi . event ("Approval") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([23 , 48 , 126 , 171 , 57 , 171 , 97 , 7 , 232 , 137 , 152 , 69 , 173 , 61 , 89 , 189 , 150 , 83 , 242 , 0 , 242 , 32 , 146 , 4 , 137 , 202 , 43 , 89 , 55 , 105 , 108 , 49]) => Ok (Event :: ApprovalForAll (log . clone () . decode (Contract :: raw_contract () . abi . event ("ApprovalForAll") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([98 , 231 , 140 , 234 , 1 , 190 , 227 , 32 , 205 , 78 , 66 , 2 , 112 , 181 , 234 , 116 , 0 , 13 , 17 , 176 , 201 , 247 , 71 , 84 , 235 , 219 , 252 , 84 , 75 , 5 , 162 , 88]) => Ok (Event :: Paused (log . clone () . decode (Contract :: raw_contract () . abi . event ("Paused") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([47 , 135 , 136 , 17 , 126 , 126 , 255 , 29 , 130 , 233 , 38 , 236 , 121 , 73 , 1 , 209 , 124 , 120 , 2 , 74 , 80 , 39 , 9 , 64 , 48 , 69 , 64 , 167 , 51 , 101 , 111 , 13]) => Ok (Event :: RoleGranted (log . clone () . decode (Contract :: raw_contract () . abi . event ("RoleGranted") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([246 , 57 , 31 , 92 , 50 , 217 , 198 , 157 , 42 , 71 , 234 , 103 , 11 , 68 , 41 , 116 , 181 , 57 , 53 , 209 , 237 , 199 , 253 , 100 , 235 , 33 , 224 , 71 , 168 , 57 , 23 , 27]) => Ok (Event :: RoleRevoked (log . clone () . decode (Contract :: raw_contract () . abi . event ("RoleRevoked") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([221 , 242 , 82 , 173 , 27 , 226 , 200 , 155 , 105 , 194 , 176 , 104 , 252 , 55 , 141 , 170 , 149 , 43 , 167 , 241 , 99 , 196 , 161 , 22 , 40 , 245 , 90 , 77 , 245 , 35 , 179 , 239]) => Ok (Event :: Transfer (log . clone () . decode (Contract :: raw_contract () . abi . event ("Transfer") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([93 , 185 , 238 , 10 , 73 , 91 , 242 , 230 , 255 , 156 , 145 , 167 , 131 , 76 , 27 , 164 , 253 , 210 , 68 , 165 , 232 , 170 , 78 , 83 , 123 , 211 , 138 , 234 , 228 , 176 , 115 , 170]) => Ok (Event :: Unpaused (log . clone () . decode (Contract :: raw_contract () . abi . event ("Unpaused") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
      if let Some(Ok(data)) = standard_event {
        return Ok(data);
      }
      Err(self::ethcontract::errors::ExecutionError::from(
        self::ethcontract::common::abi::Error::InvalidData,
      ))
    }
  }
}
pub use self::erc721_minter_pauser::Contract as ERC721MinterPauser;
