#[allow(dead_code)]
pub mod access_control_mock {
  # [rustfmt :: skip] use ethcontract as ethcontract ;
  #[doc = "Generated by `ethcontract`"]
  #[derive(Clone)]
  pub struct Contract {
    methods: Methods,
  }
  impl Contract {
    #[doc = r" Retrieves the raw contract instance used to generate the type safe"]
    #[doc = r" API for this contract."]
    pub fn raw_contract() -> &'static self::ethcontract::Contract {
      use self::ethcontract::common::artifact::truffle::TruffleLoader;
      use self::ethcontract::private::lazy_static;
      use self::ethcontract::Contract;
      lazy_static! {
        pub static ref CONTRACT: Contract = {
          # [allow (unused_mut)] let mut contract = TruffleLoader :: new () . load_contract_from_str ("{\"contractName\":\"AccessControlMock\",\"abi\":[{\"type\":\"constructor\",\"inputs\":[]},{\"type\":\"function\",\"name\":\"hasRole\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"},{\"name\":\"account\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"getRoleMember\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"},{\"name\":\"index\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"DEFAULT_ADMIN_ROLE\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bytes32\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"revokeRole\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"},{\"name\":\"account\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"renounceRole\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"},{\"name\":\"account\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"getRoleAdmin\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bytes32\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"getRoleMemberCount\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"setRoleAdmin\",\"inputs\":[{\"name\":\"roleId\",\"type\":\"bytes32\"},{\"name\":\"adminRoleId\",\"type\":\"bytes32\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"grantRole\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\"},{\"name\":\"account\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"event\",\"name\":\"RoleRevoked\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\",\"indexed\":true},{\"name\":\"account\",\"type\":\"address\",\"indexed\":true},{\"name\":\"sender\",\"type\":\"address\",\"indexed\":true}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"RoleGranted\",\"inputs\":[{\"name\":\"role\",\"type\":\"bytes32\",\"indexed\":true},{\"name\":\"account\",\"type\":\"address\",\"indexed\":true},{\"name\":\"sender\",\"type\":\"address\",\"indexed\":true}],\"anonymous\":false}],\"bytecode\":\"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\",\"networks\":{},\"devdoc\":{\"details\":null,\"methods\":{}},\"userdoc\":{\"details\":null,\"methods\":{}}}") . expect ("valid contract JSON") ;
          contract
        };
      }
      &CONTRACT
    }
    #[doc = r" Creates a new contract instance with the specified `web3`"]
    #[doc = r" provider at the given `Address`."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching"]
    #[doc = r" `Abi` is actually deployed at the given address."]
    pub fn at<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      Contract::with_deployment_info(web3, address, None)
    }
    #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
    #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
    #[doc = r" This hash is used to retrieve contract related information such as the"]
    #[doc = r" creation block (which is useful for fetching all historic events)."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
    #[doc = r" actually deployed at the given address nor that the transaction hash,"]
    #[doc = r" when provided, is actually for this contract deployment."]
    pub fn with_deployment_info<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
      deployment_information: Option<ethcontract::common::DeploymentInformation>,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::transport::DynTransport;
      use self::ethcontract::web3::api::Web3;
      use self::ethcontract::Instance;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let abi = Self::raw_contract().abi.clone();
      let instance = Instance::with_deployment_info(web3, abi, address, deployment_information);
      Contract::from_raw(instance)
    }
    #[doc = r" Creates a contract from a raw instance."]
    fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
      let methods = Methods { instance };
      Contract { methods }
    }
    #[doc = r" Returns the contract address being used by this instance."]
    pub fn address(&self) -> self::ethcontract::Address {
      self.raw_instance().address()
    }
    #[doc = r" Returns the deployment information of the contract"]
    #[doc = r" if it is known, `None` otherwise."]
    pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
      self.raw_instance().deployment_information()
    }
    #[doc = r" Returns a reference to the default method options used by this"]
    #[doc = r" contract."]
    pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
      &self.raw_instance().defaults
    }
    #[doc = r" Returns a mutable reference to the default method options used"]
    #[doc = r" by this contract."]
    pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
      &mut self.raw_instance_mut().defaults
    }
    #[doc = r" Returns a reference to the raw runtime instance used by this"]
    #[doc = r" contract."]
    pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
      &self.methods.instance
    }
    #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
    #[doc = r" this contract."]
    fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
      &mut self.methods.instance
    }
  }
  impl std::fmt::Debug for Contract {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
      f.debug_tuple(stringify!(AccessControlMock))
        .field(&self.address())
        .finish()
    }
  }
  impl Contract {
    #[doc = "Generated by `ethcontract`"]
    #[allow(clippy::too_many_arguments)]
    pub fn builder<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
    ) -> self::ethcontract::dyns::DynDeployBuilder<Self>
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::contract::DeployBuilder;
      use self::ethcontract::dyns::DynTransport;
      use self::ethcontract::web3::api::Web3;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let bytecode = Self::raw_contract().bytecode.clone();
      DeployBuilder::new(web3, bytecode, ()).expect("valid deployment args")
    }
  }
  impl self::ethcontract::contract::Deploy<self::ethcontract::dyns::DynTransport> for Contract {
    type Context = self::ethcontract::common::Bytecode;
    fn bytecode(cx: &Self::Context) -> &self::ethcontract::common::Bytecode {
      cx
    }
    fn abi(_: &Self::Context) -> &self::ethcontract::common::Abi {
      &Self::raw_contract().abi
    }
    fn from_deployment(
      web3: self::ethcontract::dyns::DynWeb3,
      address: self::ethcontract::Address,
      transaction_hash: self::ethcontract::H256,
      _: Self::Context,
    ) -> Self {
      Self::with_deployment_info(&web3, address, Some(transaction_hash.into()))
    }
  }
  impl Contract {
    #[doc = r" Returns an object that allows accessing typed method signatures."]
    pub fn signatures() -> Signatures {
      Signatures
    }
    #[doc = r" Retrieves a reference to type containing all the generated"]
    #[doc = r" contract methods. This can be used for methods where the name"]
    #[doc = r" would collide with a common method (like `at` or `deployed`)."]
    pub fn methods(&self) -> &Methods {
      &self.methods
    }
  }
  #[doc = r" Type containing signatures for all methods for generated contract type."]
  #[derive(Clone, Copy)]
  pub struct Signatures;
  impl Signatures {
    #[doc = "Returns signature for method `hasRole(bytes32,address):(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn has_role(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<[u8; 32]>,
        self::ethcontract::Address,
      ),
      bool,
    > {
      self::ethcontract::contract::Signature::new([145, 209, 72, 84])
    }
    #[doc = "Returns signature for method `getRoleMember(bytes32,uint256):(address)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_role_member(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<[u8; 32]>,
        self::ethcontract::U256,
      ),
      self::ethcontract::Address,
    > {
      self::ethcontract::contract::Signature::new([144, 16, 208, 124])
    }
    #[doc = "Returns signature for method `DEFAULT_ADMIN_ROLE():(bytes32)`."]
    #[allow(clippy::type_complexity)]
    pub fn default_admin_role(
      &self,
    ) -> self::ethcontract::contract::Signature<(), self::ethcontract::tokens::Bytes<[u8; 32]>>
    {
      self::ethcontract::contract::Signature::new([162, 23, 253, 223])
    }
    #[doc = "Returns signature for method `revokeRole(bytes32,address)`."]
    #[allow(clippy::type_complexity)]
    pub fn revoke_role(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<[u8; 32]>,
        self::ethcontract::Address,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([213, 71, 116, 31])
    }
    #[doc = "Returns signature for method `renounceRole(bytes32,address)`."]
    #[allow(clippy::type_complexity)]
    pub fn renounce_role(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<[u8; 32]>,
        self::ethcontract::Address,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([54, 86, 138, 190])
    }
    #[doc = "Returns signature for method `getRoleAdmin(bytes32):(bytes32)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_role_admin(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::tokens::Bytes<[u8; 32]>,),
      self::ethcontract::tokens::Bytes<[u8; 32]>,
    > {
      self::ethcontract::contract::Signature::new([36, 138, 156, 163])
    }
    #[doc = "Returns signature for method `getRoleMemberCount(bytes32):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn get_role_member_count(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::tokens::Bytes<[u8; 32]>,),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([202, 21, 200, 115])
    }
    #[doc = "Returns signature for method `setRoleAdmin(bytes32,bytes32)`."]
    #[allow(clippy::type_complexity)]
    pub fn set_role_admin(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<[u8; 32]>,
        self::ethcontract::tokens::Bytes<[u8; 32]>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([30, 78, 0, 145])
    }
    #[doc = "Returns signature for method `grantRole(bytes32,address)`."]
    #[allow(clippy::type_complexity)]
    pub fn grant_role(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::tokens::Bytes<[u8; 32]>,
        self::ethcontract::Address,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([47, 47, 241, 93])
    }
  }
  #[doc = r" Type containing all contract methods for generated contract type."]
  #[derive(Clone)]
  pub struct Methods {
    instance: self::ethcontract::dyns::DynInstance,
  }
  #[allow(clippy::too_many_arguments, clippy::type_complexity)]
  impl Methods {
    #[doc = "Generated by `ethcontract`"]
    pub fn has_role(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([145, 209, 72, 84], (role, account))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_role_member(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      index: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
      self
        .instance
        .view_method([144, 16, 208, 124], (role, index))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn default_admin_role(
      &self,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::tokens::Bytes<[u8; 32]>>
    {
      self
        .instance
        .view_method([162, 23, 253, 223], ())
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn revoke_role(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([213, 71, 116, 31], (role, account))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn renounce_role(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([54, 86, 138, 190], (role, account))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_role_admin(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::tokens::Bytes<[u8; 32]>>
    {
      self
        .instance
        .view_method([36, 138, 156, 163], (role,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn get_role_member_count(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([202, 21, 200, 115], (role,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn set_role_admin(
      &self,
      role_id: self::ethcontract::tokens::Bytes<[u8; 32]>,
      admin_role_id: self::ethcontract::tokens::Bytes<[u8; 32]>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([30, 78, 0, 145], (role_id, admin_role_id))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn grant_role(
      &self,
      role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      account: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([47, 47, 241, 93], (role, account))
        .expect("generated call")
    }
  }
  impl std::ops::Deref for Contract {
    type Target = Methods;
    fn deref(&self) -> &Self::Target {
      &self.methods
    }
  }
  #[doc = r" Module containing all generated data models for this contract's"]
  #[doc = r" events."]
  pub mod event_data {
    use super::ethcontract;
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct RoleRevoked {
      pub role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      pub account: self::ethcontract::Address,
      pub sender: self::ethcontract::Address,
    }
    impl RoleRevoked {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          246, 57, 31, 92, 50, 217, 198, 157, 42, 71, 234, 103, 11, 68, 41, 116, 181, 57, 53, 209,
          237, 199, 253, 100, 235, 33, 224, 71, 168, 57, 23, 27,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`RoleRevoked(bytes32,address,address)`"]
      pub fn abi_signature() -> &'static str {
        "RoleRevoked(bytes32,address,address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for RoleRevoked {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (role, account, sender) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(RoleRevoked {
          role,
          account,
          sender,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct RoleGranted {
      pub role: self::ethcontract::tokens::Bytes<[u8; 32]>,
      pub account: self::ethcontract::Address,
      pub sender: self::ethcontract::Address,
    }
    impl RoleGranted {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          47, 135, 136, 17, 126, 126, 255, 29, 130, 233, 38, 236, 121, 73, 1, 209, 124, 120, 2, 74,
          80, 39, 9, 64, 48, 69, 64, 167, 51, 101, 111, 13,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`RoleGranted(bytes32,address,address)`"]
      pub fn abi_signature() -> &'static str {
        "RoleGranted(bytes32,address,address)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for RoleGranted {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (role, account, sender) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(RoleGranted {
          role,
          account,
          sender,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
  }
  impl Contract {
    #[doc = r" Retrieves a handle to a type containing for creating event"]
    #[doc = r" streams for all the contract events."]
    pub fn events(&self) -> Events<'_> {
      Events {
        instance: self.raw_instance(),
      }
    }
  }
  pub struct Events<'a> {
    instance: &'a self::ethcontract::dyns::DynInstance,
  }
  impl Events<'_> {
    #[doc = r" Generated by `ethcontract`."]
    pub fn role_revoked(&self) -> self::event_builders::RoleRevokedBuilder {
      self::event_builders::RoleRevokedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            246, 57, 31, 92, 50, 217, 198, 157, 42, 71, 234, 103, 11, 68, 41, 116, 181, 57, 53,
            209, 237, 199, 253, 100, 235, 33, 224, 71, 168, 57, 23, 27,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn role_granted(&self) -> self::event_builders::RoleGrantedBuilder {
      self::event_builders::RoleGrantedBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            47, 135, 136, 17, 126, 126, 255, 29, 130, 233, 38, 236, 121, 73, 1, 209, 124, 120, 2,
            74, 80, 39, 9, 64, 48, 69, 64, 167, 51, 101, 111, 13,
          ]))
          .expect("generated event filter"),
      )
    }
  }
  #[doc = r" Module containing the generated event stream builders with type safe"]
  #[doc = r" filter methods for this contract's events."]
  pub mod event_builders {
    use super::ethcontract;
    use super::event_data;
    #[doc = "A builder for creating a filtered stream of `RoleRevoked` events."]
    pub struct RoleRevokedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RoleRevoked>,
    );
    impl RoleRevokedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the role event parameter."]
      pub fn role(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::tokens::Bytes<[u8; 32]>>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the account event parameter."]
      pub fn account(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the sender event parameter."]
      pub fn sender(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::RoleRevoked>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::RoleRevoked>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `RoleGranted` events."]
    pub struct RoleGrantedBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RoleGranted>,
    );
    impl RoleGrantedBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the role event parameter."]
      pub fn role(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::tokens::Bytes<[u8; 32]>>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the account event parameter."]
      pub fn account(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the sender event parameter."]
      pub fn sender(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::RoleGranted>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::RoleGranted>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
  }
  impl Contract {
    #[doc = r" Returns a log stream with all events."]
    pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
      self::ethcontract::dyns::DynAllEventsBuilder::new(
        self.raw_instance().web3(),
        self.address(),
        self.deployment_information(),
      )
    }
  }
  #[doc = r" A contract event."]
  #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
  pub enum Event {
    RoleGranted(self::event_data::RoleGranted),
    RoleRevoked(self::event_data::RoleRevoked),
  }
  impl self::ethcontract::contract::ParseLog for Event {
    fn parse_log(
      log: self::ethcontract::RawLog,
    ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
      let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([47 , 135 , 136 , 17 , 126 , 126 , 255 , 29 , 130 , 233 , 38 , 236 , 121 , 73 , 1 , 209 , 124 , 120 , 2 , 74 , 80 , 39 , 9 , 64 , 48 , 69 , 64 , 167 , 51 , 101 , 111 , 13]) => Ok (Event :: RoleGranted (log . clone () . decode (Contract :: raw_contract () . abi . event ("RoleGranted") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([246 , 57 , 31 , 92 , 50 , 217 , 198 , 157 , 42 , 71 , 234 , 103 , 11 , 68 , 41 , 116 , 181 , 57 , 53 , 209 , 237 , 199 , 253 , 100 , 235 , 33 , 224 , 71 , 168 , 57 , 23 , 27]) => Ok (Event :: RoleRevoked (log . clone () . decode (Contract :: raw_contract () . abi . event ("RoleRevoked") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
      if let Some(Ok(data)) = standard_event {
        return Ok(data);
      }
      Err(self::ethcontract::errors::ExecutionError::from(
        self::ethcontract::common::abi::Error::InvalidData,
      ))
    }
  }
}
pub use self::access_control_mock::Contract as AccessControlMock;
