#[allow(dead_code)]
pub mod token {
    # [rustfmt :: skip] use ethcontract as ethcontract ;
    #[doc = "Generated by `ethcontract`"]
    #[derive(Clone)]
    pub struct Contract {
        methods: Methods,
    }
    impl Contract {
        #[doc = r" Retrieves the raw contract instance used to generate the type safe"]
        #[doc = r" API for this contract."]
        pub fn raw_contract() -> &'static self::ethcontract::Contract {
            use self::ethcontract::common::artifact::truffle::TruffleLoader;
            use self::ethcontract::private::lazy_static;
            use self::ethcontract::Contract;
            lazy_static! {
                pub static ref CONTRACT: Contract = {
                    # [allow (unused_mut)] let mut contract = TruffleLoader :: new () . load_contract_from_str ("{\"contractName\":\"Token\",\"abi\":[{\"type\":\"constructor\",\"inputs\":[{\"name\":\"initialRoyaltiesReceiver\",\"type\":\"address\"}]},{\"type\":\"function\",\"name\":\"transferOwnership\",\"inputs\":[{\"name\":\"newOwner\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"tokenOfOwnerByIndex\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\"},{\"name\":\"index\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"safeTransferFrom\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\"},{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"safeTransferFrom\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\"},{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"tokenId\",\"type\":\"uint256\"},{\"name\":\"_data\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"name\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"isApprovedForAll\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\"},{\"name\":\"operator\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"MAX_SUPPLY\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"renounceOwnership\",\"inputs\":[],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"royaltyInfo\",\"inputs\":[{\"name\":\"_tokenId\",\"type\":\"uint256\"},{\"name\":\"_salePrice\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"receiver\",\"type\":\"address\"},{\"name\":\"royaltyAmount\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"owner\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"setApprovalForAll\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\"},{\"name\":\"approved\",\"type\":\"bool\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"supportsInterface\",\"inputs\":[{\"name\":\"interfaceId\",\"type\":\"bytes4\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"tokensOfOwner\",\"inputs\":[{\"name\":\"_owner\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"ownerTokens\",\"type\":\"uint256[]\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"tokenURI\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"totalSupply\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"ownerOf\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"approve\",\"inputs\":[{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"royaltiesReceiver\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"getApproved\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"royaltiesPercentage\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"mint\",\"inputs\":[{\"name\":\"recipient\",\"type\":\"address\"},{\"name\":\"hash\",\"type\":\"string\"}],\"outputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"setRoyaltiesReceiver\",\"inputs\":[{\"name\":\"newRoyaltiesReceiver\",\"type\":\"address\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"symbol\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"balanceOf\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"tokenByIndex\",\"inputs\":[{\"name\":\"index\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"transferFrom\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\"},{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"event\",\"name\":\"Transfer\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\",\"indexed\":true},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true},{\"name\":\"tokenId\",\"type\":\"uint256\",\"indexed\":true}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Approval\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\",\"indexed\":true},{\"name\":\"approved\",\"type\":\"address\",\"indexed\":true},{\"name\":\"tokenId\",\"type\":\"uint256\",\"indexed\":true}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"ApprovalForAll\",\"inputs\":[{\"name\":\"owner\",\"type\":\"address\",\"indexed\":true},{\"name\":\"operator\",\"type\":\"address\",\"indexed\":true},{\"name\":\"approved\",\"type\":\"bool\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Mint\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"recipient\",\"type\":\"address\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"OwnershipTransferred\",\"inputs\":[{\"name\":\"previousOwner\",\"type\":\"address\",\"indexed\":true},{\"name\":\"newOwner\",\"type\":\"address\",\"indexed\":true}],\"anonymous\":false}],\"bytecode\":\"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\",\"networks\":{},\"devdoc\":{\"details\":null,\"methods\":{}},\"userdoc\":{\"details\":null,\"methods\":{}}}") . expect ("valid contract JSON") ;
                    contract
                };
            }
            &CONTRACT
        }
        #[doc = r" Creates a new contract instance with the specified `web3`"]
        #[doc = r" provider at the given `Address`."]
        #[doc = r""]
        #[doc = r" Note that this does not verify that a contract with a matching"]
        #[doc = r" `Abi` is actually deployed at the given address."]
        pub fn at<F, B, T>(
            web3: &self::ethcontract::web3::api::Web3<T>,
            address: self::ethcontract::Address,
        ) -> Self
        where
            F: std::future::Future<
                    Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
                > + Send
                + 'static,
            B: std::future::Future<
                    Output = Result<
                        Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
                        self::ethcontract::web3::Error,
                    >,
                > + Send
                + 'static,
            T: self::ethcontract::web3::Transport<Out = F>
                + self::ethcontract::web3::BatchTransport<Batch = B>
                + Send
                + Sync
                + 'static,
        {
            Contract::with_deployment_info(web3, address, None)
        }
        #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
        #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
        #[doc = r" This hash is used to retrieve contract related information such as the"]
        #[doc = r" creation block (which is useful for fetching all historic events)."]
        #[doc = r""]
        #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
        #[doc = r" actually deployed at the given address nor that the transaction hash,"]
        #[doc = r" when provided, is actually for this contract deployment."]
        pub fn with_deployment_info<F, B, T>(
            web3: &self::ethcontract::web3::api::Web3<T>,
            address: self::ethcontract::Address,
            deployment_information: Option<ethcontract::common::DeploymentInformation>,
        ) -> Self
        where
            F: std::future::Future<
                    Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
                > + Send
                + 'static,
            B: std::future::Future<
                    Output = Result<
                        Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
                        self::ethcontract::web3::Error,
                    >,
                > + Send
                + 'static,
            T: self::ethcontract::web3::Transport<Out = F>
                + self::ethcontract::web3::BatchTransport<Batch = B>
                + Send
                + Sync
                + 'static,
        {
            use self::ethcontract::transport::DynTransport;
            use self::ethcontract::web3::api::Web3;
            use self::ethcontract::Instance;
            let transport = DynTransport::new(web3.transport().clone());
            let web3 = Web3::new(transport);
            let abi = Self::raw_contract().abi.clone();
            let instance =
                Instance::with_deployment_info(web3, abi, address, deployment_information);
            Contract::from_raw(instance)
        }
        #[doc = r" Creates a contract from a raw instance."]
        fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
            let methods = Methods { instance };
            Contract { methods }
        }
        #[doc = r" Returns the contract address being used by this instance."]
        pub fn address(&self) -> self::ethcontract::Address {
            self.raw_instance().address()
        }
        #[doc = r" Returns the deployment information of the contract"]
        #[doc = r" if it is known, `None` otherwise."]
        pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
            self.raw_instance().deployment_information()
        }
        #[doc = r" Returns a reference to the default method options used by this"]
        #[doc = r" contract."]
        pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
            &self.raw_instance().defaults
        }
        #[doc = r" Returns a mutable reference to the default method options used"]
        #[doc = r" by this contract."]
        pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
            &mut self.raw_instance_mut().defaults
        }
        #[doc = r" Returns a reference to the raw runtime instance used by this"]
        #[doc = r" contract."]
        pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
            &self.methods.instance
        }
        #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
        #[doc = r" this contract."]
        fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
            &mut self.methods.instance
        }
    }
    impl std::fmt::Debug for Contract {
        fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
            f.debug_tuple(stringify!(Token))
                .field(&self.address())
                .finish()
        }
    }
    impl Contract {
        #[doc = "Generated by `ethcontract`"]
        #[allow(clippy::too_many_arguments)]
        pub fn builder<F, B, T>(
            web3: &self::ethcontract::web3::api::Web3<T>,
            initial_royalties_receiver: self::ethcontract::Address,
        ) -> self::ethcontract::dyns::DynDeployBuilder<Self>
        where
            F: std::future::Future<
                    Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
                > + Send
                + 'static,
            B: std::future::Future<
                    Output = Result<
                        Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
                        self::ethcontract::web3::Error,
                    >,
                > + Send
                + 'static,
            T: self::ethcontract::web3::Transport<Out = F>
                + self::ethcontract::web3::BatchTransport<Batch = B>
                + Send
                + Sync
                + 'static,
        {
            use self::ethcontract::contract::DeployBuilder;
            use self::ethcontract::dyns::DynTransport;
            use self::ethcontract::web3::api::Web3;
            let transport = DynTransport::new(web3.transport().clone());
            let web3 = Web3::new(transport);
            let bytecode = Self::raw_contract().bytecode.clone();
            DeployBuilder::new(web3, bytecode, (initial_royalties_receiver,))
                .expect("valid deployment args")
        }
    }
    impl self::ethcontract::contract::Deploy<self::ethcontract::dyns::DynTransport> for Contract {
        type Context = self::ethcontract::common::Bytecode;
        fn bytecode(cx: &Self::Context) -> &self::ethcontract::common::Bytecode {
            cx
        }
        fn abi(_: &Self::Context) -> &self::ethcontract::common::Abi {
            &Self::raw_contract().abi
        }
        fn from_deployment(
            web3: self::ethcontract::dyns::DynWeb3,
            address: self::ethcontract::Address,
            transaction_hash: self::ethcontract::H256,
            _: Self::Context,
        ) -> Self {
            Self::with_deployment_info(&web3, address, Some(transaction_hash.into()))
        }
    }
    impl Contract {
        #[doc = r" Returns an object that allows accessing typed method signatures."]
        pub fn signatures() -> Signatures {
            Signatures
        }
        #[doc = r" Retrieves a reference to type containing all the generated"]
        #[doc = r" contract methods. This can be used for methods where the name"]
        #[doc = r" would collide with a common method (like `at` or `deployed`)."]
        pub fn methods(&self) -> &Methods {
            &self.methods
        }
    }
    #[doc = r" Type containing signatures for all methods for generated contract type."]
    #[derive(Clone, Copy)]
    pub struct Signatures;
    impl Signatures {
        #[doc = "Returns signature for method `transferOwnership(address)`."]
        #[allow(clippy::type_complexity)]
        pub fn transfer_ownership(
            &self,
        ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
            self::ethcontract::contract::Signature::new([242, 253, 227, 139])
        }
        #[doc = "Returns signature for method `tokenOfOwnerByIndex(address,uint256):(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn token_of_owner_by_index(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::Address, self::ethcontract::U256),
            self::ethcontract::U256,
        > {
            self::ethcontract::contract::Signature::new([47, 116, 92, 89])
        }
        #[doc = "Returns signature for method `safeTransferFrom(address,address,uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn safe_transfer_from(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (
                self::ethcontract::Address,
                self::ethcontract::Address,
                self::ethcontract::U256,
            ),
            (),
        > {
            self::ethcontract::contract::Signature::new([66, 132, 46, 14])
        }
        #[doc = "Returns signature for method `safeTransferFrom(address,address,uint256,bytes)`."]
        #[allow(clippy::type_complexity)]
        pub fn safe_transfer_from_with_data(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (
                self::ethcontract::Address,
                self::ethcontract::Address,
                self::ethcontract::U256,
                self::ethcontract::tokens::Bytes<Vec<u8>>,
            ),
            (),
        > {
            self::ethcontract::contract::Signature::new([184, 141, 79, 222])
        }
        #[doc = "Returns signature for method `name():(string)`."]
        #[allow(clippy::type_complexity)]
        pub fn name(&self) -> self::ethcontract::contract::Signature<(), String> {
            self::ethcontract::contract::Signature::new([6, 253, 222, 3])
        }
        #[doc = "Returns signature for method `isApprovedForAll(address,address):(bool)`."]
        #[allow(clippy::type_complexity)]
        pub fn is_approved_for_all(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::Address, self::ethcontract::Address),
            bool,
        > {
            self::ethcontract::contract::Signature::new([233, 133, 233, 197])
        }
        #[doc = "Returns signature for method `MAX_SUPPLY():(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn max_supply(
            &self,
        ) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
            self::ethcontract::contract::Signature::new([50, 203, 107, 12])
        }
        #[doc = "Returns signature for method `renounceOwnership()`."]
        #[allow(clippy::type_complexity)]
        pub fn renounce_ownership(&self) -> self::ethcontract::contract::Signature<(), ()> {
            self::ethcontract::contract::Signature::new([113, 80, 24, 166])
        }
        #[doc = "Returns signature for method `royaltyInfo(uint256,uint256):(address,uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn royalty_info(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::U256, self::ethcontract::U256),
            (self::ethcontract::Address, self::ethcontract::U256),
        > {
            self::ethcontract::contract::Signature::new([42, 85, 32, 90])
        }
        #[doc = "Returns signature for method `owner():(address)`."]
        #[allow(clippy::type_complexity)]
        pub fn owner(
            &self,
        ) -> self::ethcontract::contract::Signature<(), self::ethcontract::Address> {
            self::ethcontract::contract::Signature::new([141, 165, 203, 91])
        }
        #[doc = "Returns signature for method `setApprovalForAll(address,bool)`."]
        #[allow(clippy::type_complexity)]
        pub fn set_approval_for_all(
            &self,
        ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address, bool), ()>
        {
            self::ethcontract::contract::Signature::new([162, 44, 180, 101])
        }
        #[doc = "Returns signature for method `supportsInterface(bytes4):(bool)`."]
        #[allow(clippy::type_complexity)]
        pub fn supports_interface(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::tokens::Bytes<[u8; 4]>,),
            bool,
        > {
            self::ethcontract::contract::Signature::new([1, 255, 201, 167])
        }
        #[doc = "Returns signature for method `tokensOfOwner(address):(uint256[])`."]
        #[allow(clippy::type_complexity)]
        pub fn tokens_of_owner(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::Address,),
            Vec<self::ethcontract::U256>,
        > {
            self::ethcontract::contract::Signature::new([132, 98, 21, 28])
        }
        #[doc = "Returns signature for method `tokenURI(uint256):(string)`."]
        #[allow(clippy::type_complexity)]
        pub fn token_uri(
            &self,
        ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256,), String> {
            self::ethcontract::contract::Signature::new([200, 123, 86, 221])
        }
        #[doc = "Returns signature for method `totalSupply():(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn total_supply(
            &self,
        ) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
            self::ethcontract::contract::Signature::new([24, 22, 13, 221])
        }
        #[doc = "Returns signature for method `ownerOf(uint256):(address)`."]
        #[allow(clippy::type_complexity)]
        pub fn owner_of(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::U256,),
            self::ethcontract::Address,
        > {
            self::ethcontract::contract::Signature::new([99, 82, 33, 30])
        }
        #[doc = "Returns signature for method `approve(address,uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn approve(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::Address, self::ethcontract::U256),
            (),
        > {
            self::ethcontract::contract::Signature::new([9, 94, 167, 179])
        }
        #[doc = "Returns signature for method `royaltiesReceiver():(address)`."]
        #[allow(clippy::type_complexity)]
        pub fn royalties_receiver(
            &self,
        ) -> self::ethcontract::contract::Signature<(), self::ethcontract::Address> {
            self::ethcontract::contract::Signature::new([163, 165, 27, 213])
        }
        #[doc = "Returns signature for method `getApproved(uint256):(address)`."]
        #[allow(clippy::type_complexity)]
        pub fn get_approved(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::U256,),
            self::ethcontract::Address,
        > {
            self::ethcontract::contract::Signature::new([8, 24, 18, 252])
        }
        #[doc = "Returns signature for method `royaltiesPercentage():(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn royalties_percentage(
            &self,
        ) -> self::ethcontract::contract::Signature<(), self::ethcontract::U256> {
            self::ethcontract::contract::Signature::new([202, 250, 141, 254])
        }
        #[doc = "Returns signature for method `mint(address,string):(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn mint(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::Address, String),
            self::ethcontract::U256,
        > {
            self::ethcontract::contract::Signature::new([208, 222, 245, 33])
        }
        #[doc = "Returns signature for method `setRoyaltiesReceiver(address)`."]
        #[allow(clippy::type_complexity)]
        pub fn set_royalties_receiver(
            &self,
        ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address,), ()> {
            self::ethcontract::contract::Signature::new([181, 20, 55, 21])
        }
        #[doc = "Returns signature for method `symbol():(string)`."]
        #[allow(clippy::type_complexity)]
        pub fn symbol(&self) -> self::ethcontract::contract::Signature<(), String> {
            self::ethcontract::contract::Signature::new([149, 216, 155, 65])
        }
        #[doc = "Returns signature for method `balanceOf(address):(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn balance_of(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::Address,),
            self::ethcontract::U256,
        > {
            self::ethcontract::contract::Signature::new([112, 160, 130, 49])
        }
        #[doc = "Returns signature for method `tokenByIndex(uint256):(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn token_by_index(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::U256,),
            self::ethcontract::U256,
        > {
            self::ethcontract::contract::Signature::new([79, 108, 204, 231])
        }
        #[doc = "Returns signature for method `transferFrom(address,address,uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn transfer_from(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (
                self::ethcontract::Address,
                self::ethcontract::Address,
                self::ethcontract::U256,
            ),
            (),
        > {
            self::ethcontract::contract::Signature::new([35, 184, 114, 221])
        }
    }
    #[doc = r" Type containing all contract methods for generated contract type."]
    #[derive(Clone)]
    pub struct Methods {
        instance: self::ethcontract::dyns::DynInstance,
    }
    #[allow(clippy::too_many_arguments, clippy::type_complexity)]
    impl Methods {
        #[doc = "Generated by `ethcontract`"]
        pub fn transfer_ownership(
            &self,
            new_owner: self::ethcontract::Address,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([242, 253, 227, 139], (new_owner,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn token_of_owner_by_index(
            &self,
            owner: self::ethcontract::Address,
            index: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
            self.instance
                .view_method([47, 116, 92, 89], (owner, index))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn safe_transfer_from(
            &self,
            from: self::ethcontract::Address,
            to: self::ethcontract::Address,
            token_id: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([66, 132, 46, 14], (from, to, token_id))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn safe_transfer_from_with_data(
            &self,
            from: self::ethcontract::Address,
            to: self::ethcontract::Address,
            token_id: self::ethcontract::U256,
            data: self::ethcontract::tokens::Bytes<Vec<u8>>,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([184, 141, 79, 222], (from, to, token_id, data))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn name(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<String> {
            self.instance
                .view_method([6, 253, 222, 3], ())
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn is_approved_for_all(
            &self,
            owner: self::ethcontract::Address,
            operator: self::ethcontract::Address,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
            self.instance
                .view_method([233, 133, 233, 197], (owner, operator))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn max_supply(
            &self,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
            self.instance
                .view_method([50, 203, 107, 12], ())
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn renounce_ownership(&self) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([113, 80, 24, 166], ())
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn royalty_info(
            &self,
            token_id: self::ethcontract::U256,
            sale_price: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<(
            self::ethcontract::Address,
            self::ethcontract::U256,
        )> {
            self.instance
                .view_method([42, 85, 32, 90], (token_id, sale_price))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn owner(
            &self,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
            self.instance
                .view_method([141, 165, 203, 91], ())
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn set_approval_for_all(
            &self,
            operator: self::ethcontract::Address,
            approved: bool,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([162, 44, 180, 101], (operator, approved))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn supports_interface(
            &self,
            interface_id: self::ethcontract::tokens::Bytes<[u8; 4]>,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
            self.instance
                .view_method([1, 255, 201, 167], (interface_id,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn tokens_of_owner(
            &self,
            owner: self::ethcontract::Address,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<Vec<self::ethcontract::U256>> {
            self.instance
                .view_method([132, 98, 21, 28], (owner,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn token_uri(
            &self,
            token_id: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<String> {
            self.instance
                .view_method([200, 123, 86, 221], (token_id,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn total_supply(
            &self,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
            self.instance
                .view_method([24, 22, 13, 221], ())
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn owner_of(
            &self,
            token_id: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
            self.instance
                .view_method([99, 82, 33, 30], (token_id,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn approve(
            &self,
            to: self::ethcontract::Address,
            token_id: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([9, 94, 167, 179], (to, token_id))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn royalties_receiver(
            &self,
        ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::Address> {
            self.instance
                .method([163, 165, 27, 213], ())
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn get_approved(
            &self,
            token_id: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
            self.instance
                .view_method([8, 24, 18, 252], (token_id,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn royalties_percentage(
            &self,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
            self.instance
                .view_method([202, 250, 141, 254], ())
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn mint(
            &self,
            recipient: self::ethcontract::Address,
            hash: String,
        ) -> self::ethcontract::dyns::DynMethodBuilder<self::ethcontract::U256> {
            self.instance
                .method([208, 222, 245, 33], (recipient, hash))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn set_royalties_receiver(
            &self,
            new_royalties_receiver: self::ethcontract::Address,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([181, 20, 55, 21], (new_royalties_receiver,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn symbol(&self) -> self::ethcontract::dyns::DynViewMethodBuilder<String> {
            self.instance
                .view_method([149, 216, 155, 65], ())
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn balance_of(
            &self,
            owner: self::ethcontract::Address,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
            self.instance
                .view_method([112, 160, 130, 49], (owner,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn token_by_index(
            &self,
            index: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
            self.instance
                .view_method([79, 108, 204, 231], (index,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn transfer_from(
            &self,
            from: self::ethcontract::Address,
            to: self::ethcontract::Address,
            token_id: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([35, 184, 114, 221], (from, to, token_id))
                .expect("generated call")
        }
    }
    impl std::ops::Deref for Contract {
        type Target = Methods;
        fn deref(&self) -> &Self::Target {
            &self.methods
        }
    }
    #[doc = r" Module containing all generated data models for this contract's"]
    #[doc = r" events."]
    pub mod event_data {
        use super::ethcontract;
        #[derive(
            Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize,
        )]
        pub struct Transfer {
            pub from: self::ethcontract::Address,
            pub to: self::ethcontract::Address,
            pub token_id: self::ethcontract::U256,
        }
        impl Transfer {
            #[doc = r" Retrieves the signature for the event this data corresponds to."]
            #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
            #[doc = r" this event."]
            pub fn signature() -> self::ethcontract::H256 {
                self::ethcontract::H256([
                    221, 242, 82, 173, 27, 226, 200, 155, 105, 194, 176, 104, 252, 55, 141, 170,
                    149, 43, 167, 241, 99, 196, 161, 22, 40, 245, 90, 77, 245, 35, 179, 239,
                ])
            }
            #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
            #[doc = r" to. For this event the value should always be:"]
            #[doc = r""]
            #[doc = "`Transfer(address,address,uint256)`"]
            pub fn abi_signature() -> &'static str {
                "Transfer(address,address,uint256)"
            }
        }
        impl self::ethcontract::tokens::Tokenize for Transfer {
            fn from_token(
                token: self::ethcontract::common::abi::Token,
            ) -> Result<Self, self::ethcontract::tokens::Error> {
                let (from, to, token_id) = self::ethcontract::tokens::Tokenize::from_token(token)?;
                Ok(Transfer { from, to, token_id })
            }
            fn into_token(self) -> self::ethcontract::common::abi::Token {
                unimplemented!("events are only decoded, not encoded")
            }
        }
        #[derive(
            Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize,
        )]
        pub struct Approval {
            pub owner: self::ethcontract::Address,
            pub approved: self::ethcontract::Address,
            pub token_id: self::ethcontract::U256,
        }
        impl Approval {
            #[doc = r" Retrieves the signature for the event this data corresponds to."]
            #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
            #[doc = r" this event."]
            pub fn signature() -> self::ethcontract::H256 {
                self::ethcontract::H256([
                    140, 91, 225, 229, 235, 236, 125, 91, 209, 79, 113, 66, 125, 30, 132, 243, 221,
                    3, 20, 192, 247, 178, 41, 30, 91, 32, 10, 200, 199, 195, 185, 37,
                ])
            }
            #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
            #[doc = r" to. For this event the value should always be:"]
            #[doc = r""]
            #[doc = "`Approval(address,address,uint256)`"]
            pub fn abi_signature() -> &'static str {
                "Approval(address,address,uint256)"
            }
        }
        impl self::ethcontract::tokens::Tokenize for Approval {
            fn from_token(
                token: self::ethcontract::common::abi::Token,
            ) -> Result<Self, self::ethcontract::tokens::Error> {
                let (owner, approved, token_id) =
                    self::ethcontract::tokens::Tokenize::from_token(token)?;
                Ok(Approval {
                    owner,
                    approved,
                    token_id,
                })
            }
            fn into_token(self) -> self::ethcontract::common::abi::Token {
                unimplemented!("events are only decoded, not encoded")
            }
        }
        #[derive(
            Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize,
        )]
        pub struct ApprovalForAll {
            pub owner: self::ethcontract::Address,
            pub operator: self::ethcontract::Address,
            pub approved: bool,
        }
        impl ApprovalForAll {
            #[doc = r" Retrieves the signature for the event this data corresponds to."]
            #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
            #[doc = r" this event."]
            pub fn signature() -> self::ethcontract::H256 {
                self::ethcontract::H256([
                    23, 48, 126, 171, 57, 171, 97, 7, 232, 137, 152, 69, 173, 61, 89, 189, 150, 83,
                    242, 0, 242, 32, 146, 4, 137, 202, 43, 89, 55, 105, 108, 49,
                ])
            }
            #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
            #[doc = r" to. For this event the value should always be:"]
            #[doc = r""]
            #[doc = "`ApprovalForAll(address,address,bool)`"]
            pub fn abi_signature() -> &'static str {
                "ApprovalForAll(address,address,bool)"
            }
        }
        impl self::ethcontract::tokens::Tokenize for ApprovalForAll {
            fn from_token(
                token: self::ethcontract::common::abi::Token,
            ) -> Result<Self, self::ethcontract::tokens::Error> {
                let (owner, operator, approved) =
                    self::ethcontract::tokens::Tokenize::from_token(token)?;
                Ok(ApprovalForAll {
                    owner,
                    operator,
                    approved,
                })
            }
            fn into_token(self) -> self::ethcontract::common::abi::Token {
                unimplemented!("events are only decoded, not encoded")
            }
        }
        #[derive(
            Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize,
        )]
        pub struct Mint {
            pub token_id: self::ethcontract::U256,
            pub recipient: self::ethcontract::Address,
        }
        impl Mint {
            #[doc = r" Retrieves the signature for the event this data corresponds to."]
            #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
            #[doc = r" this event."]
            pub fn signature() -> self::ethcontract::H256 {
                self::ethcontract::H256([
                    243, 206, 165, 73, 61, 121, 10, 240, 19, 56, 23, 96, 111, 115, 80, 169, 29,
                    127, 21, 78, 165, 46, 170, 121, 209, 121, 212, 210, 49, 229, 1, 2,
                ])
            }
            #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
            #[doc = r" to. For this event the value should always be:"]
            #[doc = r""]
            #[doc = "`Mint(uint256,address)`"]
            pub fn abi_signature() -> &'static str {
                "Mint(uint256,address)"
            }
        }
        impl self::ethcontract::tokens::Tokenize for Mint {
            fn from_token(
                token: self::ethcontract::common::abi::Token,
            ) -> Result<Self, self::ethcontract::tokens::Error> {
                let (token_id, recipient) = self::ethcontract::tokens::Tokenize::from_token(token)?;
                Ok(Mint {
                    token_id,
                    recipient,
                })
            }
            fn into_token(self) -> self::ethcontract::common::abi::Token {
                unimplemented!("events are only decoded, not encoded")
            }
        }
        #[derive(
            Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize,
        )]
        pub struct OwnershipTransferred {
            pub previous_owner: self::ethcontract::Address,
            pub new_owner: self::ethcontract::Address,
        }
        impl OwnershipTransferred {
            #[doc = r" Retrieves the signature for the event this data corresponds to."]
            #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
            #[doc = r" this event."]
            pub fn signature() -> self::ethcontract::H256 {
                self::ethcontract::H256([
                    139, 224, 7, 156, 83, 22, 89, 20, 19, 68, 205, 31, 208, 164, 242, 132, 25, 73,
                    127, 151, 34, 163, 218, 175, 227, 180, 24, 111, 107, 100, 87, 224,
                ])
            }
            #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
            #[doc = r" to. For this event the value should always be:"]
            #[doc = r""]
            #[doc = "`OwnershipTransferred(address,address)`"]
            pub fn abi_signature() -> &'static str {
                "OwnershipTransferred(address,address)"
            }
        }
        impl self::ethcontract::tokens::Tokenize for OwnershipTransferred {
            fn from_token(
                token: self::ethcontract::common::abi::Token,
            ) -> Result<Self, self::ethcontract::tokens::Error> {
                let (previous_owner, new_owner) =
                    self::ethcontract::tokens::Tokenize::from_token(token)?;
                Ok(OwnershipTransferred {
                    previous_owner,
                    new_owner,
                })
            }
            fn into_token(self) -> self::ethcontract::common::abi::Token {
                unimplemented!("events are only decoded, not encoded")
            }
        }
    }
    impl Contract {
        #[doc = r" Retrieves a handle to a type containing for creating event"]
        #[doc = r" streams for all the contract events."]
        pub fn events(&self) -> Events<'_> {
            Events {
                instance: self.raw_instance(),
            }
        }
    }
    pub struct Events<'a> {
        instance: &'a self::ethcontract::dyns::DynInstance,
    }
    impl Events<'_> {
        #[doc = r" Generated by `ethcontract`."]
        pub fn transfer(&self) -> self::event_builders::TransferBuilder {
            self::event_builders::TransferBuilder(
                self.instance
                    .event(self::ethcontract::H256([
                        221, 242, 82, 173, 27, 226, 200, 155, 105, 194, 176, 104, 252, 55, 141,
                        170, 149, 43, 167, 241, 99, 196, 161, 22, 40, 245, 90, 77, 245, 35, 179,
                        239,
                    ]))
                    .expect("generated event filter"),
            )
        }
        #[doc = r" Generated by `ethcontract`."]
        pub fn approval(&self) -> self::event_builders::ApprovalBuilder {
            self::event_builders::ApprovalBuilder(
                self.instance
                    .event(self::ethcontract::H256([
                        140, 91, 225, 229, 235, 236, 125, 91, 209, 79, 113, 66, 125, 30, 132, 243,
                        221, 3, 20, 192, 247, 178, 41, 30, 91, 32, 10, 200, 199, 195, 185, 37,
                    ]))
                    .expect("generated event filter"),
            )
        }
        #[doc = r" Generated by `ethcontract`."]
        pub fn approval_for_all(&self) -> self::event_builders::ApprovalForAllBuilder {
            self::event_builders::ApprovalForAllBuilder(
                self.instance
                    .event(self::ethcontract::H256([
                        23, 48, 126, 171, 57, 171, 97, 7, 232, 137, 152, 69, 173, 61, 89, 189, 150,
                        83, 242, 0, 242, 32, 146, 4, 137, 202, 43, 89, 55, 105, 108, 49,
                    ]))
                    .expect("generated event filter"),
            )
        }
        #[doc = r" Generated by `ethcontract`."]
        pub fn mint(&self) -> self::event_builders::MintBuilder {
            self::event_builders::MintBuilder(
                self.instance
                    .event(self::ethcontract::H256([
                        243, 206, 165, 73, 61, 121, 10, 240, 19, 56, 23, 96, 111, 115, 80, 169, 29,
                        127, 21, 78, 165, 46, 170, 121, 209, 121, 212, 210, 49, 229, 1, 2,
                    ]))
                    .expect("generated event filter"),
            )
        }
        #[doc = r" Generated by `ethcontract`."]
        pub fn ownership_transferred(&self) -> self::event_builders::OwnershipTransferredBuilder {
            self::event_builders::OwnershipTransferredBuilder(
                self.instance
                    .event(self::ethcontract::H256([
                        139, 224, 7, 156, 83, 22, 89, 20, 19, 68, 205, 31, 208, 164, 242, 132, 25,
                        73, 127, 151, 34, 163, 218, 175, 227, 180, 24, 111, 107, 100, 87, 224,
                    ]))
                    .expect("generated event filter"),
            )
        }
    }
    #[doc = r" Module containing the generated event stream builders with type safe"]
    #[doc = r" filter methods for this contract's events."]
    pub mod event_builders {
        use super::ethcontract;
        use super::event_data;
        #[doc = "A builder for creating a filtered stream of `Transfer` events."]
        pub struct TransferBuilder(
            #[doc = r" The inner event builder."]
            pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Transfer>,
        );
        impl TransferBuilder {
            #[doc = r" Sets the starting block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the latest block."]
            #[allow(clippy::wrong_self_convention)]
            pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).from_block(block);
                self
            }
            #[doc = r" Sets the last block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the streaming until the end of days."]
            #[allow(clippy::wrong_self_convention)]
            pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).to_block(block);
                self
            }
            #[doc = r" Limits the number of events that can be retrieved by this filter."]
            #[doc = r""]
            #[doc = r" Note that this parameter is non-standard."]
            pub fn limit(mut self, value: usize) -> Self {
                self.0 = (self.0).limit(value);
                self
            }
            #[doc = r" Sets the polling interval. This is used as the interval between"]
            #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
            pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
                self.0 = (self.0).poll_interval(value);
                self
            }
            #[doc = "Adds a filter for the from event parameter."]
            pub fn from(
                mut self,
                topic: self::ethcontract::Topic<self::ethcontract::Address>,
            ) -> Self {
                self.0 = (self.0).topic0(topic);
                self
            }
            #[doc = "Adds a filter for the to event parameter."]
            pub fn to(
                mut self,
                topic: self::ethcontract::Topic<self::ethcontract::Address>,
            ) -> Self {
                self.0 = (self.0).topic1(topic);
                self
            }
            #[doc = "Adds a filter for the tokenId event parameter."]
            pub fn token_id(
                mut self,
                topic: self::ethcontract::Topic<self::ethcontract::U256>,
            ) -> Self {
                self.0 = (self.0).topic2(topic);
                self
            }
            #[doc = r" Returns a future that resolves with a collection of all existing"]
            #[doc = r" logs matching the builder parameters."]
            pub async fn query(
                self,
            ) -> std::result::Result<
                std::vec::Vec<self::ethcontract::Event<self::event_data::Transfer>>,
                self::ethcontract::errors::EventError,
            > {
                (self.0).query().await
            }
            #[doc = r" Creates an event stream from the current event builder."]
            pub fn stream(
                self,
            ) -> impl self::ethcontract::futures::stream::Stream<
                Item = std::result::Result<
                    self::ethcontract::StreamEvent<self::event_data::Transfer>,
                    self::ethcontract::errors::EventError,
                >,
            > {
                (self.0).stream()
            }
        }
        #[doc = "A builder for creating a filtered stream of `Approval` events."]
        pub struct ApprovalBuilder(
            #[doc = r" The inner event builder."]
            pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Approval>,
        );
        impl ApprovalBuilder {
            #[doc = r" Sets the starting block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the latest block."]
            #[allow(clippy::wrong_self_convention)]
            pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).from_block(block);
                self
            }
            #[doc = r" Sets the last block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the streaming until the end of days."]
            #[allow(clippy::wrong_self_convention)]
            pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).to_block(block);
                self
            }
            #[doc = r" Limits the number of events that can be retrieved by this filter."]
            #[doc = r""]
            #[doc = r" Note that this parameter is non-standard."]
            pub fn limit(mut self, value: usize) -> Self {
                self.0 = (self.0).limit(value);
                self
            }
            #[doc = r" Sets the polling interval. This is used as the interval between"]
            #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
            pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
                self.0 = (self.0).poll_interval(value);
                self
            }
            #[doc = "Adds a filter for the owner event parameter."]
            pub fn owner(
                mut self,
                topic: self::ethcontract::Topic<self::ethcontract::Address>,
            ) -> Self {
                self.0 = (self.0).topic0(topic);
                self
            }
            #[doc = "Adds a filter for the approved event parameter."]
            pub fn approved(
                mut self,
                topic: self::ethcontract::Topic<self::ethcontract::Address>,
            ) -> Self {
                self.0 = (self.0).topic1(topic);
                self
            }
            #[doc = "Adds a filter for the tokenId event parameter."]
            pub fn token_id(
                mut self,
                topic: self::ethcontract::Topic<self::ethcontract::U256>,
            ) -> Self {
                self.0 = (self.0).topic2(topic);
                self
            }
            #[doc = r" Returns a future that resolves with a collection of all existing"]
            #[doc = r" logs matching the builder parameters."]
            pub async fn query(
                self,
            ) -> std::result::Result<
                std::vec::Vec<self::ethcontract::Event<self::event_data::Approval>>,
                self::ethcontract::errors::EventError,
            > {
                (self.0).query().await
            }
            #[doc = r" Creates an event stream from the current event builder."]
            pub fn stream(
                self,
            ) -> impl self::ethcontract::futures::stream::Stream<
                Item = std::result::Result<
                    self::ethcontract::StreamEvent<self::event_data::Approval>,
                    self::ethcontract::errors::EventError,
                >,
            > {
                (self.0).stream()
            }
        }
        #[doc = "A builder for creating a filtered stream of `ApprovalForAll` events."]
        pub struct ApprovalForAllBuilder(
            #[doc = r" The inner event builder."]
            pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::ApprovalForAll>,
        );
        impl ApprovalForAllBuilder {
            #[doc = r" Sets the starting block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the latest block."]
            #[allow(clippy::wrong_self_convention)]
            pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).from_block(block);
                self
            }
            #[doc = r" Sets the last block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the streaming until the end of days."]
            #[allow(clippy::wrong_self_convention)]
            pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).to_block(block);
                self
            }
            #[doc = r" Limits the number of events that can be retrieved by this filter."]
            #[doc = r""]
            #[doc = r" Note that this parameter is non-standard."]
            pub fn limit(mut self, value: usize) -> Self {
                self.0 = (self.0).limit(value);
                self
            }
            #[doc = r" Sets the polling interval. This is used as the interval between"]
            #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
            pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
                self.0 = (self.0).poll_interval(value);
                self
            }
            #[doc = "Adds a filter for the owner event parameter."]
            pub fn owner(
                mut self,
                topic: self::ethcontract::Topic<self::ethcontract::Address>,
            ) -> Self {
                self.0 = (self.0).topic0(topic);
                self
            }
            #[doc = "Adds a filter for the operator event parameter."]
            pub fn operator(
                mut self,
                topic: self::ethcontract::Topic<self::ethcontract::Address>,
            ) -> Self {
                self.0 = (self.0).topic1(topic);
                self
            }
            #[doc = r" Returns a future that resolves with a collection of all existing"]
            #[doc = r" logs matching the builder parameters."]
            pub async fn query(
                self,
            ) -> std::result::Result<
                std::vec::Vec<self::ethcontract::Event<self::event_data::ApprovalForAll>>,
                self::ethcontract::errors::EventError,
            > {
                (self.0).query().await
            }
            #[doc = r" Creates an event stream from the current event builder."]
            pub fn stream(
                self,
            ) -> impl self::ethcontract::futures::stream::Stream<
                Item = std::result::Result<
                    self::ethcontract::StreamEvent<self::event_data::ApprovalForAll>,
                    self::ethcontract::errors::EventError,
                >,
            > {
                (self.0).stream()
            }
        }
        #[doc = "A builder for creating a filtered stream of `Mint` events."]
        pub struct MintBuilder(
            #[doc = r" The inner event builder."]
            pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Mint>,
        );
        impl MintBuilder {
            #[doc = r" Sets the starting block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the latest block."]
            #[allow(clippy::wrong_self_convention)]
            pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).from_block(block);
                self
            }
            #[doc = r" Sets the last block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the streaming until the end of days."]
            #[allow(clippy::wrong_self_convention)]
            pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).to_block(block);
                self
            }
            #[doc = r" Limits the number of events that can be retrieved by this filter."]
            #[doc = r""]
            #[doc = r" Note that this parameter is non-standard."]
            pub fn limit(mut self, value: usize) -> Self {
                self.0 = (self.0).limit(value);
                self
            }
            #[doc = r" Sets the polling interval. This is used as the interval between"]
            #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
            pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
                self.0 = (self.0).poll_interval(value);
                self
            }
            #[doc = r" Returns a future that resolves with a collection of all existing"]
            #[doc = r" logs matching the builder parameters."]
            pub async fn query(
                self,
            ) -> std::result::Result<
                std::vec::Vec<self::ethcontract::Event<self::event_data::Mint>>,
                self::ethcontract::errors::EventError,
            > {
                (self.0).query().await
            }
            #[doc = r" Creates an event stream from the current event builder."]
            pub fn stream(
                self,
            ) -> impl self::ethcontract::futures::stream::Stream<
                Item = std::result::Result<
                    self::ethcontract::StreamEvent<self::event_data::Mint>,
                    self::ethcontract::errors::EventError,
                >,
            > {
                (self.0).stream()
            }
        }
        #[doc = "A builder for creating a filtered stream of `OwnershipTransferred` events."]
        pub struct OwnershipTransferredBuilder(
            #[doc = r" The inner event builder."]
            pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::OwnershipTransferred>,
        );
        impl OwnershipTransferredBuilder {
            #[doc = r" Sets the starting block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the latest block."]
            #[allow(clippy::wrong_self_convention)]
            pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).from_block(block);
                self
            }
            #[doc = r" Sets the last block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the streaming until the end of days."]
            #[allow(clippy::wrong_self_convention)]
            pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).to_block(block);
                self
            }
            #[doc = r" Limits the number of events that can be retrieved by this filter."]
            #[doc = r""]
            #[doc = r" Note that this parameter is non-standard."]
            pub fn limit(mut self, value: usize) -> Self {
                self.0 = (self.0).limit(value);
                self
            }
            #[doc = r" Sets the polling interval. This is used as the interval between"]
            #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
            pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
                self.0 = (self.0).poll_interval(value);
                self
            }
            #[doc = "Adds a filter for the previousOwner event parameter."]
            pub fn previous_owner(
                mut self,
                topic: self::ethcontract::Topic<self::ethcontract::Address>,
            ) -> Self {
                self.0 = (self.0).topic0(topic);
                self
            }
            #[doc = "Adds a filter for the newOwner event parameter."]
            pub fn new_owner(
                mut self,
                topic: self::ethcontract::Topic<self::ethcontract::Address>,
            ) -> Self {
                self.0 = (self.0).topic1(topic);
                self
            }
            #[doc = r" Returns a future that resolves with a collection of all existing"]
            #[doc = r" logs matching the builder parameters."]
            pub async fn query(
                self,
            ) -> std::result::Result<
                std::vec::Vec<self::ethcontract::Event<self::event_data::OwnershipTransferred>>,
                self::ethcontract::errors::EventError,
            > {
                (self.0).query().await
            }
            #[doc = r" Creates an event stream from the current event builder."]
            pub fn stream(
                self,
            ) -> impl self::ethcontract::futures::stream::Stream<
                Item = std::result::Result<
                    self::ethcontract::StreamEvent<self::event_data::OwnershipTransferred>,
                    self::ethcontract::errors::EventError,
                >,
            > {
                (self.0).stream()
            }
        }
    }
    impl Contract {
        #[doc = r" Returns a log stream with all events."]
        pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
            self::ethcontract::dyns::DynAllEventsBuilder::new(
                self.raw_instance().web3(),
                self.address(),
                self.deployment_information(),
            )
        }
    }
    #[doc = r" A contract event."]
    #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub enum Event {
        Approval(self::event_data::Approval),
        ApprovalForAll(self::event_data::ApprovalForAll),
        Mint(self::event_data::Mint),
        OwnershipTransferred(self::event_data::OwnershipTransferred),
        Transfer(self::event_data::Transfer),
    }
    impl self::ethcontract::contract::ParseLog for Event {
        fn parse_log(
            log: self::ethcontract::RawLog,
        ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
            let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([140 , 91 , 225 , 229 , 235 , 236 , 125 , 91 , 209 , 79 , 113 , 66 , 125 , 30 , 132 , 243 , 221 , 3 , 20 , 192 , 247 , 178 , 41 , 30 , 91 , 32 , 10 , 200 , 199 , 195 , 185 , 37]) => Ok (Event :: Approval (log . clone () . decode (Contract :: raw_contract () . abi . event ("Approval") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([23 , 48 , 126 , 171 , 57 , 171 , 97 , 7 , 232 , 137 , 152 , 69 , 173 , 61 , 89 , 189 , 150 , 83 , 242 , 0 , 242 , 32 , 146 , 4 , 137 , 202 , 43 , 89 , 55 , 105 , 108 , 49]) => Ok (Event :: ApprovalForAll (log . clone () . decode (Contract :: raw_contract () . abi . event ("ApprovalForAll") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([243 , 206 , 165 , 73 , 61 , 121 , 10 , 240 , 19 , 56 , 23 , 96 , 111 , 115 , 80 , 169 , 29 , 127 , 21 , 78 , 165 , 46 , 170 , 121 , 209 , 121 , 212 , 210 , 49 , 229 , 1 , 2]) => Ok (Event :: Mint (log . clone () . decode (Contract :: raw_contract () . abi . event ("Mint") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([139 , 224 , 7 , 156 , 83 , 22 , 89 , 20 , 19 , 68 , 205 , 31 , 208 , 164 , 242 , 132 , 25 , 73 , 127 , 151 , 34 , 163 , 218 , 175 , 227 , 180 , 24 , 111 , 107 , 100 , 87 , 224]) => Ok (Event :: OwnershipTransferred (log . clone () . decode (Contract :: raw_contract () . abi . event ("OwnershipTransferred") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([221 , 242 , 82 , 173 , 27 , 226 , 200 , 155 , 105 , 194 , 176 , 104 , 252 , 55 , 141 , 170 , 149 , 43 , 167 , 241 , 99 , 196 , 161 , 22 , 40 , 245 , 90 , 77 , 245 , 35 , 179 , 239]) => Ok (Event :: Transfer (log . clone () . decode (Contract :: raw_contract () . abi . event ("Transfer") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
            if let Some(Ok(data)) = standard_event {
                return Ok(data);
            }
            Err(self::ethcontract::errors::ExecutionError::from(
                self::ethcontract::common::abi::Error::InvalidData,
            ))
        }
    }
}
pub use self::token::Contract as Token;
