#[allow(dead_code)]
pub mod marketplace {
    # [rustfmt :: skip] use ethcontract as ethcontract ;
    #[doc = "Generated by `ethcontract`"]
    #[derive(Clone)]
    pub struct Contract {
        methods: Methods,
    }
    impl Contract {
        #[doc = r" Retrieves the raw contract instance used to generate the type safe"]
        #[doc = r" API for this contract."]
        pub fn raw_contract() -> &'static self::ethcontract::Contract {
            use self::ethcontract::common::artifact::truffle::TruffleLoader;
            use self::ethcontract::private::lazy_static;
            use self::ethcontract::Contract;
            lazy_static! {
                pub static ref CONTRACT: Contract = {
                    # [allow (unused_mut)] let mut contract = TruffleLoader :: new () . load_contract_from_str ("{\"contractName\":\"Marketplace\",\"abi\":[{\"type\":\"constructor\",\"inputs\":[{\"name\":\"tokenContractAddress\",\"type\":\"address\"}]},{\"type\":\"function\",\"name\":\"_tokenContractAddress\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"buyOffersEscrow\",\"inputs\":[{\"name\":\"\",\"type\":\"address\"},{\"name\":\"\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"makeBuyOffer\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"acceptBuyOffer\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"activeBuyOffers\",\"inputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"buyer\",\"type\":\"address\"},{\"name\":\"price\",\"type\":\"uint256\"},{\"name\":\"createTime\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"withdrawBuyOffer\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"purchase\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"activeSellOffers\",\"inputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"seller\",\"type\":\"address\"},{\"name\":\"minPrice\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"makeSellOffer\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"},{\"name\":\"minPrice\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"withdrawSellOffer\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"event\",\"name\":\"NewBuyOffer\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"buyer\",\"type\":\"address\",\"indexed\":false},{\"name\":\"value\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"SellOfferWithdrawn\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"seller\",\"type\":\"address\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"RoyaltiesPaid\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"value\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"BuyOfferWithdrawn\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"buyer\",\"type\":\"address\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"NewSellOffer\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"seller\",\"type\":\"address\",\"indexed\":false},{\"name\":\"value\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Sale\",\"inputs\":[{\"name\":\"tokenId\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"seller\",\"type\":\"address\",\"indexed\":false},{\"name\":\"buyer\",\"type\":\"address\",\"indexed\":false},{\"name\":\"value\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false}],\"bytecode\":\"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\",\"networks\":{},\"devdoc\":{\"details\":null,\"methods\":{}},\"userdoc\":{\"details\":null,\"methods\":{}}}") . expect ("valid contract JSON") ;
                    contract
                };
            }
            &CONTRACT
        }
        #[doc = r" Creates a new contract instance with the specified `web3`"]
        #[doc = r" provider at the given `Address`."]
        #[doc = r""]
        #[doc = r" Note that this does not verify that a contract with a matching"]
        #[doc = r" `Abi` is actually deployed at the given address."]
        pub fn at<F, B, T>(
            web3: &self::ethcontract::web3::api::Web3<T>,
            address: self::ethcontract::Address,
        ) -> Self
        where
            F: std::future::Future<
                    Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
                > + Send
                + 'static,
            B: std::future::Future<
                    Output = Result<
                        Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
                        self::ethcontract::web3::Error,
                    >,
                > + Send
                + 'static,
            T: self::ethcontract::web3::Transport<Out = F>
                + self::ethcontract::web3::BatchTransport<Batch = B>
                + Send
                + Sync
                + 'static,
        {
            Contract::with_deployment_info(web3, address, None)
        }
        #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
        #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
        #[doc = r" This hash is used to retrieve contract related information such as the"]
        #[doc = r" creation block (which is useful for fetching all historic events)."]
        #[doc = r""]
        #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
        #[doc = r" actually deployed at the given address nor that the transaction hash,"]
        #[doc = r" when provided, is actually for this contract deployment."]
        pub fn with_deployment_info<F, B, T>(
            web3: &self::ethcontract::web3::api::Web3<T>,
            address: self::ethcontract::Address,
            deployment_information: Option<ethcontract::common::DeploymentInformation>,
        ) -> Self
        where
            F: std::future::Future<
                    Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
                > + Send
                + 'static,
            B: std::future::Future<
                    Output = Result<
                        Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
                        self::ethcontract::web3::Error,
                    >,
                > + Send
                + 'static,
            T: self::ethcontract::web3::Transport<Out = F>
                + self::ethcontract::web3::BatchTransport<Batch = B>
                + Send
                + Sync
                + 'static,
        {
            use self::ethcontract::transport::DynTransport;
            use self::ethcontract::web3::api::Web3;
            use self::ethcontract::Instance;
            let transport = DynTransport::new(web3.transport().clone());
            let web3 = Web3::new(transport);
            let abi = Self::raw_contract().abi.clone();
            let instance =
                Instance::with_deployment_info(web3, abi, address, deployment_information);
            Contract::from_raw(instance)
        }
        #[doc = r" Creates a contract from a raw instance."]
        fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
            let methods = Methods { instance };
            Contract { methods }
        }
        #[doc = r" Returns the contract address being used by this instance."]
        pub fn address(&self) -> self::ethcontract::Address {
            self.raw_instance().address()
        }
        #[doc = r" Returns the deployment information of the contract"]
        #[doc = r" if it is known, `None` otherwise."]
        pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
            self.raw_instance().deployment_information()
        }
        #[doc = r" Returns a reference to the default method options used by this"]
        #[doc = r" contract."]
        pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
            &self.raw_instance().defaults
        }
        #[doc = r" Returns a mutable reference to the default method options used"]
        #[doc = r" by this contract."]
        pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
            &mut self.raw_instance_mut().defaults
        }
        #[doc = r" Returns a reference to the raw runtime instance used by this"]
        #[doc = r" contract."]
        pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
            &self.methods.instance
        }
        #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
        #[doc = r" this contract."]
        fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
            &mut self.methods.instance
        }
    }
    impl std::fmt::Debug for Contract {
        fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
            f.debug_tuple(stringify!(Marketplace))
                .field(&self.address())
                .finish()
        }
    }
    impl Contract {
        #[doc = "Generated by `ethcontract`"]
        #[allow(clippy::too_many_arguments)]
        pub fn builder<F, B, T>(
            web3: &self::ethcontract::web3::api::Web3<T>,
            token_contract_address: self::ethcontract::Address,
        ) -> self::ethcontract::dyns::DynDeployBuilder<Self>
        where
            F: std::future::Future<
                    Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
                > + Send
                + 'static,
            B: std::future::Future<
                    Output = Result<
                        Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
                        self::ethcontract::web3::Error,
                    >,
                > + Send
                + 'static,
            T: self::ethcontract::web3::Transport<Out = F>
                + self::ethcontract::web3::BatchTransport<Batch = B>
                + Send
                + Sync
                + 'static,
        {
            use self::ethcontract::contract::DeployBuilder;
            use self::ethcontract::dyns::DynTransport;
            use self::ethcontract::web3::api::Web3;
            let transport = DynTransport::new(web3.transport().clone());
            let web3 = Web3::new(transport);
            let bytecode = Self::raw_contract().bytecode.clone();
            DeployBuilder::new(web3, bytecode, (token_contract_address,))
                .expect("valid deployment args")
        }
    }
    impl self::ethcontract::contract::Deploy<self::ethcontract::dyns::DynTransport> for Contract {
        type Context = self::ethcontract::common::Bytecode;
        fn bytecode(cx: &Self::Context) -> &self::ethcontract::common::Bytecode {
            cx
        }
        fn abi(_: &Self::Context) -> &self::ethcontract::common::Abi {
            &Self::raw_contract().abi
        }
        fn from_deployment(
            web3: self::ethcontract::dyns::DynWeb3,
            address: self::ethcontract::Address,
            transaction_hash: self::ethcontract::H256,
            _: Self::Context,
        ) -> Self {
            Self::with_deployment_info(&web3, address, Some(transaction_hash.into()))
        }
    }
    impl Contract {
        #[doc = r" Returns an object that allows accessing typed method signatures."]
        pub fn signatures() -> Signatures {
            Signatures
        }
        #[doc = r" Retrieves a reference to type containing all the generated"]
        #[doc = r" contract methods. This can be used for methods where the name"]
        #[doc = r" would collide with a common method (like `at` or `deployed`)."]
        pub fn methods(&self) -> &Methods {
            &self.methods
        }
    }
    #[doc = r" Type containing signatures for all methods for generated contract type."]
    #[derive(Clone, Copy)]
    pub struct Signatures;
    impl Signatures {
        #[doc = "Returns signature for method `_tokenContractAddress():(address)`."]
        #[allow(clippy::type_complexity)]
        pub fn token_contract_address(
            &self,
        ) -> self::ethcontract::contract::Signature<(), self::ethcontract::Address> {
            self::ethcontract::contract::Signature::new([92, 240, 52, 111])
        }
        #[doc = "Returns signature for method `buyOffersEscrow(address,uint256):(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn buy_offers_escrow(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::Address, self::ethcontract::U256),
            self::ethcontract::U256,
        > {
            self::ethcontract::contract::Signature::new([5, 214, 175, 147])
        }
        #[doc = "Returns signature for method `makeBuyOffer(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn make_buy_offer(
            &self,
        ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256,), ()> {
            self::ethcontract::contract::Signature::new([72, 191, 124, 106])
        }
        #[doc = "Returns signature for method `acceptBuyOffer(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn accept_buy_offer(
            &self,
        ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256,), ()> {
            self::ethcontract::contract::Signature::new([69, 80, 35, 73])
        }
        #[doc = "Returns signature for method `activeBuyOffers(uint256):(address,uint256,uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn active_buy_offers(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::U256,),
            (
                self::ethcontract::Address,
                self::ethcontract::U256,
                self::ethcontract::U256,
            ),
        > {
            self::ethcontract::contract::Signature::new([176, 229, 105, 239])
        }
        #[doc = "Returns signature for method `withdrawBuyOffer(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn withdraw_buy_offer(
            &self,
        ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256,), ()> {
            self::ethcontract::contract::Signature::new([90, 18, 59, 172])
        }
        #[doc = "Returns signature for method `purchase(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn purchase(
            &self,
        ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256,), ()> {
            self::ethcontract::contract::Signature::new([239, 239, 57, 161])
        }
        #[doc = "Returns signature for method `activeSellOffers(uint256):(address,uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn active_sell_offers(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::U256,),
            (self::ethcontract::Address, self::ethcontract::U256),
        > {
            self::ethcontract::contract::Signature::new([3, 197, 86, 73])
        }
        #[doc = "Returns signature for method `makeSellOffer(uint256,uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn make_sell_offer(
            &self,
        ) -> self::ethcontract::contract::Signature<
            (self::ethcontract::U256, self::ethcontract::U256),
            (),
        > {
            self::ethcontract::contract::Signature::new([199, 40, 199, 94])
        }
        #[doc = "Returns signature for method `withdrawSellOffer(uint256)`."]
        #[allow(clippy::type_complexity)]
        pub fn withdraw_sell_offer(
            &self,
        ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256,), ()> {
            self::ethcontract::contract::Signature::new([127, 73, 87, 211])
        }
    }
    #[doc = r" Type containing all contract methods for generated contract type."]
    #[derive(Clone)]
    pub struct Methods {
        instance: self::ethcontract::dyns::DynInstance,
    }
    #[allow(clippy::too_many_arguments, clippy::type_complexity)]
    impl Methods {
        #[doc = "Generated by `ethcontract`"]
        pub fn token_contract_address(
            &self,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::Address> {
            self.instance
                .view_method([92, 240, 52, 111], ())
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn buy_offers_escrow(
            &self,
            p0: self::ethcontract::Address,
            p1: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
            self.instance
                .view_method([5, 214, 175, 147], (p0, p1))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn make_buy_offer(
            &self,
            token_id: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([72, 191, 124, 106], (token_id,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn accept_buy_offer(
            &self,
            token_id: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([69, 80, 35, 73], (token_id,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn active_buy_offers(
            &self,
            p0: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<(
            self::ethcontract::Address,
            self::ethcontract::U256,
            self::ethcontract::U256,
        )> {
            self.instance
                .view_method([176, 229, 105, 239], (p0,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn withdraw_buy_offer(
            &self,
            token_id: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([90, 18, 59, 172], (token_id,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn purchase(
            &self,
            token_id: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([239, 239, 57, 161], (token_id,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn active_sell_offers(
            &self,
            p0: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynViewMethodBuilder<(
            self::ethcontract::Address,
            self::ethcontract::U256,
        )> {
            self.instance
                .view_method([3, 197, 86, 73], (p0,))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn make_sell_offer(
            &self,
            token_id: self::ethcontract::U256,
            min_price: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([199, 40, 199, 94], (token_id, min_price))
                .expect("generated call")
        }
        #[doc = "Generated by `ethcontract`"]
        pub fn withdraw_sell_offer(
            &self,
            token_id: self::ethcontract::U256,
        ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
            self.instance
                .method([127, 73, 87, 211], (token_id,))
                .expect("generated call")
        }
    }
    impl std::ops::Deref for Contract {
        type Target = Methods;
        fn deref(&self) -> &Self::Target {
            &self.methods
        }
    }
    #[doc = r" Module containing all generated data models for this contract's"]
    #[doc = r" events."]
    pub mod event_data {
        use super::ethcontract;
        #[derive(
            Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize,
        )]
        pub struct NewBuyOffer {
            pub token_id: self::ethcontract::U256,
            pub buyer: self::ethcontract::Address,
            pub value: self::ethcontract::U256,
        }
        impl NewBuyOffer {
            #[doc = r" Retrieves the signature for the event this data corresponds to."]
            #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
            #[doc = r" this event."]
            pub fn signature() -> self::ethcontract::H256 {
                self::ethcontract::H256([
                    209, 208, 244, 87, 247, 9, 203, 237, 15, 51, 96, 222, 230, 5, 13, 222, 26, 10,
                    196, 112, 98, 104, 255, 33, 174, 202, 232, 126, 109, 219, 40, 97,
                ])
            }
            #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
            #[doc = r" to. For this event the value should always be:"]
            #[doc = r""]
            #[doc = "`NewBuyOffer(uint256,address,uint256)`"]
            pub fn abi_signature() -> &'static str {
                "NewBuyOffer(uint256,address,uint256)"
            }
        }
        impl self::ethcontract::tokens::Tokenize for NewBuyOffer {
            fn from_token(
                token: self::ethcontract::common::abi::Token,
            ) -> Result<Self, self::ethcontract::tokens::Error> {
                let (token_id, buyer, value) =
                    self::ethcontract::tokens::Tokenize::from_token(token)?;
                Ok(NewBuyOffer {
                    token_id,
                    buyer,
                    value,
                })
            }
            fn into_token(self) -> self::ethcontract::common::abi::Token {
                unimplemented!("events are only decoded, not encoded")
            }
        }
        #[derive(
            Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize,
        )]
        pub struct SellOfferWithdrawn {
            pub token_id: self::ethcontract::U256,
            pub seller: self::ethcontract::Address,
        }
        impl SellOfferWithdrawn {
            #[doc = r" Retrieves the signature for the event this data corresponds to."]
            #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
            #[doc = r" this event."]
            pub fn signature() -> self::ethcontract::H256 {
                self::ethcontract::H256([
                    14, 233, 241, 95, 167, 178, 76, 196, 123, 122, 216, 241, 171, 126, 186, 153,
                    129, 108, 41, 183, 54, 84, 252, 115, 218, 49, 106, 248, 79, 199, 78, 83,
                ])
            }
            #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
            #[doc = r" to. For this event the value should always be:"]
            #[doc = r""]
            #[doc = "`SellOfferWithdrawn(uint256,address)`"]
            pub fn abi_signature() -> &'static str {
                "SellOfferWithdrawn(uint256,address)"
            }
        }
        impl self::ethcontract::tokens::Tokenize for SellOfferWithdrawn {
            fn from_token(
                token: self::ethcontract::common::abi::Token,
            ) -> Result<Self, self::ethcontract::tokens::Error> {
                let (token_id, seller) = self::ethcontract::tokens::Tokenize::from_token(token)?;
                Ok(SellOfferWithdrawn { token_id, seller })
            }
            fn into_token(self) -> self::ethcontract::common::abi::Token {
                unimplemented!("events are only decoded, not encoded")
            }
        }
        #[derive(
            Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize,
        )]
        pub struct RoyaltiesPaid {
            pub token_id: self::ethcontract::U256,
            pub value: self::ethcontract::U256,
        }
        impl RoyaltiesPaid {
            #[doc = r" Retrieves the signature for the event this data corresponds to."]
            #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
            #[doc = r" this event."]
            pub fn signature() -> self::ethcontract::H256 {
                self::ethcontract::H256([
                    230, 26, 242, 38, 156, 154, 251, 219, 105, 239, 206, 43, 21, 242, 164, 100,
                    248, 238, 98, 55, 241, 5, 179, 212, 2, 79, 46, 130, 74, 159, 10, 243,
                ])
            }
            #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
            #[doc = r" to. For this event the value should always be:"]
            #[doc = r""]
            #[doc = "`RoyaltiesPaid(uint256,uint256)`"]
            pub fn abi_signature() -> &'static str {
                "RoyaltiesPaid(uint256,uint256)"
            }
        }
        impl self::ethcontract::tokens::Tokenize for RoyaltiesPaid {
            fn from_token(
                token: self::ethcontract::common::abi::Token,
            ) -> Result<Self, self::ethcontract::tokens::Error> {
                let (token_id, value) = self::ethcontract::tokens::Tokenize::from_token(token)?;
                Ok(RoyaltiesPaid { token_id, value })
            }
            fn into_token(self) -> self::ethcontract::common::abi::Token {
                unimplemented!("events are only decoded, not encoded")
            }
        }
        #[derive(
            Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize,
        )]
        pub struct BuyOfferWithdrawn {
            pub token_id: self::ethcontract::U256,
            pub buyer: self::ethcontract::Address,
        }
        impl BuyOfferWithdrawn {
            #[doc = r" Retrieves the signature for the event this data corresponds to."]
            #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
            #[doc = r" this event."]
            pub fn signature() -> self::ethcontract::H256 {
                self::ethcontract::H256([
                    205, 232, 239, 184, 133, 246, 30, 48, 35, 175, 207, 180, 232, 1, 236, 164, 121,
                    11, 8, 180, 215, 112, 110, 169, 231, 251, 98, 7, 58, 9, 87, 74,
                ])
            }
            #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
            #[doc = r" to. For this event the value should always be:"]
            #[doc = r""]
            #[doc = "`BuyOfferWithdrawn(uint256,address)`"]
            pub fn abi_signature() -> &'static str {
                "BuyOfferWithdrawn(uint256,address)"
            }
        }
        impl self::ethcontract::tokens::Tokenize for BuyOfferWithdrawn {
            fn from_token(
                token: self::ethcontract::common::abi::Token,
            ) -> Result<Self, self::ethcontract::tokens::Error> {
                let (token_id, buyer) = self::ethcontract::tokens::Tokenize::from_token(token)?;
                Ok(BuyOfferWithdrawn { token_id, buyer })
            }
            fn into_token(self) -> self::ethcontract::common::abi::Token {
                unimplemented!("events are only decoded, not encoded")
            }
        }
        #[derive(
            Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize,
        )]
        pub struct NewSellOffer {
            pub token_id: self::ethcontract::U256,
            pub seller: self::ethcontract::Address,
            pub value: self::ethcontract::U256,
        }
        impl NewSellOffer {
            #[doc = r" Retrieves the signature for the event this data corresponds to."]
            #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
            #[doc = r" this event."]
            pub fn signature() -> self::ethcontract::H256 {
                self::ethcontract::H256([
                    254, 187, 118, 190, 24, 115, 223, 59, 86, 232, 102, 163, 76, 124, 44, 82, 79,
                    24, 130, 29, 31, 236, 66, 82, 174, 47, 232, 177, 31, 194, 2, 208,
                ])
            }
            #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
            #[doc = r" to. For this event the value should always be:"]
            #[doc = r""]
            #[doc = "`NewSellOffer(uint256,address,uint256)`"]
            pub fn abi_signature() -> &'static str {
                "NewSellOffer(uint256,address,uint256)"
            }
        }
        impl self::ethcontract::tokens::Tokenize for NewSellOffer {
            fn from_token(
                token: self::ethcontract::common::abi::Token,
            ) -> Result<Self, self::ethcontract::tokens::Error> {
                let (token_id, seller, value) =
                    self::ethcontract::tokens::Tokenize::from_token(token)?;
                Ok(NewSellOffer {
                    token_id,
                    seller,
                    value,
                })
            }
            fn into_token(self) -> self::ethcontract::common::abi::Token {
                unimplemented!("events are only decoded, not encoded")
            }
        }
        #[derive(
            Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize,
        )]
        pub struct Sale {
            pub token_id: self::ethcontract::U256,
            pub seller: self::ethcontract::Address,
            pub buyer: self::ethcontract::Address,
            pub value: self::ethcontract::U256,
        }
        impl Sale {
            #[doc = r" Retrieves the signature for the event this data corresponds to."]
            #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
            #[doc = r" this event."]
            pub fn signature() -> self::ethcontract::H256 {
                self::ethcontract::H256([
                    136, 134, 61, 94, 32, 246, 68, 100, 181, 84, 147, 19, 148, 226, 228, 182, 240,
                    156, 16, 1, 81, 71, 33, 91, 242, 107, 59, 165, 7, 10, 206, 190,
                ])
            }
            #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
            #[doc = r" to. For this event the value should always be:"]
            #[doc = r""]
            #[doc = "`Sale(uint256,address,address,uint256)`"]
            pub fn abi_signature() -> &'static str {
                "Sale(uint256,address,address,uint256)"
            }
        }
        impl self::ethcontract::tokens::Tokenize for Sale {
            fn from_token(
                token: self::ethcontract::common::abi::Token,
            ) -> Result<Self, self::ethcontract::tokens::Error> {
                let (token_id, seller, buyer, value) =
                    self::ethcontract::tokens::Tokenize::from_token(token)?;
                Ok(Sale {
                    token_id,
                    seller,
                    buyer,
                    value,
                })
            }
            fn into_token(self) -> self::ethcontract::common::abi::Token {
                unimplemented!("events are only decoded, not encoded")
            }
        }
    }
    impl Contract {
        #[doc = r" Retrieves a handle to a type containing for creating event"]
        #[doc = r" streams for all the contract events."]
        pub fn events(&self) -> Events<'_> {
            Events {
                instance: self.raw_instance(),
            }
        }
    }
    pub struct Events<'a> {
        instance: &'a self::ethcontract::dyns::DynInstance,
    }
    impl Events<'_> {
        #[doc = r" Generated by `ethcontract`."]
        pub fn new_buy_offer(&self) -> self::event_builders::NewBuyOfferBuilder {
            self::event_builders::NewBuyOfferBuilder(
                self.instance
                    .event(self::ethcontract::H256([
                        209, 208, 244, 87, 247, 9, 203, 237, 15, 51, 96, 222, 230, 5, 13, 222, 26,
                        10, 196, 112, 98, 104, 255, 33, 174, 202, 232, 126, 109, 219, 40, 97,
                    ]))
                    .expect("generated event filter"),
            )
        }
        #[doc = r" Generated by `ethcontract`."]
        pub fn sell_offer_withdrawn(&self) -> self::event_builders::SellOfferWithdrawnBuilder {
            self::event_builders::SellOfferWithdrawnBuilder(
                self.instance
                    .event(self::ethcontract::H256([
                        14, 233, 241, 95, 167, 178, 76, 196, 123, 122, 216, 241, 171, 126, 186,
                        153, 129, 108, 41, 183, 54, 84, 252, 115, 218, 49, 106, 248, 79, 199, 78,
                        83,
                    ]))
                    .expect("generated event filter"),
            )
        }
        #[doc = r" Generated by `ethcontract`."]
        pub fn royalties_paid(&self) -> self::event_builders::RoyaltiesPaidBuilder {
            self::event_builders::RoyaltiesPaidBuilder(
                self.instance
                    .event(self::ethcontract::H256([
                        230, 26, 242, 38, 156, 154, 251, 219, 105, 239, 206, 43, 21, 242, 164, 100,
                        248, 238, 98, 55, 241, 5, 179, 212, 2, 79, 46, 130, 74, 159, 10, 243,
                    ]))
                    .expect("generated event filter"),
            )
        }
        #[doc = r" Generated by `ethcontract`."]
        pub fn buy_offer_withdrawn(&self) -> self::event_builders::BuyOfferWithdrawnBuilder {
            self::event_builders::BuyOfferWithdrawnBuilder(
                self.instance
                    .event(self::ethcontract::H256([
                        205, 232, 239, 184, 133, 246, 30, 48, 35, 175, 207, 180, 232, 1, 236, 164,
                        121, 11, 8, 180, 215, 112, 110, 169, 231, 251, 98, 7, 58, 9, 87, 74,
                    ]))
                    .expect("generated event filter"),
            )
        }
        #[doc = r" Generated by `ethcontract`."]
        pub fn new_sell_offer(&self) -> self::event_builders::NewSellOfferBuilder {
            self::event_builders::NewSellOfferBuilder(
                self.instance
                    .event(self::ethcontract::H256([
                        254, 187, 118, 190, 24, 115, 223, 59, 86, 232, 102, 163, 76, 124, 44, 82,
                        79, 24, 130, 29, 31, 236, 66, 82, 174, 47, 232, 177, 31, 194, 2, 208,
                    ]))
                    .expect("generated event filter"),
            )
        }
        #[doc = r" Generated by `ethcontract`."]
        pub fn sale(&self) -> self::event_builders::SaleBuilder {
            self::event_builders::SaleBuilder(
                self.instance
                    .event(self::ethcontract::H256([
                        136, 134, 61, 94, 32, 246, 68, 100, 181, 84, 147, 19, 148, 226, 228, 182,
                        240, 156, 16, 1, 81, 71, 33, 91, 242, 107, 59, 165, 7, 10, 206, 190,
                    ]))
                    .expect("generated event filter"),
            )
        }
    }
    #[doc = r" Module containing the generated event stream builders with type safe"]
    #[doc = r" filter methods for this contract's events."]
    pub mod event_builders {
        use super::ethcontract;
        use super::event_data;
        #[doc = "A builder for creating a filtered stream of `NewBuyOffer` events."]
        pub struct NewBuyOfferBuilder(
            #[doc = r" The inner event builder."]
            pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::NewBuyOffer>,
        );
        impl NewBuyOfferBuilder {
            #[doc = r" Sets the starting block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the latest block."]
            #[allow(clippy::wrong_self_convention)]
            pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).from_block(block);
                self
            }
            #[doc = r" Sets the last block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the streaming until the end of days."]
            #[allow(clippy::wrong_self_convention)]
            pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).to_block(block);
                self
            }
            #[doc = r" Limits the number of events that can be retrieved by this filter."]
            #[doc = r""]
            #[doc = r" Note that this parameter is non-standard."]
            pub fn limit(mut self, value: usize) -> Self {
                self.0 = (self.0).limit(value);
                self
            }
            #[doc = r" Sets the polling interval. This is used as the interval between"]
            #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
            pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
                self.0 = (self.0).poll_interval(value);
                self
            }
            #[doc = r" Returns a future that resolves with a collection of all existing"]
            #[doc = r" logs matching the builder parameters."]
            pub async fn query(
                self,
            ) -> std::result::Result<
                std::vec::Vec<self::ethcontract::Event<self::event_data::NewBuyOffer>>,
                self::ethcontract::errors::EventError,
            > {
                (self.0).query().await
            }
            #[doc = r" Creates an event stream from the current event builder."]
            pub fn stream(
                self,
            ) -> impl self::ethcontract::futures::stream::Stream<
                Item = std::result::Result<
                    self::ethcontract::StreamEvent<self::event_data::NewBuyOffer>,
                    self::ethcontract::errors::EventError,
                >,
            > {
                (self.0).stream()
            }
        }
        #[doc = "A builder for creating a filtered stream of `SellOfferWithdrawn` events."]
        pub struct SellOfferWithdrawnBuilder(
            #[doc = r" The inner event builder."]
            pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::SellOfferWithdrawn>,
        );
        impl SellOfferWithdrawnBuilder {
            #[doc = r" Sets the starting block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the latest block."]
            #[allow(clippy::wrong_self_convention)]
            pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).from_block(block);
                self
            }
            #[doc = r" Sets the last block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the streaming until the end of days."]
            #[allow(clippy::wrong_self_convention)]
            pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).to_block(block);
                self
            }
            #[doc = r" Limits the number of events that can be retrieved by this filter."]
            #[doc = r""]
            #[doc = r" Note that this parameter is non-standard."]
            pub fn limit(mut self, value: usize) -> Self {
                self.0 = (self.0).limit(value);
                self
            }
            #[doc = r" Sets the polling interval. This is used as the interval between"]
            #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
            pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
                self.0 = (self.0).poll_interval(value);
                self
            }
            #[doc = r" Returns a future that resolves with a collection of all existing"]
            #[doc = r" logs matching the builder parameters."]
            pub async fn query(
                self,
            ) -> std::result::Result<
                std::vec::Vec<self::ethcontract::Event<self::event_data::SellOfferWithdrawn>>,
                self::ethcontract::errors::EventError,
            > {
                (self.0).query().await
            }
            #[doc = r" Creates an event stream from the current event builder."]
            pub fn stream(
                self,
            ) -> impl self::ethcontract::futures::stream::Stream<
                Item = std::result::Result<
                    self::ethcontract::StreamEvent<self::event_data::SellOfferWithdrawn>,
                    self::ethcontract::errors::EventError,
                >,
            > {
                (self.0).stream()
            }
        }
        #[doc = "A builder for creating a filtered stream of `RoyaltiesPaid` events."]
        pub struct RoyaltiesPaidBuilder(
            #[doc = r" The inner event builder."]
            pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::RoyaltiesPaid>,
        );
        impl RoyaltiesPaidBuilder {
            #[doc = r" Sets the starting block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the latest block."]
            #[allow(clippy::wrong_self_convention)]
            pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).from_block(block);
                self
            }
            #[doc = r" Sets the last block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the streaming until the end of days."]
            #[allow(clippy::wrong_self_convention)]
            pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).to_block(block);
                self
            }
            #[doc = r" Limits the number of events that can be retrieved by this filter."]
            #[doc = r""]
            #[doc = r" Note that this parameter is non-standard."]
            pub fn limit(mut self, value: usize) -> Self {
                self.0 = (self.0).limit(value);
                self
            }
            #[doc = r" Sets the polling interval. This is used as the interval between"]
            #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
            pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
                self.0 = (self.0).poll_interval(value);
                self
            }
            #[doc = r" Returns a future that resolves with a collection of all existing"]
            #[doc = r" logs matching the builder parameters."]
            pub async fn query(
                self,
            ) -> std::result::Result<
                std::vec::Vec<self::ethcontract::Event<self::event_data::RoyaltiesPaid>>,
                self::ethcontract::errors::EventError,
            > {
                (self.0).query().await
            }
            #[doc = r" Creates an event stream from the current event builder."]
            pub fn stream(
                self,
            ) -> impl self::ethcontract::futures::stream::Stream<
                Item = std::result::Result<
                    self::ethcontract::StreamEvent<self::event_data::RoyaltiesPaid>,
                    self::ethcontract::errors::EventError,
                >,
            > {
                (self.0).stream()
            }
        }
        #[doc = "A builder for creating a filtered stream of `BuyOfferWithdrawn` events."]
        pub struct BuyOfferWithdrawnBuilder(
            #[doc = r" The inner event builder."]
            pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::BuyOfferWithdrawn>,
        );
        impl BuyOfferWithdrawnBuilder {
            #[doc = r" Sets the starting block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the latest block."]
            #[allow(clippy::wrong_self_convention)]
            pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).from_block(block);
                self
            }
            #[doc = r" Sets the last block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the streaming until the end of days."]
            #[allow(clippy::wrong_self_convention)]
            pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).to_block(block);
                self
            }
            #[doc = r" Limits the number of events that can be retrieved by this filter."]
            #[doc = r""]
            #[doc = r" Note that this parameter is non-standard."]
            pub fn limit(mut self, value: usize) -> Self {
                self.0 = (self.0).limit(value);
                self
            }
            #[doc = r" Sets the polling interval. This is used as the interval between"]
            #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
            pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
                self.0 = (self.0).poll_interval(value);
                self
            }
            #[doc = r" Returns a future that resolves with a collection of all existing"]
            #[doc = r" logs matching the builder parameters."]
            pub async fn query(
                self,
            ) -> std::result::Result<
                std::vec::Vec<self::ethcontract::Event<self::event_data::BuyOfferWithdrawn>>,
                self::ethcontract::errors::EventError,
            > {
                (self.0).query().await
            }
            #[doc = r" Creates an event stream from the current event builder."]
            pub fn stream(
                self,
            ) -> impl self::ethcontract::futures::stream::Stream<
                Item = std::result::Result<
                    self::ethcontract::StreamEvent<self::event_data::BuyOfferWithdrawn>,
                    self::ethcontract::errors::EventError,
                >,
            > {
                (self.0).stream()
            }
        }
        #[doc = "A builder for creating a filtered stream of `NewSellOffer` events."]
        pub struct NewSellOfferBuilder(
            #[doc = r" The inner event builder."]
            pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::NewSellOffer>,
        );
        impl NewSellOfferBuilder {
            #[doc = r" Sets the starting block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the latest block."]
            #[allow(clippy::wrong_self_convention)]
            pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).from_block(block);
                self
            }
            #[doc = r" Sets the last block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the streaming until the end of days."]
            #[allow(clippy::wrong_self_convention)]
            pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).to_block(block);
                self
            }
            #[doc = r" Limits the number of events that can be retrieved by this filter."]
            #[doc = r""]
            #[doc = r" Note that this parameter is non-standard."]
            pub fn limit(mut self, value: usize) -> Self {
                self.0 = (self.0).limit(value);
                self
            }
            #[doc = r" Sets the polling interval. This is used as the interval between"]
            #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
            pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
                self.0 = (self.0).poll_interval(value);
                self
            }
            #[doc = r" Returns a future that resolves with a collection of all existing"]
            #[doc = r" logs matching the builder parameters."]
            pub async fn query(
                self,
            ) -> std::result::Result<
                std::vec::Vec<self::ethcontract::Event<self::event_data::NewSellOffer>>,
                self::ethcontract::errors::EventError,
            > {
                (self.0).query().await
            }
            #[doc = r" Creates an event stream from the current event builder."]
            pub fn stream(
                self,
            ) -> impl self::ethcontract::futures::stream::Stream<
                Item = std::result::Result<
                    self::ethcontract::StreamEvent<self::event_data::NewSellOffer>,
                    self::ethcontract::errors::EventError,
                >,
            > {
                (self.0).stream()
            }
        }
        #[doc = "A builder for creating a filtered stream of `Sale` events."]
        pub struct SaleBuilder(
            #[doc = r" The inner event builder."]
            pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Sale>,
        );
        impl SaleBuilder {
            #[doc = r" Sets the starting block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the latest block."]
            #[allow(clippy::wrong_self_convention)]
            pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).from_block(block);
                self
            }
            #[doc = r" Sets the last block from which to stream logs for."]
            #[doc = r""]
            #[doc = r" If left unset defaults to the streaming until the end of days."]
            #[allow(clippy::wrong_self_convention)]
            pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
                self.0 = (self.0).to_block(block);
                self
            }
            #[doc = r" Limits the number of events that can be retrieved by this filter."]
            #[doc = r""]
            #[doc = r" Note that this parameter is non-standard."]
            pub fn limit(mut self, value: usize) -> Self {
                self.0 = (self.0).limit(value);
                self
            }
            #[doc = r" Sets the polling interval. This is used as the interval between"]
            #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
            pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
                self.0 = (self.0).poll_interval(value);
                self
            }
            #[doc = r" Returns a future that resolves with a collection of all existing"]
            #[doc = r" logs matching the builder parameters."]
            pub async fn query(
                self,
            ) -> std::result::Result<
                std::vec::Vec<self::ethcontract::Event<self::event_data::Sale>>,
                self::ethcontract::errors::EventError,
            > {
                (self.0).query().await
            }
            #[doc = r" Creates an event stream from the current event builder."]
            pub fn stream(
                self,
            ) -> impl self::ethcontract::futures::stream::Stream<
                Item = std::result::Result<
                    self::ethcontract::StreamEvent<self::event_data::Sale>,
                    self::ethcontract::errors::EventError,
                >,
            > {
                (self.0).stream()
            }
        }
    }
    impl Contract {
        #[doc = r" Returns a log stream with all events."]
        pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
            self::ethcontract::dyns::DynAllEventsBuilder::new(
                self.raw_instance().web3(),
                self.address(),
                self.deployment_information(),
            )
        }
    }
    #[doc = r" A contract event."]
    #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub enum Event {
        BuyOfferWithdrawn(self::event_data::BuyOfferWithdrawn),
        NewBuyOffer(self::event_data::NewBuyOffer),
        NewSellOffer(self::event_data::NewSellOffer),
        RoyaltiesPaid(self::event_data::RoyaltiesPaid),
        Sale(self::event_data::Sale),
        SellOfferWithdrawn(self::event_data::SellOfferWithdrawn),
    }
    impl self::ethcontract::contract::ParseLog for Event {
        fn parse_log(
            log: self::ethcontract::RawLog,
        ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
            let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([205 , 232 , 239 , 184 , 133 , 246 , 30 , 48 , 35 , 175 , 207 , 180 , 232 , 1 , 236 , 164 , 121 , 11 , 8 , 180 , 215 , 112 , 110 , 169 , 231 , 251 , 98 , 7 , 58 , 9 , 87 , 74]) => Ok (Event :: BuyOfferWithdrawn (log . clone () . decode (Contract :: raw_contract () . abi . event ("BuyOfferWithdrawn") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([209 , 208 , 244 , 87 , 247 , 9 , 203 , 237 , 15 , 51 , 96 , 222 , 230 , 5 , 13 , 222 , 26 , 10 , 196 , 112 , 98 , 104 , 255 , 33 , 174 , 202 , 232 , 126 , 109 , 219 , 40 , 97]) => Ok (Event :: NewBuyOffer (log . clone () . decode (Contract :: raw_contract () . abi . event ("NewBuyOffer") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([254 , 187 , 118 , 190 , 24 , 115 , 223 , 59 , 86 , 232 , 102 , 163 , 76 , 124 , 44 , 82 , 79 , 24 , 130 , 29 , 31 , 236 , 66 , 82 , 174 , 47 , 232 , 177 , 31 , 194 , 2 , 208]) => Ok (Event :: NewSellOffer (log . clone () . decode (Contract :: raw_contract () . abi . event ("NewSellOffer") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([230 , 26 , 242 , 38 , 156 , 154 , 251 , 219 , 105 , 239 , 206 , 43 , 21 , 242 , 164 , 100 , 248 , 238 , 98 , 55 , 241 , 5 , 179 , 212 , 2 , 79 , 46 , 130 , 74 , 159 , 10 , 243]) => Ok (Event :: RoyaltiesPaid (log . clone () . decode (Contract :: raw_contract () . abi . event ("RoyaltiesPaid") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([136 , 134 , 61 , 94 , 32 , 246 , 68 , 100 , 181 , 84 , 147 , 19 , 148 , 226 , 228 , 182 , 240 , 156 , 16 , 1 , 81 , 71 , 33 , 91 , 242 , 107 , 59 , 165 , 7 , 10 , 206 , 190]) => Ok (Event :: Sale (log . clone () . decode (Contract :: raw_contract () . abi . event ("Sale") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([14 , 233 , 241 , 95 , 167 , 178 , 76 , 196 , 123 , 122 , 216 , 241 , 171 , 126 , 186 , 153 , 129 , 108 , 41 , 183 , 54 , 84 , 252 , 115 , 218 , 49 , 106 , 248 , 79 , 199 , 78 , 83]) => Ok (Event :: SellOfferWithdrawn (log . clone () . decode (Contract :: raw_contract () . abi . event ("SellOfferWithdrawn") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
            if let Some(Ok(data)) = standard_event {
                return Ok(data);
            }
            Err(self::ethcontract::errors::ExecutionError::from(
                self::ethcontract::common::abi::Error::InvalidData,
            ))
        }
    }
}
pub use self::marketplace::Contract as Marketplace;
