#[allow(dead_code)]
pub mod erc1155_upgradeable {
  # [rustfmt :: skip] use ethcontract as ethcontract ;
  #[doc = "Generated by `ethcontract`"]
  #[derive(Clone)]
  pub struct Contract {
    methods: Methods,
  }
  impl Contract {
    #[doc = r" Retrieves the raw contract instance used to generate the type safe"]
    #[doc = r" API for this contract."]
    pub fn raw_contract() -> &'static self::ethcontract::Contract {
      use self::ethcontract::common::artifact::truffle::TruffleLoader;
      use self::ethcontract::private::lazy_static;
      use self::ethcontract::Contract;
      lazy_static! {
        pub static ref CONTRACT: Contract = {
          # [allow (unused_mut)] let mut contract = TruffleLoader :: new () . load_contract_from_str ("{\"contractName\":\"ERC1155Upgradeable\",\"abi\":[{\"type\":\"function\",\"name\":\"setApprovalForAll\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\"},{\"name\":\"approved\",\"type\":\"bool\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"balanceOf\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\"},{\"name\":\"id\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"safeTransferFrom\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\"},{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"id\",\"type\":\"uint256\"},{\"name\":\"amount\",\"type\":\"uint256\"},{\"name\":\"data\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"uri\",\"inputs\":[{\"name\":\"\",\"type\":\"uint256\"}],\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"balanceOfBatch\",\"inputs\":[{\"name\":\"accounts\",\"type\":\"address[]\"},{\"name\":\"ids\",\"type\":\"uint256[]\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint256[]\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"isApprovedForAll\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\"},{\"name\":\"operator\",\"type\":\"address\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"safeBatchTransferFrom\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\"},{\"name\":\"to\",\"type\":\"address\"},{\"name\":\"ids\",\"type\":\"uint256[]\"},{\"name\":\"amounts\",\"type\":\"uint256[]\"},{\"name\":\"data\",\"type\":\"bytes\"}],\"outputs\":[],\"constant\":false,\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"supportsInterface\",\"inputs\":[{\"name\":\"interfaceId\",\"type\":\"bytes4\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\"}],\"constant\":false,\"stateMutability\":\"view\"},{\"type\":\"event\",\"name\":\"URI\",\"inputs\":[{\"name\":\"value\",\"type\":\"string\",\"indexed\":false},{\"name\":\"id\",\"type\":\"uint256\",\"indexed\":true}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"TransferBatch\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\",\"indexed\":true},{\"name\":\"from\",\"type\":\"address\",\"indexed\":true},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true},{\"name\":\"ids\",\"type\":\"uint256[]\",\"indexed\":false},{\"name\":\"values\",\"type\":\"uint256[]\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"ApprovalForAll\",\"inputs\":[{\"name\":\"account\",\"type\":\"address\",\"indexed\":true},{\"name\":\"operator\",\"type\":\"address\",\"indexed\":true},{\"name\":\"approved\",\"type\":\"bool\",\"indexed\":false}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"TransferSingle\",\"inputs\":[{\"name\":\"operator\",\"type\":\"address\",\"indexed\":true},{\"name\":\"from\",\"type\":\"address\",\"indexed\":true},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true},{\"name\":\"id\",\"type\":\"uint256\",\"indexed\":false},{\"name\":\"value\",\"type\":\"uint256\",\"indexed\":false}],\"anonymous\":false}],\"bytecode\":\"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\",\"networks\":{},\"devdoc\":{\"details\":null,\"methods\":{}},\"userdoc\":{\"details\":null,\"methods\":{}}}") . expect ("valid contract JSON") ;
          contract
        };
      }
      &CONTRACT
    }
    #[doc = r" Creates a new contract instance with the specified `web3`"]
    #[doc = r" provider at the given `Address`."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching"]
    #[doc = r" `Abi` is actually deployed at the given address."]
    pub fn at<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      Contract::with_deployment_info(web3, address, None)
    }
    #[doc = r" Creates a new contract instance with the specified `web3` provider with"]
    #[doc = r" the given `Abi` at the given `Address` and an optional transaction hash."]
    #[doc = r" This hash is used to retrieve contract related information such as the"]
    #[doc = r" creation block (which is useful for fetching all historic events)."]
    #[doc = r""]
    #[doc = r" Note that this does not verify that a contract with a matching `Abi` is"]
    #[doc = r" actually deployed at the given address nor that the transaction hash,"]
    #[doc = r" when provided, is actually for this contract deployment."]
    pub fn with_deployment_info<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
      address: self::ethcontract::Address,
      deployment_information: Option<ethcontract::common::DeploymentInformation>,
    ) -> Self
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::transport::DynTransport;
      use self::ethcontract::web3::api::Web3;
      use self::ethcontract::Instance;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let abi = Self::raw_contract().abi.clone();
      let instance = Instance::with_deployment_info(web3, abi, address, deployment_information);
      Contract::from_raw(instance)
    }
    #[doc = r" Creates a contract from a raw instance."]
    fn from_raw(instance: self::ethcontract::dyns::DynInstance) -> Self {
      let methods = Methods { instance };
      Contract { methods }
    }
    #[doc = r" Returns the contract address being used by this instance."]
    pub fn address(&self) -> self::ethcontract::Address {
      self.raw_instance().address()
    }
    #[doc = r" Returns the deployment information of the contract"]
    #[doc = r" if it is known, `None` otherwise."]
    pub fn deployment_information(&self) -> Option<ethcontract::common::DeploymentInformation> {
      self.raw_instance().deployment_information()
    }
    #[doc = r" Returns a reference to the default method options used by this"]
    #[doc = r" contract."]
    pub fn defaults(&self) -> &self::ethcontract::contract::MethodDefaults {
      &self.raw_instance().defaults
    }
    #[doc = r" Returns a mutable reference to the default method options used"]
    #[doc = r" by this contract."]
    pub fn defaults_mut(&mut self) -> &mut self::ethcontract::contract::MethodDefaults {
      &mut self.raw_instance_mut().defaults
    }
    #[doc = r" Returns a reference to the raw runtime instance used by this"]
    #[doc = r" contract."]
    pub fn raw_instance(&self) -> &self::ethcontract::dyns::DynInstance {
      &self.methods.instance
    }
    #[doc = r" Returns a mutable reference to the raw runtime instance used by"]
    #[doc = r" this contract."]
    fn raw_instance_mut(&mut self) -> &mut self::ethcontract::dyns::DynInstance {
      &mut self.methods.instance
    }
  }
  impl std::fmt::Debug for Contract {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
      f.debug_tuple(stringify!(ERC1155Upgradeable))
        .field(&self.address())
        .finish()
    }
  }
  impl Contract {
    #[doc = "Generated by `ethcontract`"]
    #[allow(clippy::too_many_arguments)]
    pub fn builder<F, B, T>(
      web3: &self::ethcontract::web3::api::Web3<T>,
    ) -> self::ethcontract::dyns::DynDeployBuilder<Self>
    where
      F: std::future::Future<
          Output = Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>,
        > + Send
        + 'static,
      B: std::future::Future<
          Output = Result<
            Vec<Result<self::ethcontract::json::Value, self::ethcontract::web3::Error>>,
            self::ethcontract::web3::Error,
          >,
        > + Send
        + 'static,
      T: self::ethcontract::web3::Transport<Out = F>
        + self::ethcontract::web3::BatchTransport<Batch = B>
        + Send
        + Sync
        + 'static,
    {
      use self::ethcontract::contract::DeployBuilder;
      use self::ethcontract::dyns::DynTransport;
      use self::ethcontract::web3::api::Web3;
      let transport = DynTransport::new(web3.transport().clone());
      let web3 = Web3::new(transport);
      let bytecode = Self::raw_contract().bytecode.clone();
      DeployBuilder::new(web3, bytecode, ()).expect("valid deployment args")
    }
  }
  impl self::ethcontract::contract::Deploy<self::ethcontract::dyns::DynTransport> for Contract {
    type Context = self::ethcontract::common::Bytecode;
    fn bytecode(cx: &Self::Context) -> &self::ethcontract::common::Bytecode {
      cx
    }
    fn abi(_: &Self::Context) -> &self::ethcontract::common::Abi {
      &Self::raw_contract().abi
    }
    fn from_deployment(
      web3: self::ethcontract::dyns::DynWeb3,
      address: self::ethcontract::Address,
      transaction_hash: self::ethcontract::H256,
      _: Self::Context,
    ) -> Self {
      Self::with_deployment_info(&web3, address, Some(transaction_hash.into()))
    }
  }
  impl Contract {
    #[doc = r" Returns an object that allows accessing typed method signatures."]
    pub fn signatures() -> Signatures {
      Signatures
    }
    #[doc = r" Retrieves a reference to type containing all the generated"]
    #[doc = r" contract methods. This can be used for methods where the name"]
    #[doc = r" would collide with a common method (like `at` or `deployed`)."]
    pub fn methods(&self) -> &Methods {
      &self.methods
    }
  }
  #[doc = r" Type containing signatures for all methods for generated contract type."]
  #[derive(Clone, Copy)]
  pub struct Signatures;
  impl Signatures {
    #[doc = "Returns signature for method `setApprovalForAll(address,bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn set_approval_for_all(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::Address, bool), ()> {
      self::ethcontract::contract::Signature::new([162, 44, 180, 101])
    }
    #[doc = "Returns signature for method `balanceOf(address,uint256):(uint256)`."]
    #[allow(clippy::type_complexity)]
    pub fn balance_of(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::U256),
      self::ethcontract::U256,
    > {
      self::ethcontract::contract::Signature::new([0, 253, 213, 142])
    }
    #[doc = "Returns signature for method `safeTransferFrom(address,address,uint256,uint256,bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn safe_transfer_from(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        self::ethcontract::U256,
        self::ethcontract::U256,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([242, 66, 67, 42])
    }
    #[doc = "Returns signature for method `uri(uint256):(string)`."]
    #[allow(clippy::type_complexity)]
    pub fn uri(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::U256,), String> {
      self::ethcontract::contract::Signature::new([14, 137, 52, 28])
    }
    #[doc = "Returns signature for method `balanceOfBatch(address[],uint256[]):(uint256[])`."]
    #[allow(clippy::type_complexity)]
    pub fn balance_of_batch(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        Vec<self::ethcontract::Address>,
        Vec<self::ethcontract::U256>,
      ),
      Vec<self::ethcontract::U256>,
    > {
      self::ethcontract::contract::Signature::new([78, 18, 115, 244])
    }
    #[doc = "Returns signature for method `isApprovedForAll(address,address):(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn is_approved_for_all(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (self::ethcontract::Address, self::ethcontract::Address),
      bool,
    > {
      self::ethcontract::contract::Signature::new([233, 133, 233, 197])
    }
    #[doc = "Returns signature for method `safeBatchTransferFrom(address,address,uint256[],uint256[],bytes)`."]
    #[allow(clippy::type_complexity)]
    pub fn safe_batch_transfer_from(
      &self,
    ) -> self::ethcontract::contract::Signature<
      (
        self::ethcontract::Address,
        self::ethcontract::Address,
        Vec<self::ethcontract::U256>,
        Vec<self::ethcontract::U256>,
        self::ethcontract::tokens::Bytes<Vec<u8>>,
      ),
      (),
    > {
      self::ethcontract::contract::Signature::new([46, 178, 194, 214])
    }
    #[doc = "Returns signature for method `supportsInterface(bytes4):(bool)`."]
    #[allow(clippy::type_complexity)]
    pub fn supports_interface(
      &self,
    ) -> self::ethcontract::contract::Signature<(self::ethcontract::tokens::Bytes<[u8; 4]>,), bool>
    {
      self::ethcontract::contract::Signature::new([1, 255, 201, 167])
    }
  }
  #[doc = r" Type containing all contract methods for generated contract type."]
  #[derive(Clone)]
  pub struct Methods {
    instance: self::ethcontract::dyns::DynInstance,
  }
  #[allow(clippy::too_many_arguments, clippy::type_complexity)]
  impl Methods {
    #[doc = "Generated by `ethcontract`"]
    pub fn set_approval_for_all(
      &self,
      operator: self::ethcontract::Address,
      approved: bool,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([162, 44, 180, 101], (operator, approved))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn balance_of(
      &self,
      account: self::ethcontract::Address,
      id: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<self::ethcontract::U256> {
      self
        .instance
        .view_method([0, 253, 213, 142], (account, id))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn safe_transfer_from(
      &self,
      from: self::ethcontract::Address,
      to: self::ethcontract::Address,
      id: self::ethcontract::U256,
      amount: self::ethcontract::U256,
      data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([242, 66, 67, 42], (from, to, id, amount, data))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn uri(
      &self,
      p0: self::ethcontract::U256,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<String> {
      self
        .instance
        .view_method([14, 137, 52, 28], (p0,))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn balance_of_batch(
      &self,
      accounts: Vec<self::ethcontract::Address>,
      ids: Vec<self::ethcontract::U256>,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<Vec<self::ethcontract::U256>> {
      self
        .instance
        .view_method([78, 18, 115, 244], (accounts, ids))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn is_approved_for_all(
      &self,
      account: self::ethcontract::Address,
      operator: self::ethcontract::Address,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([233, 133, 233, 197], (account, operator))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn safe_batch_transfer_from(
      &self,
      from: self::ethcontract::Address,
      to: self::ethcontract::Address,
      ids: Vec<self::ethcontract::U256>,
      amounts: Vec<self::ethcontract::U256>,
      data: self::ethcontract::tokens::Bytes<Vec<u8>>,
    ) -> self::ethcontract::dyns::DynMethodBuilder<()> {
      self
        .instance
        .method([46, 178, 194, 214], (from, to, ids, amounts, data))
        .expect("generated call")
    }
    #[doc = "Generated by `ethcontract`"]
    pub fn supports_interface(
      &self,
      interface_id: self::ethcontract::tokens::Bytes<[u8; 4]>,
    ) -> self::ethcontract::dyns::DynViewMethodBuilder<bool> {
      self
        .instance
        .view_method([1, 255, 201, 167], (interface_id,))
        .expect("generated call")
    }
  }
  impl std::ops::Deref for Contract {
    type Target = Methods;
    fn deref(&self) -> &Self::Target {
      &self.methods
    }
  }
  #[doc = r" Module containing all generated data models for this contract's"]
  #[doc = r" events."]
  pub mod event_data {
    use super::ethcontract;
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct Uri {
      pub value: String,
      pub id: self::ethcontract::U256,
    }
    impl Uri {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          107, 183, 255, 112, 134, 25, 186, 6, 16, 203, 162, 149, 165, 133, 146, 224, 69, 29, 238,
          38, 34, 147, 140, 135, 85, 102, 118, 136, 218, 243, 82, 155,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`URI(string,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "URI(string,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for Uri {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (value, id) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(Uri { value, id })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct TransferBatch {
      pub operator: self::ethcontract::Address,
      pub from: self::ethcontract::Address,
      pub to: self::ethcontract::Address,
      pub ids: Vec<self::ethcontract::U256>,
      pub values: Vec<self::ethcontract::U256>,
    }
    impl TransferBatch {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          74, 57, 220, 6, 212, 192, 219, 198, 75, 112, 175, 144, 253, 105, 138, 35, 58, 81, 138,
          165, 208, 126, 89, 93, 152, 59, 140, 5, 38, 200, 247, 251,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`TransferBatch(address,address,address,uint256[],uint256[])`"]
      pub fn abi_signature() -> &'static str {
        "TransferBatch(address,address,address,uint256[],uint256[])"
      }
    }
    impl self::ethcontract::tokens::Tokenize for TransferBatch {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (operator, from, to, ids, values) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(TransferBatch {
          operator,
          from,
          to,
          ids,
          values,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct ApprovalForAll {
      pub account: self::ethcontract::Address,
      pub operator: self::ethcontract::Address,
      pub approved: bool,
    }
    impl ApprovalForAll {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          23, 48, 126, 171, 57, 171, 97, 7, 232, 137, 152, 69, 173, 61, 89, 189, 150, 83, 242, 0,
          242, 32, 146, 4, 137, 202, 43, 89, 55, 105, 108, 49,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`ApprovalForAll(address,address,bool)`"]
      pub fn abi_signature() -> &'static str {
        "ApprovalForAll(address,address,bool)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for ApprovalForAll {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (account, operator, approved) = self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(ApprovalForAll {
          account,
          operator,
          approved,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
    #[derive(Clone, Debug, Default, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
    pub struct TransferSingle {
      pub operator: self::ethcontract::Address,
      pub from: self::ethcontract::Address,
      pub to: self::ethcontract::Address,
      pub id: self::ethcontract::U256,
      pub value: self::ethcontract::U256,
    }
    impl TransferSingle {
      #[doc = r" Retrieves the signature for the event this data corresponds to."]
      #[doc = r" This signature is the Keccak-256 hash of the ABI signature of"]
      #[doc = r" this event."]
      pub fn signature() -> self::ethcontract::H256 {
        self::ethcontract::H256([
          195, 213, 129, 104, 197, 174, 115, 151, 115, 29, 6, 61, 91, 191, 61, 101, 120, 84, 66,
          115, 67, 244, 192, 131, 36, 15, 122, 172, 170, 45, 15, 98,
        ])
      }
      #[doc = r" Retrieves the ABI signature for the event this data corresponds"]
      #[doc = r" to. For this event the value should always be:"]
      #[doc = r""]
      #[doc = "`TransferSingle(address,address,address,uint256,uint256)`"]
      pub fn abi_signature() -> &'static str {
        "TransferSingle(address,address,address,uint256,uint256)"
      }
    }
    impl self::ethcontract::tokens::Tokenize for TransferSingle {
      fn from_token(
        token: self::ethcontract::common::abi::Token,
      ) -> Result<Self, self::ethcontract::tokens::Error> {
        let (operator, from, to, id, value) =
          self::ethcontract::tokens::Tokenize::from_token(token)?;
        Ok(TransferSingle {
          operator,
          from,
          to,
          id,
          value,
        })
      }
      fn into_token(self) -> self::ethcontract::common::abi::Token {
        unimplemented!("events are only decoded, not encoded")
      }
    }
  }
  impl Contract {
    #[doc = r" Retrieves a handle to a type containing for creating event"]
    #[doc = r" streams for all the contract events."]
    pub fn events(&self) -> Events<'_> {
      Events {
        instance: self.raw_instance(),
      }
    }
  }
  pub struct Events<'a> {
    instance: &'a self::ethcontract::dyns::DynInstance,
  }
  impl Events<'_> {
    #[doc = r" Generated by `ethcontract`."]
    pub fn uri(&self) -> self::event_builders::UriBuilder {
      self::event_builders::UriBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            107, 183, 255, 112, 134, 25, 186, 6, 16, 203, 162, 149, 165, 133, 146, 224, 69, 29,
            238, 38, 34, 147, 140, 135, 85, 102, 118, 136, 218, 243, 82, 155,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn transfer_batch(&self) -> self::event_builders::TransferBatchBuilder {
      self::event_builders::TransferBatchBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            74, 57, 220, 6, 212, 192, 219, 198, 75, 112, 175, 144, 253, 105, 138, 35, 58, 81, 138,
            165, 208, 126, 89, 93, 152, 59, 140, 5, 38, 200, 247, 251,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn approval_for_all(&self) -> self::event_builders::ApprovalForAllBuilder {
      self::event_builders::ApprovalForAllBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            23, 48, 126, 171, 57, 171, 97, 7, 232, 137, 152, 69, 173, 61, 89, 189, 150, 83, 242, 0,
            242, 32, 146, 4, 137, 202, 43, 89, 55, 105, 108, 49,
          ]))
          .expect("generated event filter"),
      )
    }
    #[doc = r" Generated by `ethcontract`."]
    pub fn transfer_single(&self) -> self::event_builders::TransferSingleBuilder {
      self::event_builders::TransferSingleBuilder(
        self
          .instance
          .event(self::ethcontract::H256([
            195, 213, 129, 104, 197, 174, 115, 151, 115, 29, 6, 61, 91, 191, 61, 101, 120, 84, 66,
            115, 67, 244, 192, 131, 36, 15, 122, 172, 170, 45, 15, 98,
          ]))
          .expect("generated event filter"),
      )
    }
  }
  #[doc = r" Module containing the generated event stream builders with type safe"]
  #[doc = r" filter methods for this contract's events."]
  pub mod event_builders {
    use super::ethcontract;
    use super::event_data;
    #[doc = "A builder for creating a filtered stream of `Uri` events."]
    pub struct UriBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::Uri>,
    );
    impl UriBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the id event parameter."]
      pub fn id(mut self, topic: self::ethcontract::Topic<self::ethcontract::U256>) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::Uri>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::Uri>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `TransferBatch` events."]
    pub struct TransferBatchBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::TransferBatch>,
    );
    impl TransferBatchBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the from event parameter."]
      pub fn from(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the to event parameter."]
      pub fn to(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::TransferBatch>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::TransferBatch>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `ApprovalForAll` events."]
    pub struct ApprovalForAllBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::ApprovalForAll>,
    );
    impl ApprovalForAllBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the account event parameter."]
      pub fn account(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::ApprovalForAll>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::ApprovalForAll>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
    #[doc = "A builder for creating a filtered stream of `TransferSingle` events."]
    pub struct TransferSingleBuilder(
      #[doc = r" The inner event builder."]
      pub  self::ethcontract::dyns::DynEventBuilder<self::event_data::TransferSingle>,
    );
    impl TransferSingleBuilder {
      #[doc = r" Sets the starting block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the latest block."]
      #[allow(clippy::wrong_self_convention)]
      pub fn from_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).from_block(block);
        self
      }
      #[doc = r" Sets the last block from which to stream logs for."]
      #[doc = r""]
      #[doc = r" If left unset defaults to the streaming until the end of days."]
      #[allow(clippy::wrong_self_convention)]
      pub fn to_block(mut self, block: self::ethcontract::BlockNumber) -> Self {
        self.0 = (self.0).to_block(block);
        self
      }
      #[doc = r" Limits the number of events that can be retrieved by this filter."]
      #[doc = r""]
      #[doc = r" Note that this parameter is non-standard."]
      pub fn limit(mut self, value: usize) -> Self {
        self.0 = (self.0).limit(value);
        self
      }
      #[doc = r" Sets the polling interval. This is used as the interval between"]
      #[doc = r" consecutive `eth_getFilterChanges` calls to get filter updates."]
      pub fn poll_interval(mut self, value: std::time::Duration) -> Self {
        self.0 = (self.0).poll_interval(value);
        self
      }
      #[doc = "Adds a filter for the operator event parameter."]
      pub fn operator(
        mut self,
        topic: self::ethcontract::Topic<self::ethcontract::Address>,
      ) -> Self {
        self.0 = (self.0).topic0(topic);
        self
      }
      #[doc = "Adds a filter for the from event parameter."]
      pub fn from(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic1(topic);
        self
      }
      #[doc = "Adds a filter for the to event parameter."]
      pub fn to(mut self, topic: self::ethcontract::Topic<self::ethcontract::Address>) -> Self {
        self.0 = (self.0).topic2(topic);
        self
      }
      #[doc = r" Returns a future that resolves with a collection of all existing"]
      #[doc = r" logs matching the builder parameters."]
      pub async fn query(
        self,
      ) -> std::result::Result<
        std::vec::Vec<self::ethcontract::Event<self::event_data::TransferSingle>>,
        self::ethcontract::errors::EventError,
      > {
        (self.0).query().await
      }
      #[doc = r" Creates an event stream from the current event builder."]
      pub fn stream(
        self,
      ) -> impl self::ethcontract::futures::stream::Stream<
        Item = std::result::Result<
          self::ethcontract::StreamEvent<self::event_data::TransferSingle>,
          self::ethcontract::errors::EventError,
        >,
      > {
        (self.0).stream()
      }
    }
  }
  impl Contract {
    #[doc = r" Returns a log stream with all events."]
    pub fn all_events(&self) -> self::ethcontract::dyns::DynAllEventsBuilder<Event> {
      self::ethcontract::dyns::DynAllEventsBuilder::new(
        self.raw_instance().web3(),
        self.address(),
        self.deployment_information(),
      )
    }
  }
  #[doc = r" A contract event."]
  #[derive(Clone, Debug, Eq, PartialEq, serde :: Deserialize, serde :: Serialize)]
  pub enum Event {
    ApprovalForAll(self::event_data::ApprovalForAll),
    TransferBatch(self::event_data::TransferBatch),
    TransferSingle(self::event_data::TransferSingle),
    Uri(self::event_data::Uri),
  }
  impl self::ethcontract::contract::ParseLog for Event {
    fn parse_log(
      log: self::ethcontract::RawLog,
    ) -> Result<Self, self::ethcontract::errors::ExecutionError> {
      let standard_event = log . topics . get (0) . copied () . map (| topic | match topic { self :: ethcontract :: H256 ([23 , 48 , 126 , 171 , 57 , 171 , 97 , 7 , 232 , 137 , 152 , 69 , 173 , 61 , 89 , 189 , 150 , 83 , 242 , 0 , 242 , 32 , 146 , 4 , 137 , 202 , 43 , 89 , 55 , 105 , 108 , 49]) => Ok (Event :: ApprovalForAll (log . clone () . decode (Contract :: raw_contract () . abi . event ("ApprovalForAll") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([74 , 57 , 220 , 6 , 212 , 192 , 219 , 198 , 75 , 112 , 175 , 144 , 253 , 105 , 138 , 35 , 58 , 81 , 138 , 165 , 208 , 126 , 89 , 93 , 152 , 59 , 140 , 5 , 38 , 200 , 247 , 251]) => Ok (Event :: TransferBatch (log . clone () . decode (Contract :: raw_contract () . abi . event ("TransferBatch") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([195 , 213 , 129 , 104 , 197 , 174 , 115 , 151 , 115 , 29 , 6 , 61 , 91 , 191 , 61 , 101 , 120 , 84 , 66 , 115 , 67 , 244 , 192 , 131 , 36 , 15 , 122 , 172 , 170 , 45 , 15 , 98]) => Ok (Event :: TransferSingle (log . clone () . decode (Contract :: raw_contract () . abi . event ("TransferSingle") . expect ("generated event decode")) ?)) , self :: ethcontract :: H256 ([107 , 183 , 255 , 112 , 134 , 25 , 186 , 6 , 16 , 203 , 162 , 149 , 165 , 133 , 146 , 224 , 69 , 29 , 238 , 38 , 34 , 147 , 140 , 135 , 85 , 102 , 118 , 136 , 218 , 243 , 82 , 155]) => Ok (Event :: Uri (log . clone () . decode (Contract :: raw_contract () . abi . event ("URI") . expect ("generated event decode")) ?)) , _ => Err (self :: ethcontract :: errors :: ExecutionError :: from (self :: ethcontract :: common :: abi :: Error :: InvalidData)) , }) ;
      if let Some(Ok(data)) = standard_event {
        return Ok(data);
      }
      Err(self::ethcontract::errors::ExecutionError::from(
        self::ethcontract::common::abi::Error::InvalidData,
      ))
    }
  }
}
pub use self::erc1155_upgradeable::Contract as ERC1155Upgradeable;
