use crate::{parse, parse_and_get_csv};

#[test]
fn operating_point_sample_real() {
    let file = "Title: basic r circuit
Date: Sat Dec 25 20:36:08  2021
Plotname: Operating Point
Flags: real
No. Variables: 3
No. Points: 1
Variables:
    0	v(a)	voltage
    1	v(b)	voltage
    2	i(v1)	current
Values:
 0	1.000000000000000e+02
    3.000000000000000e+01
    -1.000000000000000e+00
        
";
    println!("{:#?}", parse(file).unwrap());
}

#[test]
fn ac_analysis_sample_complex() {
    let file = "Title: rc circuit frequency response
Date: Sat Dec 25 20:19:58  2021
Plotname: AC Analysis
Flags: complex
No. Variables: 4
No. Points: 10
Variables:
    0	frequency	frequency grid=3
    1	v(1)	voltage
    2	v(2)	voltage
    3	i(vin)	current
Values:
 0	1.000000000000000e+00,0.000000000000000e+00
    2.000000000000000e+00,0.000000000000000e+00
    1.999921046281759e+00,-1.256587453351677e-02
    -7.895371824124392e-08,-1.256587453351677e-05

 1	1.258925411794167e+00,0.000000000000000e+00
    2.000000000000000e+00,0.000000000000000e+00
    1.999874869678668e+00,-1.581913351188419e-02
    -1.251303213319760e-07,-1.581913351188419e-05

 2	1.584893192461114e+00,0.000000000000000e+00
    2.000000000000000e+00,0.000000000000000e+00
    1.999801689062528e+00,-1.991438042510184e-02
    -1.983109374718156e-07,-1.991438042510184e-05

 3	1.995262314968880e+00,0.000000000000000e+00
    2.000000000000000e+00,0.000000000000000e+00
    1.999685716572190e+00,-2.506926567624283e-02
    -3.142834278093906e-07,-2.506926567624283e-05

 4	2.511886431509581e+00,0.000000000000000e+00
    2.000000000000000e+00,0.000000000000000e+00
    1.999501940112003e+00,-3.155743513567430e-02
    -4.980598879971571e-07,-3.155743513567430e-05

 5	3.162277660168380e+00,0.000000000000000e+00
    2.000000000000000e+00,0.000000000000000e+00
    1.999210743233995e+00,-3.972267118117190e-02
    -7.892567660053307e-07,-3.972267118117190e-05

 6	3.981071705534974e+00,0.000000000000000e+00
    2.000000000000000e+00,0.000000000000000e+00
    1.998749400982035e+00,-4.999634024631034e-02
    -1.250599017964520e-06,-4.999634024631034e-05

 7	5.011872336272725e+00,0.000000000000000e+00
    2.000000000000000e+00,0.000000000000000e+00
    1.998018658772645e+00,-6.291865177870989e-02
    -1.981341227354390e-06,-6.291865177870990e-05

 8	6.309573444801935e+00,0.000000000000000e+00
    2.000000000000000e+00,0.000000000000000e+00
    1.996861604277849e+00,-7.916401907807098e-02
    -3.138395722150980e-06,-7.916401907807098e-05

 9	7.943282347242818e+00,0.000000000000000e+00
    2.000000000000000e+00,0.000000000000000e+00
    1.995030539021331e+00,-9.957020847080085e-02
    -4.969460978668499e-06,-9.957020847080085e-05

";
    println!("{:#?}", parse(file).unwrap());
    println!("{}", parse_and_get_csv(file).unwrap());
}
